# **COPYRIGHT*******************************************************************
#    INTEL CONFIDENTIAL
#    Copyright (C) 2017 Intel Corporation
# *******************************************************************COPYRIGHT**
# **DISCLAIMER******************************************************************
#    The source code contained or described herein and all documents related
#    to the source code ("Material") are owned by Intel Corporation or its
#    suppliers or licensors. Title to the Material remains with Intel
#    Corporation or its suppliers and licensors. The Material may contain
#    trade secrets and proprietary and confidential information of Intel
#    Corporation and its suppliers and licensors, and is protected by
#    worldwide copyright and trade secret laws and treaty provisions. No part
#    of the Material may be used, copied, reproduced, modified, published,
#    uploaded, posted, transmitted, distributed, or disclosed in any way
#    without Intel's prior express written permission.
#
#    No license under any patent, copyright, trade secret or other
#    intellectual property right is granted to or conferred upon you by
#    disclosure or delivery of the Materials, either expressly, by
#    implication, inducement, estoppel or otherwise. Any license under
#    such intellectual property rights must be express and approved by
#    Intel in writing.
# ******************************************************************DISCLAIMER**
    $USAGE = "Synopsis: perl timestamp.pl input_file output_file\n";


    if ($#ARGV != 1)
    {
        print "$#ARGV \n";
    	die($USAGE);
    }
    
    $infile = @ARGV[0];
    $outfile = @ARGV[1];

    open(INFILE, "<$infile") || die "cannot open input file $infile\n";
    open (OUTFILE, ">$outfile") || die "cannot open output file $output\n";

    ($second, $minute, $hour, $day, $mon, $year, $dummy1, $dummy2, $dummy3) = localtime(time);
    $year += 1900;
    $mon++;

    while(<INFILE>)
    {
        if (/^\s*BYTE\(DAY\)/i)
        {
            $_ =~ s/DAY/$day/i;
        }
        elsif  (/^\s*BYTE\(MONTH\)/i)
        {
            $_ =~ s/MONTH/$mon/i;
        }
        elsif  (/^\s*BYTE\(MINUTE\)/i)
        {
            $_ =~ s/MINUTE/$minute/i;
        }
        elsif  (/^\s*BYTE\(HOUR\)/i)
        {
            $_ =~ s/HOUR/$hour/i;
        }
        elsif  (/^\s*LONG\(YEAR\)/i)
        {
            $_ =~ s/YEAR/$year/i;
        }
        print (OUTFILE $_);
    }

    close(INFILE);
    close(OUTFILE);

