# **COPYRIGHT*******************************************************************
#    INTEL CONFIDENTIAL
#    Copyright (C) 2017 Intel Corporation
# *******************************************************************COPYRIGHT**
# **DISCLAIMER******************************************************************
#    The source code contained or described herein and all documents related
#    to the source code ("Material") are owned by Intel Corporation or its
#    suppliers or licensors. Title to the Material remains with Intel
#    Corporation or its suppliers and licensors. The Material may contain
#    trade secrets and proprietary and confidential information of Intel
#    Corporation and its suppliers and licensors, and is protected by
#    worldwide copyright and trade secret laws and treaty provisions. No part
#    of the Material may be used, copied, reproduced, modified, published,
#    uploaded, posted, transmitted, distributed, or disclosed in any way
#    without Intel's prior express written permission.
#
#    No license under any patent, copyright, trade secret or other
#    intellectual property right is granted to or conferred upon you by
#    disclosure or delivery of the Materials, either expressly, by
#    implication, inducement, estoppel or otherwise. Any license under
#    such intellectual property rights must be express and approved by
#    Intel in writing.
# ******************************************************************DISCLAIMER**

    $USAGE = " Usage: \n".
             "perl update_uflags.pl\n".
             "\tuser_flag_dir_name\n".
             "\tuflag_outfile\n";
    
    if ($#ARGV != 1)
    {
    	die("$USAGE");
    }

    $user_flag_dir = @ARGV[0];
    $user_flag_outfile = "@ARGV[0]/@ARGV[1]";
    
    opendir(UFLAG_DIR, "$user_flag_dir");
    @all_uf_files = readdir(UFLAG_DIR);

    open(UFLAG_OUT, ">$user_flag_outfile") || die "Failed to open $user_flag_outfile\n";

    foreach $file (@all_uf_files)
    {
        if (($uf_file = $file) =~ m%(\w+)\.uf%)
        {
            print UFLAG_OUT "$1_uf = $file\n";
            print UFLAG_OUT "\@$1_uf = \@${user_flag_dir}/$file\n";
        }
    }

    close(UFLAG_OUT);
