######                                                ######
###### BEWARE THAT THIS FILE IS CASE SENSITIVE !!!    ######
######                                                ######



#  This makefile will read in supporting makefiles (namedly *.src, *.rls):
#      *.src contains definitions of subproject_SRC, subproject_C_RLS,
#  subproject_ASM_RLS, VPATH_FOR_C, and VPATH_FOR_ASM.
#
#  These variables are used by makefile to set up search paths and object file
#  compilation rules.
#
#  The hcarc compiler will use its own search paths which are provided thru
#  *.inc files.


############################################################
###          USER MODIFIABLE ENVIRONMENTS                ###
############################################################

MAKE                    = ../arc_bld_62/gmake_3.80.exe
MAKE_FILE               = ../arc_bld_62/vdsl_modem.mak
MAKE_INPUTS             = make_inputs
COMMON_MAKE_INPUTS      = ../arc_bld_62/make_inputs
PERL_DIR                = ../arc_bld_62/perl
MAP_DIR                 = map
ARC_SRC_INC_DIR         = ../arc_src/include
SOURCE_PLATFORM_INC_DIR = ../Source/Vdsl_Platform/include
UFLAGS_LIST             = uflags.dep
SOURCE_TIMESTAMPS       = source_timestamps.txt



ITUX_OPT               = VDSL_CPE
ITUX                   = vcpe
EXTRACT_SCRIPT         = ../arc_bld_62/ExtractVdslImage.sc


PLATFORM_VER =
PLATFORM_DOT_VER =
PLATFORM_TYPE =

MULT_TASK_VER = _50
MULT_TASK_DOT_VER = _5.0
MULT_TASK_CO_VER =
MULT_TASK_CPE_VER =

ENGINE_LIB_VER = _50
ENGINE_LIB_DOT_VER = _5.0

HWEXEC_VER = _50
HWEXEC_DOT_VER = _5.0

SIMTEST_VER =
SIMTEST_DOT_VER =

CODESWAP_SRC_VER =
MEMFILE_VER = _50

CONFIG_NAME = $(ITUX)

BUILD_DIR =

#For HW 6.2 Build
ifneq (,$(findstring VDSL_62, $(EXTRA_COMPILER_OPTIONS)))
    PLATFORM_VER = _62
    MULT_TASK_VER =
    MULT_TASK_DOT_VER = _62
    MULT_TASK_CPE_VER =_62
    ENGINE_LIB_VER = _62
    ENGINE_LIB_DOT_VER =
    HWEXEC_VER = _62
    CODESWAP_SRC_VER = _62
    MEMFILE_VER = _62
# do not redefine CONFIG_NAME for this build
#    CONFIG_NAME = $(ITUX)$(PLATFORM_VER)

    SIMTEST_VER = _62
    SIMTEST_DOT_VER = _62
    BUILD_DIR = _62
    EXTRACT_SCRIPT         = ./ExtractVdslImage_62.sc
endif

ifneq (,$(findstring VRX318, $(EXTRA_COMPILER_OPTIONS)))
    PLATFORM_TYPE = VRX318_
endif

ifneq (,$(findstring VRX518, $(EXTRA_COMPILER_OPTIONS)))
    PLATFORM_TYPE = VRX518_
endif

OBJ_DIR                = obj/$(ITUX)
ASM_DIR                = asm/$(ITUX)
RLS_DIR                = make_rls/$(ITUX)
UFLAGS_DIR             = make_uflags/$(ITUX)


CODESWAP_SOURCE        = CodeSwap_Source_$(ITUX)$(CODESWAP_SRC_VER)


CODESWAP_SRC_DIR       = ../arc_src/$(CODESWAP_SOURCE)


ifeq ($(TARGET_OPT),TARGET_SIM)
    TARGET                 = asim
endif

ifeq ($(TARGET_OPT),TARGET_HW)
    TARGET                 = hw
endif

ifeq ($(TARGET_OPT),TARGET_ARC)
    TARGET                 = arc
endif


CODESWAP_CMD_FILE      = $(ITUX)_$(TARGET).cmd
CUSTOMER_CMD_FILE      = $(ITUX)_customer.cmd
OUT_FILE               = $(ITUX)_$(TARGET).out
ARCHIVE_FILE           = $(ITUX)_$(TARGET).a
BIN_FILE               = $(ITUX)_$(TARGET).bin
CODESWAP_CMD_INFILE    = $(COMMON_MAKE_INPUTS)/$(ITUX)_inputs.cmd

POST_PROCESS_IMAGE     =

# list of files included by CODESWAP_CMD_INFILE
CUSTOMER_CMD_INFILE    = $(COMMON_MAKE_INPUTS)/$(ITUX)_$(CUSTOMER_BLD).cmd


ifneq (,$(findstring VDSL_62, $(EXTRA_COMPILER_OPTIONS)))
    LOADER_BIN = loader_62.bin
    LOADER_OBJ_DIR = obj/loader_62
    POST_PROCESS_IMAGE = build_VdslOnly_Image.bat
else
    LOADER_BIN =
    LOADER_OBJ_DIR =
endif

ifneq (,$(findstring VRX518, $(EXTRA_COMPILER_OPTIONS)))
    LOADER_BIN = loader_VRx518.bin
    LOADER_OBJ_DIR = obj/loader_62
    POST_PROCESS_IMAGE = build_VdslOnly_Image.bat VRX518
endif

MEM_FILE = $(PLATFORM_TYPE)$(ITUX_OPT)$(MEMFILE_VER).mem $(LOADER_BIN)


CC_EXE = hcac.exe
LD_EXE = hcac.exe
AR_EXE = arac.exe
AS_EXE = hcac.exe
SIM_EXE = scac.exe

ifeq (,$(ARCDIR))
    CC = $(CC_EXE)
    LD = $(LD_EXE)
    AR = $(AR_EXE)
    AS = $(AS_EXE)
    SIM = $(SIM_EXE)
else
    CC = $(ARCDIR)/MetaWare/arc/bin/$(CC_EXE)
    LD = $(ARCDIR)/MetaWare/arc/bin/$(LD_EXE)
    AR = $(ARCDIR)/MetaWare/arc/bin/$(AR_EXE)
    AS = $(ARCDIR)/MetaWare/arc/bin/$(AS_EXE)
    SIM = $(ARCDIR)/MetaWare/arc/bin/$(SIM_EXE)
endif

CRTFLAGS      = -Hnocrt
LD_LIST_FLAGS = -Hldopt=-Ccrossref
LD_MAP_FLAGS  = -Hldopt=-Cout=$(MAP_DIR)/$(notdir $*).map -Hldopt=-Cpage=0
# note that EXTRA_COMPILER_OPTIONS is used to pass more build option from .bat files
CFLAGS        = -D$(ARC_OPT) $(EXTRA_COMPILER_OPTIONS) -g1 @$(MAKE_INPUTS)/cflags.rsp @$(MAKE_INPUTS)/defines.rsp -D$(TARGET_OPT) -D$(ITUX_OPT)

# put each function in own section so linker can eliminate all unused functions
CFLAGS += -Hon=Each_function_in_own_section

# stop build on compiler warnings
CFLAGS += -Hretwc

ASFLAGS       = -Hasmcpp $(CFLAGS)
LDFLAGS       = @$(MAKE_INPUTS)/ldflags.rsp $(CRTFLAGS) $(LD_LIST_FLAGS) $(LD_MAP_FLAGS)

# Eliminate all unused functions
LDFLAGS += -zpurgetext

ARFLAGS       = -c

CC_COMMAND = $(CC)  $(CFLAGS)
AS_COMMAND = $(AS) $(ASFLAGS)
AS_RLS_COMMAND = $(AS) $(ASFLAGS)

# the following sub-projects are retrieved from the Cocomo sub-projects.

AUTO_SUB_PROJECTS = \
                    MultTask$(MULT_TASK_DOT_VER) \
                    HWExec$(HWEXEC_VER) \
                    HWEngineLib$(ENGINE_LIB_VER) \

ifeq ($(ITUX_OPT),VDSL_CO)
    AUTO_SUB_PROJECTS += Multtask_VDSL_CO$(MULT_TASK_CO_VER)
else
    AUTO_SUB_PROJECTS += Multtask_VDSL_CPE$(MULT_TASK_CPE_VER)
endif

ifeq ($(TARGET_OPT),TARGET_SIM)
    INCLUDE_SIMTEST = TRUE
endif

ifeq ($(TARGET_OPT),TARGET_ARC)
    INCLUDE_SIMTEST = TRUE
endif


ifeq ($(INCLUDE_SIMTEST),TRUE)
    AUTO_SUB_PROJECTS += SimTest_VDSL$(SIMTEST_DOT_VER)
endif

# note that Platform MUST be the first one in the list
# so that arc source directories are searched first.


MANUAL_SUB_PROJECTS = \
                      Platform$(PLATFORM_VER) \


CODESWAP_SUB_PROJECT = CodeSwap_Source_$(ITUX)$(CODESWAP_SRC_VER)

CUSTOMER_SUB_PROJECTS = \
                      $(CUSTOMER_BLD) \

NON_CODESWAP_SUB_PROJECTS = $(MANUAL_SUB_PROJECTS) $(AUTO_SUB_PROJECTS) $(CUSTOMER_SUB_PROJECTS)

ALL_SUB_PROJECTS = $(MANUAL_SUB_PROJECTS) $(CODESWAP_SUB_PROJECT) $(AUTO_SUB_PROJECTS)  $(CUSTOMER_SUB_PROJECT)

VPATH_FOR_DSP = \
                ../build$(BUILD_DIR)/MultMode$(MULT_TASK_VER)/modem \
                ../build$(BUILD_DIR)/MultMode/modem \
                ../build$(BUILD_DIR)/VDSL/modem \
                ../build$(BUILD_DIR)/HWEngineLib$(ENGINE_LIB_DOT_VER) \

############################################################
###                AUTOMATED ENVIRONMENTS                ###
############################################################


AUTO_SUB_PROJ_SRC_FILES = $(AUTO_SUB_PROJECTS:%=$(MAKE_INPUTS)/%.src)
AUTO_SUB_PROJ_INC_FILES = $(AUTO_SUB_PROJECTS:%=$(MAKE_INPUTS)/%.inc)


MANUAL_SUB_PROJ_SRC_FILES = $(MANUAL_SUB_PROJECTS:%=$(MAKE_INPUTS)/%.src)
CUSTOMER_SUB_PROJ_SRC_FILES = $(CUSTOMER_SUB_PROJECTS:%=$(COMMON_MAKE_INPUTS)/%.src)

# note that MANUAL_SUB_PROJECTS has to be the first one in the list
# so that arc source directories are searched first.
NON_CODESWAP_SRC_FILES = $(MANUAL_SUB_PROJ_SRC_FILES) \
                         $(AUTO_SUB_PROJ_SRC_FILES) \
                         $(CUSTOMER_SUB_PROJ_SRC_FILES)

NON_CODESWAP_INC_PATHS = $(NON_CODESWAP_SRC_FILES:%.src=@%.inc)

CODESWAP_SRC_FILES = $(CODESWAP_SUB_PROJECT:%=$(MAKE_INPUTS)/%.src) \

CODESWAP_INC_PATHS = $(CODESWAP_SRC_FILES:%.src=@%.inc)

ALL_SRC_FILES = $(CODESWAP_SRC_FILES) $(NON_CODESWAP_SRC_FILES)

-include $(ALL_SRC_FILES)

NON_CODESWAP_SOURCES       = $(foreach name,$(NON_CODESWAP_SUB_PROJECTS),$($(name)_SRC))
NON_CODESWAP_C_SOURCES     = $(filter %.c, $(notdir $(NON_CODESWAP_SOURCES)))
NON_CODESWAP_ASM_SOURCES   = $(filter %.s, $(notdir $(NON_CODESWAP_SOURCES)))

NON_CODESWAP_C_RULES       = $(NON_CODESWAP_C_SOURCES:%.c=%.rls)
NON_CODESWAP_ASM_RULES     = $(NON_CODESWAP_ASM_SOURCES:%.s=%.rls)

NON_CODESWAP_C_OBJECTS     = $(NON_CODESWAP_C_SOURCES:%.c=%.o)
NON_CODESWAP_ASM_OBJECTS   = $(NON_CODESWAP_ASM_SOURCES:%.s=%.o)



CODESWAP_SOURCES       = $(foreach name,$(CODESWAP_SUB_PROJECT),$($(name)_SRC))
CODESWAP_C_SOURCES     = $(filter %.c, $(notdir $(CODESWAP_SOURCES)))
CODESWAP_ASM_SOURCES   = $(filter %.s, $(notdir $(CODESWAP_SOURCES)))

CODESWAP_C_RULES       = $(CODESWAP_C_SOURCES:%.c=%.rls)
CODESWAP_ASM_RULES     = $(CODESWAP_ASM_SOURCES:%.s=%.rls)

CODESWAP_C_OBJECTS     = $(CODESWAP_C_SOURCES:%.c=%.o)
CODESWAP_ASM_OBJECTS   = $(CODESWAP_ASM_SOURCES:%.s=%.o)


ALL_SOURCES       = $(CODESWAP_SOURCES) $(NON_CODESWAP_SOURCES)
ALL_C_SOURCES     = $(CODESWAP_C_SOURCES) $(NON_CODESWAP_C_SOURCES)
ALL_ASM_SOURCES   = $(CODESWAP_ASM_SOURCES) $(NON_CODESWAP_ASM_SOURCES)

ALL_C_RULES       = $(CODESWAP_C_RULES) $(NON_CODESWAP_C_RULES)
ALL_ASM_RULES     = $(CODESWAP_ASM_RULES) $(NON_CODESWAP_ASM_RULES)

ALL_C_OBJECTS     = $(CODESWAP_C_OBJECTS) $(NON_CODESWAP_C_OBJECTS)
ALL_ASM_OBJECTS   = $(CODESWAP_ASM_OBJECTS) $(NON_CODESWAP_ASM_OBJECTS)

ALL_INC_PATHS     = $(CODESWAP_INC_PATHS) $(NON_CODESWAP_INC_PATHS)


# set up source search paths for make
vpath %.c   $(VPATH_FOR_C)

vpath %.s   $(VPATH_FOR_ASM)

vpath %.dsp $(VPATH_FOR_DSP)

vpath %.out $(OBJ_DIR)

vpath %.bin $(OBJ_DIR) $(LOADER_OBJ_DIR)

vpath %.o   $(OBJ_DIR)

vpath %.src $(MAKE_INPUTS)

vpath %.inc $(MAKE_INPUTS)

vpath %.def $(MAKE_INPUTS)

vpath %.rls $(RLS_DIR)

vpath %.a   $(OBJ_DIR)

vpath %.cmd $(MAKE_INPUTS)

vpath %.mem $(MAKE_INPUTS)

vpath %.uf  $(UFLAGS_DIR)


############################################################
#                                                          #
#               RULE SECTIONS                              #
#                                                          #
############################################################

-include customer.mak


# to force make to exit cleanly when encountering errors or being killed.
.DELETE_ON_ERROR: $(BIN_FILE) $(OUT_FILE) $(ARCHIVE_FILE)


############################################################
###           rules to build CODESWAP image              ###
############################################################

CODESWAP_MODEM: UPDATE_UFLAGS
	$(MAKE) -f $(MAKE_FILE) $(BIN_FILE) INCLUDE_OBJ_RLS=1


$(BIN_FILE): $(OUT_FILE)
	$(SIM) -cl -memext=0,0x5fffff -memextinit=0 -nogoifmain -nooptions  $(SIM_FLAGS) -cmd="read $(EXTRACT_SCRIPT)" $(OBJ_DIR)/$(notdir $<)
	$(POST_PROCESS_IMAGE)
	..\arc_bld_62\ArcVdslCheckSum.exe itux_image.bin
	mv itux_image.bin $(OBJ_DIR)/$(BIN_FILE)

# this rule is for linking the image based on archive of all objects for codeswap build
$(OUT_FILE): $(ARCHIVE_FILE) $(LOADER_BIN)
	$(CC) $(LDFLAGS) $(MAKE_INPUTS)/$(CODESWAP_CMD_FILE) $(OBJ_DIR)/$(notdir $<) -o $(OBJ_DIR)/$(notdir $@)
	..\arc_bld_62\elfdump.exe -t $(OBJ_DIR)/$(notdir $@) > $(MAP_DIR)/$(basename $(notdir $@)).sym
	perl $(PERL_DIR)/MemSize_2.pl $(MAP_DIR)/$(basename $(notdir $@)) > $(MAP_DIR)/$(basename $(notdir $@))_mem.xls
	perl $(PERL_DIR)/image_check.pl $(MAP_DIR)/$(basename $(notdir $@)).map CHECK_ALL $(ITUX) > $(MAP_DIR)/$(basename $(notdir $@))_cross_ref.txt


# this rule is for creating archive of all objects for codeswap build
$(ARCHIVE_FILE): $(ALL_C_OBJECTS) $(ALL_ASM_OBJECTS) $(CODESWAP_CMD_FILE)
	$(AR) $(ARFLAGS) $(OBJ_DIR)/$(notdir $@) $(addprefix $(OBJ_DIR)/,$(filter-out $(CODESWAP_CMD_FILE), $(notdir $^)))

CLEAN_vco_BUILD_FLAGS:
	@if exist .vco_build_info.txt rm .vco_build_info.txt

CLEAN_vcpe_BUILD_FLAGS:
	@if exist .vcpe_build_info.txt rm .vcpe_build_info.txt

CLEAN_IMAGES:
	@echo cleaning *.bin, *.out, and *.a
	@-rm -f $(OBJ_DIR)/$(OUT_FILE)
	@-rm -f $(OBJ_DIR)/$(BIN_FILE)
	@-rm -f $(OBJ_DIR)/$(ARCHIVE_FILE)
# removing objects and archives
CLEAN_OBJ:
	@echo cleaning *.o
	@-rm -f $(OBJ_DIR)/*.o


############################################################
###                  TESTS                               ###
############################################################

test:
	echo "$(ALL_C_OBJECTS)"

############################################################
###                  CLEANS                              ###
############################################################

CLEAN_ALL: CLEAN_SRC_INC CLEAN_RLS CLEAN_OBJ CLEAN_IMAGES CLEAN_SOURCE_TIMESTAMPS\
           CLEAN_CODESWAP CLEAN_UFLAGS CLEAN_$(ITUX)_BUILD_FLAGS CLEAN_ASM_FILES

CLEAN_ALL_EXCEPT_IMAGES: CLEAN_SRC_INC CLEAN_RLS CLEAN_OBJ CLEAN_SOURCE_TIMESTAMPS\
                         CLEAN_CODESWAP CLEAN_UFLAGS CLEAN_$(ITUX)_BUILD_FLAGS CLEAN_ASM_FILES


############################################################
###          rules to set up CODESWAP build              ###
###                                                      ###
############################################################
SET_UP_CODESWAP:
	$(MAKE) -f $(MAKE_FILE) $(CUSTOMER_CMD_FILE) $(CODESWAP_CMD_FILE)

$(CUSTOMER_CMD_FILE): $(CUSTOMER_CMD_INFILE)
	@echo         generating $(CODESWAP_CMD_FILE) ...
	@echo
	@perl $(PERL_DIR)/setup_codeswap.pl $< $@ $(MAKE_INPUTS) \
	    $(CODESWAP_SOURCE) $(CODESWAP_SRC_DIR) $(SOURCE_PLATFORM_INC_DIR)/$(ITUX)_ \
        $(ARC_SRC_INC_DIR) "$(NON_CODESWAP_SRC_FILES)" \
        "$(TARGET_OPT) $(CUSTOMER_BLD)  $(subst -D,,$(EXTRA_COMPILER_OPTIONS))"
	@echo

$(CODESWAP_CMD_FILE): $(CODESWAP_CMD_INFILE) $(CUSTOMER_CMD_FILE)  $(MEM_FILE)
	@echo         generating $(CODESWAP_CMD_FILE) ...
	@echo
	@perl $(PERL_DIR)/setup_codeswap.pl $< $@ $(MAKE_INPUTS) \
	    $(CODESWAP_SOURCE) $(CODESWAP_SRC_DIR) $(SOURCE_PLATFORM_INC_DIR)/$(ITUX)_ \
        $(ARC_SRC_INC_DIR) "$(NON_CODESWAP_SRC_FILES)" \
        "$(TARGET_OPT) $(CUSTOMER_BLD)  $(subst -D,,$(EXTRA_COMPILER_OPTIONS))"
	@echo

CLEAN_CODESWAP: CLEAN_CODESWAP_SOURCE CLEAN_CODESWAP_SRC_INC CLEAN_CMD_FILES

CLEAN_CODESWAP_SOURCE:
	@echo cleaning $(CODESWAP_SRC_DIR)
	@-rm -f $(CODESWAP_SRC_DIR)/*.c
	@-rm -f $(MAKE_INPUTS)/$(CODESWAP_CMD_FILE)
	@-rm -f $(MAKE_INPUTS)/$(CUSTOMER_CMD_FILE)

CLEAN_CODESWAP_SRC_INC:
	@-rm -f $(MAKE_INPUTS)/$(CODESWAP_SOURCE).src
	@-rm -f $(MAKE_INPUTS)/$(CODESWAP_SOURCE).inc

CLEAN_CMD_FILES:
	@echo cleaning intermediate .cmd files
	@-rm -f $(MAKE_INPUTS)/$(CODESWAP_CMD_FILE)
	@-rm -f $(MAKE_INPUTS)/$(CUSTOMER_CMD_FILE)

############################################################
###          rules to update .src/.inc from .dsp         ###
###                for AUTO_SUB_PROJECTS                 ###
############################################################

# the platform files are manually updated thru make_inputs/platform.src
# and make_inputs/platform.inc

UPDATE_SRC_INC:
	$(MAKE) -f $(MAKE_FILE) $(AUTO_SUB_PROJECTS:%=%.src)

# force codeswap to regenerate .cmd and super files
$(AUTO_SUB_PROJECTS:%=%.src):%.src:$(notdir %).dsp
	@echo 	generating $@ ...
	@-rm -f $(MAKE_INPUTS)/$(CODESWAP_CMD_FILE)
	@perl $(PERL_DIR)/get_src_frm_dsp.pl $(basename $(notdir $^)) $(<D) $(MAKE_INPUTS) $(CONFIG_NAME)

CLEAN_SRC_INC:
	@echo clear *.src
	@-rm -f  $(AUTO_SUB_PROJ_SRC_FILES)
	@-rm -f  $(AUTO_SUB_PROJ_INC_FILES)

############################################################
###      COMPILE default RULES UPDATE to build *.o       ###
############################################################

# this will cause make to read in all existing .rls files
ifdef INCLUDE_OBJ_RLS
    -include $(UFLAGS_DIR)/$(UFLAGS_LIST)
    -include $(ALL_C_RULES:%.rls=$(RLS_DIR)/%.rls)
    -include $(ALL_ASM_RULES:%.rls=$(RLS_DIR)/%.rls)
endif

UPDATE_ALL_RLS:
	@echo      updating all .rls files
	@$(MAKE) -f $(MAKE_FILE) $(ALL_C_RULES) $(ALL_ASM_RULES) INCLUDE_OBJ_RLS=1


# the following templates are used to create the .rls if they don't exist yet.
# so the dependcy is mainly just the .c or .s source file.
# one the .rls file is created, it will contain rule to build the object .o and
# how to re-generate .rls file itself based on the same dependencies of the .o.

#ifdef INCLUDE_OBJ_RLS
define C_RLS_template
ifndef $(1)_rls
$(1).rls: $(filter %/$(1).c, $(NON_CODESWAP_SOURCES) $(CODESWAP_SOURCES))
	@echo            generating $(1).rls
	@-rm -f tempzzz* $$(RLS_DIR)/$(1).rls
	@perl $$(PERL_DIR)/gen_C_rls.pl "$$(CC_COMMAND)" "CC_COMMAND" \
    "$$(ALL_INC_PATHS)" "$$(filter %/$(1).c, $$(NON_CODESWAP_SOURCES) $$(CODESWAP_SOURCES))" \
    "$(1).c" "$$(RLS_DIR)/$(1).rls" tempzzz $$(OBJ_DIR) $$(UFLAGS_DIR) $$(MAKE_INPUTS)
	@-rm -f tempzzz*
endif
endef

define ASM_RLS_template
ifndef $(1)_rls
$(1).rls: $(filter %/$(1).s, $(NON_CODESWAP_SOURCES) $(CODESWAP_SOURCES))
	@echo            generating $(1).rls
	@-rm -f tempzzz* $$(RLS_DIR)/$(1).rls
	@perl $$(PERL_DIR)/gen_asm_rls.pl "$$(CC_COMMAND)" "$$(AS_RLS_COMMAND)" "AS_COMMAND" \
	"$$(ALL_INC_PATHS)" "$$(filter %/$(1).s, $$(NON_CODESWAP_SOURCES) $$(CODESWAP_SOURCES))" \
    "$(1).s" "$$(RLS_DIR)/$(1).rls" tempzzz $$(OBJ_DIR) $$(UFLAGS_DIR) $$(MAKE_INPUTS)
	@-rm -f tempzzz*
endif
endef
#endif

# creating default rules to generate .rls files if they don't exist yet.
# these two lines are very picky about extra spaces after the commas.
$(foreach src_file,$(basename $(ALL_C_SOURCES)),$(eval $(call C_RLS_template,$(src_file))))
$(foreach src_file,$(basename $(ALL_ASM_SOURCES)),$(eval $(call ASM_RLS_template,$(src_file))))


CLEAN_RLS:
	@echo cleaning all rules *.rls ...
	@-rm -f $(RLS_DIR)/*.rls
	@-rm -f $(RLS_DIR)/*.bad

CLEAN_ASM_FILES:
	@echo cleaning all intermediate *.s ...
	@-rm -f $(ASM_DIR)/*.s

############################################################
###          rules to generate .uf files                 ###
############################################################

UPDATE_UFLAGS:
	@perl $(PERL_DIR)/update_uflags.pl $(UFLAGS_DIR) $(UFLAGS_LIST)

CLEAN_UFLAGS:
	@echo cleaning user compile flags dependency ...
	@-rm -f $(UFLAGS_DIR)/*.dep

############################################################
###     rules to check time-stamp of source files        ###
###     to solve the MKS resynch problem                 ###
############################################################

CHECK_SOURCE_TIMESTAMPS: $(ALL_SRC_FILES)
	@perl $(PERL_DIR)/check_source_timestamps.pl "$(RLS_DIR)" "$(OBJ_DIR)" "$^" "$(SOURCE_TIMESTAMPS)" $(FORCE_REBUILD)

CLEAN_SOURCE_TIMESTAMPS:
	@-rm -f $(RLS_DIR)/$(SOURCE_TIMESTAMPS)

