/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2009 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
//*************************************************************************
// Aware DMT Technology. Proprietary and Confidential.
//
// ADDRESS:         40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
// TELEPHONE:       781.276.4000
// FAX:             781.276.4001
// WEB:             http://www.aware.com
//
// FILENAME:        vr9_memorymap.h
//
// DESCRIPTION:     vr9 simext memory map
//
//*************************************************************************

#ifndef VR9_MEMORYMAP_H

#define VR9_MEMORYMAP_H
//
// this file is used for vr9_simext6.dll
//
#include "afeif_memmap.h"
#include "alp_memmap.h"

    #define DMA_CAPABLE_BLOCKS                6

    #define IRAM_BEGIN                        (0x00000000)
    #define IRAM_END                          (0x000097FF)

    // local LD_ST
    #define DSP_REGS_BEGIN                    (0x00020000)
    #define DSP_REGS_END                      (0x000200F3)

    #define X_BEGIN                           (0x00030000)
    #define X_END                             (0x00030FFF)

    #define Y_BEGIN                           (0x00034000)
    #define Y_END                             (0x00034FFF)

    #define XDSL_MEM_BEGIN                    (0x00200000)
    #define XDSL_MEM_END                      (0x002D6FFF)


    #define AI_REG_BEGIN                      (AI_REG_BASE_ADDR)    // 0xC540
    #define AI_REG_END                        (AI_REG_BEGIN + AI_REG_SIZE*4 - 1)
    #define AI_MEM_BEGIN                      (AI_MEM_BASE_ADDR)    // 0x1F000
    #define AI_MEM_END                        (AI_MEM_BASE_ADDR + AI_MEM_SIZE*4 - 1)


//#define ALP_REGBLOCK_ADDR         (0x9C00)        // 0x9c00 - (0x9c00 + 0xDD*4) = 0x9F74
//
// Tx/Rx cell buffer addresses
//#define ALP_TX_CELLBUFFER_ADDR    (0xA000)        // 0xA000 - 0xBFFF
//#define ALP_RX_CELLBUFFER_ADDR    (0xC000)        // 0xC000 - 0xDFFF
//
//#define ALP_DCP_RX_CELLBUFFER_ADDR   (0xE000)
//#define ALP_DCP_TX_CELLBUFFER_ADDR   (0xE800)

    #define ALP_REG_BEGIN                     (ALP_REGBLOCK_ADDR)
    #define ALP_REG_END                       (ALP_REG_BEGIN + 0xDD*4 - 1)
    #define ALP_MEM_BEGIN                     (ALP_TX_CELLBUFFER_ADDR)
    #define ALP_MEM_END                       (ALP_DCP_TX_CELLBUFFER_ADDR + 0x800 - 1)

    #define IIBRAM_BEGIN                      (0x00040000)
        #define MEI_TO_ARC_MAILBOX_LOC_0_ADDR       (0x00040000 + 5*4)
        #define ARC_TO_MEI_MAILBOX_LOC_0_ADDR       (0x00040000 + 5*4 + 134*2)
    #define IIBRAM_END                        (0x00069FFF)

    #define SDRAM_BASE_ADDR                   (0x00080000)
    // this space is UN-USED by the spec, so we use it to communicate
    // with simext.dll
    // Even though everything above is pushed down by           (EXTRA_RAM)
    // the following block of memory should still be available for simext
    // usage.
    #define SIMEXT_MEM_BEGIN                  (0x00020200)
    #define SIMEXT_MEM_END                    (0x000202FF)
        #define SIMEXT_INIT_CORES             (SIMEXT_MEM_BEGIN + 0*4)

                                              // 1-2 not used

        #define SIMEXT_CLOCK_CORE_MODE        (SIMEXT_MEM_BEGIN + 3*4)
            #define CLOCK_CORES_WITH_STRYMON      1
            #define CLOCK_CORES_NO_STRYMON        2
            #define CLOCK_CORES_DISABLED          3
            #define CLOCK_CORES_OVERRIDE          4
            // only take affect if running in CLOCK_CORES_UNTIL_INTR mode

        #define SIMEXT_INIT_ITUX              (SIMEXT_MEM_BEGIN + 4*4)
            #define ITUX_VDSL_CO              1
            #define ITUX_VDSL_CPE             2

        #define SIMEXT_FILE_PERMISSION_LENGTH (SIMEXT_MEM_BEGIN + 5*4)
        #define SIMEXT_FILE_PERMISSION_STRING (SIMEXT_MEM_BEGIN + 6*4)
        #define SIMEXT_FILE_NAME_LENGTH       (SIMEXT_MEM_BEGIN + 7*4)
        #define SIMEXT_FILE_NAME_STRING       (SIMEXT_MEM_BEGIN + 8*4)
        #define SIMEXT_FILE_PTR               (SIMEXT_MEM_BEGIN + 9*4)
        #define SIMEXT_FILE_IO_WRITE          (SIMEXT_MEM_BEGIN + 10*4)
        #define SIMEXT_FILE_IO_READ           (SIMEXT_MEM_BEGIN + 11*4)
        #define SIMEXT_FOPEN_REQUEST          (SIMEXT_MEM_BEGIN + 12*4)
        #define SIMEXT_FCLOSE_REQUEST         (SIMEXT_MEM_BEGIN + 13*4)
        #define SIMEXT_FFLUSH_REQUEST         (SIMEXT_MEM_BEGIN + 14*4)
        #define SIMEXT_FILE_STDOUT            (SIMEXT_MEM_BEGIN + 15*4)
        #define SIMEXT_SCANF_TYPE             (SIMEXT_MEM_BEGIN + 16*4)
        #define SIMEXT_SCANF_VAR_PTR          (SIMEXT_MEM_BEGIN + 17*4)
            #define PERCENT_s                 1
            #define PERCENT_d                 2
            #define PERCENT_x                 3
            #define PERCENT_rest_of_line      4
        #define SIMEXT_SCANF_RETURN           (SIMEXT_MEM_BEGIN + 18*4)
            #define SCANF_EOF                 -1
    // end of SIMEXT_MEM
    #define EXT_IRAM_BEGIN                    (SIMEXT_MEM_END + 1)
    #define EXT_IRAM_END                      (EXT_IRAM_BEGIN + 0xFA00 - 1)

    #define EXT_BULK_DATA_BEGIN               0x6A000
    #define EXT_BULK_DATA_END                 (EXT_BULK_DATA_BEGIN + 0x13000 - 1)


#endif // VR9_MEMORYMAP_H
