/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2002 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
;*************************************************************************
; Aware DMT Technology. Proprietary and Confidential.
;
; ADDRESS:         40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
; TELEPHONE:       781.276.4000
; FAX:             781.276.4001
; WEB:             http://www.aware.com
;
; FILENAME:        asm.h
;
; DESCRIPTION:     constants useful for assembly files
;
;*************************************************************************

; Constants
.equ BYTES_PER_WORD, 2
.equ LOG2_BYTES_PER_WORD, 1

.equ BYTES_PER_LONGWORD, 4
.equ LOG2_BYTES_PER_LONGWORD, 2

.equ BITS_PER_LONGWORD, 32
.equ FRAMESIZE_IN_BYTES, 12

.equ BTSIZE_IN_BYTES, 4*BYTES_PER_LONGWORD

.equ MAX_32BIT_NUM, 0x7FFF_FFFF
.equ MIN_32BIT_NUM, 0x8000_0000

; interrupt related
.equ DIS_INTR,   0
.equ ENA_INTR,   6       ; enable both level_1 and level_2
.equ ENA_L1,     2       ; enable both level_1 and level_2
.equ ENA_L2,     4       ; enable both level_1 and level_2

; DSP registers
.ifdef VDSL_CO_60
.equ DSP_REGISTERS_BASE, 0x40000

.equ DSP_CHIP_CONFIG, (DSP_REGISTERS_BASE + 0x94)
    .equ DSP_CHIP_CONFIG_BOOTMODE_BIT,9                 ; bit_9 is 0 for 2-port; is 1 for 4-port

.equ DSP_LDST_BANK_SEL, (DSP_REGISTERS_BASE + 0x8C)     ; LD/ST Bank Select for BRAM, XYRAM, XDSL, IRAM

.equ DSP_IFETCH_BANK_SEL, (DSP_REGISTERS_BASE + 0x90) ; IFetch Bank Select for BRAM, XYRAM, XDSL, IRAM
.equ CRI_EVENT0n_A, (0x00200818)
.equ CRI_STATUSn_A, (0x00200838)

.endif
