/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2005 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*************************************************************************
* Aware DMT Technology. Proprietary and Confidential.
*
* ADDRESS:         40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
* TELEPHONE:       781.276.4000
* FAX:             781.276.4001
* WEB:             http://www.aware.com
*
* FILENAME:        mul.h
*
* DESCRIPTION:     macros for the abstraction of multiplications
*
**************************************************************************/
#ifndef _MUL_H
#define _MUL_H

#include "typedef.h"

extern int32  xmult(int32, int32);
extern uint32 xmulu(uint32, uint32);

// ARC6 related
#define AUX_XMAC2 (0x46)
pragma intrinsic(xmult,  opcode => 0x05, sub_opcode => 0x0c, assume_volatile => 1);
pragma intrinsic(xmulu, opcode => 0x05, sub_opcode => 0x0d, assume_volatile => 1);


/* 16-bit * 16-bit multiply */
#define MULS16(prod, x, y) {  \
   xmult((int32) (x), (int32) (y)); \
   (prod) = (int32) _lr(AUX_XMAC2); \
}

#define MULU16(prod, x, y) {  \
   xmulu((uint32) (x), (uint32) (y));  \
   (prod) = (uint32) _lr(AUX_XMAC2);   \
}


#define MULS32x16(prod, x32, y16) { \
   int32 l_result; \
   xmult((x32) >> 16, (y16)); \
   (l_result) = (int32) (_lr(AUX_XMAC2) << 16); \
   if((y16) < 0) {   \
      xmulu((x32) & 0x0000FFFF, -(y16));  \
      (l_result) -= (int32) _lr(AUX_XMAC2);  \
   } \
   else {   \
      xmulu((x32) & 0x0000FFFF, (y16));   \
      (l_result) += (int32) _lr(AUX_XMAC2);  \
   } \
   prod = l_result;\
}

#define MULS32xU16(prod, x32, y16) { \
   int32 l_result; \
   xmult((x32) >> 16, (y16)); \
   (l_result) = (int32) (_lr(AUX_XMAC2) << 16); \
   xmulu((x32) & 0x0000FFFF, (y16)); \
   (l_result) += (int32) _lr(AUX_XMAC2); \
   prod = l_result;\
}

#endif
