/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */

#ifndef _XDMA_H
#define _XDMA_H


//
// XDMA interface
//

// write a single 16-bit word to XDMA interface
void WriteXdmaWord(int16 s_Data, int32 l_DestAddr);

// read block from XDMA; blocking
void ReadXdmaBlock(int32 l_SourceStart, int32 l_DestStart, int32 l_NumOfBytes);

// set up an XDMA read and return (non-blocking)
void SetupReadXdmaBlock(int32 l_SourceStart, int32 l_DestStart, int32 l_NumOfBytes);
void SetupWriteXdmaBlock(int32 l_SourceStart, int32 l_DestStart, int32 l_NumOfBytes);

// get XDMA access status and return (non-blocking)
int GetXdmaAccessStatus(void);

void WaitForXdmaDone(void);

FlagT LockXdmaBus(void);
void ReleaseXdmaLock(void);

#endif // _XDMA_H
