/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2004 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*************************************************************************
* Aware DMT Technology. Proprietary and Confidential.
*
* ADDRESS:         40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
* TELEPHONE:       781.276.4000
* FAX:             781.276.4001
* WEB:             http://www.aware.com
*
* FILENAME:        xy_iof.h
*
* DESCRIPTION:     Header file for functions that interface the XY memory
*
**************************************************************************/
#include "common.h"

/***** GENERAL CONSTANTS *****/
#ifndef FAIL
#define FAIL   (0)
#endif // #ifndef FAIL

#ifndef PASS
#define PASS   (1)
#endif // #ifndef PASS

#define ADDR_MODE_16 (0)
#define ADDR_MODE_32 (1)
#define ADDR_NOT_IN_XY  (-1)

#define BYTES_PER_WORD        (2)
#define BYTES_PER_LONGWORD    (4)
#define LOG2_BYTES_PER_WORD      (1)
#define LOG2_BYTES_PER_LONGWORD  (2)

/***** BUFFER IDs *****/
#define NUM_BUFFER_ID      (2)

#define X_MEM           (0)
#define Y_MEM           (1)

/***** BUFFER ADDRESSES *****/
#ifdef VDSL_50
   #define X_BLOCK_SIZE_IN_BYTES (0x2000)
   #define Y_BLOCK_SIZE_IN_BYTES (0x2000)

   #define XY_BASE_ADDR_IN_BYTES (0x2A000) //(0x18000)

   #define X_BASE_ADDR_IN_BYTES  (XY_BASE_ADDR_IN_BYTES)
   #define Y_BASE_ADDR_IN_BYTES  (XY_BASE_ADDR_IN_BYTES + X_BLOCK_SIZE_IN_BYTES)

#endif

   #define X_BLOCK_SIZE_IN_BYTES (0x1000)
   #define Y_BLOCK_SIZE_IN_BYTES (0x1000)

   #define X_BASE_ADDR_IN_BYTES  (0x30000)
   #define Y_BASE_ADDR_IN_BYTES  (0x34000)




/* FUNCTION PROTOTYPES */
int32 XYAddrDecode(int32 *pla_input, FlagT ft_AddrMode);
FlagT CheckXYAddrRange(int32 *pla_buf, uint32 ul_bufId);
FlagT CheckValidModuloAddr(int32 pla_bufXY, int16 s_bufLen);
void  AlignOddAddressWordsX(int32 psa_xyBuf, int16 s_bufLen);
void  AlignOddAddressWordsY(int32 psa_xyBuf, int16 s_bufLen);
void XYDecodeBypass_AddrDecode();

