;; **COPYRIGHT******************************************************************
;;    INTEL CONFIDENTIAL
;;    Copyright (C) 2017 Intel Corporation
;;    Copyright (C), 1994-2002 Aware Inc. All Rights Reserved.
;; ******************************************************************COPYRIGHT**
;; **DISCLAIMER*****************************************************************
;;   The source code contained or described herein and all documents related
;;   to the source code ("Material") are owned by Intel Corporation or its
;;   suppliers or licensors. Title to the Material remains with Intel
;;   Corporation or its suppliers and licensors. The Material may contain
;;   trade secrets and proprietary and confidential information of Intel
;;   Corporation and its suppliers and licensors, and is protected by
;;   worldwide copyright and trade secret laws and treaty provisions. No part
;;   of the Material may be used, copied, reproduced, modified, published,
;;   uploaded, posted, transmitted, distributed, or disclosed in any way
;;   without Intels prior express written permission.
;;
;;   No license under any patent, copyright, trade secret or other
;;   intellectual property right is granted to or conferred upon you by
;;   disclosure or delivery of the Materials, either expressly, by
;;   implication, inducement, estoppel or otherwise. Any license under
;;   such intellectual property rights must be express and approved by
;;   Intel in writing.
;; *****************************************************************DISCLAIMER**
;*************************************************************************
; Aware DMT Technology. Proprietary and Confidential.
;
; ADDRESS:         40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
; TELEPHONE:       781.276.4000
; FAX:             781.276.4001
; WEB:             http://www.aware.com
;
; FILENAME:        cmplxvecmultloop.s
;
; DESCRIPTION:     Function for multiplying two complex vectors
;
;*************************************************************************

.text

;******************************************************************************
; void CmplxVectorMultiplyLoop_PreProcess(int32 src_arr1, int32 src_arr2, int32 scratch_padX, int32 scratch_padY, int16 length, int16 conj_src_arr1);
.global CmplxVectorMultiplyLoop_PreProcess
CmplxVectorMultiplyLoop_PreProcess:
   ; Input Arguments
   ; %r0 = Start Address of source array 1 in X memory
   ; %r1 = Start Address of source array 2 in Y memory
   ; %r2 = Start address of scratch pad in X memory
   ; %r3 = Start address of scratch pad in Y memory
   ; %r4 = Number of complex elements in source array
   ; %r5 = 1 indicates conjugate source array 1

   ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
   ; set up loop count for zero ovhd loop mechanism ;
   ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
    mov.f %lp_count,%r4       ; Initialise loop counter
   blt 9f                  ; if (length <= 0) return
   nop
   nop

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;        -----------
;        | Yr | Yr | address n in 32-bit XY addressing mode
;        | Yi | Yi | address n+1 in 32-bit XY addressing mode
;        -----------
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

   ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
   ; set up regs for use later ;
   ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
                  ; %r4 = 1*length
    asl %r6,%r4,1    ; %r6 = 2*length
    asl %r7,%r4,2    ; %r7 = 4*length


   ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
   ; set up zero ovhd loop mechanism ;
   ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
    mov.f %lp_count,%r6       ;Initialise loop counter

   ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
   ; set up address and modifier registers ;
   ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
   add %r8, %r1, %r6
   sub %r8, %r8, 1
    sr %r8,[%ay0]
    sr 0x2000_3FFF,[%my00]    ; offset = -1, postupdate, linear, 16-bit mode, AM_MODULO

   add %r8, %r3, %r7
   sub %r8, %r8, 1
    sr %r8,[%ay1]
    sr 0x2000_3FFF,[%my10]    ; offset = -1, postupdate, linear, 16-bit mode, AM_MODULO
   nop
   nop

   lp 0f ; for(i=0; i<2*length; i++)
      mov %y1_u0, %y0_nu
      mov %y1_u0, %y0_u0
   0:

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;        ------------
;        | Xi | Xr  |   address n in 32-bit XY addressing mode
;        | Xr | -Xi |   address n+1 in 32-bit XY addressing mode
;        ------------
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
   ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
   ; set up regs for use later ;
   ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
   add %r6, %r0, %r6 ; %r6 = src_arr1     + (2*length)
   add %r7, %r2, %r7 ; %r7 = scratch_padX + (4*length)


   ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
   ; set up modifier registers ;
   ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
    sr 0x2000_3FFE,[%mx00]    ; offset = -2, postupdate, linear, 16-bit mode, AM_MODULO
    sr 0x2000_3FFC,[%mx10]    ; offset = -4, postupdate, linear, 16-bit mode, AM_MODULO
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;        ------------
;Iteration1   |    |  Xr |
;        |    |     |
;             ------------
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
   ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
   ; set up for zero ovhd loop mechanism ;
   ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

    //ARC6 related
    sr movx_loop_start1, [%lp_start]   ;Prepare single instruction
    sr movx_loop_end1, [%lp_end]         ;loop

    mov.f %lp_count,%r4                ;Initialise loop counter

   ;;;;;;;;;;;;;;;;;;;;;;;;;;;;
   ; set up address registers ;
   ;;;;;;;;;;;;;;;;;;;;;;;;;;;;
   sub %r8, %r6, 2
    sr %r8,[%ax0]

   sub %r8, %r7, 4
    sr %r8,[%ax1]
   nop
   nop

#ifdef ARC7
   lp movx_loop_end1
#endif
   movx_loop_start1:
      mov %x1_u0, %x0_u0
   movx_loop_end1:

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;        ------------
;Iteration2   |    |     |
;        | Xr |     |
;             ------------
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
   ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
   ; set up for zero ovhd loop mechanism ;
   ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
    //ARC6 related
    sr movx_loop_start2, [%lp_start]   ;Prepare single instruction
    sr movx_loop_end2, [%lp_end]         ;loop

    mov.f %lp_count,%r4                ;Initialise loop counter

   ;;;;;;;;;;;;;;;;;;;;;;;;;;;
   ; set up window registers ;
   ;;;;;;;;;;;;;;;;;;;;;;;;;;;
   sub %r8, %r6, 2
    sr %r8,[%ax0]

   sub %r8, %r7, 1
    sr %r8,[%ax1]
   nop
   nop

#ifdef ARC7
   lp movx_loop_end2
#endif
   movx_loop_start2:
      mov %x1_u0, %x0_u0
   movx_loop_end2:

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;        -----------------
;Iteration3/4 | +/-Xi |       |
;        |       | -/+Xi |
;             -----------------
; depends on conj_src_arr1 %r5
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

   mov.f %r8, %r5
   bz check_conj_src_arr1_done      ; if conj_src_arr1 (%r5) == 0 return
   mov %r5, 1                 ; else set %r5 to 1 (to be used below)

   check_conj_src_arr1_done:

   ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
   ; set up for zero ovhd loop mechanism ;
   ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
    //ARC6 related
    sr movx_loop_start3, [%lp_start]   ;Prepare single instruction
    sr movx_loop_end3, [%lp_end]         ;loop

    mov.f %lp_count,%r4                ;Initialise loop counter

   ;;;;;;;;;;;;;;;;;;;;;;;;;;;
   ; set up window registers ;
   ;;;;;;;;;;;;;;;;;;;;;;;;;;;
   sub %r8, %r6, 1
    sr %r8,[%ax0]

   sub %r8, %r7, 3
   add %r8, %r8, %r5
    sr %r8,[%ax1]
   nop
   nop

#ifdef ARC7
   lp movx_loop_end3
#endif
   movx_loop_start3:
      mov %x1_u0, %x0_u0
   movx_loop_end3:

   ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
   ; set up for zero ovhd loop mechanism ;
   ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
    mov.f %lp_count,%r4                ;Initialise loop counter

   ;;;;;;;;;;;;;;;;;;;;;;;;;;;
   ; set up window registers ;
   ;;;;;;;;;;;;;;;;;;;;;;;;;;;
   sub %r8, %r6, 1
    sr %r8,[%ax0]

   sub %r8, %r7, 2
   sub %r8, %r8, %r5
    sr %r8,[%ax1]
   nop
   nop

   lp movx_loop_end4
      asr %r8, %x0_u0, 16
      sub %r8, 0, %r8
      asl %x1_u0, %r8, 16
   movx_loop_end4:

   9:
   j [%blink]

;******************************************************************************

; void CmplxVectorMultiplyLoop(int32 dest_arr, int32 src_arr1, int32 src_arr2, int16 shift, int16 length)
.global CmplxVectorMultiplyLoop
CmplxVectorMultiplyLoop:
   ; Input Arguments
   ; %r0 = Start Address of destination array in X memory
   ; %r1 = Start Address of source cmplx multiply scratch pad array in X memory
   ; %r2 = Start Address of source cmplx multiply scratch pad array in Y memory
   ; %r3 = Shift to be applied to result
   ; %r4 = Number of complex elements in destination array

   ;;;;;;;;;;;;;;;;;;;;;;;;;;;
   ; set up window registers ;
   ;;;;;;;;;;;;;;;;;;;;;;;;;;;
    sr %r1,[%ax0]
    sr 0x1,[%mx00]            ; offset = 1, postupdate, linear, 32-bit mode, AM_MODULO

    sr %r2,[%ay0]
    sr 0x1,[%my00]            ; offset = 1, postupdate, linear, 32-bit mode, AM_MODULO

    sr %r0,[%ax1]
    sr 0x2000_0001,[%mx10]    ; offset = 1, postupdate, linear, 16-bit mode, AM_MODULO
   nop
   nop

   ;Setup the # of right shifts
   sub %r7, 0x10, %r3

   ;multiply
   muldw 0,%x0_u0,%y0_u0
   macdw 0,%x0_u0,%y0_u0
   lr %r5, [%aux_xmac2]
   lr %r6, [%aux_xmac1]

   ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
   ; set up loop count for zero ovhd loop mechanism ;
   ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
    sub.f %lp_count,%r4,1     ;Initialise loop counter - Dual
   bz    0f             ; if (length-1 == 0) skip loop
   blt      9f             ; if (length-1 < 0) return

   lp 0f ; for(i=0; i<length; i++)
      ;multiply
      muldw 0,%x0_u0,%y0_u0
      macdw 0,%x0_u0,%y0_u0

      ;Shift result right and save @ destination addr
      asl %x1_u0, %r5, %r7
      asl %x1_u0, %r6, %r7

      lr %r5, [%aux_xmac2]
      lr %r6, [%aux_xmac1]
   0:

   ;Shift result right and save @ destination addr
   asl %x1_u0, %r5, %r7
   asl %x1_u0, %r6, %r7

   9:
   j [%blink]

;******************************************************************************




