;; **COPYRIGHT******************************************************************
;;    INTEL CONFIDENTIAL
;;    Copyright (C) 2017 Intel Corporation
;;    Copyright (C), 1994-2002 Aware Inc. All Rights Reserved.
;; ******************************************************************COPYRIGHT**
;; **DISCLAIMER*****************************************************************
;;   The source code contained or described herein and all documents related
;;   to the source code ("Material") are owned by Intel Corporation or its
;;   suppliers or licensors. Title to the Material remains with Intel
;;   Corporation or its suppliers and licensors. The Material may contain
;;   trade secrets and proprietary and confidential information of Intel
;;   Corporation and its suppliers and licensors, and is protected by
;;   worldwide copyright and trade secret laws and treaty provisions. No part
;;   of the Material may be used, copied, reproduced, modified, published,
;;   uploaded, posted, transmitted, distributed, or disclosed in any way
;;   without Intels prior express written permission.
;;
;;   No license under any patent, copyright, trade secret or other
;;   intellectual property right is granted to or conferred upon you by
;;   disclosure or delivery of the Materials, either expressly, by
;;   implication, inducement, estoppel or otherwise. Any license under
;;   such intellectual property rights must be express and approved by
;;   Intel in writing.
;; *****************************************************************DISCLAIMER**
;*************************************************************************
; Aware DMT Technology. Proprietary and Confidential.
;
; ADDRESS:         40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
; TELEPHONE:       781.276.4000
; FAX:             781.276.4001
; WEB:             http://www.aware.com
;
; FILENAME:        dsp_op.s
;
; DESCRIPTION:     This file contains functions emulating DSP operations.
;
;*************************************************************************

.text
;/****************************************************************************
; ;
; ;   Subroutine Name : round(L_var, s_bit_position)
; ;
; ;  This function performs conventional rounding at bit
; ;   indicated by "bit_position" and then shift the result
; ;   right by "bit_position"
; ;
; ;   Prototype:
; ;   int32 round(int32 L_var, int s_bit_position)
; ;
; ;  Input Arguments:
; ;
; ;    L_var - 32 bit long signed integer whose value falls in the
; ;             range : 0x8000 0000 <= L_var1 <= 0x7fff ffff
; ;   s_bit_position - the bit position rounding bit 1 is added
; ;
; ;   Output Arguments:
; ;
; ;    none
; ;
; ;  Return Value:
; ;
; ;    l_var_out - 32 bit long signed integer whose value falls in the
; ;              range : 0x8000 0000 <= L_var1 <= 0x7fff ffff
; *****************************************************************************/
;int32 round(int32 L_var, int16 s_bit_position)
.global round
round:
   ; Input Arguments
   ; %r0 = L_var
   ; %r1 = s_bit_position

   .define L_var,          %r0
   .define s_bit_position, %r1
   .define s_bitpos_min1,  %r2
   .define l_rnd_bit,      %r3
   .define l_var_out,      %r3

   ; prolog: none since leaf function and no stack frame for auto variables
   sub.f s_bitpos_min1, s_bit_position, 1 ; if (s_bit_position <= 0) return L_var;
   bn    9f
   sub.f 0, s_bit_position, 32   ; if (s_bit_postion >= 32) return 0;
   blt   0f
   mov   %r0, 0
   b     9f

   0:
      asl  l_rnd_bit, 1, s_bitpos_min1    ; l_rnd_bit = (int32) 0x1 << (s_bit_position-1);
      adds l_var_out, L_var, l_rnd_bit    ; l_var_out = l_add(L_var, l_rnd_bit);
      asr  %r0, l_var_out, s_bit_position    ; l_var_out >>= s_bit_position;

   ; epilog: just return to the caller
   9:
      j [%blink]

   .undef L_var
   .undef s_bit_position
   .undef s_bitpos_min1
   .undef l_rnd_bit
   .undef l_var_out

;/****************************************************************************
; ;
; ;   Subroutine Name: l_add(L_var1, L_var2)
; ;
; ;  Description:
; ;  Adds two 32bit values and tests for overflow/underflow.  If overflow/
; ;  underflow occurs then result if saturated to MAX_32/MIN_32
; ;
; ;   Prototype:
; ;   int32 l_add(int32 L_var1, int32 L_var2)
; ;
; ;  Input Arguments:
; ;
; ;    L_var1, L_var2 - 32 bit long signed integers to be summed
; ;
; ;   Output Arguments:
; ;
; ;  Return Value:
; ;
; ;    l_var_out - 32 bit long signed integer whose value falls in the
; ;              range : 0x8000 0000 <= L_var1 <= 0x7fff ffff
; *****************************************************************************/
;int32 l_add(int32 L_var1, int32 L_var2)
.global l_add
l_add:
   .define L_var1, %r0
   .define L_var2, %r1

   adds %r0, L_var1, L_var2
   j [%blink]

   .undef L_var1
   .undef L_var2

