;; **COPYRIGHT******************************************************************
;;    INTEL CONFIDENTIAL
;;    Copyright (C) 2017 Intel Corporation
;;    Copyright (C), 1994-2002 Aware Inc. All Rights Reserved.
;; ******************************************************************COPYRIGHT**
;; **DISCLAIMER*****************************************************************
;;   The source code contained or described herein and all documents related
;;   to the source code ("Material") are owned by Intel Corporation or its
;;   suppliers or licensors. Title to the Material remains with Intel
;;   Corporation or its suppliers and licensors. The Material may contain
;;   trade secrets and proprietary and confidential information of Intel
;;   Corporation and its suppliers and licensors, and is protected by
;;   worldwide copyright and trade secret laws and treaty provisions. No part
;;   of the Material may be used, copied, reproduced, modified, published,
;;   uploaded, posted, transmitted, distributed, or disclosed in any way
;;   without Intels prior express written permission.
;;
;;   No license under any patent, copyright, trade secret or other
;;   intellectual property right is granted to or conferred upon you by
;;   disclosure or delivery of the Materials, either expressly, by
;;   implication, inducement, estoppel or otherwise. Any license under
;;   such intellectual property rights must be express and approved by
;;   Intel in writing.
;; *****************************************************************DISCLAIMER**
;*************************************************************************
; Aware DMT Technology. Proprietary and Confidential.
;
; ADDRESS:         40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
; TELEPHONE:       781.276.4000
; FAX:             781.276.4001
; WEB:             http://www.aware.com
;
; FILENAME:        intvec.s
;
; DESCRIPTION:     This file includes
;                  1. interrupt vector table
;                  2. asm ISRs for all interrupts. These routines will
;                     call c_interrupt_handlers if needed.
;
;*************************************************************************

#define IN_ASM
.include "asm.h"
.include "interrupts.h"


;**********************************************************
;   interrupt vector table
;**********************************************************

    .file "intvec.s"

    .global hw_reset_isr

    .global hw_reset
    .global mem_except
    .global instr_err
    .global xdsl_1
    .global xdsl_2
    .global ivect5
    .global ivect6
    .global ivect7
    .global ivect8
    .global ivect9
    .global ivectA
    .global ivectB
    .global ivectC
    .global ivectD
    .global ivectE
    .global ivectF
    .global invalid_int_isr
    .global memex_int_isr
    .global instr_err_int_isr

    .global vdsl_1_isr                             ; return thru ILINK1
;    .global vdsl_2_isr                             ; return thru ILINK1

#ifdef REV_1_4_IFX
    .global sci_int_isr                             ; return thru ILINK1
#endif // REV_1_4_IFX

    .text

hw_reset:      j   hw_reset_isr
mem_except:    j   memex_int_isr                       ; MEMEX
instr_err:     j   instr_err_int_isr                   ; INSTERR
xdsl_1:        j   vdsl_1_isr                          ; XDSL1, return thru ILINK1
xdsl_2:        j   invalid_int_isr                     ; XDSL2, return thru ILINK1
ivect5:        j   invalid_int_isr                     ; ARCDMA
ivect6:        j   invalid_int_isr                     ;
ivect7:        j   invalid_int_isr                     ;
ivect8:        j   invalid_int_isr                     ; ME_MBX
ivect9:        j   invalid_int_isr                     ; ME_GP
ivectA:        j   invalid_int_isr                     ; ME_CS
ivectB:        j   invalid_int_isr                     ; XMEM
#ifdef REV_1_4_IFX
ivectC:        j   sci_int_isr                         ; PER
#else
ivectC:        j   invalid_int_isr                     ; PER
#endif // REV_1_4_IFX
ivectD:        j   invalid_int_isr                     ; PER2
ivectE:        j   invalid_int_isr                     ; PER3
ivectF:        j   invalid_int_isr                     ; PER4

// for bad exceptions, the code eventually will be written to:
// 1. disable interrupts
// 2. lock the processor in infinite loop while still providing
//    MP message handling.

// these are 32-bit variables
;typedef struct {
;  int32 l_bad_intr_cnt;
;  int32 l_which_bad_intr;
;  int32 l_blink_value;
;  int32 l_ilink1_value;
;  int32 l_ilink2_value;
;} intrpt_debug_t;

.extern gt_intrpt_debug

memex_int_isr:
    mov r0,   0x101          ; 0x101 = mem_exception
    j invalid_int_common

instr_err_int_isr:
    mov r0,   0x202          ; 0x202 = instruction_error
    j invalid_int_common

invalid_int_isr:
    mov r0,   0x303          ; 0x303 = unexpected interrupts

invalid_int_common:
    mov r1, gt_intrpt_debug

    st r0, [r1, 4]          ; which_bad_intr
    st r31, [r1, 8]         ; blink_value
    st r29, [r1, 12]        ; ilink1_value
    st r30, [r1, 16]        ; ilink2_value

    mov r0, 1

invalid_int_loop:           ; trap loop
    add r0, r0, r0
    st r0, [r1]             ; update bad_intr_cnt
    j   invalid_int_loop

//**********************************************
//*********** ASM ISRs *************************
//**********************************************


;**********************************************************
;   Hardware Reset
;**********************************************************

    ; Slightly modified of crt1.s from Metaware.
    ; Initialize the register file.  This is necessary because
    ; of an idiosyncracy of the register file implementation.
    ; Compiled code may generate sub  r0, r1, r1, expecting to
    ; load 0 into r0, but the individual reads of r1 for the two source
    ; operands may return different (garbage) values if r1 had never
    ; been written to since reset.
    ; NOTE: This initialization is required ONLY for Tangent ARC4 builds.
    ;       You may comment it out if not using an ARC4 build.

    .extern main
    .text
    .weak    _SDA_BASE_

    .type    hw_reset_isr, @function

hw_reset_isr:
    ; set up interrupt priority level
;    mov    r0, 0x00000100           ; ivect8 (xmem) is set to level 2 (mid)
;    sr     r0, [aux_irq_lev]

;    soc legacy code might not really needed
;    .irep num, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25
;        mov    r\&num, 0
;    .endr

    mov    sp, _estack              ; initialize stack pointer to end of .stack section
    sub    sp, sp, 16               ; allocate expected call frame
    mov    gp, _SDA_BASE_           ; initialize small-data base register

    ; more initialization to reset/clear other mem spaces and control blocks


    bl.d   main                     ; jump directly to main instead of calling __arc_main
    mov    fp, 0                    ; initialize frame pointer

    b    _exit_halt

    .global    _exit_halt
    .type    _exit_halt, @function

_exit_halt:
    flag    0x01                    ; halt the processor
    nop
    b    _exit_halt
    nop

    ; weak versions of small data symbols normally defined by the linker.
    .weak _fsbss
    .weak _esbss
    .set _fsbss,0
    .set _esbss,0

    ; weak versions of heap section boundaries.  If a .heap section
    ; is provided, our low-level allocator "sbrk" allocates within it.
    ; If no .heap is provided, we allocate from _end to the end of memory.
    .weak _fheap
    .weak _eheap
    .set _fheap,0
    .set _eheap,0

;------------------------------------------------------------------------
;
;  Name : vdsl_1_isr
;         vdsl_2_isr
;  Description:
;        the ADSL ASM interrupt handler which will save processor context
;       and call the C interrupt dispatcher.
;
;  Prototype:
;
;  Input Arguments:
;
;  Output Arguments:
;
;  Return:
;
;  Notes:
;
;------------------------------------------------------------------------

    .extern  gs_FGActive
    .extern  gs_FGTaskPending
    .extern  ForegroundHandler
    .extern  _enable1
    .extern  _disable1


    .text

    .type    vdsl_1_isr, @function

vdsl_1_isr:

    sub      sp, sp, ISR_FPSIZE              ; allocate stack space ;
    ; ==================== ;
    ; save registers
    ; ==================== ;
    .irep the_reg, r0, r1, r2, r3, r4, r5, r6, r7, r8, r9, r10, \\
                   r11, r12, fp, blink, ilink1, lp_count
        st       the_reg, [sp, the_reg\&_offset]
    .endr

    ; ==================== ;
    ; set up fp
    ; ==================== ;
    add     fp, sp, ISR_FPSIZE

    ; ==================== ;
    ; save aux regs
    ; ==================== ;
    lr      r12, [lp_start]
    st      r12, [sp, lp_start_offset]
    lr      r12, [lp_end]
    st      r12, [sp, lp_end_offset]

    ; =============================== ;
    ; saving XMAC registers
    ; =============================== ;

    .irep the_reg, xmac0, xmac1, t0, t1, t2, t3
        st      the_reg, [sp, the_reg\&_offset]
    .endr

    .irep the_reg, ax0, ax1, ay0, ay1, mx0, mx1, my0, my1, aux_xmac0, \\
                   aux_xmac1, aux_xmac2, xyconfig, aux_macmode
        lr      r12, [the_reg]
        st      r12, [sp, the_reg\&_offset]
    .endr

    ; ==================== ;
    ; ARC DMA engine registers
    ; Since ARC DMA can only be preformed in the TC tasks which in not interruptible,
    ; there is no needs to save/restore its context
    ; ==================== ;

    ; ==================== ;
    ; handle the interrupt ;
    ; ==================== ;
    sr      0, [lp_end]
    jl      MasterIntHandler

    ; =============================== ;
    ; checking Foreground processing
    ; upon returning from TC task (interrupt handler),
    ; if ((gs_FGActive == 0) && (gs_FGTaskPending))
    ; {
    ;     save context;
    ; FG_resume:
    ;     enable interrupts;
    ;     excute FG tasks
    ;     disable interrupts;    // potetially TC task could set the FG pending and will
    ;                            // miss to run the FG task.
    ;     if (FG task queue is NOT empty)
    ;     {
    ;         goto FG_resume;
    ;     }
    ;     restore context;
    ;     enable interrupts
    ; }
    ; =============================== ;

    ldw     r8, [gs_FGActive]
    xor.f   r8, 0x1, r8
    ldw     r11, [gs_FGTaskPending]
    bz      isr_cont_0                     ; continue with context restoration if (FG is active)
    xor.f   r11, 0x1, r11
    bnz      isr_cont_0                    ; continue with context restoration if (no FG task pending)

resume_FG:
    sr      0, [lp_end]                     ; clear lp_end
    stw     r8, [gs_FGActive]               ; claim that FG is active
    stw     r11, [gs_FGTaskPending]         ; clear pending flag
;    bl      _enable1                        ; enable interrupts before running foreground

    bl      ForegroundHandler

;    bl      _disable1                       ; disable level1 interrupt before checking FG status

    ; check if FG queue is really empty
    ldw     r8, [gs_FGTaskPending]          ; if TC interrupt FG, this might have been set again by TC.
                                            ; so if we do not check it here, we might miss the new FG.
    xor.f   r11, 0x1, r8

    bz   resume_FG

    stw     r8, [gs_FGActive]               ; r8 should be 0 meaning no pending FG,
                                            ; so claim that FG is DONE if there is no more FG pending

isr_cont_0:
    ; =============================== ;
    ; restoring XMAC registers
    ; =============================== ;
    .irep the_reg, xmac0, xmac1, t0, t1, t2, t3
        ld      the_reg, [sp, the_reg\&_offset]
    .endr

    ; note that aux_xmac0 (the extension register) must be restored after aux_xmac1 and aux_xmac2
    .irep the_reg, ax0, ax1, ay0, ay1, mx0, mx1, my0, my1, aux_xmac1, \\
                   aux_xmac2, aux_xmac0, xyconfig, aux_macmode
        ld      r12, [sp, the_reg\&_offset]
        sr      r12, [the_reg]
    .endr


    ; delay restoring of r12 to the end since r12 being used as a scratch reg now.
    .irep the_reg, r0, r1, r2, r3, r4, r5, r6, r7, r8, r9, r10, \\
                   r11, fp, blink
        ld      the_reg, [sp, the_reg\&_offset]
    .endr

    ld      r12, [sp, lp_start_offset]
    sr      r12, [lp_start]
    ld      r12, [sp, lp_end_offset]
    sr      r12, [lp_end]
    ld      r12, [sp, lp_count_offset]
    mov     lp_count, r12


    ; =======================
    ; No context restoring for ARC DMA engine registers
    ; because only TC can use it.
    ; =======================

    ld      ilink1, [sp, ilink1_offset]

    ld      r12, [sp, r12_offset]                   // restore r12 last
    ; ======================= ;
    ; de-allocate stack space ;
    ; ======================= ;
    add     sp, sp, ISR_FPSIZE

    ; ===================== ;
    ; return from interrupt ;
    ; ===================== ;
    j.f     [ilink1]

;/*
;*-------------------------------------------------------------------------------
;*
;* Prototype: void disable1_save(uint32 *pul_stat)
;*
;* This function disables level 1 interrupt and save status for previous status.
;*
;* Input Arguments:
;*    *pul_stat: pointer to variable to hold interrupt status
;*
;* Output Arguments:
;*
;* Returns:
;*
;* Global Variables:
;*
;*-------------------------------------------------------------------------------
;*/
; disable interrupt level 1 & save previous interrupt status (low priority)
; disable1_save(uint32 *pul_stat)
.global  disable1_save
.type disable1_save, @function
disable1_save:
    st %blink, [r0]
    and %blink, %blink, 0xfbffffff
    j.f [%blink]

;/*
;*-------------------------------------------------------------------------------
;*
;* Prototype: void restore1_save(uint32 ul_stat)
;*
;* This function restores level 1 interrupt with previously saved status.
;*
;* Input Arguments:
;*    ul_stat: variable to hold previous interrupt status
;*
;* Output Arguments:
;*
;* Returns:
;*
;* Global Variables:
;*
;*-------------------------------------------------------------------------------
;*/
; restore interrupt level 1 with previously saved interrupt status (low priority)
; restore1_save(uint32 ul_stat)
.global  restore1_save
.type restore1_save, @function
restore1_save:
    and.f %r0, %r0, 0x04000000
    and.z %blink, %blink, 0xfbffffff
    or.nz %blink, %blink, 0x04000000
    j.f [%blink]

#ifdef REV_1_4_IFX
sci_int_isr:

    sub      sp, sp, ISR_FPSIZE              ; allocate stack space ;
    ; ==================== ;
    ; save registers
    ; ==================== ;
    .irep the_reg, r0, r1, r2, r3, r4, r5, r6, r7, r8, r9, r10, \\
                   r11, r12, fp, blink, ilink1, lp_count
        st       the_reg, [sp, the_reg\&_offset]
    .endr

    ; ==================== ;
    ; set up fp
    ; ==================== ;
    add     fp, sp, ISR_FPSIZE

    ; ==================== ;
    ; save aux regs
    ; ==================== ;
    lr      r12, [lp_start]
    st      r12, [sp, lp_start_offset]
    lr      r12, [lp_end]
    st      r12, [sp, lp_end_offset]

    ;; --------------------------------------
    ;; Branch to C-version secondary ISR
    ;; --------------------------------------
    bl    SCIIntHandler

    ; delay restoring of r12 to the end since r12 being used as a scratch reg now.
    .irep the_reg, r0, r1, r2, r3, r4, r5, r6, r7, r8, r9, r10, \\
                   r11, fp, blink
        ld      the_reg, [sp, the_reg\&_offset]
    .endr

    ld      r12, [sp, lp_start_offset]
    sr      r12, [lp_start]
    ld      r12, [sp, lp_end_offset]
    sr      r12, [lp_end]
    ld      r12, [sp, lp_count_offset]
    mov     lp_count, r12


    ; =======================
    ; No context restoring for ARC DMA engine registers
    ; because only TC can use it.
    ; =======================

    ld      ilink1, [sp, ilink1_offset]

    ld      r12, [sp, r12_offset]                   // restore r12 last
    ; ======================= ;
    ; de-allocate stack space ;
    ; ======================= ;
    add     sp, sp, ISR_FPSIZE

    ; ===================== ;
    ; return from interrupt ;
    ; ===================== ;
    j.f     [ilink1]

#endif // REV_1_4_IFX

    .end
