/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#include <stdarg.h>
#include <string.h>
#include <stdio.h>
#include "common.h"

#include "hercules_memrymap.h"

char sprintf_buf[512];

// file ops
FILE* fopen(const char* path, const char* mode)
{
   FILE *ptr;

   *((volatile int32 *)SIMEXT_FILE_NAME_LENGTH) = strlen(path);
   *((volatile int32 *)SIMEXT_FILE_NAME_STRING) = (int32)path;
   *((volatile int32 *)SIMEXT_FILE_PERMISSION_LENGTH) = strlen(mode);
   *((volatile int32 *)SIMEXT_FILE_PERMISSION_STRING) = (int32)mode;

   ptr = (FILE *)(*(volatile int32*)SIMEXT_FOPEN_REQUEST);
   return(ptr);
}

int fclose(FILE *stream)
{
   int32 l_handle_bk;
   int return_value;

   l_handle_bk = *((volatile int32*)SIMEXT_FILE_PTR);
   *(volatile int32*)SIMEXT_FILE_PTR = (int32)stream;
   return_value = *(volatile int32*)SIMEXT_FCLOSE_REQUEST;
   *((volatile int32*)SIMEXT_FILE_PTR) = l_handle_bk;

   return(return_value);
}

// output functions
int _write(int handle, char *buffer, unsigned int length)
{
   int32 l_handle_bk;
   int32 i;

   if ((handle == (int)stdout) || (handle == (int)stderr))
   {
      handle =  *((volatile int32*)SIMEXT_FILE_STDOUT);
   }

   l_handle_bk = *((volatile int32*)SIMEXT_FILE_PTR);
   *((volatile int32*)SIMEXT_FILE_PTR) = handle;
   for(i = 0; i < length; i++)
   {
      *((volatile int32*)SIMEXT_FILE_IO_WRITE) = *buffer++;
   }

   *((volatile int32*)SIMEXT_FILE_PTR) = l_handle_bk;
   return(i);
}

int fprintf(FILE *stream, const char *format,...)
{
   va_list args;
   int length;

   va_start(args,format);
   length = vsprintf(sprintf_buf, format, args);
   _write((int)stream, sprintf_buf, length);
   va_end(args);

   return(0);
}

int printf(const char *format,...)
{
   va_list args;
   int length;

   va_start(args,format);
   length = vsprintf(sprintf_buf, format, args);
   _write((int)stdout, sprintf_buf, length);
   va_end(args);

   return(0);
}

int fflush(FILE *stream)
{
   int32 i_handle_bk;

   if (stream != NULL)
   {
      i_handle_bk = *((volatile int32*)SIMEXT_FILE_PTR);
      if ((stream == stderr) || (stream == stdout))
      {
         *((volatile int32*)SIMEXT_FILE_PTR) = *((volatile int32*)SIMEXT_FILE_STDOUT);
      }
      else
      {
         *((volatile int32*)SIMEXT_FILE_PTR) = (int32)stream;
      }
      *((volatile int32*)SIMEXT_FFLUSH_REQUEST) = 1;
      *((volatile int32*)SIMEXT_FILE_PTR) = i_handle_bk;
   }
   return(0);
}

// input functions
int _read(int handle, char *buffer, unsigned int length)
{
   int32 l_handle_bk;
   int32 i;

   l_handle_bk = *((volatile int32*)SIMEXT_FILE_PTR);
   *((volatile int32*)SIMEXT_FILE_PTR) = handle;
   for(i = 0; i < length; i++)
   {
      *buffer++ = *((volatile char *)SIMEXT_FILE_IO_READ);
   }

   *((volatile int32*)SIMEXT_FILE_PTR) = l_handle_bk;
   return(i);

}

int fscanf(FILE *stream, const char *format, ...)
{
   va_list va_Args;
   char uca_FormatString[64];
   char *ucp_CurToken;
   int32 i_handle_bk;

   void *vptr;
   int  i_ScanfTypeBk;
   int  i_ScanfType;
   int  i_argc;

   i_argc = 0;

   strcpy(uca_FormatString, format);
   ucp_CurToken = uca_FormatString;
   ucp_CurToken = strtok(ucp_CurToken, " \t");

   va_start(va_Args,format);

   if (stream == NULL)
   {
      stream = (FILE *)(*(volatile int32*)SIMEXT_FILE_STDOUT);
   }

   i_handle_bk = *((volatile int32*)SIMEXT_FILE_PTR);
   *((volatile int32*)SIMEXT_FILE_PTR) = (int32)stream;

   i_ScanfTypeBk = *((volatile int32*)SIMEXT_SCANF_TYPE);

   do
   {
      i_ScanfType = PERCENT_s;
      if (strcmp(ucp_CurToken, "%s") == 0)
      {
         vptr = (void *)va_arg(va_Args, char *);
      }
      else if (strcmp(ucp_CurToken, "%d") == 0)
      {
         vptr = (void *)va_arg(va_Args, int *);
         i_ScanfType = PERCENT_d;
      }
      else if (strcmp(ucp_CurToken, "%x") == 0)
      {
         vptr = (void *)va_arg(va_Args, int *);
         i_ScanfType = PERCENT_x;
      }
      else if (strcmp(ucp_CurToken, "%[^\n]") == 0)
      {
         vptr = (void *)va_arg(va_Args, char *);
         i_ScanfType = PERCENT_rest_of_line;
      }
      else
      {
         printf("++%s++: is not supported yet\n", ucp_CurToken);
         va_arg(va_Args, void *);
         continue;
      }

      *((volatile int32 *)SIMEXT_SCANF_TYPE) = i_ScanfType;
      *((volatile int32 *)SIMEXT_SCANF_VAR_PTR) = (int32)vptr;       // scanf kicked off.
      if (*((volatile int32*)SIMEXT_SCANF_RETURN) == SCANF_EOF)
      {
         i_argc = EOF;
         break;
      }
      i_argc++;
   }
   while((ucp_CurToken = strtok(NULL, " \t")) != NULL);

   *((volatile int32*)SIMEXT_SCANF_TYPE) = i_ScanfTypeBk;
   *((volatile int32*)SIMEXT_FILE_PTR) = i_handle_bk;
   va_end(va_Args);

   return (i_argc);
}


// functions not implemented
void PrintNotImplemented(void)
{
   printf("this function is not implemented\n");
}

FILE *freopen(const char *filename, const char *mode, FILE *stream)
{
   PrintNotImplemented();
   return(NULL);
}


int remove(const char *filename)
{
   PrintNotImplemented();
   return(0);
}

int rename(const char *oldname, const char *newname)
{
   PrintNotImplemented();
   return(0);
}

FILE *tmpfile(void)
{
   PrintNotImplemented();
   return(NULL);
}

char *tmpnam(char s[L_tmpnam])
{
   PrintNotImplemented();
   return(NULL);
}

int setvbuf(FILE *stream, char *buf, int mode, size_t size)
{
   PrintNotImplemented();
   return(0);
}

void setbuf(FILE *stream, char *buf)
{
   PrintNotImplemented();
}

int vfprintf(FILE *stream, const char *format, va_list arg)
{
   PrintNotImplemented();
   return(0);
}

int vprintf(const char *format, va_list arg)
{
   PrintNotImplemented();
   return(0);
}

int scanf(const char *format, ...)
{
   PrintNotImplemented();
   return(0);
}

int sscanf(const char *s, const char *format, ...)
{
   PrintNotImplemented();
   return(0);
}

int fgetc(FILE *stream)
{
   PrintNotImplemented();
   return(0);
}

int fputc(int c, FILE *stream)
{
   PrintNotImplemented();
   return(0);
}

char *fgets(char *, int n, FILE *stream)
{
   PrintNotImplemented();
   return(NULL);
}

int getc(FILE *stream)
{
   PrintNotImplemented();
   return(0);
}

char *gets(char *)
{
   PrintNotImplemented();
   return(NULL);
}

int putc(int c, FILE *stream)
{
   PrintNotImplemented();
   return(0);
}

int puts(const char *s)
{
   PrintNotImplemented();
   return(0);
}

int ungetc(int c, FILE *stream)
{
   PrintNotImplemented();
   return(0);
}

size_t fread(void *ptr, size_t size, size_t nobj, FILE *stream)
{
   PrintNotImplemented();
   return(0);
}

size_t fwrite(const void *ptr, size_t size, size_t nobj, FILE *stream)
{
   PrintNotImplemented();
   return(0);
}

int fseek(FILE *stream, long offet, int origin)
{
   PrintNotImplemented();
   return(0);
}

long ftell(FILE *stream)
{
   PrintNotImplemented();
   return(0);
}

void rewind(FILE *stream)
{
   PrintNotImplemented();
}

int fgetpos(FILE *stream, fpos_t *ptr)
{
   PrintNotImplemented();
   return(0);
}

int fsetpos(FILE *stream, const fpos_t *ptr)
{
   PrintNotImplemented();
   return(0);
}

