/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2007 Aware Incorporated
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------
*
*     All Rights Reserved
*
*     40, Middlesex Turnpike , Bedford, MA 01730-1413
*     Phone (617) 276 - 4000 ; Fax (617) 276 - 4001
*
*     nmp.c
*
*     ADSL Configuration and Management protocol using the New CMV format
*
*-------------------------------------------------------------------
*/

#ifndef NMP_C
#define NMP_C

#define IN_NMP_C

/*******************************************************************
*
*     Include Files
*
*******************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include "common.h"
#include "gdata.h"
#include "nmp.h"
#include "mp.h"
#include "cmv.h"
#include "codeswap.h"
#include "hmp_data.h"
#include "dsp_op.h"
#include "string.h"
#include "dsp_regs_62.h"
#include "fifo.h"
#include "LL_IOF.h"


#include "xdma.h"

/*******************************************************************
*
*     Define Variables
*
*******************************************************************/

/* =============================================== */
/* MP Message Structure                      */
/* =============================================== */
/*
**
**          typedef struct {
**             int16 FunctionOpcode;
**             int16 PayloadSize;
**             int16 GroupField;
**             int16 AddrField;
**             int16 IndexField;
**             int16 PayLoad[12];
**          } MPStruct;
**
**
*/


HerculesMPStruct_t HMP_RxBuffer;

HMP_AutoMsgQueue_t gt_AutoMsgQueue;

// the order of entry in this table is very important because
// it assumes the dictionary look-up algorithm will do a top
// down search.

uint16 NEW_CMV_Dictionary[NEW_DICT_SIZE] =
{// Groupfield  AddrRange                 OffsetRange       BlockType            ReadWriteAccess
   CNTLGroup,   0,   CNTLARRAY_SIZE-1,    0, 1,             NewCNTLType,         WRITE_ACCESS,

   STATGroup,   0,   0,                   0, STAT_0_SIZE,   NewSTAT_0_TypeI,     READ_ACCESS,
   STATGroup,   1,   1,                   0, STAT_1_SIZE,   NewSTAT_1_TypeI,     READ_ACCESS,
   STATGroup,   5,   5,                   0, STAT_5_SIZE,   NewSTAT_5_TypeI,     READ_ACCESS,
   STATGroup,   0,   STATARRAY_SIZE-1,    0, 0,             NewSTATType,         READ_ACCESS,

   iNFOGroup,   0,   INFOMAP_SIZE-1,      0, 0x7fff,        NewINFOTypeI,        READ_WRITE_ACCESS,
   iNFOGroup,   200, 200+INFO2MAP_SIZE-1, 0, 0x7fff,        NewINFO2TypeI,       READ_WRITE_ACCESS,
   TESTGroup,   25,  25,                  0, TEST_25_SIZE,  NewTEST_25_TypeI,    READ_WRITE_ACCESS,
   TESTGroup,   0,   TESTARRAY_SIZE-1,    0, 0,             NewTESTType,         READ_WRITE_ACCESS,

   OPTNGroup,   0,   0,                   0, OPTN_0_SIZE,   NewOPTN_0_TypeI,     READ_WRITE_ACCESS,
   OPTNGroup,   2,   2,                   0, OPTN_2_SIZE,   NewOPTN_2_TypeI,     READ_WRITE_ACCESS,
   OPTNGroup,   4,   4,                   0, OPTN_4_SIZE,   NewOPTN_4_TypeI,     READ_WRITE_ACCESS,
   OPTNGroup,   28,  28,                  0, OPTN_28_SIZE,  NewOPTN_28_TypeI,    READ_WRITE_ACCESS,
   OPTNGroup,   29,  29,                  0, OPTN_29_SIZE,  NewOPTN_29_TypeI,    READ_WRITE_ACCESS,
   OPTNGroup,   0,   OPTNARRAY_SIZE-1,    0, 0,             NewOPTNType,         READ_WRITE_ACCESS,

   RATEGroup,   0,   RATEMAP_SIZE-1,      0, 0x7fff,        NewRATETypeI,        READ_ACCESS,
   PLAMGroup,   0,   PLAMMAP_SIZE-1,      0, 6,             NewPLAMTypeI,        READ_ACCESS,
   CNFGGroup,   0,   CNFGMAP_SIZE-1,      0, 0x7fff,        NewCNFGTypeI,        READ_WRITE_ACCESS,
   MONIGroup,   0,   MONIMAP_SIZE-1,      0, 127,           NewMONITypeI,        READ_WRITE_ACCESS,
   CNTRGroup,   0,   CNTRMAP_SIZE-1,      0, 0x7fff,        NewCNTRTypeI,        READ_WRITE_ACCESS,
   ALGSGroup,   0,   ALGSMAP_SIZE-1,      0, 0,             NewALGSTypeI,        READ_WRITE_ACCESS,
   SELTGroup,   0,   SELTMAP_SIZE-1,      0, 0x7fff,        NewSELTTypeI,        READ_WRITE_ACCESS,
   DSLGroup,    4,   4,                   0, DSL_4_SIZE,    NewDSL_4_TypeI,      WRITE_ACCESS,            //XDSLRTFW-3705 (Start_End)
   DSLGroup,    0,   DSLMAP_SIZE - 1,     0, 0x7fff,        NewDSLTypeI,         READ_WRITE_ACCESS
};

int16 *NewBlockNameArrayPtr;

// this table must be initialized with the exact order
// that the NewXXXXType being defined; In other words,
// this table is indexed by NewXXXXType.
int16 *NewCMVBlockNamePtr[] =
{
   // Note the pointers for the indirect CMV groups
   // are really type (int16 **) rather than (int16 *).
   &CNTLArray[0],
   (int16 *)(void *) &STAT_0_Map[0],
   (int16 *)(void *) &STAT_1_Map[0],
   (int16 *)(void *) &STAT_5_Map[0],
   &STATArray[0],
   (int16 *)(void *) &INFOMap[0],
   (int16 *)(void *) &INFO2Map[0],
   (int16 *)(void *) &TEST_25_Map[0],
   &TESTArray[0],
   (int16 *)(void *) &OPTN_0_Map[0],
   (int16 *)(void *) &OPTN_2_Map[0],
   (int16 *)(void *) &OPTN_4_Map[0],
   (int16 *)(void *) &OPTN_28_Map[0],
   (int16 *)(void *) &OPTN_29_Map[0],
   &OPTNArray[0],
   (int16 *)(void *) &RATEMap[0],
   (int16 *)(void *) &PLAMMap[0],
   (int16 *)(void *) &CNFGMap[0],
   (int16 *)(void *) &MONIMap[0],
   (int16 *)(void *) &CNTRMap[0],
   (int16 *)(void *) &ALGSMap[0],
   (int16 *)(void *) &SELTMap[0],
   (int16 *)(void *) &DSL_4_Map[0],      //XDSLRTFW-3705 (Start_End)
   (int16 *)(void *) &DSLMap[0]
};
int16 gs_MPReturnOpcode;
int16 gs_MPFunctionOpcode;


/*^^^
*-------------------------------------------------------------------------------------
*
*     Prototype:
*        void ProcessTxMailbox(void)
*
*     Abstract:
*        This function coordinates messages from Socrates to the ME.  MP messages,
*     Codeswap requests, and FastDataRead requests are all handled by this function.
*
*
*     Parameters:  None
*
*     Returns:    None
*
*     Notes:
*
*-------------------------------------------------------------------
^^^*/
void ProcessTxMailbox(void)
{
   AutoMsgQueueEntry_t t_NewAutoMsg;
   int32 l_InterruptStat;

   // XDSLRTFW-2629 (Start_End)
   l_InterruptStat = GetDspReg(ARC_INT_STAT_REG);

   /* Priority of codeswap increased to reduce the time of queuing */
   if ((guc_CodeSwapMsgReq != 0) && LockXdmaBus())
   {
      /* then send it and clear the request bit */
      SendCodeSwapRequest();
      guc_CodeSwapMsgReq = 0;
      // gt_SwapControl.uc_HwStatus = SWAP_HW_ACTIVE;
   }

   /* Check if the previous mailbox access is complete */
   if (TxMailBoxPending() == 0)
   {
      if (guc_MPMsgRespReq != 0)
      {
         // XDSLRTFW-2629 (Start)
         // If the Mailbox query does not query a SDRAM variable
         // then give the response to the host.
         if (gft_Mailbox_thru_SDRAM == FALSE)   // If IIBRAM variable requested
         {
            // then send it and clear the request bit
            NewMPSendMessage(gs_MPReturnOpcode, 1);
            guc_MPMsgRespReq = 0;
         }
         else
         {
            // If the SDRAM variable is being queried by the
            // host or mailbox, we need to configure XDMA to copy the
            // data from the SDRAM to IIBRAM.

            // If we were not able configure the XDMA registers earlier,
            // we are configuring it here
            if (gft_XDMA_Mailbox_Busy == TRUE)
            {
               guc_EVB_DebugBuff_flag |= 0x2;
               if (PollForCodeSwapDone(VDSL_WRITE_DATA_TO_SRAM_DM_SWAPPAGE, guc_OffChipRequestHandle) == SWAP_DONE)
               {
                  gta_BAR15LookUpTable[OFF_CHIP_MAILBOX][OFF_CHIP_SOURCE_INDEX] = (int32)gl_Source_Address;
                  gta_BAR15LookUpTable[OFF_CHIP_MAILBOX][OFF_CHIP_DEST_INDEX] = (int32)gl_Dest_Address;
                  gta_BAR15LookUpTable[OFF_CHIP_MAILBOX][OFF_CHIP_LENGTH_INDEX] = gus_Length;

                  FreeSwapHandle(&guc_OffChipRequestHandle);
                  guc_OffChipRequestHandle = RequestSwapOffChip(VDSL_WRITE_DATA_TO_SRAM_DM_SWAPPAGE, SWAP_TIMING_OFF,OFF_CHIP_MAILBOX);
                  gft_XDMA_Mailbox_Busy = FALSE;
                  gft_Mailbox_XDMA_Triggered = TRUE;
               }
               else
               {
                  // We are checking for a maximum of 256 times and if we are not
                  // able to give a response within that period, we give a NACK to
                  // mailbox query and do a intended linkdrop/exception.
                  gul_XDMA_Busy_Cnt++;
                  // Debug code to analyze codeswap requests (commented out by default in order to avoid flooding Tracee with events which are only required for specific debugging)
                  //DSH_SendEvent(DSH_EVT_MAILBOX_BUSY,sizeof(uint32),&gul_XDMA_Busy_Cnt);
                  if (gul_XDMA_Busy_Cnt == 256)
                  {
                     gs_MPReturnOpcode = D2H_ERROR_RESOURCE_OCCUPIED;
                     // then send it and clear the request bit
                     NewMPSendMessage(gs_MPReturnOpcode, 1);
                     guc_MPMsgRespReq = 0;
                     gft_Mailbox_thru_SDRAM = FALSE;
                     guc_EVB_DebugBuff_flag &= (~0x2);
                     gul_XDMA_Busy_Cnt = 0;
                     EnterFailStates(E_CODE_MAILBOX_BUSY);
                  }
               }
            }
            else
            {
               // If the XDMA is triggered, we check whether the DMA
               // is completed successfully or not.
               if (gft_Mailbox_XDMA_Triggered == TRUE)
               {
                  if (PollForCodeSwapDone(VDSL_WRITE_DATA_TO_SRAM_DM_SWAPPAGE, guc_OffChipRequestHandle) == SWAP_DONE)
                  {
                     // then send it and clear the request bit
                     NewMPSendMessage(gs_MPReturnOpcode, 1);
                     guc_MPMsgRespReq = 0;
                     gft_Mailbox_XDMA_Triggered = FALSE;
                     gft_Mailbox_thru_SDRAM = FALSE;
                     guc_EVB_DebugBuff_flag &= (~0x2);
                  }
               }
            }
         }
         // XDSLRTFW-2629 (End)
      }
      // else if there is an autonomuos message waiting
      // Before sending an autonomous message, we check if we have any request
      // from the host for any query.
      // XDSLRTFW-2629 (Start)
      else if ((gft_Mailbox_thru_SDRAM == FALSE) && (!(l_InterruptStat & ARC_INT_MSGAV_MASK)))
      {
         // The pointer in the buffer/fifo "gt_AutoMsgQueue" gets incremented whenever there is a
         // new autonomous message. But if the Mailbox is not free (due to whatever reason), we
         // do not send out the autonomous message. But since the pointer would have increased,
         // the DSL FW assumes the autonomous message has been sent out. But in reality, we would
         // have not sent and we will never send the message.
         if (GetNextAutoMsgQueueEntry(&t_NewAutoMsg) == AUTO_MSG_QUEUE_OPERATION_SUCCESS)
         {
            // then send it and clear the request bit
#ifdef DEBUG_AUTO_MSG
            printf("Send Auto Message: 0x%x, 0x%x\n", t_NewAutoMsg.t_MsgHeader.us_HmpMsgWord0,
            t_NewAutoMsg.t_MsgHeader.us_HmpMsgWord1);
#endif
            NewMPSendAutoMessage(&t_NewAutoMsg);
         }
      }
      // XDSLRTFW-2629 (End)
   }

}


uint16 NMP_IsDebugMsgPending(void)
{
   return gt_DebugStreamMsg.us_DbgStreamLength;
}

int32 NMP_SendDebugMsg(uint16 us_StreamId, uint32 ul_SymCount, uint16 us_Crc16, uint16 us_StreamStatus, uint16 us_Length, uint16 * us_pPayload)
{

    gt_DebugStreamMsg.us_DbgStreamId          = us_StreamId;
    gt_DebugStreamMsg.us_DbgStreamSymCnt      = ul_SymCount;
    gt_DebugStreamMsg.us_DbgStreamCrc16       = us_Crc16;
    gt_DebugStreamMsg.us_DbgStreamStatus      = us_StreamStatus;
    gt_DebugStreamMsg.us_DbgStreamLength      = us_Length;
    gt_DebugStreamMsg.pus_DbgStreamPayload    = us_pPayload;

    // XDSLRTFW-2701 The check to avoid E_CODE_BKGD_FIFO_ADD_EXCEPTION is done in the calling function
    AddFunctionToBkgdFifo((PtrToBkgdFunc)NMP_BgService) ;

    return 0;
}


void NMP_BgService(void)
{
   uint32 ul_int_status;
   // first check if we have a debug stream message pending
   if(NMP_IsDebugMsgPending())
   {
      // avoid that gackground task 'mail box check' gets interrupted by foreground and we get corrupted messages in mail box
      disable1_save(&ul_int_status);
      // then check if mailbox is available (previous outgoing message already served)
      if (TxMailBoxPending() == TRUE)
      {
         //busy try again later
          gus_RequeueBGFunction |= DSH_REQUEUE_NMP_BG_SERVICE;
          gus_Dbg_RequeueCnt++;
      }
      else
      {
         uint16 us_Length = gt_DebugStreamMsg.us_DbgStreamLength;

         // Mailbox header
         __gt_Arc2MeMboxMsg.t_MsgHeader.us_HmpMboxCode = AUTONOMOUS_MSG_EVENT;                        // Mailbox code
         __gt_Arc2MeMboxMsg.t_MsgHeader.us_HmpMsgWord0 =(0x4000) | (D2H_CMV_READ_REPLY << HMP_WORD0_OPCODE_SHIFT);    // Functional code
         __gt_Arc2MeMboxMsg.t_MsgHeader.us_HmpMsgWord1 = (uint16)((us_Length + 12) >> 1);             // length of payload in 16bit words

         // Message Header
         __gt_Arc2MeMboxMsg.t_MsgHeader.us_HmpMsgWord2 = AUTO_MSG_INF118_HEADER_2 ;                   // MessageId
         __gt_Arc2MeMboxMsg.t_MsgHeader.us_HmpMsgWord3 = AUTO_MSG_INF118_HEADER_3 ;                   // Offset
         __gt_Arc2MeMboxMsg.t_MsgHeader.us_HmpMsgWord4 = (uint16)((us_Length + 12) >> 1);             // Length of payload in 16bit words

         // Debug Stream
         __gt_Arc2MeMboxMsg.usa_HmpPayLoad[0] = (uint16)((us_Length+10));   // Length of following bytes (debug stream +10 header bytes)

         // Debug Stream Header (10byte)
         __gt_Arc2MeMboxMsg.usa_HmpPayLoad[1] = gt_DebugStreamMsg.us_DbgStreamId;
         __gt_Arc2MeMboxMsg.usa_HmpPayLoad[2] = gt_DebugStreamMsg.us_DbgStreamStatus;
         __gt_Arc2MeMboxMsg.usa_HmpPayLoad[3] = (uint16)(gt_DebugStreamMsg.us_DbgStreamSymCnt);
         __gt_Arc2MeMboxMsg.usa_HmpPayLoad[4] = (uint16)(gt_DebugStreamMsg.us_DbgStreamSymCnt >> 16);
         __gt_Arc2MeMboxMsg.usa_HmpPayLoad[5] = gt_DebugStreamMsg.us_DbgStreamCrc16;

         memcpy(&__gt_Arc2MeMboxMsg.usa_HmpPayLoad[6], gt_DebugStreamMsg.pus_DbgStreamPayload, us_Length);

         SetDspReg(ARC_ARC2ME_INT_REG, ARC_ARC2ME_MSGAV_MASK);    // set the mailbox interrupt
         gt_DebugStreamMsg.us_DbgStreamLength      = 0;
      }
      // restore interrupts
      restore1_save(ul_int_status);
   }
}




/*^^^
*-------------------------------------------------------------------
*
*     Prototype:
*   int16  NewDecodeCMVBlockName(int16 *, int16 *);
*
*     Abstract:
*   This function reads the message memory access address field,
*   decodes it into a CMV Block Name and Offset, determines if the
*   BlockName. Offset variable is read-only, write-only, or read/write, and
*   determines if the offset is within the allowable range for the Block Name.
*
*     Parameters:
*        int16 BlockNameType:       Function fills in the CMV block name.
*        int16 ReadWriteStatus:        Function fills in the Read/write access of BlockName.Offset.
*
*     Returns:
*        0 if no errors or Memory Access Error Message Subtype number.
*
*     Notes:
*
*-------------------------------------------------------------------
^^^*/

int16 NewDecodeCMVBlockName(uint16 *pus_BlockNameType, uint16 *pus_ReadWriteStatus, uint16 *pus_StartAddr)
{
   int16 us_DictIndex;
   uint16 us_CMVGroupName,us_AddrField, us_OffsetField;
   int16 MemoryAccessErrorType;
   int16 us_Length;

   /* Assume message will be decoded successfully. */

   us_CMVGroupName = HMP_RxBuffer.t_MsgHeader.us_HmpMsgWord2 & HMP_WORD2_GROUP_MASK;

   /* Grab CMV Block Name Offset. */
   us_AddrField = HMP_RxBuffer.t_MsgHeader.us_HmpMsgWord2 >> HMP_WORD2_ADDRESS_SHIFT;

   us_OffsetField = HMP_RxBuffer.t_MsgHeader.us_HmpMsgWord3;

   us_Length = (HMP_RxBuffer.t_MsgHeader.us_HmpMsgWord4 & HMP_WORD4_LENGTH_MASK) - 1;

   /* Check the CMV "dictionary." */

   // presume search will fail
   MemoryAccessErrorType = UNKNOWN_ADDRESS;     /* Address MAY not be valid. */

   for (us_DictIndex = 0; us_DictIndex <= NEW_DICT_SIZE; us_DictIndex += NEW_DICT_ENTRY_LENGTH )
   {

      // check group name
      if (us_CMVGroupName != NEW_CMV_Dictionary[us_DictIndex])
      {
         continue;                              /* Continue search. */
      }

      // check start address
      if (us_AddrField < NEW_CMV_Dictionary[us_DictIndex + 1])
      {
         continue;                              /* Continue search. */
      }

      // check end address
      if (us_AddrField > NEW_CMV_Dictionary[us_DictIndex + 2])
      {
         continue;                              /* Continue search. */
      }

      // check start offset
      if (us_OffsetField < NEW_CMV_Dictionary[us_DictIndex + 3])
      {
         continue;                              /* Continue search. */
      }

      // check end offset
      if (us_OffsetField > NEW_CMV_Dictionary[us_DictIndex + 4])
      {
         continue;                              /* Continue search. */
      }

      // check range on block operation
      if (NEW_CMV_Dictionary[us_DictIndex + 5] & INDIRECT_CMV_TYPE_MASK)
      {
         if ((us_Length + us_OffsetField) > NEW_CMV_Dictionary[us_DictIndex + 4])
         {
            break;         // illegal size for block operation; break out.
         }
      }
      else
      {
         if ((us_Length + us_AddrField) > NEW_CMV_Dictionary[us_DictIndex + 2])
         {
            break;         // illegal size for block operation; break out.
         }
      }

      /* Set candidate CMV Block Name type. */
      *pus_BlockNameType = NEW_CMV_Dictionary[us_DictIndex + 5];

      /* CMV dictionary entry matches, set read/write status, clear error indicator, and stop search. */
      *pus_ReadWriteStatus = NEW_CMV_Dictionary[us_DictIndex + 6];
      *pus_StartAddr = NEW_CMV_Dictionary[us_DictIndex + 1];

      MemoryAccessErrorType = 0;

      break;
   }

   return(MemoryAccessErrorType);
}  /* DecodeCMVBlockName */



/*^^^
*----------------------------------------------------------------------------------
*
*      Prototype:
*         int16  NewMPHandleMessage(int16 mailbox);
*
*      Abstract:
*         This function receives the MP message and performs any required
*         variabe access. This function also sends a response (ACK) message
*         back to the sender. The hardware layer of the sender is handled
*         in the hardware layer.
*
*      Input Parameters:
*         int16 mailbox - Not used.
*
*      Returns:
*         int16 :    TRUE   If a message was received which requires modem intervention.
*                     FALSE   If no intervention is required
*
*      Notes:
*
*-------------------------------------------------------------------------------------
^^^*/
int16 NewMPHandleMessage(void)
{
   // output
   uint16 ReturnOpcode;
   int16 OperationRequired;

   uint16 FunctionOpcode;
   uint16 us_Length, us_ReceivedPayloadSize, us_PayloadSizeFromLength;
   uint16 us_BlockNameType, us_ReadWriteStatus, us_StartAddr;
   uint16 us_AddrField, us_OffsetField;
   uint16 us_BitSize;
   uint32 l_addr_32bit=0;

   //int16 i;
   int16 MemAccessError;
   void *p_Src=NULL, *p_Dst=NULL;


   // extract fields from RxMsg
   FunctionOpcode = (HMP_RxBuffer.t_MsgHeader.us_HmpMsgWord0 >> HMP_WORD0_OPCODE_SHIFT) & HMP_WORD0_OPCODE_MASK_AFTER_SHIFT;
   us_BitSize = HMP_RxBuffer.t_MsgHeader.us_HmpMsgWord0 >> HMP_WORD0_BITSIZE_SHIFT;
   us_ReceivedPayloadSize = HMP_RxBuffer.t_MsgHeader.us_HmpMsgWord1 & HMP_WORD1_SIZE_MASK;
   us_AddrField = HMP_RxBuffer.t_MsgHeader.us_HmpMsgWord2 >> HMP_WORD2_ADDRESS_SHIFT;
   us_OffsetField = HMP_RxBuffer.t_MsgHeader.us_HmpMsgWord3;
   us_Length = HMP_RxBuffer.t_MsgHeader.us_HmpMsgWord4 & HMP_WORD4_LENGTH_MASK;
   us_Length = (us_Length << us_BitSize);      // in bytes
   us_PayloadSizeFromLength = (us_Length + 1)/2;

   // clear the PayLoadSize in Rx buffer for either write command or invalid command
   HMP_RxBuffer.t_MsgHeader.us_HmpMsgWord1 &= (~HMP_WORD1_SIZE_MASK);

   // default outputs
   ReturnOpcode = FunctionOpcode ^ 1;  // Invert LSB of opcode to form default return opcode.
   OperationRequired = FALSE;

   // validate message
   if ((us_PayloadSizeFromLength > HMP_MBOX_PAYLOAD_SIZE) || (us_BitSize > HMP_RW_DWORD_DATA))
   {
      ReturnOpcode = D2H_ERROR_ILLEGAL_PAYLOAD_SIZE;
      goto Finish;
   }

   if ((FunctionOpcode == H2D_CMV_READ) || (FunctionOpcode == H2D_CMV_WRITE))
   {
      /* Decode CMV Block Name & Offset; validate Offset is in range and determine read/write status. */
      MemAccessError = NewDecodeCMVBlockName(&us_BlockNameType,&us_ReadWriteStatus, &us_StartAddr);
      /* If error found, send message to ME. */
      if ((MemAccessError > 0) || (us_BitSize != HMP_RW_WORD_DATA))
      {
         ReturnOpcode = D2H_ERROR_CMV_UNKNOWN;
      }
      else
      {

         int16 *CMVPtr;

         CMVPtr = (int16 *) NewCMVBlockNamePtr[(us_BlockNameType & ~INDIRECT_CMV_TYPE_MASK)];

         if (us_BlockNameType & INDIRECT_CMV_TYPE_MASK)
         {
            // If indirect reference, we have a table of pointers.
            CMVPtr = (int16 *)(void *) (((int16 **)(void *) CMVPtr) + us_AddrField - us_StartAddr);
            CMVPtr = *(int16 **)(void *) CMVPtr;
            if (CMVPtr == NULL)
            {
               // This address entry not loaded yet, clear out size and return error.
               ReturnOpcode = D2H_ERROR_CMV_UNINITIALIZED_ENTRY;
               goto Finish;
            }
            CMVPtr = CMVPtr + us_OffsetField;
         }
         else
         {
            CMVPtr += us_AddrField;
         }
         l_addr_32bit = (int32)CMVPtr;
      }
   }
   else
   {
      l_addr_32bit = (((uint32)HMP_RxBuffer.t_MsgHeader.us_HmpMsgWord2) << 16) | HMP_RxBuffer.t_MsgHeader.us_HmpMsgWord3;
   }

   switch(FunctionOpcode)
   {
      case H2D_CMV_READ:
         if (us_ReadWriteStatus == WRITE_ACCESS)
         {
            /* If BlockName.Offset is WRITE-ONLY, then send message to ME. */
            ReturnOpcode = D2H_ERROR_CMV_WRITE_ONLY;
         }
         // intentionally fall thru

      case H2D_DEBUG_READ_DM:
      case H2D_DEBUG_READ_PM:
         if (us_ReceivedPayloadSize !=  0)
         {
            ReturnOpcode = D2H_ERROR_CMV_UNKNOWN;
         }
         else
         {
            p_Src = (void *)l_addr_32bit;
            p_Dst = (void *)(&HMP_RxBuffer.usa_HmpPayLoad[0]);
            HMP_RxBuffer.t_MsgHeader.us_HmpMsgWord1 |= us_PayloadSizeFromLength;
         }
         break;

         /* =================================================================  */
         /*                                                     */
         /* CMV WRITE                                           */
         /*                                                     */
         /* =================================================================  */

      case H2D_CMV_WRITE:
         if (us_ReadWriteStatus == READ_ACCESS)
         {
            /* If BlockName.Offset is READ-ONLY, then send message to ME. */
            ReturnOpcode = D2H_ERROR_CMV_READ_ONLY;
         }
         /* Set variable to signal the modem application */
         else if (us_BlockNameType == NewCNTLType)
         {
            if (us_AddrField == CNTL_ModemControl)
            {
               // XDSLRTFW-2186(Start)

               // [ATTENTION!]Below piece of  code  allows CNTL_0_0_x to  write back cmv at any point of time after Link initiated.
               // After return ,function call will send out Message to  MEI and MEI ACK with write back option to FW.
               // Below implementation is adopted to  keep similar implementation like ADSL.

               p_Src = (void *)(&HMP_RxBuffer.usa_HmpPayLoad[0]);

               p_Dst = (void *)l_addr_32bit;

               OperationRequired = us_AddrField + 1;        // msg is valid now for CNTL_0_0_x  write operation
               gs_ModemOperationRequiredShadow = OperationRequired;
               break;
               // XDSLRTFW-2186(End)
            }
            else if (us_AddrField == CNTL_Control1)
            {
               OperationRequired = us_AddrField + 1;       // potentially if msg is valid
               gs_ModemOperationRequiredShadow = OperationRequired;

            }
         }
         // intentionally fall thru

      case H2D_DEBUG_WRITE_DM:
      case H2D_DEBUG_WRITE_PM:
         if (us_PayloadSizeFromLength !=  us_ReceivedPayloadSize)
         {
            ReturnOpcode = D2H_ERROR_ILLEGAL_PAYLOAD_SIZE;
            OperationRequired = FALSE;       // undo setting from previous step
         }
         else
         {
            p_Src = (void *)(&HMP_RxBuffer.usa_HmpPayLoad[0]);
            p_Dst = (void *)l_addr_32bit;
         }
         break;

      default:
         ReturnOpcode = D2H_ERROR_OPCODE_UNKNOWN;
         break;
   }  /* switch (FunctionOpcode) */

   // payload handling
   if (ReturnOpcode == (FunctionOpcode^1))
      // If no error, then read/write data
   {
      if (us_Length > 0)
      {
         // XDSLRTFW-2629 (Start)
         // We are checking if the query is requesting any SDRAM variable.
         if ((((uint32)p_Dst >= SRAM_START_ADDR) && ((uint32)p_Dst <= SRAM_END_ADDR)) || (((uint32)p_Src >= SRAM_START_ADDR) && ((uint32)p_Src <= (int32) SRAM_END_ADDR)))
         {
            gft_Mailbox_thru_SDRAM = TRUE;   // Set a Flag
            if (((FunctionOpcode == H2D_CMV_READ) || (FunctionOpcode == H2D_DEBUG_READ_DM) || (FunctionOpcode == H2D_DEBUG_READ_PM)) ||    // Reading from SDRAM
                  ((FunctionOpcode == H2D_CMV_WRITE) || (FunctionOpcode == H2D_DEBUG_WRITE_DM) || (FunctionOpcode == H2D_DEBUG_WRITE_PM)))   // Writing into SDRAM
            {
               guc_EVB_DebugBuff_flag |= 0x2;
               if (PollForCodeSwapDone(VDSL_WRITE_DATA_TO_SRAM_DM_SWAPPAGE, guc_OffChipRequestHandle) == SWAP_DONE)
               {
                  gta_BAR15LookUpTable[OFF_CHIP_MAILBOX][OFF_CHIP_SOURCE_INDEX] = (int32)p_Src;
                  gta_BAR15LookUpTable[OFF_CHIP_MAILBOX][OFF_CHIP_DEST_INDEX] = (int32)p_Dst;
                  gta_BAR15LookUpTable[OFF_CHIP_MAILBOX][OFF_CHIP_LENGTH_INDEX] = us_Length;
                  gft_Mailbox_XDMA_Triggered = TRUE;

                  // Free handle for offchip request
                  FreeSwapHandle(&guc_OffChipRequestHandle);
                  guc_OffChipRequestHandle = RequestSwapOffChip(VDSL_WRITE_DATA_TO_SRAM_DM_SWAPPAGE, SWAP_TIMING_OFF,OFF_CHIP_MAILBOX);
               }
               else   // If the XDMA is busy, we need to store the request details into other location and trigger XDMA later
               {
                  gl_Source_Address = (int32)p_Src;
                  gl_Dest_Address = (int32)p_Dst;
                  gus_Length = us_Length;
                  gft_XDMA_Mailbox_Busy = TRUE;
                  gul_XDMA_Busy_Cnt = 0;        // Reset XDMA Busy counter to start counting up
               }
            }
         }
         else   // If IIBRAM vriable is requested
         {
            memcpy(p_Dst, p_Src, us_Length);
         }
      }
      //XDSLRTFW-3705 (Start)
      //Special handling for DSL 4 - AFE Read, AFE Write
      if (us_BlockNameType == NewDSL_4_TypeI)
      {
         uint16 us_AfeRegAddr, us_AfeRegData, us_FcsiInterface, us_DummyParam;

         //AFERegAddr format -> Refer to "CMD_DBG_AFE_Read" in MCAT ver 3.1 or above
         //  AFERegAddr[15:14] -> FCSI Selector; Selects one of the Full Custom Serial Interfaces (FCSI) in VRX51x.
         //    Bit#15  Bit#14   Description
         //      0       0       FCSI_NO Value for VRX318/VR218 AFE (mentioned just for information here)
         //      0       1       FCSI_CENTRAL: FCSI-IF to AFE for control path in VRX51x
         //      1       0       FCSI_DSL: FCSI-IF to AFE for data path in VRX51x
         //  AFERegAddr[13:0]  -> AFE register address
         us_AfeRegAddr = gt_AFEConfig.us_AFERegAddr;

         us_FcsiInterface  = ((us_AfeRegAddr & 0xC000) >> 14);
         if (us_FcsiInterface == (FCSI_DSL | FCSI_CENTRAL))
         {
            us_FcsiInterface = 0;
         }

         if (us_FcsiInterface != 0)
         {
            HMP_RxBuffer.usa_HmpPayLoad[0] = us_AfeRegAddr;

            //Mask out Bit#15  Bit#14 of AFE Reg address
            us_AfeRegAddr = (us_AfeRegAddr & 0x3FFF);
            if (gt_AFEConfig.us_AFERegOp == AFE_REG_RD_OP)
            {
               us_AfeRegData = VRX5AFE_FCSI_READ(us_FcsiInterface, us_AfeRegAddr, &us_DummyParam);

               HMP_RxBuffer.usa_HmpPayLoad[1] = us_AfeRegData ;

               HMP_RxBuffer.t_MsgHeader.us_HmpMsgWord1 |= 2;
            }
            else if (gt_AFEConfig.us_AFERegOp == AFE_REG_WR_OP)
            {
               VRX5AFE_FCSI_WRITE(us_FcsiInterface, us_AfeRegAddr, gt_AFEConfig.us_AFERegData);
            }
         }
      }
      //XDSLRTFW-3705 (End)
   }
   // XDSLRTFW-2629 (End)

   // We always send an acknowledgement.
   // Set flag in gs_TxMailboxState to notify ProcessTxMailbox function that an
   // MP message is ready to go out, and
   // use global variable to pass ReturnOpcode to the ProcessTxMailbox function.
   //
Finish:
   gs_MPReturnOpcode = ReturnOpcode;
   guc_MPMsgRespReq = 1;

   return OperationRequired;
}  /* NewMPHandleMessage */



// modulo increment
int16 IncrMsgQueueIndex(int16 s_Index)
{
   if (++s_Index >= AUTO_MSG_QUEUE_LENGTH)
   {
      return(0);
   }
   else
   {
      return(s_Index);
   }
}


/*^^^
*----------------------------------------------------------------------------------
*
*     Prototype:
*        int16 SubmitAutoMsg(AutoMsgPayLoadEntry_t *pt_PayLoadEntry, uint16 us_MailboxCode, uint16 us_MsgWord0
*              uint16 us_MsgWord1, uint16 us_MsgWord2, uint16 us_MsgWord3, uint16 us_MsgWord4)
*
*     Abstract:
*
*     Input Parameters:
*
*     Returns:
*
*     Notes: Initially the first parameter was of the type AutoMsgPayLoadEntry_t but to suppress or
*            remove the warning, it is changed to type void.
*
*-------------------------------------------------------------------------------------
^^^*/

// return QUEUE_ADDED or QUEUE_FULL
// Important!!!
// pt_PayLoadEntry->pus_PayLoad must contain address of a global or static global
// payload buffer if there is data in the payload. The reason is that
// the payload buffer has to exist at the time this queue entry being served
// by the GetNextAutoMsgQueueEntry() and then ProcessTxMailbox().

int16 SubmitAutoMsg(AutoMsgPayLoadEntry_t *pt_PayLoadEntry, uint16 us_MailboxCode, uint16 us_MsgWord0,
                    uint16 us_MsgWord1, uint16 us_MsgWord2, uint16 us_MsgWord3, uint16 us_MsgWord4)

{
   int16 s_CurWriteIndex, s_NewWriteIndex;
   int16 s_ReturnCode;
   uint32 ul_int_status;

   disable1_save(&ul_int_status);

   s_CurWriteIndex = gt_AutoMsgQueue.s_AutoMsgWriteIndex;
   s_NewWriteIndex = IncrMsgQueueIndex(s_CurWriteIndex);

   if (gt_AutoMsgQueue.s_AutoMsgReadIndex != s_NewWriteIndex)
   {
      // add new message to queue
      //gt_AutoMsgQueue.ta_AutoMsgArray[s_CurWriteIndex].t_MsgHeader = *pt_MsgHeader;
      gt_AutoMsgQueue.ta_AutoMsgArray[s_CurWriteIndex].t_MsgHeader.us_HmpMboxCode = us_MailboxCode;
      gt_AutoMsgQueue.ta_AutoMsgArray[s_CurWriteIndex].t_MsgHeader.us_HmpMsgWord0 = us_MsgWord0;
      gt_AutoMsgQueue.ta_AutoMsgArray[s_CurWriteIndex].t_MsgHeader.us_HmpMsgWord1 = us_MsgWord1;
      gt_AutoMsgQueue.ta_AutoMsgArray[s_CurWriteIndex].t_MsgHeader.us_HmpMsgWord2 = us_MsgWord2;
      gt_AutoMsgQueue.ta_AutoMsgArray[s_CurWriteIndex].t_MsgHeader.us_HmpMsgWord3 = us_MsgWord3;
      gt_AutoMsgQueue.ta_AutoMsgArray[s_CurWriteIndex].t_MsgHeader.us_HmpMsgWord4 = us_MsgWord4;

      // modify the payload to prevent over-writing of payload data
      pt_PayLoadEntry->uc_PayLoadSent = 0;
      gt_AutoMsgQueue.ta_AutoMsgArray[s_CurWriteIndex].pt_PayLoadEntry = pt_PayLoadEntry;

      gt_AutoMsgQueue.s_AutoMsgWriteIndex = s_NewWriteIndex;
      s_ReturnCode = AUTO_MSG_QUEUE_OPERATION_SUCCESS;

#ifdef DEBUG_AUTO_MSG
      printf("successfully submited opcode = 0x%x, size = 0x%x", us_MsgWord0, us_MsgWord1);
#endif
   }
   else
   {
      s_ReturnCode = AUTO_MSG_QUEUE_FULL;
   }

   restore1_save(ul_int_status);

   return(s_ReturnCode);
}

int16 GetNextAutoMsgQueueEntry(AutoMsgQueueEntry_t *pt_NewAutoMsg)
{
   int16 s_ReadIndex;
   int16 s_ReturnCode;
   uint32 ul_int_status;

   disable1_save(&ul_int_status);

   s_ReadIndex = gt_AutoMsgQueue.s_AutoMsgReadIndex;

   if (s_ReadIndex != gt_AutoMsgQueue.s_AutoMsgWriteIndex)
   {
      pt_NewAutoMsg->t_MsgHeader = gt_AutoMsgQueue.ta_AutoMsgArray[s_ReadIndex].t_MsgHeader;
      pt_NewAutoMsg->pt_PayLoadEntry = gt_AutoMsgQueue.ta_AutoMsgArray[s_ReadIndex].pt_PayLoadEntry;
      gt_AutoMsgQueue.s_AutoMsgReadIndex = IncrMsgQueueIndex(s_ReadIndex);
      s_ReturnCode = AUTO_MSG_QUEUE_OPERATION_SUCCESS;
   }
   else
   {
      s_ReturnCode = AUTO_MSG_QUEUE_EMPTY;
   }

   restore1_save(ul_int_status);

   return(s_ReturnCode);
}

#endif

