/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1995-2003 Aware Incorporated
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------
*
*       All Rights Reserved
*
*       40, Middlesex Turnpike , Bedford, MA 01730-1413
*       Phone (617) 276 - 4000 ; Fax (617) 276 - 4001
*
*       nmp.c
*
*       ADSL Configuration and Management protocol using the New CMV format
*
*-------------------------------------------------------------------
*/

#ifndef NMP_INIT_C
#define NMP_INIT_C
#define IN_NMP_INIT_C

/*******************************************************************
*
*       Include Files
*
*******************************************************************/

#include "gdata.h"
#include "nmp.h"
#include "mp.h"
#include "cmv.h"
#include "cmv_data.h"
#include "codeswap.h"
#include "hercules_memrymap.h"
#include "aux_regs.h"
#include <stdio.h>
#include <stdlib.h>
#include "string.h"
#include "LL_IOF.h"

#include "hmp_data.h"


void ModemMonitorInit(void);


/*^^^
*-------------------------------------------------------------------------------------
*
*     Function name: NewMPInitialize
*
*     Abstract:
*        This function initializes all hardware and required variables
*        for the specified MP source.
*
*       Parameters:     None
*
*       Returns:
*        int   :  Returns TRUE if initialization successful, else
*              FALSE is returned.
*
*       Notes:
*
*-------------------------------------------------------------------
^^^*/

int16 NewMPInitialize(void)
{


   // might not be really needed
   // clear the status register for the Rx Message
   SetDspReg(ARC_INT_STAT_REG, ARC_INT_MSGAV_MASK);            // no pending message from MEI to ARC

   // set up HMP_HEADER
   __gt_HmpHeader.us_HmpHeaderWord0 = (0x1 << 8) | HMP_VERSION;  //  1 mbox pair and version
   __gt_HmpHeader.us_HmpHeaderWord1 = (0x1 << 8) | HMP_DESC_SIZE;  //  1 mbox pair and version

   // set up first descriptor
   __gta_HmpMboxDescriptor[0].pl_Arc2MeMboxStart = (int32 *)(void *)&__gs_Arc2MeMboxCode;
   __gta_HmpMboxDescriptor[0].l_Arc2MeMboxLength = HMP_MBOX_SIZE; // num of 16-bit words
   __gta_HmpMboxDescriptor[0].pl_Me2ArcMboxStart = (int32 *)(void *)&__gs_Me2ArcMboxCode;
   __gta_HmpMboxDescriptor[0].l_Me2ArcMboxLength = HMP_MBOX_SIZE; // num of 16-bit words
   // set up HMP descriptor

   memset( &__gs_Me2ArcMboxCode, 0, 2*HMP_MBOX_SIZE);
   memset( &__gs_Arc2MeMboxCode, 0, 2*HMP_MBOX_SIZE);
   ModemMonitorInit();
   return(1);
}


/*^^^
*-------------------------------------------------------------------
*
*     Prototype:
*        void NewMPSetupReadyMessage(void)
*
*     Abstract:
*        This function prepares the MP Ready Message, which is
*     autonomously transmitted to the ME following reset as an indication
*     that the modem is ready to accept MP messages.
*
*        Most fields in the MP Modem Ready field are "don't care".  The
*     length is set to 1, the opcode is set to Modem Ready, and the rest
*     of the message is 0.
*
*       Parameters:
*           None
*
*       Returns:
*        None
*
*       Notes:
*
*-------------------------------------------------------------------
^^^*/

void NewMPSetupReadyMessage(void)
{

   gus_BootupResultCode = 0x0;    // successful, no errors.

   /* set size field to 1, FunctionOpcode to D2H_AUTONOMOUS_MODEM_READY_MSG */
   gt_ModemReadyPayLoad.uc_PayLoadLength = 1;
   gt_ModemReadyPayLoad.uc_PayLoadSent = 0;
   gt_ModemReadyPayLoad.pus_PayLoad= &gus_BootupResultCode;

   SubmitAutoMsg(&gt_ModemReadyPayLoad, AUTONOMOUS_MSG_EVENT, MODEM_READY_HEADER_0, MODEM_READY_HEADER_1,
                 MODEM_READY_HEADER_2, MODEM_READY_HEADER_3, MODEM_READY_HEADER_4);
}
#endif
