/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1995 Aware Incorporated
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------
*
*       All Rights Reserved
*
*       40, Middlesex Turnpike , Bedford, MA 01730-1413
*       Phone (617) 276 - 4000 ; Fax (617) 276 - 4001
*
*       nmp_plfm.c
*
*       ADSL Configuration and Management protocol using the New CMV format
*
*       int16 NewMPInitialize
*       int16 NewMPCheckMessage
*       void  NewMPSendMessage
*
*-------------------------------------------------------------------
*/

#ifndef NMP_PLFM_C
#define NMP_PLFM_C

#define IN_NMP_PLFM_C

/*******************************************************************
*
*       Include Files
*
*******************************************************************/

#include "common.h"
#include "nmp.h"
#include "aux_regs.h"
#include "hercules_memrymap.h"
#include "cmv_Data.h"
#include "string.h"
#include "gdata.h"
#include "profile.h"
#include "LL_Iof.h"


#ifdef LOG_HMP_CMV_WRITES
extern int16 gs_HmpLogIndex, gsa_HmpLogBuf[];

void LogHmpBuffer(HerculesMPStruct_t *pt_SrcBuf)
{
   int16 s_Length, FunctionOpcode;

   s_Length = pt_SrcBuf->t_MsgHeader.us_HmpMsgWord4 & HMP_WORD4_LENGTH_MASK;

   if ((gs_HmpLogIndex + s_Length) <= (HMP_LOG_BUF_SIZE - 3))
   {
      FunctionOpcode = (pt_SrcBuf->t_MsgHeader.us_HmpMsgWord0 >> HMP_WORD0_OPCODE_SHIFT) & HMP_WORD0_OPCODE_MASK_AFTER_SHIFT;

      if (FunctionOpcode == H2D_CMV_WRITE)
      {
         memcpy((int8 *)&gsa_HmpLogBuf[gs_HmpLogIndex], (int8 *)&pt_SrcBuf->t_MsgHeader.us_HmpMsgWord2, (s_Length + 3)*2);
         gs_HmpLogIndex += s_Length + 3;
      }

   }
}
#endif

void CopyHmpBuffers(HerculesMPStruct_t *pt_DestBuf, HerculesMPStruct_t *pt_SrcBuf)
{
   int32 l_MsgSize;
   uint32 ul_PayLoadLength;

   ul_PayLoadLength = pt_SrcBuf->t_MsgHeader.us_HmpMsgWord1 & HMP_WORD1_SIZE_MASK;

   l_MsgSize = 2*(HMP_MBOX_HEADER_SIZE + ul_PayLoadLength);  // size in bytes

   if (l_MsgSize > (2*HMP_MBOX_SIZE))
   {
      // log error in Trail
      l_MsgSize = 2*HMP_MBOX_SIZE;
   }

   memcpy((int8 *)pt_DestBuf, (int8 *)pt_SrcBuf, l_MsgSize);
}

/*******************************************************************************
*
*  Prototype: int16 NewMPCheckMessage(void)
*
*  This function checks to see if a new message has been received.
*
*  Input Arguments:

*  Output Arguments:
*
*  Returns:
*     TRUE (message arrived) / FALSE (no message)
*
*  Global Variables:
*
*******************************************************************************/

extern FlagT gft_ByPassCustomerMsgHandling;

int16 NewMPCheckMessage(void)
{
   int32 l_InterruptStat;
   uint16 us_Group;
   uint16 us_Opcode;

   /* ProcessTxMailbox() arbitrates access to ARC-to-ME Mailbox. */
   // This is the function where we send the autonomous message
   // and give response to the Mailbox query.
   ProcessTxMailbox();

   if (TxMailBoxPending() == 0)   // prev TX msg has been served?
   {
      l_InterruptStat = GetDspReg(ARC_INT_STAT_REG);
      // No previous message response is pending. A new message is pending
      if ((l_InterruptStat & ARC_INT_MSGAV_MASK) && (guc_MPMsgRespReq == 0))   // XDSLRTFW-3377
      {

         if (__gs_Me2ArcMboxCode == QUERY_N_RESPONSE)
         {
            us_Group = __gt_Me2ArcMboxMsg.t_MsgHeader.us_HmpMsgWord2 & HMP_WORD2_GROUP_MASK;
            us_Opcode = (__gt_Me2ArcMboxMsg.t_MsgHeader.us_HmpMsgWord0 >> HMP_WORD0_OPCODE_SHIFT) &
                        HMP_WORD0_OPCODE_MASK_AFTER_SHIFT;

            // incoming message will be copied to HMP_RxBuffer. Both NewMHandleMessage and
            // CustomterHandleMessage will work with this buffer modifying it in place and
            // set guc_MPMsgRespReq = 1 to trigger the reply at the end of the processing.
            // Note that CustomerHandleMessage may copy HMP_RxBuffer to their HMP_CustomerMsgBuffer
            // for later processing in background
            CopyHmpBuffers(&HMP_RxBuffer, &__gt_Me2ArcMboxMsg);

#ifdef LOG_HMP_CMV_WRITES
            LogHmpBuffer(&__gt_Me2ArcMboxMsg);
#endif

#ifdef CUSTOMER_TASKS
            if ((!gft_ByPassCustomerMsgHandling) && ((us_Opcode == H2D_CMV_READ) || (us_Opcode == H2D_CMV_WRITE)) && ((us_Group & CUST_CMV_GROUP_BIT_MASK) == CUST_CMV_GROUP_BIT_MASK))
            {
               CustomerHandleMessage();
            }
            else
#endif // CUSTOMER_TASKS
            {
               gs_ModemOperationRequired = NewMPHandleMessage();
            }
         }
         else
         {
            gs_ModemOperationRequired = FALSE;
            gs_MPReturnOpcode = D2H_ERROR_MBOXCODE_UNKNOWN;
            guc_MPMsgRespReq = 1;
         }
         // XDSLRTFW-3377 (Start_End) Clearing the bit here is to early, it needs to be done in NewMPSendMessage()
         // SetDspReg(ARC_INT_STAT_REG, ARC_INT_MSGAV_MASK); // clear it by writing 1
         return (1);
      }
   }
   // No new message arrived
   return 0;
}

/*******************************************************************************
*
*  Prototype: void NewMPSendMessage(int16 FunctionOpcode, int16 RW_status)
*
*  This function constructs and sends messages from modem to ME.
*
*  Input Arguments:
*     FunctionOpcode: 8-bit OP code [11:4] in Function Field
*     RW_status: normal operation if 1, do nothing if 0
*
*  Output Arguments:
*
*  Returns:
*
*  Global Variables:
*
*******************************************************************************/

void NewMPSendMessage(int16 FunctionOpcode, int16 RW_status)
{

   CopyHmpBuffers(&__gt_Arc2MeMboxMsg, &HMP_RxBuffer);

   // modify the FunctionOpcode before sending
   __gt_Arc2MeMboxMsg.t_MsgHeader.us_HmpMsgWord0 = (__gt_Arc2MeMboxMsg.t_MsgHeader.us_HmpMsgWord0 & HMP_WORD0_BITSIZE_MASK_B4_SHIFT) | (FunctionOpcode << HMP_WORD0_OPCODE_SHIFT);

   // set the mailbox code to 0 for MP messages
   __gs_Arc2MeMboxCode = QUERY_N_RESPONSE;

   SetDspReg(ARC_ARC2ME_INT_REG, ARC_ARC2ME_MSGAV_MASK);    // set the mailbox interrupt

   // XDSLRTFW-3377 (Start_End)
   SetDspReg(ARC_INT_STAT_REG, ARC_INT_MSGAV_MASK); // clear it by writing 1
}

/*^^^
*-------------------------------------------------------------------
*
*       Prototype:
*     void  NewMPSendAutoMessage();
*
*       Abstract:
*     This function is called to transmit autonomous messages (e.g. Modem Ready)
*
*       Parameters:
*
*       Returns:
*           None
*
*       Notes:
*
*-------------------------------------------------------------------
^^^*/
//#define DEBUG_AUTO_MSG

void NewMPSendAutoMessage(AutoMsgQueueEntry_t *pt_AutoMsg)
{
   int16 s_PayLoadLength;

   if ((s_PayLoadLength = pt_AutoMsg->pt_PayLoadEntry->uc_PayLoadLength <<1) > 0)
   {
      memcpy(__gt_Arc2MeMboxMsg.usa_HmpPayLoad,
             pt_AutoMsg->pt_PayLoadEntry->pus_PayLoad, s_PayLoadLength);
   }

   pt_AutoMsg->pt_PayLoadEntry->uc_PayLoadSent = 1;
   __gt_Arc2MeMboxMsg.t_MsgHeader = pt_AutoMsg->t_MsgHeader;

#ifdef DEBUG_AUTO_MSG
   printf("Send Auto Msg 0x%x 0x%x 0x%x 0x%x payload = 0x%x, 0x%x\n", pt_AutoMsg->t_MsgHeader.us_HmpMsgWord0,
          pt_AutoMsg->t_MsgHeader.us_HmpMsgWord1, pt_AutoMsg->t_MsgHeader.us_HmpMsgWord2,
          pt_AutoMsg->t_MsgHeader.us_HmpMsgWord3, pt_AutoMsg->pt_PayLoadEntry->pus_PayLoad[0],
          pt_AutoMsg->pt_PayLoadEntry->pus_PayLoad[1]);
#endif

   SetDspReg(ARC_ARC2ME_INT_REG, ARC_ARC2ME_MSGAV_MASK);    // set the mailbox interrupt

#ifdef DEBUG_TRAIL
   // Log Auto Messages if enabled
   DebugTrail1(9,DEBUG_TRAIL_AUTOMSG_TRAIL_ENABLE,0,
               (int16)0xEE00,
               (int16)gl_RxSymbolCount,
               (int16)(gl_RxSymbolCount>>16),
               (int16)pt_AutoMsg->t_MsgHeader.us_HmpMsgWord0,
               (int16)pt_AutoMsg->t_MsgHeader.us_HmpMsgWord1,
               (int16)pt_AutoMsg->t_MsgHeader.us_HmpMsgWord2,
               (int16)pt_AutoMsg->t_MsgHeader.us_HmpMsgWord3,
               (int16)pt_AutoMsg->pt_PayLoadEntry->pus_PayLoad[0],
               (int16)pt_AutoMsg->pt_PayLoadEntry->pus_PayLoad[1]);
#endif // DEBUG_TRAIL


}

/*^^^
*-------------------------------------------------------------------
*
* Prototype:
*     int16 TxMailBoxPending(void)
*
* Abstract:
*     This function is called to transmit autonomous messages (e.g. Modem Ready)
*
* Parameters:
*
* Returns:
*     None
*
* Notes:
*
*-------------------------------------------------------------------
^^^*/

int32 gl_Arc2MeStat;

int16 TxMailBoxPending(void)
{
   gl_Arc2MeStat = GetDspReg(ARC_ARC2ME_STAT_REG);
   if ((gl_Arc2MeStat & ARC_ARC2ME_MSGAV_MASK) == 0)   // prev TX msg has been served?
   {
      return(0);
   }
   else
   {
      return(1);
   }
}
#endif
