;; **COPYRIGHT******************************************************************
;;    INTEL CONFIDENTIAL
;;    Copyright (C) 2017 Intel Corporation
;;    Copyright (C), 1994-2004 Aware Inc. All Rights Reserved.
;; ******************************************************************COPYRIGHT**
;; **DISCLAIMER*****************************************************************
;;   The source code contained or described herein and all documents related
;;   to the source code ("Material") are owned by Intel Corporation or its
;;   suppliers or licensors. Title to the Material remains with Intel
;;   Corporation or its suppliers and licensors. The Material may contain
;;   trade secrets and proprietary and confidential information of Intel
;;   Corporation and its suppliers and licensors, and is protected by
;;   worldwide copyright and trade secret laws and treaty provisions. No part
;;   of the Material may be used, copied, reproduced, modified, published,
;;   uploaded, posted, transmitted, distributed, or disclosed in any way
;;   without Intels prior express written permission.
;;
;;   No license under any patent, copyright, trade secret or other
;;   intellectual property right is granted to or conferred upon you by
;;   disclosure or delivery of the Materials, either expressly, by
;;   implication, inducement, estoppel or otherwise. Any license under
;;   such intellectual property rights must be express and approved by
;;   Intel in writing.
;; *****************************************************************DISCLAIMER**
;*************************************************************************
; Aware DMT Technology. Proprietary and Confidential.
;
; ADDRESS:         40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
; TELEPHONE:       781.276.4000
; FAX:             781.276.4001
; WEB:             http://www.aware.com
;
; FILENAME:        noiseacc_loop.s
;
; DESCRIPTION:     This file contains assembly version of NoiseAccLoop()
;
;*************************************************************************
.include "asm.h"
.include "xy_regs.h"
.data


.text
;-------------| NoiseAccLoopXX |-------------------
    .global    NoiseAccLoopXX
NoiseAccLoopXX:    ; r0 = pla_OuputX (X memory)
                ; r1 = psa_InputX (X memory)
                ; r2 = s_num_tones

    ;;;;;;;;;;;;;;;;;;;;;;;;;;;
    ; set up window registers ;
    ;;;;;;;;;;;;;;;;;;;;;;;;;;;
    sr  %r1, [%ax0]                    ; ax0 = psa_InputX
    sr  0x1, [aux_mx0]                    ; offset = 1, postupdate, linear, 32 bit mode, AM_MODULO

    sr  %r0, [%ax1]                    ; ax1 = pla_OuputX
    sr  0x1, [aux_mx1]                    ; offset = 1, postupdate, linear, 32 bit mode, AM_MODULO

    ;multiply and get x^2, y^2
    mul_op  0,aux_x0_u,aux_x0_u            ; the X window register increments only once

    ;accumulate (x^2 + y^2)
    lr      %r0, [%aux_xmac1]
    lr      %r1, [%aux_xmac2]
    adds    %r0, %r0, %r1

    ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
    ; set up loop count for zero ovhd loop mechanism ;
    ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
    sub.f    %lp_count, %r2, 1            ; set up loop counter
    bz       0f                            ; if (length-1 == 0) skip loop
    blt      9f                            ; if (length-1 < 0) return

    lp 0f    ; for(i=0; i<length; i++)
        ;multiply and get x^2, y^2
    mul_op   0,aux_x0_u,aux_x0_u        ; the X window register increments only once

        ;add previous result to accumulator
        add.f    aux_x1_u, %r0, aux_x1_nu    ; *(pla_NoisePowerX)   += (l_Acc & 0xFFFF)
        adc      aux_x1_u, aux_x1_nu, 0    ; *(pla_NoisePowerX+1) += (l_Acc >>= 16)

        ;accumulate (x^2 + y^2)
        lr       %r0, [%aux_xmac1]
        lr       %r1, [%aux_xmac2]
        adds     %r0, %r0, %r1
    0:

    ;add previous result to accumulator
    add.f    aux_x1_u, %r0, aux_x1_nu    ; *(pla_NoisePowerX)   += (l_Acc & 0xFFFF)
    adc      aux_x1_u, aux_x1_nu, 0    ; *(pla_NoisePowerX+1) += (l_Acc >>= 16)

    9:
    j    [%blink]         ; if (s_num_tones <= i) return


.text
;-------------| NoiseAccLoopXY |-------------------
    .global    NoiseAccLoopXY
NoiseAccLoopXY:    ; r0 = pla_OuputX (X memory)
                ; r1 = psa_InputY (Y memory)
                ; r2 = s_num_tones

    ;;;;;;;;;;;;;;;;;;;;;;;;;;;
    ; set up window registers ;
    ;;;;;;;;;;;;;;;;;;;;;;;;;;;
    sr  %r1, [%ay0]                    ; ay0 = psa_InputY
    sr  0x1, [aux_my0]                    ; offset = 1, postupdate, linear, 32 bit mode, AM_MODULO

    sr  %r0, [%ax1]                    ; ax1 = pla_OuputX
    sr  0x1, [aux_mx1]                    ; offset = 1, postupdate, linear, 32 bit mode, AM_MODULO

    ;multiply and get x^2, y^2
    mul_op    0,aux_y0_u,aux_y0_u            ; the Y window register increments only once

    ;accumulate (x^2 + y^2)
    lr        %r0, [%aux_xmac1]
    lr        %r1, [%aux_xmac2]
    adds      %r0, %r0, %r1

    ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
    ; set up loop count for zero ovhd loop mechanism ;
    ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
    sub.f    %lp_count, %r2, 1              ; set up loop counter
    bz       0f                             ; if (length-1 == 0) skip loop
    blt      9f                             ; if (length-1 < 0) return

    lp 0f    ; for(i=0; i<length; i++)
        ;multiply and get x^2, y^2
    mul_op       0,aux_y0_u,aux_y0_u        ; the Y window register increments only once

        ;add previous result to accumulator
        add.f    aux_x1_u, %r0, aux_x1_nu    ; *(pla_NoisePowerX)   += (l_Acc & 0xFFFF)
        adc      aux_x1_u, aux_x1_nu, 0      ; *(pla_NoisePowerX+1) += (l_Acc >>= 16)

        ;accumulate (x^2 + y^2)
        lr       %r0, [%aux_xmac1]
        lr       %r1, [%aux_xmac2]
        adds     %r0, %r0, %r1
    0:

    ;add previous result to accumulator
    add.f    aux_x1_u, %r0, aux_x1_nu     ; *(pla_NoisePowerX)   += (l_Acc & 0xFFFF)
    adc      aux_x1_u, aux_x1_nu, 0       ; *(pla_NoisePowerX+1) += (l_Acc >>= 16)

    9:
    j    [%blink]         ; if (s_num_tones <= i) return

    .end
