;; **COPYRIGHT******************************************************************
;;    INTEL CONFIDENTIAL
;;    Copyright (C) 2017 Intel Corporation
;;    Copyright (C), 1994-2002 Aware Inc. All Rights Reserved.
;; ******************************************************************COPYRIGHT**
;; **DISCLAIMER*****************************************************************
;;   The source code contained or described herein and all documents related
;;   to the source code ("Material") are owned by Intel Corporation or its
;;   suppliers or licensors. Title to the Material remains with Intel
;;   Corporation or its suppliers and licensors. The Material may contain
;;   trade secrets and proprietary and confidential information of Intel
;;   Corporation and its suppliers and licensors, and is protected by
;;   worldwide copyright and trade secret laws and treaty provisions. No part
;;   of the Material may be used, copied, reproduced, modified, published,
;;   uploaded, posted, transmitted, distributed, or disclosed in any way
;;   without Intels prior express written permission.
;;
;;   No license under any patent, copyright, trade secret or other
;;   intellectual property right is granted to or conferred upon you by
;;   disclosure or delivery of the Materials, either expressly, by
;;   implication, inducement, estoppel or otherwise. Any license under
;;   such intellectual property rights must be express and approved by
;;   Intel in writing.
;; *****************************************************************DISCLAIMER**
;*************************************************************************
; Aware DMT Technology. Proprietary and Confidential.
;
; ADDRESS:         40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
; TELEPHONE:       781.276.4000
; FAX:             781.276.4001
; WEB:             http://www.aware.com
;
; FILENAME:        retx_asm.s
;
; DESCRIPTION:     This file includes asm modules for RETX feature
;                  1. GolayCoding
;
;*************************************************************************

#define IN_ASM
#include "vdsl_compiler.h"


    ; uint32 GolayCoding(uint32);

    .text
    .global GolayCoding
    .type GolayCoding, @function
    .align 4

    ;
    ; macro for bit_x*D^y
    ; forming bit-y in reg1 based on bit-x in reg0
    ;
    .macro BxDy, reg0, x, reg1, y
        btst_s reg0, x;
        bset.nz reg1, reg1, y;
    .endm



GolayCoding:
        ; only take 12 LSB as input
        bmsk r4, r0, 12
        xor_s r2, r2, r2

        ; forming M(D)xD11
        mov_s r1, 22
        mov lp_count, 12

        lp _forming_MDxD11_lp_end

_forming_MDxD11_lp_start:
        lsr.f   r0, r0
        bset.c r2, r2, r1
        sub_s r1, r1, 1
_forming_MDxD11_lp_end:


        ; r3 = G(D) = 0xAE3
        ; for convenience, we set G`(D) = 0xAE3 << 11
        mov_s r3, 0x571800;

    ; test code
        ; C(D) = M(D)*D^11 mod G(D)
        mov lp_count, 12

        lp _MD_D11_mod_GD_end

_MD_D11_mod_GD_start:
        btst_s r2, 22
        xor.nz r2, r2, r3
        asl_s r2, r2
_MD_D11_mod_GD_end:

        lsr_s r2, r2, 12          ; extra shift to compensate the asl_s r2, r2 within the loop

        ; forming the redundancy bits
        ; C(D) = b17D10 + b18D9 + b22D8 + b21D7 + b14D6 + b19D5 + b23D4 + b13D3 + b20D2 + b15D + b16

        BxDy    r2, 10, r4, 17
        BxDy    r2,  9, r4, 18
        BxDy    r2,  8, r4, 22
        BxDy    r2,  7, r4, 21
        BxDy    r2,  6, r4, 14
        BxDy    r2,  5, r4, 19
        BxDy    r2,  4, r4, 23
        BxDy    r2,  3, r4, 13
        BxDy    r2,  2, r4, 20
        BxDy    r2,  1, r4, 15
        BxDy    r2,  0, r4, 16

        ; calculate bit12 (parity)

        mov lp_count, 24
        mov_s r0, r4
        xor_s r1, r1, r1

        lp _rrc_parity_bit_loop_end

_rrc_parity_bit_loop_start:
        lsr.f   r0, r0
        add.c r1, r1, 1
_rrc_parity_bit_loop_end:

        ; put this parity bit into bit12
        BxDy    r1,  0, r4, 12

        j.d [blink]
        mov_s r0, r4


    .end
