/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2002 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*************************************************************************
* Aware DMT Technology. Proprietary and Confidential.
*
* ADDRESS:         40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
* TELEPHONE:       781.276.4000
* FAX:             781.276.4001
* WEB:             http://www.aware.com
*
* FILENAME:        xy_iof.c
*
* DESCRIPTION:     Functions for interfacing the XY memory
*
**************************************************************************/

#include "xy_iof.h"
#include "gdata.h"

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : XYAddrDecode
 *
 *  Prototype:
 *         void XYAddrDecode( void pla_input1,
 *                            FlagT ft_AddrMode )
 *
 *  Input Arguments:
 *
 *  Output Arguments:
 *
 *  Notes: Initially the first parameter was of type int32 but to suppress/remove a warning
 *         it has been changed to type void. And suitable changes are made in the function
 *         and wherever it is being employed.
 *
 *------------------------------------------------------------------------
 *^^^
 */
int32 XYAddrDecode(int32 *pla_input, FlagT ft_AddrMode)
{

   int32 l_temp;

   if (((l_temp = (int32)pla_input - X_BASE_ADDR_IN_BYTES) >= 0) &&
         (l_temp < X_BLOCK_SIZE_IN_BYTES))
   {
   }
   else if (((l_temp = (int32)pla_input - Y_BASE_ADDR_IN_BYTES) >= 0) &&
            (l_temp < Y_BLOCK_SIZE_IN_BYTES))
   {
   }
   else
   {
      return(ADDR_NOT_IN_XY);
   }


   if(ft_AddrMode == ADDR_MODE_16)
      return(l_temp >> 1);
   else
      return(l_temp >> 2);


}


/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : CheckXYAddrRange
 *
 *  Prototype:
 *         void CheckXYAddrRange(void pla_buf1,
 *                                uint32 ul_bufId)
 *
 *  Input Arguments:
 *
 *  Output Arguments:
 *
 *  Notes: Initially the first parameter was of type int32 but to suppress/remove a warning
 *         it has been changed to type void. And suitable changes are made in the function
 *         and wherever it is being employed.
 *
 *------------------------------------------------------------------------
 *^^^
 */
FlagT CheckXYAddrRange(int32 *pla_buf, uint32 ul_bufId)
{
   int32 la_VectorizeXYCheck[NUM_BUFFER_ID][2] =
   {
      {X_BASE_ADDR_IN_BYTES , (X_BASE_ADDR_IN_BYTES + X_BLOCK_SIZE_IN_BYTES)},   // X_MEM
      {Y_BASE_ADDR_IN_BYTES , (Y_BASE_ADDR_IN_BYTES + Y_BLOCK_SIZE_IN_BYTES)}    // Y_MEM
   };


   if (ul_bufId < NUM_BUFFER_ID)
   {
      if (((int32)pla_buf >= la_VectorizeXYCheck[ul_bufId][0]) && ((int32)pla_buf < la_VectorizeXYCheck[ul_bufId][1]))
      {
         return PASS;
      }
   }

   return FAIL;
}

// the same code applies to addresses of both 16-bit and 32-bit data
FlagT CheckValidModuloAddr(int32 pla_bufXY, int16 s_bufLen)
{
   int16 i;
   int16 s_log2bufLen;

   // compute ceil(log2(s_bufLen))
   for(i=s_bufLen-1, s_log2bufLen=0; i>1; i >>= 1)
      s_log2bufLen++;

   s_log2bufLen++;

   // any buffer using modulo addressing must start at
   // a multiple of (1 << s_log2bufLen)
   if(pla_bufXY % (1 << s_log2bufLen) == 0)
      return PASS;
   else
      return FAIL;

}
