;; **COPYRIGHT******************************************************************
;;    INTEL CONFIDENTIAL
;;    Copyright (C) 2017 Intel Corporation
;;    Copyright (C), 1994-2002 Aware Inc. All Rights Reserved.
;; ******************************************************************COPYRIGHT**
;; **DISCLAIMER*****************************************************************
;;   The source code contained or described herein and all documents related
;;   to the source code ("Material") are owned by Intel Corporation or its
;;   suppliers or licensors. Title to the Material remains with Intel
;;   Corporation or its suppliers and licensors. The Material may contain
;;   trade secrets and proprietary and confidential information of Intel
;;   Corporation and its suppliers and licensors, and is protected by
;;   worldwide copyright and trade secret laws and treaty provisions. No part
;;   of the Material may be used, copied, reproduced, modified, published,
;;   uploaded, posted, transmitted, distributed, or disclosed in any way
;;   without Intels prior express written permission.
;;
;;   No license under any patent, copyright, trade secret or other
;;   intellectual property right is granted to or conferred upon you by
;;   disclosure or delivery of the Materials, either expressly, by
;;   implication, inducement, estoppel or otherwise. Any license under
;;   such intellectual property rights must be express and approved by
;;   Intel in writing.
;; *****************************************************************DISCLAIMER**
;*************************************************************************
; Aware DMT Technology. Proprietary and Confidential.
;
; ADDRESS:         40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
; TELEPHONE:       781.276.4000
; FAX:             781.276.4001
; WEB:             http://www.aware.com
;
; FILENAME:        xy_iof_asm.s
;
; DESCRIPTION:     Functions to read and write data to XY memory
;
;*************************************************************************
.include "asm.h"
.include "xy_regs.h"


   .define psa_xyBuf, %r0
   .define s_bufLen,  %r1

   .define scratch,      %r2
   .define scratch1,     %r3
   .define s_leftShift,  %r4
   .define s_log2bufLen, %r5
   .define s_blockSize,  %r6

.text
; assume that the input address is given in 16-bit addressing mode
; void AlignOddAddressWordsX(int32 psa_xyBuf, int16 s_bufLen)
.global AlignOddAddressWordsX
AlignOddAddressWordsX:
   ; Input Arguments
   ; %r0 = psa_xyBuf
   ; %r1 = s_bufLen

   ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
   ; prolog: none since leaf function and no stack frame for auto variables ;
   ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
   sub.f 0, s_bufLen, 0
   ble   9f

   and.f 0, s_bufLen, 1       ; check whether we have odd or even length buffer
   bz    8f

   ; if(s_bufLen is odd)
   mov   %lp_count, s_bufLen

   sr    psa_xyBuf, [%ax0]
   sr    0x2000_0001, [aux_mx0]              ; all other bits = postupdate, linear, 16-bit mode, AM_MODULO
   add   psa_xyBuf, psa_xyBuf, s_bufLen
   sr    psa_xyBuf, [%ax1]
   sr    0x2000_0001, [aux_mx1]     ; offset = 1, postupdate, linear, 16-bit mode, AM_MODULO

    b     _X_loop_setup

   ; if(s_bufLen is even)
   8:
   mov   %lp_count, s_bufLen

   add   scratch, psa_xyBuf, 1
   sr    scratch, [%ax0]
   asl   scratch, s_bufLen, 16            ; bits 16:28 = modulo length
   or    scratch, scratch, 0x2000_0001    ; bits 0:13 = offset = 1
   sr    scratch, [aux_mx0]               ; all other bits = postupdate, linear, 16-bit mode, AM_MODULO

   sub   scratch, s_bufLen, 1
   norm  s_leftShift, scratch
   sub   s_log2bufLen, 31, s_leftShift    ; what should be the exponent here for 16-bit addressing, 30 or 31?
   asl   s_blockSize, 1, s_log2bufLen
   add   psa_xyBuf, psa_xyBuf, s_blockSize
   sr    psa_xyBuf, [%ax1]
   sr    0x2000_0001, [aux_mx1]     ; offset = 1, postupdate, linear, 32-bit mode, AM_MODULO

_X_loop_setup:
   ; set up the single instruction loop
    mov   r2, _X_loop0
    mov   r3, _X_loop0_end
    sr    r2, [%lp_start]
    sr    r3, [%lp_end]
    nop
    nop

   _X_loop0:
      mov aux_x1_u, aux_x0_u

   _X_loop0_end:
   ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
   ; epilog: just return to the caller ;
   ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
   9:
      j    [%blink]

; assume that the input address is given in 16-bit addressing mode


; void AlignOddAddressWordsY(int32 psa_xyBuf, int16 s_bufLen)
.global AlignOddAddressWordsY
AlignOddAddressWordsY:
   ; Input Arguments
   ; %r0 = psa_xyBuf
   ; %r1 = s_bufLen

   ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
   ; prolog: none since leaf function and no stack frame for auto variables ;
   ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
   sub.f 0, s_bufLen, 0
   ble   9f

   and.f 0, s_bufLen, 1       ; check whether we have odd or even length buffer
   bz    8f

   ; if(s_bufLen is odd)
   mov   %lp_count, s_bufLen

   sr    psa_xyBuf, [%ay0]
   sr    0x2000_0001, [aux_my0]              ; all other bits = postupdate, linear, 16-bit mode, AM_MODULO
   add   psa_xyBuf, psa_xyBuf, s_bufLen
   sr    psa_xyBuf, [%ay1]
   sr    0x2000_0001, [aux_my1]     ; offset = 1, postupdate, linear, 16-bit mode, AM_MODULO

    b     _Y_loop_setup;

   ; if(s_bufLen is even)
   8:
   mov   %lp_count, s_bufLen

   add   scratch, psa_xyBuf, 1
   sr    scratch, [%ay0]
   asl   scratch, s_bufLen, 16            ; bits 16:28 = modulo length
   or    scratch, scratch, 0x2000_0001    ; bits 0:13 = offset = 1
   sr    scratch, [aux_my0]               ; all other bits = postupdate, linear, 16-bit mode, AM_MODULO

   sub   scratch, s_bufLen, 1
   norm  s_leftShift, scratch
   sub   s_log2bufLen, 31, s_leftShift    ; what should be the exponent here for 16-bit addressing, 30 or 31?
   asl   s_blockSize, 1, s_log2bufLen
   add   psa_xyBuf, psa_xyBuf, s_blockSize
   sr    psa_xyBuf, [%ay1]
   sr    0x2000_0001, [aux_my1]     ; offset = 1, postupdate, linear, 32-bit mode, AM_MODULO


_Y_loop_setup:
   ; set up the single instruction loop
    mov   r2, _Y_loop0
    mov   r3, _Y_loop0_end
    sr    r2, [%lp_start]
    sr    r3, [%lp_end]
    nop
    nop

   _Y_loop0:
      mov aux_y1_u, aux_y0_u

   _Y_loop0_end:
   ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
   ; epilog: just return to the caller ;
   ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
   9:
      j    [%blink]

   .undef psa_xyBuf
   .undef s_bufLen

   .undef scratch
   .undef scratch1
   .undef s_leftShift
   .undef s_log2bufLen
   .undef s_blockSize
