/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2005 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: FindPmdStep.c
*
*   This file contains engine interface functions to initialize cores
*   for showtime TX path operations.
*
*-------------------------------------------------------------------------------
*/

#include "common.h"

/*-------------------------------------------------------------------------------
*
*   Prototype: uint16 ZEP_ILV_Find_Pmd_Step(uint16 us_D, uint16 us_I)
*
*   This function computes the PMD step size, by solving  1=D*i mod I for i
*
*   Input Arguments:
*            us_D: Interleaver Depth
*            uc_fifo:Block Size
*
*   Output Arguments:
*           Step Size
*-------------------------------------------------------------------------------
*/
uint16 Find_Pmd_Step(uint16 s_D, uint16 s_I)
{
   int16 i=1;
   int32 l_temp = 0;

   for (i=1; i<s_I; i++)
   {
      l_temp +=  s_D;
      while ( l_temp >=  s_I)
      {
         l_temp -= s_I;
      }

      if (l_temp == 1)
      {
         break;
      }

   }

   return (i);
}

