/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 1998-2007 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *----------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Condfidential
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276-4000
 *   FAX   (781) 276-4001
 *
 *   IRI_IOf.C
 *
 *   Iridia CPE core interface layer.
 *
 *
 *----------------------------------------------------------------------------
 */


// ***********************************************************************************************************
// IRI_IOf.c
//
// History
//
// 19/09/2013 Varun/Palaksha/Ram : Added new CMV INFO 238 0 ==> gives the Max mips count(Foregraound + Tc task) in showtime if test 0 0 is 0x1000
//                    Note that in VDSL Rx enters showtime first(look timing diagram of VDSL2 for more details). since we want showtime mips when both tx
//                    and rx in showtime we enable the profile tasking when tx enters showtime. foreground mips peaking occurs at tx in RPSynchro6 state.
//                    Hence condition is checked in foreground in showtime. Following additional improvements done
//                  - Added FG Task Averege MIPS profiling
//                  - Added a optimisation code to reduce the RxTc Mips
//                     Grep for "XDSLRTFW-1243 Feature_ALL_VDSL2_ALL_CMV_MipsProfiling"
//
// 05/08/2015 Vinay: Added two more field to DSL 3 ( DSL 3 17 and DSL 3 18) to accomadate the pilot tone constellation for the pilot tone(only 1 being used).
//                   The first field represents the real part and the second field represents the imaginary part of the constellation.
//                   Grep: XDSLRTFW-214
//
// ************************************************************************************************************


#include "common.h"
#include "gdata.h"
#include "ft_memmap.h"
#include "ftb_memmap.h"

#include "qt_memmap.h"
#include "qtp_memmap.h"
#include "qt_const.h"
#include "cri_memmap.h"
#include "LL_Iof.h"
#include "string.h"
#include "states.h"
#include "cmv.h"
#include "afe.h"
#include "IRI_Iof.h"
#include "vdsl_xception.h"
#include "fifo.h"
#include "Vdsl_state.h"
#include "FormRErrorFeedbackMsg_VDSL2.h"

extern uint64 gll_Pa;
/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : LoadTxPRBSMsgBytes
 *
 *  Description:  This loading function loads the message into QT's PRBS data register.
 *
 *  Prototype:
 *      void LoadTxPRBSMsgBytes(void)
 *
 *  Input Arguments:
 *
 *  Output Arguments:
 *
 *  Return:
 *
 *  Global Variables Used:
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */
void LoadTxPRBSMsgBytes(void)
{
   WriteCoreReg(IRI_QTP_REG_TX_PRBS_DATA0_ADDR, gl_SocTxDataForPrbs);

//#ifdef MTK_VECTORING_SUPPORT
   WriteCoreReg(IRI_QTP_REG_TX_PRBS_DATA1_ADDR, gl_SocTxDataForPrbs_ext[0]);
   WriteCoreReg(IRI_QTP_REG_TX_PRBS_DATA2_ADDR, gl_SocTxDataForPrbs_ext[1]);
   WriteCoreReg(IRI_QTP_REG_TX_PRBS_DATA3_ADDR, gl_SocTxDataForPrbs_ext[2]);
   WriteCoreReg(IRI_QTP_REG_TX_PRBS_DATA4_ADDR, gl_SocTxDataForPrbs_ext[3]);
   WriteCoreReg(IRI_QTP_REG_TX_PRBS_DATA5_ADDR, gl_SocTxDataForPrbs_ext[4]);
   WriteCoreReg(IRI_QTP_REG_TX_PRBS_DATA6_ADDR, gl_SocTxDataForPrbs_ext[5]);
   WriteCoreReg(IRI_QTP_REG_TX_PRBS_DATA7_ADDR, gl_SocTxDataForPrbs_ext[6]);
//#endif
}


/*****************************************************************************
;   Prototype:
;      void LoadFDQ(void)
;
;   Time critical function used for loading the FDQ coefficients to HW.
;
;   Global Variables:
;      Inputs:
;         gsa_pre_FDQ_coef - FDQ coefficients computed during training;
;
;      Outputs:
;
;****************************************************************************/
void LoadFDQ(void)
{
   uint16 us_length;

   // Read both FDQ mantissa and exponent from HW.
   us_length = gs_RightChannel - gs_LeftChannel + 1;

   StoreFdqMant(gsa_pre_FDQ_coef, gs_LeftChannel, us_length);
   StoreFdqExp(guca_pre_FDQ_exp, gs_LeftChannel, us_length);
}

/*****************************************************************************
;   Prototype:
;      void ReadFDQ(void)
;
;   Time critical function used for reading the FDQ coefficients from HW.
;
;   Global Variables:
;      Inputs:
;         gsa_pre_FDQ_coef - FDQ coefficients array
;
;      Outputs:
;
;****************************************************************************/
void ReadFDQ(void)
{
   uint16 us_length;

   // Read both FDQ mantissa and exponent from HW.
   us_length = gs_RightChannel - gs_LeftChannel + 1;
   ReadFdqMant(gsa_pre_FDQ_coef, gs_LeftChannel, us_length);
   ReadFdqExp(guca_pre_FDQ_exp, gs_LeftChannel, us_length);
}

//Copy the FDQ mantissas from the input buffer to the HW buffer
void StoreFdqMant(int16 *psa_FdqMant, int16 s_FirstTone, int16 s_NumTones)
{
   WriteCoreBuf32((uint32)(IRI_QT_RAM_FDQ_MANT_ADDR + (s_FirstTone<<2)), psa_FdqMant, s_NumTones);
}

//Copy the FDQ exponents from the input buffer to the HW buffer
void StoreFdqExp(uint8 *puca_FdqExp, int16 s_FirstTone, int16 s_NumTones)
{
   WriteCoreBuf8((uint32)(IRI_QT_RAM_FDQ_EXP_ADDR + (s_FirstTone<<2)),(int8 *)(void *) puca_FdqExp, s_NumTones);
}

//Copy the FDQ mantissas from the HW buffer to the input buffer
void ReadFdqMant(int16 *psa_FdqMant, int16 s_FirstTone, int16 s_NumTones)
{
   ReadCoreBuf32((uint32)(IRI_QT_RAM_FDQ_MANT_ADDR + (s_FirstTone<<2)), psa_FdqMant, s_NumTones);
}

//Copy the FDQ exponents from the HW buffer to the input buffer
void ReadFdqExp(uint8 *puca_FdqExp, int16 s_FirstTone, int16 s_NumTones)
{
   ReadCoreBuf8((uint32)(IRI_QT_RAM_FDQ_EXP_ADDR + (s_FirstTone<<2)),(int8 *)(void *) puca_FdqExp, s_NumTones);
}

/*****************************************************************************
;   Prototype:
;      void SetRxToneOffset(void)
;
;   Input Arguments: None
;   Output Arguments: None
;
;   Set Rx tone offset for use by RTV buffer 0.
;
;****************************************************************************/
void SetRxToneOffset(void)
{
   uint32 ul_tmpWord;
   uint32 ul_rtvOffsetMask;


   ul_rtvOffsetMask = RTV_OFFSET_MASK;


   // Set QTP PRBS offset. Same offset for both RTVs
   ul_tmpWord = (uint32)gs_RxToneOffset | ((uint32)gs_RxToneOffset << 16); // PRBS_OFFSET0&1
   WriteCoreReg(IRI_QTP_REG_RX_PRBS_OFFSET_ADDR, ul_tmpWord);

   // write RTV_OFFSET0 fields directly
   ReadCoreReg(IRI_QT_REG_RX_FD_RNG0_ADDR, &ul_tmpWord);
   ul_tmpWord &= (uint32)~(ul_rtvOffsetMask);
   ul_tmpWord |= (uint32)gs_RxToneOffset & ul_rtvOffsetMask;
   WriteCoreReg(IRI_QT_REG_RX_FD_RNG0_ADDR, ul_tmpWord);

   // write RTV_OFFSET1 fields directly
   ReadCoreReg(IRI_QT_REG_RX_FD_RNG1_ADDR, &ul_tmpWord);
   ul_tmpWord &= (uint32)~(ul_rtvOffsetMask);
   ul_tmpWord |= (uint32)gs_RxToneOffset & ul_rtvOffsetMask;
   WriteCoreReg(IRI_QT_REG_RX_FD_RNG1_ADDR, ul_tmpWord);
}


void Enable_HW_VectoringErbDump(void)
{
   uint32 ul_data;


   gs_RxToneOffsetSave = gs_RxToneOffset;

   //Modify PRBS_offset settings for start tone = 0
   ReadCoreReg(IRI_QTP_REG_RX_PRBS_OFFSET_ADDR, &ul_data);
   ul_data &= PRBS_TONE_OFFSET0_MASK;
   WriteCoreReg(IRI_QTP_REG_RX_PRBS_OFFSET_ADDR, ul_data);
   //save RTV0 settings
   ReadCoreReg(IRI_QT_REG_RX_FD_RNG0_CNT_35B_ADDR, &gul_FD_RNG0CNTShadow);
   ReadCoreReg(IRI_QT_REG_RX_FD_RNG0_ADDR, &ul_data);
   gul_FD_RNG0Shadow = ul_data;

   //set 1st tone to 0 and number of tones to capture = 1024
   // code should be more robust & flexible. This version supports Fsub = 4 onwards
   ul_data &= 0xE1000000; //set 1st tone to 0

   // Error mode
   ul_data |= (ERROR_OUTPUT << 25);  //ERROR_OUTPUT = 0x7
   // unrotate   for correct error
   ul_data |= (0x1 << 28);
   WriteCoreReg(IRI_QT_REG_RX_FD_RNG0_ADDR, ul_data);

   //ul_data |= (1023 << 12); // save 1024 values defined by decimation
   ul_data = (gs_NoOfRTV0ToneToCapture-1); // save 2048 values defined by decimation factor
   WriteCoreReg(IRI_QT_REG_RX_FD_RNG0_CNT_35B_ADDR, ul_data);
   // Change IRI_MISC settings
   ReadCoreReg(IRI_QT_REG_RX_MISC_ADDR, &ul_data);
   gul_RX_MISC_Shadow =  ul_data;

   //Disable IR_REIM_ACCUM, IR_NPR_ACCUM and VECPOW_ACCUM
   // clear decim and Error Format fields
   ul_data &= 0xC31FFFFF;
   // set decimation factor
   ul_data |= ((uint32)gs_IR_NPR_DECIM <<26);//0 = every, 1 = 2nd, 2 = 4th, 3 = 8th
   //set error format = 1
   //ul_data |= 0x10000000;
   //set error format = 0
   ul_data |= (0 <<28);  //0 = 16bit, 1 = 8bit, 2 = 4bit, 3 = 2bit
   WriteCoreReg(IRI_QT_REG_RX_MISC_ADDR, ul_data);

   // Switch RTV data from NPR to IIBRAM.
   // Value = 0x80000000 | ((RTV0 training buffer offset from 0x40000)/4)
   ul_data = (1<<31) | (((uint32)gsa_TrnVectoringBuffer - ZEP_RAM_IIBRAM_ADDR) >> 2);
   WriteCoreReg(IRI_QT_REG_RX_NPR_IIBRAM_ADDR, ul_data);
}
/*
*-------------------------------------------------------------------------------
*
*   Prototype: void TriggerVectorPower(void)
*
*   This sets the VectorPower block for calculating the power of the FFT output
*   in the RD_RNG0
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/
// For Vector Power
void TriggerVectorPower(void)
{
   uint32 ul_data;
   uint32 ul_TempRxMisc;

   if (gft_StartHybTrn==0)
   {
      //Clear the vector accumulation register
      WriteCoreReg(IRI_QT_REG_RX_VECPOW_L_ADDR,0);
      WriteCoreReg(IRI_QT_REG_RX_VECPOW_H_ADDR,0);
   }

   // Get the MISC register
   ReadCoreReg(IRI_QT_REG_RX_MISC_ADDR, &ul_TempRxMisc);
   if(gft_ExecuteShadowing)
   {
      gul_RX_MISC_Shadow = ul_TempRxMisc;
      // Get the RTV0 register
      ReadCoreReg(IRI_QT_REG_RX_FD_RNG0_ADDR, &gul_FD_RNG0Shadow);
      ReadCoreReg(IRI_QT_REG_RX_FD_RNG0_CNT_35B_ADDR, &gul_FD_RNG0CNTShadow);
   }

   // Write the MISC register
   {
      // Disable IR_REIM_ACCUM, IR_NPR_ACCUM and VECPOW_ACCUM
      ul_data = ul_TempRxMisc & ~(0x1F<<21);
      // Enable VECPOW_ACCUM
      ul_data |= (1<<21);
      // Set NP_SHIFT to x
      {
         uint8 uc_AdditionalShifts;

         // FW is using 32bit power value.
         // HW has 42bit, i.e. 10bit headroom for accumulation. Plus 1bit due to FFT stages, i.e. 2^1/2.
         // This leads to 11bit.
         uc_AdditionalShifts = 0;
         if (guc_VectorPowerRightShifts > (uint8)(11))
         {
            uc_AdditionalShifts = (guc_VectorPowerRightShifts - 11);
         }

         ul_data |= (uc_AdditionalShifts<<24);
      }

      WriteCoreReg(IRI_QT_REG_RX_MISC_ADDR, ul_data);
   }

   // Write the RTV0 register
   ul_data = (1<<28) |                               // disable rotation
             (FFT_OUTPUT<<25) |                      // RAW FFT
             gs_LeftChannel;                         // Tone Start
   WriteCoreReg(IRI_QT_REG_RX_FD_RNG0_ADDR, ul_data);

   ul_data = (gs_AlgNumTonesToProcess - 1);        // Number of Tones
   WriteCoreReg(IRI_QT_REG_RX_FD_RNG0_CNT_35B_ADDR, ul_data);
}

void DeTriggerVectorPower(void)
{
   //Restore the previous register value
   WriteCoreReg(IRI_QT_REG_RX_MISC_ADDR, gul_RX_MISC_Shadow);
   WriteCoreReg(IRI_QT_REG_RX_FD_RNG0_ADDR, gul_FD_RNG0Shadow);
   WriteCoreReg(IRI_QT_REG_RX_FD_RNG0_CNT_35B_ADDR, gul_FD_RNG0CNTShadow);
}

void Disable_HW_VectoringErbDump(void)
{
   uint32 ul_data;

   DeTriggerVectorPower();

   //switch Data Dump back to NPR instead of IIBRAM
   ResetCoreReg(IRI_QT_REG_RX_NPR_IIBRAM_ADDR, (1<<31));
   // restore PRBS Offset for normal capture
   ReadCoreReg(IRI_QTP_REG_RX_PRBS_OFFSET_ADDR, &ul_data);
   ul_data &= PRBS_TONE_OFFSET0_MASK;
   ul_data |= (gs_RxToneOffsetSave & RTV_OFFSET_MASK);
   WriteCoreReg(IRI_QTP_REG_RX_PRBS_OFFSET_ADDR, ul_data);
}

void ClearVectorPower(void)
{
   //Clear the vector accumulation register
   WriteCoreReg(IRI_QT_REG_RX_VECPOW_L_ADDR,0);
   WriteCoreReg(IRI_QT_REG_RX_VECPOW_H_ADDR,0);
}

void StopVectorPower(void)
{
//   if(gs_HybrTrHandlerCount == (guc_HybridEchoAccu))
   {
      uint32 ul_TempRxMisc;
      ReadCoreReg(IRI_QT_REG_RX_MISC_ADDR, &ul_TempRxMisc);
      // Disable IR_REIM_ACCUM, IR_NPR_ACCUM and VECPOW_ACCUM
      ul_TempRxMisc = ul_TempRxMisc & ~(0x1F<<21);
      WriteCoreReg(IRI_QT_REG_RX_MISC_ADDR, ul_TempRxMisc);
   }
}
/*
*-------------------------------------------------------------------------------
*
*   Prototype: void ReadVectorPower(void)
*
*   This reads and combines the Low and High words of the Vector Power and divides by 2^13.
*   The average power is added to gl_Pa.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/
void ReadVectorPower(void)
{
   uint32 ul_H, ul_L;
   int32 s_rsh;
   uint64 ull_word;

   // Note: pul_word[0] contains the lower 32 bits of the vector power accumulator and
   //       pul_word[1] contains the upper 10 bits of the vector power accumulator
   ReadCoreReg(IRI_QT_REG_RX_VECPOW_L_ADDR, &ul_L);
   ReadCoreReg(IRI_QT_REG_RX_VECPOW_H_ADDR, &ul_H);

   s_rsh = guc_VectorPowerRightShifts;
// Debug code start_end
//   s_rsh = 0;

   // Compute the average signal power; divide by total # of samples in a frame
   ul_L = ul_L >> s_rsh;
   ul_H = ul_H & 0x03FF;   // take the 10 LSBs
   ull_word = ((uint64)gl_Pa) + (uint64)(ul_L | ((uint64)ul_H << (32-s_rsh)));

   // Debug code start
   gll_Pa = ull_word;

   // Check for saturation
   // Decide if the vector power can be represented by 31 bits or not (note gl_Pa is a signed 32-bit number)
   // if not, return gl_Pa as the maximum positive 32-bit integer
   if(ull_word > 0x7FFFFFFF)
   {
      gl_Pa = 0x7FFFFFFF;
   }
// Debug code start
//   if(ull_word > (uint64)0xFFFFFFFF)
//   {
//      gll_Pa = ull_word;
//      gl_Pa = ull_word >> 32;
//   }
// Debug code end
   else
   {
      gl_Pa = (int32)ull_word;
    }
}


/***************************************************************************************
;   Subroutine Name: GetRxTones
;
;   Description:
;      This routine copies the RTV buffer 0 contents from the Iridia QT
;
;   Prototype:
;      void GetRxTones(void)
;
;   Input Arguments:
;
;   Output Arguments:
;      none
;
;   Return Value:
;      none
;
;   Global Variables:
;      gs_RtvSelect (I)      - FFT_OUTPUT: RTV0, SFDQ_OUTPUT: RTV1
;      gpsa_RxToneBuf (O)      - output from FDQ
;
;   Substates:
;             None
;
;**********************************************************************************************/
//Mei test
#ifdef CAPTURE_AFE_RX_IN
#include <stdio.h>
FILE *fp_RxToneBuf;
int16 gs_init1 = 0;
#endif

void GetRxTones(void)
{
   //For training, always read from RTV0; during showtime, RTV1 access is by ReadRxSynchFrame()
   ReadCoreBuf32(IRI_QT_RAM_RX_NOISE_ACCMR_LSW_ADDR, gpsa_RxToneBuf, (uint16)gs_NumChannelsPerGroup );

#ifdef CAPTURE_AFE_RX_IN
   if(gs_CaptureAfeRxInFlag)
   {
      int16 i;

      if(gs_init1 == 0)
      {
         fp_RxToneBuf = fopen("fRxToneBuf.txt", "w");
         gs_init1 = 1;
      }

      for(i=0; i<gs_NumChannelsPerGroup*2; i++)
      {
         fprintf(fp_RxToneBuf, "%d\n", gpsa_RxToneBuf[i]);
      }
      fflush(fp_RxToneBuf);
   } //if(gs_CaptureAfeRxInFlag)
#endif //#ifdef CAPTURE_AFE_RX_IN
}

/*****************************************************************************
;   Prototype:
;      void EnableRxDescrambling(void)
;
;   Input Arguments: None
;   Output Arguments: None
;
;   Enables Rx PRBS Descrambling
;
;****************************************************************************/
void EnableRxDescrambling(void)
{
   // Enable QTP PRBS generation bit.
   SetCoreReg(IRI_QTP_REG_RX_CTRL_ADDR, (1<<1));
}

/*****************************************************************************
;   Prototype:
;      void DbgModifyRxDescrambling(void)
;
;   Input Arguments: None
;   Output Arguments: None
;
;   Modifies Rx PRBS Descrambling parameters
;
;****************************************************************************/

/*
*-------------------------------------------------------------------------------
*
*   Prototype: void SwitchTxPingPongTable(void)
*
*   This function switches the bank of TX ping-pong table used by BAT, GST, EGT,
*   and TRT by toggling TPP bit in IT_MISC register.
*   It also updates the active/inactive pointers to BAT/GST/EGT/TRT.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/
void SwitchTxPingPongTable(void)
{
   uint32 ul_data;

   //set min and max tone range for active table

   //This register is used in QT
   if(gs_TxNumTonesUsed <= 0)
   {
      ul_data = 0;
   }
   else
   {
      ul_data = (gs_TxNumTonesUsed - 1);
   }

   WriteCoreReg(IRI_QT_REG_TX_ACTIVE_ADDR, (ul_data<<16));

   //This register is used in QTP
    ul_data = (gs_TxNumTonesUsed - 1) << 13;
    if(gs_TxNumTonesUsed <= 0)
    {
        ul_data = 0;
    }
   WriteCoreReg(IRI_QTP_REG_TXTC_ACTIVE_ADDR, ul_data);

   //set TC direction from inactive to active
   ResetCoreReg(IRI_QTP_REG_TXTC_CTRL_ADDR, MASK_BIT0);

   SetCoreReg(IRI_QTP_REG_TX_CTRL_ADDR, 1);
}

/*
*-------------------------------------------------------------------------------
*
*   Prototype: void SwitchRxPingPongTable(void)
*
*   This function switches the bank of RX ping-pong table used by BAT, GST, EGT,
*   and TRT by toggling RPP bit in IR_MISC register.
*   It also updates the active/inactive pointers to BAT/GST/EGT/TRT.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/
void SwitchRxPingPongTable(void)
{
   // Set TBLCP_ENA bit - auto cleared after copy
   SetCoreReg(IRI_QTP_REG_RX_CTRL_ADDR, 1);
}

// XDSLRTFW-3280 - Start - PLL improvement / pilot tone selection improvement
/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : CopyPilotTone
 *
 *  Description:  Pilot tone data is copied form FFT output
 *
 *  Prototype:  void CopyPilotTone(FlagT IsSyncSymbol)
 *
 *
 *  Input Arguments:
 *       Flag to differentiate between data and sync symbol
 *
 *  Output Arguments:
 *      None
 *
 *  Return:
 *          None
 *
 *  Global Variables Used:
 *      gs_CopyPilotFromRegisters
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */
void CopyPilotTone(FlagT IsSyncSymbol)
{
   uint32 ul_data;

   if(IsSyncSymbol)
   {
      // Read 1st RX Pilot tone
      ReadCoreReg(IRI_QT_REG_RX_PILOT_ADDR, &ul_data);
      gt_PilotConfig.ta_PilotTones[0].s_PilotToneAtSyncSymb_Re = (int16)(ul_data & 0xFFFF);
      gt_PilotConfig.ta_PilotTones[0].s_PilotToneAtSyncSymb_Im = (int16)(ul_data >> 16);

      // Read 2nd Pilot tone
      ReadCoreReg(IRI_QT_REG_RX_PILOT1_ADDR, &ul_data);
      gt_PilotConfig.ta_PilotTones[1].s_PilotToneAtSyncSymb_Re = (int16)(ul_data & 0xFFFF);
      gt_PilotConfig.ta_PilotTones[1].s_PilotToneAtSyncSymb_Im = (int16)(ul_data >> 16);

      // Read 3rd Pilot tone
      ReadCoreReg(IRI_QT_REG_RX_PILOT2_ADDR, &ul_data);
      gt_PilotConfig.ta_PilotTones[2].s_PilotToneAtSyncSymb_Re = (int16)(ul_data & 0xFFFF);
      gt_PilotConfig.ta_PilotTones[2].s_PilotToneAtSyncSymb_Im = (int16)(ul_data >> 16);
   }
   else
   {
      // Read 1st RX Pilot tone
      ReadCoreReg(IRI_QT_REG_RX_PILOT_ADDR, &ul_data);
      gt_PilotConfig.ta_PilotTones[0].s_PilotTone_Re = (int16)(ul_data & 0xFFFF);
      gt_PilotConfig.ta_PilotTones[0].s_PilotTone_Im = (int16)(ul_data >> 16);

      // Read 2nd Pilot tone
      ReadCoreReg(IRI_QT_REG_RX_PILOT1_ADDR, &ul_data);
      gt_PilotConfig.ta_PilotTones[1].s_PilotTone_Re = (int16)(ul_data & 0xFFFF);
      gt_PilotConfig.ta_PilotTones[1].s_PilotTone_Im = (int16)(ul_data >> 16);

      // Read 3rd Pilot tone
      ReadCoreReg(IRI_QT_REG_RX_PILOT2_ADDR, &ul_data);
      gt_PilotConfig.ta_PilotTones[2].s_PilotTone_Re = (int16)(ul_data & 0xFFFF);
      gt_PilotConfig.ta_PilotTones[2].s_PilotTone_Im = (int16)(ul_data >> 16);
   }

   gt_PilotConfig.usa_PilotToneConstellation[0] = gt_PilotConfig.ta_PilotTones[gt_PilotConfig.te_UsedPTArrayIdx].s_PilotTone_Re;
   gt_PilotConfig.usa_PilotToneConstellation[1] = gt_PilotConfig.ta_PilotTones[gt_PilotConfig.te_UsedPTArrayIdx].s_PilotTone_Im;
}
// XDSLRTFW-3280 - End - PLL improvement / pilot tone selection improvement

// XDSLRTFW-3280 - Start - PLL improvement / pilot tone selection improvement
/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : SetRxPilotTone
 *
 *  Description:  Configure QT RX pilot tone index register
 *
 *  Prototype:  void SetRxPilotTone(void)
 *
 *
 *  Input Arguments: None.
 *
 *  Output Arguments: None.
 *
 *
 *  Return:
 *          None
 *
 *  Global Variables Used:
 *      gt_PilotConfig.ta_PilotTones[0].s_PilotToneIdx
 *      gt_PilotConfig.ta_PilotTones[1].s_PilotToneIdx
 *      gt_PilotConfig.ta_PilotTones[2].s_PilotToneIdx
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */
void SetRxPilotToneIndex(void)
{
   // Set RX pilot index and enable pilot tone latching
   WriteCoreReg(IRI_QT_REG_RX_PTINDEX_ADDR , (uint32)((gt_PilotConfig.ta_PilotTones[0].s_PilotToneIdx & 0x1FFF) | MASK_BIT13));
   WriteCoreReg(IRI_QT_REG_RX_PTINDEX1_ADDR, (uint32)((gt_PilotConfig.ta_PilotTones[1].s_PilotToneIdx & 0x1FFF) | MASK_BIT13));
   WriteCoreReg(IRI_QT_REG_RX_PTINDEX2_ADDR, (uint32)((gt_PilotConfig.ta_PilotTones[2].s_PilotToneIdx & 0x1FFF) | MASK_BIT13));
   gt_PilotConfig.sa_PilotTonesIndex[0] = gt_PilotConfig.ta_PilotTones[0].s_PilotToneIdx;
   gt_PilotConfig.sa_PilotTonesIndex[1] = gt_PilotConfig.ta_PilotTones[1].s_PilotToneIdx;
   gt_PilotConfig.sa_PilotTonesIndex[2] = gt_PilotConfig.ta_PilotTones[2].s_PilotToneIdx;
}
// XDSLRTFW-3280 - End - PLL improvement / pilot tone selection improvement


/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : IridiaControlCommon
 *
 *  Description: Configure RTV0 according to gs_RtvSelect and check for
 *             LUT access errors
 *
 *  Prototype:  void IridiaControlCommon(void)
 *
 *  Input Arguments: None.
 *
 *  Output Arguments: None.
 *
 *  Return: None
 *
 *  Global Variables Used: None
 *      gs_RtvSelect
 *      gs_RtvSelectLastFrame
 *      gp_RxLoadingFunctionFifo
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */
void ConfigRTVBuf0_train(void);
void ConfigRTVBuf0_ACC_OUT_train(void);

void IridiaControlCommon(void)
{
   // If current RtvSelect is different from last frame, configure the RTV accordingly
   if (gs_RtvSelect != gs_RtvSelectLastFrame)
   {
      if(gs_RtvSelect != RTV_NOTYPE)
      {
         //if((gs_RtvSelect == FFT_OUTPUT) || (gs_RtvSelect == SFDQ_OUTPUT) || (gs_RtvSelect == ERROR_OUTPUT))
         if((gs_RtvSelect & HW_ACCUM_POW) == 0)
         {
            AddFunctionToFifo(gp_RxLoadingFunctionFifo, ConfigRTVBuf0_train);
         }
         else
         {
            AddFunctionToFifo(gp_RxLoadingFunctionFifo, ConfigRTVBuf0_ACC_OUT_train);
         }
      }

      gs_RtvSelectLastFrame = gs_RtvSelect;
   }

}

/*
*-------------------------------------------------------------------------------
*
*   Prototype:  ConfigRTVBuf0_train(void)
*
*   This function configures RTV buffer 0 to store FFT/ERR/SFDQ output.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/
void ConfigRTVBuf0_train(void)
{
   uint32 ul_tmpWord;
   ul_tmpWord = (uint32)(gs_RtvSelect << 25)
            | gs_RxToneOffset                // Init offset for RTV buffer 0 to 0
            | (1<<31); // Enable RTV capture

   if(gs_RtvSelect == ERROR_OUTPUT)
      ul_tmpWord |= (1<<28);        // Disable tone rotation

   WriteCoreReg(IRI_QT_REG_RX_FD_RNG0_ADDR, ul_tmpWord);

   ul_tmpWord = (gs_NumChannelsPerGroup-1);            // Number of tones to store - 1, starting at RTV_OFFSET0
   WriteCoreReg(IRI_QT_REG_RX_FD_RNG0_CNT_35B_ADDR, ul_tmpWord);

   //Disable IR_REIM_ACCUM, IR_NPR_ACCUM and VECPOW_ACCUM
   ResetCoreReg(IRI_QT_REG_RX_MISC_ADDR, (uint32)(0x7<<21));

   //Disable RTV1
   ResetCoreReg(IRI_QT_REG_RX_FD_RNG1_ADDR, (1<<31));
}

/*
*-------------------------------------------------------------------------------
*
*   Prototype:  ConfigRTVBuf0_ACC_OUT_train(void)
*
*   This function configures RTV buffer 0 to the accumulated signal/noise power.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/
void ConfigRTVBuf0_ACC_OUT_train(void)
{
   uint32 ul_tmpWord;
   int16 s_RtvOutput;

   s_RtvOutput = gs_RtvSelect & 0xFF;

   ul_tmpWord =  (1<<28)                        // Disable tone rotation
            | (s_RtvOutput << 25)               // Write Error output to RTV buffer 0
            | gs_RxToneOffset                // Init offset for RTV buffer 0 to 0
            | (0<<31);                       // Do not enable RTV capture
   WriteCoreReg(IRI_QT_REG_RX_FD_RNG0_ADDR, ul_tmpWord);

   ul_tmpWord =  (gs_NumChannelsPerGroup-1);       // Number of tones to store - 1
   WriteCoreReg(IRI_QT_REG_RX_FD_RNG0_CNT_35B_ADDR, ul_tmpWord);

   //Disable IR_REIM_ACCUM, IR_NPR_ACCUM and VECPOW_ACCUM
   ResetCoreReg(IRI_QT_REG_RX_MISC_ADDR, (uint32)(0x7<<21));

   //Enable IR_NPR_ACCUM
   SetCoreReg(IRI_QT_REG_RX_MISC_ADDR, (uint32)(1<<22));

   //Disable RTV1
   ResetCoreReg(IRI_QT_REG_RX_FD_RNG1_ADDR, (1<<31));
}

/***************************************************************************************
;   Subroutine Name: void ZeroTxOutbandTones(void)
;
;   Description:
;      This function configure the QT register to set the outband of TX tones to 0.
;
;   Input Arguments:
;      none
;
;   Output Arguments:
;      none
;
;   Return Value:
;      none
;
;**********************************************************************************************/
void ZeroTxOutbandTones(void)
{
   uint32 ul_addr;
   int16 s_band_idx, s_start_tone, s_end_tone, s_max_num_bands;


   //Clear all IT_IFFT_RNGx registers

   s_max_num_bands = MIN(gs_NumOfTxBands, 6);

   //Initialize the start tone of the first band to be zeroed out
   s_start_tone = 0;

   ul_addr = IRI_QT_REG_TX_IFFTZ_RNG0_ADDR;

#define RNG_ENA   (1)
   for(s_band_idx = 0; s_band_idx < s_max_num_bands; s_band_idx++)
   {
      //Set the end tone of the current band
      s_end_tone = gsa_TxBandLeftChannel[s_band_idx]-1;

      //Set IT_IFFT_RNGx register to zero out tones in this range
      //XDSLRTFW-465 Bug_Fix_in_ZeroTxOutbandTones (start)
      if(s_end_tone >= s_start_tone)
      {
      WriteCoreReg(ul_addr, (s_end_tone<<14)|(s_start_tone<<1)|RNG_ENA);
      }
      else  // disable the register
      {
         WriteCoreReg(ul_addr, 0);
      }
      //XDSLRTFW-465 Bug_Fix_in_ZeroTxOutbandTones (end)
      ul_addr += 4;

      //Set the start tone of the next band
      s_start_tone = gsa_TxBandRightChannel[s_band_idx] + 1;
   }

   //Set the tones above the last band to 0
   if(s_band_idx < 6)
   {
      //Set the end tone of the last zero band
      s_end_tone = gs_TxNumTones-1;

      //Set IT_IFFT_RNGx register to zero out tones in this range
      //XDSLRTFW-465 Bug_Fix_in_ZeroTxOutbandTones (start)
      if(s_end_tone >= s_start_tone)
      {
        WriteCoreReg(ul_addr, (s_end_tone<<14)|(s_start_tone<<1)|RNG_ENA);
      }
      else // disable the register
      {
         WriteCoreReg(ul_addr, 0);
      }
      //XDSLRTFW-465 Bug_Fix_in_ZeroTxOutbandTones (start)
      ul_addr += 4;
   }

   //Disable the other registers
   s_band_idx++;
   while(s_band_idx < 6)
   {
      WriteCoreReg(ul_addr, 0);
      ul_addr += 4;
      s_band_idx++;
   }


} //void ZeroTxOutbandTones(void)


/*
*-------------------------------------------------------------------------------
*
*   Prototype: void ResetNoisePowerBuffer(void)
*
*   This clears the RTV accumulator buffer
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/
void ResetNoisePowerBuffer(void)
{
   //Use ADMA Queues to do the ADMA to save DSP mips
   if (TESTArray[TEST_Control4] & TEST_Control4_Ena_StAdma_Queue_Bit3_Mask)
   {
      gul_35bLiteConfig |= EN_ADMA_COPYBETWEEN_XRAM_RTV;
   }

   FillCoreBuf32((uint32)(IRI_QT_RAM_RX_NOISE_ACCMR_LSW_ADDR), (int32)0, (uint16)gs_AlgNumTonesToProcess);
   FillCoreBuf32((uint32)(IRI_QT_RAM_RX_NOISE_ACCMR_MSW_ADDR), (int32)0, (uint16)gs_AlgNumTonesToProcess);
//   FillCoreBuf32((uint32)(IRI_QT_RAM_RX_NOISE_ACCMR_LSW_ADDR), (int32)0, (uint16)RTV_BUF_NUM_TONES);
//   FillCoreBuf32((uint32)(IRI_QT_RAM_RX_NOISE_ACCMR_MSW_ADDR), (int32)0, (uint16)RTV_BUF_NUM_TONES);
   gul_35bLiteConfig &= ~(EN_ADMA_COPYBETWEEN_XRAM_RTV);
}

void ResetFdQBuffer(void)
{
   // Clear FDQ mantissa and exponent
//   StoreFdqMant((int16 *)(void *)gpla_RxAccumBuf, gs_LeftChannel, (uint16)gs_NumOfTonesInBand);
//   StoreFdqExp((uint8 *)(void *)gpla_RxAccumBuf, gs_LeftChannel, (uint16)gs_NumOfTonesInBand);
   FillCoreBuf32((uint32)(IRI_QT_RAM_FDQ_MANT_ADDR + (gs_LeftChannel<<2)), (int32)0, (uint16)gs_NumOfTonesInBand);
   FillCoreBuf32((uint32)(IRI_QT_RAM_FDQ_EXP_ADDR + (gs_LeftChannel<<2)), (int32)0, (uint16)gs_NumOfTonesInBand);
}

void EnableNPRWrite(void)
{
   uint32 ul_tmpWord;

   // This code is needed since a not understood problem will
   // lead to an zero noise for the last tone of a band if the
   // number of tones to calculate is odd, i.e. even when the -1 is done!
   // Now for odd tone number one value more gets be programmed.
   if ((gs_AlgNumTonesToProcess & 0x0001) == 0)
   {
      ul_tmpWord = gs_AlgNumTonesToProcess-1;
   }
   else
   {
      ul_tmpWord = gs_AlgNumTonesToProcess;
   }
   WriteCoreReg(IRI_QT_REG_RX_FD_RNG0_CNT_35B_ADDR, ul_tmpWord);
   //Enable IR_NPR_ACCUM
   SetCoreReg(IRI_QT_REG_RX_MISC_ADDR, (uint32)(1<<22));
}

/***************************************************************************************
;   Subroutine Name: ReadAccumulatedNoise
;
;   Description:
;      This routine reads the low and high words of the Accumulated Noise Power per tone.
;
;   Prototype:
;      void GetRxTones(void)
;
;   Input Arguments:
;
;   Output Arguments:
;      none
;
;   Return Value:
;      none
;
;   Global Variables:
;      gs_RtvSelect (I)      - FFT_OUTPUT: RTV0, SFDQ_OUTPUT: RTV1
;      gpsa_RxToneBuf (O)      - output from FDQ
;
;   Substates:
;             None
;
;**********************************************************************************************/
void ReadAccumulatedNoise(void)
{
   int32 *pla_addr;
   uint32 ul_LSW ,  ul_MSW;
   int i;
   pla_addr = gpla_RxAccumBuf;

   ul_LSW  = IRI_QT_RAM_RX_NOISE_ACCMR_LSW_ADDR;
   ul_MSW  = IRI_QT_RAM_RX_NOISE_ACCMR_MSW_ADDR;

   for (i=0 ; i < gs_AlgNumTonesToProcess ; i++ )
   {
      ReadCoreReg(ul_LSW , pla_addr);
      pla_addr++;
      ul_LSW+=4;
      ReadCoreReg(ul_MSW , pla_addr);
      pla_addr++;
      ul_MSW+=4;
   }
}

//XDSLRTFW-1243 Feature_ALL_VDSL2_ALL_CMV_MipsProfiling (Start)
//Added a new wrapper func to read Accumulated noise data using DMA -> To save Mips in RXTC task
void ReadAccumulatedNoise2(void)
{
   CopyAccumulatedNoisefromRTV();
}
//XDSLRTFW-1243 Feature_ALL_VDSL2_ALL_CMV_MipsProfiling (End)

/***************************************************************************************
;   Subroutine Name: LoadAccumulatedNoisetoRTV
;
;   Description:
;      This routine loads data from accum buffer located in XY-MEM to RTV0 and RTV1
;
;   Prototype:
;      void LoadAccumulatedNoisetoRTV(void)
;
;   Input Arguments:
;
;   Output Arguments:
;      none
;
;   Return Value:
;      none
;
;   Global Variables:
;      gs_RtvSelect (I)      - FFT_OUTPUT: RTV0, SFDQ_OUTPUT: RTV1
;      gpsa_RxToneBuf (O)      - output from FDQ
;
;   Substates:
;             None
;
;**********************************************************************************************/
void LoadAccumulatedNoisetoRTV(void)
{
   int32 *pla_addr;
   uint32 ul_LSW ,  ul_MSW;
   pla_addr = gpla_RxAccumBuf;

   ul_LSW  = IRI_QT_RAM_RX_NOISE_ACCMR_LSW_ADDR;
   ul_MSW  = IRI_QT_RAM_RX_NOISE_ACCMR_MSW_ADDR;

   /*
      for (i=0 ; i < gs_AlgNumTonesToProcess ; i++ )
      {
       WriteCoreReg(ul_LSW , *pla_addr);
       pla_addr++;
       ul_LSW+=4;
       WriteCoreReg(ul_MSW , *pla_addr);
       pla_addr++;
       ul_MSW+=4;
      }
   */

   //The format is irrelavant, use DMA from RTVs to Accum Buffer to save MIPS.
   WriteCoreBuf32(ul_LSW, (void*)pla_addr, gs_AlgNumTonesToProcess );
   WriteCoreBuf32(ul_MSW, (void*)(&gpla_RxAccumBuf[gt_DDSnrFdqConfig.s_DDSnrFdqNumChannelsPerGroup]), gs_AlgNumTonesToProcess );
}

/***************************************************************************************
;   Subroutine Name: CopyAccumulatedNoisefromRTV
;
;   Description:
;      This routine copies data from RTV0 and RTV1 to accum buffer located in XY-MEM.
;
;   Prototype:
;      void CopyAccumulatedNoisefromRTV(void)
;
;   Input Arguments:
;
;   Output Arguments:
;      none
;
;   Return Value:
;      none
;
;   Global Variables:
;      gs_RtvSelect (I)      - FFT_OUTPUT: RTV0, SFDQ_OUTPUT: RTV1
;      gpsa_RxToneBuf (O)      - output from FDQ
;
;   Substates:
;             None
;
;**********************************************************************************************/
void CopyAccumulatedNoisefromRTV(void)
{
   int32 *pla_addr;
   uint32 ul_LSW ,  ul_MSW;
   pla_addr = gpla_RxAccumBuf;

   ul_LSW  = IRI_QT_RAM_RX_NOISE_ACCMR_LSW_ADDR;
   ul_MSW  = IRI_QT_RAM_RX_NOISE_ACCMR_MSW_ADDR;

   //The format is irrelavant, use DMA from Accum Buffer to RTVs to save MIPS.
   ReadCoreBuf32(ul_LSW,(int16 *)(void *) pla_addr, gs_AlgNumTonesToProcess);
   ReadCoreBuf32(ul_MSW,(int16 *)(void *) (&gpla_RxAccumBuf[gt_DDSnrFdqConfig.s_DDSnrFdqNumChannelsPerGroup]), gs_AlgNumTonesToProcess );

}

/***************************************************************************************
;   Subroutine Name: DisableNPRWrite
;
;   Description:
;      This routine disables any write to NPR buffer.
;
;   Prototype:
;      void DisableNPRWrite(void)
;
;   Input Arguments:
;
;   Output Arguments:
;      none
;
;   Return Value:
;      none
;
;   Global Variables:
;
;
;   Substates:
;             None
;
;**********************************************************************************************/
void DisableNPRWrite(void)
{
   ResetCoreReg(IRI_QT_REG_RX_MISC_ADDR, (uint32)(1<<22));
}

/***************************************************************************************
;   Subroutine Name: CheckQTError
;
;   Description:
;      This routine check the QT error status bits to record the number of errors
;
;   Prototype:
;      void CheckQTError(void)
;
;   Input Arguments:
;
;   Output Arguments:
;
;   Return Value:
;      none
;
;   Global Variables:
;
;
;   Substates:
;             None
;
;**********************************************************************************************/
#ifdef ENABLE_VR9_HW_ERR_CNT

#define QT_ERROR_MASK_BITS      (0x00000780)
void CheckQTError(void)
{
   int16 i, j;

   // Read TX QT error register
   ReadCoreReg((uint32)IRI_QT_REG_TX_MISC_ADDR, &gul_TXQT_ErrorData);

   //Mask the error bits only
   gul_TXQT_ErrorData &= QT_ERROR_MASK_BITS;

   //Clear error bits
   ResetCoreReg((uint32)IRI_QT_REG_TX_MISC_ADDR, QT_ERROR_MASK_BITS);

   // Read RX QT error register
   ReadCoreReg((uint32)IRI_QT_REG_RX_MISC_ADDR, &gul_RXQT_ErrorData);

   //Mask the error bits only
   gul_RXQT_ErrorData &= QT_ERROR_MASK_BITS;

   //Clear error bits
   ResetCoreReg((uint32)IRI_QT_REG_RX_MISC_ADDR, QT_ERROR_MASK_BITS);

   //Update the TX error count counter
   for(i=7, j=0; i<=10; i++, j++)
   {
      if((gul_TXQT_ErrorData & (1<<i)) && (gsa_TxQTErrorCnt[j] < 0xFFFF))
      {
         gsa_TxQTErrorCnt[j]++;
      }

      if((gul_RXQT_ErrorData & (1<<i)) && (gsa_RxQTErrorCnt[j] < 0xFFFF))
      {
         gsa_RxQTErrorCnt[j]++;
      }
   }
} //void CheckQTError(void)

#endif //#ifdef ENABLE_VR9_HW_ERR_CNT

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : IridiaTxGainScaleDataPathControl
 *
 *  Description:  This function configure the Tx Gain scale data path in Iridia QT module by
 *  configuring REF_GAIN_ENA bit of IT_MISC and IT_REF_GAIN registers. In other words this
 *  function couples either GAIN TABLE or IT_REF_GAIN (which contains a fixed gain value)
 *  register on Tx Data path
 *
 *   Description from Iirdia QT Spec :
 *  If the REF_GAIN_ENA (bit 4) bit of IT_MISC is set, then the hardware will multiply
 *  a Q2.13 unsigned gain value contained in the IT_REF_GAIN register (instead
 *  of the product of the gain (g i ) and tss i  values) with the constellation
 *  gain for a 4-QAM (2-bit) constellation, since that is the size of all
 *  constellation values employed during a reference frame.  This product will
 *  then be multiplied with the X and Y constellation points (see section 2.1.2.5
 *  in Iridia-QT.doc ).
 *
 *  Prototype:  void IridiaTxGainScaleDataPathControl(void)
 *
 *  Input Arguments: None.
 *
 *  Output Arguments: None.
 *
 *  Return:   None
 *
 *  Global Variables Used:
 *       gus_RefGain :   Unsigned (2.13) gain value to be multiplied by 4-QAM constellation gain
 *                      and then applied to constellation output from PRBS encoding when the
 *                      REF_GAIN_ENA bit of IT_MISC is set. Applied to all nonzero physical tones.
 *                  Unity Gain = 0x2000
 *
 *
 *       gft_IT_MISC_RefGainEna : 1 = Enable use of REF_GAIN value instead of gain scale table.
 *                          0 = Obtain gain scale values from gain scale table.
 *
 *  Notes: before using this function please initialize gus_RefGain & gft_IT_MISC_RefGainEna correctly
 *
 *------------------------------------------------------------------------
 *^^^
 */
void IridiaTxGainScaleDataPathControl(void)
{
   // set IT_REF_GAIN register value
   WriteCoreReg(IRI_QT_REG_TX_REF_GAIN_ADDR, (uint32)gus_RefGain);

   if (gft_IT_MISC_RefGainEna)
   {
      SetCoreReg(IRI_QT_REG_TX_MISC_ADDR, MASK_BIT4);   // coupled IT_REF_GAIN register on Tx data path
   }
   else
   {
      ResetCoreReg(IRI_QT_REG_TX_MISC_ADDR, MASK_BIT4);   // coupled GAIN TABLE on Tx data path
   }

}
