/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 1998-2007 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *----------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Condfidential
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276-4000
 *   FAX   (781) 276-4001
 *
 *   IRI_IOf_FFT.C
 *
 *   Iridia Data Transfer Layer.
 *
 *
 *----------------------------------------------------------------------------
 */

#include "common.h"
#include "gdata.h"
#include "IRI_Iof.h"
#include "LL_Iof.h"
#include "string.h"
#include "states.h"
#include "cri_iof.h"
#include "ghs.h"
#include "ft_memmap.h"
#include "ftb_memmap.h"
#include "qt_memmap.h"
#include "cmv_Data.h"
#include "cmv.h"

#undef VR9_BRINGUP_DBG
/*
*-------------------------------------------------------------------------------
*
*   Prototype: void WhichIFFTBuffers(uint32 *pul_IFFTInputBuffer,
*      uint32 *pul_IFFTOutputBuffer)
*
*   This function identifies which IFFT input/output buffers can be used by DSP.
*
*   Input Arguments:
*
*   Output Arguments:
*      pul_FFTInputBuffer: pointer to the input IFFT buffer prior to
*         running the IFFT. This input buffer contains frequency domain data.
*      pul_FFTOutputBuffer: pointer to the output IFFT buffer after
*         running the IFFT. This output buffer contains time domain data.

  In BM6.1, input buffer and output buffer are the same as FFT / IFFT use in-place computation
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/

void WhichIFFTBuffers(uint32 *pul_IFFTInputBuffer, uint32 *pul_IFFTOutputBuffer)
{
   uint32 ul_TxBufferStat,  ul_TxIFFTInputBuffer;

   // Determine the Tx Strymon buffer status

   ReadCoreReg(IRI_FTB_TX_STATUS_ADDR, &ul_TxBufferStat);
   ul_TxIFFTInputBuffer = (ul_TxBufferStat & IRI_FTB_REG_TX_IFFT_BUF_STAT_MASK)>>3;

   switch(ul_TxIFFTInputBuffer)
   {
   case 0:
      *pul_IFFTInputBuffer = (uint32)IRI_FTB_IFFT_RAM_A_ADDR;
      *pul_IFFTOutputBuffer = (uint32)IRI_FTB_IFFT_RAM_A_ADDR;
      break;

   case 1:
      *pul_IFFTInputBuffer = (uint32)IRI_FTB_IFFT_RAM_B_ADDR;
      *pul_IFFTOutputBuffer = (uint32)IRI_FTB_IFFT_RAM_B_ADDR;
      break;

   case 2:
      *pul_IFFTInputBuffer = (uint32)IRI_FTB_IFFT_RAM_C_ADDR;
      *pul_IFFTOutputBuffer = (uint32)IRI_FTB_IFFT_RAM_C_ADDR;
      break;
   }

}

/*
*-------------------------------------------------------------------------------
*
*   Prototype: void WhichFFTBuffers(uint32 *pul_FFTInputBuffer,
*      uint32 *pul_FFTOutputBuffer)
*
*   This function identifies which FFT input/output buffers can be used by DSP.
*
*   Input Arguments:
*
*   Output Arguments:
*      pul_FFTInputBuffer: pointer to the input FFT buffer prior to
*         running the FFT. This input buffer contains time domain data.
*      pul_FFTOutputBuffer: pointer to the output FFT buffer after
*         running the FFT. This output buffer contains frequency domain data.

  In BM6.1, input buffer and output buffer are the same as FFT / IFFT use in-place computation

*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/

void WhichFFTBuffers(uint32 *pul_FFTInputBuffer, uint32 *pul_FFTOutputBuffer)
{
   uint32 ul_RxBufferStat, ul_RxFFTOutputBuffer;


   ReadCoreReg(IRI_FTB_RX_STATUS_ADDR, &ul_RxBufferStat);

   ul_RxFFTOutputBuffer = (ul_RxBufferStat & IRI_FTB_REG_RX_FFT_BUF_STAT_MASK)>>3;

   switch(ul_RxFFTOutputBuffer)
   {
   case 0:
      *pul_FFTInputBuffer = (uint32)IRI_FTB_FFT_RAM_A_ADDR;
      *pul_FFTOutputBuffer = (uint32)IRI_FTB_FFT_RAM_A_ADDR;
      break;

   case 1:
      *pul_FFTInputBuffer = (uint32)IRI_FTB_FFT_RAM_B_ADDR;
      *pul_FFTOutputBuffer = (uint32)IRI_FTB_FFT_RAM_B_ADDR;
      break;

   case 2:
      *pul_FFTInputBuffer = (uint32)IRI_FTB_FFT_RAM_C_ADDR;
      *pul_FFTOutputBuffer = (uint32)IRI_FTB_FFT_RAM_C_ADDR;
      break;
   }


}

/*
*-------------------------------------------------------------------------------
*
*   Prototype: void LoadSingleToneToIfftBuf(void)
*
*   This function loads a single tone to the IFFT input buffer.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*      gsa_TxSingeToneBuf[] -- (I) buffer containing the tone magnitude
*      TESTArray[TEST_TxTestTone] -- (I) the tone index to be loaded
*      gs_TxAbgtOffset -- (I) the base address of TX active BGTN buffer
*-------------------------------------------------------------------------------
*/

// XDSLRTFW-3681 (Start)
void LoadSingleToneToIfftBuf(void)
{
   uint32 ul_regData, ul_offset;
   int16 i = 0;
   uint16 us_toneNumber, us_dci_starting_addr, us_dci_ending_addr;
   int16 *ps_AEGTN;

   //Put the DCI after the TX tones
   us_dci_starting_addr = gs_TxNumTonesUsed+2;

   ul_offset = IRI_QT_RAM_ACTIVE_BGTN_ADDR + ((gs_TxAbgtOffset+us_dci_starting_addr)<<2)-4;
   ps_AEGTN = (int16 *) (IRI_QT_RAM_TX_ACTIVE_EGT_ADDR + ((gs_TxAbgtOffset+us_dci_starting_addr)<<1)-2);

   us_toneNumber = TESTArray[TEST_TxTestTone];  //Get tone number first.

   //Start & end tone is the same because we only write to a single tone.
   ul_offset += 4;
   ps_AEGTN++;  //To Write Start Tone Index
   *ps_AEGTN = (us_toneNumber << 3);  //Start Tone Index <15:3>
   WriteCoreReg(ul_offset, (uint32) ((us_toneNumber << 15) & 0x0FFF8000));    //<31:28> unused, <27:15> End Tone, <14:0> unused & Masked

   ps_AEGTN++;  //To write Real component           <12:0> @ AEGTN<15:3>
   *ps_AEGTN = ((gsa_TxSingleToneBuf[i*2] << 3) & 0xFFF8); //<15:3> Real <12:0>
   ul_offset += 4;  //To write Imaginary <15:0> & Real <15:13> @ ABGTN <30:15> Imag<15:0>, ABGTN <14:12> Real<15:12>
   WriteCoreReg(ul_offset, (int32) (((gsa_TxSingleToneBuf[(i*2)+1] << 15) | (gsa_TxSingleToneBuf[i*2] >> 1)) & 0x7FFFF000));

   us_dci_ending_addr = ((ul_offset - IRI_QT_RAM_ACTIVE_BGTN_ADDR)>>2) - gs_TxAbgtOffset;

   ul_regData = ((us_dci_ending_addr<<14) | (us_dci_starting_addr<<1) | (1<<0));
   WriteCoreReg(IRI_QT_REG_TX_DCI_CTRL_ADDR, ul_regData ); //Enable Direct Copy to IFFT in QT.
}
// XDSLRTFW-3681 (End)

// XDSLRTFW-2373
#define R_ACT_REQ_TONE  8
// XDSLRTFW-3681 (Start)
void LoadT1413ToneToIfftBuf (void)
{
   uint32 ul_regData, ul_offset;
   int16 i = 0;
   uint16 us_toneNumber, us_dci_starting_addr, us_dci_ending_addr;
   int16 *ps_AEGTN;

   //Put the DCI after the TX tones
   us_dci_starting_addr = gs_TxNumTonesUsed+2;

   ul_offset = IRI_QT_RAM_ACTIVE_BGTN_ADDR + ((gs_TxAbgtOffset+us_dci_starting_addr)<<2)-4;
   ps_AEGTN = (int16 *) (IRI_QT_RAM_TX_ACTIVE_EGT_ADDR + ((gs_TxAbgtOffset+us_dci_starting_addr)<<1)-2);

   us_toneNumber = R_ACT_REQ_TONE;  //Get tone number first.

   //Start & end tone is the same because we only write to a single tone.
   ul_offset += 4;
   ps_AEGTN++;  //To Write Start Tone Index
   *ps_AEGTN = (us_toneNumber << 3);  //Start Tone Index <15:3>
   WriteCoreReg(ul_offset, (uint32) ((us_toneNumber << 15) & 0x0FFF8000));    //<31:28> unused, <27:15> End Tone, <14:0> unused & Masked

   ps_AEGTN++;  //To write Real component           <12:0> @ AEGTN<15:3>
   *ps_AEGTN = ((gsa_TxGhsToneBuf[i*2] << 3) & 0xFFF8); //<15:3> Real <12:0>
   ul_offset += 4;  //To write Imaginary <15:0> & Real <15:13> @ ABGTN <30:15> Imag<15:0>, ABGTN <14:12> Real<15:12>
   WriteCoreReg(ul_offset, (int32) (((gsa_TxGhsToneBuf[(i*2)+1] << 15) | (gsa_TxGhsToneBuf[i*2] >> 1)) & 0x7FFFF000));

   us_dci_ending_addr = ((ul_offset - IRI_QT_RAM_ACTIVE_BGTN_ADDR)>>2) - gs_TxAbgtOffset;

   ul_regData = ((us_dci_ending_addr<<14) | (us_dci_starting_addr<<1) | (1<<0));
   WriteCoreReg(IRI_QT_REG_TX_DCI_CTRL_ADDR, ul_regData ); //Enable Direct Copy to IFFT in QT.
}
// XDSLRTFW-3681 (End)
/*
*-------------------------------------------------------------------------------
*
*   Prototype: void LoadGhsTonesToIfftBuf(void)
*
*   This function loads the GHS tones to the IFFT input buffer.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*      gsa_TxGhsToneBuf[] -- (I) buffer containing the GHS tones
*      gs_GhsCarSetCfgInternal -- (I) indicator of the GHS set selection
*      gs_TxAbgtOffset -- (I) the base address of TX active BGTN buffer
*-------------------------------------------------------------------------------
*/

//Mei debug
int16 gs_DCI_Start = -1;

void LoadGhsTonesToIfftBuf(void)
{
   uint32 ul_regData, ul_offset;
   int16 i,j,s_temp;
   uint16 us_toneNumber, us_dci_starting_addr, us_dci_ending_addr;
   int16 *ps_AEGTN;
   int16 s_TxScale[6],i2;


   //Put the DCI after the TX tones
   if(gs_DCI_Start < 0)
   {
      us_dci_starting_addr = gs_TxNumTonesUsed+2;
   }
   else
   {
      us_dci_starting_addr = gs_DCI_Start + 2;
   }

   ul_offset = IRI_QT_RAM_ACTIVE_BGTN_ADDR + ((gs_TxAbgtOffset+us_dci_starting_addr)<<2)-4;
   ps_AEGTN = (int16 *) (IRI_QT_RAM_TX_ACTIVE_EGT_ADDR + ((gs_TxAbgtOffset+us_dci_starting_addr)<<1)-2);

//Mei debug
   {
      //Load GHS tones to Tx Active BGTN table (and later loaded to IFFT buffer by QT)
      //For each Carrier Set
      for(j=0; j<NUM_CARRIER_SETS; j++)
      {
         // Check if the bitmask for the Carrier Set is enabled
         s_temp = (int16) (1 << j);

         if (gs_GhsCarSetCfgInternal & s_temp)
         {
            for(i=0; i<NUM_CARRIER; i++)
            {
               i2=2*i;
               // scale V43 carrier set (standard requires these to be at -16.65dBm
               if (s_temp == 64)
               {
                  // For BJ Hybrid we have +2dB as L2DGain, we see 1dB violation
                  // Reduce 1dB on V43 power for BJ hybrid
                  // As the Var Gain is increased by 2dB in general and Scale V43 accordingly by 2dB more
                  s_TxScale[i2] = (int16)(( gsa_TxGhsToneBuf[i2] * (int32)355)>>10); // scale V43 tones by 9dB (=20*log(407/2^10))
                  s_TxScale[i2+1] = (int16)(( gsa_TxGhsToneBuf[i2+1] * (int32)355)>>10); // scale V43 tones by 9dB (=20*log(407/2^10))
                  //XDSLRTFW-554 : BUG_US_ALL_ALL_GHSPOWER
               }
               else
               {
                  //XDSLRTFW-554 : BUG_US_ALL_ALL_GHSPOWER
                  if(s_temp == CNFG_GHS_CAR_SET_A43 ||
                        s_temp == CNFG_GHS_CAR_SET_A43C ||
                        s_temp == CNFG_GHS_CAR_SET_B43 ||
                        s_temp == CNFG_GHS_CAR_SET_B43C ) // XDSLRTFW-1226 : BUG_US_ALL_ALL_GHSPOWER_B43C (Start_End)
                  {
                     //Increase by 5dB
                     s_TxScale[i2] = gsa_TxGhsToneBuf[i2] + (gsa_TxGhsToneBuf[i2]/4)*3;
                     s_TxScale[i2+1] = gsa_TxGhsToneBuf[i2+1] + (gsa_TxGhsToneBuf[i2+1]/4)*3;
                  }
                  //XDSLRTFW-554 : BUG_US_ALL_ALL_GHSPOWER
                  else
                  {
                     s_TxScale[i2] = gsa_TxGhsToneBuf[i2];
                     s_TxScale[i2+1] = gsa_TxGhsToneBuf[i2+1];
                  }
               }

               us_toneNumber = gpsa_TxCarSetTable[j*NUM_CARRIER + i];  //Get tone number first.

               //Start & end tone is the same because we only write to a single tone.
               ul_offset += 4;
            ps_AEGTN++;  //To Write Start Tone Index
            *ps_AEGTN = (us_toneNumber << 3);  //Start Tone Index <15:3>
            WriteCoreReg(ul_offset, (uint32) ((us_toneNumber << 15) & 0x0FFF8000));    //<31:28> unused, <27:15> End Tone, <14:0> unused & Masked


            ps_AEGTN++;  //To write Real component    <12:0> @ AEGTN<15:3>
            *ps_AEGTN = ((gsa_TxGhsToneBuf[i*2] << 3) & 0xFFF8); //<15:3> Real <12:0>
            ul_offset += 4;  //To write Imaginay <15:0> & Real <15:13> @ ABGTN <30:15> Imag<15:0>, ABGTN <14:12> Real<15:12>
            WriteCoreReg(ul_offset, (int32) (((gsa_TxGhsToneBuf[(i*2)+1] << 15) | (gsa_TxGhsToneBuf[i*2] >> 1)) & 0x7FFFF000));
            }
         } //if (gs_GhsCarSetCfgInternal & s_temp)
      } //for(j=0; j<NUM_CARRIER_SETS; j++)
   }

   us_dci_ending_addr = ((ul_offset - IRI_QT_RAM_ACTIVE_BGTN_ADDR)>>2) - gs_TxAbgtOffset;

    ul_regData = ((us_dci_ending_addr<<14) | (us_dci_starting_addr<<1) | (1<<0));
   WriteCoreReg(IRI_QT_REG_TX_DCI_CTRL_ADDR, ul_regData ); //Enable Direct Copy to IFFT in QT.


}


/*
*-------------------------------------------------------------------------------
*
*   Prototype: void DisableDCI(void)
*
*   This function disables Direct Copy to IFFT buffer
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*-------------------------------------------------------------------------------
*/

void DisableDCI(void)
{
   WriteCoreReg(IRI_QT_REG_TX_DCI_CTRL_ADDR, (uint32) 0);
}

#ifdef USE_ENGINE_FOR_BG_FFTS
/***************************************************************************************
;   Subroutine Name: LoadFFTInput
;
;   Description:
;      This loading function copies a time domain signal to be transformed from the task layer to
;      Iridia's FFT buffer.
;
;   Prototype:
;      void LoadFFTInput(void)
;
;   Input Arguments:
;      None.
;
;   Output Arguments:
;      None.
;
;   Return Value:
;      none
;
;   Global Variables:
;       gs_EngineFFTSize - Specifies size of FFT. Equal to either 128 or 256.
;      gpsa_EngineFFTInput - Pointer to time-domain real-valued buffer of size 2*gs_FastFFTSize.
;
;   Substates:
;
;**********************************************************************************************/
void LoadEngineFFTInput(void)
{
   uint16 RealPart;   /* points to IRI_RAM_RX_FFT_A0 or IRI_RAM_RX_FFT_B0 */
   uint16 ImagPart;   /* points to IRI_RAM_RX_FFT_A1 or IRI_RAM_RX_FFT_B1 */

   WhichFFTBuffers(&RealPart,&ImagPart);

   if(gs_EngineFFTSize == 128)
   {

      WriteCoreBuf32LowHigh(RealPart, gpsa_EngineFFTInput, (int16)(2*gs_EngineFFTSize), 0);
      FillCoreBuf32LowHigh(RealPart, 0, gs_EngineFFTSize, 1);

   }
   else     // Assumed that gs_EngineFFTSize == 256
   {

      WriteCoreBuf32(RealPart, gpsa_EngineFFTInput, gs_EngineFFTSize);

   }
}

/***************************************************************************************
;   Subroutine Name: GetEngineFFTResult
;
;   Description:
;      This time-critical task copies the contents of the current FFT buffer to the
;      output buffer specified for the Fast FFT.  It is similar to GetRxTones() but is
;      especially for use in reading the results of the Fast FFT.
;
;   Prototype:
;      void GetEngineFFTResult(void)
;
;   Input Arguments:
;      None.
;
;   Output Arguments:
;      None.
;
;   Return Value:
;      none
;
;   Global Variables:
;       gs_EngineFFTSize - Specifies size of FFT. Equal to either 128 or 256.
;      gpsa_EngineFFTOutput - Pointer to buffer of size 2*gs_EngineFFTSize words.
;
;   Substates:
;
;**********************************************************************************************/
void GetEngineFFTResult(void)
{
   uint16 RealPart;   /* points to IRI_RAM_RX_FFT_A0 or IRI_RAM_RX_FFT_B0 */
   uint16 ImagPart;   /* points to IRI_RAM_RX_FFT_A1 or IRI_RAM_RX_FFT_B1 */
   int16 HalfSize;

   HalfSize = gs_EngineFFTSize;
   WhichFFTBuffers(&RealPart,&ImagPart);

   ReadCoreBuf32(RealPart, gpsa_EngineFFTOutput, (uint16) HalfSize);

}

#endif //USE_ENGINE_FOR_BG_FFTS

/******************************************************************************/



void ReadFftBuffer(int16 *psa_time_domain_samples, int16 s_offset, int16 s_numSamples)
{
   uint32  ul_FFTInput, ul_FFTOutput;

   // Read the FFT buffer.
   WhichFFTBuffers(&ul_FFTInput, &ul_FFTOutput);
   ReadCoreBuf32((ul_FFTInput+s_offset), psa_time_domain_samples, s_numSamples);
}


/***************************************************************************************
;   Subroutine Name: AccessIfftBuffer
;
;   Description:
;      This function access the IFFT buffer by either read from or write to it.
;      It can access any, A, B or C buffer as specified by the input flag.
;      It can also use the DSP reorder feature as specified by the input flag.
;
;   Prototype:
;      void AccessIfftBuffer(int16 *psa_buf, int16 s_offset, int16 s_NumTones, FlagT gft_InOut, FlagT gft_ReadWrite)
;
;   Input Arguments:
;      psa_buf  -- pointer to the buffer to store the input or output data
;       s_offset -- the first location of the IFFT buffer to access (in unit of 32-word address)
;      s_NumTones -- the number of tones (or a pair of samples) to access
;       gft_DigitRev  -- indicator of IFFT input (1) or output (0) of IFFT output buffer
;      gft_ReadWrite -- indicator of reading or writing operation
;       gft_WhichBuf -- indicate which buffer, QT, FT or FDF to access
;
;
;   Output Arguments:
;
;   Return Value:
;      none
;
;   Global Variables:
;      none
;
;**********************************************************************************************/

void AccessIfftBuffer(int16 *psa_buf, int16 s_offset, int16 s_NumTones,
                      FlagT gft_DigitRev, FlagT gft_ReadWrite, FlagT gft_WhichBuf)
{
   uint32 ul_data_sav;
   uint32 ul_IfftBufAddr;

   ReadCoreReg(IRI_FTB_CTRL_ADDR, &ul_data_sav);

   //Decide which one is the current IFFT buffer
   //Note in the 6.2 HW, the IFFT input and output has the same buffer
   GetIfftBufAddr(&ul_IfftBufAddr, gft_WhichBuf);

   if(gft_DigitRev == IFFT_DSP_REORD_ENA)
   {
      //IFFT input is stored in digit-reversed order
      //set the IFFT_DSP_REORD to 1
      SetCoreReg(IRI_FTB_CTRL_ADDR, (1<<11));
   }
   else //if(gft_DigitRev == IFFT_DSP_REORD_DIS)
   {
      //IFFT output is stored in linear order
      //set the IFFT_DSP_REORD to 0
      ResetCoreReg(IRI_FTB_CTRL_ADDR, (1<<11));
   }

   if(gft_ReadWrite == IFFT_BUF_READ)
   {
      ReadCoreBuf32(ul_IfftBufAddr+s_offset, psa_buf, s_NumTones);
   }
   else //gft_ReadWrite == IFFT_BUF_WRITE)
   {
      WriteCoreBuf32(ul_IfftBufAddr+s_offset, psa_buf, s_NumTones);
   }

   //Restore the original value of register FTB_CTRL
   WriteCoreReg(IRI_FTB_CTRL_ADDR, ul_data_sav);
}

/***************************************************************************************
;   Subroutine Name: GetIfftBufAddr
;
;   Description:
;      This function retrieves one of the IFFT buffer addresses for the following buffer:
;   TX_QT_BUF, TX_FT_BUF and TX_FDF.
;
;   Prototype:
;      void GetIfftBufAddr(uint32 *pul_addr, FlagT gft_WhichBuf)
;
;   Input Arguments:
;      pul_addr  -- pointer to the returned buffer address
;       gft_WhichBuf -- specify one of the IFFT buffers: TX_QT_BUF, TX_FT_BUF or TX_FDF
;
;   Output Arguments:
;
;   Return Value:
;      none
;
;   Global Variables:
;      none
;
;**********************************************************************************************/
void GetIfftBufAddr(uint32 *pul_addr, FlagT gft_WhichBuf)
{
   uint32 ul_TxBufferStat;
   int16 i=0;

   ReadCoreReg(IRI_FTB_TX_STATUS_ADDR, &ul_TxBufferStat);

   switch(gft_WhichBuf)
   {
   case TX_QT_BUF:
      i = 0;
      break;
   case TX_FT_BUF:
      i = 3;
      break;
   case TX_FDF_BUF:
   case TX_FDF_BUF_PRE:
      i = 6;
      break;
   }

   //Get the status bits
   i = (int16)((ul_TxBufferStat>>i) & 3);

   //Get the previous FDF buffer address
   if(gft_WhichBuf == TX_FDF_BUF_PRE)
   {
      i = i - 1;

      if(i<0)
      {
         i=2;
      }
   }

   switch(i)
   {
   case 0:
      *pul_addr = (uint32)IRI_FTB_IFFT_RAM_A_ADDR;
      break;

   case 1:
      *pul_addr = (uint32)IRI_FTB_IFFT_RAM_B_ADDR;
      break;

   case 2:
      *pul_addr = (uint32)IRI_FTB_IFFT_RAM_C_ADDR;
      break;
   }
}

//Function to read the FTB_TX_STATUS register
void ReadIfftBufStatus(uint32 *pul_data)
{
   ReadCoreReg(IRI_FTB_TX_STATUS_ADDR, pul_data);
}


/***************************************************************************************
;   Subroutine Name: AccessFftBuffer
;
;   Description:
;      This function access the IFFT buffer by either read from or write to it.
;      It can access any, A, B or C buffer as specified by the input flag.
;      It can also use the DSP reorder feature as specified by the input flag.
;
;   Prototype:
;      void AccessFftBuffer(int16 *psa_buf, int16 s_offset, int16 s_NumTones, FlagT gft_InOut, FlagT gft_ReadWrite)
;
;   Input Arguments:
;      psa_buf  -- pointer to the buffer to store the input or output data
;       s_offset -- the first location of the IFFT buffer to access (in unit of 32-word address)
;      s_NumTones -- the number of tones (or a pair of samples) to access
;       gft_DigitRev  -- indicator of IFFT input (1) or output (0) of IFFT output buffer
;      gft_ReadWrite -- indicator of reading or writing operation
;      gft_WhichBuf -- indicate which buffer, QT, FT or FDF to access
;
;   Output Arguments:
;
;   Return Value:
;      none
;
;   Global Variables:
;      none
;
;**********************************************************************************************/

void AccessFftBuffer(int16 *psa_buf, int16 s_offset, int16 s_NumTones,
                     FlagT gft_DigitRev, FlagT gft_ReadWrite, FlagT gft_WhichBuf)
{
   uint32 ul_data_sav;
   uint32 ul_FftBufAddr;

   ReadCoreReg(IRI_FTB_CTRL_ADDR, &ul_data_sav);

   //Decide which one is the current FFT buffer
   //Note in the 6.2 HW, the IFFT input and output has the same buffer
   GetFftBufAddr(&ul_FftBufAddr, gft_WhichBuf);

   if(gft_DigitRev == FFT_DSP_REORD_ENA)
   {
      //FFT output is stored in digit-reversed order
      //set the FFT_DSP_REORD to 1
      SetCoreReg(IRI_FTB_CTRL_ADDR, (1<<3));
   }
   else //if(gft_DigitRev == IFFT_DSP_REORD_DIS)
   {
      //FFT input is stored in linear order
      //set the FFT_DSP_REORD to 0
      ResetCoreReg(IRI_FTB_CTRL_ADDR, (1<<3));
   }

   if(gft_ReadWrite == FFT_BUF_READ)
   {
      ReadCoreBuf32(ul_FftBufAddr+s_offset, psa_buf, s_NumTones);
   }
   else //gft_ReadWrite == FFT_BUF_WRITE)
   {
      WriteCoreBuf32(ul_FftBufAddr+s_offset, psa_buf, s_NumTones);
   }

   //Restore the original value of register FTB_CTRL
   WriteCoreReg(IRI_FTB_CTRL_ADDR, ul_data_sav);
}

/***************************************************************************************
;   Subroutine Name: GetFftBufAddr
;
;   Description:
;      This function retrieves one of the FFT buffer addresses for the following buffer:
;   RX_QT_BUF, RX_FT_BUF and RX_FDF_BUF.
;
;   Prototype:
;      void GetIfftBufAddr(uint32 *pul_addr, FlagT gft_WhichBuf)
;
;   Input Arguments:
;      pul_addr  -- pointer to the returned buffer address
;       gft_WhichBuf -- specify one of the IFFT buffers: RX_QT_BUF, RX_FT_BUF or RX_FDF
;
;   Output Arguments:
;
;   Return Value:
;      none
;
;   Global Variables:
;      none
;
;**********************************************************************************************/

void GetFftBufAddr(uint32 *pul_addr, FlagT gft_WhichBuf)
{
   uint32 ul_TxBufferStat;
   int16 i=0;

   ReadCoreReg(IRI_FTB_RX_STATUS_ADDR, &ul_TxBufferStat);

   switch(gft_WhichBuf)
   {
   case RX_QT_BUF:
      i = 0;
      break;
   case RX_FT_BUF:
      i = 3;
      break;
   case RX_FDF_BUF:
   case RX_FDF_BUF_PRE:
      i = 6;
      break;
   }


   //Get the status bits
   i = (int16)((ul_TxBufferStat>>i) & 3);

   //Get the previous FDF buffer address
   if(gft_WhichBuf == RX_FDF_BUF_PRE)
   {
      i = i - 1;

      if(i<0)
      {
         i=2;
      }
   }

   switch(i)
   {
   case 0:
      *pul_addr = (uint32)IRI_FTB_FFT_RAM_A_ADDR;
      break;

   case 1:
      *pul_addr = (uint32)IRI_FTB_FFT_RAM_B_ADDR;
      break;

   case 2:
      *pul_addr = (uint32)IRI_FTB_FFT_RAM_C_ADDR;
      break;
   }
}

//Function to read the FTB_TX_STATUS register
void ReadFftBufStatus(uint32 *pul_data)
{
   ReadCoreReg(IRI_FTB_RX_STATUS_ADDR, pul_data);
}

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : CheckQtStall
 *
 *  Description: Check to see if the QT run is dropped or not (stalled).
 *
 *  Prototype: FlagT CheckQtStall(uint8 uc_TxRxIndicator)
 *
 *  Input Arguments:
 *      uc_TxRxIndicator -- indicator of TX or RX direction
 *
 *  Output Arguments (global variables):
 *
 *  Return:
 *      1: QT is stalled, 0: QT has run
 *
 *  Global Variables Used:
 *      None
 *
 *------------------------------------------------------------------------
 *^^^
 */



FlagT CheckQtStall(uint8 uc_TxRxIndicator)
{
   uint8 uc_qt_curr, *puc_qt_prev;
   FlagT ft_flag;
   uint32 ul_data;
   uint32 ul_addr;

   //Get the QT buffer status
   if(uc_TxRxIndicator == TX)
   {
      ul_addr = IRI_FTB_TX_STATUS_ADDR;
      puc_qt_prev = &guc_ftb_tx_qt;
   }
   else
   {
      ul_addr = IRI_FTB_RX_STATUS_ADDR;
      puc_qt_prev = &guc_ftb_rx_qt;
   }

   ReadCoreReg(ul_addr, &ul_data);
   uc_qt_curr = ul_data & 3;

   //QT stalled
   if(uc_qt_curr == *puc_qt_prev)
   {
      ft_flag = 1;
   }
   else //QT not stalled
   {
      ft_flag = 0;
   }

   *puc_qt_prev = uc_qt_curr;




   return(ft_flag);

}


/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : CheckFTOverFlow
 *
 *  Description: Check and record the FT overflow events
 *
 *  Prototype: void CheckFTOverFlow(void)
 *
 *  Input Arguments:
 *
 *  Output Arguments:
 *
 *  Return:
 *
 *  Global Variables Used:
 *      gul_FT_OverflowData - current value of FT_STATUS register
 *      gusa_FTOverflowCnt[0] -- IFFT overflow count
 *      gusa_FTOverflowCnt[1] -- FFT overflow count
 *------------------------------------------------------------------------
 *^^^
 */

#ifdef ENABLE_VR9_HW_ERR_CNT
void CheckFTOverFlow(void)
{
   // Read Strymon's overflow/event register
   ReadCoreReg((uint32)IRI_FT_REG_STATUS_ADDR, &gul_FT_OverflowData);

   // Write '1' to clear overflow bits
   WriteCoreReg((uint32)IRI_FT_REG_STATUS_ADDR, 0xA);

   //Update the IFFT overflow counter
   if((gul_FT_OverflowData & 8) && (gusa_FTOverflowCnt[0] < 0xFFFF))
   {
      gusa_FTOverflowCnt[0]++;
   }

   //Update the FFT overflow counter
   if((gul_FT_OverflowData & 2) && (gusa_FTOverflowCnt[1] < 0xFFFF))
   {
      gusa_FTOverflowCnt[1]++;
   }

} //void CheckStrymonOverFlow(void)

#endif //ENABLE_VR9_HW_ERR_CNT

