/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2005 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: IRI_IOf_mfdq.c
*
*   This file contains engine interface functions to used MFDQ calculation.
*
*-------------------------------------------------------------------------------
*/

#include "common.h"
#include "gdata.h"
#include "IRI_Iof.h"
#include "LL_IOf.h"
#include "qt_memmap.h"

/*
*-------------------------------------------------------------------------------
*
*   Prototype: void ReadSfdqCoef(void)
*
*   This function reads and saves SFDQ coefficients for MFDQ calculation.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/

void ReadSfdqCoef(void)
{
   //modified 2/5/08
   int16 s_NumTones, s_StartTone;

   s_NumTones = gt_MfdqConfig.s_NumReadTone;
   s_StartTone = gt_MfdqConfig.s_ReadToneStart; // start tone index

   // read SFDQ coefficients
   ReadFdqMant(gt_MfdqConfig.psa_SfdqCoef, s_StartTone, s_NumTones);

   // read SFDQ exponents
   ReadFdqExp(gt_MfdqConfig.puca_SfdqExp, s_StartTone, s_NumTones);
}

/*
*-------------------------------------------------------------------------------
*
*   Prototype: void WriteSfdqCoef(void)
*
*   This function writes SFDQ coefficients modified from MFDQ calculation.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/

void WriteSfdqCoef(void)
{
   //modified 2/5/08
   int16 s_NumTones, s_StartTone;

   s_NumTones = gt_MfdqConfig.s_NumReadTone;
   s_StartTone = gt_MfdqConfig.s_ReadToneStart; // start tone index

   // write SFDQ coefficients
   StoreFdqMant(gt_MfdqConfig.psa_SfdqCoef, s_StartTone, s_NumTones);

   // write SFDQ exponents
   StoreFdqExp(gt_MfdqConfig.puca_SfdqExp, s_StartTone, s_NumTones);
}

/*
*-------------------------------------------------------------------------------
*
*   Prototype: void ReadMfdqCoef(void)
*
*   This function reads MFDQ coefficients from HW for showtime MFDQ adjustment.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/

void ReadMfdqCoef(void)
{
   int16 s_NumTones;

   s_NumTones = gt_MfdqConfig.s_NumMfdqTones; // # of MFDQ tones

   // read coefficients for feedback (FB) tap
   ReadCoreBuf32(IRI_QT_RAM_RX_MFDQ_FB_COEF_MANT_ADDR, gt_MfdqConfig.psa_fb_coef, (uint16)s_NumTones);

   // read exponents for feedback (FB) tap
   ReadCoreBuf8(IRI_QT_RAM_RX_MFDQ_FB_COEF_EXP_ADDR, (int8 *)(void *)gt_MfdqConfig.puca_fb_exp, (uint16)s_NumTones);
}

/*
*-------------------------------------------------------------------------------
*
*   Prototype: void WriteMfdqCoef(void)
*
*   This function writes 3 sets of MFDQ coefficients (SF, FF, FB) to HW.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/

void WriteMfdqCoef(void)
{
   int16 s_NumTones;

   s_NumTones = gt_MfdqConfig.s_NumMfdqTones; // # of MFDQ tones

   // write SFDQ coefficients
   WriteSfdqCoef();

   // write coefficients for feedforward (FF) tap
   WriteCoreBuf32(IRI_QT_RAM_RX_MFDQ_FF_COEF_MANT_ADDR, gt_MfdqConfig.psa_ff_coef, (uint16)s_NumTones);

   // write coefficients for feedback (FB) tap
   WriteCoreBuf32(IRI_QT_RAM_RX_MFDQ_FB_COEF_MANT_ADDR, gt_MfdqConfig.psa_fb_coef, (uint16)s_NumTones);

   // write exponents for feedback (FB) tap
   WriteCoreBuf8(IRI_QT_RAM_RX_MFDQ_FB_COEF_EXP_ADDR, (int8 *)(void *)gt_MfdqConfig.puca_fb_exp, (uint16)s_NumTones);
}

/*
*-------------------------------------------------------------------------------
*
*   Prototype: void EnableMfdq(void)
*
*   This function enables MFDQ by resetting bits in IR_MISC register.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/

void EnableMfdq(void)
{
   uint32 ul_data;

   // enable MFDQ
   ul_data = (uint32)(MASK_BIT16 | MASK_BIT13 | MASK_BIT11);
   ResetCoreReg(IRI_QT_REG_RX_MISC_ADDR, ul_data);
}

/*
*-------------------------------------------------------------------------------
*
*   Prototype: void DisableMfdq(void)
*
*   This function disables MFDQ by setting bits in IR_MISC register.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/

void DisableMfdq(void)
{
   uint32 ul_data;

   // disable MFDQ
   ul_data = (uint32)(MASK_BIT16 | MASK_BIT13 | MASK_BIT11);
   SetCoreReg(IRI_QT_REG_RX_MISC_ADDR, ul_data);
}

/*
*-------------------------------------------------------------------------------
*
*   Prototype: void SetUpHwForMfdqHandler(void)
*
*   This function sets up HW for MfdqHandler.
*   1.   configure RTV0 for SFDQ output, Yi = Ci*Xi
*      (Ci: original SFDQ coefficient, Xi: FFT output)
*   2.   configure RTV1 for final decision output, Di
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/

void SetUpHwForMfdqHandler(void)
{
   uint32 ul_data;

   ul_data = (1 << 28) // disable tone rotation using PRBS
         | (SFDQ_OUTPUT << 25)
         | (RTV_FMT0 << 24) // format option 0
         | (1<<31);                 // Enable RTV capture
   WriteCoreReg(IRI_QT_REG_RX_FD_RNG0_ADDR, ul_data);

   ul_data = (MAX_RTV_TONE_NUM-1);     // # of tones to store - 1, starting at RTV_OFFSET0
   WriteCoreReg(IRI_QT_REG_RX_FD_RNG0_CNT_35B_ADDR, ul_data);

   ul_data = (1 << 28) // disable tone rotation using PRBS
         | (CDEC_OUTPUT << 25)
         | (RTV_FMT0 << 24) // format option 0
         | (1<<31);                 // Enable RTV capture
   WriteCoreReg(IRI_QT_REG_RX_FD_RNG1_ADDR, ul_data);

    ul_data = (MAX_RTV_TONE_NUM-1);     // # of tones to store - 1, starting at RTV_OFFSET0
    WriteCoreReg(IRI_QT_REG_RX_FD_RNG1_CNT_35B_ADDR, ul_data);

   // initialize MFDQ tone table
   WriteCoreBuf32(IRI_QT_RAM_RX_FEEDBACK_TONE_ADDR,(int16 *)(void *) gt_MfdqConfig.pla_ToneTable, (uint16)gt_MfdqConfig.s_NumMfdqTones);

   // make sure MFDQ is disabled
   DisableMfdq();
}

/*
*-------------------------------------------------------------------------------
*
*   Prototype: void GetRxDataForMfdqHandler(void)
*
*   This function reads both RTV buffers for MFDQ calculation.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/

void GetRxDataForMfdqHandler(void)
{
   //modified 2/5/08
   // read SFDQ output from RTV0

//In 6.1 BM, only one buffer for both RTV0, RTV1. Hence,offset for RTV1 locations is set equal to (FD_RANG0.l_RxRTVBuffer0Count)*4 bytes.
   //This value is set to MAX_RTV_TONE_NUM ( 512) , but may have to change in future


   ReadCoreBuf32(IRI_QT_RAM_RX_NOISE_ACCMR_LSW_ADDR, gt_MfdqConfig.psa_FdqOutput, (uint16)gt_MfdqConfig.s_NumReadTone);

   // read final decision output from RTV1 //FIXME  this offset address
   ReadCoreBuf32(IRI_QT_RAM_RX_NOISE_ACCMR_LSW_ADDR+2048, gt_MfdqConfig.psa_DecOutput, (uint16)gt_MfdqConfig.s_NumReadTone);

}
