/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2007 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: IRI_IOf_train.c
*
*   This file contains engine interface functions to used during training.
*
*-------------------------------------------------------------------------------
*/

#include "common.h"
#include "gdata.h"
#include "LL_IOf.h"
#include "ft_memmap.h"
#include "qt_memmap.h"
#include "qtp_memmap.h"
#include "IRI_Iof.h"
#include "str_memmap.h"


#ifdef INCLUDE_CACHE_FUNCTIONS
/*
*-------------------------------------------------------------------------------
*
*   Prototype: void ModifyMedleyPrbsSkipBits(FlagT ft_tx_or_rx, uint16 us_BitsToSkip)
*
*   This function modifies TX PRBS parameters.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/

void ModifyMedleyPrbsSkipBits(FlagT ft_tx_or_rx, uint16 us_BitsToSkip)
{
   uint32 ul_addr,ul_RegData;

   if (ft_tx_or_rx == TX)
   {
      //QT register
      ul_addr = IRI_QT_REG_TX_PRBS_MISC_ADDR;
      ReadCoreReg(ul_addr, &ul_RegData);

      // Non-standard compliant: skip n bits instead of 4 bits
      // at end of each symbol.
      ul_RegData &= (uint32)~(0x0000F000);
      ul_RegData |= ((uint32)us_BitsToSkip << 12);

      WriteCoreReg(ul_addr, ul_RegData);

      // QTP PRBS
      ul_addr = IRI_QTP_REG_TX_PRBS_MISC_ADDR;
      ReadCoreReg(ul_addr, &ul_RegData);

      // Non-standard compliant: skip n bits instead of 4 bits
      // at end of each symbol.
      ul_RegData &= (uint32)~(0x0000F000);
      ul_RegData |= ((uint32)us_BitsToSkip << 12);
      WriteCoreReg(ul_addr, ul_RegData);

   }
   else //RX
   {
      ul_addr = IRI_QTP_REG_RX_PRBS_MISC_ADDR;

      ReadCoreReg(ul_addr, &ul_RegData);

      // Non-standard compliant: skip n bits instead of 4 bits
      // at end of each symbol.
      ul_RegData &= (uint32)~(0x00007800);
      ul_RegData |= ((uint32)us_BitsToSkip << 11);

      WriteCoreReg(ul_addr, ul_RegData);
   } //if (ft_tx_or_rx == TX)
}

#endif // INCLUDE_CACHE_FUNCTIONS






#ifdef INCLUDE_NON_CACHE_FUNCTIONS

/*
*-------------------------------------------------------------------------------
*
*   Prototype: void InsertTxCE(void)
*
*   This function inserts TX Cyclic Extension.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*      gs_TxBetaLength -- (I) the TX window length
*      gs_TxCPLength -- (I) the TX CP length
*      gs_TxCSLength -- (I) the TX CS length
*      gsa_WindowCoeffs -- (I) the TX window coefficients buffer
*-------------------------------------------------------------------------------
*/
//Note: this function should belong to the strymon HW IOf file,
//but we keep it here so we do not need to change the ARC build file
void InsertTxCE(void)
{
   uint32 ul_tmpWord;

   if(gs_DbgTxBetaLength >= 0)
   {
      gs_TxBetaLength = gs_DbgTxBetaLength;
   }
   if(gs_DbgTxCPLength >= 0)
   {
      gs_TxCPLength = gs_DbgTxCPLength;
   }
   if(gs_DbgTxCSLength >= 0)
   {
      gs_TxCSLength = gs_DbgTxCSLength;
   }

   // Set Beta length
   WriteCoreReg((uint32)V_TX_BETA_ADDR, (uint32)gs_TxBetaLength);

   // Set Tx extension register
   ul_tmpWord = (gs_TxCPLength<<CP_SIZE_LSB);   // Tx CP length
   ul_tmpWord |= (gs_TxCSLength<<CS_SIZE_LSB);  // Tx CS length

   if(gs_TxCPLength > 0)
   {
      ul_tmpWord |= CP_EN;   // Tx CP strobe enable
   }

   if(gs_TxCSLength > 0)
   {
      ul_tmpWord |= CS_EN;   // Tx CS strobe enable
   }

   //Set the flag, the TX windowing is actually enabled in the next symbol
   if(gs_TxBetaLength > 0)
   {
      gft_StartTxWin = TRUE;
   }
   else
   {
      gft_StartTxWin = FALSE;
   }

   ul_tmpWord |= TX_WIN_COEFF_MODE_VDSL;   // the TX window coefficient are stored in the VDSL pattern

   WriteCoreReg((uint32)V_TX_EXTEN_ADDR, ul_tmpWord);

   //Popolate the shadow fifo registers
   if(gft_UpdateVRegShadowFifo == TRUE)
   {
      //Write to the active register
      WriteCoreReg((uint32)V_TX_EXTEN_A_ADDR, ul_tmpWord);
      WriteCoreReg((uint32)V_TX_BETA_A_ADDR, (uint32)gs_TxBetaLength);
   }

} //void InsertTxCE(void)


/*
*-------------------------------------------------------------------------------
*
*   Prototype: void InsertRxCE(void)
*
*   This function inserts RX Cyclic Extension.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*      gs_RxCPLength -- (I) RX CP length
*      gs_RxCSLength -- (I) RX CS length
*      gs_RxBetaLength -- (I) RX beta length
*-------------------------------------------------------------------------------
*/

//Note: this function should belong to the strymon HW IOf file,
//but we keep it here so we do not need to change the ARC build file
void InsertRxCE(void)
{
   uint32 ul_tmpWord;

   gft_SkipSymbol = 0;

   //Set the RX window size
   WriteCoreReg((uint32)V_RX_WSIZE_ADDR, gs_RxWindowLength);

   if(gs_DbgRxBetaLength >= 0)
   {
      gs_RxBetaLength = gs_DbgRxBetaLength;
   }
   if(gs_DbgRxCPLength >= 0)
   {
      gs_RxCPLength = gs_DbgRxCPLength;
   }
   if(gs_DbgRxCSLength >= 0)
   {
      gs_RxCSLength = gs_DbgRxCSLength;
   }

   // Set Rx extension register
   // Note: DMT Symbol size = 2N + L_CE = 2N + L_CP + L_CS - beta.
   //  L_CE = L_CP + (L_CS -beta)
   //       -> L_CE from O-Signature
   //       -> L_CP from O-Signature
   //       -> beta from O-Signatute
   ul_tmpWord = (gs_RxCPLength << CP_SIZE_LSB);                        // Rx CP length
   ul_tmpWord |= ((gs_RxCSLength - gs_RxBetaLength) << CS_SIZE_LSB);   // Rx CS length - set equal to RX CS length - Rx beta

   if(gs_RxCPLength > 0)
   {
      ul_tmpWord |= CP_EN;   // Rx CP strobe enable
   }

   if(gs_RxCSLength > gs_RxBetaLength)
   {
      ul_tmpWord |= CS_EN;   // Rx CS strobe enable
   }

   if(gs_RxWindowLength > 0)
   {
      ul_tmpWord |= WIN_EN;   // Rx Window strobe enable
   }

   WriteCoreReg((uint32)V_RX_EXTEN_ADDR, ul_tmpWord);

   //Popolate the shadow fifo registers
   if(gft_UpdateVRegShadowFifo == TRUE)
   {
      //Write to the active register
      WriteCoreReg((uint32)V_RX_EXTEN_A_ADDR, ul_tmpWord);
      WriteCoreReg((uint32)V_RX_WSIZE_A_ADDR, (uint32)gs_RxWindowLength);
   }

} //void InsertRxCE(void)


/*
*-------------------------------------------------------------------------------
*
*   Prototype: void ConfigRxNumTone(void)
*
*   This function reconfigures the number of RX tones used by the QT core.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/

void ConfigRxNumTone(void)
{
   uint32 ul_N;
   int16 s_RxNumTones;

   // Since gs_FeModemLog2IfftSize = log2(2*N), where N is the number of tones
   // convert it to the format used by HW(000 = 32 tones, 001=64 tones ..)
   ul_N = (gs_FeModemLog2IfftSize - 6) & 0xF;
   // IR_NSC
   // This register controls the QT processing range, but does not affect PRBS state.
   WriteCoreReg(IRI_QT_REG_RX_NSC_ADDR, ul_N);


   //QTP_RX_CTRL
   //PRBS Enable in QTP and set the number of RX tones
   //(This is necessary for PRBS works correctly in Medley state)
   s_RxNumTones = 1<<(gs_FeModemLog2IfftSize-1);


   ul_N = ((s_RxNumTones-1) << 2) | (1<<1);
   WriteCoreReg(IRI_QTP_REG_RX_CTRL_ADDR, ul_N);
}

/*
*-------------------------------------------------------------------------------
*
*   Prototype: SwitchToTxMedleyPRBS(void)
*              SwitchToRxMedleyPRBS(void)
*
*   These functions switches the TX and RX PRBS state generators from Reverb
*   mode (resets seed every frame) to Medley mode (DON't reset seed every frame)
*   respectively.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/

void SwitchToTxMedleyPRBS(void)
{
   if (gft_dbg_DisableMedleyPRBS == 0)
   {
      ResetCoreReg(IRI_QT_REG_TX_PRBS_MISC_ADDR, (0x1 << 11)); // Do NOT reset TX PRBS generator each frame.
      ResetCoreReg(IRI_QTP_REG_TX_PRBS_MISC_ADDR, (0x1 << 11)); // Do NOT reset TX PRBS generator each frame.
   }
}

void SwitchToRxMedleyPRBS(void)
{
   //modified 2/5/08
   if (gft_dbg_DisableMedleyPRBS == 0)
   {
      ResetCoreReg(IRI_QTP_REG_RX_PRBS_MISC_ADDR, (0x1 << 10));   // Do NOT reset RX PRBS generator each frame.
   }
}


#endif // INCLUDE_NON_CACHE_FUNCTIONS




/*
*-------------------------------------------------------------------------------
*
*   Prototype: void LoadBlackoutNssiBits(void)
*
*   This function copys the blackout bits and nssi bits in the inactive EGT
*   to the active EGT in HW.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/

