/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 1998-2005 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *----------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Condfidential
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276-4000
 *   FAX   (781) 276-4001
 *
 *   IRI_Ini.C
 *
 *   Iridia initialization functions
 *
 *
 *----------------------------------------------------------------------------
 */
#include "common.h"
#include "gdata.h"
#include "ft_memmap.h"
#include "ftb_memmap.h"
#include "qt_memmap.h"
#include "qtp_memmap.h"
#include "qtp_cocomo_interface.h"
#include "LL_Iof.h"
#include "IRI_Iof.h"
#include "cmv.h"
#include "mul.h"
#include "dsp_op.h"


/***************************************************************************************
;   Subroutine Name: InitIridiaFT()
;
;   Description:
;      This function initializes the registers and memory blocks in FT and FTB core
;   (Note: the function name is inheritated from the privious HW design)
;
;
;   Prototype:
;      void InitIridiaFT()
;
;   Input Arguments:
;
;   Output Arguments:
;      none
;
;   Return Value:
;      none
;
;**********************************************************************************************/

// The possible settings for the scale-backs are
// - 00b    (scaleback is 1; no scale-back is applied),
// - 01b    (scale-back is 1/2), and
// - 10/11b (scale-back is 1/4).
#define SCALE_BACK_ONE        0x00
#define SCALE_BACK_ONE_HALF   0x01
#define SCALE_BACK_ONE_FORTH  0x02
#define SCALE_BACK_BITS       (SCALE_BACK_ONE_FORTH|SCALE_BACK_ONE_HALF)


// Tones    |  Transform type   |    m    | Radix
//----------------------------------------------------------
//  8192    |    2*4^m          |    6    | Radix-4/Radix-2 (This process may be viewed as computing a 4^(m+1)-point transform)
//  4096    |     4^m           |    6    | Radix-4
//  2048    |    2*4^m          |    5    | Radix-4/Radix-2 (This process may be viewed as computing a 4^(m+1)-point transform)
//  1024    |     4^m           |    5    | Radix-4
//   512    |    2*4^m          |    4    | Radix-4/Radix-2 (This process may be viewed as computing a 4^(m+1)-point transform)
//   256    |     4^m           |    4    | Radix-4
//   128    |    2*4^m          |    3    | Radix-4/Radix-2 (This process may be viewed as computing a 4^(m+1)-point transform)
//    64    |     4^m           |    3    | Radix-4


// <15:14> set 0x01 in IFFT_SB_7 @Enable IFFT_8K, 6th Bit @IRI_FT_REG_TX_SCALE_35B_ADDR
uint16 gus_ScaleBackRx35B = 0x5554;

void InitIridiaFT()
{
   uint32 ul_tmpWord;
   uint32 ScaleBack = 0x1555;
   //-------------------------------------------------------
   //Configure FT registers
   //-------------------------------------------------------

   // Configure IFFT size and enable IFFT
   ul_tmpWord = (gs_TxLog2IfftLength-7)<<3 //IFFT size
                | (MASK_BIT0|MASK_BIT1);             //enable IFFT

   // If US 8K tones, then enable 8K IFFT flag
   //OPEN_VRX518 How to configure US 4K tones
   if ((gt_ProfileAct.us_ProfileSelected & CNFG_V2_PROFILE_35B_MASK) &&
       (gs_TxLog2IfftLength > US_LOG2_FFT_LENGTH_8192))
   {
        ul_tmpWord |= 0x40; //Enable IFFT_8K, 6th Bit @IRI_FT_REG_TX_CTRL_35B_ADDR
   }

   WriteCoreReg(IRI_FT_REG_TX_CTRL_ADDR, ul_tmpWord);
   WriteCoreReg(IRI_FT_REG_TX_CTRL_A_ADDR, ul_tmpWord);

   ul_tmpWord = ScaleBack;
    // If US 8K tones
   if ((gt_ProfileAct.us_ProfileSelected & CNFG_V2_PROFILE_35B_MASK) &&
       (gs_TxLog2IfftLength > US_LOG2_FFT_LENGTH_8192))
   {
      ul_tmpWord |= 0x4000; //<15:14> set 0x01 in IFFT_SB_7 @Enable IFFT_8K, 6th Bit @IRI_FT_REG_TX_SCALE_35B_ADDR
   }

   // Set IFFT scaleback
    // change scaleback functions here
   WriteCoreReg(IRI_FT_REG_TX_SCALE_ADDR, ul_tmpWord);

   // Configure FFT size and enable FFT
   ul_tmpWord = (gs_RxLog2FftLength-7)<<2   //FFT size
                | (MASK_BIT0|MASK_BIT1);      //enable FFT

   if (gt_ProfileAct.us_ProfileSelected & CNFG_V2_PROFILE_35B_MASK)
   {
      ul_tmpWord |=  (0x20); //Enable FFT_8K, 5th Bit @IRI_FT_REG_RX_CTRL_A_35B_ADDR
   }

   //FFT size
   //Note: Hw spec doesn't show the fft size in FT_REG_RX_CTRL only in the active register.
   //      Both registers must identically be written!
   WriteCoreReg(IRI_FT_REG_RX_CTRL_ADDR, ul_tmpWord);
   WriteCoreReg(IRI_FT_REG_RX_CTRL_A_ADDR, ul_tmpWord);

   // Set FFT scalebacks (RX SCALEBACK)
   {
      // For 4096 tone FFT - 1/2 for butterflies 1-6, none on post proc.
      ScaleBack = 0x1554;
      if (gt_ProfileAct.us_ProfileSelected & CNFG_V2_PROFILE_35B_MASK)
      {
         // For 8192 tone FFT - 1/2 for butterflies 1-7, none on post proc.
         ScaleBack = gus_ScaleBackRx35B;
      }

      // Calculate the number of FFT right shifts.
      {
         // Note:
         signed int i;
         uint32 ul_ScaleBackValue;

         gs_RxFftRsh = 0;
         ul_ScaleBackValue = ScaleBack;

         for(i=0; i<8; i++)
         {
            if(ul_ScaleBackValue & SCALE_BACK_BITS)
            {
               gs_RxFftRsh += 1;       // Increment number of right shifts
               if(ul_ScaleBackValue & SCALE_BACK_ONE_FORTH)
               {
                  gs_RxFftRsh += 1;    // Increment number of right shifts
               }
            }

            ul_ScaleBackValue = (ul_ScaleBackValue >> 2);
         }
      }

      WriteCoreReg(IRI_FT_REG_RX_SCALE_ADDR, ScaleBack);
   }

   //-------------------------------------------------------
   //Configure FTB registers and buffers
   //-------------------------------------------------------
   {
      uint8 uc_fft_Size;

      //FTB_CTRL
      //set FFT size, TX_FDF_ENA, RX_FDF_ENA and TX_FDF_READ_CLEAR
      ul_tmpWord=((gs_RxLog2FftLength - 7)<<4)|(1<<8)|(1<<0)|(1<<15);

        if (gt_ProfileAct.us_ProfileSelected & CNFG_V2_PROFILE_35B_MASK)
        {
           ul_tmpWord |=  0x2000; //Enable FFT_8K, 13th Bit @IRI_FTB_CTRL_35B_ADDR
        }

      WriteCoreReg(IRI_FTB_CTRL_ADDR, ul_tmpWord);

      //FTB_IFFT_TSIZE
      //set IFFT size

      uc_fft_Size = (gs_TxLog2IfftLength - 7);
      ul_tmpWord = (uc_fft_Size) | (uc_fft_Size << 4) | (uc_fft_Size << 8) | (uc_fft_Size << 12);

        //If US 8K tones, then enable 8K IFFT flags
        if ((gt_ProfileAct.us_ProfileSelected & CNFG_V2_PROFILE_35B_MASK) &&
            (gs_TxLog2IfftLength > US_LOG2_FFT_LENGTH_8192))
        {
           //Enable IFFT_8K_SHADOW(3rd), IFFT_8K_A(7th), IFFT_8K_B(11th), IFFT_8K_C(15th), @IRI_FTB_IFFT_TSIZE_35B_ADDR
           ul_tmpWord |=  0x8888;
        }
      WriteCoreReg(IRI_FTB_IFFT_TSIZE_ADDR, ul_tmpWord);
   }

   //XDSLRTFW-3148 (Start)
   if ((gt_ProfileAct.us_ProfileSelected & CNFG_V2_PROFILE_35B_MASK) &&
       (gul_35bLiteConfig & EN_HRT_5_0_SCHEDULING_FOR_CASCADED_MODE))
   {
      //Initialize TX Status register (to default value 010000001b: QT 1, FT 1, FDF 2)
      //(Note set it to 0 does not work for COCOMO)
      WriteCoreReg(IRI_FTB_TX_STATUS_ADDR, (0x0089 | 0x124));
   }
   else
   {
      //Initialize TX Status register (to default value 010000001b: QT 1, FT 0, FDF 2)
      //(Note set it to 0 does not work for COCOMO)
      WriteCoreReg(IRI_FTB_TX_STATUS_ADDR, (0x0081 | 0x124));
   }
   //XDSLRTFW-3148 (End)

   if (gt_ProfileAct.us_ProfileSelected & CNFG_V2_PROFILE_35B_MASK)
   {
        //XDSLRTFW-2168 (Start)
        if (gul_35bLiteConfig & EN_HRT_5_0_SCHEDULING_FOR_CASCADED_MODE)
        {
           //Initialize RX Status register (to default value 010000000b, QT 0, FT 0, FDF 2)
           ul_tmpWord = (0x0080 | 0x124);
        }
        else
        {
           //Changed to test 35B mode, This is required to run FFT and QT simultaneouly in two diff buffers
           //Which results in one symbol addtional round trip delay in the system.
           //FFT/IFFT engine is estimated to consume 65K cycles with 8K FFT/IFFT
           //Initialize RX Status register (to default value 010000001b, QT 1, FT 0, FDF 2)
           ul_tmpWord = (0x0081 | 0x124);
        }
        //XDSLRTFW-2168 (End)
   }
   else
   {
       //Initialize RX Status register (to default value 010000000b, QT 0, FT 0, FDF 2)
       ul_tmpWord = (0x0080 | 0x124);
   }

   WriteCoreReg(IRI_FTB_RX_STATUS_ADDR, ul_tmpWord);

   ReadCoreReg(IRI_FTB_TX_STATUS_ADDR, &ul_tmpWord);
   guc_ftb_tx_qt = ul_tmpWord & 3;

   ReadCoreReg(IRI_FTB_RX_STATUS_ADDR, &ul_tmpWord);
   guc_ftb_rx_qt = ul_tmpWord & 3;
   // clean IFFT buffers
   ul_tmpWord = (IRI_FTB_IFFT_RAM_A_SIZE>>guc_PortMode);
   FillCoreBuf32(IRI_FTB_IFFT_RAM_A_ADDR, 0, (uint16)ul_tmpWord);
   FillCoreBuf32(IRI_FTB_IFFT_RAM_B_ADDR, 0, (uint16)ul_tmpWord);
   FillCoreBuf32(IRI_FTB_IFFT_RAM_C_ADDR, 0, (uint16)ul_tmpWord);

   // Clear FT status register (write 1 to clear)
   WriteCoreReg(IRI_FT_REG_STATUS_ADDR, 0xF);
}

/***************************************************************************************
;   Subroutine Name: InitIridiaQT()
;
;   Description:
;      This function initializes the Iridia QT core.
;
;
;   Prototype:
;      void InitIridiaQT()
;
;   Input Arguments:
;
;   Output Arguments:
;      none
;
;   Return Value:
;      none
;
;**********************************************************************************************/

void InitIridiaQT()
{
   //modified 2/5/08
   uint8 uc_port_num;
   uint32 ul_RegData;
   uint8 uc_TxNsc, uc_TxNumIfftTones;

   //====== Program QT Global registers =============================

   //IT_ENABLE
   WriteCoreReg(IRI_QT_REG_RX_ENABLE_ADDR, 0x01);

   //IR_ENABLE
   WriteCoreReg(IRI_QT_REG_TX_ENABLE_ADDR, 0x01);

   //IR_NSC
   ul_RegData = gs_RxLog2FftLength - 6 ;
   WriteCoreReg(IRI_QT_REG_RX_NSC_ADDR, ul_RegData);
   //IR_PRBS0
   WriteCoreReg(IRI_QT_REG_RX_PRBS0_ADDR, 0);

   //IR_PRBS1
   WriteCoreReg(IRI_QT_REG_RX_PRBS1_ADDR, 0);

   //I_ABGT_OFFSET
   //Set TX active table offset to 0, and RX will be changed later
   WriteCoreReg(IRI_QT_REG_ABGT_OFFSET_ADDR, 0);

   gs_TxAbgtOffset = 0;
   gs_RxAbgtOffset = 0;
   gl_Active_BGTN_Size = IRI_QT_RAM_ACTIVE_BGTN_SIZE >> guc_PortMode;
   gs_Active_TxEGT_Size = IRI_QT_RAM_TX_ACTIVE_EGT_SIZE >> guc_PortMode;

   //====== Program QT TX registers =============================

   //Reset all registers first
#define IRI_QT_REG_TX_SIZE      ((IRI_QT_REG_TX_DCI_CTRL_ADDR-IRI_QT_REG_TX_CNFG_ADDR+4)/4)

   FillCoreBuf32(IRI_QT_REG_TX_CNFG_ADDR, 0, IRI_QT_REG_TX_SIZE);

   //IT_CONFIG
   uc_TxNsc = gs_TxLog2IfftLength - 6;
   uc_TxNumIfftTones = uc_TxNsc;

   ul_RegData = (uint32)uc_TxNsc;
   ul_RegData |= (uint32)uc_TxNumIfftTones<<4;
   WriteCoreReg(IRI_QT_REG_TX_CNFG_ADDR,  ul_RegData);

   //IT_TCM_CTRL is configured later
   {


      //IR_PRBS_CTRL
      WriteCoreReg(IRI_QT_REG_RX_PRBS_CTRL_ADDR, (uint32)0x3); //Latch RTV0 and RTV1
      //IT_MISC
      ul_RegData  = ( 0 <<  4)  // DON'T use REF_GAIN value in PRBS_GEN mode.
                    | ( 1 <<  5)  // Enable PRBS_GEN mode.
                    | ( 0 <<  6)  // Bit 6 should always be set to 0 in VDSL.
                    | ( 0 <<  11) //type of over sampling: zero-fill upper tones
                    | ( 4 <<  13); // LP order should always be set to 4 in VDSL2 (LP2, LP0, LP1)

      WriteCoreReg(IRI_QT_REG_TX_MISC_ADDR, ul_RegData);
      //The following registers are configured later
      //IT_ACT_ADDR
      //IT_LP0_BITS
      //IT_LP1_BITS
      //IT_LP2_BITS
      //IT_LP0_DUMMY
      //IT_LP0_BIT_FIFO
      //IT_LP1_BIT_FIFO
      //IT_LP2_BIT_FIFO
      //IT_PILOT

      //IT_PTINDEX
      //disable TX pilot tone
      //WriteCoreReg(IRI_QT_REG_TX_PTINDEX_ADDR, 0);

      //IT_PRBS
      WriteCoreReg(IRI_QT_REG_TX_PRBS_ADDR, (uint32)0x7FF); // initial PRBS LFSR state.

      //IT_PRBS_MISC
      ul_RegData  = (10 << 4)   // d[n] = d[n-9] xor d[n-11] -> LFSR length = 11-1 = 10
                    | ( 0 << 9)   // do not rotate pilot tone
                    | ( 0 << 10)  // do not invert output of PRBS
                    | ( 1 << 11)  // Resets PRBS generator each frame.
                    | ( 4 << 12)  // Skip 4 bits at end of each symbol.
                    | ( 1 << 16)  // Pick PRBS output from head of LFSR
                    | ( 9 << 17)  // 1 less than the modulo number (=10) of tones for each tone set.
                    | ( 0 << 24)  // PRBS scrambling when 2 bit PRBS output is "00"
                    | ( 2 << 26)  // PRBS scrambling when 2 bit PRBS output is "01"
                    | ( 1 << 28)  // PRBS scrambling when 2 bit PRBS output is "10"
                    | ( 3 << 30); // PRBS scrambling when 2 bit PRBS output is "11"

      WriteCoreReg(IRI_QT_REG_TX_PRBS_MISC_ADDR, ul_RegData);

      //QTP_TX_PRBS_MISC
      WriteCoreReg(IRI_QTP_REG_TX_PRBS_MISC_ADDR, ul_RegData);

      //IT_PRBS_POLY
      WriteCoreReg(IRI_QT_REG_TX_PRBS_POLY_ADDR, (uint32)0x0100); // d[n] = d[n-9] xor d[n-11]

      //not need to use the following registers
      //IT_PRBS_DATAx, x=0, 1, ...7

      //IT_REF_GAIN (not used)
      //set to unity
      WriteCoreReg(IRI_QT_REG_TX_REF_GAIN_ADDR, 0x2000);
      //QT / QTP register
      //IT_TXCG_x, x=0, 1, ... 15
      // Program Tx Constellation Gain Constants
      WriteCoreReg( IRI_QT_REG_TX_CG0_ADDR, (   0 << 16 ) |  0x304d  );
      WriteCoreReg( IRI_QT_REG_TX_CG1_ADDR, (   0 << 16 ) |  0x304d  );
      WriteCoreReg( IRI_QT_REG_TX_CG2_ADDR, (   0 << 16 ) |  0x304d  );
   }

   //IT_NYQ_TONE_DATA
   // Set Nyquist tone value to zero // A BM6.1 difference.
   //WriteCoreReg(IRI_QT_REG_TX_NYQ_TONE_DATA_ADDR,  0);

   WriteCoreReg( IRI_QT_REG_TX_CG3_ADDR, (   1 << 16 ) |  0x37C6  );
   WriteCoreReg( IRI_QT_REG_TX_CG4_ADDR, (   1 << 16 ) |  0x2B34  );
   WriteCoreReg( IRI_QT_REG_TX_CG5_ADDR, (   2 << 16 ) |  0x3D19  );
   WriteCoreReg( IRI_QT_REG_TX_CG6_ADDR, (   2 << 16 ) |  0x2A29  );
   WriteCoreReg( IRI_QT_REG_TX_CG7_ADDR, (   3 << 16 ) |  0x3C59  );
   WriteCoreReg( IRI_QT_REG_TX_CG8_ADDR, (   3 << 16 ) |  0x29E9  );
   WriteCoreReg( IRI_QT_REG_TX_CG9_ADDR, (   4 << 16 ) |  0x3C2A  );
   WriteCoreReg( IRI_QT_REG_TX_CG10_ADDR, (4 << 16 ) |  0x29DA  );
   WriteCoreReg( IRI_QT_REG_TX_CG11_ADDR, (5 << 16 ) |  0x3C1E  );
   WriteCoreReg( IRI_QT_REG_TX_CG12_ADDR, (5 << 16 ) |  0x29D6  );
   WriteCoreReg( IRI_QT_REG_TX_CG13_ADDR, (6 << 16 ) |  0x3C1B  );
   WriteCoreReg( IRI_QT_REG_TX_CG14_ADDR, (6 << 16 ) |  0x29D5  );
   WriteCoreReg( IRI_QT_REG_TX_CG15_ADDR, (7 << 16 ) |  0x3C1B  );

   //IT_IFFTZ_RNGx, x=0,1,...,5
   //WriteCoreReg( IRI_QT_REG_TX_IFFTZ_RNG0_ADDR, 0 );
   //WriteCoreReg( IRI_QT_REG_TX_IFFTZ_RNG1_ADDR, 0 );
   //WriteCoreReg( IRI_QT_REG_TX_IFFTZ_RNG2_ADDR, 0 );
   //WriteCoreReg( IRI_QT_REG_TX_IFFTZ_RNG3_ADDR, 0 );
   //WriteCoreReg( IRI_QT_REG_TX_IFFTZ_RNG4_ADDR, 0 );
   //WriteCoreReg( IRI_QT_REG_TX_IFFTZ_RNG5_ADDR, 0 );

   //IT_TONE0_DATA
   //WriteCoreReg(IRI_QT_REG_TX_TONEZERO_ADDR, 0);

   //IT_DCI_CTRL
   WriteCoreReg(IRI_QT_REG_TX_DCI_CTRL_ADDR, 0); //Disable Direct Copy to IFFT buffer.


   //=========== Program QT RX registers ====================

   //Reset all registers first
    #define IRI_QT_REG_RX_SIZE      ((IRI_QT_REG_RX_FD_RNG1_CNT_35B_ADDR-IRI_QT_REG_RX_CNFG_ADDR+4)/4)

   FillCoreBuf32(IRI_QT_REG_RX_CNFG_ADDR, 0, IRI_QT_REG_RX_SIZE);

   //IR_CONFIG
   //WriteCoreReg(IRI_QT_REG_RX_CNFG_ADDR, 0);

   //IR_TCM_CTRL
   //disable TCM
   //WriteCoreReg(IRI_QT_REG_RX_TCM_CTRL_ADDR, 0);

   //IR_MISC
   ul_RegData =  (0 << 30)      // disable dual FFT
                 | (0 << 28)      // size of error of 16 bits
                 | (0 << 26)      // accumulate every tone
                 | (0 << 24)      // no shift of noise/vector power accumulation
                 | (0 << 23)      // disable accumulation of Re and Im
                 | (0 << 22)      // disable accumulation of power
                 | (0 << 21)      // disable accumulation of vector power
                 | (4 << 17)      // RX_LP_ORDER, always set to 4 in VDSL (LP2, LP0, LP1)
                 | (1 << 16)      // disable MFDQ
                 | (1 << 15)      // disable use of bit-stuffer
                 | (0 << 14)      // do not bypass SFDQ
                 | (1 << 13)      // disable feed forward part of SFDQ
                 | (0 << 12)      // enable gain scale calculation
                 | (1 << 11)      // disable MFDQ feedback calculation
                 | (1 << 6)      // disable TOT
                 | (0 << 5);      // RX_INIT, always set to 0 for VDSL

   WriteCoreReg(IRI_QT_REG_RX_MISC_ADDR, ul_RegData);

   //The following registers are set later
   //IR_ACT_ADDR
   //IR_LPx_BITS, x =  0, 1, 2
   //IR_DUMMY
   //IR_LPx_BIT_FIFO, x = 0, 1, 2
   {

      // IR_DEROT_MISC
      ul_RegData  = (10 <<  0);   // d[n] = d[n-9] xor d[n-11] -> LFSR length = 11-1 = 10
      ul_RegData |= ( 1 << 6);   // Pick PRBS output from head of LFSR
      ul_RegData |= ( 0 << 7);   // PRBS descrambling when 2 bit PRBS output is "00"
      ul_RegData |= ( 2 << 9);   // PRBS descrambling when 2 bit PRBS output is "01"
      ul_RegData |= ( 1 << 11);   // PRBS descrambling when 2 bit PRBS output is "10"
      ul_RegData |= ( 3 << 13);   // PRBS descrambling when 2 bit PRBS output is "11"
      WriteCoreReg(IRI_QT_REG_RX_DPRBS_MISC_ADDR, ul_RegData);

      // IR_DEROT_POLY
      WriteCoreReg(IRI_QT_REG_RX_DPRBS_POLY_ADDR, (uint32)0x0100); // d[n] = d[n-9] xor d[n-11]

      //IR_FD_RNG1_BASE
      WriteCoreReg(IRI_QT_REG_RX_FD_RNG1_BASE_ADDR, gs_NumChannelsPerGroup);
   }

   /*
      //IR_FD_RNG0
      //disable RTV capture
      WriteCoreReg(IRI_QT_REG_RX_FD_RNG0_ADDR, 0);

      //IR_FD_RNG1
      //disable RTV capture
      WriteCoreReg(IRI_QT_REG_RX_FD_RNG1_ADDR, 0);
   */

   /*
      //IR_NPR_IIBRAM
      //(not write to IIBRAM)
      WriteCoreReg(IRI_QT_REG_RX_NPR_IIBRAM_ADDR, 0);

      //IR_QUAD0
      WriteCoreReg(IRI_QT_REG_RX_QUAD0_ADDR, 0);

      //IR_QUAD1
      WriteCoreReg(IRI_QT_REG_RX_QUAD1_ADDR, 0);

      //IR_SLOWDOWN
      WriteCoreReg(IRI_QT_REG_RX_SLOWDOWN_ADDR, 0);

      //IP_PTINDEX
      //disable pilot tone
      WriteCoreReg(IRI_QT_REG_RX_PTINDEX_ADDR, 0);

      //IR_PILOT
      WriteCoreReg(IRI_QT_REG_RX_PILOT_ADDR, 0);

      //IR_FDQADAPT
      //Disable FDQ adaptation
      WriteCoreReg(IRI_QT_REG_RX_FDQADAPT_ADDR, 0);

      //IR_VECTOR_L
      WriteCoreReg(IRI_QT_REG_RX_VECPOW_L_ADDR, 0);

      //IR_VECTOR_H
      WriteCoreReg(IRI_QT_REG_RX_VECPOW_H_ADDR, 0);

      //IR_REMETRIC_CTL
      WriteCoreReg(IRI_QT_REG_RX_RMETRIC_CTL_ADDR, 0);

      //IR_REMETRIC_VAL
      WriteCoreReg(IRI_QT_REG_RX_RMETRIC_VAL_ADDR, 0);
   */
   //IR_RXCG_x, x=0, 1, ..., 15
   // Rx Constellation Gain Table.
   WriteCoreReg( IRI_QT_REG_RX_CG0_ADDR , (0 << 16 ) |  0x2000 );
   WriteCoreReg( IRI_QT_REG_RX_CG1_ADDR , (0 << 16 ) |  0x2000 );
   WriteCoreReg( IRI_QT_REG_RX_CG2_ADDR , (0 << 16 ) |  0x2000 );
   WriteCoreReg( IRI_QT_REG_RX_CG3_ADDR , (0 << 16 ) |  0x376D );
   WriteCoreReg( IRI_QT_REG_RX_CG4_ADDR , (1 << 16 ) |  0x23C7 );
   WriteCoreReg( IRI_QT_REG_RX_CG5_ADDR , (1 << 16 ) |  0x3299 );
   WriteCoreReg( IRI_QT_REG_RX_CG6_ADDR , (2 << 16 ) |  0x24A9 );
   WriteCoreReg( IRI_QT_REG_RX_CG7_ADDR , (2 << 16 ) |  0x333A );
   WriteCoreReg( IRI_QT_REG_RX_CG8_ADDR , (3 << 16 ) |  0x24E1 );
   WriteCoreReg( IRI_QT_REG_RX_CG9_ADDR , (3 << 16 ) |  0x3362 );
   WriteCoreReg( IRI_QT_REG_RX_CG10_ADDR , (4 << 16 ) |  0x24EF );
   WriteCoreReg( IRI_QT_REG_RX_CG11_ADDR , (4 << 16 ) |  0x336B );
   WriteCoreReg( IRI_QT_REG_RX_CG12_ADDR , (5 << 16 ) |  0x24F2 );
   WriteCoreReg( IRI_QT_REG_RX_CG13_ADDR , (5 << 16 ) |  0x336E );
   WriteCoreReg( IRI_QT_REG_RX_CG14_ADDR , (6 << 16 ) |  0x24F3 );
   WriteCoreReg( IRI_QT_REG_RX_CG15_ADDR , (6 << 16 ) |  0x336F );


   //====== Program QTP Globel registers ========================

   //QTP_CONFIG

   //Initialize the segment size
   uc_TxNsc = gs_TxLog2IfftLength - 6;
   WriteCoreReg(IRI_QTP_REG_CONFIG_ADDR, (uint32)uc_TxNsc);
   // WriteCoreReg(IRI_QTP_REG_CONFIG_ADDR, 0x4); //sizeof each table segment = 512 tones

   //QTP_STATUS
   //Clear QTP_STATUS register (write 1 to clear bit 0 and 1)
   WriteCoreReg(IRI_QTP_REG_STATUS_ADDR, 0x3);

   //QTP_TX_PRBS_DATAx, x = 0 ..., 7
   FillCoreBuf32(IRI_QTP_REG_TX_PRBS_DATA0_ADDR, 0, 8);
   /*
      WriteCoreReg(IRI_QTP_REG_TX_PRBS_DATA0_ADDR, (uint32)0);
      WriteCoreReg(IRI_QTP_REG_TX_PRBS_DATA1_ADDR, (uint32)0);
      WriteCoreReg(IRI_QTP_REG_TX_PRBS_DATA2_ADDR, (uint32)0);
      WriteCoreReg(IRI_QTP_REG_TX_PRBS_DATA3_ADDR, (uint32)0);
      WriteCoreReg(IRI_QTP_REG_TX_PRBS_DATA4_ADDR, (uint32)0);
      WriteCoreReg(IRI_QTP_REG_TX_PRBS_DATA5_ADDR, (uint32)0);
      WriteCoreReg(IRI_QTP_REG_TX_PRBS_DATA6_ADDR, (uint32)0);
      WriteCoreReg(IRI_QTP_REG_TX_PRBS_DATA7_ADDR, (uint32)0);
   */

   //====== Program QTP TX registers =============================

   //QTP_TX_CTRL
   //enable PRBS_GEN and set the number TX tones in QTP
   WriteCoreReg(IRI_QTP_REG_TX_CTRL_ADDR, (uint32)(((gs_TxNumTones-1)<<2)|(1<<1)));

   {
      //QTP_TXTC_CTRL
      WriteCoreReg(IRI_QTP_REG_TXTC_CTRL_ADDR, (1<<5));//disable TOT in QTP

      //QTP_TX_TC_TOT_AD
      WriteCoreReg(IRI_QTP_REG_TXTC_TOT_ADDR, 0);

      //QTP_TXTC_ACT_AD
      WriteCoreReg(IRI_QTP_REG_TXTC_ACTIVE_ADDR, 0);

      //QTP_TX_PRBS
      WriteCoreReg(IRI_QTP_REG_TX_PRBS_ADDR, (uint32)0x7FF); // initial PRBS LFSR state.//for QTP

      //QTP_TX_PRBS_MISC
      //Configued right after IT_PRBS_MISC (IRI_QT_REG_TX_PRBS_MISC_ADDR) above

      //QTP_TX_PRBS_POLY
      WriteCoreReg(IRI_QTP_REG_TX_PRBS_POLY_ADDR, (uint32)0x0100); // d[n] = d[n-9] xor d[n-11] for QTP

      //====== Program QTP RX registers =============================

      //QTP_RX_CTRL
      //PRBS Enable in QTP and set the number of RX tones
      ul_RegData = ((gs_RxNumTones-1) << 2) | (1<<1);
      WriteCoreReg(IRI_QTP_REG_RX_CTRL_ADDR, ul_RegData);

      //QTP_RXTC_CTRL
      WriteCoreReg(IRI_QTP_REG_RXTC_CTRL_ADDR, (1<<5)); //TRT bypass in QTP

      //QTP_RXTC_TOT_AD
      WriteCoreReg(IRI_QTP_REG_RXTC_TOT_ADDR, 0);

      //QTP_TXTC_ACT_AD
      WriteCoreReg(IRI_QTP_REG_RXTC_ACTIVE_ADDR, 0);

      //QTP_RX_PRBS
      WriteCoreReg(IRI_QTP_REG_RX_PRBS_ADDR, (uint32)0x7FF); // Initial Rx PRBS state generator state

      //QTP_RX_PRBS_MISC
      ul_RegData = (10 <<  4);   // d[n] = d[n-9] xor d[n-11] -> LFSR length = 11-1 = 10
      ul_RegData |= ( 1 << 10);   // Resets PRBS generator each frame.
      ul_RegData |= ( 4 << 11);   // Skip 4 bits at end of each symbol.
      WriteCoreReg(IRI_QTP_REG_RX_PRBS_MISC_ADDR, ul_RegData);

      //QTP_RX_PRBS_POLY
      WriteCoreReg(IRI_QTP_REG_RX_PRBS_POLY_ADDR, (uint32)0x0100); // d[n] = d[n-9] xor d[n-11]

      //QTP_RX_PRBS_OFFSET
      WriteCoreReg(IRI_QTP_REG_RX_PRBS_OFFSET_ADDR, 0);

   }
   // Initialize pointers for TX side:
#define TX_PATH   (1)
#define RX_PATH   (0)

   //In the ARC the bank select is used to provide the data which will be at the same address for each port.
   uc_port_num = 0;
   ghpuca_TxBat_Active =                (uint8*) GetActiveBGTNTableAddress(TX_PATH, uc_port_num);
   ghpsa_TxFineGains_Active =   (int16*)(void *)GetActiveBGTNTableAddress(TX_PATH, uc_port_num);
   ghpsa_TxToneOrder_Active =   (int16*)(void *)GetActiveBGTNTableAddress(TX_PATH, uc_port_num);
   ghpuca_TxExtGains_Active =   (uint8*) GetActiveEGTTableAddress(uc_port_num);

   ghpuca_TxBat_Inactive = GetBitAllocationTableAddress(uc_port_num);
   ghpsa_TxFineGains_Inactive = (int16*)GetGainScaleTableAddress(uc_port_num);
   ghpuca_TxExtGains_Inactive = GetExtendedGainTableAddress(uc_port_num);
   ghpsa_TxToneOrder_Inactive = (int16*)GetToneReorderingTableAddress(uc_port_num);


   // Initialize pointers for RX side:
   ghpuca_RxBat_Active = (uint8*)GetActiveBGTNTableAddress(RX_PATH, uc_port_num);
   ghpsa_RxFineGains_Active = (int16*)(void *)GetActiveBGTNTableAddress(RX_PATH, uc_port_num);
   ghpsa_RxToneOrder_Active = (int16*)(void *)GetActiveBGTNTableAddress(RX_PATH,uc_port_num);
   ghpuca_RxBat_Inactive = GetBitAllocationTableAddress(uc_port_num);
   ghpsa_RxFineGains_Inactive = (int16*)GetGainScaleTableAddress(uc_port_num);
   ghpuca_RxExtGains_Inactive = GetExtendedGainTableAddress(uc_port_num);
   ghpsa_RxToneOrder_Inactive = (int16*)GetToneReorderingTableAddress(uc_port_num);

   // set pointers for other HW buffers
   ghpsa_SFDQMantissa = GetSFDQMantissaTableAddress(uc_port_num);
   ghpuca_SFDQExponet = GetSFDQExponentTableAddress(uc_port_num);

   //fill inactive tables
   FillCoreBuf32(IRI_QT_RAM_INACTIVE_BAT_ADDR, 0, (uint16)((IRI_QT_RAM_INACTIVE_BAT_SIZE>>2)>>guc_PortMode));
   FillCoreBuf32(IRI_QT_RAM_INACTIVE_EGT_ADDR, 0, (uint16)((IRI_QT_RAM_INACTIVE_EGT_SIZE>>2)>>guc_PortMode));
   FillCoreBuf32(IRI_QT_RAM_INACTIVE_TOT_ADDR, 0, (uint16)((IRI_QT_RAM_INACTIVE_TOT_SIZE>>2)>>guc_PortMode));

   //Clear active BGT tables
   FillCoreBuf32(IRI_QT_RAM_ACTIVE_BGTN_ADDR, 0, (uint16)(gl_Active_BGTN_Size>>2));
   FillCoreBuf32(IRI_QT_RAM_TX_ACTIVE_EGT_ADDR, 0, (uint16)(gs_Active_TxEGT_Size>>2));

   // Clear SFDQ mantissas
   FillCoreBuf32(IRI_QT_RAM_FDQ_MANT_ADDR, 0, (uint16)((IRI_QT_RAM_FDQ_MANT_SIZE>>2)>>guc_PortMode));
   FillCoreBuf32(IRI_QT_RAM_FDQ_EXP_ADDR, 0, (uint16)((IRI_QT_RAM_FDQ_EXP_SIZE>>2)>>guc_PortMode));

   // clear MFDQ feedback tone table
   FillCoreBuf32(IRI_QT_RAM_RX_FEEDBACK_TONE_ADDR, 0, IRI_QT_RAM_RX_FEEDBACK_TONE_SIZE/4);

   // clear MFDQ coefficient table
   FillCoreBuf32(IRI_QT_RAM_RX_MFDQ_FF_COEF_MANT_ADDR, 0, IRI_QT_RAM_RX_MFDQ_FF_COEF_MANT_SIZE/4);
   FillCoreBuf32(IRI_QT_RAM_RX_MFDQ_FB_COEF_MANT_ADDR, 0, IRI_QT_RAM_RX_MFDQ_FB_COEF_MANT_SIZE/4);
   FillCoreBuf32(IRI_QT_RAM_RX_MFDQ_FB_COEF_EXP_ADDR, 0, IRI_QT_RAM_RX_MFDQ_FB_COEF_EXP_SIZE/4);

   // update CMVs connected to HW pointers
   UpdateINFOMapHWBufPtrs();

}
/***************************************************************************************
;   Subroutine Name: InitIridiaQT_InactiveGain()
;
;   Description:
;      This function initializes the Iridia QT Inactive Gain Table.
;
;
;   Prototype:
;      void InitIridiaQT_InactiveGain()
;
;   Input Arguments:
;
;   Output Arguments:
;      none
;
;   Return Value:
;      none
;
;**********************************************************************************************/
void InitIridiaQT_InactiveGain()
{
   FillCoreBuf32(IRI_QT_RAM_INACTIVE_GAIN_SCALE_ADDR, (uint32)0x20002000, (uint16)((IRI_QT_RAM_INACTIVE_GAIN_SCALE_SIZE>>2)>>guc_PortMode));
}

void InitIridiaQT_PostGhs()
{
   uint32 ul_Data;
   uint8 uc_TxNsc;
   uint8 uc_TxNumIfftTones;
   if (gt_ProfileAct.us_ProfileSelected & CNFG_V2_PROFILE_35B_MASK)
   {
      //IR_NSC
      ul_Data = gs_RxLog2FftLength - 6 ;
      WriteCoreReg(IRI_QT_REG_RX_NSC_ADDR, ul_Data);

      //QTP_RX_CTRL
      //PRBS Enable in QTP and set the number of RX tones
      ul_Data = ((gs_RxNumTones-1) << 2) | (1<<1);
      WriteCoreReg(IRI_QTP_REG_RX_CTRL_ADDR, ul_Data);

      //QTP_CONFIG
      //Initialize the segment size
      //SegmentSize = Max(NSCds, NSCus);
      ul_Data = (MAX(gs_TxLog2IfftLength, gs_RxLog2FftLength) - 6);
      WriteCoreReg(IRI_QTP_REG_CONFIG_ADDR, (uint32)ul_Data);

      if (gs_TxLog2IfftLength > US_LOG2_FFT_LENGTH_8192)
      {
         //IT_CONFIG
         uc_TxNsc = gs_TxLog2IfftLength - 6;
         uc_TxNumIfftTones = uc_TxNsc;

         ul_Data = (uint32)uc_TxNsc;
         ul_Data |= (uint32)uc_TxNumIfftTones<<4;
         WriteCoreReg(IRI_QT_REG_TX_CNFG_ADDR,  ul_Data);

         //QTP_TX_CTRL
         //enable PRBS_GEN and set the number TX tones in QTP
         WriteCoreReg(IRI_QTP_REG_TX_CTRL_ADDR, (uint32)(((gs_TxNumTones-1)<<2)|(1<<1)));
      }
   }

}

