/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 1998-2004 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *----------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Condfidential
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276-4000
 *   FAX   (781) 276-4001
 *
 *   IRI_sync.C
 *
 *   Iridia frame alignment functions.
 *
 *
 *----------------------------------------------------------------------------
 */
#include "sys_const.h"
#include "gdata.h"
#include "LL_IOf.h"
#include "str_memmap.h"
#include "IRI_sync.h"

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : AdjustAlignment
 *
 *  Description:    Adjusts the Alignment forward by gs_AlignmentOffset samples
 *
 *  Prototype:  void AdjustAlignment(void)
 *
 *
 *  Output Arguments: None
 *
 *  Return:
 *          None
 *
 *  Global Variables Used:
 *      gs_AlignmentOffset - the number of samples to adjust alignment
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */
C_SCOPE void AdjustAlignment(void)
{
   uint32 ul_data;
   int16 s_AlignmentOffset;

   //Make sure each strymon frame (between two consecutive buffer swap)
   //is not less than the FFT size (otherwise, the time-slotted task assignment may be messed up)
   if(gs_RxFrameAlignRemain == 0)
   {
      s_AlignmentOffset = gs_AlignmentOffset;
   }
   else
   {
      s_AlignmentOffset = gs_RxFrameAlignRemain;
   }

   if(s_AlignmentOffset <= gs_RxCELength)
   {
      gs_RxFrameAlignRemain = 0;
   }
   else
   {
      gs_RxFrameAlignRemain = s_AlignmentOffset - gs_RxCELength;
      s_AlignmentOffset = gs_RxCELength;
   }

   // Set to (Rx frame size - gs_AlignmentOffset) in TD samples
   ul_data = (gs_RxFftLength - s_AlignmentOffset)|gul_RxFftRate;
   WriteCoreReg((uint32)V_RX_FSIZE_ADDR, ul_data);

}

/***************************************************************************************
;   Subroutine Name: ResetRxAlign
;
;   Description:
;      This routine resets the Iridia to normal operation following adjustment
;      of the synch point.  Must be called on the frame immediately after synch
;       adjust.
;
;   Prototype:
;      void ResetRxAlign(void)
;
;   Input Arguments:
;
;   Output Arguments:
;      none
;
;   Return Value:
;      none
;
;   Global Variables:
;
;   Substates:
;
;**********************************************************************************************/
C_SCOPE void ResetRxAlign(void)
{
   uint32 ul_data;

   ul_data = gs_RxFftLength | gul_RxFftRate;
   WriteCoreReg((uint32)V_RX_FSIZE_ADDR, ul_data);
}

/*^^^
 *------------------------------------------------------------------------
 *
 *  Prototype:  void AdjustTxTimingAdvance(void)
 *
 *  Description:    Lengthen or shorten the TX frame by gs_TimingAdvance samples.
 *
 *  Output Arguments: None
 *
 *  Return:
 *          None
 *
 *  Global Variables Used:
 *      gs_TxIfftLength -- TX FFT frame size
 *      gs_TimingAdvance - number of TX samples
 *      (Note: abs(gs_TimingAdvance) is restricted to be not greater than gs_TxIfftLength)
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */

C_SCOPE void AdjustTxTimingAdvance(void)
{
   uint32 ul_TxFrameSize;
   int16 s_TimingAdvance;

   //Make sure each strymon frame (between two consecutive buffer swap)
   //is not less than the IFFT size (otherwise, the time-slotted task assignment may be messed up)
   if(gs_TxFrameAlignRemain == 0)
   {
      s_TimingAdvance = gs_TimingAdvance;
   }
   else
   {
      s_TimingAdvance = gs_TxFrameAlignRemain;
   }

   if(s_TimingAdvance < 0)
   {
      if (gs_DbgRecnfgCpCsBeta & TX_TIMING_ADVANCE_DELAY_2STEP_EN)
      {
         if (s_TimingAdvance >= -4416)
         {
            gs_TxFrameAlignRemain = 0;
         }
         else
         {
            gs_TxFrameAlignRemain = s_TimingAdvance + 4416;
            s_TimingAdvance = -4416;
         }
      }
      else
         gs_TxFrameAlignRemain = 0;
   }
   else if(0<= s_TimingAdvance <= gs_TxCELength)
   {
      gs_TxFrameAlignRemain = 0;
   }
   else
   {
      gs_TxFrameAlignRemain = s_TimingAdvance - gs_TxCELength;
      s_TimingAdvance = gs_TxCELength;
   }

   //======================================================================
   //First change the frame length to compensate for timing advance
   //If gs_TimingAdvance > 0, this implies that TX frame should be advanced,
   //thus we need to shorten this frame (the next frame is the one where TA takes effect).
   //If gs_TimingAdvance < 0, this implies that TX frame should be delayed,
   //thus we need to lengthen this frame.
   //=======================================================================
   ul_TxFrameSize = (gs_TxIfftLength - s_TimingAdvance)|gul_TxIfftRate;
   WriteCoreReg((uint32)V_TX_FSIZE_ADDR, ul_TxFrameSize);
}

/***************************************************************************************
;   Subroutine Name: ResetTxTimingAdvance
;
;   Description:
;      This routine resets the Iridia to normal operation following adjustment
;      of the TX timing advance.  Must be called on the frame immediately after timing
;       advance adjustment.
;
;   Prototype:
;      void ResetTxTimingAdvance(void)
;
;   Input Arguments:
;
;   Output Arguments:
;      none
;
;   Return Value:
;      none
;
;   Global Variables:
;      gs_TxIfftLength -- TX FFT frame size
;
;   Substates:
;
;**********************************************************************************************/
C_SCOPE void ResetTxTimingAdvance(void)
{
   uint32 ul_TxFrameSize;

   ul_TxFrameSize = gs_TxIfftLength|gul_TxIfftRate;
   WriteCoreReg((uint32)V_TX_FSIZE_ADDR, ul_TxFrameSize);
}


