/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2011 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;   Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;   Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;   File Name: InitEngine_PreHandshake.c
;
;   Initialization functions
;
*****************************************************************************/
#include "common.h"
#include "ft_memmap.h"
#include "mtkernel.h"
#include "cri_memmap.h"
#include "cri_ini.h"
#include "cri_iof.h"
#include "V_STR_ini.h"
#include "IRI_ini.h"
#include "IRI_Iof.h"
#include "LL_IOf.h"
#include "gdata.h"
#include "ZPH_Ini.h"
#include "V_STR_IOf.h"

/*****************************************************************************
;   Prototype: int16 InitModem_PowerDownAfe(void)
;
;   This subroutine initializes the serial interface to the AFE and then
;   AFE is set to power down mode.
;
;   Input Arguments: none
;
;   Output Arguments: none
;
;   Return:
;       SUCCEED                 - Initialization is done successfully
;       FAIL                    - Initialization fails
;
;****************************************************************************/

/***************************************************************************************
;   Subroutine Name: InitEngine_PreHandshake
;
;   Description:
;      This function initializes the ADSL cores.
;
;   Prototype:
;      void InitEngine_PreHandshake(void)
;
;   Input Arguments:
;      none
;   Output Arguments:
;      none
;   Return Value:
;      none
;
;**********************************************************************************************/
void InitEngine_PreHandshake(void)
{
   // Do not Initialize VDSL Strymon block until frame rate is known at Link Start.
   // This is to avoid a POTENTIAL problem with the re-initialization.
   // More study is required to determine if there is really a problem.

   // Soft reset all the HW cores via CRI RST
   // Note: Soft reset is now moved to main_hw.c
   // SoftResetCores();

   // Hold Strymon in reset until the configuration is complete
   // Otherwise, the buffer sequencing registers IRI_FTB_TX_STATUS_ADDR
   // and IRI_FTB_RX_STATUS_ADDR may not be set up properly.
   DisableStrymon();

   // Initialize Iridia FT block
   InitIridiaFT();

   // Initialize Iridia QT block
   InitIridiaQT();

   // Switch the inactive/active Tx tables
   SwitchTxPingPongTable();


   // Initialize Zephyr block
   InitZephyr();


   // Initialize CRI block
   // (Note: this should be done at the end so other cores are not enabled while they
   //  are configured)
   InitCRI();

} //void InitEngine_PreHandshake(void)

