/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2007 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: LoadIridiaTransmitGains.c
*
*   This file contains engine interface functions to set TX gain.
*
*-------------------------------------------------------------------------------
*/

#include "common.h"
#include "gdata.h"
#include "LL_IOf.h"
#include "ft_memmap.h"
#include "IRI_Iof.h"

/*
*-------------------------------------------------------------------------------
*
*   Prototype: void LoadIridiaTransmitGains(void)
*
*   This function loads transmit gains in HW based on the task layer settings
*   determined in SetTransmitGains, for   Fine Gains, etc table, IFFT scales,
*   conditional parr enable.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/

void LoadIridiaTransmitGains(void)
{
   uint32 ul_data;

   //zero out TX outband tones
   ZeroTxOutbandTones();

   //IFFT fine gains, etc.
   SwitchTxPingPongTable();

   if (gft_EnableTxPSDCtrl)
   {
      //IFFT scales
      ReadCoreReg((uint32)IRI_FT_REG_TX_SCALE_ADDR, &ul_data);
      ul_data &= ~0x00003FFF;
      ul_data |= gul_ifft_scales_cntl_word;
      WriteCoreReg(IRI_FT_REG_TX_SCALE_ADDR, ul_data);
   }

}
