/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2004 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;   Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;   Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;   File Name: OvhdMsg_IOf_VDSL2.c
;
;   This file contains HW i/o functions for supporting VDSL2 overhead messaging,
;   including IB and EOC.
;
*****************************************************************************/
#include "common.h"
#include "gdata.h"
#include "LL_IOf.h"
#include "zep_memmap.h"
#include "zep_memmap_cnfg.h"
#include "OvhdMsg_IOf.h"
#include "cri_iof.h"

#include "zep_memmap_cnfg.h"
extern RRC_Stat_t gt_RrcStat;
extern ReTX_Params_t gt_ReTXParams;

//extern uint16 gus_dbg_LogControl;
//extern int16  gs_dbg_OH_Frame_Idx;
//extern int16  gs_QTdone_LogIdx;
//extern uint8 *gpuc_QT_Done;

/****************************************************************************
; Name: void WriteTxOvhdHwFifo
;
; Prototype:
;   void void WriteTxOvhdHwFifo
;
; Description:
;   This function writes Tx overhead bytes to FIFO #0 of the Zephyr core.
;
; Arguments:
;   N/A
;
; Return Value:
;   N/A
;
; Globals:
;
*****************************************************************************/
void WriteTxOvhdHwFifo(void)
{
   uint32 ul_data, ul_data_sav;
   uint8 uc_ready, uc_full=0;

   if (gt_ReTXParams.uc_OMSG1_DsReTxEnabled == RETX_SELECTED)
   {
      // with ReTX enabled, OVHD bytes will be put in FIFO_0 of LP0
      ul_data = 0;         //FIFO_NUM = 0, FIFO_LP = 0
   }
   else
   {
      if (gt_tx_TPS_Map.s_IBITSlp == LP1)
      {
         ul_data = (1 << 8); //FIFO_NUM = 1
         ul_data |= 1 << 12; //FIFO_LP = 1
      }
      else
      {
         ul_data = 0;      ////FIFO_NUM = 0, FIFO_LP = 0
      }
   }

   ul_data_sav = ul_data;

   ul_data |= 1 << 16;            //Valid_Bytes_REQ = 1
   WriteCoreReg(ZEP_REG_ZT_FIFO_ACCESS_ADDR, ul_data);

   uc_ready = 0;
   while (!uc_ready)
   {
      ReadCoreReg(ZEP_REG_ZT_FIFO_ACCESS_ADDR, &ul_data);
      if (ul_data & (1<<11)) //FIFO_RDY = 1
      {
         uc_ready = 1;

         uc_full = (ul_data>>31) & 0x1;
      }
   }

   while((gs_TxOvhdSwFifoDepth > 0) && (uc_full == 0))
   {
      ul_data = ul_data_sav;
      ul_data |= (uint32)guca_TxOvhdSwFifoBuf[gs_TxOvhdRdPtr]; //7:0 FIFO_Byte
      ul_data |= 1 << 10; //10 FIFO_Write
      WriteCoreReg(ZEP_REG_ZT_FIFO_ACCESS_ADDR, ul_data);

      uc_ready = 0;
      while (!uc_ready)
      {
         ReadCoreReg(ZEP_REG_ZT_FIFO_ACCESS_ADDR, &ul_data);
         if (ul_data & (1<<11)) //FIFO_RDY = 1
         {
            uc_ready = 1;
            uc_full = (ul_data>>31) & 0x1;
         }
      }

      gs_TxOvhdSwFifoDepth--;

      // Reset pointer if it reaches end of SW buffer
      gs_TxOvhdRdPtr++;
      if(gs_TxOvhdRdPtr == TX_OVHD_MSG_SWFIFO_LEN)
      {
         gs_TxOvhdRdPtr = 0;
      }

   } //while((gs_TxOvhdSwFifoDepth > 0) && (uc_full == 0))
}

/****************************************************************************
; Name: ReadRxOvhdHwFifo
;
; Prototype:
;   void ReadRxOvhdHwFifo(void)
;
; Description:
;   This function reads Rx overhead bytes from FIFO #0 of the Zephyr core.
;
; Arguments:
;   N/A
;
; Return Value:
;   N/A
;
; Globals:
;
*****************************************************************************/
void ReadRxOvhdHwFifo(void)
{
   int16  s_MaxWrPtr;
   uint32 ul_data, ul_data_sav;
   uint8 i;
   uint8 uc_ready;
   uint16 us_NumValidBytes=0;

   if (gt_ReTXParams.uc_OMSG1_DsReTxEnabled == RETX_SELECTED)
   {
      // with ReTX enabled, OVHD bytes will come from  FIFO_0 of LP0
      ul_data = 0;         //FIFO_NUM = 0, FIFO_LP = 0
   }
   else
   {
      if (gt_rx_TPS_Map.s_IBITSlp == LP1)
      {
         ul_data = (1 << 8);      //FIFO_NUM = 1
         ul_data |= (1 << 12);   //FIFO_LP = 1
      }
      else
      {
         ul_data = 0;         //FIFO_NUM = 0, FIFO_LP = 0
      }
   }

   ul_data_sav = ul_data;

   ul_data |= 1 << 16; //Valid_Bytes_REQ = 1
   WriteCoreReg(ZEP_REG_ZR_FIFO_ACCESS_ADDR, ul_data);

   uc_ready = 0;
   while (!uc_ready)
   {
      ReadCoreReg(ZEP_REG_ZR_FIFO_ACCESS_ADDR, &ul_data);
      if (ul_data & (1<<11)) //FIFO_RDY = 1
      {
         uc_ready = 1;
         us_NumValidBytes = (uint8)((ul_data >> 17) & 0x1FFF);
      }
   }

   // To avoid overwriting bytes which are waiting to be sent, prevent
   // write pointer from reaching read pointer
   s_MaxWrPtr = gs_RxOvhdRdPtr - 1;

   // Check for s_MaxWrPtr wrap
   if(s_MaxWrPtr < 0)
   {
      s_MaxWrPtr = RX_OVHD_MSG_SWFIFO_LEN-1;
   }

   // Empty out the HW fifo based on valid bytes to read value
   for (i = 0; i < us_NumValidBytes; i++)
   {
      // Write Ovhd byte to circular SW FIFO if it's not already full
      if (gs_RxOvhdWrPtr != s_MaxWrPtr)
      {
         ul_data = ul_data_sav;
         //ul_data |= 0 << 10; //10 FIFO_Read
         WriteCoreReg(ZEP_REG_ZR_FIFO_ACCESS_ADDR, ul_data);

         uc_ready = 0;
         while (!uc_ready)
         {
            ReadCoreReg(ZEP_REG_ZR_FIFO_ACCESS_ADDR, &ul_data);
            if (ul_data & (1<<11)) //FIFO_RDY = 1
            {
               uc_ready = 1;
            }
         }

         guca_RxOvhdSwFifoBuf[gs_RxOvhdWrPtr++] = (uint8)(ul_data & 0xFF);

//         //Given below debug code may be used to compare the expected pattern of OH channel 0xAC for every OH superframe
//         //This code was used to detect the expect pattern 0xAC for every 63 OH bytes.
//         //Log upto 24K memory buffer
//         if (gs_QTdone_LogIdx < 24576)
//         {
//            if ((gs_dbg_OH_Frame_Idx == 0) && ((ul_data & 0xFF) != 0xAC) &&  (gus_dbg_LogControl & 0x20))
//            {
//               gft_PauseOff = 0;
//               DisableRxPms();
//               DisableTxPms();
//               Pause(0x4488);
//            }
//            gpuc_QT_Done[gs_QTdone_LogIdx++] = (uint8)(ul_data & 0xFF);
//
//            //Look for an initial OH Frame alignment, if not coming correct, Pause
//            gs_dbg_OH_Frame_Idx++;
//            if (gs_dbg_OH_Frame_Idx == 63)
//              gs_dbg_OH_Frame_Idx = 0;
//         }
//
//        if (gs_QTdone_LogIdx == 24570)
//         gs_QTdone_LogIdx = 0;

         // Check for buffer wrap
         if (gs_RxOvhdWrPtr == RX_OVHD_MSG_SWFIFO_LEN)
         {
            gs_RxOvhdWrPtr = 0;
         }
      }
      else
      {
         break;
      }
   }
}

