/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 1998-2006 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*----------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Condfidential
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276-4000
 *   FAX   (781) 276-4001
 *
 *   cri_iof.c
 *
 *   Clock, Reset, Interrupt (CRI) block core interface functions
 *
 *
 *----------------------------------------------------------------------------
 */
// ***********************************************************************************************************
// cri_iof.c
//
// History
//
//
// 18/09/2014  Palaksha:
//              The FW changes for "XDSLRTFW-1707 Bringup of DS/US Retransmission on 30a profile"
//              In general The changes involve
//              - Memory optimization (Need more memory to support 200Mbps DSNDR /100Mbps USNDR)
//                              VRx318 platform : 86K + 12K+ 17K = 115K IlvDilv Memory
//                                      Moved ThreeGLP_Interface.c(used all the time) from CACHE_INIT_1PORT to ONE_PORT_MAIN_ISWAP
//                                      Also moved below files(used all the time) from CACHE_TRN_1PORT to ONE_PORT_MAIN_ISWAP
//                  main_hw.o(.text) snr_b.o(.text)    CalcShowtimeSnrMargin.o(.text)   QuickAverage.o(.text)
//                      CACHE_TRN_1PORT contains files which are used only till training ==> this place can be used in showtime as a overlay
//                                      This got around 12K+17K for ReTx buffer usage
//                              So only VRx318 platform can support 200Mpbs DSNDR + Additional 18K buffer 3-needle noise handling
//                                                      Vector friendly FW binary               Full Vector  FW binary
//                                                              -----------------                       ---------------------
//                                                              VRx318          VR9                                     VRx318          VR9
//              Memory Section Name
//              Size in Bytes
//              ST_VECTORING_BUFFER     12800           12800                           0                       0
//              ONE_PORT_ILV_DILV_HW    88064           88064                           88064           88064
//              CACHE_INIT_1PORT                12544           0                                       12544           0
//              CACHE_TRN_1PORT                 22064           0                                       22064           0
//              Total Memory in Bytes          135472           100864                          122672          88064
//              Total Memory in KB              132.30          98.50                           119.80          86.00
//              on VRX 318, disabled DEBUG buffer functionality to get around 4k of data memory in addition to above
//              - Indicate Max delay Octet = 121K*2 for Vrx318 and 86K*2 for VR9 ("Field 10 : Octet 11-12-13 of  G.INP R-MSG2  message)
//              - ARC Mips optimization/HW Accelerator time change
//                      Since in 30a profile frame rate is 8KHz and it has only 2 Timeslots(32768 ARC cycles will be available),
//                      less cylces for ARC/HW accelarators  available in a symbol period.
//                      Changed Start time of  Tx FC,Tx QTP, Tx QT and Rx FC and these changes are under bit#6 of test 28 0 CMV and enabled by default
//              - rearranged some functions related to RTXus so that forward DTU function execte early in RXTC
//              - Restricted rate of transfer size to 3438 bytes instead of 4160 bytes on PPE-DSL intreface to reduce PPE buffer overflow.TEST_Control3_Test28_Bit7Mask
//              -  RMSG2_UsNetDataRateMax = 100 mbps
//              - RTXds Framing modifications for 30 Mhz profile
//                      So far framing generation tested only for up to 17a profile. For 30a there are additional framing combinations available
//                      Need to evaluation these framing for 30a RTXds mode for HW accelerator time constraint(only 32768 cycles in a symbol).
//                      More codewords in a symbol will result in more time to complete.
//                      Restricting framing combinations(HQV) to have maximum of 7 CWs (HQV index from 15 to 25 are only selected)
//                      Also overflow handling in fixed point implementation code in RTX framing generation is done
//              - RTXds parameter handling in 30Mhz profile
//                      Roundtrip delay in symbols is double due to higher frame and Roundtrip delay in DTUs is to be taken as is(No doubling)
//              - Change the value "RX_LP_ORDER (Order of processing of Rx latency paths) field in IR_MISC register"
//                      from 4 (Lp2 Lp1 Lp0) to 2(Lp0 Lp1 Lp2). With RX_LP_ORDER=4(Lp2 Lp1 Lp0), if the 1st bin in ToT is >8 bits, then even
//                      if Lp2 is allocated 0 bits, but HW considers it as active LP and throws up HW Rx BAT error in CRI register.This is because
//                      hardware supports encoding of two latency paths on the same tone. As of now RX_LP_ORDER=2(Lp0 Lp1 Lp2) is being used as an
//                      interm solution DS RTX is enabled in 30a profile. If US RTX in 30a to be supported then RX_LP_ORDER=4(Lp2 Lp1 Lp0) setting is needed.
//                      In that case we need to have the special handling of 1st tone in ToT. The same problem can also happen on tx path(TX_LP_ORDER) as well.
//                      we decided not do change anything we shall use default (Lp2 Lp1 Lp0) ordering. So as a working around testing 30a RTX (us, ds or both)
//                      we shall use  OH rate of minimum of 128 kbps (this ensures minimum 16 bits per symbol)
//   grep for XDSLRTFW-1707_30a_RTX_DsUs
//
// 07/08/2015  ChihWen:
//             Move the Tx timer setup for QTP, and QT (30a RTX) from "Reconfig_CRI" to "StartTxDataPath"
//             because the setup will cause Strymon Tx overflows during training and lower DS rate.
//             Grep for XDSLRTFW-2307_Move_TxTimerSetup_30a_RTX
// ************************************************************************************************************

#include "common.h"
#include "cri_cocomo_interface.h"
#include "LL_IOf.h"
#include "gdata.h"
#include "cri_memmap.h"
#include "mtkernel.h"
#include "dsp_op.h"
#include "cmv.h"
#include "cmv_Data.h"

/*
*-------------------------------------------------------------------------------
*
*   Prototype: void Reconfig_CRI(void)
*
*   This function reconfigures CRI (called at the end of GHS)
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/

// This function should be called at the end of G.hs
void Reconfig_CRI(void)
{
   //XDSLRTFW-2392 (Cascaded scheduling - Start)
   if (guc_CasMode_enable)
   {
      //***************Start of 35B CRI configuration*************/
      //Configure the transmit timeslot settings
      {
         #define TX_QTP_TS_PORT0_4K_CASCADE   (0x1F)
         #define TX_PMS_TS_PORT0_4K_CASCADE   (0x1F)
         #define TX_QT_TS_PORT0_4K_CASCADE    (0x1F)
         #define TX_IFFT_TS_PORT0_4K_CASCADE  (0x1F)   //inactive
         #define TX_PAR_TS_PORT0_4K_CASCADE   (0x1F)   //inactive
         #define TX_DSP_TS_PORT0_4K_CASCADE   (0x1F)

         WriteCoreReg(CRI_TX_TSLOTC_A_ADDR, (TX_QTP_TS_PORT0_4K_CASCADE |(TX_PMS_TS_PORT0_4K_CASCADE<<5)|
                                             (TX_QT_TS_PORT0_4K_CASCADE<<10)|(TX_IFFT_TS_PORT0_4K_CASCADE<<15)|
                                             (TX_PAR_TS_PORT0_4K_CASCADE<<20)|(TX_DSP_TS_PORT0_4K_CASCADE<<25)));
      }

      //Configure the receive timeslot settings
      {
         #define RX_QTP_TS_PORT0_4K_CASCADE   (0x1F)
         #define RX_FFT_TS_PORT0_4K_CASCADE   (0x1F)   //inactive
         #define RX_QT_TS_PORT0_4K_CASCADE    (0x1F)
         #define RX_PMS_TS_PORT0_4K_CASCADE   (0x1F)
         #define RX_DSP_TS_PORT0_4K_CASCADE   (0x1F)
         WriteCoreReg(CRI_RX_TSLOTC_A_ADDR, ((RX_QTP_TS_PORT0_4K_CASCADE<<0)|(RX_FFT_TS_PORT0_4K_CASCADE<<5)|
                                             (RX_QT_TS_PORT0_4K_CASCADE<<10)|(RX_PMS_TS_PORT0_4K_CASCADE<<15)|
                                             (RX_DSP_TS_PORT0_4K_CASCADE<<25)));
      }


      //XDSLRTFW-3148 (Start)
      if (gul_35bLiteConfig & EN_HRT_5_0_SCHEDULING_FOR_CASCADED_MODE)
      {
         //XDSLRTFW-3493(Start)
         //XDSLRTFW-3506(Start)
         //Reverted back to "0" to start at Tx buffer swap boundary
         //Seeing link drop/training failures after shift of 8192 cycles.
         gl_TxFcTimerCount = 0; //Start at the buffer swap boundaries.
         gl_TxQtpTimerCount = 0;  //16384
         //XDSLRTFW-3506(End)
         //XDSLRTFW-3493(End)
      }
      else
      {
         //Set the core to start w.r.t Buffer swap time on 4 khz frame rate
         gl_TxFcTimerCount = CRI_TSC_CTRL_NUM_CLKS + 1500;
         gl_TxQtpTimerCount = CRI_TSC_CTRL_NUM_CLKS + 1500;  //16384
      }

      if (gt_ProfileAct.us_ProfileSelected & CNFG_V2_PROFILE_35B_MASK )
      {
         if (gul_35bLiteConfig & EN_HRT_5_0_SCHEDULING_FOR_CASCADED_MODE)
         {
            gus_TxQtTimerCount = 34000;
         }
         else
         {
            gus_TxQtTimerCount = 35000;
         }
      }
      else
      {
        gus_TxQtTimerCount = 26536+500;
      }
      //XDSLRTFW-3148 (End)
      //Configure TX PMS
      //It has been disabled in InitCRI() and will be enabled (and configured) EnableTxPms() later;

      //Configure TX QT & QTP to start w.r.t Buffer swap time on 4 khz frame rate
      WriteCoreReg(CRI_TX_QTP_CTL_ADDR, (gl_TxQtpTimerCount | TX_TIMER_START_TX_QTP_SEL));
      WriteCoreReg(CRI_TX_QT_CTL_ADDR, (gus_TxQtTimerCount | TX_TIMER_START_TX_QT_SEL));

      //Program IFFT to be triggered by timer-based method
      //TX_IFFT_REG_START = 0
      //TX_IFFT_START_SEL = 2 (timer-based)
      //TX_IFFT_GO_CNT = Predefined timer
      if(gs_CRI_DbgCntl & CRI_DBG_CNTL_DISABLE_IFFT)
      {
         WriteCoreReg(CRI_TX_IFFT_CTL_ADDR, 0);
      }
      else
      {
         if (gt_ProfileAct.us_ProfileSelected & CNFG_V2_PROFILE_35B_MASK )
         {
            //XDSLRTFW-3148 (Start)
            if (gul_35bLiteConfig & EN_HRT_5_0_SCHEDULING_FOR_CASCADED_MODE)
            {
               //For 35B mode with HRT 5,0, Configure IFFT to start at Tx QT done event.
               WriteCoreReg(CRI_TX_IFFT_CTL_ADDR, (uint32)(TX_QT_DONE_START_TX_IFFT_SEL));
            }
            else
            {
               //For 35B mode, Configure IFFT to start at Buffer swap boundary
               WriteCoreReg(CRI_TX_IFFT_CTL_ADDR, (uint32)(TX_BUFFER_SWAP_START_IFFT_SEL));
            }
            //XDSLRTFW-3148 (End)
         }
         else
         {
            WriteCoreReg(CRI_TX_IFFT_CTL_ADDR, (uint32)(TX_TIMER_START_TX_IFFT_SEL|36536));
         }
      }

      //Program FFT to be triggered by the RX buffer-swap
      if(gs_CRI_DbgCntl & CRI_DBG_CNTL_DISABLE_FFT)
      {
         //Configure RX FFT to disabled
         WriteCoreReg(CRI_RX_FFT_CTL_ADDR, 0);
      }
      else
      {
         //Configure RX FFT to rx buffer swap
         WriteCoreReg(CRI_RX_FFT_CTL_ADDR, RX_BUFFER_SWAP_START_RX_FFT_SEL);
      }

      //Configure RX QT to start in REG START mode
      //RX_QT_REG_START = 0
      //RX_QT_START_SEL = 4
      //RX_QT_GO_CNT = CRI_RX_QT_GO_CNT_8K
      if(gs_CRI_DbgCntl & CRI_DBG_CNTL_DISABLE_RXQT)
      {
         WriteCoreReg(CRI_RX_QT_CTL_ADDR, 0);
      }
      else
      {
         if (gt_ProfileAct.us_ProfileSelected & CNFG_V2_PROFILE_35B_MASK )
         {
            //XDSLRTFW-2168 (Start)
            if (gul_35bLiteConfig & EN_HRT_5_0_SCHEDULING_FOR_CASCADED_MODE)
            {
               //For 35B mode with HRT 5,0, Configure Rx QT start at Rx FFT done event.
               WriteCoreReg(CRI_RX_QT_CTL_ADDR, (RX_FFT_DONE_START_RX_QT_SEL)); //QT is triggered automatically from RX FFT done. It is working
            }
            else
            {
               //Rx QT Must be started once Rx PMS & Rx QTP are finished.
               //Start 35K cycles after buffer swap
               WriteCoreReg(CRI_RX_QT_CTL_ADDR, (35000 | RX_TIMER_START_RX_QT_SEL));
            }
            //XDSLRTFW-2168 (End)
         }
         else
         {
            WriteCoreReg(CRI_RX_QT_CTL_ADDR, (RX_FFT_DONE_START_RX_QT_SEL)); //QT is triggered automatically from RX FFT done. It is working
         }
      }

      //XDSLRTFW-2168 (Start)
      if (gul_35bLiteConfig & EN_HRT_5_0_SCHEDULING_FOR_CASCADED_MODE)
      {
         //Configure RX QTP to start at Rx buffer swap
         WriteCoreReg(CRI_RX_QTP_CTL_ADDR, (RX_TIMER_START_RX_QTP_SEL | 36000));//XDSLRTFW-3901 (START_END) //46000
      }
      else
      {
         //Configure RX QTP to start at Rx buffer swap
         WriteCoreReg(CRI_RX_QTP_CTL_ADDR, (RX_BUFFER_SWAP_START_RX_QTP_SEL));
      }
      //XDSLRTFW-2168 (End)

      //Configure RX PMS
      //It is disabled in InitCRI() and will be enabled (and configured) in EnableRxPms() later

      //First reset QT stall registers to the power-on state
      WriteCoreReg(CRI_TX_QT_STALL_ADDR, 0xE0000);
      WriteCoreReg(CRI_RX_QT_STALL_ADDR, 0xE0000);

      //Tx QT stall disabled
      WriteCoreReg(CRI_TX_QT_STALL_ADDR, ((CRI_TX_QT_STALL_CLKS_8K)|(0<<16)));

      //Rx QT stall disabled
      WriteCoreReg(CRI_RX_QT_STALL_ADDR, ((CRI_RX_QT_STALL_CLKS_8K)|(0<<16)));

      //Enable Interrupt Masks
      ResetCoreReg(CRI_MASK0_RX_ADDR, CRI_MASK_RX_TSC_INT);  //Mask RX TSC interrupt

      //XDSLRTFW-3670, XDSLRTFW-3660 (Start)
      {
         uint32 ul_data;
         // clear Previous Rx Timer interrupt event if any
         //WriteCoreReg(CRI_EVENT_ADDR, CRI_MASK_RX_CRI_TIMER);

         //Configure the Rx Timer value at which Rx interrupt is expected.
         ReadCoreReg(CRI_RX_TIMER_CTL_ADDR, &ul_data);
         ul_data = ul_data & 0xFFF00000;
         ul_data |= gl_StartReqRxTimerInt;
         WriteCoreReg(CRI_RX_TIMER_CTL_ADDR, ul_data);
         SetCoreReg(CRI_MASK0_RX_ADDR,  CRI_MASK_RX_CRI_TIMER );  //Enable Rx Timer Interrupt
      }


      {
         uint32 ul_data;
         // clear Previous Rx Timer interrupt event if any
         //WriteCoreReg(CRI_EVENT_ADDR, CRI_MASK_TX_CRI_TIMER);

         //Configure the Tx Timer value at which Tx interrupt is expected.
         ReadCoreReg(CRI_TX_TIMER_CTL_ADDR, &ul_data);
         ul_data = ul_data & 0xFFF00000;
         ul_data |= gl_StartReqTxTimerInt;
         WriteCoreReg(CRI_TX_TIMER_CTL_ADDR, ul_data);
         SetCoreReg(CRI_MASK0_TX_ADDR,  CRI_MASK_TX_CRI_TIMER );  //Enable Tx Timer Interrupt
      }
      //XDSLRTFW-3670, XDSLRTFW-3660 (End)

#ifdef ENABLE_PMS_DONE_INT_FOR_PMS_CYCLE_MEASUREMENT //XDSLRTFW-3322 (start_End)
        //Enable this code to measure the Time taken by Tx & Rx PMS
//      if (gs_dbg_EnableRxPMSInt)
//      {
         SetCoreReg(CRI_MASK0_RX_ADDR,  (CRI_MASK_RX_PMS_DONE));  //Enable Rx PMS done Interrupt
         SetCoreReg(CRI_MASK0_TX_ADDR,  (CRI_MASK_TX_PMS_DONE));  //Enable Tx PMS done Interrupt
//      }
#endif  //XDSLRTFW-3322 (start_End)
      guc_Start_CasMode_Int = 1;

      //***************End of 35B CRI configuration*************/
   }  //XDSLRTFW-2392 (Cascaded scheduling - End)
   else
   {
      uint32 ul_data;
      uint32 ul_NumClocksPerTimeSlot;

      //Disable TX/RX timer
      WriteCoreReg(CRI_TX_TIMER_CTL_ADDR, 0);
      WriteCoreReg(CRI_RX_TIMER_CTL_ADDR, 0);

      //Clear TX/RX timer
      WriteCoreReg(CRI_TX_TIMER_ADDR, 0);
      WriteCoreReg(CRI_RX_TIMER_ADDR, 0);

      //Enable TX timer counter
      #define TX_TIM_RLVR      (0)   //set roll over on TX buffer swap
      #define TX_TIM_ENB      (1) //Enable TX timer counter
      #define TX_TIM_START   (1) //Start timer at the first rollover

      WriteCoreReg(CRI_TX_TIMER_CTL_ADDR, (TX_TIM_RLVR<<21)|(TX_TIM_ENB<<20)|(TX_TIM_START<<28));

      // Enable RX timer counter and set roll over on RX buffer swap
      #define RX_TIM_RLVR      (0)   //set roll over on TX buffer swap
      #define RX_TIM_ENB      (1) //Enable TX timer counter
      #define RX_TIM_START   (1) //Start timer at the first rollover

      WriteCoreReg(CRI_RX_TIMER_CTL_ADDR, (RX_TIM_RLVR<<21)|(RX_TIM_ENB<<20)|(RX_TIM_START<<28));

      //Configure the transmit timeslot settings
      {

         #define TX_QTP_TS_PORT0_8K   (0)
         #define TX_PMS_TS_PORT0_8K   (0)
         #define TX_QT_TS_PORT0_8K   (1)
         #define TX_IFFT_TS_PORT0_8K   (0x1F)   //inactive
         #define TX_PAR_TS_PORT0_8K   (0x1F)   //inactive
         #define TX_DSP_TS_PORT0_8K   (0)

         WriteCoreReg(CRI_TX_TSLOTC_A_ADDR, (TX_QTP_TS_PORT0_8K    |(TX_PMS_TS_PORT0_8K<<5)|
                                             (TX_QT_TS_PORT0_8K<<10)|(TX_IFFT_TS_PORT0_8K<<15)|
                                             (TX_PAR_TS_PORT0_8K<<20)|(TX_DSP_TS_PORT0_8K<<25)));
      }

      //Configure the receive timeslot settings
      {

         #define RX_QTP_TS_PORT0_8K   (0)
         #define RX_FFT_TS_PORT0_8K   (0x1F)   //inactive
         #define RX_QT_TS_PORT0_8K   (1)
         #define RX_PMS_TS_PORT0_8K   (0)
         #define RX_DSP_TS_PORT0_8K   (0)

         WriteCoreReg(CRI_RX_TSLOTC_A_ADDR, ((RX_QTP_TS_PORT0_8K<<0)|(RX_FFT_TS_PORT0_8K<<5)|
                                             (RX_QT_TS_PORT0_8K<<10)|(RX_PMS_TS_PORT0_8K<<15)|
                                             (RX_DSP_TS_PORT0_8K<<25)));
      }

      //Set the core start time for 8 khz frame rate
      ul_NumClocksPerTimeSlot = CRI_TSC_CTRL_NUM_CLKS-1;

      gl_TxFcTimerCount = CRI_TX_PMS_GO_CNT_8K;
      gl_TxQtpTimerCount = CRI_TX_QTP_GO_CNT_8K;
      gus_TxQtTimerCount = CRI_TX_QT_GO_CNT_8K;

      gs_RxFcTimerCount = CRI_RX_PMS_GO_CNT_8K;
      gs_RxQtpTimerCount = CRI_RX_QTP_GO_CNT_8K ;
      gs_RxQtTimerCount = CRI_RX_QT_GO_CNT_8K;

      //Note: in FDCONN, the time slot duration is configured much shorter
      //to speed up the test so we set the clock count differently

      //Configure TX PMS
      //It has been disabled in InitCRI() and will be enabled (and configured) EnableTxPms() later;

      //Configure TX QTP to tx time-slot start
      //TX_QTP_REG_START = 0
      //TX_QTP_START_SEL = 4
      //TX_QTP_GO_CNT = CRI_TX_QTP_GO_CNT_8K
      WriteCoreReg(CRI_TX_QTP_CTL_ADDR, (gl_TxQtpTimerCount | TX_TSC_START_TX_QTP_SEL));

      //Configure TX QT to tx time-slot start
      //TX_QT_REG_START = 0
      //TX_QT_START_SEL = 4
      //TX_QT_GO_CNT = CRI_TX_QT_GO_CNT_8K
      WriteCoreReg(CRI_TX_QT_CTL_ADDR, (gus_TxQtTimerCount | TX_TSC_START_TX_QT_SEL));

      //Program IFFT to be triggered by timer-based method
      //TX_IFFT_REG_START = 0
      //TX_IFFT_START_SEL = 2 (timer-based)
      //TX_IFFT_GO_CNT = Predefined timer
      if(gs_CRI_DbgCntl & CRI_DBG_CNTL_DISABLE_IFFT)
      {
         WriteCoreReg(CRI_TX_IFFT_CTL_ADDR, 0);
      }
      else
      {
         WriteCoreReg(CRI_TX_IFFT_CTL_ADDR, (uint32)(TX_TIMER_START_TX_IFFT_SEL|TX_IFFT_START_TIMER_8K));
      }

      //Program FFT to be triggered by the RX buffer-swap
      if(gs_CRI_DbgCntl & CRI_DBG_CNTL_DISABLE_FFT)
      {
         //Configure RX FFT to disabled
         WriteCoreReg(CRI_RX_FFT_CTL_ADDR, 0);
      }
      else
      {
         //Configure RX FFT to rx buffer swap
         WriteCoreReg(CRI_RX_FFT_CTL_ADDR, RX_BUFFER_SWAP_START_RX_FFT_SEL);
      }

      //Configure RX QT to rx time-slot start
      //RX_QT_REG_START = 0
      //RX_QT_START_SEL = 4
      //RX_QT_GO_CNT = CRI_RX_QT_GO_CNT_8K
      if(gs_CRI_DbgCntl & CRI_DBG_CNTL_DISABLE_RXQT)
      {
         WriteCoreReg(CRI_RX_QT_CTL_ADDR, 0);
      }
      else
      {
         WriteCoreReg(CRI_RX_QT_CTL_ADDR, (gs_RxQtTimerCount | RX_TSC_START_RX_QT_SEL));
      }

      //Configure RX QTP to rx time-slot start
      //RX_QTP_REG_START = 0
      //RX_QTP_START_SEL = 4
      //RX_QTP_GO_CNT = CRI_RX_QTP_GO_CNT_8K
      WriteCoreReg(CRI_RX_QTP_CTL_ADDR, (gs_RxQtpTimerCount | RX_TSC_START_RX_QTP_SEL));

      //Configure RX PMS
      //It is disabled in InitCRI() and will be enabled (and configured) in EnableRxPms() later

      //First reset QT stall registers to the power-on state
      WriteCoreReg(CRI_TX_QT_STALL_ADDR, 0xE0000);
      WriteCoreReg(CRI_RX_QT_STALL_ADDR, 0xE0000);

      //Configure QT_STALL register and enable it

      #define QT_STALL_ENA   (1) //enable QT stall
      WriteCoreReg(CRI_TX_QT_STALL_ADDR, ((CRI_TX_QT_STALL_CLKS_8K)|(QT_STALL_ENA<<16)));
      WriteCoreReg(CRI_RX_QT_STALL_ADDR, ((CRI_RX_QT_STALL_CLKS_8K)|(QT_STALL_ENA<<16)));

      //By doing this, clear CRI_TSC_STATUS_ADDR register
      //(Note: this reset must be done, otherwise the 30a fdconn COCOMO test won't work)
      ResetCoreReg(CRI_TSC_CTRL_ADDR, (CRI_TSC_CTRL_ENABLE<<31));

      //Reconfigure the time slot control (2 slots per frame)
      ul_data = (CRI_TSC_CTRL_NUM_TS_8K)|(ul_NumClocksPerTimeSlot<<5)|(CRI_TSC_CTRL_CLKS_LAST<<22)|
                (CRI_TSC_CTRL_ENABLE<<31);
      WriteCoreReg(CRI_TSC_CTRL_ADDR, ul_data);
   }
} //Reconfig_CRI()








