/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2005 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: ResetPRBS.c
*
*   This file contains engine interface functions to used during showtime.
*
*-------------------------------------------------------------------------------
*/
#include <string.h>
#include "common.h"
#include "gdata.h"
#include "IRI_Iof.h"
#include "LL_IOf.h"
#include "cri_iof.h"
#include "alp_memmap.h"
#include "cri_memmap.h"
#include "ft_memmap.h"
#include "qt_memmap.h"
#include "qtp_memmap.h"

#include "zep_ilv_memmap.h"
#include "zep_memmap.h"
#include "show_iof.h"
#include "OvhdMsg_IOf.h"
#include "cmv.h"
#include "profile.h"


/*
*-------------------------------------------------------------------------------
*
*   Prototype: EnableTxResetPRBS(void)
*              EnableRxResetPRBS(void)
*
*   These functions set the TX or RX PRBS generator in reset mode.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/
void EnableTxResetPRBS(void)
{

   WriteCoreReg(IRI_QT_REG_TX_PRBS_ADDR, (uint32)0x7FF); // initial PRBS LFSR state.
   WriteCoreReg(IRI_QTP_REG_TX_PRBS_ADDR, (uint32)0x7FF); // initial PRBS LFSR state.

   SetCoreReg(IRI_QT_REG_TX_PRBS_MISC_ADDR, (0x1 << 11)); //enable reset mode
   SetCoreReg(IRI_QTP_REG_TX_PRBS_MISC_ADDR, (0x1 << 11)); //enable reset mode in QTP
}

void EnableRxResetPRBS(void)
{
   WriteCoreReg(IRI_QTP_REG_RX_PRBS_ADDR, (uint32)0x7FF); // Initial Rx PRBS state generator state
   SetCoreReg(IRI_QTP_REG_RX_PRBS_MISC_ADDR, (MASK_BIT10 )); //enable reset mode in QTP core
}
