/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2005 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *-------------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   filename: RxDataPumpSetUp.c
 *
 *   This file contains engine interface functions to initialize cores
 *   for showtime RX path operations.
 *
 *-------------------------------------------------------------------------------
 */
//********************************************************************************
// 05/02/2014 Anantha Ramu : Reset the LCD & NCD failure bits before going to showtime.
//                          Grep for XDSLRTFW-1544
//********************************************************************************
#include <string.h>
#include "common.h"
#include "gdata.h"
#include "dsp_op.h"
#include "RxDataPumpSetUp.h"
#include "LL_IOf.h"
#include "alp_memmap.h"
#include "qt_memmap.h"
#include "qtp_memmap.h"
#include "zep_ilv_memmap.h"
#include "zep_memmap.h"
#include "mul.h"
#include "CustomerTasks.h"
#include "zep_memmap_cnfg.h"
#include "cri_memmap.h"
//XDSLRTFW-1544 (Start)
#include "g997.h"
//XDSLRTFW-1544 (End)

#ifdef PPE_ENGINE
#include "ppe_memmap.h"
#endif


void LoadRxZepMicroCode(void);

/*
 *-------------------------------------------------------------------------------
 *
 *   Prototype: void RxDataPumpSetUp(void)
 *
 *   This function initializes cores for showtime RX path operations.
 *
 *   Input Arguments:
 *
 *   Output Arguments:
 *
 *   Returns:
 *
 *   Global Variables:
 *
 *-------------------------------------------------------------------------------
 */

void RxDataPumpSetUp(void)
{
   // initialize cores one by one
   // make sure each core initialization is within MIPS budget for TC task
   switch (guc_RxDataPumpState)
   {

   case RX_CONFIG_TPS_ALP:


#ifdef PPE_ENGINE
      // Configure PPE interface registers
      ConfigurePPERxPath();
#endif //PPE_ENGINE

      guc_RxDataPumpState = RX_CONFIG_PMS_ZEP_FC;
      break;

   case RX_CONFIG_PMS_ZEP_FC:


      ConfigZephyrFcRxPath_VDSL2();
      guc_RxDataPumpState = RX_ZEP_FC_LOADING_LP0_UCODE;

      if(gft_EnableNTR)
      {
         ConfigureNtrHw();
      }
      break;

   case RX_ZEP_FC_LOADING_LP0_UCODE:
   case RX_ZEP_FC_WAIT_FOR_LP0_UCODE:
   case RX_ZEP_FC_LOADING_LP1_UCODE:
   case RX_ZEP_FC_WAIT_FOR_LP1_UCODE:
      LoadRxZepMicroCode();               // this function will step thru these 3 substates
      break;

   case RX_ZEP_FC_LOADING_UCODE_DONE:
      guc_RxDataPumpState = RX_CONFIG_PMS_ZEP_ILV;
      break;

   case RX_CONFIG_PMS_ZEP_ILV:

      ConfigZephyrIlvRxPath_VDSL2();

      guc_RxDataPumpState = RX_CONFIG_PMD_IRI_QT;
      break;

   case RX_CONFIG_PMD_IRI_QT:
      ConfigIridiaQtRxPath();
      guc_RxDataPumpState = RX_CONFIG_CORE_DONE;
      break;
   }
}


/*
 *-------------------------------------------------------------------------------
 *
 *   Prototype: void ConfigIridiaQtRxPath(void)
 *
 *   This function initializes Iridia-QT core for showtime RX path operations.
 *
 *   Input Arguments:
 *
 *   Output Arguments:
 *
 *   Returns:
 *
 *   Global Variables:
 *
 *-------------------------------------------------------------------------------
 */

void ConfigIridiaQtRxPath(void)
{
   uint32 ul_data;

   //=========== Configure QT registers ============================
   gs_RxAbgtOffset = (gl_Active_BGTN_Size>>2) - (gs_RxMaxTone + 1);
   WriteCoreReg(IRI_QT_REG_ABGT_OFFSET_ADDR, (uint32)(gs_RxAbgtOffset<<16));

   // IR_CONFIG

   // IR_TCM_CTRL
   ul_data = (uint32)(gus_Rx_Tcm_Num1bits >> 1) << 13;   //no. of 1-bit tone pairs
   ul_data |= (uint32)gus_Rx_1Bit_Index;               //index in TOT of the first 1 bit tone

   //Trellis decoder (RTE bit) will be enabled at the showtime start
   WriteCoreReg((uint32)IRI_QT_REG_RX_TCM_CTRL_ADDR, ul_data);

   // IR_MISC
   // set in initialization, modified right before showtime in StartRxDataPath()
   WriteCoreReg(IRI_QT_REG_RX_LP0_BITS_ADDR, gt_rx_config_v2.ul_Lp[LP0]);
   WriteCoreReg(IRI_QT_REG_RX_LP1_BITS_ADDR, gt_rx_config_v2.ul_Lp[LP1]);


   // IR_LP2_BITS
   if (gt_ReTXParams.uc_UsReTxStatus == US_RETX_IN_USE)
   {
      WriteCoreReg(IRI_QT_REG_RX_LP2_BITS_ADDR, US_RRC_BITS); //US_RRC_BITS=(US_RRC_BYTES*8), US_RRC_BYTES=3
   }
   else
   {
      WriteCoreReg(IRI_QT_REG_RX_LP2_BITS_ADDR, 0);
   }

   // IR_DUMMY
   WriteCoreReg(IRI_QT_REG_RX_DUMMY_ADDR, 0);

   // IR_LP0_BIT_FIFO
   WriteCoreReg(IRI_QT_REG_RX_LP0_BIT_FIFO_ADDR, 0);

   // IR_LP1_BIT_FIFO
   WriteCoreReg(IRI_QT_REG_RX_LP1_BIT_FIFO_ADDR, 0);

   // IR_LP2_BIT_FIFO
   WriteCoreReg(IRI_QT_REG_RX_LP2_BIT_FIFO_ADDR, 0);

   // IR_DEROT_MISC
   // IR_DEROT_POLY
   // IR_PRBS_MISC
   // IR_FD_RNG0
   // IR_FD_RNG1
   // IR_FD_RNG1_BASE
   // IR_NPR_IIBRAM
   // IR_QUAD0
   // IR_QUAD1
   // IR_SLOWDOWN
   // IR_PTINDEX
   // IR_PILOT
   // IR_FDQADAPT
   // IR_VECTOR_L
   // IR_VECTOR_H
   // IR_REMETRIC_CTL

   // XDSLRTFW-3111 START
   // Create a normalized version of Erasure/Viterbi metric by calculating the shift value according to the Maximum QT Score

   //calculate the number of trellis tone pairs contributing to the trellis metric
   //first: calculate the loaded carriers with more than 1 bit. Division by two to have pairs of tones
   gul_CntrTrellisTonePairs = (gus_ncloaded-gus_Rx_Tcm_Num1bits)>>1;
   //second: add the tone pairs of 1 bit tones (treat 2 1-bit tones, as one multi-pit tone), then build tone pairs again
   gul_CntrTrellisTonePairs+= gus_Rx_Tcm_Num1bits>>2;
   gul_MaxQtScore=(gul_CntrTrellisTonePairs<<8) - (gul_CntrTrellisTonePairs<<1);

   // Set the treshold in a way that it detects early enough Impulse noises on the line, but does not stall PLL when we go to 0dB margin due to external noise increase
   // A test series showed these typical Erasure metric values (see XDSLRTFW-3111 for more details)
   // Margin            | Erasure Score White Noise   |
   //   6dB             |   ~150                      |
   //   3dB             |   ~120                      |
   //   0dB             |   ~60                       |
   // Shine impulses    |  ~16-28     on short loop   |
   // Shine impulses    |  ~0-10      on long loop    |
   guc_EdMetricThresholdDuringExtNoise = 50;
   if (gt_Kl0ElectricalLength.s_kl0_estimate > 100)  // if loop is >~300 meters
   {
      // on long loops we can't bee as agressive in the noise detection as on short loops. The metric value is jittering much mor on longer loops for SNR margin ~0dB
      guc_EdMetricThresholdDuringExtNoise = 20;
   }

   // Re-map the symbol score to 8-bit value
   // for this we need to find the MSB of maxcumscore
   guc_msb = (uint8)(31 - norm_l(gul_MaxQtScore));

    // program the lsb of the 8-bit value to be extracted from the accumulated "msb-bit" score, to take the uppermost 8 bits
   gus_rmetric_scale=   ((guc_msb-8) & 0xF);

   WriteCoreReg (IRI_QT_REG_RX_RMETRIC_CTL_ADDR,  (uint32)((1<<4)|gus_rmetric_scale));

   // XDSLRTFW-3111 END

   // IR_REMETRIC_VAL
   // IR_RXCG_x, x=0, 1, ..., 15

   //Mei fixme: need to revisit
   // write MFDQ tone table based on logical tone order
   // and fine gain/constellation gain adjusted MFDQ coefficients

   // IR_ACT_ADDR
   ul_data = ((uint32)gs_RxMinTone) | ((uint32)gs_RxMaxTone << 16);
   WriteCoreReg(IRI_QT_REG_RX_ACTIVE_ADDR, ul_data);

   //=========== Configure QTP registers ============================

   // QTP_RXTC_TOT_AD
   // Set the inactive TOT table range to be copied to the active BGT table
   // Inactive RX TRT lies at the beginning of Inactive TRT
      ul_data = (0) | (uint32) (gs_RxMaxTone << 13);
   WriteCoreReg(IRI_QTP_REG_RXTC_TOT_ADDR, ul_data);

   // QTP_RXTC_ACT_AD
   // Set min and max tone range in active table when the inactive table are copied to
   WriteCoreReg(IRI_QTP_REG_RXTC_ACTIVE_ADDR, ul_data);

  //QTP_RXTC_CTRL
   ul_data = (uint32) ((gs_Tblcpy_Num0bit[RX] << 19)|
             (gs_Tblcpy_NumGT1bit[RX] << 6) |
             (0 << 5) | //enable TOT during the table copying
             (0 << 2) | //table segment to copy: 0
             (0 << 1) | //disable 1 bit ordering
             (0 << 0)); //copy from inactive to active

   // enable 1 bit ordering if TCM is enabled
   if (gft_RxTcmFlag)
   {
      ul_data |= (1<<1);
   }

   //QTP_RXTC_CTRL
   WriteCoreReg(IRI_QTP_REG_RXTC_CTRL_ADDR, ul_data);


}

/*
 *-------------------------------------------------------------------------------
 *
 *   Prototype: void ClearRxZephyrRegs(void)
 *
 *   This function initializes clears all RX Zephyr registers
 *
 *   Input Arguments:
 *
 *   Output Arguments:
 *
 *   Returns:
 *
 *   Global Variables:
 *
 *-------------------------------------------------------------------------------
 */
void ClearRxZephyrRegs(void)
{
   //zero out pram before RxDataPumpSetup.
   FillCoreBuf32(ZEP_PRAM_RX_LP0_START_ADDR, 0, ZEP_REG_RX_PRAM_SIZE);
   FillCoreBuf32(ZEP_PRAM_RX_LP1_START_ADDR, 0, ZEP_REG_RX_PRAM_SIZE);
}


/*
 *-------------------------------------------------------------------------------
 *
 *   Prototype: void ConfigurePPERxPath(void)
 *
 *   This function initializes PPE engine for showtime RX path operations.
 *
 *   Input Arguments:
 *
 *   Output Arguments:
 *
 *   Returns:
 *
 *   Global Variables:
 *
 *      guc_PortMode -- (I)
 *      gula_DREG_AR_CFG_Cnfg[] -- (I)
 *      gft_TcTypeSelected -- (I)
 *-------------------------------------------------------------------------------
 */


#ifdef PPE_ENGINE

//Define for Ax_CFG REGISTER.
#define PPE_EFM_MODE (3<<5)
#define PPE_BYTE_FLIP_DISABLE (2)

void ConfigurePPERxPath(void)
{
   uint32 ul_data;
   uint32 ul_addr=0;
   uint8 uc_bc, uc_offset;
   G997_AtmFailure_t *pt_AF;
   pt_AF = &gt_g997_AtmFailure_NE;
   //XDSLRTFW-521 NewFeatures_ALL_ALL_ALL_ATMVDSL2
   for (uc_bc=0; uc_bc<2; uc_bc++) //Need to clear Paths not used
   {
      uc_offset = (uc_bc + guc_ch_id)<<2;

      //DREG_AR_CFG
      if(gt_rx_TPS_Map.s_BCtoTPS[uc_bc] != 0)
      {
         //Configure DREG_AR_CFG0
         ul_data = gula_DREG_AR_CFG_Cnfg[uc_bc];


         if(gft_TcTypeSelected == TPS_TC_TYPE_PTM)
         {
            //If EFM preemption is supported, set the corresponding bit in this register
            if(gta_DsBearerChanAct[uc_bc].ta_TpsTcType.uc_TPSTCoptions & TPS_TC_OPTION_PREEMPT)
            {
               ul_data |= (1<<7);
            }

            //If EFM short packets are supported, set the corresponding bit in this register
            if(gta_DsBearerChanAct[uc_bc].ta_TpsTcType.uc_TPSTCoptions & TPS_TC_OPTION_SHORTPACKET)
            {
               ul_data |= (1<<8);
            }

            //Set the RX TC mode to EFM TC mode, with Byte flip disabled.
            ul_data |= (PPE_EFM_MODE | PPE_BYTE_FLIP_DISABLE );
            //XDSLRTFW-1544 (Start)
            pt_AF->t_LCD[0].us_FailureBitNumber &= ~LCD_LP0_FAILURE_BIT;
            pt_AF->t_NCD[0].us_FailureBitNumber &= ~NCD_LP0_FAILURE_BIT;
            //XDSLRTFW-1544 (End)

         }

         //According to VDSL2 AnnexK, we need to do the following for ATM-TC
         if(gft_TcTypeSelected == TPS_TC_TYPE_ATM)
         {
            //Enable byte flip (setting bit 1 to 0

            //Enable scrambling
            ul_data |= (1<<2);
         }

         WritePpeReg((DREG_AR_CFG0_ADDR + uc_offset), ul_data);

         //DREG_AR_IDLE
         if(gft_TcTypeSelected == TPS_TC_TYPE_ATM)
         {
            ul_data = 0x6A;
         }
         else
         {
            ul_data = 0;
         }
         WritePpeReg((DREG_AR_IDLE0_ADDR + uc_offset), ul_data);

         //DREG_AR_DELIN
         ul_data = (CELL_DELIN_DELTA & 0xF) | ((CELL_DELIN_ALPHA & 0xF) <<4);
         WritePpeReg((DREG_AR_DELIN0_ADDR + uc_offset), ul_data);
         //XDSLRTFW-542: Platform_VRX318 (START)
         //VRX318 doesn't support onchip binding and it support only offchip bonding.
         //Hence BC0 only will be used for given line. Indicate the same to PPE.
         if (uc_bc == 0)
         {
            // Set Bit 2 of DREG0 to inform PPE that bearer channel is "ON". We have only BC0, hence it is implies BC0 is on.
            // Please refer the document "PPE DSL Notifications" for more information.
            // Bit defintion of DREG registers:
            // 0x7DC0 (DREG_MISCRAM0_ADDR)
            //  Bit 0      --> Set by DSL FW when both Tx and Rx enter showtime and cleared by DSL FW when showtime is left
            //  Bit 1      --> Set by DSL FW on first Rx showtime
            //  Bit 2      --> To indicate whether BEARER_CHANNEL is ON or OFF
            ul_addr = DREG_MISCRAM0_ADDR;
            ReadPpeReg(ul_addr, &ul_data);
            ul_data |=MASK_BIT2;
            WritePpeReg(ul_addr, ul_data);
         }
         //XDSLRTFW-542: Platform_VRX318 (END)
      } //if(gt_rx_TPS_Map.s_BCtoTPS[uc_bc] != 0)
      else
      {
         //Clear all registers
         WritePpeReg((DREG_AR_CFG0_ADDR + uc_offset), 0);
         WritePpeReg((DREG_AR_IDLE0_ADDR + uc_offset), 0);
         WritePpeReg((DREG_AR_DELIN0_ADDR + uc_offset), 0);
      } //if(gt_rx_TPS_Map.s_BCtoTPS[uc_bc] != 0) else

      //DREG_AR_STAT
      WritePpeReg((DREG_AR_STAT0_ADDR + uc_offset), 0);

      //Read PPE counter registers and initiate shadow global variables
      ReadPpeReg((DREG_AR_CELL0_ADDR + uc_offset), &ul_data);
      gula_DREG_AR_CELL_Shadow[uc_bc] = ul_data;

      ReadPpeReg((DREG_AR_IDLE_CNT0_ADDR + uc_offset), &ul_data);
      gula_DREG_AR_IDLE_CNT_Shadow[uc_bc] = ul_data;

      ReadPpeReg((DREG_AR_AIIDLE_CNT0_ADDR + uc_offset), &ul_data);
      gula_DREG_AR_AIIDLE_CNT_Shadow[uc_bc] = ul_data;

      ReadCoreReg((DREG_AR_BE_CNT0_ADDR + uc_offset), &ul_data);
      gula_DREG_AR_BE_CNT_Shadow[uc_bc] = ul_data;

      ReadPpeReg((DREG_AR_HEC_CNT0_ADDR + uc_offset), &ul_data);
      gula_DREG_AR_HEC_CNT_Shadow[uc_bc] = ul_data;

      ReadPpeReg((DREG_AR_CD_CNT0_ADDR + uc_offset), &ul_data);
      gula_DREG_AR_CD_CNT_Shadow[uc_bc] = ul_data;

      ReadPpeReg((DREG_AR_OVDROP_CNT0_ADDR + uc_offset), &ul_data);
      gula_DREG_AR_OVDROP_CNT_Shadow[uc_bc] = ul_data;

      ReadPpeReg((DREG_AR_CERRN_CNT0_ADDR + uc_offset), &ul_data);
      gula_DREG_AR_CERRN_CNT_Shadow[uc_bc] = ul_data;

      ReadPpeReg((DREG_AR_CERRNP_CNT0_ADDR + uc_offset), &ul_data);
      gula_DREG_AR_CERRNP_CNT_Shadow[uc_bc] = ul_data;

      ReadPpeReg((DREG_AR_CVN_CNT0_ADDR + uc_offset), &ul_data);
      gula_DREG_AR_CVN_CNT_Shadow[uc_bc] = ul_data;

      ReadPpeReg((DREG_AR_CVNP_CNT0_ADDR + uc_offset), &ul_data);
      gula_DREG_AR_CVNP_CNT_Shadow[uc_bc] = ul_data;

   } //for (uc_bc=0; uc_bc<(guc_PortMode+1); uc_bc++)

} //ConfigurePPERxPath()

#endif //#ifdef PPE_ENGINE

/*
 *-------------------------------------------------------------------------------
 *
 *   Prototype: Void ConfigureNtrHw(void))
 *
 *   This function enables the NTR block to produce a clock.
 *
 *   Inputs: none
 *   Outputs:  Arguments: None
 *           HW :   CRI_NTR_CPE_CTRL regsiter
 *   Returns: none
 *   Global Variables:
 *
 *   Description:
 *      This sets the NTR clock at a nominal 8KHz frequency and enables the o/p
 *      The NTR SOURCE for output = high speed ~282 Mhz (after NTR_FR is set)
 *      The NTR SOURCE for Phase counter feedback = RX sample clock at FFT ~35/70 MHz.
 *
 *   Limitation: Port for NTR is hardcoded to Port 0. May need flexibility for dual port.
 *-------------------------------------------------------------------------------
 */
#define NTR_CTRL_EN (1<<31)
#define NTR_CTRL_SOURCE_FFT (1<<17)
#define NTR_CTRL_PHASESOURCE_FFT (1<<16)

void ConfigureNtrHw(void)
{
   uint32 ul_regData = 0;

   ul_regData = 0x8a00; // = 282.624 MHz/8khz
   ul_regData |= NTR_CTRL_PHASESOURCE_FFT;

   if (gft_EnableNTR)
   {
      ul_regData |= (NTR_CTRL_EN);
   }

   WriteCoreReg(CRI_NTR_CPE_CTRL_ADDR, ul_regData);
}
