/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2005 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: RxDataPumpSetUp_VDSL2.c
*
*   This file contains engine interface functions to initialize cores
*   for showtime RX path operations.
*
*-------------------------------------------------------------------------------
*/
//RxDataPumpSetUp_VDSL2.c
// History
//
// 29/10/2014 Anantha Ramu: Modifications done for configurations of deinterleaver
//                          for Intra DTU Interleaving.
//                          Grep for "XDSLRTFW-1617"
//
// 26/11/2015 Anantha Ramu: Added modifications for SRA with DS Intra DTU Interleaving.
//                          Grep for "XDSLRTFW-2162".
//
// 26/11/2015 Anantha Ramu: Added modifications for SRA with US Intra DTU Interleaving.
//                           Grep for "XDSLRTFW-2341".
//
// 10/10/2018 Sriram Shastry : VDSL,errors in datapath after a SRA downshift
//     It  has been observed during SRA calculated de-interleaver memory  size in training is exceeded
//     in show-time. Re-computation framing parameter i.e. Lp (Np) gets changed,it can result in higher dilv memory size
//     than computed during training phase[gul_RtxQBaseAddr = gula_rxILVBaseAddr[LP1] + ul_dilv_size].As a result of
//     memory corruption packet drops is seen in Traffic test.
// Grep for XDSLRTFW-3948
//********************************************************************************************
#include "common.h"
#include "gdata.h"
#include "RxDataPumpSetUp.h"
#include "LL_IOf.h"
#include "qt_memmap.h"
#include "zep_ilv_memmap.h"
#include "zep_memmap.h"
#include "zep_memmap_cnfg.h"
#include "mul.h"
#include "showtime.h"
#include "vdsl_state.h"
#include "cmv.h"
#include "cmv_Data.h"
#include "ppe_memmap.h"

#include "zep_memmap_cnfg.h"
extern RRC_Stat_t gt_RrcStat;
extern ReTX_Params_t gt_ReTXParams;
extern QretxTableEntry_t gta_QretxTable[];

extern uint32 gul_dbg_Zephyr[20];

uint16 Find_Pmd_Step(uint16 s_D, uint16 s_I);
void LoadRxZepMicroCode(void);

//XDSLRTFW-2577 (Start)
void SetUpDMATransfer(uint32 SourceAddr, uint32 SourceEnd, uint32 DestAddr,
                      uint32 ul_DspAdmaCtrl_FillMask, int32 ul_FillValue,
                      uint16 us_WaitForDMAComplete);
//XDSLRTFW-2577 (End)

/*
*-------------------------------------------------------------------------------
*
*   Prototype: void ConfigZephyrFcRxPath_VDSL2(void)
*
*   This function initializes Zephyr-FC core for showtime RX path operations.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/
void ConfigZephyrFcRxPath_VDSL2(void)
{
   int16 s_lp;
   int16 s_lpInit = LP1;               // In showtime, ReTx updates only LP1.
   uint32 ul_data, ul_addr, ul_RegBaseAddr;
   VDSL2Config_t *pt_Config;
   ReTX_Params_t *pt_ReTXParams;
   //XDSLRTFW-1209: BugFix_DS_VDSL2_ALL_PacketLoss_In_ReTX_Mode (Start_End)
   //uint32 ul_Temp;
   uint16 us_PPE_INPUT_MAX;


   // map the RX parameter structure
   pt_Config = &gt_rx_config_v2;
   pt_ReTXParams = &gt_ReTXParams;

   if(gs_RxState != R_O_SHOWTIME_RX) // Training
   {
      // Use FIFO3 to capture the output data from the DeScrambler
      ul_data = ZEP_RAM_RX_OHFIFO3_DBG1_OFFSET;
      ul_data |= (ZEP_RAM_RX_OHFIFO3_DBG1_SIZE-1) << ZEP_REG_ZR_FIFO_SIZEX_POS;
      WriteCoreReg(ZEP_PRAM_ZR_FIFO_BASE3_LP0_ADDR, ul_data);

      WriteCoreReg(ZEP_PRAM_ZR_FIFO_PTRS3_LP0_ADDR, 0);
      WriteCoreReg(ZEP_PRAM_ZR_FIFO_CNST3_LP0_ADDR, 0);

      // all RX registers are cleared in ClearRxZephyrRegs()

      ///////////////////////////////////////////////////////////
      // GLOBAL REGISTERS INITIALIZATION START                 //
      // Note: all unconfigured registers are initialized to 0 //
      ///////////////////////////////////////////////////////////
      //XDSLRTFW-3756 (START)
      ul_data = 0;
      WriteCoreReg(ZEP_REG_ZR_QTDTB_ADDR_LP01_ADDR, ul_data);
      WriteCoreReg(ZEP_REG_ZR_QTDTB_ADDR_LP2_ADDR, ul_data);
      //XDSLRTFW-3756 (END)

      ///////////////////////////////////////////
      //Per Port Registers

      // ZEP_REG_ZR_CONFIG_ADDR
      WriteCoreReg(ZEP_REG_ZR_CONFIG_ADDR, ZEP_PRAM_RX_START_ADDR/4); //Longword address
      ul_addr = ZEP_RAM_IIBRAM_ADDR + ZEP_PRAM_RX_START_ADDR;

      if(pt_Config->ul_Lp[LP1] == 0)
      {
         WriteCoreReg(ul_addr, 1);   //Number of LP
      }
      else
      {
         WriteCoreReg(ul_addr, 2);   //Number of LP
      }

      ul_addr += 4;
      WriteCoreReg(ul_addr, ZEP_RX_CFG_LP0_PTR/4);

      ul_addr += 4;
      WriteCoreReg(ul_addr, ZEP_RX_CFG_LP1_PTR/4);

      s_lpInit = LP0;                    // In Training, ReTx updates for all LP.
   }

#if 1
   gul_dbg_Zephyr[0] = ZEP_PRAM_RX_LP0_START_ADDR;
   gul_dbg_Zephyr[1] = ZEP_PRAM_RX_LP1_START_ADDR;
   gul_dbg_Zephyr[2] = ZEP_PRAM_TX_LP0_START_ADDR;
   gul_dbg_Zephyr[3] = ZEP_PRAM_TX_LP1_START_ADDR;
   gul_dbg_Zephyr[4] = ZEP_REG_RX_PRAM_SIZE;
   gul_dbg_Zephyr[5] = ZEP_REG_TX_PRAM_SIZE;
   gul_dbg_Zephyr[6] = 0xAAAA;
   gul_dbg_Zephyr[7] = 0xBBBB;
   gul_dbg_Zephyr[8] = ZEP_RX_CFG_LP0_PTR;
   gul_dbg_Zephyr[9] = ZEP_RX_CFG_LP1_PTR;
   gul_dbg_Zephyr[10] = ZEP_TX_CFG_LP0_PTR;
   gul_dbg_Zephyr[11] = ZEP_TX_CFG_LP1_PTR;

   //gft_PauseOff = 0;
   //Pause(0x1234);
#endif

   ///////////////////////////////////////////
   // PER LP REGISTERS INITIALIZATION START //
   ///////////////////////////////////////////
   for(s_lp = s_lpInit; s_lp < NUM_DATA_PATHS; s_lp++)
   {
      if(s_lp == LP0)
      {
         ul_RegBaseAddr = ZEP_PRAM_RX_LP0_START_ADDR;
      }
      else //(s_lp == LP1)
      {
         ul_RegBaseAddr = ZEP_PRAM_RX_LP1_START_ADDR;
      }

      // ZEP_PRAM_ZR_CODEWORD_LPx_ADDR
      ul_data = (uint32)pt_Config->s_Mp[s_lp] << 24; //31:24 SYM_CW
      ul_data |= (uint32)pt_Config->s_Rp[s_lp] << 16; //23:16 CB_Size
      ul_data |= (uint32)(pt_Config->s_Nfecp[s_lp] - pt_Config->s_Rp[s_lp]) << 8; //15:8 KP_Val
      ul_data |= (uint32)pt_Config->s_Nfecp[s_lp]; //7:0 CW_Size

      ul_addr = ul_RegBaseAddr + ZR_CODEWORD_OFFSET;

      WriteCoreReg(ul_addr, ul_data);

      // ZEP_PRAM_ZR_VBC_SIZE_LPx_ADDR
      if (gt_rx_TPS_Map.s_BCtoLP[BC0] == s_lp)
      {
         ul_data = (uint32)pt_Config->sa_Bpn[s_lp][BC0];   //15:0 BC0_Bytes
      }
      else
      {
         ul_data = 0;
      }
      if (gt_rx_TPS_Map.s_BCtoLP[BC1] == s_lp)
      {
         ul_data |= (uint32)pt_Config->sa_Bpn[s_lp][BC1] << 16;   //31:16 BC1_Bytes
      }

      ul_addr = ul_RegBaseAddr + ZR_VBC_SIZE_OFFSET;
      WriteCoreReg(ul_addr, ul_data);

      // ZEP_PRAM_ZR_FRAMING_LPx_ADDR
      ul_data = (uint32)pt_Config->s_OHSWITCHp[s_lp] << 24; //31:24 Rx_OHSwitch
      ul_data |= (uint32)pt_Config->s_Tp[s_lp] << 16; //23:16 TP_Val
      ul_data |= pt_Config->s_SEQp[s_lp]; //15:0 Max_Frm_Idx -- (1 based, no need to minus 1)

      ul_addr = ul_RegBaseAddr + ZR_FRAMING_OFFSET;
      WriteCoreReg(ul_addr, ul_data);

      // ZEP_PRAM_ZR_OHRATE_LPx_ADDR
      ul_data = (uint32)(MAX(pt_Config->s_OHRate1p[s_lp], pt_Config->s_OHRate2p[s_lp])) << 16; //31:16 Max_OH
      ul_data |= (uint32)pt_Config->s_OHRate2p[s_lp] << 8; //15:8 Rx_OH2Rate
      ul_data |= (uint32)pt_Config->s_OHRate1p[s_lp]; //7:0 Rx_OH1Rate

      ul_addr = ul_RegBaseAddr + ZR_OHRATE_OFFSET;
      WriteCoreReg(ul_addr, ul_data);

      // ZEP_PRAM_ZR_CRC_POLY0_LPx_ADDR
      ul_addr = ul_RegBaseAddr + ZR_CRC_POLY0_OFFSET;
      WriteCoreReg(ul_addr, 0x8e); //x^8 + x^4 + x^3 + x^2 + x^0

      if(gs_RxState != R_O_SHOWTIME_RX) // Training
      {
         // ZEP_PRAM_ZR_SCR_POLY_LPx_ADDR
         if(gul_dbgShowtimeControl & DISABLE_ZEP_RX_SCRAMBLE)
         {
            ul_data = 0;
         }
         else
         {
            ul_data = 0x00420000;
         }

         ul_addr = ul_RegBaseAddr + ZR_SCR_POLY_OFFSET;
         WriteCoreReg(ul_addr, ul_data); //Polynomial has degrees 23 and 18

         // ZEP_PRAM_ZR_SCR_CTRL_LPx_ADDR
         ul_addr = ul_RegBaseAddr + ZR_SCR_CTRL_OFFSET;
         WriteCoreReg(ul_addr, 31); //4:0 SCR_Len

         // ZEP_PRAM_ZR_FIFO_BASE0_LPx_ADDR
         if(s_lp == LP0)
         {
            ul_data = ZEP_RAM_RX_LP0_OHFIFO0_OFFSET;   //17:0 FIFO_Base, the location in IIBRAM as byte address
            ul_data |= (uint32)(ZEP_RAM_OHFIFO_SIZE_64-1) << ZEP_REG_ZR_FIFO_SIZEX_POS;
         }
         else
         {
            ul_data = ZEP_RAM_RX_LP1_OHFIFO0_OFFSET;
            ul_data |= (uint32)(ZEP_RAM_OHFIFO_SIZE_32-1) << ZEP_REG_ZR_FIFO_SIZEX_POS;
         }

         ul_addr = ul_RegBaseAddr + ZR_FIFO_BASE0_OFFSET;
         WriteCoreReg(ul_addr, ul_data);


#define WB_SCORE1 (0)

         // ZEP_PRAM_ZR_WB_SCORE_CTL_LPx_ADDR
         ul_data =  0x4040000;
         if (gft_erasure_on == 0) //erasure off
         {
            ul_data |= 1 << 14; //14 NO_WB_SCORE
            ul_data |= 1 << 12; //12 Bypass_Metric
         }

         ul_addr = ul_RegBaseAddr + ZR_WB_SCORE_CTL_OFFSET;
         WriteCoreReg(ul_addr, ul_data|WB_SCORE1);

         // ZEP_PRAM_ZR_WB_SCORE2_LPx_ADDR
         if (gft_erasure_on == 1) //erasure on
         {
            ul_addr = ul_RegBaseAddr + ZR_WB_SCORE2_OFFSET;
            WriteCoreReg(ul_addr, gs_wb_maxscore);
         }
         else
         {
            //    ul_data = 0x0FFF;
            ul_data = (uint32) (255* pt_Config->s_Rp[s_lp]/2)+1; //(use for HD emulation)

            ul_addr = ul_RegBaseAddr + ZR_WB_SCORE2_OFFSET;
            WriteCoreReg(ul_addr , ul_data);
         }
      } // if(gs_RxState != R_O_SHOWTIME_RX)
   } //for(s_lp = 0; s_lp < NUM_DATA_PATHS; s_lp++)

// Configuring the Zephyr micro engine to compute CRC
   ul_RegBaseAddr = ZEP_PRAM_RX_LP0_START_ADDR;
   if (gft_DSVectoringEnabled== TRUE)
   {
      // 32-bit CRC polynomial
      // Refer section 2.1.2.1 of Zephyr spec to understand  the way how
      // polynomial should be programmed into Zephyr.
      ul_addr = ul_RegBaseAddr + ZR_CRC_POLY1_OFFSET;
      ul_data = 0x82608EDB;//    z^32 + z^26 + z^23 + z^22 + z^16 + z^12 + z^11 + z^10 + z^8 + z^7 + z^5 + z^4 + z^2 + z + 1
      WriteCoreReg(ul_addr,ul_data);

      // CRC Control
      ul_addr = ul_RegBaseAddr + ZR_CRC_CTRL1_OFFSET;
      ul_data = 0x3;
      WriteCoreReg(ul_addr,ul_data);

      // Length of data for which CRC to be computed
      ul_addr = ul_RegBaseAddr + ZR_R4_OFFSET;
      ul_data = 0;
      WriteCoreReg(ul_addr,ul_data);

      // Initialise the state
      ul_addr = ul_RegBaseAddr + ZR_CRC1_OFFSET;
      WriteCoreReg(ul_addr,0xFFFFFFFF);

      // Configure the Read pointer address
      ul_addr = ul_RegBaseAddr + ZR_ILVB_RDPTR_OFFSET;
      ul_data = ZEP_RAM_ERB_RD_PTRS_LW_BASE_ADDR;
      WriteCoreReg(ul_addr, ul_data);
   }
   else
   {
   // Length of data for which CRC to be computed
   // It needs to be set to Zero to prevent Zephyr accessing any other data
   ul_addr = ul_RegBaseAddr + ZR_R4_OFFSET;
   ul_data = 0;
   WriteCoreReg(ul_addr,ul_data);
   }


   if (pt_ReTXParams->uc_OMSG1_DsReTxEnabled == RETX_SELECTED)
   {
      uint8 uc_H, uc_V_plus_2;

      if(gs_RxState != R_O_SHOWTIME_RX) // Training
      {
         //Metric must be bypassed in order for RS error detection to work properly
         ul_data =  0x4041000;
         WriteCoreReg(ZEP_PRAM_ZR_WB_SCORE_CTL_LP1_ADDR, ul_data);
         WriteCoreReg(ZEP_PRAM_ZR_WB_SCORE2_LP1_ADDR, 1);
         //XDSLRTFW-1617 (Start)
//XDSLRTFW-2162 (Start- End)
         if(gft_Intra_DTU_Ilv_DS == TRUE)
         {
            //XDSLRTFW-3493 (Start)
            //"R" is configurable.
            //ul_data =  1530; // =0xFF * R/2 where R =4, The number check bytes used for correction
            ul_data =  255*((pt_Config->s_Rp[LP1] - 4) >> 1); // =0xFF * R/2 where R = 4, The number check bytes used for correction
            //XDSLRTFW-3493 (End)

            //XDSLRTFW-3020 (Start)
            //Configure the Max possible correction to (Rp - 4)/2 in bits <20:16>
            //This change is applicable for intra DTU interleaving only.
            //This change is done after the discussion with SE team (Gert and Dietmar)
            //Note: This change is not taking any additional MIPS of the Zephyr.
            if (((pt_Config->s_Rp[LP1] - 4) >> 1) > 0)
            {
               ul_data |= (((pt_Config->s_Rp[LP1] - 4) >> 1) << 16);
            }
            //XDSLRTFW-3020 (End)
            WriteCoreReg(ZEP_PRAM_ZR_WB_SCORE2_LP1_ADDR, ul_data);


         }
         //XDSLRTFW-1617 (End)
         ReadCoreReg(ZEP_PRAM_ZR_FLAG_CTRL0_LP1_ADDR,&ul_data);
         ul_data &= ~0x0700;
         ul_data |= 0x200;
         WriteCoreReg(ZEP_PRAM_ZR_FLAG_CTRL0_LP1_ADDR,ul_data);
      }
      pt_ReTXParams->uc_ReTX_N = (uint8)pt_Config->s_Nfecp[LP1];
      pt_ReTXParams->uc_ReTX_H = (uint8)(pt_ReTXParams->uc_ReTX_N - pt_Config->s_Rp[LP1]); // K = N - R = H

      // DTUPERframe = 1/(S*Q) = Lp/(8*N*Q)
      // in Q4.4 format = 2*Lp/(N*Q)
      pt_ReTXParams->uc_DtuPerFrame = (pt_Config->ul_Lp[1]<<1)/((uint32)(pt_ReTXParams->uc_ReTX_N*pt_ReTXParams->Un_UcodeReTXParam1.t_Param1.uc_CWsPerDtu_Q));


      uc_H = pt_ReTXParams->uc_ReTX_H;
      uc_V_plus_2 = pt_ReTXParams->Un_UcodeReTXParam1.t_Param1.uc_DtuPaddingSize_V + 2;

      // ZEP_PRAM_ZR_FRAMING_LP1_ADDR
      // for initial bring up, need to do MWB to uc_CWsPerDtu_Q and uc_DtuPaddingSize_V
      pt_ReTXParams->Un_UcodeReTXParam1.t_Param1.uc_1stCWPayloadSize = uc_H - uc_V_plus_2;              // H - V -2
      WriteCoreReg(ZEP_PRAM_ZR_RETX_PARAM1_LP1_ADDR, pt_ReTXParams->Un_UcodeReTXParam1.l_ReTXParam1);


      // ZEP_PRAM_ZR_R12_LP1_ADDR
      pt_ReTXParams->us_DS_ReTx_DtuSize =                                     //Q.H
         pt_ReTXParams->Un_UcodeReTXParam1.t_Param1.uc_CWsPerDtu_Q*uc_H;

      //XDSLRTFW-1393 (Start)
      pt_ReTXParams->ul_DtuPayloadSize = pt_ReTXParams->us_DS_ReTx_DtuSize  - uc_V_plus_2; //Q.H - V - 2

      if(gs_RxState != R_O_SHOWTIME_RX) // Training
      {
         pt_ReTXParams->Un_UcodeReTXParam2.t_Param2.us_DtuPayloadSize = (int16)pt_ReTXParams->ul_DtuPayloadSize;
      }

      gs_DTUSizeDS = pt_ReTXParams->us_DS_ReTx_DtuSize;
      gs_DTUPayloadSizeDS = (int16)pt_ReTXParams->ul_DtuPayloadSize;
      //XDSLRTFW-1417 (Start)
#ifdef ENABLE_RETX_US_DEBUG1

#endif
      //XDSLRTFW-1393 (End)

      gs_DsQTx = pt_ReTXParams->uc_RPMS_Qtx;
      //XDSLRTFW-1571 (Start_End)
      gs_DsQRx = pt_ReTXParams->uc_Qrx;
      //XDSLRTFW-1417 (End)
      //XDSLRTFW-1707_30a_RTX_DsUs (Start)

      //XDSLRTFW-2942 (Start_End)
      us_PPE_INPUT_MAX = gus_PPE_INPUT_MAX; //Computed in FramingGenLp1.c

      //XDSLRTFW-1707_30a_RTX_DsUs (End)
      guc_maxdtuout = us_PPE_INPUT_MAX/(pt_ReTXParams->Un_UcodeReTXParam2.t_Param2.us_DtuPayloadSize);

      //XDSLRTFW-2162 (Start)
      if(gft_Intra_DTU_Ilv_DS == TRUE)
      {
         guc_maxdtuout = us_PPE_INPUT_MAX/((int16)pt_ReTXParams->ul_DtuPayloadSize);
      }
      //XDSLRTFW-2162 (End)

      if (guc_maxdtuout > ILVB_RDPTR_TABLE_SIZE_LW)
      {
         guc_maxdtuout = ILVB_RDPTR_TABLE_SIZE_LW;
      }

      //XDSLRTFW-1393 (Start)
      if(gs_RxState != R_O_SHOWTIME_RX) // Training
      {
         pt_ReTXParams->Un_UcodeReTXParam2.t_Param2.uc_DtusToForward_XDTU = 0;
         //XDSLRTFW-1571 (Start_End)
         //This location is being used by micro code for DTU forward count
         pt_ReTXParams->Un_UcodeReTXParam2.t_Param2.uc_FIFO3_DTU_FwdCount = 0;
         WriteCoreReg(ZEP_PRAM_ZR_RETX_PARAM2_LP1_ADDR, pt_ReTXParams->Un_UcodeReTXParam2.l_ReTXParam2);
      }
      //XDSLRTFW-1393 (End)

//XDSLRTFW-1617 (Start)
// This part of the code is moved to routine, ConfigZephyrFcRxPath_VDSL2().
// Reason: The variable gul_RtxQBaseAddr, depends on the code for Intra DTU interleaving changes
//in the routine  ConfigZephyrIlvRxPath_VDSL2.
//XDSLRTFW-1617 (End)

      //Program FIFO1
      ul_data = ZEP_RAM_RX_LP1_OHFIFO1_OFFSET;            //17:0 FIFO_Base, the location in IIBRAM as byte address
      ul_data |= (uint32)(ZEP_RAM_OHFIFO_SIZE_32-1) << ZEP_REG_ZR_FIFO_SIZEX_POS;
      WriteCoreReg(ZEP_PRAM_ZR_FIFO_BASE1_LP1_ADDR, ul_data);
      WriteCoreReg(ZEP_PRAM_ZR_FIFO_PTRS1_LP1_ADDR, 0);
      WriteCoreReg(ZEP_PRAM_ZR_FIFO_CNST1_LP1_ADDR, 0);

      //Program FIFO3 for DTU forward from IIBRAM to TC Layer
      ul_data = 0xC000;  //0x4C000 - 0x40000
      ul_data |= (4096-1) << 19;   //<26:19> FIFO SIZE
      WriteCoreReg(ZEP_PRAM_ZR_FIFO_BASE3_LP1_ADDR, ul_data);
      WriteCoreReg(ZEP_PRAM_ZR_FIFO_PTRS1_LP1_ADDR, 0); //will be configured again the DS ReTx micro code
      WriteCoreReg(ZEP_PRAM_ZR_FIFO_CNST1_LP1_ADDR, 0);
   }

}


/*
*-------------------------------------------------------------------------------
*
*   Prototype: void LoadRxZepMicroCode(void)
*
*   This function configure the microcode registers and load the micro code to IIBRAM.
*
*   Input Arguments:
*       None
*
*   Output Arguments:
*       None
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/

extern int32 fci_prog_rx_vdsl2_bc0_lp1[];
extern int32 fci_prog_rx_vdsl2_bc0_lp0[];
extern int32 fci_prog_rx_vdsl2_bc1_lp1[];
extern int32 fci_prog_rx_vdsl2_bc1_lp0[];

void LoadRxZepMicroCode(void)
{
   uint32 ul_RegBaseAddr=0, ul_MicroCode_ToAddr=0;
   int32 *pla_MicroCode_fromAddr=NULL;
   int16 i, j;
   FlagT ft_CopyUcode = FALSE;
   uint8 uc_RxLp0UcodePage=0, uc_RxLp1UcodePage=0;

   if(gs_RxState != R_O_SHOWTIME_RX)
   {
      if (gt_ReTXParams.uc_OMSG1_DsReTxEnabled == RETX_SELECTED)
      {
         uc_RxLp0UcodePage = VDSL_RX_LP0_UCODE_DM_SWAPPAGE;
         uc_RxLp1UcodePage = VDSL_RX_LP1_RETX_UCODE_DM_SWAPPAGE;
         //XDSLRTFW-1617 (Start)
         if(guc_ReTx_DS_D > 1)
         {
            uc_RxLp1UcodePage = VDSL_RX_LP1_RETX_IDILV_UCODE_DM_SWAPPAGE;
         }
         //XDSLRTFW-1617 (End)
      }
      else
      {
         if (guc_ch_id ==0)
         {
            uc_RxLp0UcodePage = VDSL_RX_LP0_UCODE_DM_SWAPPAGE;
            uc_RxLp1UcodePage = VDSL_RX_LP1_UCODE_DM_SWAPPAGE;
         }
         else
         {
            uc_RxLp0UcodePage = VDSL_RX_PORT1_LP0_UCODE_DM_SWAPPAGE;
            uc_RxLp1UcodePage = VDSL_RX_PORT1_LP1_UCODE_DM_SWAPPAGE;
         }
      }
   }
   else
   {
      guc_RxDataPumpState = RX_ZEP_FC_WAIT_FOR_LP1_UCODE;
   }

   switch (guc_RxDataPumpState)
   {
   case RX_ZEP_FC_LOADING_LP0_UCODE:
      if ((guc_RxUcodeHandle = RequestSwap1(uc_RxLp0UcodePage, SWAP_TIMING_OFF)) != INVALID_CODESWAP_HANDLE)
      {
         guc_RxDataPumpState = RX_ZEP_FC_WAIT_FOR_LP0_UCODE;
      }

      break;

   case RX_ZEP_FC_WAIT_FOR_LP0_UCODE:

      if (PollForCodeSwapDone(uc_RxLp0UcodePage, guc_RxUcodeHandle) == SWAP_DONE)
      {
         FreeSwapHandle(&guc_RxUcodeHandle);

         if(guc_ch_id ==0)
         {
            pla_MicroCode_fromAddr = fci_prog_rx_vdsl2_bc0_lp0;

            if(guc_PortMode == SINGLE_PORT_MODE)
            {
               ul_MicroCode_ToAddr = ZEP_RAM_1PORT_RX_LP0_UCODE_ADDR;
            }
            else
            {
               ul_MicroCode_ToAddr = ZEP_RAM_RX_LP0_UCODE_ADDR;
            }
         }
         else //if (guc_ch_id == 1), it is dual port mode.
         {
            pla_MicroCode_fromAddr = fci_prog_rx_vdsl2_bc1_lp0;

            ul_MicroCode_ToAddr = ZEP_RAM_RX_LP0_UCODE_ADDR;
         }

         ul_RegBaseAddr = ZEP_PRAM_RX_LP0_START_ADDR;
         guc_RxDataPumpState = RX_ZEP_FC_LOADING_LP1_UCODE;
         ft_CopyUcode = TRUE;
      }

      break;

   case RX_ZEP_FC_LOADING_LP1_UCODE:

      if ((guc_RxUcodeHandle = RequestSwap1(uc_RxLp1UcodePage, SWAP_TIMING_OFF)) != INVALID_CODESWAP_HANDLE)
      {
         guc_RxDataPumpState = RX_ZEP_FC_WAIT_FOR_LP1_UCODE;
      }

      break;

   case RX_ZEP_FC_WAIT_FOR_LP1_UCODE:


      if(gs_RxState != R_O_SHOWTIME_RX) // Showtime Code
      {
         if (PollForCodeSwapDone(uc_RxLp1UcodePage, guc_RxUcodeHandle) == SWAP_DONE)
         {
            FreeSwapHandle(&guc_RxUcodeHandle);
         }
         else
         {
            break;
         }
      }

      // by overlay just the two Ucode arrays,
      // fci_prog_rx_vdsl2_bc0_lp1 and fci_prog_rx_vdsl2_bc0_lp1_ReTX will be linked at the same address
      if (guc_ch_id ==0)
      {
         pla_MicroCode_fromAddr = fci_prog_rx_vdsl2_bc0_lp1;
      }
      else
      {
         pla_MicroCode_fromAddr = fci_prog_rx_vdsl2_bc1_lp1;
      }

      ul_RegBaseAddr = ZEP_PRAM_RX_LP1_START_ADDR;

      if((guc_ch_id ==0) && (guc_PortMode == SINGLE_PORT_MODE))
      {
         ul_MicroCode_ToAddr = ZEP_RAM_1PORT_RX_LP1_UCODE_ADDR;
         //XDSLRTFW-1617 (Start_End)
         gul_RX_LP1_UCODE_ADDR = ul_MicroCode_ToAddr;
      }
      else
      {
         ul_MicroCode_ToAddr = ZEP_RAM_RX_LP1_UCODE_ADDR;
      }

      guc_RxDataPumpState = RX_ZEP_FC_LOADING_UCODE_DONE;
      ft_CopyUcode = TRUE;
      break;

   }

   if (ft_CopyUcode)
   {
      uint32 ul_data, ul_addr;
      t_microcode_header *pt_header;
      uint32 ul_MicroCode_ToAddr_InLW;

      ul_MicroCode_ToAddr_InLW = ul_MicroCode_ToAddr >> 2;
      pt_header = (t_microcode_header*)(void *)pla_MicroCode_fromAddr;
      //Refer to CMV INFO 54 in Message Catalog ver 2.9 or newer for format
      //Load Rx Microcode version number
      gusa_FW_version_number[3] = (uint16)(pt_header->version & 0xFFFF); //XDSLRTFW-3364 (Start_End)


      // ZEP_PRAM_ZR_FLAG_CTRLx_LPx_ADDR
      WriteCoreReg((ul_RegBaseAddr+ZR_FLAG_CTRL0_OFFSET), pt_header->flags0);
      WriteCoreReg((ul_RegBaseAddr+ZR_FLAG_CTRL1_OFFSET), pt_header->flags1);

      // ZEP_PRAM_ZR_UPROC_ENA_LPx_ADDR
      WriteCoreReg((ul_RegBaseAddr+ZR_UPROC_ENA_OFFSET), pt_header->uproc_ena);
   // For Micro processor 0 to 4 use PRAM offset from ZR_UPROC01_BASE_OFFSET
   // from 5 to 9 use the offset from ZR_UPROC5_BASE_OFFSET_35B
   // Don't combine the base address of 2 micro processors for VRX518 as we are doing for VRX218 &
   // 318 platforms.
      // Write to ZEP_PRAM_ZR_UPROCxy_BASE_LPx_ADDR, where xy = 01, 23, 45, 67, 89
      {
         ul_addr = ul_RegBaseAddr+ZR_UPROC01_BASE_OFFSET;

         for(i=0; i<NUM_OF_UPROCESSORS; i++)
         {
            ul_data = ul_MicroCode_ToAddr_InLW + (pt_header->engine[i]).base;
            WriteCoreReg(ul_addr, ul_data);
            if (i == 4)
            {
               ul_addr = ul_RegBaseAddr+ZR_UPROC5_BASE_OFFSET_35B;
            }
            else
            {
               ul_addr += 4;
            }
         }
      }
      // ZEP_PRAM_ZR_UPROC_INT_LPx_ADDR - Initialize to 0.

      // Write to ZEP_PRAM_ZR_UPROCy_STATEx_LPx_ADDR, y=0,..9, x=0,..,4
      {
         ul_addr = ul_RegBaseAddr + ZR_UPROC0_STATE0_OFFSET;

         //Loop through all micro-processors (total of 9)
         for(i=0; i<NUM_OF_UPROCESSORS; i++)
         {
            for(j=0; j<NUM_OF_UPROC_STATES; j++)
            {
               WriteCoreReg(ul_addr, pt_header->engine[i].state[j]);
               ul_addr += 4;
            }
         }
      }

      //XDSLRTFW-3339(Start)
      //Initialize Internal state of Framing processors and don't need to reload the micro code executables
      //once more in showtime. This is done to save MIPS.
      //We can generalize this logic for 17a and 35b as well. In order to reduce the testing effort,
      //restricted to 35B with iDTU only.
      if ((gft_Intra_DTU_Ilv_DS == TRUE) && (gs_RxState == R_O_SHOWTIME_RX) &&
         (gt_ProfileAct.us_ProfileSelected & CNFG_V2_PROFILE_35B_MASK))
      {
         return;
      }
      //XDSLRTFW-3339(End)

      // Now Copy down microCode.
      {
         void *ptr_mcode;

         //Compute the number of 32-bit words in the header
         i = sizeof(t_microcode_header)/4;

         //Point to the first word following the header
         ptr_mcode = (void *) &pla_MicroCode_fromAddr[i];

         //Load micro-code
         ul_addr = ZEP_RAM_IIBRAM_ADDR + ul_MicroCode_ToAddr;
         //XDSLRTFW-2577 (Start)
         //MIPs optimization: Start DMA transfer of Micro code. Don't wait for its completion, continue
      //with other TC tasks
         {
            uint32 ul_StartAddr = (uint32)(ptr_mcode);
            uint32 ul_EndAddr = (uint32)((uint16 *)ptr_mcode+(2*pt_header->total_lines - 1));
            SetUpDMATransfer(ul_StartAddr, ul_EndAddr, ul_addr, 0, 0, 0);
         }
         //XDSLRTFW-2577 (End)
      }
   }

}



/*
*-------------------------------------------------------------------------------
*
*   Prototype: void ConfigZephyrIlvRxPath_VDSL2(void)
*
*   This function initializes Zephyr-ILV core for showtime RX path operations.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/

void ConfigZephyrIlvRxPath_VDSL2(void)
{
   //XDSLRTFW-1617 (Start)
   int16 s_lp,i;
   int16 s_lpInit = LP0;
   int32 ul_data, ul_addr, ul_RegBaseAddr;
   uint16 us_TransferSize[NUM_DATA_PATHS];
   int16 s_DoverI;
//XDSLRTFW-2162 (Start - End)
   uint32 l_ilvSize, ul_temp;
   //XDSLRTFW-1617 (End)

   ReTX_Params_t *pt_ReTXParams;
   VDSL2Config_t *pt_Config;

   uint32 *ptr_SidTsDtuStatus;  //XDSLRTFW-3493 (Start_End)

   // all RX registers are cleared in ClearRxZephyrRegs()

   // map the RX parameter structure
   pt_Config = &gt_rx_config_v2;
   pt_ReTXParams = &gt_ReTXParams;

   ///////////////////////////////////////////
   // GLOBAL REGISTERS INITIALIZATION START //
   ///////////////////////////////////////////

   // ZEP_REG_ZR_PMS_SIZE_ADDR
   // ZEP_REG_ZR_DT_SIZE_ADDR
//XDSLRTFW-2162 (Start)
   if(((gs_RxState != R_O_SHOWTIME_RX) && (guc_ReTx_DS_D > 1)) ||((gft_Intra_DTU_Ilv_DS == FALSE)))
   {
      us_TransferSize[LP0] = (uint16)(pt_Config->ul_Lp[LP0] >> 3);
      us_TransferSize[LP1] = (uint16)(pt_Config->ul_Lp[LP1] >> 3);
      ul_data = (uint32)us_TransferSize[LP0];
      ul_data |= ((uint32)us_TransferSize[LP1]) << 16;
      WriteCoreReg(ZEP_REG_ZR_PMS_SIZE_ADDR, ul_data);
      WriteCoreReg(ZEP_REG_ZR_DT_SIZE_ADDR, ul_data);
      // ZEP_PRAM_ZR_DTB_OFFSET_ADDR
      WriteCoreReg(ZEP_REG_ZR_DTB_OFFSET_ADDR, gs_ZEP_ILV_RAM_RXDTB_OFFSET); // THis is a LW address,
   }

   uint16 us_bytes;
   if((gs_RxState != R_O_SHOWTIME_RX) && (guc_ReTx_DS_D > 1))
   {
      gus_DTU_bytes = (uint16)(gt_rx_config_v2.s_Nfecp[LP1] * guc_ReTx_DS_D);
      ReadCoreReg(ZEP_REG_ZR_PMS_SIZE_ADDR,&ul_data);
      us_bytes = (ul_data & 0xFFFF0000) >> 16;
      us_bytes = us_bytes + gus_partial_DTU_bytes;
      gus_partial_DTU_bytes = us_bytes % gus_DTU_bytes;
   }
//With Intra DTU Interleaving DTU pointers are reset at the beginning of showtime & at the
// start of first symbol after SRA.
   //if(gft_Intra_DTU_Ilv_DS == TRUE)
   //{
   //   uint32 ul_RegBaseAddr1,  ul_addr1;
   //   ul_RegBaseAddr1 = ZEP_PRAM_RX_LP1_START_ADDR;
   //   ul_addr1 = ul_RegBaseAddr1 + ZR_DTB_PTRS_OFFSET;
   //   WriteCoreReg(ul_addr1, 0);
   //}
//XDSLRTFW-2162 (End)

   ///////////////////////////////////////////
   // PER LP REGISTERS INITIALIZATION START //
   ///////////////////////////////////////////
   if(gs_RxState == R_O_SHOWTIME_RX)
   {
      s_lpInit = LP1;               // In showtime, ReTx updates only LP1.
   }

   for(s_lp = s_lpInit; s_lp < NUM_DATA_PATHS; s_lp++)
   {
      if(s_lp == LP0)
      {
         ul_RegBaseAddr = ZEP_PRAM_RX_LP0_START_ADDR;
      }
      else //(s_lp == LP1)
      {
         ul_RegBaseAddr = ZEP_PRAM_RX_LP1_START_ADDR;
      }

      if(gs_RxState != R_O_SHOWTIME_RX)
      {
         // ZEP_PRAM_ZR_DTB_CTRL_LPx_ADDR
         if(s_lp == LP0)
         {
            ul_data = (gs_ZEP_ILV_RAM_RXDTB_LP0_SIZE-1) << 16; //27:16 DTB_Size - actual number of words - 1
            ul_data |= ZEP_ILV_RAM_RXDTB_LP0_BASE; //11:0 DTB_Base in 32-bit words
         }
         else //(s_lp == LP1)
         {
            ul_data = (gs_ZEP_ILV_RAM_RXDTB_LP1_SIZE-1) << 16; //27:16 DTB_Size - actual number of words - 1
            ul_data |= ZEP_ILV_RAM_RXDTB_LP1_BASE; //11:0 DTB_Base in 32-bit words
         }

         ul_addr = ul_RegBaseAddr + ZR_DTB_CTRL_OFFSET;
         WriteCoreReg(ul_addr, ul_data);

         // ZEP_ZR_QTDTB_CONFIG_LPx_ADDR

#ifdef QT_LATCH_LP_BITS
         ul_data |= (3<<30); // 30:31  Latch Bits.
#endif

         ul_addr = ZEP_REG_ZR_QTDTB_CONFIG_LP0_ADDR + (s_lp<<2);
         WriteCoreReg(ul_addr, ul_data);

         // ZEP_PRAM_ZR_ILV_BASE0_LPx_ADDR
         ul_addr = ul_RegBaseAddr + ZR_ILV_BASE0_OFFSET;
         WriteCoreReg(ul_addr, gula_rxILVBaseAddr[s_lp]);
//XDSLRTFW-2162 (Start)
      }//if(gs_RxState != R_O_SHOWTIME_RX)

      //XDSLRTFW-1617 (Start)
      if ((gft_Intra_DTU_Ilv_DS == TRUE) &&(s_lp == LP1))
      {
         l_ilvSize =(uint32) (gt_ReTXParams.uc_ReTX_N) *(guc_ReTx_DS_D);
//XDSLRTFW-2162 (End)
         ul_addr = ul_RegBaseAddr + ZR_ILV_BASE0_OFFSET;
         ul_temp = gula_rxILVBaseAddr[LP1];
         ul_temp = (ul_temp + 3) & 0xFFFFFFFC;
         WriteCoreReg(ul_addr, ul_temp);
         ul_temp += l_ilvSize;
         ul_temp = (ul_temp + 3) & 0xFFFFFFFC;
         ul_addr = ul_RegBaseAddr + ZR_ILV_BASE1_OFFSET;
         WriteCoreReg(ul_addr, ul_temp);

         //gul_RtxQBaseAddr provides the base address for DTUs in re-ordering buffer.
         //SID, TS and DTU status (Good/Bad) is directly written by microcode in the
         //first four bytes of each DTU. FW code uses a "uint32 pointer" to access SID,
         //TS and DTU status data. Additionally ADMA (for DTUs forwarded to TPS-TC layer)
         //requires that source and destination address to be aligned to 32 bit boundary.
         //Hence aligning the DTU base address to 32 bit boundary.
         gul_RtxQBaseAddr = ((ul_temp + l_ilvSize + 3) & 0xFFFFFFFC); //XDSLRTFW-4503 (Start_End)
      }//if ((gft_Intra_DTU_Ilv_DS == TRUE) &&(s_lp == LP1))
      //XDSLRTFW-1617 (End)


      // ZEP_REG_ZR_ILV_PARAMS0_LPx_ADDR
      ul_data = (uint32) Find_Pmd_Step(pt_Config->s_Dp[s_lp] , pt_Config->s_Ip[s_lp] );
      ul_data <<= 16;
      ul_data |= 1<<24; //pms_step =1
      ul_data |= ((uint32) pt_Config->s_Ip[s_lp] <<8); //7:0
      ul_data |= 0 ; //  efficient DE_interleaver

      ul_addr = ul_RegBaseAddr + ZR_ILV_PARAMS0_OFFSET;
      WriteCoreReg(ul_addr, ul_data);

      //XDSLRTFW-1617 (Start)
//XDSLRTFW-2162 (Start - End)
      if ((gft_Intra_DTU_Ilv_DS == TRUE) &&(s_lp == LP1))
      {
         ul_data = ((ul_data & ~0xffff00ff) | 0x2); //Block De interleaver
         WriteCoreReg(ul_addr, ul_data);
         ul_addr = ul_RegBaseAddr + ZR_ILV_PARAMS1_OFFSET;
         WriteCoreReg(ul_addr, ul_data);
      }
      //XDSLRTFW-1617 (End)


      // ZEP_PRAM_ZR_ILV_SIZE0_LPx_ADDR
      // calculate total_delay per fifo as (D-M-1) with M = floor(D/I)

      if(pt_Config->s_Ip[s_lp] != 0)
      {
         if (pt_Config->s_Ip[s_lp] != 0)
         {
            s_DoverI = pt_Config->s_Dp[s_lp] / pt_Config->s_Ip[s_lp];

            // Special case
            if (pt_Config->s_Dp[s_lp] == 1)
            {
               s_DoverI = 0;
            }

            l_ilvSize = pt_Config->s_Dp[s_lp] - s_DoverI -1;
         }//if (pt_Config->s_Ip[s_lp] != 0)
         else
         {
            l_ilvSize = 0;
         }//else  (pt_Config->s_Ip[s_lp] != 0)



         //ILV EXT = ILV_SIZE[16:23] = q+EXT
         ul_data = (uint32)pt_Config->s_q[s_lp] + 1;

         ul_addr = ul_RegBaseAddr + ZR_ILV_SIZE0_OFFSET;
         WriteCoreReg(ul_addr, ((ul_data<<16)|l_ilvSize));

         // set R8 to D - M - 1, where  M = floor(D/I)
         ul_addr = ul_RegBaseAddr + ZR_R8_OFFSET;
         WriteCoreReg(ul_addr, l_ilvSize);

         //XDSLRTFW-1617 (Start)
         if((gt_ReTXParams.uc_OMSG1_DsReTxEnabled == RETX_SELECTED) && (s_lp == LP1))
         {
            //XDSLRTFW-2162 (Start - End)
            if (gft_Intra_DTU_Ilv_DS == TRUE)
            {
               l_ilvSize =(uint32) (pt_ReTXParams->uc_ReTX_N) *(guc_ReTx_DS_D);
               ul_addr = ul_RegBaseAddr + ZR_ILV_SIZE0_OFFSET;
               WriteCoreReg(ul_addr, l_ilvSize);
               ul_addr = ul_RegBaseAddr + ZR_ILV_SIZE1_OFFSET;
               WriteCoreReg(ul_addr, l_ilvSize);

               ul_addr = ul_RegBaseAddr + ZR_ILV_MIN_FULLNESS0_OFFSET;
               WriteCoreReg(ul_addr, l_ilvSize);
               ul_addr = ul_RegBaseAddr + ZR_ILV_MIN_FULLNESS1_OFFSET;
               WriteCoreReg(ul_addr, l_ilvSize);


               ul_addr = ul_RegBaseAddr + ZR_ILV_MAX_FULLNESS0_OFFSET;
               WriteCoreReg(ul_addr, l_ilvSize);
               ul_addr = ul_RegBaseAddr + ZR_ILV_MAX_FULLNESS1_OFFSET;
               WriteCoreReg(ul_addr, l_ilvSize );
               //XDSLRTFW-2162 (Start - End)
               if(gs_RxState != R_O_SHOWTIME_RX)
               {
                  ul_addr = ul_RegBaseAddr + ZR_ILV_CNTRS0_OFFSET;
                  WriteCoreReg(ul_addr,0);
                  ul_addr = ul_RegBaseAddr + ZR_ILV_CNTRS1_OFFSET;
                  WriteCoreReg(ul_addr,0);
                  ul_addr = ul_RegBaseAddr + ZR_ILV_PMS_CNTRS0_OFFSET;
                  WriteCoreReg(ul_addr,0);
                  ul_addr = ul_RegBaseAddr + ZR_ILV_PMS_CNTRS1_OFFSET;
                  WriteCoreReg(ul_addr,0);
                  ul_addr = ul_RegBaseAddr + ZR_ILV_PMD_CNTRS0_OFFSET;
                  WriteCoreReg(ul_addr,0);
                  ul_addr = ul_RegBaseAddr + ZR_ILV_PMD_CNTRS1_OFFSET;
                  WriteCoreReg(ul_addr,0);
                  //XDSLRTFW-2162 (Start - End)
               }
            }
            else
            {
               ul_addr = ul_RegBaseAddr + ZR_ILV_MIN_FULLNESS0_OFFSET;
               WriteCoreReg(ul_addr, 0);
               ul_addr = ul_RegBaseAddr + ZR_ILV_MAX_FULLNESS0_OFFSET;
               WriteCoreReg(ul_addr, 0x3ffff);
            }
         }//if ( (gt_ReTXParams.uc_OMSG1_DsReTxEnabled == RETX_SELECTED)/* && (guc_ReTx_DS_D > 1) */&& (s_lp == LP1))
         //XDSLRTFW-1617 (End)
      }//if(pt_Config->s_Ip[s_lp] != 0)

      // ZEP_PRAM_ZR_DEPTH_LPx_ADDR
      ul_data = (uint32)pt_Config->s_Dp[s_lp] << 16; //D_Shadow
      ul_data |= (uint32)pt_Config->s_Dp[s_lp]; // D
      ul_addr = ul_RegBaseAddr + ZR_DEPTH_OFFSET;
      WriteCoreReg(ul_addr, ul_data);

      if(pt_Config->ul_Lp[s_lp] > 0)
      {
         uint16 Dp, Ip;
         uint32 ul_divL, ul_modL, ul_Lp ;

         Dp = pt_Config->s_Dp[s_lp] ;
         ul_Lp = pt_Config->ul_Lp[s_lp] ;
         Ip = pt_Config->s_Ip[s_lp] ;

         // ZEP_PRAM_ZIR_DL_REL0_LPx_ADDR
         ul_divL = (8 * Dp) / ul_Lp;
         ul_modL = (8 * Dp) % ul_Lp;
         ul_data = ul_modL | (ul_divL << 16);

         ul_addr = ul_RegBaseAddr + ZIR_DL_REL0_OFFSET;
         WriteCoreReg(ul_addr, ul_data);

         // ZEP_PRAM_ZIR_NL_REL0_LPx_ADDR
         ul_divL = (8 * Ip) / ul_Lp;
         ul_modL = (8 * Ip) % ul_Lp;
         ul_data = ul_modL | (ul_divL << 16);

         ul_addr = ul_RegBaseAddr + ZIR_NL_REL0_OFFSET;
         WriteCoreReg(ul_addr, ul_data);
      }//if(pt_Config->ul_Lp[s_lp] > 0)


      if(gs_RxState != R_O_SHOWTIME_RX)
      {
         //ZEP_PRAM_ZIR_DMETRIC0_LPx_ADDR
         ul_addr = ul_RegBaseAddr + ZIR_DMETRIC0_OFFSET;
         WriteCoreReg(ul_addr, 7);
         // LP2 config
         ul_data = (uint32)(gs_ZEP_ILV_RAM_RXDTB_LP2_SIZE-1) << 16; //27:16 DTB_Size - actual number of words - 1
         ul_data |= ZEP_ILV_RAM_RXDTB_LP2_BASE; //11:0 DTB_Base in 32-bit words
         WriteCoreReg(ZEP_REG_ZR_QTDTB_CONFIG_LP2_ADDR, ul_data);
      }//if(gs_RxState != R_O_SHOWTIME_RX)

      //ZEP_PRAM_ZIR_DMETRIC_CTRL_LPx_ADDR
      if(pt_Config->s_Ip[s_lp] > 0)
      {
         ul_data =  (pt_Config->s_Dp[s_lp]%pt_Config->s_Ip[s_lp]) <<24;
         ul_data |= 1<<16; //Symbol_croass_op =1;

         ul_addr = ul_RegBaseAddr + ZIR_DMETRIC_CTRL_OFFSET;
         WriteCoreReg(ul_addr, ul_data);
      }

      //ZEP_PRAM_ZIR_LPBITS_LPx_ADDR
      ul_addr = ul_RegBaseAddr + ZIR_LPBITS_OFFSET;
      WriteCoreReg(ul_addr, pt_Config->ul_Lp[s_lp]) ;

   } //for(s_lp = 0; s_lp < NUM_DATA_PATHS; s_lp++)


   if (pt_ReTXParams->uc_OMSG1_DsReTxEnabled == RETX_SELECTED)
   {
      //XDSLRTFW-1617 (Start)
      // This part of the code is moved from routine, ConfigZephyrFcRxPath_VDSL2().
      // Reason: The variable gul_RtxQBaseAddr, depends on the code for Intra DTU interleaving changes
      //in the routine  ConfigZephyrIlvRxPath_VDSL2.

      //XDSLRTFW-1209: BugFix_DS_VDSL2_ALL_PacketLoss_In_ReTX_Mode (Start)
      //Program number of "stuff" or packing bytes required to make DTU(s) (in Qrx queue) address
      //a multiple of 4 bytes. This is need to either trigger DMA (if reqd) or for fast memcpy
      //(i.e 4 bytes at a time)
      //XDSLRTFW-1393 (Start_End)
      pt_ReTXParams->l_NumPaddingBytes = ((4 - (pt_ReTXParams->ul_DtuPayloadSize & 3)) & 3);
      ul_temp = pt_ReTXParams->l_NumPaddingBytes << 8;
      WriteCoreReg(ZEP_PRAM_ZR_CRC1_LP1_ADDR, ul_temp);

      gt_ReTXParams.ul_DS_ReTXQueue_BaseAddress = gul_RtxQBaseAddr;   // XDSLRTFW-3948(Start_End)

      //XDSLRTFW-1571 (Start)
      //Initialize the WR pointer to the begining of the Queue
      //XDSLRTFW-3493 (Start)
      //Added 4 bytes for the Rx framer to write SID, TS and DTU_STATUS. ARC DSP will read these 3 bytes from
      //appropriate location. Note: Allocated 4 bytes to have 32bit boundary.
      WriteCoreReg(ZEP_PRAM_ZR_ILVB_WRAD_LP1_ADDR,
                   (uint32)(pt_ReTXParams->ul_DS_ReTXQueue_BaseAddress +
                            (guca_InpBufList[0]*(pt_ReTXParams->ul_DtuPayloadSize + pt_ReTXParams->l_NumPaddingBytes + BYTES_FOR_SID_TS_DTU_STATUS))));
      //XDSLRTFW-3493 (End)

      __gula_ZrIlvbWrPtrTable[0] = (uint32)(ZEP_PRAM_ZR_CRC0_LP1_ADDR);
      __gula_ZrIlvbWrPtrTable[1] = (uint32)(ZEP_PRAM_ZR_OHRATE_LP1_ADDR);
      __gula_ZrIlvbWrPtrTable[2] = (uint32)(ZEP_PRAM_ZR_ILVB_WRPTR_LP1_ADDR);
      __gula_ZrIlvbWrPtrTable[3] = (uint32)(ZEP_PRAM_ZR_VBC_SIZE_LP1_ADDR);


      for (i = 0; i < ILVB_WRPTR_TABLE_SIZE_LW; i++)
      {
         //XDSLRTFW-3493 (Start)
         ul_temp = (uint32)(pt_ReTXParams->ul_DS_ReTXQueue_BaseAddress +
                     (guca_InpBufList[i]*(pt_ReTXParams->ul_DtuPayloadSize + pt_ReTXParams->l_NumPaddingBytes + BYTES_FOR_SID_TS_DTU_STATUS)));

         *((uint32 *)__gula_ZrIlvbWrPtrTable[i]) = ul_temp;

         ptr_SidTsDtuStatus = (uint32 *)(ZEP_RAM_IIBRAM_ADDR + ul_temp + pt_ReTXParams->ul_DtuPayloadSize + pt_ReTXParams->l_NumPaddingBytes);
         *ptr_SidTsDtuStatus = 0xFFFFFFFF; //Initialize SID<7:0> as 0xFF, TS <15:8> as 0xFF, DTU_STATUS <23:16> as 0xFF and DUMMY_BYTE <31:24> as 0xFF
         //XDSLRTFW-3493 (End)
      }
      //XDSLRTFW-1571 (End)
      //XDSLRTFW-1617 (End)

      // ZEP_PRAM_ZR_ILVB_RDPTR_LPx_ADDR - Init to 0
      WriteCoreReg(ZEP_PRAM_ZR_ILVB_RDPTR_LP1_ADDR, DTU_POINTERS_LW_BASE_ADDR);

   }

} //void ConfigZephyrIlvRxPath_VDSL2(void)
