/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2005 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: TxDataPumpSetUp.c
*
*   This file contains engine interface functions to initialize cores
*   for showtime TX path operations.
*
*-------------------------------------------------------------------------------
*/
// ***********************************************************************************************************
// TxDataPumpSetUp.c
//
// History
//
// 11/07/2014 Kannan : "CalcDataBytesPerSymbol(uint8 uc_bc)" is moved to TxDataPumpUpSetup.c
//                     to call this function during training and showtime to update the
//                     PPE register to change in Tx throuput rate.
//                     Grep for XDSLRTFW-1474
//************************************************************************************************************

#include <string.h>
#include "common.h"
#include "gdata.h"
#include "dsp_op.h"
#include "TxDataPumpSetUp.h"
#include "LL_IOf.h"
#include "alp_memmap.h"
#include "qt_memmap.h"
#include "qtp_memmap.h"
#include "zep_ilv_memmap.h"
#include "zep_memmap.h"
#include "OvhdMsg_IOf.h"
#include "mul.h"
#include "CustomerTasks.h"
#include "zep_memmap_cnfg.h"
#include "delay.h"

#ifdef PPE_ENGINE
#include "ppe_memmap.h"
#endif


void LoadTxZepMicroCode(void);

extern int16 CalcDataBytesPerSymbol(uint8 uc_bc); //XDSLRTFW-1474 (START-END)

#ifdef INCLUDE_TXDATAPUMP_FUNCS


/*
*-------------------------------------------------------------------------------
*
*   Prototype: void TxDataPumpSetUp(void)
*
*   This function initializes cores for showtime TX path operations.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/

void TxDataPumpSetUp(void)
{
   // initialize cores one by one
   // make sure each core initialization is within MIPS budget for TC task
   switch (guc_TxDataPumpState)
   {

   case TX_CONFIG_TPS_ALP:


#ifdef PPE_ENGINE
      // Configure PPE interface registers
      ConfigurePPETxPath();
#endif //PPE_ENGINE

      guc_TxDataPumpState = TX_CONFIG_PMS_ZEP_FC;
      break;

   case TX_CONFIG_PMS_ZEP_FC:
      ConfigZephyrFcTxPath_VDSL2();
      guc_TxDataPumpState = TX_ZEP_FC_LOADING_LP0_UCODE;

      break;

   case TX_ZEP_FC_LOADING_LP0_UCODE:
   case TX_ZEP_FC_WAIT_FOR_LP0_UCODE:
   case TX_ZEP_FC_LOADING_LP1_UCODE:
   case TX_ZEP_FC_WAIT_FOR_LP1_UCODE:
      LoadTxZepMicroCode();               // this function will step thru these 3 substates
      break;

   case TX_ZEP_FC_LOADING_UCODE_DONE:
      guc_TxDataPumpState = TX_CONFIG_PMS_ZEP_ILV;
      break;


   case TX_CONFIG_PMS_ZEP_ILV:
      ConfigZephyrIlvTxPath_VDSL2();

      guc_TxDataPumpState = TX_CONFIG_PMD_IRI_QT;
      break;

   case TX_CONFIG_PMD_IRI_QT:
      ConfigIridiaQtTxPath();
      guc_TxDataPumpState = TX_CONFIG_CORE_DONE;
      break;

   default:
      break;

   }
}

/*
*-------------------------------------------------------------------------------
*
*   Prototype: void ConfigAlphaeusTxPath(void)
*
*   This function initializes Alphaeus core for showtime TX path operations.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/


/*
*-------------------------------------------------------------------------------
*
*   Prototype: void ConfigIridiaQtTxPath(void)
*
*   This function initializes Iridia-QT core for showtime TX path operations.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/

void ConfigIridiaQtTxPath(void)
{
   uint32 ul_data;
   int16 s_TxNumTones;
   if (gs_RxNumTones > gs_TxNumTones)
      s_TxNumTones = gs_RxNumTones;
   else
      s_TxNumTones = gs_TxNumTones;

   // IT_CONFG
   // set in initialization

   // IT_MISC
   // set in initialization, modified right before showtime in StartTxDataPath()

   // IT_ACT_ADDR
   // configured in SwitchTxPingPongTable()

   // IT_LP0_BITS, IT_LP1_BITS
   WriteCoreReg(IRI_QT_REG_TX_LP0_BITS_ADDR, gt_tx_config_v2.ul_Lp[LP0]);
   WriteCoreReg(IRI_QT_REG_TX_LP1_BITS_ADDR, gt_tx_config_v2.ul_Lp[LP1]);


   // IT_LP2_BITS
   if (gt_ReTXParams.uc_OMSG1_DsReTxEnabled == RETX_SELECTED)
   {
      WriteCoreReg(IRI_QT_REG_TX_LP2_BITS_ADDR, DS_RRC_BITS);
   }
   else
   {
      WriteCoreReg(IRI_QT_REG_TX_LP2_BITS_ADDR, 0);
   }

   // IT_DUMMY
   WriteCoreReg(IRI_QT_REG_TX_DUMMY_ADDR, 0);

   // IT_LP0_BIT_FIFO
   WriteCoreReg(IRI_QT_REG_TX_LP0_BIT_FIFO_ADDR, 0);

   // IT_LP1_BIT_FIFO
   WriteCoreReg(IRI_QT_REG_TX_LP1_BIT_FIFO_ADDR, 0);

   // IT_LP2_BIT_FIFO
   WriteCoreReg(IRI_QT_REG_TX_LP2_BIT_FIFO_ADDR, 0);

   // Not used for CPE
   // IT_PILOT
   // IT_PTINDEX

   // IT_PRBS
   // IT_PRBS_MISC
   // IT_PRBS_POLY
   // IT_PRBS_DATAx
   // IT_REF_GAIN
   // IT_NYQ_TONE_DATA
   // IT_TXCG_x, x=0, 1, ... 15
   // IT_IFFTZ_RNGx, x=0,1,...,5
   // IT_TONE0_DATA
   // IT_DCI_CTRL


   //QTP_TXTC_CTRL
   //set TOT_DIS=0; segment = 0 ; tc_Dir =0= inactive->active
   ul_data = (uint32)((gs_Tblcpy_Num0bit[TX] << 19) | (gs_Tblcpy_NumGT1bit[TX] << 6));

   // enable TCM
   if (gft_TxTcmFlag)
   {
      ul_data |= MASK_BIT1;   //Enable 1bit reorder in QTP for TCM mode
   }

   WriteCoreReg(IRI_QTP_REG_TXTC_CTRL_ADDR, ul_data);


   ul_data = ((uint32)(s_TxNumTones-gs_TxNumTonesUsed)) | ((uint32)(s_TxNumTones-1) << 13);
   WriteCoreReg(IRI_QTP_REG_TXTC_TOT_ADDR, ul_data);

   // IT_TCM_CTRL
   ul_data = (uint32) (((gus_Tx_Tcm_Num1bits >> 1) << 13) | (gs_TxNumTonesUsed-1));
   WriteCoreReg(IRI_QT_REG_TX_TCM_CTRL_ADDR, ul_data);

   //IT_PRBS_MISC
   //XDSLRTFW-1420
   //Dont reset PRBS at the end of every frame for monitor tones support
   ResetCoreReg(IRI_QT_REG_TX_PRBS_MISC_ADDR,(uint16)MASK_BIT11);

}

/*
*-------------------------------------------------------------------------------
*
*   Prototype: void ClearRxZephyrRegs(void)
*
*   This function initializes clears all RX Zephyr registers
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/
void ClearTxZephyrRegs(void)
{
   FillCoreBuf32(ZEP_PRAM_TX_LP0_START_ADDR, 0, ZEP_REG_TX_PRAM_SIZE);
   FillCoreBuf32(ZEP_PRAM_TX_LP1_START_ADDR, 0, ZEP_REG_TX_PRAM_SIZE);
}

#ifdef PPE_ENGINE

//Define for Ax_CFG REGISTER.
#define PPE_EFM_MODE (3<<5)
#define PPE_BYTE_FLIP_DISABLE (2)
//

/*
*-------------------------------------------------------------------------------
*
*   Prototype: void ConfigurePPETxPath(void)
*
*   This function initializes PPE engine for showtime TX path operations.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*      guc_PortMode -- (I)
*      gula_DREG_AR_CFG_Cnfg[] -- (I)
*      gft_TcTypeSelected -- (I)
*-------------------------------------------------------------------------------
*/
void ConfigurePPETxPath(void)
{
   uint32 ul_data;
   uint8 uc_bc, uc_offset;
   //XDSLRTFW-521 NewFeatures_ALL_ALL_ALL_ATMVDSL2
   for (uc_bc=0; uc_bc<2; uc_bc++) //Need to clear paths not used
   {
      uc_offset = (uc_bc +guc_ch_id)<<2;

      //Configure bearer channel 0
      if(gt_tx_TPS_Map.s_BCtoTPS[uc_bc] != 0)
      {
         //Configure DREG_AT_CFG0
         ul_data = gula_DREG_AT_CFG_Cnfg[uc_bc];

         if(gft_TcTypeSelected == TPS_TC_TYPE_PTM)
         {
            //If EFM preemption is supported, set the corresponding bit in this register
            if(gta_UsBearerChanAct[uc_bc].ta_TpsTcType.uc_TPSTCoptions & TPS_TC_OPTION_PREEMPT)
            {
               ul_data |= (1<<7);
            }

            //If EFM short packets are supported, set the corresponding bit in this register
            if(gta_UsBearerChanAct[uc_bc].ta_TpsTcType.uc_TPSTCoptions & TPS_TC_OPTION_SHORTPACKET)
            {
               ul_data |= (1<<8);
            }

            //Set the TX TC mode to EFM TC mode, with Byte flip disabled.
            ul_data |= (PPE_EFM_MODE | PPE_BYTE_FLIP_DISABLE );

         }

         //According to VDSL2 AnnexK (section K.2.8.6), we need to do the following for ATM-TC
         else if(gft_TcTypeSelected == TPS_TC_TYPE_ATM)
         {
            //Enable byte flip (seting bit 1 to 0)

            //Enable scrambling
            ul_data |= (1<<2);
         }

         WritePpeReg((DREG_AT_CFG0_ADDR + uc_offset), ul_data);

         //DREG_AT_IDLEx
         if(gft_TcTypeSelected == TPS_TC_TYPE_ATM)
         {
            ul_data = 0x6A;
         }
         else
         {
            ul_data = 0;
         }
         WritePpeReg((DREG_AT_IDLE0_ADDR + uc_offset), ul_data);

         //DREG_Bx_LADR
         //Compute the average number of bytes per DMT symbol
         //transfered from PPE to DFE
         ul_data = (uint32)CalcDataBytesPerSymbol(uc_bc);
         WritePpeReg((DREG_B0_LADR_ADDR + uc_offset), ul_data);
      }
      else //if(gt_tx_TPS_Map.s_BCtoTPS[uc_bc] != 0)
      {
         //Clear all registers
         WritePpeReg((DREG_AT_CFG0_ADDR + uc_offset), 0);
         WritePpeReg((DREG_AT_IDLE0_ADDR + uc_offset), 0);
         WritePpeReg((DREG_B0_LADR_ADDR + uc_offset), 0);

      } //if(gt_tx_TPS_Map.s_BCtoTPS[uc_bc] != 0) else

      //Read PPE counter registers and initiate shadow global variables
      ReadPpeReg((DREG_AT_CELL0_ADDR + uc_offset), &ul_data);
      gula_DREG_AT_CELL_Shadow[uc_bc] = ul_data;

      ReadPpeReg((DREG_AT_IDLE_CNT0_ADDR + uc_offset), &ul_data);
      gula_DREG_AT_IDLE_CNT_Shadow[uc_bc] = ul_data;

   } //for (s_bc=0; s_bc<(guc_PortMode+1); s_bc++)
}

#endif //#ifdef PPE_ENGINE

#endif // INCLUDE_TXDATAPUMP_FUNCS

