/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2005 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: TxDataPumpSetUp_VDSL2.c
*
*   This file contains engine interface functions to initialize cores
*   for showtime TX path operations.
*
*-------------------------------------------------------------------------------
*/
// TxDataPumpSetUp_VDSL2.c
//
// History
//
//19/07/2013 Kannan: Changes to set the Tx Data pump setup
//Grep for "XDSLRTFW-1079 Feature_US_VDSL2_ALL_UsReTx"
//
// 29/10/2013 Sooraj: Added Support of US-SRA with ReTx
//                 Grep for XDSLRTFW-1258_ZephyrConfig for US-SRA in US-ReTx mode
//
//09/09/2014 Kannan: clear "ZEP_PRAM_ZT_R12_LP1_ADDR <31:0> as an initialization
//Grep for "XDSLRTFW-1830"
//
// 29/10/2014 Anantha Ramu: Modifications done for configurations of interleaver
//                          for Intra DTU Interleaving.
//                          Grep for "XDSLRTFW-1617"
//
// ************************************************************************************************************

#include <string.h>
#include "common.h"
#include "gdata.h"
#include "vdsl_state.h"
#include "dsp_op.h"
#include "TxDataPumpSetUp.h"
#include "LL_IOf.h"
#include "alp_memmap.h"
#include "qt_memmap.h"
#include "zep_ilv_memmap.h"
#include "zep_memmap.h"
#include "zep_memmap_cnfg.h"
#include "OvhdMsg_IOf.h"
#include "mul.h"
#include "cmv.h"
#include "cmv_data.h"
#include "typedef.h"
#include "showtime.h"
#include "Us_Rtx.h"

uint16 Find_Pmd_Step(uint16 s_D, uint16 s_I);

extern int32 fci_prog_tx_vdsl2_bc0_lp0[];


//XDSLRTFW-2577 (Start)
void SetUpDMATransfer(uint32 SourceAddr, uint32 SourceEnd, uint32 DestAddr,
                      uint32 ul_DspAdmaCtrl_FillMask, int32 ul_FillValue,
                      uint16 us_WaitForDMAComplete);
//XDSLRTFW-2577 (End)

/*
*-------------------------------------------------------------------------------
*
*   Prototype: void ConfigZephyrFcTxPath_VDSL2(void)
*
*   This function initializes Zephyr-FC core for showtime TX path operations.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------*/

void ConfigZephyrFcTxPath_VDSL2(void)
{
   int16 s_lp;
   int16 s_lpInit = LP1;               // In showtime, ReTx updates only LP1.
   uint32 ul_data, ul_addr, ul_RegBaseAddr;
   VDSL2Config_t *pt_Config;
   // map the TX parameter structure
   pt_Config = &gt_tx_config_v2;

   // XDSLRTFW-1258_ZephyrConfig for US-SRA in US-ReTx mode (START)
   if(gs_TxState != R_SHOWTIME_TX) // Training
   {
      // XDSLRTFW-1258_ZephyrConfig for US-SRA in US-ReTx mode (END)
      // Use FIFO3 to capture the input data to the scrambler
      ul_data = ZEP_RAM_TX_OHFIFO3_DBG1_OFFSET;
      //VRX518 Platform specific changes
      ul_data |= (ZEP_RAM_TX_OHFIFO3_DBG1_SIZE-1) << 19;  //<29:19> FIFO SIZE
      WriteCoreReg(ZEP_PRAM_ZT_FIFO_BASE3_LP0_ADDR, ul_data);

      WriteCoreReg(ZEP_PRAM_ZT_FIFO_PTRS3_LP0_ADDR, 0);
      WriteCoreReg(ZEP_PRAM_ZT_FIFO_CNST3_LP0_ADDR, 0);


      // all TX registers are cleared in InitZephyr()


      ///////////////////////////////////////////
      // GLOBAL REGISTERS INITIALIZATION START //
      ///////////////////////////////////////////
      //XDSLRTFW-3756 (START)
      ul_data = 0;
      WriteCoreReg(ZEP_REG_ZT_QTDTB_ADDR_LP01_ADDR, ul_data);
      WriteCoreReg(ZEP_REG_ZT_QTDTB_ADDR_LP2_ADDR, ul_data);
      //XDSLRTFW-3756 (END)


      // ZEP_REG_Z_VERSION_ADDR
      // may be read at initialization, read-only register

      // ZEP_REG_ZT_FIFO_ACCESS_ADDR - Init to 0


      // ZEP_REG_ZT_CONFIG_ADDR
      WriteCoreReg(ZEP_REG_ZT_CONFIG_ADDR, ZEP_PRAM_TX_START_ADDR/4); //Longword address
      ul_data = ZEP_RAM_IIBRAM_ADDR + ZEP_PRAM_TX_START_ADDR;


      WriteCoreReg(ul_data, guc_NumLantencyPath);

      ul_data += 4;
      WriteCoreReg(ul_data, ZEP_TX_CFG_LP0_PTR/4);

      ul_data += 4;
      WriteCoreReg(ul_data, ZEP_TX_CFG_LP1_PTR/4);

      s_lpInit = LP0;                    // In Training, ReTx updates for all LP.
   }

   // End of per instance and per port registers

   ///////////////////////////////////////////
   // PER LP REGISTERS INITIALIZATION START //
   ///////////////////////////////////////////

   for(s_lp = s_lpInit; s_lp < NUM_DATA_PATHS; s_lp++)
   {
      if(s_lp == LP0)
      {
         ul_RegBaseAddr = ZEP_PRAM_TX_LP0_START_ADDR;
      }
      else //(s_lp == LP1)
      {
         ul_RegBaseAddr = ZEP_PRAM_TX_LP1_START_ADDR;
      }

      // ZEP_PRAM_ZT_CODEWORD_LPx_ADDR
      ul_data = (uint32)pt_Config->s_Mp[s_lp] << 24; //31:24 SYM_CW
      ul_data |= (uint32)pt_Config->s_Rp[s_lp] << 16; //23:16 CB_Size
      ul_data |= (uint32)(pt_Config->s_Nfecp[s_lp] - pt_Config->s_Rp[s_lp]) << 8; //15:8 KP_Val
      ul_data |= (uint32)pt_Config->s_Nfecp[s_lp]; //7:0 CW_Size

      ul_addr = ul_RegBaseAddr + ZT_CODEWORD_OFFSET;
      WriteCoreReg(ul_addr, ul_data);


      // ZEP_PRAM_ZT_VBC_SIZE_LPx_ADDR
      if (gt_tx_TPS_Map.s_BCtoLP[BC0] == s_lp)
      {
         ul_data = (uint32)pt_Config->sa_Bpn[s_lp][BC0];   //15:0 BC0_Bytes
      }
      else
      {
         ul_data = 0;
      }
      if (gt_tx_TPS_Map.s_BCtoLP[BC1] == s_lp)
      {
         ul_data |= (uint32)pt_Config->sa_Bpn[s_lp][BC1] << 16;   //31:16 BC1_Bytes
      }

      ul_addr = ul_RegBaseAddr + ZT_VBC_SIZE_OFFSET;
      WriteCoreReg(ul_addr, ul_data);

      // XDSLRTFW-1258_ZephyrConfig for US-SRA in US-ReTx mode (START)
      if(gs_TxState != R_SHOWTIME_TX) // Training
      {
         // XDSLRTFW-1258_ZephyrConfig for US-SRA in US-ReTx mode (END)
         // ZEP_PRAM_ZT_FRAMING_LPx_ADDR
         ul_data = (uint32)pt_Config->s_OHSWITCHp[s_lp] << 24; //31:24 Tx_OHSwitch
         ul_data |= (uint32)pt_Config->s_Tp[s_lp] << 16; //23:16 TP_Val
         ul_data |= pt_Config->s_SEQp[s_lp]; //15:0 Max_Frm_Idx -- (1 based, no need to minus 1)

         ul_addr = ul_RegBaseAddr + ZT_FRAMING_OFFSET;
         WriteCoreReg(ul_addr, ul_data);

         // ZEP_PRAM_ZT_OHRATE_LPx_ADDR
         ul_data = (uint32)(MAX(pt_Config->s_OHRate1p[s_lp], pt_Config->s_OHRate2p[s_lp])) << 16; //31:16 Max_OH
         ul_data |= (uint32)pt_Config->s_OHRate2p[s_lp] << 8; //15:8 Tx_OH2Rate
         ul_data |= (uint32)pt_Config->s_OHRate1p[s_lp]; //7:0 Tx_OH1Rate

         ul_addr = ul_RegBaseAddr + ZT_OHRATE_OFFSET;
         WriteCoreReg(ul_addr, ul_data);

         // ZEP_PRAM_ZT_CRC_POLY0_LPx_ADDR
         ul_addr = ul_RegBaseAddr + ZT_CRC_POLY0_OFFSET;
         WriteCoreReg(ul_addr, 0x8e); //x^8 + x^4 + x^3 + x^2 + x^0

         // ZEP_PRAM_ZT_CRC_CTRL0_LPx_ADDR
         //WriteCoreReg(ZEP_PRAM_ZT_CRC_CTRL0_LP0_ADDR, 0); //1:0 CRC_Len, 0 = 8-bit CRC

         // ZEP_PRAM_ZT_SCR_POLY_LPx_ADDR
         if(gul_dbgShowtimeControl & DISABLE_ZEP_TX_SCRAMBLE)
         {
            ul_data = 0;
         }
         else
         {
            ul_data = 0x00420000;
         }

         ul_addr = ul_RegBaseAddr + ZT_SCR_POLY_OFFSET;
         WriteCoreReg(ul_addr, ul_data); //Polynomial has degrees 23 and 18

         // ZEP_PRAM_ZT_SCR_CTRL_LPx_ADDR
         ul_addr = ul_RegBaseAddr + ZT_SCR_CTRL_OFFSET;
         WriteCoreReg(ul_addr, 31); //4:0 SCR_Len

         // ZEP_PRAM_ZT_FIFO_BASE0_LPx_ADDR
         if(s_lp == LP0)
         {
            ul_data = ZEP_RAM_TX_LP0_OHFIFO0_OFFSET;   //17:0 FIFO_Base, the location in IIBRAM as byte address
            ul_data |= (uint32)(ZEP_RAM_OHFIFO_SIZE_64-1) << ZEP_REG_ZT_FIFO_SIZEX_POS; //26:19 FIFO_Size -1
         }
         else
         {
            ul_data = ZEP_RAM_TX_LP1_OHFIFO0_OFFSET;
            ul_data |= (uint32)(ZEP_RAM_OHFIFO_SIZE_32-1) << ZEP_REG_ZT_FIFO_SIZEX_POS; //26:19 FIFO_Size -1
         }

         ul_addr = ul_RegBaseAddr + ZT_FIFO_BASE0_OFFSET;
         WriteCoreReg(ul_addr, ul_data);
      }
//XDSLRTFW-1079 Feature_US_VDSL2_ALL_UsReTx(START)
      //if LP1 and ReTx Enabled
      if((s_lp == LP1) && (gt_ReTXParams.uc_UsReTxStatus == US_RETX_IN_USE))
      {
         // US_RETX Framing changes
         // ZEP_PRAM_ZT_FRAMING_LPx_ADDR
         ul_data = (uint32) 0x0 << 24; //31:24 Reserved
         ul_data |= (uint32)(pt_Config->s_Nfecp[s_lp] -  pt_Config->s_Rp[s_lp]- gt_ReTXParams.us_OPMS_UsPaddingPerDtu_V - 2 ) << 16; //23:16 H = Nfex - Rp; H - V - 2
         ul_data |= gt_ReTXParams.us_OPMS_UsPaddingPerDtu_V << 8;    //15:8  V - Num of Padded bytes
         ul_data |= (gt_ReTXParams.us_OPMS_UsCodeWordPerDtu_Q);   // 7:0  Q - No of CW's / DTU, +1 due to pre increment in micro code

         ul_addr = ul_RegBaseAddr + ZT_FRAMING_OFFSET;
         WriteCoreReg(ul_addr, ul_data);

         //ZEP_PRAM_ZT_R4_LPx_ADDR
         //initialize the SID and timestamp(TS) byte in the Register
         ul_data = (uint32)0 << 24; //31:24 Reserved
         ul_data |= (uint32)(0) << 16; //23:16 Loc to clear SID <Keep 0 val, don't change>
//             ul_data |= gs_UsretxSID1 << 8;    //15:8 Register Loc to generate SID (start from 0);
         ul_data |= 0x0 << 8;    //15:8 Register Loc to generate SID (start from 0);
         ul_data |= guc_TS_byte_Retx;      // 7:0  Time Stamp

         ul_addr = ul_RegBaseAddr + ZT_R4_OFFSET;
         WriteCoreReg(ul_addr, ul_data);
         //XDSLRTFW-1830 (START)
         ul_data = 0;
         ul_addr = ul_RegBaseAddr + ZT_R12_OFFSET;
         WriteCoreReg(ul_addr, ul_data);
         //XDSLRTFW-1830 (END)
         //RETX_QUEUE_BASE_ADDR
         //Initialize the WR pointer to the begining of the Queue
         //
         //ZEP_PRAM_ZT_ILVB_WRAD_LP0_ADDR           (uint32)(ZEP_PRAM_TX_LP0_START_ADDR +  ZT_ILVB_RDAD_OFFSET      )
         ul_addr = ul_RegBaseAddr + ZT_ILVB_WRAD_OFFSET;
         ul_data = gt_ReTXParams.ul_US_ReTXQueue_BaseAddress;
         WriteCoreReg(ul_addr, ul_data);

         //ZEP_PRAM_ZT_ILVB_RDAD_LP0_ADDR           (uint32)(ZEP_PRAM_TX_LP0_START_ADDR +  ZT_ILVB_RDAD_OFFSET      )
         ul_addr = ul_RegBaseAddr + ZT_ILVB_RDAD_OFFSET;
         //ul_data = gt_ReTXParams.ul_US_ReTXQueue_BaseAddress; //Added 8 for debug to have different address as compared to write address
         WriteCoreReg(ul_addr, ul_data);

         ul_addr = ul_RegBaseAddr + ZT_CRC_POLY0_OFFSET;
         WriteCoreReg(ul_addr, 0x0); //Disable CRC0
      }
//XDSLRTFW-1079 Feature_US_VDSL2_ALL_UsReTx(END)
   }
}


/*
*-------------------------------------------------------------------------------
*
*   Prototype: void LoadTxZepMicroCode(void)
*
*   This function configure the microcode registers and load the micro code to IIBRAM.
*
*   Input Arguments:
*       None
*
*   Output Arguments:
*       None
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/

extern int32 fci_prog_tx_vdsl2_bc0_lp1[];
extern int32 fci_prog_tx_vdsl2_bc0_lp0[];
extern int32 fci_prog_tx_vdsl2_bc1_lp0[];
extern int32 fci_prog_tx_vdsl2_bc1_lp1[];

void LoadTxZepMicroCode(void)
{
   uint32 ul_RegBaseAddr=0, ul_MicroCode_ToAddr=0;
   int32 *pla_MicroCode_fromAddr=NULL;
   int16 i, j;
   FlagT ft_CopyUcode = FALSE;
   uint8 uc_TxLp0UcodePage=0, uc_TxLp1UcodePage=0;
//XDSLRTFW-1048 Feature_US_VDSL2_ALL_UsReTx(START)
   // XDSLRTFW-1258_ZephyrConfig for US-SRA in US-ReTx mode (START)
   if (gs_TxState != R_SHOWTIME_TX)
   {
      // XDSLRTFW-1258_ZephyrConfig for US-SRA in US-ReTx mode (END)
      if (gt_ReTXParams.uc_UsReTxStatus == US_RETX_IN_USE)
      {
         uc_TxLp0UcodePage = VDSL_TX_LP0_RETX_UCODE_DM_SWAPPAGE;
         uc_TxLp1UcodePage = VDSL_TX_LP1_RETX_UCODE_DM_SWAPPAGE;
         //XDSLRTFW-1617 (Start)
         if(guc_ReTx_US_D > 1)
         {
            uc_TxLp1UcodePage = VDSL_TX_LP1_RETX_IDILV_UCODE_DM_SWAPPAGE;
            //XDSLRTFW-2341 (Start - End)
            gft_US_IDILV_ucode = TRUE;
         }
         //XDSLRTFW-1617 (End)
      }
      else
      {
         if (guc_ch_id ==0)
         {
            uc_TxLp0UcodePage = VDSL_TX_LP0_UCODE_DM_SWAPPAGE;
            uc_TxLp1UcodePage = VDSL_TX_LP1_UCODE_DM_SWAPPAGE;
         }
         else
         {
            uc_TxLp0UcodePage = VDSL_TX_PORT1_LP0_UCODE_DM_SWAPPAGE;
            uc_TxLp1UcodePage = VDSL_TX_PORT1_LP1_UCODE_DM_SWAPPAGE;
         }
      }
   }
   else
   {
      guc_TxDataPumpState = TX_ZEP_FC_WAIT_FOR_LP1_UCODE;
   }
//XDSLRTFW-1048 Feature_US_VDSL2_ALL_UsReTx(END)
   switch (guc_TxDataPumpState)
   {
   case TX_ZEP_FC_LOADING_LP0_UCODE:
      if ((guc_TxUcodeHandle = RequestSwap1(uc_TxLp0UcodePage, SWAP_TIMING_OFF)) != INVALID_CODESWAP_HANDLE)
      {
         guc_TxDataPumpState = TX_ZEP_FC_WAIT_FOR_LP0_UCODE;
      }

      break;

   case TX_ZEP_FC_WAIT_FOR_LP0_UCODE:

      if (PollForCodeSwapDone(uc_TxLp0UcodePage, guc_TxUcodeHandle) == SWAP_DONE)
      {
         FreeSwapHandle(&guc_TxUcodeHandle);

         if (guc_ch_id ==0)
         {
            // by overlay just the two Ucode arrays,
            // fci_prog_tx_vdsl2_bc0_lp0 and fci_prog_tx_vdsl2_bc0_lp0_retx will be linked at the same address
            pla_MicroCode_fromAddr = fci_prog_tx_vdsl2_bc0_lp0;
         }
         else
         {
            pla_MicroCode_fromAddr = fci_prog_tx_vdsl2_bc1_lp0;
         }

         ul_MicroCode_ToAddr = ZEP_RAM_TX_LP0_UCODE_ADDR;
         ul_RegBaseAddr = ZEP_PRAM_TX_LP0_START_ADDR;
         guc_TxDataPumpState = TX_ZEP_FC_LOADING_LP1_UCODE;
         ft_CopyUcode = TRUE;
      }
      break;

   case TX_ZEP_FC_LOADING_LP1_UCODE:
      if ((guc_TxUcodeHandle = RequestSwap1(uc_TxLp1UcodePage, SWAP_TIMING_OFF)) != INVALID_CODESWAP_HANDLE)
      {
         guc_TxDataPumpState = TX_ZEP_FC_WAIT_FOR_LP1_UCODE;
      }

      break;

   case TX_ZEP_FC_WAIT_FOR_LP1_UCODE:
      // XDSLRTFW-1258_ZephyrConfig for US-SRA in US-ReTx mode (START)
      if (gs_TxState != R_SHOWTIME_TX)
      {
         // XDSLRTFW-1258_ZephyrConfig for US-SRA in US-ReTx mode (START)
         if (PollForCodeSwapDone(uc_TxLp1UcodePage, guc_TxUcodeHandle) == SWAP_DONE)
         {
            FreeSwapHandle(&guc_TxUcodeHandle);
         }
         else
         {
            break;
         }
      }
      // by overlay just the two Ucode arrays,
      // fci_prog_tx_vdsl2_bc0_lp1 and fci_prog_rx_vdsl2_bc0_lp1_retx will be linked at the same address
      if(guc_ch_id ==0)
      {
         pla_MicroCode_fromAddr = fci_prog_tx_vdsl2_bc0_lp1;
      }
      else
      {
         pla_MicroCode_fromAddr = fci_prog_tx_vdsl2_bc1_lp1;
      }
      ul_MicroCode_ToAddr = ZEP_RAM_TX_LP1_UCODE_ADDR;
      //XDSLRTFW-1617 (Start_End)
      gul_TX_LP1_UCODE_ADDR = ul_MicroCode_ToAddr;
      ul_RegBaseAddr = ZEP_PRAM_TX_LP1_START_ADDR;
      guc_TxDataPumpState = TX_ZEP_FC_LOADING_UCODE_DONE;
      ft_CopyUcode = TRUE;

      break;
   }

   if (ft_CopyUcode)
   {

      uint32 ul_data, ul_addr;
      t_microcode_header *pt_header;
      uint32 ul_MicroCode_ToAddr_InLW;

      ul_MicroCode_ToAddr_InLW = ul_MicroCode_ToAddr >> 2;
      pt_header = (t_microcode_header*)(void *)pla_MicroCode_fromAddr;
      //Refer to CMV INFO 54 in Message Catalog ver 2.9 or newer for format
      //Load Tx Microcode version number
      gusa_FW_version_number[4] = (uint16)(pt_header->version & 0xFFFF); //XDSLRTFW-3364 (Start_End)


      // ZEP_PRAM_ZT_FLAG_CTRLx_LPx_ADDR
      WriteCoreReg((ul_RegBaseAddr+ZT_FLAG_CTRL0_OFFSET), pt_header->flags0);
      WriteCoreReg((ul_RegBaseAddr+ZT_FLAG_CTRL1_OFFSET), pt_header->flags1);

      // ZEP_PRAM_ZT_UPROC_ENA_LPx_ADDR
      WriteCoreReg((ul_RegBaseAddr+ZT_UPROC_ENA_OFFSET), pt_header->uproc_ena);
   // For Micro processor 0 to 4 use PRAM offset from ZT_UPROC01_BASE_OFFSET
   // from 5 to 9 use the offset from ZT_UPROC5_BASE_OFFSET_35B
   // Don't combine the base address of 2 micro processors for VRX518 as we are doing for VRX218 &
   // 318 platforms.
      // Write to ZEP_PRAM_ZT_UPROCxy_BASE_LPx_ADDR, where xy = 01, 23, 45, 67, 89
      {
         ul_addr = ul_RegBaseAddr+ZT_UPROC01_BASE_OFFSET;

         for(i=0; i<NUM_OF_UPROCESSORS; i++)
         {
            ul_data = ul_MicroCode_ToAddr_InLW + (pt_header->engine[i]).base;
            WriteCoreReg(ul_addr, ul_data);
            if (i == 4)
            {
               ul_addr = ul_RegBaseAddr+ZT_UPROC5_BASE_OFFSET_35B;
            }
            else
            {
               ul_addr += 4;
            }
         }
      }

      // ZEP_PRAM_ZT_UPROC_INT_LPx_ADDR - Initialize to 0.

      // Write to ZEP_PRAM_ZT_UPROCy_STATEx_LPx_ADDR, y=0,..9, x=0,..,4
      {
         ul_addr = ul_RegBaseAddr + ZT_UPROC0_STATE0_OFFSET;

         //Loop through all micro-processors (total of 9)
         for(i=0; i<NUM_OF_UPROCESSORS; i++)
         {
            for(j=0; j<NUM_OF_UPROC_STATES; j++)
            {
               WriteCoreReg(ul_addr, pt_header->engine[i].state[j]);
               ul_addr += 4;
            }
         }
      }

      //XDSLRTFW-3334(Start)
      //Initialize Internal state of Framing processors and don't need to reload the micro code executables
      //once more in showtime. This is done to save MIPS.
      //This logic is generalized for profiles <=17a and 35b without iDTU interleaving.
      if ((gft_US_IDILV_ucode == FALSE) && (gs_TxState == R_SHOWTIME_TX))
      {
         return;
      }
      //XDSLRTFW-3334(End)

      // Now Copy down microCode.
      {
         void *ptr_mcode;

         //Compute the number of 32-bit words in the header
         i = sizeof(t_microcode_header)/4;

         //Point to the first word following the header
         ptr_mcode = (void *) &pla_MicroCode_fromAddr[i];

         //Load micro-code
         ul_addr = ZEP_RAM_IIBRAM_ADDR + ul_MicroCode_ToAddr;
         //XDSLRTFW-2577 (Start)
         //MIPs optimization: Start DMA transfer of Micro code. Don't wait for its completion, continue
      //with other TC tasks
         {
            uint32 ul_StartAddr = (uint32)(ptr_mcode);
            uint32 ul_EndAddr = (uint32)((uint16 *)ptr_mcode+(2*pt_header->total_lines - 1));
            SetUpDMATransfer(ul_StartAddr, ul_EndAddr, ul_addr, 0, 0, 0);
         }
         //XDSLRTFW-2577 (End)
      }
   }

}

/*
*-------------------------------------------------------------------------------
*
*   Prototype: void ConfigZephyrIlvTxPath_VDSL2(void)
*
*   This function initializes Zephyr-ILV core for showtime TX path operations.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/


void ConfigZephyrIlvTxPath_VDSL2(void)
{
   //XDSLRTFW-1617 (Start_End)
   uint32 ul_data, ul_addr, ul_RegBaseAddr,ul_temp;
   int16 s_lp, s_bitsinLp;
   int16 s_lpInit = LP0;
   uint16 us_TransferSize[NUM_DATA_PATHS];
   int32 l_ilvSize;
   VDSL2Config_t *pt_Config;

   // all TX registers are cleared in InitZephyr()

   // map the TX parameter structure
   pt_Config = &gt_tx_config_v2;

   ///////////////////////////////////////////
   // GLOBAL REGISTERS INITIALIZATION START //
   ///////////////////////////////////////////

   // ZEP_REG_ZT_DT_SIZE_ADDR
   // ZEP_REG_ZT_PMS_SIZE_ADDR
   // The two registers are initialized with the same parameter.
   // XDSLRTFW-1258_ZephyrConfig for US-SRA in US-ReTx mode (START)
   if(gs_TxState != R_SHOWTIME_TX)
   {
      // XDSLRTFW-1258_ZephyrConfig for US-SRA in US-ReTx mode (END)
      for (s_lp=s_lpInit; s_lp< NUM_DATA_PATHS; s_lp++)
      {
         us_TransferSize[s_lp] = (uint16)(pt_Config->ul_Lp[s_lp] >> 3);
         s_bitsinLp = (int16)(pt_Config->ul_Lp[s_lp] - (uint32)(us_TransferSize[s_lp] << 3));
         // transfer size = ceil(Lp/8) bytes
         if (s_bitsinLp)
         {
            us_TransferSize[s_lp]++;
         }
      }
      ul_data = (uint32)us_TransferSize[LP0]; //15:0 LP0 DT Size
      ul_data |= ((uint32)us_TransferSize[LP1]) << 16; //31:16 LP1 DT Size
      WriteCoreReg(ZEP_REG_ZT_DT_SIZE_ADDR, ul_data);
      WriteCoreReg(ZEP_REG_ZT_PMS_SIZE_ADDR, ul_data);
      gul_DTBLOOP_lastTxSize = ul_data;  // this line needed for lpbk1 test only.

      // ZEP_REG_ZT_DTB_OFFSET_ADDR
      WriteCoreReg(ZEP_REG_ZT_DTB_OFFSET_ADDR, gs_ZEP_ILV_RAM_TXDTB_OFFSET);
   }
   else
   {
      s_lpInit = LP1;               // In showtime, ReTx updates only LP1.
   }

   ///////////////////////////////////////////
   // PER LP REGISTERS INITIALIZATION START //
   ///////////////////////////////////////////
   for(s_lp=s_lpInit; s_lp< NUM_DATA_PATHS; s_lp++)
   {
      if(s_lp == LP0)
      {
         ul_RegBaseAddr = ZEP_PRAM_TX_LP0_START_ADDR;
      }
      else //(s_lp == LP1)
      {
         ul_RegBaseAddr = ZEP_PRAM_TX_LP1_START_ADDR;
      }

      // XDSLRTFW-1258_ZephyrConfig for US-SRA in US-ReTx mode (START)
      if(gs_TxState != R_SHOWTIME_TX)
      {
         // XDSLRTFW-1258_ZephyrConfig for US-SRA in US-ReTx mode (END)
         // ZEP_PRAM_ZR_DTB_CTRL_LPx_ADDR
         if(s_lp == LP0)
         {
            ul_data = (gs_ZEP_ILV_RAM_TXDTB_LP0_SIZE-1) << 16; //27:16 DTB_Size - actual number of words - 1
            ul_data |= ZEP_ILV_RAM_TXDTB_LP0_BASE; //11:0 DTB_Base in 32-bit words, For 35B Base is from <12:0>
         }
         else //(s_lp == LP1)
         {
            ul_data = (gs_ZEP_ILV_RAM_TXDTB_LP1_SIZE-1) << 16; //27:16 DTB_Size - actual number of words - 1
            ul_data |= ZEP_ILV_RAM_TXDTB_LP1_BASE; //11:0 DTB_Base in 32-bit words, For 35B Base is from <12:0>
         }

         ul_addr = ul_RegBaseAddr + ZT_DTB_CTRL_OFFSET;
         WriteCoreReg(ul_addr, ul_data);

         // ZEP_ZT_QTDTB_CONFIG_LPx_ADDR

         ul_addr = ZEP_REG_ZT_QTDTB_CONFIG_LP0_ADDR + (s_lp<<2);
         WriteCoreReg(ul_addr, ul_data);

         // ZEP_PRAM_ZT_ILV_BASE0_LPx_ADDR
         ul_addr = ul_RegBaseAddr + ZT_ILV_BASE0_OFFSET;
         WriteCoreReg(ul_addr, gula_txILVBaseAddr[s_lp]);
      //XDSLRTFW-2341 (Start)
      }
      //XDSLRTFW-1617 (Start)
      if(gft_US_IDILV_ucode && ((s_lp == LP1)))
      {
      //XDSLRTFW-2341 (End)
         //XDSLRTFW-3020 (Start)
         //XDSLRTFW-3189 (Start)
         //XDSLRTFW-3322 (Start)
         if (gs_DTU_size > gus_MaxDTUSizeUS_iDTU)
         {
            //Call exception handler if actual DTU size > estimated US max DTU size.
            //Since memory allocation is done based on the gus_MaxDTUSizeUS_iDTU.
            EnterFailStates(E_CODE_US_iDTU_SIZE_EXCEED_ESTIMATED_MAX_iDTU_SIZE);
         }
         //XDSLRTFW-3322 (End)
         l_ilvSize = gus_MaxDTUSizeUS_iDTU;  //Worst case RS overhead is already taken care in "gus_MaxDTUSizeUS_iDTU"
         //XDSLRTFW-3189 (End)

         ul_addr = ul_RegBaseAddr + ZT_ILV_BASE0_OFFSET;
         ul_temp = gula_txILVBaseAddr[LP1];
         ul_temp = (ul_temp + 3) & 0xFFFFFFFC;
         WriteCoreReg(ul_addr, ul_temp);  //BASE0 configuration

         ul_temp += l_ilvSize;
         ul_temp = (ul_temp + 3) & 0xFFFFFFFC;
         ul_addr = ul_RegBaseAddr + ZT_ILV_BASE1_OFFSET;
         WriteCoreReg(ul_addr, ul_temp); //BASE1 configuration
         //XDSLRTFW-3020 (End)

         gl_UsReTxBufWrRunningAddr = gt_ReTXParams.ul_US_ReTXQueue_BaseAddress;
         gl_UsReTxBufEndAddr = gt_ReTXParams.ul_US_ReTXQueue_BaseAddress + (gs_DTU_size * gt_ReTXParams.us_OPMS_UsQtx)-1;
         //ZEP_PRAM_ZT_ILVB_WRAD_LP0_ADDR           (uint32)(ZEP_PRAM_TX_LP0_START_ADDR +  ZT_ILVB_RDAD_OFFSET      )
         ul_addr = ul_RegBaseAddr + ZT_ILVB_WRAD_OFFSET;
         ul_data = gt_ReTXParams.ul_US_ReTXQueue_BaseAddress;
         WriteCoreReg(ul_addr, ul_data);

         //ZEP_PRAM_ZT_ILVB_RDAD_LP0_ADDR           (uint32)(ZEP_PRAM_TX_LP0_START_ADDR +  ZT_ILVB_RDAD_OFFSET      )
         ul_addr = ul_RegBaseAddr + ZT_ILVB_RDAD_OFFSET;
         //ul_data = gt_ReTXParams.ul_US_ReTXQueue_BaseAddress; //Added 8 for debug to have different address as compared to write address
         WriteCoreReg(ul_addr, ul_data);

      }
      //XDSLRTFW-1617 (End)

      // ZEP_REG_ZT_ILV_PARAMS0_LPx_ADDR
      ul_data = (uint32) Find_Pmd_Step(pt_Config->s_Dp[s_lp] , pt_Config->s_Ip[s_lp] );
      ul_data <<= 16;
      ul_data |= 1<<24; //pms_step =1
      ul_data |= (uint32)(pt_Config->s_Ip[s_lp] <<8); //7:0
      ul_data |= 4 ; //  efficient interleaver

      ul_addr = ul_RegBaseAddr + ZT_ILV_PARAMS0_OFFSET;
      WriteCoreReg(ul_addr, ul_data);
      //XDSLRTFW-1617 (Start)
      //XDSLRTFW-2341 (Start - End)
      if(gft_US_IDILV_ucode && ((s_lp == LP1)))
      {
         ul_data = ((ul_data & ~0xffff00ff) | 0x6); //Block De interleaver
         WriteCoreReg(ul_addr, ul_data);
         ul_addr = ul_RegBaseAddr + ZT_ILV_PARAMS1_OFFSET;
         WriteCoreReg(ul_addr, ul_data);
      }
      //XDSLRTFW-1617 (End)


      // ZEP_PRAM_ZT_ILV_SIZE0_LPx_ADDR

      // set totalFifo delay to D - M - 1, where  M = floor(D/I)
      if ( pt_Config->s_Ip[s_lp] == 0 )
      {
         l_ilvSize = 0;
      }
      else
      {
         uint32 x;
         x = pt_Config->s_Dp[s_lp] / pt_Config->s_Ip[s_lp] ;

         // Special case
         if (pt_Config->s_Dp[s_lp] == 1)
         {
            x = 0;
         }

         l_ilvSize = (pt_Config->s_Dp[s_lp] - x - 1)& 0xFFFF;
      }

      if (l_ilvSize < 0)
      {
         l_ilvSize = 0;
      }

      //TX EXT is always 2
      ul_addr = ul_RegBaseAddr + ZT_ILV_SIZE0_OFFSET;
      WriteCoreReg(ul_addr, (uint32)( (2 <<16) | l_ilvSize ));

      // ZEP_PRAM_ZT_FULLNESS_LPx_ADDR
      // Min Fullness, Init to 0
      //WriteCoreReg(ZEP_PRAM_ZT_ILV_MIN_FULLNESS0_LP0_ADDR, 0);

      //Max Fullness set to I
      ul_addr = ul_RegBaseAddr + ZT_ILV_MAX_FULLNESS0_OFFSET;
      WriteCoreReg(ul_addr, (uint32)(pt_Config->s_Ip[s_lp]));

      //XDSLRTFW-1617 (Start)
      //XDSLRTFW-2341 (Start - End)
      if(gft_US_IDILV_ucode && ((s_lp == LP1)))
      {
         ul_addr = ul_RegBaseAddr + ZT_ILV_SIZE0_OFFSET;
         l_ilvSize =(uint32) (gt_tx_config_v2.s_Nfecp[LP1]) *(gt_ReTXParams.us_OPMS_UsCodeWordPerDtu_Q);
         WriteCoreReg(ul_addr, l_ilvSize);
         ul_addr = ul_RegBaseAddr + ZT_ILV_SIZE1_OFFSET;
         WriteCoreReg(ul_addr, l_ilvSize);

         ul_addr = ul_RegBaseAddr + ZT_ILV_MIN_FULLNESS0_OFFSET;
         WriteCoreReg(ul_addr, l_ilvSize);
         ul_addr = ul_RegBaseAddr + ZT_ILV_MIN_FULLNESS1_OFFSET;
         WriteCoreReg(ul_addr, l_ilvSize);



         ul_addr = ul_RegBaseAddr + ZT_ILV_MAX_FULLNESS0_OFFSET;
         WriteCoreReg(ul_addr, l_ilvSize);

         ul_addr = ul_RegBaseAddr + ZT_ILV_MAX_FULLNESS1_OFFSET;
         WriteCoreReg(ul_addr, l_ilvSize );

         ul_addr = ul_RegBaseAddr + ZT_ILV_CNTRS0_OFFSET;
         WriteCoreReg(ul_addr,0);
         ul_addr = ul_RegBaseAddr + ZT_ILV_CNTRS1_OFFSET;
         WriteCoreReg(ul_addr,0);
         ul_addr = ul_RegBaseAddr + ZT_ILV_PMS_CNTRS0_OFFSET;
         WriteCoreReg(ul_addr,0);
         ul_addr = ul_RegBaseAddr + ZT_ILV_PMS_CNTRS1_OFFSET;
         WriteCoreReg(ul_addr,0);
         ul_addr = ul_RegBaseAddr + ZT_ILV_PMD_CNTRS0_OFFSET;
         WriteCoreReg(ul_addr,0);
         ul_addr = ul_RegBaseAddr + ZT_ILV_PMD_CNTRS1_OFFSET;
         WriteCoreReg(ul_addr,0);
      }
      //XDSLRTFW-1617 (End)

      // ZEP_PRAM_ZT_DEPTH_LPx_ADDR
      ul_data = (uint32)pt_Config->s_Dp[s_lp] << 16; //D_Shadow
      ul_data |= (uint32)pt_Config->s_Dp[s_lp]; // D
      ul_addr = ul_RegBaseAddr + ZT_DEPTH_OFFSET;
      WriteCoreReg(ul_addr, ul_data);

   } //for (s_lp=0;s_lp< NUM_DATA_PATHS; s_lp++)

   // XDSLRTFW-1258_ZephyrConfig for US-SRA in US-ReTx mode (START)
   if(gs_TxState != R_SHOWTIME_TX)
   {
      // XDSLRTFW-1258_ZephyrConfig for US-SRA in US-ReTx mode (END)
      // LP2 config
      ul_data = (uint32)(gs_ZEP_ILV_RAM_TXDTB_LP2_SIZE-1) << 16; //27:16 DTB_Size - actual number of words - 1
      ul_data |= ZEP_ILV_RAM_TXDTB_LP2_BASE; //11:0 DTB_Base in 32-bit words
      WriteCoreReg(ZEP_REG_ZT_QTDTB_CONFIG_LP2_ADDR, ul_data);
//XDSLRTFW-1052 Feature_US_VDSL2_ALL_UsReTx_WrTCtoILV_RdILVtoDTB (Start)
      if (gt_ReTXParams.uc_UsReTxStatus == US_RETX_IN_USE)
      {
         UsReTx_WrTCtoILV_RdILVtoDTB(us_TransferSize[LP1]);
      }
//XDSLRTFW-1052 Feature_US_VDSL2_ALL_UsReTx_WrTCtoILV_RdILVtoDTB (End)
   }

}


#ifdef INCLUDE_CACHE_FUNCTIONS

/*
*-------------------------------------------------------------------------------
*
*   Prototype: int32 CalcActIlvMem(VDSL2Config_t *pt_Config, int16 s_lp)
*
*   This function computes the interleaving memory required for the giving
*   framing parameters. The equation used to compute the interleaving size
*   is given below:
*
*   fifo_ext = q+1 for RX and 1 for TX
*   total_fifo_delay = max (0, (D-M-1)), where M = floor(D/I)
*   row_width = total_fifo_delay + 2*fifo_ext
*   ilv_mem_size = row_width * (I/2) + ((I is odd)? row_width/2+1, 0)
*
*   Input Arguments:
*      pt_Config -- pointer to the structure containing the framing parameters
*       s_lp -- interleave path to be used
*
*   Output Arguments:
*
*   Returns:
*      the required interleaving memory size in bytes
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/

int32 CalcActIlvMem(VDSL2Config_t *pt_Config, int16 s_lp, FlagT ft_TxRxIndicator)
{
   int16 s_D, s_I, s_q, s_M;
   int16 s_total_fifo_delay, s_row_width;
   int32 l_ilv_size;

   s_D = pt_Config->s_Dp[s_lp];
   s_I = pt_Config->s_Ip[s_lp];
   s_q = pt_Config->s_q[s_lp];

   //Compute total_fifo_delay = max(0,(D-M-1)), where M = floor(D/I)
   s_total_fifo_delay = 0;
   if(s_I > 0)
   {
      s_M = floor32((int32)s_D, s_I);
      s_total_fifo_delay = s_D - s_M - 1;
      if(s_total_fifo_delay < 0)
      {
         s_total_fifo_delay = 0;
      }
   }

   //Compute row_width = total_fifo_delay + 2*fifo_ext = total_fifo_delay + 2*(q+1)
   if(ft_TxRxIndicator == RX)
   {
      s_q += 1;
   }
   else
   {
      s_q = 2;
   }

   s_row_width = s_total_fifo_delay + (s_q<<1);

   //Compute ilv_mem_size = row_width * (I/2) + ((I is odd)? row_width/2+1, 0)

   MULS16(l_ilv_size, s_row_width, (int16)(s_I>>1));

   //If I is odd
   if(s_I&1)
   {
      l_ilv_size += ((s_row_width>>1) + 1);
   }

   return(l_ilv_size);

} //CalcActIlvMem()

/*
*-------------------------------------------------------------------------------
*
*   Prototype: uint16 ConfigZephyrIlvTxIFM_VDSL2(void)
*
*   This function configures Zephyr-ILV TX Interleave FIFO Management buffers
*   (IFB, IFWP, IFRP). This function can be called from FG or BG as long as
*   Zephyr-ILV block is not enabled.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*      *pus_FifoBaseAddr: size of ILVB used
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/

uint32 ConfigZephyrIlvTxIFM_VDSL2(void)
{
   VDSL2Config_t *pt_Config;
   uint32 ul_mem_size;
   int16 s_lp;

   s_lp = guc_data_path_tx;

   // map the RX parameter structure
   pt_Config = &gt_tx_config_v2;

   //Compute the actual interleave memory usage
   ul_mem_size = CalcActIlvMem(pt_Config, s_lp, TX);

   // check if computed DILV size is less than HW limit
   if(ul_mem_size > gul_HW_ILV_MEM_SIZE[s_lp])
   {
      return(0);
   }
   else
   {
      return(ul_mem_size);
   }
}


/*
*-------------------------------------------------------------------------------
*
*   Prototype: uint16 ConfigZephyrIlvRxDFM_VDSL2(void)
*
*   This function configures Zephyr-ILV RX Deinterleave FIFO Management buffers
*   (DFB, DFWP, DFRP). This function can be called from FG or BG as long as
*   Zephyr-ILV block is not enabled.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*      *pus_FifoBaseAddr: size of DILVB used
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/


uint32 ConfigZephyrIlvRxDFM_VDSL2(void)
{
   VDSL2Config_t *pt_Config;
   uint32 ul_mem_size;
   int16 s_lp;

   s_lp = guc_data_path_rx;

   // map the RX parameter structure
   pt_Config = &gt_rx_config_v2;

   //Compute the actual deinterleave memory usage
   ul_mem_size = CalcActIlvMem(pt_Config, s_lp, RX);

   // check if computed DILV size is less than HW limit
   if(ul_mem_size > gul_HW_DILV_MEM_SIZE[s_lp])
   {
      return(0);
   }
   else
   {
      return(ul_mem_size);
   }

}


#endif //#ifdef INCLUDE_CACHE_FUNCTIONS
