/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2007 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;   Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;   Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;   File Name: V_STR_IIR_IOf.c
;
;   VDSL Strymon CO/CPE core IIR interface functions
;
*****************************************************************************/

// ***********************************************************************************************************
// V_STR_IIR_IOf.c
//
// History
//
// 20/08/2018: Sriram Shastry : XDSLRTFW-232-Coding/decoding of US- and DS-tssi in O-PRM and R-PRM not correct
// 1. Performance optimization is done up to now only for US0 oPOTS configuration (US0-spectrum: tone 6-32)
// 2. If US oPOTS is used we force the out-of-band TSSI values for the CO TDQ training phase to: ...
//    Lower OOB tone Idx (0,4 are shaped with 6.0dB dB TxATTEN ) and  Upper OOB tone idx (36 =-0.0 dB &
//    tone idx 54 = -62.0 dB) TxATTEN is applied).
// 3. All other modes still use the old code
// 4. Added  new Tx IIR filter for  ISI optimization
// 5. Upstream performance optimization is  controlled by cmv. TEST 49 BITMASK- 9. Enabled by default
// Grep for XDSLRTFW-232
//
// ***********************************************************************************************************


#include "common.h"
#include "gdata.h"
#include "LL_IOf.h"
#include "cmv.h"
#include "cri_memmap.h"
#include "afeif_memmap.h"
#include "str_memmap.h"
#include "v_str_src_ini.h"
#include "V_STR_IOf.h"
#include "V_STR_IIR_IOf.h"

// XDSLRTFW-3352 since the filter designed for US0 only transmission has indeed a much higher group delay compared
//               to the one that is intended to be used for transmission of the full 17a profile.
//               For Any new Tx filter added,check the group delay of the filter and adjust the value of gsa_TimingAdvanceFixedDelay accordingly!
// XDSLRTFW-3737 VRx518 - Group delay for new US0 only TxIIR filters must be adapted for 35b profile (TimingAdvance)
// TxIIR : OPTN_POTS_Filter_Select                  0x0001  group delay = 218 to 3 (Tone6  to end); In/OutRate = 35MHZ -> transform to IFFT = 35MHZ -> ceil(3) = 3 IFFT sample
// TxIIR : OPTN_POTS_DOUBLE_Filter_Select           0x0002  group delay = 230 to 3 (Tone6  to end); In/OutRate = 35MHZ -> transform to IFFT = 35MHZ -> ceil(3) = 3 IFFT sample
// TxIIR : OPTN_ISDN_Filter_Select                  0x0003  group delay = 178 to 3 (Tone32 to end); In/OutRate = 35MHZ -> transform to IFFT = 35MHZ -> ceil(3) = 3 IFFT sample
#define OPTN_POTS_Filter_Select_GROUPDELAY                  3
#define OPTN_POTS_DOUBLE_Filter_Select_GROUPDELAY           3
#define OPTN_ISDN_Filter_Select_GROUPDELAY                  3
// TxIIR : OPTN_35B_VDSL_Filter_Select              0x0004
//       : OPTN_35B_VDSL_POTS_DOUBLE_Filter_Select  0x0005
//       : OPTN_35B_VDSL_ISDN_Filter_Select         0x0006
#define OPTN_35B_VDSL_Filter_Select_GROUPDELAY              3
#define OPTN_35B_VDSL_POTS_DOUBLE_Filter_Select_GROUPDELAY  3
#define OPTN_35B_VDSL_ISDN_Filter_Select_GROUPDELAY         3

// TxIIR : OPTN_POTS_LP_Filter_Select               0x0007  group delay = 340 to 168 (middle 121) (Tone6  to 32); In/OutRate = 35MHZ -> transform to IFFT = 35MHZ -> ceil(3) = 3 IFFT sample
#define OPTN_POTS_LP_Filter_Select_GROUPDELAY               121
// TxIIR : OPTN_ISDN_LP_Filter_Select               0x0008  group delay = 151 to 363 (middle 91) (Tone6  to 32); In/OutRate = 35MHZ -> transform to IFFT = 35MHZ -> ceil(3) = 3 IFFT sample
#define OPTN_ISDN_LP_Filter_Select_GROUPDELAY               91
// TxIIR : OPTN_POTS_DOUBLE_LP_Filter_Select        0x0009  group delay = 337 to 370 (middle 60) (Tone6  to 32); In/OutRate = 35MHZ -> transform to IFFT = 35MHZ -> ceil(3) = 3 IFFT sample
#define OPTN_POTS_DOUBLE_LP_Filter_Select_GROUPDELAY        61
// TxIIR : OPTN_POTS_QUAD_LP_Filter_Select          0x000A  group delay = 323 to 213 (middle 31) (Tone6  to 32); In/OutRate = 35MHZ -> transform to IFFT = 35MHZ -> ceil(3) = 3 IFFT sample
#define OPTN_POTS_QUAD_LP_Filter_Select_GROUPDELAY          31

// TxIIR : OPTN_35B_POTS_LP_Filter_Select           0x000B  group delay = 102 to 520             (Tone6  to 32); In/OutRate = 35MHZ/70MHz -> transform to IFFT = 35MHZ -> ceil(group delay/2) IFFT sample
// TxIIR : OPTN_35B_ISDN_LP_Filter_Select           0x000C  group delay = 298 to 142 (middle 98) (Tone32 to 64); In/OutRate = 35MHZ/70MHz -> transform to IFFT = 35MHZ -> ceil(group delay/2) IFFT sample
// TxIIR : OPTN_35B_POTS_DOUBLE_LP_Filter_Select    0x000D  group delay = 54 to 191              (Tone6  to 64); In/OutRate = 35MHZ/70MHz -> transform to IFFT = 35MHZ -> ceil(group delay/2) IFFT sample
//       : OPTN_35B_POTS_QUAD_LP_Filter_Select      0x000E
// Note: Due to the big range it is not clear what value should be used.
//       Probable most sense is to use an average of the higher US0 tones.
#define OPTN_35B_POTS_LP_Filter_Select_GROUPDELAY           121
#define OPTN_35B_ISDN_LP_Filter_Select_GROUPDELAY           61
#define OPTN_35B_POTS_DOUBLE_LP_Filter_Select_GROUPDELAY    43       // TxIIR (Tone 40) = ceil(85/2) = 43;
#define OPTN_35B_POTS_QUAD_LP_Filter_Select_GROUPDELAY      61


/*******************************************************************************
*
*   Prototype: void UnityTxIIR(void)
*
*   This function sets the Strymon's Tx IIR filter to a unit impulse.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*******************************************************************************/

void UnityTxIIR(void)
{
   uint32 ul_data;

   // Set TXIIR_IN_RATE
   ul_data = (gs_TxLog2IfftLength - 7);
   if ((gt_ProfileAct.us_ProfileSelected & (CNFG_V2_PROFILE_30A_MASK | CNFG_V2_PROFILE_35B_MASK )) &&
       (gs_TxLog2IfftLength <= US_LOG2_FFT_LENGTH_8192))
   {
      ul_data += 1;
   }
   ul_data = (ul_data << 20);

   // Set it in bypass mode
   ul_data |= TXIIR_BYPASS;
   WriteCoreReg((uint32)(V_TXIIR1_CFG_ADDR), ul_data);

} //void UnityTxIIR(void)

/*******************************************************************************
*
*   Prototype: void LoadTxIIR(void)
*
*   This function loads the Strymon's Tx IIR filter to desired filter.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*******************************************************************************/
    // XDSLRTFW-3737 (Start_End)
// Note: All code in fct. "LoadTxIIR" belonging to varibale "gs_TimingAdvanceTxIirDelay".
void LoadTxIIR(void)
{
   int16 s_FilterControl,s_FilterSelect;

   s_FilterControl = gsa_Optn4_FilterControl[OPTN_4_IDX1_FILTER_CTRL];
   s_FilterSelect = gs_TxIIRFilterSelect;
   gs_TimingAdvanceTxIirDelay = 0;           // Bypass

   // Note: The below mentioned method is used:
   // Method for changing filter coefficients and/or scaling factors is
   // to place the individual block in bypass mode, then change the filter coefficients
   // and/or scaling factors, then clear the block level bypass bit.
// Note: The correct sequence leads to sporadic "bad SNR" links. Until it is not checked with HW people
//       the old implementation will be used!
//   UnityTxIIR();

   if(gs_STR_DbgCntl & STR_DBG_CNTL_DISABLE_TXIIR)
   {
      // Set global variable to bypass mode
      gs_TxIIRFilterSelect = OPTN_BYPASS_Filter_Select;
      // Set local variable to bypass mode
      s_FilterSelect = OPTN_BYPASS_Filter_Select;
      s_FilterControl = OPTN_Tx_Filter_Enable;
   }

   // Filters are switched on by setting bits in OPTN 4
   if (s_FilterControl & OPTN_Tx_Filter_Enable)
   {
      switch (s_FilterSelect)
      {
         //Since we only have one filter design now
         //so we map all three CMVs into this one
      case OPTN_POTS_Filter_Select:
         // VDSL_CPE POTS Tx Filter, with HPF and bandstop sections.
         //the filter is not used for 30 MHz profile
         {
            if(!(gt_ProfileAct.us_ProfileSelected & CNFG_V2_PROFILE_30A_MASK))
            {
               TxLoadIir(gula_TxIIR_POTS_17M_Filter);
               gt_PSDCompData.us_TxIIRFilter = OPTN_POTS_Filter_Select; //XDSLRTFW-2059
               gs_TimingAdvanceTxIirDelay = OPTN_POTS_Filter_Select_GROUPDELAY;
            }
         }
         break;

      case OPTN_POTS_DOUBLE_Filter_Select:
         // VDSL_CPE POTS Tx Filter, with HPF and bandstop sections with double US0 band
         {
            if(!(gt_ProfileAct.us_ProfileSelected & CNFG_V2_PROFILE_30A_MASK))
            {
               TxLoadIir(gula_TxIIR_POTS_DOUBLE_17M_Filter);
               gt_PSDCompData.us_TxIIRFilter = OPTN_POTS_DOUBLE_Filter_Select; //XDSLRTFW-2059
               gs_TimingAdvanceTxIirDelay = OPTN_POTS_DOUBLE_Filter_Select_GROUPDELAY;
            }
         }
         break;

      case OPTN_ISDN_Filter_Select:
         // VDSL_CPE POTS Tx Filter, with HPF and bandstop sections.
         //the filter is not used for 30 MHz profile
         {
            if(!(gt_ProfileAct.us_ProfileSelected & CNFG_V2_PROFILE_30A_MASK))
            {
               TxLoadIir(gula_TxIIR_ISDN_17M_Filter);
               gt_PSDCompData.us_TxIIRFilter = OPTN_ISDN_Filter_Select; //XDSLRTFW-2059
               gs_TimingAdvanceTxIirDelay = OPTN_ISDN_Filter_Select_GROUPDELAY;
            }
         }
         break;

      case OPTN_35B_VDSL_Filter_Select:
         //For 35b used same filter for POTS and Annex M;
         TxLoadIir(gula_TxIIR_LP_17MHz_VDSL35B);
         gt_PSDCompData.us_TxIIRFilter = OPTN_35B_VDSL_Filter_Select;
         gs_TimingAdvanceTxIirDelay = OPTN_35B_VDSL_Filter_Select_GROUPDELAY;
         break;

      // XDSLRTFW-3715 Start
      case OPTN_35B_VDSL_POTS_DOUBLE_Filter_Select:
         //For 35b mode, used same filter for POTS and Annex M;
         TxLoadIir(gula_TxIIR_LP_17MHz_VDSL35B);
         gt_PSDCompData.us_TxIIRFilter = OPTN_35B_VDSL_POTS_DOUBLE_Filter_Select;
         gs_TimingAdvanceTxIirDelay = OPTN_35B_VDSL_POTS_DOUBLE_Filter_Select_GROUPDELAY;
         break;

      case OPTN_35B_VDSL_ISDN_Filter_Select:
         //For 35b mode, used seperate filter for ISDN
         TxLoadIir(gula_TxIIR_isdn_17MHz_VDSL35B);
         gt_PSDCompData.us_TxIIRFilter = OPTN_35B_VDSL_ISDN_Filter_Select;
         gs_TimingAdvanceTxIirDelay = OPTN_35B_VDSL_ISDN_Filter_Select_GROUPDELAY;
         break;
      // XDSLRTFW-3715 End

      //---- filter in case only US0 is indicated ----
      case OPTN_POTS_LP_Filter_Select:
         // filter in case only US0 is indicated
         TxLoadIir(gula_Strymon_TxIir_us0_only_A_poco_XdB_VDSL17_ISIOptimized);//XDSLRTFW-3352 & XDSLRTFW-232(Start_End)
         gt_PSDCompData.us_TxIIRFilter = OPTN_POTS_LP_Filter_Select; //XDSLRTFW-2059
         gs_TimingAdvanceTxIirDelay = OPTN_POTS_LP_Filter_Select_GROUPDELAY;
         break;

      case OPTN_ISDN_LP_Filter_Select:
         // filter in case only US0 is indicated
         TxLoadIir(gula_Strymon_TxIir_us0_only_B_poco_XdB_VDSL17);
         gt_PSDCompData.us_TxIIRFilter = OPTN_ISDN_LP_Filter_Select;
         gs_TimingAdvanceTxIirDelay = OPTN_ISDN_LP_Filter_Select_GROUPDELAY;
         break;

      case OPTN_POTS_DOUBLE_LP_Filter_Select:
         // filter in case only US0 is indicated
         TxLoadIir(gula_Strymon_TxIir_us0_only_M_poco_XdB_VDSL17);
         gt_PSDCompData.us_TxIIRFilter = OPTN_POTS_DOUBLE_LP_Filter_Select;
         gs_TimingAdvanceTxIirDelay = OPTN_POTS_DOUBLE_LP_Filter_Select_GROUPDELAY;
         break;

      case OPTN_POTS_QUAD_LP_Filter_Select:
         // filter in case only US0 is indicated
         TxLoadIir(gula_Strymon_TxIir_us0_only_EU128_poco_XdB_VDSL17);
         gt_PSDCompData.us_TxIIRFilter = OPTN_POTS_QUAD_LP_Filter_Select;
         gs_TimingAdvanceTxIirDelay = OPTN_POTS_QUAD_LP_Filter_Select_GROUPDELAY;
         break;

      case OPTN_35B_POTS_LP_Filter_Select:
         // filter in case only US0 is indicated
         TxLoadIir(gula_Strymon_TxIir_us0_only_A_poco_XdB_VDSL35);
         gt_PSDCompData.us_TxIIRFilter = OPTN_35B_POTS_LP_Filter_Select;
         gs_TimingAdvanceTxIirDelay = OPTN_35B_POTS_LP_Filter_Select_GROUPDELAY;
         break;

      case OPTN_35B_ISDN_LP_Filter_Select:
         // filter in case only US0 is indicated
         TxLoadIir(gula_Strymon_TxIir_us0_only_B_poco_XdB_VDSL35);
         gt_PSDCompData.us_TxIIRFilter = OPTN_35B_ISDN_LP_Filter_Select;
         gs_TimingAdvanceTxIirDelay = OPTN_35B_ISDN_LP_Filter_Select_GROUPDELAY;
         break;

      case OPTN_35B_POTS_DOUBLE_LP_Filter_Select: //XDSLRTFW-3570
         // filter in case only US0 is indicated
         TxLoadIir(gula_Strymon_TxIir_us0_only_M_poco_XdB_VDSL35);
         gt_PSDCompData.us_TxIIRFilter = OPTN_35B_POTS_DOUBLE_LP_Filter_Select;
         gs_TimingAdvanceTxIirDelay = OPTN_35B_POTS_DOUBLE_LP_Filter_Select_GROUPDELAY;
         break;

      case OPTN_BYPASS_Filter_Select:
      default:
//         if (gt_ProfileAct.us_ProfileSelected & CNFG_V2_PROFILE_35B_MASK)
//         {
//            TxLoadIir(gula_Strymon_TxIir_VDSL35b_unity);
//         }
         UnityTxIIR();
         gt_PSDCompData.us_TxIIRFilter = OPTN_BYPASS_Filter_Select; //XDSLRTFW-2059
         break;
      }
   }

   // Debug TxIir group delay
   if (gs_DbgTimingAdvanceTx != 0)
   {
      gs_TimingAdvanceTxIirDelay = gs_DbgTimingAdvanceTx;
   }

   // Save actual loaded TX IIR filter.
   gsa_Optn4_FilterControl[OPTN_4_IDX2_FILTER_ACT] = (gsa_Optn4_FilterControl[OPTN_4_IDX2_FILTER_ACT] & (~OPTN_TX_MASK_Filter_Select));
   gsa_Optn4_FilterControl[OPTN_4_IDX2_FILTER_ACT] |= s_FilterSelect;

} //void LoadTxIIR(void)

/*******************************************************************************
*
*   Prototype: void LoadInterpFIR(void)
*
*   This function loads the Strymon's interpolation filter to desired filter.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*******************************************************************************/

extern int16 gsa_StrymonFir_Filter_TxInterp_lrvdsl_8[];

extern int16 gsa_StrymonFir_Filter_TxInterp_Adsl[];

void LoadInterpFIR(void)
{
   uint32 ul_data;

   // Zeros the current block output
   ResetCoreReg((uint32)V_BLOCK_RSTN_ADDR, MASK_BIT5);


   // Set the input sampling rate (= 144/(8-IN_RATE))

   if (gs_TxLog2IfftLength == 9)
   {
      ul_data = (gs_TxLog2IfftLength - 5)<<20; //=IN_RATE<<20
      // Set interolation factor (= (1<<INTERP_FACTOR))
      ul_data |= (12-gs_TxLog2IfftLength);   //= INTERP_FACTOR
   }
   else
   {
      ul_data = (gs_TxLog2IfftLength - 6)<<20; //=IN_RATE<<20
      // Set interolation factor (= (1<<INTERP_FACTOR))
      ul_data |= (13-gs_TxLog2IfftLength);   //= INTERP_FACTOR
   }


   // For 30 and 17 Mhz bandwidth, the interpolation factor is 1
   // so we set it in bypass mode
   if((gs_TxLog2IfftLength == 13) || (gs_STR_DbgCntl & STR_DBG_CNTL_DISABLE_TXINP))
   {
      ul_data |= TX_INTERP_BYPASS;
   }
   //For 8 Mhz bandwidth, the interpolation factor is 2
   else //if((gs_TxLog2IfftLength == 12)
   {

#define INTERP_SCALE   (0)
#define INTERP_LEN      (16)
#define INTERP_FACTOR   (2)
#define INTERP_ACT_LEN   (INTERP_FACTOR*INTERP_LEN)
#define INTERP_MAX_LEN   (24)

      ul_data |= ((INTERP_SCALE & 7)<<28) | ((INTERP_LEN-1) << 8);

      //Load the interpolation filter coefficients

      if (gs_TxLog2IfftLength == 9)
      {
         FillCoreBuf32(V_INTERP_CO_ADDR, 0, 192);
         WriteCoreBuf32(V_INTERP_CO_ADDR, gsa_StrymonFir_Filter_TxInterp_Adsl, (96));
         //WriteCoreBuf32(V_INTERP_CO_ADDR + INTERP_MAX_LEN*2, &gsa_StrymonFir_Filter_TxInterp_Adsl[INTERP_LEN],(INTERP_LEN >>1));
      }
      else
      {
         FillCoreBuf32(V_INTERP_CO_ADDR, 0, INTERP_MAX_LEN);
         WriteCoreBuf32(V_INTERP_CO_ADDR, gsa_StrymonFir_Filter_TxInterp_lrvdsl_8, (INTERP_LEN >>1));
         WriteCoreBuf32(V_INTERP_CO_ADDR + INTERP_MAX_LEN*2, &gsa_StrymonFir_Filter_TxInterp_lrvdsl_8[INTERP_LEN],(INTERP_LEN >>1));
      }

   }

   //Write to the interpolation configuration filter
   WriteCoreReg((uint32)(V_INTERP_CFG_ADDR), ul_data);

   // Enable the current block output
   SetCoreReg((uint32)V_BLOCK_RSTN_ADDR, MASK_BIT5);

} //void LoadInterpFIR(void)
