/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2007 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;   Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;   Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;   File Name: V_STR_IOf.c
;
;   VDSL Strymon CO/CPE core i/o functions.
;
*****************************************************************************/
#include <string.h>
#include "common.h"
#include "gdata.h"
#include "LL_IOf.h"
#include "cmv.h"
#include "str_memmap.h"

/****************************************************************************
; Name: ReadTxVarGain
;
; Prototype:
;   void ReadTxVarGain(void)
;
; Description:
;   This function reads the TX Var gain from the HW register.
;
; Arguments:
;   N/A
;
; Return Value:
;   N/A
;
; Globals:
;
*****************************************************************************/
#ifdef POLLING_CORE_INTERRUPTS
void ReadTxVarGain(int16 *ps_TxVarGain)
{
   uint32 ul_tmpWord;

   ReadCoreReg((uint32)V_TX_VARGAIN_ADDR, &ul_tmpWord);

   *ps_TxVarGain = (int16)(ul_tmpWord & 0xFFFF);
}
#endif //#ifdef POLLING_CORE_INTERRUPTS

/****************************************************************************
; Name: ClearTxVarGain
;
; Prototype:
;   void ClearTxVarGain(void)
;
; Description:
;   This function sets the Tx variable gain block of the VDSL Strymon HW to 0.
;
; Arguments:
;   N/A
;
; Return Value:
;   N/A
;
; Globals:
;
*****************************************************************************/
void ClearTxVarGain(void)
{
   // silence the transmitter.
//   gs_TxVarGain = 0;

   // Set Tx variable gain
   WriteCoreReg((uint32)V_TX_VARGAIN_ADDR, (uint32)0);
}

/*
*-------------------------------------------------------------------------------
*
*   Prototype: void SetTxVarGain(void)
*
*   This function sets the Tx variable gain block of the VDSL Strymon HW.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/

void SetTxVarGain(void)
{
   uint32 ul_tmpWord;

   // Set Tx variable gain
   ul_tmpWord = gs_TxVarGain;            // Tx gain coefficient

   if(gs_TxVarGainExp < MIN_TXVARGAIN_EXP)
   {
      gs_TxVarGainExp = MIN_TXVARGAIN_EXP;
   }
   else if (gs_TxVarGainExp > MAX_TXVARGAIN_EXP)
   {
      gs_TxVarGainExp = MAX_TXVARGAIN_EXP;
   }

   ul_tmpWord |= (gs_TxVarGainExp << 16);   // Tx gain exponent

   WriteCoreReg((uint32)V_TX_VARGAIN_ADDR, ul_tmpWord);

   //Popolate the shadow fifo registers
   if(gft_UpdateVRegShadowFifo == TRUE)
   {
      //Write to the active register
      WriteCoreReg((uint32)V_TX_AVARGAIN_ADDR, ul_tmpWord);
   }
}

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : CheckStrymonOverFlow
 *
 *  Prototype:  void CheckStrymonOverFlow(void)
 *
 *      This functions is called in RxProcessTones().
 *
 *      Checks for overflow inside strymon. Use the overflow mask
 *      to select which overflow to monitor. An overflow count will get
 *      incremented every time an overflow occurs.
 *
 *
 *------------------------------------------------------------------------
 *^^^
 */

#ifdef ENABLE_VR9_HW_ERR_CNT

void CheckStrymonOverFlow(void)
{
   int16 i;

   // Read Strymon's overflow/event register
   ReadCoreReg((uint32) V_OVERFLOW_ADDR, &gul_STR_OverflowData);

   // Write '1' to clear overflow bits
   WriteCoreReg((uint32) V_OVERFLOW_ADDR, gul_STR_OverflowMask);

   gul_STR_OverflowData &= gul_STR_OverflowMask;

   //Update the overflow counters
   for(i=0; i<17; i++)
   {
      if((gul_STR_OverflowData & (1<<i)) && (gsa_StrymonOverflowCnt[i] < 0xFFFF))
      {
         gsa_StrymonOverflowCnt[i]++;
      }
   }

} //void CheckStrymonOverFlow(void)

#endif //#ifdef ENABLE_VR9_HW_ERR_CNT

void StartTxWin(void)
{
   // Tx window strobe enable
   SetCoreReg(V_TX_EXTEN_ADDR, WIN_EN);
}


// this function needs to be in IRAM because by the time it is called by LinkStart,
// INIT_2 page is no longer in the memory.
void EnableStrymon(void)
{
   //Take the strymon out of reset
   SetCoreReg((uint32)(V_CONTROL_ADDR), RESET_STATEN);
}

//Hold the strymon at the reset state
void DisableStrymon(void)
{
   //Take the strymon out of reset
   ResetCoreReg((uint32)(V_CONTROL_ADDR), RESET_STATEN);
}

//XDSLRTFW-2794 (start)
//Call this function only once if 35B mode is selected after Strymon is
//taken out of reset and Strymon is started running.
void CfgSRCCTL(void)
{
     WriteCoreReg(V_SRCCTL_ADDR, 1);
}
//XDSLRTFW-2794 (end)

// This function writes the windowing coeffs depending on the windowing length and direction from gsa_WindowCoeffs buffer to
// gsa_CommonMemoryBlock0 and from there to Hardware
// Please note: Since this function is called from background no DMA is used to write to HW
void WriteWindowingCoefficients(FlagT Direction, int16 Length)
{
   int32 i, j;

   if (Direction == RX)
   {
      // Set Rx CP coefficients and Rx past captured samples to 0                    >>2 due to long access
      FillCoreBuf32((uint32)V_RXWIN_CO_PS_ADDR, (int32)0, (uint16)(V_RXWIN_CO_PS_SIZE/4));

      if(Length > 0)
      {
         int32 l_IdxAdder;
         int16 s_RefWindow;

         s_RefWindow = RX_WINDOW_LENGTH;
         if(gs_DbgRecnfgCpCsBeta & TX_CP_CS_BETA_BDCM_EN)
         {
            s_RefWindow = RX_WINDOW_LENGTH_BDCM;
         }
         // The full windowing coeffs for 8K FFT size is stored with 240 values, i.e. 480/2.
         // Note: From these values following window sets should be used:
         //         - dbg mode:            The given value should be used.
         //         - Full values (240):   8K FFT size, i.e. 35b
         //         - Half values (120):   8K FFT size, BDCM fix
         //         - Half values (120):   4K FFT size, i.e. 17a, 12x, 8x -> every second value belong to the 4K FFT size windowing coeffs
         //         - Half values (60):    4K FFT size, BDCM fix          -> every forth value belong to the 4K FFT size windowing coeffs

         // Loop index initalization for original windowing coeffs table, i.e. dbg mode or 8K FFT size (35b).
         // Note: Debug mode is not fully working (gs_DbgRxWindowLength != 0), i.e. FFT length of profile is not checked!
         j = 0;
         l_IdxAdder = 1;

         // // Loop index initalization for all other modes.
         {
            // Take every second value
            if(Length == s_RefWindow)
            {
               j = 0;
               l_IdxAdder = 2;
            }
            // Take every forth value
            if(Length == (s_RefWindow>>1))
            {
               j = 2;
               l_IdxAdder = 4;
            }
         }


         for(i=0; i<s_RefWindow; i++)
         {
            gsa_CommonMemoryBlock0[i] = (uint16)0x8000 - gsa_WindowCoeffs[j];
            j += l_IdxAdder;
         }

         // Write Rx windowing coeffs to HW
         // Note: HW has 32bit therefore half of the length must be copied!
         WriteCoreBuf32NoDMA((uint32)(V_RXWIN_CO_PS_ADDR), gsa_CommonMemoryBlock0, (uint16) (Length>>2));
      }
   }
   else
   {  // Direction TX
      int16 s_RefWindow;

      s_RefWindow = TX_WINDOW_LENGTH_8K_IFFT;
      if(gs_DbgRecnfgCpCsBeta & TX_CP_CS_BETA_BDCM_EN)
      {
         s_RefWindow = TX_WINDOW_LENGTH_8K_IFFT_BDCM;
      }

      // Set Tx CP coefficients and Rx past captured samples to 0
      FillCoreBuf32((uint32)V_TXWIN_CO_PS_ADDR, (int32)0, (uint16)(V_TXWIN_CO_PS_SIZE/4));
      // 8K FFT size
      if(Length == s_RefWindow)
      {
         for(i=0; i<(Length>>1); i++)
         {
            gsa_CommonMemoryBlock0[i] = gsa_WindowCoeffs[i];
         }
      }
      // 4K FFT size
      else if(Length == (s_RefWindow >> 1))
      {
         for(i=0, j=1; i<(Length>>1); i++, j+=2)
         {
            gsa_CommonMemoryBlock0[i] = gsa_WindowCoeffs[j];
         }
      }
      else
      {
         //Invalid length or zero length, consider fail code
         return;
      }
      // Write Tx windowing coeffs to HW
      WriteCoreBuf32NoDMA((uint32)(V_TXWIN_CO_PS_ADDR), gsa_CommonMemoryBlock0, (uint16) (Length>>2));
   }// Direction

   // clear common memory block
   memset(gsa_CommonMemoryBlock0, 0, sizeof(int16)*(Length>>1));
}


//void DisableIir(void)
//{
//   ResetCoreReg((uint32)V_BLOCK_RSTN_ADDR, 0x12);
//}
//
//void EnableIir(void)
//{
//   SetCoreReg((uint32)V_BLOCK_RSTN_ADDR, 0x12);
//}
