/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2007 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: V_STR_IOf_Trn.c
*
*   This file contains V Strymon engine interface functions used during
*   all phases except Showtime.
*
*-------------------------------------------------------------------------------
*/

#include "common.h"
#include "gdata.h"
#include "LL_IOf.h"
#include "cmv.h"

#include "str_memmap.h"
#include "V_STR_SRC_Ini.h"
#include "V_STR_IIR_IOf.h"

//XDSLRTFW-3629 Start
//0x30c604          V_BLOCK_RSTN                0x77
//bit#4 TX.IIR_RSTN RW 0x1 Zeroes the current tx iir output and resets the internal state machine.
#define TX_IIR_RSTN_BITMASK    (0x10)
//bit#1 RX.IIR_RSTN RW 0x1 Zeroes the current rx iir output and resets the internal state machine.
#define RX_IIR_RSTN_BITMASK    (0x02)
//XDSLRTFW-3629 End

// structure used for iir
typedef struct
{
   uint32 n;            // num of coefs
   uint32 cfg_regs[2];  // cfg1 ,cfg2
   uint32 coefs[31];    // 31 is max size of 6 biquads.
} iirLoad_Struc_t;

void LoadIir(void *p_filter, uint32 pul_register , uint32 ul_coefs_addr)
{
   iirLoad_Struc_t *p_iir = p_filter;

// Note: The below mentioned method is used:
// An alternative method for changing filter coefficients and/or scaling factors is
// to place the individual block in bypass mode, then change the filter coefficients
// and/or scaling factors, then clear the block level bypass bit.
// Therefore write the register V_xXIIR1_CFG at the end, because in this the BYPASS-bit
// is located!
//   WriteCoreReg( pul_register ,  p_iir->cfg_regs[0]); //V_xXIIR1_CFG_ADDR
//   WriteCoreReg( pul_register+4, p_iir->cfg_regs[1]); //V_xXIIR2_CFG_ADDR
   WriteCoreBuf32(ul_coefs_addr,(int16 *)(void *) &(p_iir->coefs[0]), (uint16)p_iir->n);
   WriteCoreReg( pul_register+4, p_iir->cfg_regs[1]); //V_xXIIR2_CFG_ADDR
   WriteCoreReg( pul_register ,  p_iir->cfg_regs[0]); //V_xXIIR1_CFG_ADDR
}

//XDSLRTFW-3629 Start
//When loading TXIIR filter coefficients the following steps need to be followed:
//         - the bit#4(TX.IIR_RSTN) of strymon register "V_BLOCK_RSTN" set to '0'
//         - then load the TXIIR filter coefficients
//         - the bit#4(TX.IIR_RSTN) of strymon register "V_BLOCK_RSTN" set to '1'
void TxLoadIir(void *p_filter)
{
   ResetCoreReg((uint32)(V_BLOCK_RSTN_ADDR), TX_IIR_RSTN_BITMASK);
   LoadIir( p_filter , V_TXIIR1_CFG_ADDR , V_TXIIR_CO_ADDR );
   SetCoreReg((uint32)(V_BLOCK_RSTN_ADDR), TX_IIR_RSTN_BITMASK);
}
//XDSLRTFW-3629 End

//When loading RXIIR filter coefficients the following steps need to be followed:
//         - the bit#1(RX.IIR_RSTN) of strymon register "V_BLOCK_RSTN" set to '0'
//         - then load the TXIIR filter coefficients
//         - the bit#1(RX.IIR_RSTN) of strymon register "V_BLOCK_RSTN" set to '1'
void RxLoadIir(void *p_filter)
{
   ResetCoreReg((uint32)(V_BLOCK_RSTN_ADDR), RX_IIR_RSTN_BITMASK);
   LoadIir( p_filter , V_RXIIR1_CFG_ADDR , V_RXIIR_CO_ADDR );
   SetCoreReg((uint32)(V_BLOCK_RSTN_ADDR), RX_IIR_RSTN_BITMASK);
}

/*
*-------------------------------------------------------------------------------
*
*   Prototype: void UnityRxIIR(void)
*
*   This function sets RX IIR filter to bypass mode.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/
void UnityRxIIR(void)
{
   uint32 ul_data;

   //Save the original register value
   ReadCoreReg((uint32)(V_RXIIR1_CFG_ADDR), &gul_RXIIR_reg);

   // Set RXIIR_IN_RATE
   ul_data = (gs_RxLog2FftLength - 7);
   if (gt_ProfileAct.us_ProfileSelected & CNFG_V2_PROFILE_30A_MASK)
   {
      ul_data += 1;
   }
   ul_data = (ul_data << 20);

   // Set it in bypass mode
   ul_data |= RXIIR_BYPASS;
   WriteCoreReg((uint32)(V_RXIIR1_CFG_ADDR), ul_data);
}


void RestoreRxIIR(void)
{
   if(gul_RXIIR_reg != 0)
   {
      // Clear Rx IIR block reset bit to keep RX IIR in reset mode in V_BLOCK_RSTN register
      // Restore the original register value
      // Set Rx IIR Block reset bit to take RX IIR out of reset
      ResetCoreReg((uint32)(V_BLOCK_RSTN_ADDR), 0x2);
      WriteCoreReg((uint32)(V_RXIIR1_CFG_ADDR), gul_RXIIR_reg);
      SetCoreReg((uint32)(V_BLOCK_RSTN_ADDR), 0x2);

      gul_RXIIR_reg = 0;
   }
}

/*
*-------------------------------------------------------------------------------
*
*   Prototype: void LoadRxIIR(void)
*
*   This function loads RX IIR filter.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/
void LoadRxIIR(void)
{
   int16 s_FilterControl;

   s_FilterControl = gsa_Optn4_FilterControl[OPTN_4_IDX1_FILTER_CTRL];
   // XDSLRTFW-3737 (Start_End)
   gs_TimingAdvanceRxIirDelay = 0;       // Bypass

   // Note: The below mentioned method is used:
   // Method for changing filter coefficients and/or scaling factors is
   // to place the individual block in bypass mode, then change the filter coefficients
   // and/or scaling factors, then clear the block level bypass bit.
// Note: The correct sequence leads to sporadic "bad SNR" links. Until it is not checked with HW people
//       the old implementation will be used!
//   UnityRxIIR();

   if(gs_STR_DbgCntl & STR_DBG_CNTL_DISABLE_RXIIR)
   {
      gs_RxIIRFilterSelect = OPTN_BYPASS_Filter_Select;
      s_FilterControl = OPTN_Rx_Filter_Enable;
   }


   // Init POTS filter if enabled
   if (s_FilterControl & OPTN_Rx_Filter_Enable)
   {
      if (gft_Debug35bHwConfig17aModeEnable == TRUE)
      {
         RxLoadIir(gula_Strymon_RxIir_lp_17MHz_VDSL35); //Decim by 2
      }
      else if ((gs_RxIIRFilterSelect == OPTN_ISDN_Filter_Select)  ||
               (gs_RxIIRFilterSelect == OPTN_POTS_DOUBLE_Filter_Select)) // ||
//               (gs_RxIIRFilterSelect == OPTN_ISDN_LP_Filter_Select) ||
//               (gs_RxIIRFilterSelect == OPTN_POTS_DOUBLE_LP_Filter_Select))
      {
         // CPE Rx ISDN Filter
         if(gs_RxNumTones == 4096)
         {
            //the filter is not used for 30 MHz profile
            if(gs_frame_rate_is_8khz == 0)
            {
               RxLoadIir(gula_RxIIR_ISDN_17M_Filter);
            }
         }
         else
         {
            RxLoadIir(gula_RxIIR_ISDN_8M_Filter);
         }
      }
      else if ((gs_RxIIRFilterSelect == OPTN_POTS_Filter_Select)) // ||
//               (gs_RxIIRFilterSelect == OPTN_POTS_LP_Filter_Select))
      {
         // CPE Rx POTS Filter
         if(gs_RxNumTones == 4096)
         {
            //the filter is not used for 30 MHz profile
            if(gs_frame_rate_is_8khz == 0)
            {
               RxLoadIir(gula_RxIIR_POTS_17M_Filter);
            }
         }
         else
         {
            RxLoadIir(gula_RxIIR_POTS_8M_Filter);
         }
      }
      else //if (gs_RxIIRFilterSelect == OPTN_BYPASS_Filter_Select)
      {
         UnityRxIIR();
      }
   }

   // Save actual loaded RX IIR filter.
   gsa_Optn4_FilterControl[OPTN_4_IDX2_FILTER_ACT] = (gsa_Optn4_FilterControl[OPTN_4_IDX2_FILTER_ACT] & (~OPTN_RX_MASK_Filter_Select));
   gsa_Optn4_FilterControl[OPTN_4_IDX2_FILTER_ACT] |= (gs_RxIIRFilterSelect << OPTN_RX_Filter_Select_POS);
}


/*
*-------------------------------------------------------------------------------
*
*   Prototype: void UnityDecimFIR(void)
*
*   This function programs the RX FIR decimation filter to unity filter (i.e in bypass mode)
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*      gs_RxLog2FftLength -- (I) log2 of RX FFT size
*      gul_DecimCfg_reg -- (O) the value of the previous V_DECIM_CFG register
*-------------------------------------------------------------------------------
*/


/*
*-------------------------------------------------------------------------------
*
*   Prototype: void RestoreDecimFIR(void)
*
*   This function restores the previous value of V_DECIM_CFG register
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*      gs_RxLog2FftLength -- (I) log2 of RX FFT size
*      gul_DecimCfg_reg -- (O) the value of the previous DECIM_CFG register
*-------------------------------------------------------------------------------
*/

void RestoreDecimFIR(void)
{
   if(gul_DecimCfg_reg != 0)
   {
      //Restore the original register value
      WriteCoreReg(V_DECIM_CFG_ADDR, gul_DecimCfg_reg);

      gul_DecimCfg_reg = 0;
   }
}

/*
*-------------------------------------------------------------------------------
*
*   Prototype: void SetRxVarGain(void)
*
*   This function sets the Rx variable gain block of the VDSL Strymon HW.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/
void SetRxVarGain(void)
{
   uint32 ul_tmpWord;

   // Set Rx variable gain
   ul_tmpWord = gs_RxVarGain;            // Tx gain coefficient
   ul_tmpWord |= (gs_RxVarGainExp << 16);   // Tx gain exponent

   WriteCoreReg((uint32)V_RX_VARGAIN_ADDR, ul_tmpWord);

   //Popolate the shadow fifo registers
   if(gft_UpdateVRegShadowFifo == TRUE)
   {
      //Write to the active register
      WriteCoreReg((uint32)V_RX_AVARGAIN_ADDR, ul_tmpWord);
   }
}


/*
*-------------------------------------------------------------------------------
*
*   Prototype: void EnableSRCFilter(void)
*
*   This function sets up the SRC (or INTERP/DECIM) filter.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/

void EnableSRCFilter(void)
{
   WriteCoreReg((uint32) V_SRCFR_ADDR, TESTArray[TEST_SrcFRNominalOffset]); // Write initial nominal SRCFR value
}

/*
*-------------------------------------------------------------------------------
*
*   Prototype: void EnableTimeDomainLoopback(void)
*
*   This function sets up the Strymon in Loopback mode by setting bit
*   WIN_Loopback in the V_CONTROL register.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/

void EnableTimeDomainLoopback(void)
{
   //Set the WIN_LOOPBACK bit in the V_CONTROL_Register
   SetCoreReg((uint32)V_CONTROL_ADDR, (1<<11));
}


void DisableTimeDomainLoopback(void)
{
   // Reset the WIN_LOOPBACK bit in the V_CONTROL_Register
   ResetCoreReg((uint32)V_CONTROL_ADDR, (1<<11));

}
