/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2006 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;   Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;   Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;   File Name: V_STR_Ini.c
;
;   VDSL Strymon CO/CPE core Initialization
;
*****************************************************************************/
#include <string.h>
#include "common.h"
#include "gdata.h"
#include "ghs.h"
#include "LL_IOf.h"
#include "cmv.h"
#include "cri_memmap.h"
#include "afeif_memmap.h"
#include "str_memmap.h"
#include "v_str_src_ini.h"
#include "V_STR_IOf.h"
#include "V_STR_Ini.h"

void UnityTxIIR(void);
void LoadTxIIR(void);
void LoadInterpFIR(void);

#ifdef VR9_BRINGUP_DBG
extern int32 jgSERDESLoop;
#endif

//XDSLRTFW-3463  Start
int32 gl_fc_pofi_lp_kHz_temp;
uint8 guc_SrcTxScale_Handhake = 0; //During Handshake the TX SRC Gain increased by 6dB to meet -38dBM. Post handshake this will be zero
//XDSLRTFW-3463  End

/****************************************************************************
; Name: V_Str_Init
;
; Prototype:
;   void V_Str_Init(void)
;
; Description:
;   This function initializes the VDSL Strymon core by performing the following steps:
;
;   1) Set the mode of the core via the V_CONTROL register
;   2) All filter blocks are set to unity. The Tx/Rx SRCs are bypassed.
;
; Arguments:
;   N/A
;
; Return Value:
;   N/A
;
; Globals:
;
*****************************************************************************/
void V_Str_Init(void)
{
   uint32 ul_data;

   // ===============================================
   // Configure Strymon
   // ===============================================

   //-----------------------------------------------------------------------------------------------------------
   // Hold Strymon in Reset until the configuration is complete
   //-----------------------------------------------------------------------------------------------------------
   WriteCoreReg((uint32)V_CONTROL_ADDR, 0);

   //VControl  enable LPBK
   //Configure DAC sampling rate to 144 MSPS (this actually doesn't matter for lpbk mode)
   //Configure ADC sampling rate to 144 MSPS (this actually doesn't matter for lpbk mode)
   if(gft_StrymonLpbkMode == STR_TX_RX_LPBK)
   {
      ul_data = (STR_LPBK_ENA|RX_ADC_RATE|TX_DAC_RATE|TX_UPD_SEL|RX_UPD_SEL);
   }
   else
      //ul_data = (RX_ADC_RATE|TX_DAC_RATE|TX_UPD_SEL|RX_UPD_SEL);
   {
      ul_data = (RX_ADC_RATE|TX_DAC_RATE|FIFO_FORCE);
   }

   WriteCoreReg((uint32)(V_CONTROL_ADDR), ul_data);

   //skip V_BLOCK_RSTN

   //Clear V_OVERFLOW
   WriteCoreReg((uint32)V_OVERFLOW_ADDR, 0x1FFFF);

   // -------Configure TX IIR------------

   //Clear TX IIR coefficient memory
   FillCoreBuf32((uint32)V_TXIIR_CO_ADDR, (int32)0, (uint16)(V_TXIIR_CO_SIZE/4));

   //Config TX IIR filter to unity (or bypass mode)
   UnityTxIIR();

  if (gs_ForceGainPofi_dB != -1)  //XDSLRTFW-3463 Start
  {
      //memset(sa_PilotToneIdxArray, (int16)(-1), sizeof(int16)*MAX_NUM_RX_BANDS);
      gsa_gain_pofi_dB[BYPASSED]    = gs_ForceGainPofi_dB;
      gsa_gain_pofi_dB[VDSL35b_CPE] = gs_ForceGainPofi_dB;
      gsa_gain_pofi_dB[VDSL17_CPE]  = gs_ForceGainPofi_dB;
      gsa_gain_pofi_dB[VDSL8_CPE]   = gs_ForceGainPofi_dB;
      gsa_gain_pofi_dB[ADSL2_CPE]   = gs_ForceGainPofi_dB;
  }

  //CHECK_VRX518AFE
  //Initialize DFI with 17a configuration since,
  //both FFT & IFFT will be configured with 4K tones before G.hs
  /// In VRX318, DFE/DFI is configured for 17 a mode, But only AFE RX path configured for ADSL2 mode
  //With that change GHS loop reach increased by 500M. This type of change may not be possible on VRX518 because
  // DFE if configured for 17a means 288MSPS and AFE RX in ADSL means 144 MSPS NOT a valid configuration,
  {
     //Later if someone wants to try other than 17a before GHS
      gus_AFE_RxMode = VDSL17_CPE;
      gus_AFE_TxMode = VDSL17_CPE;
      gus_DAC_Rate = VRX518_DAC_RATE_288MHZ;
      gus_ADC_Rate = VRX518_ADC_RATE_1152MHZ;
      gus_TxSRC_InRate = VRX518_SRC_INRATE_35MHZ; //VRX518AFE_OPEN
      gus_TxSRC_UpsamplingFactor = 1;  //VRX518AFE_OPEN
      gus_TxSRC_OutRate = (gus_TxSRC_InRate << gus_TxSRC_UpsamplingFactor);

      gs_AGC1_Gain_Set = gsa_gain_pga_dB[gus_AFE_RxMode];
      gs_AGC2_Gain_Set = gsa_gain_prefi_dB[gus_AFE_RxMode];
  }

   gl_fc_pofi_lp_kHz_temp = gla_fc_pofi_lp_kHz[gus_AFE_TxMode];  //XDSLRTFW-3463 End

   // Get TX IIR filter selection from CMV
   // Filters are switched on by setting bits in OPTN 4
   gs_TxIIRFilterSelect = (gsa_Optn4_FilterControl[OPTN_4_IDX0_FILTER_CONF] & OPTN_TX_MASK_Filter_Select);
   if (gsa_Optn4_FilterControl[OPTN_4_IDX1_FILTER_CTRL] & OPTN_Tx_Filter_Auto_Reconfig)
   {
      // Choose the TX IIR filter based on the Ghs handshake tones
      gs_TxIIRFilterSelect = OPTN_ISDN_Filter_Select;
      if (gs_GhsCarSetCfgInternal & CNFG_GHS_CAR_SET_A43) //XDSLRTFW-3515
      {
         gs_TxIIRFilterSelect = OPTN_POTS_Filter_Select;
      }

      // XDSLRTFW-3292
      if (!(TESTArray[TEST_Control3] & TEST_GHS_DisableTxPathAfeDfeCustomSettings))
      {
         gs_TxPathAfeDfeCustomSettings = AFE_POFI_MODE_ADSL2_CPE;

         if (gs_TxIIRFilterSelect == OPTN_POTS_Filter_Select)
         {
            gs_TxIIRFilterSelect = OPTN_POTS_LP_Filter_Select;
            gla_fc_pofi_lp_kHz[gus_AFE_TxMode] = 80;//XDSLRTFW-3463
         }
         else
         {
            gs_TxIIRFilterSelect = OPTN_ISDN_LP_Filter_Select;
            gla_fc_pofi_lp_kHz[gus_AFE_TxMode] = 320;//XDSLRTFW-3463
         }
      }
   }
   // Store used filter in CMV. This is a debug feature for link analysis.
   gsa_Optn4_FilterControl[OPTN_4_IDX3_FILTER_GHS] = (gsa_Optn4_FilterControl[OPTN_4_IDX3_FILTER_GHS] & (~OPTN_TX_MASK_Filter_Select));
   gsa_Optn4_FilterControl[OPTN_4_IDX3_FILTER_GHS] |= gs_TxIIRFilterSelect;

   // Load TX IIR
   LoadTxIIR();
   //gft_TxIirSelect_HskOnly = 0; Moved lien AFED_ModeConfig

   // -------- Configure RX IIR ------------------------

   //Clear RX IIR coefficient memory
   FillCoreBuf32((uint32)V_RXIIR_CO_ADDR, (int32)0, (uint16)(V_RXIIR_CO_SIZE/4));

   //Config RX IIR filter to unity (or bypass mode)
   UnityRxIIR();

   // Get RX IIR filter selection from CMV
   // Filters are switched on by setting bits in OPTN 4
   gs_RxIIRFilterSelect = ((gsa_Optn4_FilterControl[OPTN_4_IDX0_FILTER_CONF] >> OPTN_RX_Filter_Select_POS) & OPTN_TX_MASK_Filter_Select);
   if (gsa_Optn4_FilterControl[OPTN_4_IDX1_FILTER_CTRL] & OPTN_Rx_Filter_Auto_Reconfig)
   {
      // Choose the RX IIR filter based on the Ghs handshake tones
      gs_RxIIRFilterSelect = OPTN_ISDN_Filter_Select;
      if (gs_GhsCarSetCfgInternal & CNFG_GHS_CAR_SET_A43)//XDSLRTFW-3515
      {
         gs_RxIIRFilterSelect = OPTN_POTS_Filter_Select;
      }
   }
   // Store used filter in CMV. This is a debug feature for link analysis.
   gsa_Optn4_FilterControl[OPTN_4_IDX3_FILTER_GHS] = (gsa_Optn4_FilterControl[OPTN_4_IDX3_FILTER_GHS] & (~OPTN_RX_MASK_Filter_Select));
   gsa_Optn4_FilterControl[OPTN_4_IDX3_FILTER_GHS] |= (gs_RxIIRFilterSelect << OPTN_RX_Filter_Select_POS);

   // Load RX IIR
   LoadRxIIR();

   // ---------- Configure TX interp ------------------------------

   //Load the interpolation FIR filter and configure the corresponding register
   LoadInterpFIR();

   // -------- Configure RX DECIM -------------------------
   // Rx Decim Bypass and set the sampling rate

   if(gft_StrymonLpbkMode == STR_TX_RX_LPBK)
   {
      // Set the output sampling rate = input sampling rate/(1<<RX_DECIM_FACTOR)
      ul_data = (13 - gs_RxLog2FftLength) << 24; //RX_DECIM_FACTOR <<24

      // Set the decimation filter input sample rate and bypass mode
      // the input sample rate is fixed at 72 MSPS in the lpbk mode
      ul_data |= (RX_DECIM_IN_RATE_72|RX_DECIM_BYPASS);

      WriteCoreReg((uint32)(V_DECIM_CFG_ADDR), ul_data);
   }
   else
   {
      //Load the decimation filter and configure the corresponding register
      LoadDecimFIR();
   }

   // ------- Configure DEC_CFG --------------------------
   // Set DEC/TDQ in bypass and set sampling rate, disable dec

   //Set TDQ input sampling rate (= 141.312/(1<<(8-TDQ_IN_RATE))
   ul_data = (gs_RxLog2FftLength - 7) << 24;   //TDQ_IN_RATE<<24

   //Disable DEC
   WriteCoreReg((uint32)(V_DEC_CFG_ADDR), ul_data);

   // ------- Configure TDQ_CFG --------------------------
   //Clear the DEC TDQ coefficient array
   FillCoreBuf32(V_DEC_TDQ_CO_ADDR, 0, (V_DEC_TDQ_CO_SIZE/2));

   //Set TDQ in bypass mode
   WriteCoreReg((uint32)(V_TDQ_CFG_ADDR), (uint32)TDQ_BYPASS);

   //skip V_DEC_CAPTURE
   //skip V_ADAPT_CTRL


   /****************************************************************************/
   /* Initialize DEC - initial coefficient values are arbitrary.                           */
   /****************************************************************************/
   //first detect the chip version (v1.4 interpdec)
   SetCoreReg((uint32)V_DEC_CFG_ADDR, MASK_BIT7);
   ReadCoreReg((uint32)V_DEC_CFG_ADDR, &ul_data);
   ResetCoreReg((uint32)V_DEC_CFG_ADDR, MASK_BIT7);

   // The DEC input rate is 2.2MHz or 4.4MHz
   // The DEC upsampling rate is 1x for CPE
   // The DEC Length Field (bits 7-0) are programmed to (dec length/8 - 1)
   // Set DEC input sampling rate (= 141.312/(1<<(8-TDQ_IN_RATE))

   //clear dec-tdq coefficients
   FillCoreBuf32(V_DEC_TDQ_CO_ADDR, 0, (V_DEC_TDQ_CO_SIZE>>2));
   //load unity DEC
   // UnityTDQ();

   //V_DEC_CAPTURE
   WriteCoreReg((uint32)(V_DEC_CAPTURE_ADDR), 0x0);
   //XDSLRTFW-558: VR9_VRX318_DFE_InitWithResetValues (END)

   // Set Tx variable gain to 0 to shut off signal on power up.---------
   WriteCoreReg((uint32)V_TX_VARGAIN_ADDR, (uint32)0);
   WriteCoreReg((uint32)V_TX_AVARGAIN_ADDR, (uint32)0);

   // Set Rx variable gain to unity ----------------------------------
   ul_data  = (gs_RxVarGain)|(gs_RxVarGainExp << 16);
   WriteCoreReg((uint32)V_RX_VARGAIN_ADDR, ul_data);
   WriteCoreReg((uint32)V_RX_AVARGAIN_ADDR, ul_data);

   //configure V_ADC_ADJUST
    WriteCoreReg((uint32)V_ADC_ADJUST_ADDR, 0x1000);
   //skip V_FRAME_SKEW

   // ------------- Set CP, CS length to 0 in GHS --------------------
   WriteCoreReg((uint32)(V_TX_EXTEN_ADDR), 0);
   WriteCoreReg((uint32)(V_TX_EXTEN_A_ADDR), 0);

   // ------------- Configure TX window length (beta) to 0 in GHS ----
   WriteCoreReg((uint32)(V_TX_BETA_ADDR), 0);
   WriteCoreReg((uint32)(V_TX_BETA_A_ADDR), 0);

   //---------- set IFFT size and sampling rate -----------------------

   //Set IFFT size
   ul_data = gs_TxIfftLength;

   //Set IFFT sampling rate (= 141.312/(1<<(8-IFFT_RATE)
   gul_TxIfftRate = (gs_TxLog2IfftLength - 7)<<16;   //= IFFT_RATE << 16
   ul_data |= gul_TxIfftRate;

   WriteCoreReg((uint32)(V_TX_FSIZE_ADDR), ul_data);
   WriteCoreReg((uint32)(V_TX_FSIZE_A_ADDR), ul_data);

   //skip V_FSOFFSET_IN
   //skip V_FSOFFSET_ER

   // ------------- Configure RX CP, CS length to 0 in GHS ---------------
   WriteCoreReg((uint32)(V_RX_EXTEN_ADDR), 0);
   WriteCoreReg((uint32)(V_RX_EXTEN_A_ADDR), 0);

   // ------------- Configure RX window length to 0 in GHS ---------------
   WriteCoreReg((uint32)(V_RX_WSIZE_ADDR),0);
   WriteCoreReg((uint32)(V_RX_WSIZE_A_ADDR),0);

   //------------ set FFT size and sampling rate ------------------
   //Set FFT size
   ul_data = gs_RxFftLength;
   //MAHESH
   //Set FFT sampling rate (=141.312/(1<<(8-FFT_RATE))
   gul_RxFftRate = (gs_RxLog2FftLength-7)<<16; //FFT_RATE<<16
   ul_data |= gul_RxFftRate;

   WriteCoreReg((uint32)(V_RX_FSIZE_ADDR), ul_data);
   WriteCoreReg((uint32)(V_RX_FSIZE_A_ADDR), ul_data);

   //Configure Strymon/AFE interface register

#ifndef VR9_BRINGUP_DBG
   WriteCoreReg((uint32)(V_SERDES_XBAR_ADDR), (uint32)guc_ch_id);
#else
   // JAGg jgSERDESLoop = 0x100 to loop and get clock.
   WriteCoreReg((uint32)(V_SERDES_XBAR_ADDR), (uint32)guc_ch_id | jgSERDESLoop );
#endif //#ifndef VR9_BRINGUP_DBG


   //------------ set Tx/Rx SRC sampling rate and bypass mode --------------

   // Download SRC coeffs
   LoadSRCCoeffs();

   //Configure SRC
   CfgSRC();

   //Set SRC TX input sample rate (=144/(1<<(8-INRATE))
   if(gs_TxLog2IfftLength == 9)
      ul_data = (gs_TxLog2IfftLength-6)<<20;   //= IN_RATE<<20
   else
      ul_data = (gs_TxLog2IfftLength-7)<<20;   //= IN_RATE<<20

   if(gs_STR_DbgCntl & STR_DBG_CNTL_DISABLE_SRC)
   {
      //Set TX and RX in bypass mode
      ul_data |= (TX_SRC_BYPASS|RX_SRC_BYPASS|SRC_FACTOR);
   }
   else
   {
      //Seeing Tx SRC overflow in Legacy mode 17a profile in VRX518 platform with Tx SRC scale factor of 2 (2^1)
      //Hence reduced scale factor to 1(2^0).
      ul_data |= ((SRC_FACTOR) |(0x7 << 4) |(0x0 << 1));
   }

   ul_data |= (guc_SrcTxScale_Handhake << 1); //Increase Tx SRC gain by 6dB in HSK //XDSLRTFW-3463

   WriteCoreReg((uint32)(V_SRC_CFG_ADDR), ul_data);

   if (gt_ProfileAct.us_ProfileSelected & CNFG_V2_PROFILE_35B_MASK)
   {
     WriteCoreReg((uint32)(V_SRC_MSEL_35B_ADDR), V_SRC_MSEL_35B_MASK | (0x1745 << 4)); //V_SRCCORR <19:4>, 0x1745
   }
   else
   {
    //Set Bit 0 to operate SRC in 35B mode
    //By Default use legacy mode SRC, Do the reconfiguration if 35B mode is required.
    WriteCoreReg((uint32)(V_SRC_MSEL_35B_ADDR), 0);
   }

   // ----------- Configure HB Filter ---------------------------------------
   //Input sampling rate is fixed at 72 MSPS
   //the sampling rate = 144/(1<<(8-TX_HBFILT_IN_RATE))
   //Set the exponent to 1 otherwise there will be loss of 6 dB in HBFILT

   ul_data = (uint32)((TX_HBFILT_IN_RATE)|(1<<28));

   if(gs_STR_DbgCntl & STR_DBG_CNTL_DISABLE_TXHB )
   {
      //Set TX HB filter in Bypass Mode
      ul_data |=  TX_HBFILT_BYPASS;
   }
   WriteCoreReg((uint32)(V_HBFILT_CFG_ADDR), ul_data);

   //Configured in AFE in VR9_SSC_init()
   //skip V_AFE_SERIAL_CFG
   //skip V_AFE_SERIAL_ADDR
   //skip V_AFE_SERIAL_WDATA
   //skip V_AFE_SERIAL_RDATA

   //------------ Load TX window coefficients --------------------------
   /*  // Not required? Windowing is only used after GHS
   if(gft_DisableTxWin == FALSE)
   {
      gs_TxWindowLength = TX_WINDOW_LENGTH_8K_IFFT;
      if (gs_TxLog2IfftLength > US_LOG2_FFT_LENGTH_8192)
      {
         gs_TxWindowLength = TX_WINDOW_LENGTH_8K_IFFT;
      }

      WriteWindowingCoefficients(TX,gs_TxWindowLength);
   }

   //------------ Load RX window coefficients --------------------------

   if(gft_DisableRxWin == FALSE)
   {
      gs_RxWindowLength = RX_WINDOW_LENGTH;
      if (gs_RxLog2FftLength > DS_LOG2_FFT_LENGTH_8192)
      {
         gs_RxWindowLength = RX_WINDOW_LENGTH_8K_FFT;
      }

      WriteWindowingCoefficients(RX,gs_RxWindowLength);
   }
   */

  //Initialize DFI with 17a configuration since,
  //both FFT & IFFT will be configured with 4K tones before G.hs.
  //Do the reconfigure once more after the profile is selected.

  //DFE-AFE Startup Sequence as in Page 101 of Strymon-VFDF_xDSL_CPE_bonded_v3.1 04
  //The startup handshake between the DFE and AFE needs to follow a proper sequence otherwise the expected behaviour
  //cannot be ensured. The sequence below details the order in which the various modules are enabled. The sequence is for
  //the data path and should only be done after the power sequence. There maybe other steps or configurations between
  //each step, but the following sequence needs to be adhered to.
  //1. Put Strymon in reset state by setting RESET_STATEN=0
  //2. Configure Strymon/DFI for both Tx and Rx. This step setup the time domain modules to the desried data rate
  //and profiles.
  //3. Configure AFE for both Tx and Rx via the FCSI-D interface for data rate that matched to the DFE side,
  //4. Only after both DFE and AFE are setup correctly and enabled, then DFE-AFE interface FIFO can be
  //enabled.No read/write of the FIFO can happen before it is enabled. Any read attempt will return 0 and write
  //attempt is ignored.
  //5. Put Strymon out of reset by setting RESET_STATEN=1

  gul_Afe_flowtest |=0x40;

  AFED_ModeConfig();

  //Resetting of Variable after AFE/DFI reconfig
  gs_TxPathAfeDfeCustomSettings = 0;//Requires for POFI config in ADSL mode

   if (gus_DebugControlVRX518 & ENA_TX_NOISESHAPER_VDSL17_35B) //XDSLRTFW-3361
   {
      gs_TxPathAfeDfeCustomSettings |= DFE_TX_NS_VDSL_MODE;//Enabling 17 MHz Noise Shaper settings for 35B
   }

  gs_Hyb_Hsk_QlnHlog = 1; //HSK hybrid setting
  AFED_HskQlnHlogSetHybrid();
  gul_Afe_flowtest |=0x80;

#ifdef DEBUG_VRX518_AFE  //0x5100
   if(gs_PauseControl == 0x5100)
      Pause(gs_PauseControl);
#endif

   //Take the strymon out of reset
   //Postpone this until linkStart in EnableCores_ForLinkStart()
   //SetCoreReg((uint32)(V_CONTROL_ADDR), RESET_STATEN);

   //This function changes some registers required for loopback operation
   if(gft_StrymonLpbkMode == STR_TX_RX_LPBK)
   {
      InitStrymon_Lpbk();
   }

} //V_Str_Init(void)


// ===============================================
// Configure Strymon in Loopback Operation
// ===============================================
void InitStrymon_Lpbk(void)
{
   uint32 ul_data;

   //---------- Make Tx variable gain unity ---------------------------
   ul_data = UNITY_TX_VAR_GAIN;
   ul_data |= (UNITY_TX_VAR_GAIN_EXP<<16);
   WriteCoreReg((uint32)(V_TX_AVARGAIN_ADDR), ul_data);
   WriteCoreReg((uint32)(V_TX_VARGAIN_ADDR), ul_data);

   // ------------- Make Rx variable gain unity ------------------
   ul_data = UNITY_RX_VAR_GAIN;
   ul_data |= (UNITY_RX_VAR_GAIN_EXP<<16);
   WriteCoreReg((uint32)(V_RX_AVARGAIN_ADDR), ul_data);
   WriteCoreReg((uint32)(V_RX_VARGAIN_ADDR), ul_data);

   // ------------- Configure TX CP, CS paremeters --------------------
   //Set CS, CP length and and window coefficient storage format
   ul_data = (gs_TxCPLength<<CP_SIZE_LSB)|(gs_TxCSLength<<CS_SIZE_LSB)|TX_WIN_COEFF_MODE_VDSL;

   //Enable CP
   if(gs_TxCPLength > 0)
   {
      ul_data |= CP_EN;
   }

   //Enable CS
   if(gs_TxCSLength > 0)
   {
      ul_data |= CS_EN;
   }

   //Enable TX window
   if(gs_TxBetaLength > 0)
   {
      ul_data |= WIN_EN;
   }

   WriteCoreReg((uint32)(V_TX_EXTEN_ADDR), ul_data);
   WriteCoreReg((uint32)(V_TX_EXTEN_A_ADDR), ul_data);

   // ------------- Configure TX window length (beta) --------------------
   WriteCoreReg((uint32)(V_TX_BETA_ADDR), (uint32)gs_TxBetaLength);
   WriteCoreReg((uint32)(V_TX_BETA_A_ADDR), (uint32)gs_TxBetaLength);

   // ------------- Configure RX CP, CS paremeters --------------------
   //Set CS, CP length and and window coefficient storage format
   ul_data = (gs_RxCPLength<<CP_SIZE_LSB)|((gs_RxCSLength-gs_RxBetaLength)<<CS_SIZE_LSB);

   //Enable CP
   if(gs_RxCPLength > 0)
   {
      ul_data |= CP_EN;
   }

   //Enable CS
   if(gs_RxCSLength > 0)
   {
      ul_data |= CS_EN;
   }

   //Enable RX window
   if(gs_RxWindowLength > 0)
   {
      ul_data |= WIN_EN;
   }

   WriteCoreReg((uint32)(V_RX_EXTEN_ADDR), ul_data);
   WriteCoreReg((uint32)(V_RX_EXTEN_A_ADDR), ul_data);

   // ------------- Configure RX window length (beta) --------------------

   WriteCoreReg((uint32)(V_RX_WSIZE_ADDR), (uint32)gs_RxWindowLength);
   WriteCoreReg((uint32)(V_RX_WSIZE_A_ADDR), (uint32)gs_RxWindowLength);

   //Take the strymon out of reset
   SetCoreReg((uint32)(V_CONTROL_ADDR), RESET_STATEN);

} //void InitStrymon_Lpbk(void)

