/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2006 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;   Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;   Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;   File Name: V_STR_Ini_PostGhs.c
;
;   Post GHS VDSL Strymon CO/CPE core Initialization
;
*****************************************************************************/
#include <string.h>
#include "common.h"
#include "gdata.h"
#include "LL_IOf.h"
#include "str_memmap.h"
#include "V_STR_IOf.h"
#include "V_STR_SRC_Ini.h"
#include "V_STR_IIR_IOf.h"
#include "ftb_memmap.h"
#include "ft_memmap.h"
#include "cri_memmap.h"
#include "IRI_Ini.h"
#include "cmv_Data.h"
#include "cmv.h"

#define  VRX518_AFE_FIXED_GAIN_ABJ_TONES_8192   (39526)  //154.398 dB in Q8.8 format ->154.398 * 256 = 39526

void LoadInterpFIR(void);

uint8 guc_SrcTxScale = 0x0;
uint8 guc_SrcRxScale = 0x0;

void ReconfigVStrymonFor8kHzTraining(void)
{
   uint32 ul_data;

   //-----------------------------------------------------------------------------------------------------------
   // Hold Strymon in Reset until the configuration is complete
   //-----------------------------------------------------------------------------------------------------------
   ResetCoreReg((uint32)V_CONTROL_ADDR, RESET_STATEN);

   //Disable all the cores and they will be enabled at LinkStart by function Reconfig_CRI()
   WriteCoreReg(CRI_TX_QTP_CTL_ADDR, 0);
   WriteCoreReg(CRI_TX_QT_CTL_ADDR, 0);
   WriteCoreReg(CRI_TX_IFFT_CTL_ADDR, 0);
   WriteCoreReg(CRI_RX_FFT_CTL_ADDR, 0);
   WriteCoreReg(CRI_RX_QT_CTL_ADDR, 0);
   WriteCoreReg(CRI_RX_QTP_CTL_ADDR, 0);

   // -------Configure TX IIR------------

   //Clear TX IIR coefficient memory
   FillCoreBuf32((uint32)V_TXIIR_CO_ADDR, (int32)0, (uint16)(V_TXIIR_CO_SIZE/4));

   gs_TxIIRFilterSelect = (gsa_Optn4_FilterControl[OPTN_4_IDX0_FILTER_CONF] & OPTN_TX_MASK_Filter_Select);
   // No TX IIR filter is used for 30a bandplan
   if (gsa_Optn4_FilterControl[OPTN_4_IDX1_FILTER_CTRL] & OPTN_Tx_Filter_Auto_Reconfig)
   {
      // Switch off the TX digital filter in 30MHz, i.e. Config TX IIR filter to unity (or bypass mode)
      gs_TxIIRFilterSelect = OPTN_BYPASS_Filter_Select;
   }
   // Load TX IIR
//   LoadTxIIR();

   // -------- Configure RX IIR ------------------------

   //Clear RX IIR coefficient memory
   FillCoreBuf32((uint32)V_RXIIR_CO_ADDR, (int32)0, (uint16)(V_RXIIR_CO_SIZE/4));

   gs_RxIIRFilterSelect = ((gsa_Optn4_FilterControl[OPTN_4_IDX0_FILTER_CONF] >> OPTN_RX_Filter_Select_POS) & OPTN_TX_MASK_Filter_Select);
   // No RX IIR filter is used for 30a bandplan
   if (gsa_Optn4_FilterControl[OPTN_4_IDX1_FILTER_CTRL] & OPTN_Rx_Filter_Auto_Reconfig)
   {
      // Switch off the RX digital filter in 30MHz, i.e. Config RX IIR filter to unity (or bypass mode)
      gs_RxIIRFilterSelect = OPTN_BYPASS_Filter_Select;
   }
   // Load RX IIR
//   LoadRxIIR();


   //Load the interpolation FIR filter and configure the corresponding register
   LoadInterpFIR();

   //Load the decimation filter and configure the corresponding register
   LoadDecimFIR();

   // ------- Configure DEC_CFG --------------------------
   // Set DEC/TDQ in bypass and set sampling rate, disable dec

   //Set TDQ input sampling rate (= 141.312/(1<<(8-TDQ_IN_RATE))
   ul_data = (7) << 24;   //TDQ_IN_RATE<<24

   //Disable DEC
   WriteCoreReg((uint32)(V_DEC_CFG_ADDR), ul_data);

   // ------- Configure TDQ_CFG --------------------------

   //Set TDQ in bypass mode
   WriteCoreReg((uint32)(V_TDQ_CFG_ADDR), (uint32)TDQ_BYPASS);

   // Set Tx variable gain to 0 to shut off signal on power up.---------
   WriteCoreReg((uint32)V_TX_VARGAIN_ADDR, (uint32)0);
   WriteCoreReg((uint32)V_TX_AVARGAIN_ADDR, (uint32)0);

   // Set Rx variable gain to unity ----------------------------------
   ul_data  = (gs_RxVarGain)|(gs_RxVarGainExp << 16);
   WriteCoreReg((uint32)V_RX_VARGAIN_ADDR, ul_data);
   WriteCoreReg((uint32)V_RX_AVARGAIN_ADDR, ul_data);


   //---------- set IFFT size and sampling rate -----------------------

   //Set IFFT size
   ul_data = gs_TxIfftLength;

   //Set IFFT sampling rate to 72 MHz (= 141.312/(1<<(8-IFFT_RATE)
   gul_TxIfftRate = (7)<<16;   //= IFFT_RATE << 16
   ul_data |= gul_TxIfftRate;

   WriteCoreReg((uint32)(V_TX_FSIZE_ADDR), ul_data);
   WriteCoreReg((uint32)(V_TX_FSIZE_A_ADDR), ul_data);

   //------------ set FFT size and sampling rate ------------------
   //Set FFT size
   ul_data = gs_RxFftLength;

   //Set FFT sampling rate to 72Mhz (=141.312/(1<<(8-FFT_RATE))
   gul_RxFftRate = (7)<<16; //FFT_RATE<<16
   ul_data |= gul_RxFftRate;

   WriteCoreReg((uint32)(V_RX_FSIZE_ADDR), ul_data);
   WriteCoreReg((uint32)(V_RX_FSIZE_A_ADDR), ul_data);


   //------------ set Tx/Rx SRC sampling rate and bypass mode --------------

   // Download SRC coeffs
   LoadSRCCoeffs();

   CfgSRC();

   //Set SRC TX input sample rate to 72 MHz (=144/(1<<(8-IN_RATE))
   ul_data = (7<<20)            //= IN_RATE<<20
             | (SRC_FACTOR_8KHZ);   //set SRC factor to 1
   //set TX and RX scaling to 0

   if(gs_STR_DbgCntl & STR_DBG_CNTL_DISABLE_SRC)
   {
      //Set TX and RX in bypass mode
      ul_data |= (TX_SRC_BYPASS|RX_SRC_BYPASS);
   }

   WriteCoreReg((uint32)(V_SRC_CFG_ADDR), ul_data);

   //This is done in LinkStart_ForPostGhs()
   //Take the strymon out of reset (wait until CRI
   //SetCoreReg((uint32)(V_CONTROL_ADDR), RESET_STATEN);

   //===========Following initializing the FT registers and memory ================
   //Instead of creating another function, we simply put the code to this funciton.
   {

      uint32 ul_tmpWord;

      //Initialize TX Status register (to default value 010000001b: QT 1, FT 0, FDF 2)
      //(Note set it to 0 does not work for COCOMO)
      WriteCoreReg(IRI_FTB_TX_STATUS_ADDR, (0x0081 | 0x124));

      //Initialize RX Status register (to default value 010000000b, QT 0, FT 0, FDF 2)
      WriteCoreReg(IRI_FTB_RX_STATUS_ADDR, (0x0080 | 0x124));

      ReadCoreReg(IRI_FTB_TX_STATUS_ADDR, &ul_tmpWord);
      guc_ftb_tx_qt = ul_tmpWord & 3;

      ReadCoreReg(IRI_FTB_RX_STATUS_ADDR, &ul_tmpWord);
      guc_ftb_rx_qt = ul_tmpWord & 3;

      // clean IFFT buffers
      ul_tmpWord = (IRI_FTB_IFFT_RAM_A_SIZE>>guc_PortMode);
      FillCoreBuf32(IRI_FTB_IFFT_RAM_A_ADDR, 0, (uint16)ul_tmpWord);
      FillCoreBuf32(IRI_FTB_IFFT_RAM_B_ADDR, 0, (uint16)ul_tmpWord);
      FillCoreBuf32(IRI_FTB_IFFT_RAM_C_ADDR, 0, (uint16)ul_tmpWord);
   }

}

void ReconfigVStrymonFor35bTraining(void)
{
   uint32 ul_data;

   //-----------------------------------------------------------------------------------------------------------
   // Hold Strymon in Reset until the configuration is complete
   //-----------------------------------------------------------------------------------------------------------
   ResetCoreReg((uint32)V_CONTROL_ADDR, RESET_STATEN);  // DisableStrymon();

   // Gets be enabled in fct. "Reconfig_CRI()"
   WriteCoreReg(CRI_TX_QTP_CTL_ADDR, 0);
   WriteCoreReg(CRI_TX_QT_CTL_ADDR, 0);
   WriteCoreReg(CRI_TX_IFFT_CTL_ADDR, 0);
   WriteCoreReg(CRI_RX_FFT_CTL_ADDR, 0);
   WriteCoreReg(CRI_RX_QT_CTL_ADDR, 0);
   WriteCoreReg(CRI_RX_QTP_CTL_ADDR, 0);

   // Clear V_OVERFLOW
   WriteCoreReg((uint32)V_OVERFLOW_ADDR, 0x1FFFF);

   // ---------- Configure TX interp ------------------------------
   // Load the interpolation FIR filter and configure the corresponding register
   LoadInterpFIR();

   // -------- Configure RX DECIM -------------------------
   // Rx Decim Bypass and set the sampling rate
   // Load the decimation filter and configure the corresponding register
   LoadDecimFIR();

   //------------ set Tx/Rx SRC sampling rate and bypass mode --------------
   // Download SRC coeffs
   LoadSRCCoeffs();
   //Configure SRC
   CfgSRC();

   //Set SRC interp and decim factor and scale
   //Set SRC TX input sample rate (=144/(1<<(8-INRATE))
   // According to RolandZ, RX SRC scale factor should be 1 for all modes in 518 BM
   // According to RolandZ, in case of 35B, no scaling is applied to the TX SRC.
   // 2x scaling factor is rather applied in the WDF_Int1.
   //For legacy mode, the TX SRC factor should be 2
   {
      uint32 ul_InRate;

      ul_InRate = gs_TxLog2IfftLength-7;

      if (gs_TxLog2IfftLength == 13)
      {
         ul_InRate += 1;
      }

      ul_data =  (((ul_InRate)<<20) |     // = IN_RATE<<20
                 (0 << 4) |               //   Rx Scale << 4
                 (0 << 1) |               // set Tx scaling to 1 for 35B mode
                 (SRC_FACTOR));
   }

   //set TX and RX scaling to 0
   WriteCoreReg((uint32)(V_SRC_CFG_ADDR), ul_data);

   //Set Bit 0 to operate SRC in 35B mode
   WriteCoreReg((uint32)(V_SRC_MSEL_35B_ADDR), V_SRC_MSEL_35B_MASK | (0x173B << 4)); //V_SRCCORR <19:4>, 0x1745


   // -------Configure TX IIR------------
   // Clear TX IIR coefficient memory
   FillCoreBuf32((uint32)V_TXIIR_CO_ADDR, (int32)0, (uint16)(V_TXIIR_CO_SIZE/4));
   // Get TX IIR filter selection from CMV
   // Filters are switched on by setting bits in OPTN 4
   gs_TxIIRFilterSelect = (gsa_Optn4_FilterControl[OPTN_4_IDX0_FILTER_CONF] & OPTN_TX_MASK_Filter_Select);
   if (gsa_Optn4_FilterControl[OPTN_4_IDX1_FILTER_CTRL] & OPTN_Tx_Filter_Auto_Reconfig)
   {
      //XDSLRTFW-3715 Start
      int16 s_FirstSupportedUS0Channel;
      //int16 s_LastSupportedUS0Channel;

      s_FirstSupportedUS0Channel = gsa_TxBandLeftChannel[0];
      //s_LastSupportedUS0Channel = gsa_TxBandRightChannel[0];
      if (s_FirstSupportedUS0Channel <= US0_POTS_ISDN_DETECT_TONE)
      {
         gs_TxIIRFilterSelect = OPTN_35B_VDSL_Filter_Select;
      }
      else
      {
         gs_TxIIRFilterSelect = OPTN_35B_VDSL_ISDN_Filter_Select;
      }
      //XDSLRTFW-3715 End
   }
   // Load TX IIR
   // LoadTxIIR();

   // -------- Configure RX IIR ------------------------
   // Clear RX IIR coefficient memory
   FillCoreBuf32((uint32)V_RXIIR_CO_ADDR, (int32)0, (uint16)(V_RXIIR_CO_SIZE/4));
   // Get RX IIR filter selection from CMV
   // Filters are switched on by setting bits in OPTN 4
   gs_RxIIRFilterSelect = ((gsa_Optn4_FilterControl[OPTN_4_IDX0_FILTER_CONF] >> OPTN_RX_Filter_Select_POS) & OPTN_TX_MASK_Filter_Select);
   // Load RX IIR
//   LoadRxIIR();

   // ------- Configure DEC_CFG --------------------------
   // Set DEC/TDQ in bypass and set sampling rate, disable dec
   // Set TDQ input sampling rate (= 141.312/(1<<(8-TDQ_IN_RATE))
   ul_data = (gs_RxLog2FftLength - 7) << 24;   //TDQ_IN_RATE<<24
   // Disable DEC
   WriteCoreReg((uint32)(V_DEC_CFG_ADDR), ul_data);

   // ------- Configure TDQ_CFG --------------------------
   // Set TDQ in bypass mode
   WriteCoreReg((uint32)(V_TDQ_CFG_ADDR), (uint32)TDQ_BYPASS);
   // Set Tx variable gain to 0 to shut off signal on power up.---------
   WriteCoreReg((uint32)V_TX_VARGAIN_ADDR, (uint32)0);
   WriteCoreReg((uint32)V_TX_AVARGAIN_ADDR, (uint32)0);

   // Set Rx variable gain to unity ----------------------------------
   ul_data  = (gs_RxVarGain)|(gs_RxVarGainExp << 16);
   WriteCoreReg((uint32)V_RX_VARGAIN_ADDR, ul_data);
   WriteCoreReg((uint32)V_RX_AVARGAIN_ADDR, ul_data);

   //---------- set IFFT size and sampling rate -----------------------
   //Set IFFT size
   ul_data = gs_TxIfftLength;
   //Set IFFT sampling rate (= 141.312/(1<<(8-IFFT_RATE)
   gul_TxIfftRate = (gs_TxLog2IfftLength - 7)<<16;   //= IFFT_RATE << 16
   ul_data |= gul_TxIfftRate;
   WriteCoreReg((uint32)(V_TX_FSIZE_ADDR), ul_data);
   WriteCoreReg((uint32)(V_TX_FSIZE_A_ADDR), ul_data);

   //------------ set FFT size and sampling rate ------------------
   // Set FFT size
   ul_data = gs_RxFftLength;
   // Set FFT sampling rate (=141.312/(1<<(8-FFT_RATE))
   gul_RxFftRate = (gs_RxLog2FftLength-7)<<16; //FFT_RATE<<16
   ul_data |= gul_RxFftRate;
   WriteCoreReg((uint32)(V_RX_FSIZE_ADDR), ul_data);
   WriteCoreReg((uint32)(V_RX_FSIZE_A_ADDR), ul_data);

   //This is done in LinkStart_ForPostGhs(), see fct. EnableStrymon()
   //Take the strymon out of reset (wait until CRI are configured!
   //SetCoreReg((uint32)(V_CONTROL_ADDR), RESET_STATEN);

   //===========Following initializing the FT registers and memory ================
   //Iridia FT & FTB Reconfiguration
   InitIridiaFT();
   InitIridiaQT_PostGhs();

}

void ReconfigVStrymonFor4kHzTraining(void)
{
   uint32 ul_data;

   //-----------------------------------------------------------------------------------------------------------
   // Hold Strymon in Reset until the configuration is complete
   //-----------------------------------------------------------------------------------------------------------
   ResetCoreReg((uint32)V_CONTROL_ADDR, RESET_STATEN);   // DisableStrymon();

   // Clear V_OVERFLOW
   WriteCoreReg((uint32)V_OVERFLOW_ADDR, 0x1FFFF);

   // ---------- Configure TX interp ------------------------------
   // Load the interpolation FIR filter and configure the corresponding register
   LoadInterpFIR();

   // -------- Configure RX DECIM -------------------------
   // Rx Decim Bypass and set the sampling rate
   // Load the decimation filter and configure the corresponding register
   LoadDecimFIR();

   //------------ set Tx/Rx SRC sampling rate and bypass mode --------------
   // Download SRC coeffs
   LoadSRCCoeffs();
   //Configure SRC
   CfgSRC();

   //Set SRC interp and decim factor and scale
   //Set SRC TX input sample rate (=144/(1<<(8-INRATE))
   // According to RolandZ, RX SRC scale factor should be 1 for all modes in 518 BM
   // According to RolandZ, in case of 35B, no scaling is applied to the TX SRC.
   // 2x scaling factor is rather applied in the WDF_Int1.
   //For legacy mode, the TX SRC factor should be 2
   {
      uint32 ul_InRate;

     //Set SRC TX input sample rate (=144/(1<<(8-INRATE))
     if(gs_TxLog2IfftLength == 9)
         ul_InRate = (gs_TxLog2IfftLength-6);
     else
         ul_InRate = (gs_TxLog2IfftLength-7);

     if (gft_Debug35bHwConfig17aModeEnable == TRUE) //35B Tx mode special test mode
     {
           ul_data =  (((ul_InRate+1)<<20)  |   // = IN_RATE<<20 = 144
                           (0 << 4)    |   // = Rx Scale << 4
                             (0 << 1)    |   // set Tx scaling to 1 for 35B mode
                       (SRC_FACTOR));
     }
     else                              ////17M Tx mode
       {
        ul_data =  (((ul_InRate)<<20)  |     // = IN_RATE<<20 = 72
                        (7 << 4)  |     // = Rx Scale << 4
                        (0 << 1)  |     // set Tx scaling to 1 for 35B mode
                    (SRC_FACTOR));
       }
   }

   WriteCoreReg((uint32)(V_SRC_CFG_ADDR), ul_data);

   //Set Bit 0 to operate SRC in 35B mode
   WriteCoreReg((uint32)(V_SRC_MSEL_35B_ADDR), V_SRC_MSEL_35B_MASK | (0x173B << 4)); //V_SRCCORR <19:4>, 0x1745


   // -------Configure TX IIR------------
   // Clear TX IIR coefficient memory
   FillCoreBuf32((uint32)V_TXIIR_CO_ADDR, (int32)0, (uint16)(V_TXIIR_CO_SIZE/4));
   // Get TX IIR filter selection from CMV
   // Filters are switched on by setting bits in OPTN 4
   gs_TxIIRFilterSelect = (gsa_Optn4_FilterControl[OPTN_4_IDX0_FILTER_CONF] & OPTN_TX_MASK_Filter_Select);
   // Load TX IIR
   // LoadTxIIR();

   // -------- Configure RX IIR ------------------------
   // Clear RX IIR coefficient memory
   FillCoreBuf32((uint32)V_RXIIR_CO_ADDR, (int32)0, (uint16)(V_RXIIR_CO_SIZE/4));
   // Get RX IIR filter selection from CMV
   // Filters are switched on by setting bits in OPTN 4
   gs_RxIIRFilterSelect = ((gsa_Optn4_FilterControl[OPTN_4_IDX0_FILTER_CONF] >> OPTN_RX_Filter_Select_POS) & OPTN_TX_MASK_Filter_Select);
   // Load RX IIR
   // LoadRxIIR();

   // ------- Configure DEC_CFG --------------------------
   // Set DEC/TDQ in bypass and set sampling rate, disable dec
   // Set TDQ input sampling rate (= 141.312/(1<<(8-TDQ_IN_RATE))
   ul_data = (gs_RxLog2FftLength - 7) << 24;   //TDQ_IN_RATE<<24
   // Disable DEC
   WriteCoreReg((uint32)(V_DEC_CFG_ADDR), ul_data);

   // ------- Configure TDQ_CFG --------------------------
   // Set TDQ in bypass mode
   WriteCoreReg((uint32)(V_TDQ_CFG_ADDR), (uint32)TDQ_BYPASS);
   // Set Tx variable gain to 0 to shut off signal on power up.---------
   WriteCoreReg((uint32)V_TX_VARGAIN_ADDR, (uint32)0);
   WriteCoreReg((uint32)V_TX_AVARGAIN_ADDR, (uint32)0);

   // Set Rx variable gain to unity ----------------------------------
   ul_data   = (gs_RxVarGain)|(gs_RxVarGainExp << 16);
   WriteCoreReg((uint32)V_RX_VARGAIN_ADDR, ul_data);
   WriteCoreReg((uint32)V_RX_AVARGAIN_ADDR, ul_data);

   //---------- set IFFT size and sampling rate -----------------------
   //Set IFFT size
   ul_data = gs_TxIfftLength;
   //Set IFFT sampling rate (= 141.312/(1<<(8-IFFT_RATE)
   gul_TxIfftRate = (gs_TxLog2IfftLength - 7)<<16;    //= IFFT_RATE << 16
   ul_data |= gul_TxIfftRate;
   WriteCoreReg((uint32)(V_TX_FSIZE_ADDR), ul_data);
   WriteCoreReg((uint32)(V_TX_FSIZE_A_ADDR), ul_data);

   //------------ set FFT size and sampling rate ------------------
   // Set FFT size
   ul_data = gs_RxFftLength;
   // Set FFT sampling rate (=141.312/(1<<(8-FFT_RATE))
   gul_RxFftRate = (gs_RxLog2FftLength-7)<<16; //FFT_RATE<<16
   ul_data |= gul_RxFftRate;
   WriteCoreReg((uint32)(V_RX_FSIZE_ADDR), ul_data);
   WriteCoreReg((uint32)(V_RX_FSIZE_A_ADDR), ul_data);

   //This is done in LinkStart_ForPostGhs(), see fct. EnableStrymon()
   //Take the strymon out of reset (wait until CRI are configured!
   //SetCoreReg((uint32)(V_CONTROL_ADDR), RESET_STATEN);

}
// XDSLRTFW-3441 Start
void CalculateAfeDfeGains(void)
{
   // FFT Gain[dB] = 20*log10(sqrt(FFTSize)/2^RSH), with FFTSize = 2*Nfft
   // Note: log10(x) = log2(X)*log10(2)
   //                = 20*(log2(sqrt(FFTSize)/2^RSH)*log10(2))
   //                = 20*(log2(sqrt(FFTSize))- log2(2^RSH))*log10(2))
   //                = (20*log2(sqrt(FFTSize)) - 20*log2(2^RSH)) * log10(2)
   //                = (10*log2(FFTSize) - 10*RSH*log2(2^2)) * log10(2)
   //                = (log2(FFTSize) - RSH*log2(2^2)) * 10*log10(2)
   //                = (log2(FFTSize) - RSH*2) * 3 in dB
   //
   // FFT Gain in Q8.8
   gt_DfeAfeGainSettings.s_Rx_FFT_Gain_Rms_dB =  ((gs_RxLog2FftLength - (gs_RxFftRsh << 1))*3) << 8;

   gt_DfeAfeGainSettings.s_Rx_Total_TdqToAfeInterface_Gain_dB =
            gt_DfeAfeGainSettings.s_Rx_CIC_Gain_dB + gt_DfeAfeGainSettings.s_Rx_WDF_DEC2_Gain_dB +
            gt_DfeAfeGainSettings.s_ADC_Adjust_Gain_dB + gt_DfeAfeGainSettings.s_Rx_WDF_DEC1_Gain_dB +
            gt_DfeAfeGainSettings.s_Rx_FIR_Decim1_Gain_dB + gt_DfeAfeGainSettings.s_Rx_SRC_Gain_dB +
            gt_DfeAfeGainSettings.s_Rx_IIR_Gain_dB + gt_DfeAfeGainSettings.s_Rx_TDQ_Gain_dB;

   // Q8.8
   // 20*log(2^RSH / (2Nfft)) + 10*log(2), with FFTSize = 2*Nfft
   // = 20*(log2(2^RSH / (FFTSize))* log10(2)) + 10*log(2)
   // = ((RSH*log2(2^1) - log2(FFTSize))* 20*log10(2)) + 10*log(2)
   // = ((RSH*1 - log2(FFTSize))* 20*log10(2)) + 10*log(2)
   // = ((RSH*1 - log2(FFTSize)) * 6) + 3
   // Note: gl_afe_fixed_gain gets be subtracted, therefore the sign must be inverted!
   // = - ((log2(FFTSize)-(RSH)) * 6) - 3), with 1541 = (20*log10(2) << 8) and 770 = (10*log(2) << 8)
   //
   gt_DfeAfeGainSettings.s_Rx_FFT_Gain_dBPerHz = (((gs_RxLog2FftLength - gs_RxFftRsh)*1541) - 770);
}
// XDSLRTFW-3441 End

