/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2006 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: v_str_src_ini.c
*
*-------------------------------------------------------------------------------
*/


#include "common.h"
#include "ll_iof.h"
#include "str_memmap.h"
#include "data_alloc.h"
#include "gdata.h"
#include "cmv.h"
#include "AFED_Functions.h"
#include "vrx5afe_mode_defines.h"


extern int16 gs_frame_rate_is_8khz;

extern void SwapInPage(uint8 uc_PageNum); //function is in main_hw.c

extern int16 gsa_StrymonFir_Filter_RxDecim_vdsl2_30[];
extern int16 gsa_StrymonFir_Filter_RxDecim_vdsl2_17[];
extern int16 gsa_StrymonFir_Filter_RxDecim_lrvdsl_8[];
extern int16  gsa_StrymonFir_Filter_RxDecim_Plus[];

void LoadSRCCoeffs(void)
{
   // depends on 4K or 8K frame rate,
   // Use XDMA to codeswap the page whose destination is mapped directly to strymon memory
   uint8 uc_swapPage =  VDSL_SRC_COEFS_4KHZ_DM_SWAPPAGE;

   if (gs_frame_rate_is_8khz)
   {
      uc_swapPage = VDSL_SRC_COEFS_8KHZ_DM_SWAPPAGE;
   }

   if ( (gt_ProfileAct.us_ProfileSelected & CNFG_V2_PROFILE_35B_MASK) || (gft_Debug35bHwConfig17aModeEnable == TRUE) )
   {
      uc_swapPage = VDSL_SRC_COEFS_35B_RX_DM_SWAPPAGE;
      SwapInPage(uc_swapPage); // This loads to V_RXSRC_B00_ADDR

      uc_swapPage = VDSL_SRC_COEFS_35B_TX_DM_SWAPPAGE;
      SwapInPage(uc_swapPage); // This loads to V_TXSRC_B00_ADDR
   }
   else
   {
      //VRX218 & VRX318 platforms
      // this function is currently running the BG (during pre-HS and post-HS)
      // so it is OK to call SwapInPage which has also been modified to run
      // correctly under VDSL_62
      SwapInPage(uc_swapPage); // This loads to V_RXSRC_B00_ADDR
      // Copy from Rx to TX strymon with adma.
      WriteCoreBuf32(V_TXSRC_B00_ADDR,(int16 *)(void *) V_RXSRC_B00_ADDR, 3072);
   }

}




/*******************************************************************************
*
*   Prototype: void CfgSRC(void)
*
*   This function configure the SRC operation.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*******************************************************************************/
void CfgSRC(void)
{
   WriteCoreReg(V_SRCFR_ADDR, 0); // Clear initial nominal SRCFR value
   WriteCoreReg(V_SRCCTL_ADDR, 0);

   //If SRC is disabled, do not set SRCFR register
   if(gs_STR_DbgCntl & STR_DBG_CNTL_DISABLE_SRC)
   {
      return;
   }


   // If clocks are NOT tied
   if (gs_TiedClocks == 0)
   {
      //SetSRCFR(); // Write initial nominal SRCFR value
      if ( (gt_ProfileAct.us_ProfileSelected & CNFG_V2_PROFILE_35B_MASK) || (gft_Debug35bHwConfig17aModeEnable == TRUE))
      {
         gl_constant_SRCFR_offset = 0x4DE9C;
      }
      WriteCoreReg((uint32)V_SRCFR_ADDR, gl_constant_SRCFR_offset);
   }

} //void CfgSRC(void)


/*
*-------------------------------------------------------------------------------
*
*   Prototype: void LoadDecimFIR(void)
*
*   This function loads RX FIR decimation filter.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*      gs_RxLog2FftLength -- (I) log2 of RX FFT size
*      gs_frame_rate_is_8khz -- (I) flag to indicate if it is 8 khz or 4 khz frame rate
*      gsa_StrymonFir_Filter_RxDecim_vdsl2_17[] -- the decimation filter for 17 Mhz profile
*      gsa_StrymonFir_Filter_RxDecim_vdsl2_30[] -- the decimation filter for 30 Mhz profile
*      gsa_StrymonFir_Filter_RxDecim_lrvdsl_8[] -- the decimation filter for 8 Mhz profile
*      gul_DecimCfg_reg -- (O) the DECIM_CFG register variable initailized to 0
*-------------------------------------------------------------------------------
*/

void LoadDecimFIR(void)
{
   uint32 ul_data;
   int16 *psa_CoefBuf;
   uint16 us_NCo;

   // Set the output sampling rate = input sampling rate/(1<<RX_DECIM_FACTOR)
   ul_data = (14 - gs_RxLog2FftLength) << 24; //RX_DECIM_FACTOR <<24

   // Set the decimation filter input sample rate at 144 Mhz
   ul_data |= (RX_DECIM_IN_RATE_144);

   if(gs_STR_DbgCntl & STR_DBG_CNTL_DISABLE_RXDEC)
   {
      ul_data |= RX_DECIM_BYPASS;

      //Write to the Decimation register
      WriteCoreReg(V_DECIM_CFG_ADDR, ul_data);

      return;
   }

   //Configure the decimation output scaling and filter length
   //2 for 30 and 17 Mhz bandwidth and 4 for 8 Mhz

#define DECIM_SCALE_4096        (-1)
#define DECIM_SCALE_2048        (-2)
#define DECIM_LEN                       (3)
#define DECIM_ACT_LEN           ((DECIM_LEN+1)*8)               //actual length
#define DECIM_SCALE_512          (4)
#define DECIM_LEN_512            (15)
#define DECIM_ACT_LEN_512        ((DECIM_LEN_512)*8)
   if(gs_RxLog2FftLength == 13)
      ul_data |= ((DECIM_SCALE_4096 & 7)<<28) | (DECIM_LEN);
   else //if(gs_RxLog2FftLength == 12)
      ul_data |= ((DECIM_SCALE_2048 & 7)<<28) | (DECIM_LEN);

   //Write to the Decimation register
   WriteCoreReg((uint32)(V_DECIM_CFG_ADDR), ul_data);

   us_NCo = DECIM_ACT_LEN>>1;
   //Load the filter coefficients to HW
   if(gs_RxLog2FftLength == 13)
   {
      if(gs_frame_rate_is_8khz)
      {
         psa_CoefBuf = gsa_StrymonFir_Filter_RxDecim_vdsl2_30;
      }
      else
      {
         psa_CoefBuf = gsa_StrymonFir_Filter_RxDecim_vdsl2_17;
      }
   }
   else //if(gs_RxLog2FftLength == 12)
   {
      psa_CoefBuf = gsa_StrymonFir_Filter_RxDecim_lrvdsl_8;
   }

   WriteCoreBuf32(V_DECIM_CO_ADDR, psa_CoefBuf,us_NCo);

   gul_DecimCfg_reg = 0;


} //void LoadDecimFIR(void)

////////////////////////////////////////////////////////////////////////////////////////////////
//Function Name:
//Description: This function Initialiseds the DFI register for starting VDSL mode Handshake
// Prototype:
//
//
// Input Arguments:
//             None
//  Output Arguments:
//             None
// Return:
//                None
// Global Variables Used:
//
// Notes
//
////////////////////////////////////////////////////////////////////////////////////////////////

void VRX518_DfiConfig_Common()
{
   uint32 ul_RegData =0;
   // this check is for VRx518 bring-up only
   if (gus_SkipAfeFlow & 0x0001)
   {
      return;
   }

   //
   //0x30C780   V_LBK_35B      Strymon-VFDF Loopback Control  0x00000060    0x0000000   0x00000000  0x00000100
   if (gus_TxSRC_OutRate == VRX518_SRC_OUTRATE_144MHZ) //for 35b only
   {
      ul_RegData |= (V_LBK_35B_SRC_SEL_RXWDF1 | V_LBK_35B_DFI_SEL_TXWDF1);
   }

   if (gus_DAC_Rate == VRX518_DAC_RATE_144MHZ)
   {
      ul_RegData |= V_LBK_35B_NS_SEL_DFI;
   }

   if (gus_ADC_Rate == VRX518_ADC_RATE_576MHZ)
   {
      ul_RegData |= V_LBK_35B_ADCADJ_SEL_CIC;
   }

   WriteCoreReg((uint32)(V_LBK_35B_ADDR), ul_RegData);
   //Reset DFI BLOCK should be before AFE init. The reason is after AFE Config we are not suppose reset this
   //only RX.FIFO_RSTN should be done here
   //0x30C78C   V_DFI_BLOCK_RSTN_35B       DFI Block Reset Register      0x00000000   0x00000000   0x00000000   0x00000000
   //0x30C78C   V_DFI_BLOCK_RSTN_35B       DFI Block Reset Register      0x00070007   0x00070007   0x00070007   0x00070007
   WriteCoreReg((uint32)(V_DFI_BLK_RSTN_35B_ADDR), 0x00050005);
   WriteCoreReg((uint32)(V_DFI_BLK_RSTN_35B_ADDR), 0x00070007);
}

void VRX518_DfiConfig_TxPath(void)
{
   // this check is for VRx518 bring-up only
   if (gus_SkipAfeFlow & 0x0002)
   {
      return;
   }

   //Address   Register Name            Short Description            35b_Mode   30a_Mode   17a_Mode   8a_Mode
   //0x30B000   V_TX_WDF_INT1_CTRL_35B      Tx WDF INT1 control register   0x00000002   0x00000000   0x00000000   0x00000000
   //0x30B004   V_TX_WDF_INT1_COEF_35B      Tx WDF INT1 coefficient reg      0xcb78390f   0x00000000   0x00000000   0x00000000
   //0x30B000   V_TX_WDF_INT1_CTRL_35B      Tx WDF INT1 control register   0x00000009
   if (gus_TxSRC_OutRate == VRX518_SRC_OUTRATE_144MHZ)  //35B
   {
      WriteCoreReg((uint32)(V_TX_WDF_INT1_CTRL_35B_ADDR), 0x00000002);
      WriteCoreReg((uint32)(V_TX_WDF_INT1_COEF_35B_ADDR), 0xcb78390f);
      //SoC team done SRC performance test including the WDF for profile 35B and found that we do not need the additional scaling
      //So the configuration V_TX_WDF_INT1_CTRL_35B(0x30B000)=0x00000001 instead of 0x00000009
      WriteCoreReg((uint32)(V_TX_WDF_INT1_CTRL_35B_ADDR), 0x00000001);//
   }
   else
   {
      WriteCoreReg((uint32)(V_TX_WDF_INT1_CTRL_35B_ADDR), 0x00000000);
      WriteCoreReg((uint32)(V_TX_WDF_INT1_COEF_35B_ADDR), 0x00000000);
   }
   //0x30B400   DFI_TX_WDF_INT2_CTRL_35B   Tx WDF INT2 control register   0x00000002   0x00000002   0x00000002   0x00000002
   //0x30B404   DFI_TX_WDF_INT2_COEF_35B   Tx WDF INT2 coefficient reg      0x00ae4711   0x00ae4711   0x00ae4711   0x00ae4711
   //0x30B400   DFI_TX_WDF_INT2_CTRL_35B   Tx WDF INT2 control register   0x00000001   0x00000001   0x00000001   0x00000001
   if (gus_DAC_Rate == VRX518_DAC_RATE_144MHZ)
   {
      WriteCoreReg((uint32)(V_DFI_TX_WDF_INT2_CTRL_35B_ADDR), 0x00000000);
      WriteCoreReg((uint32)(V_DFI_TX_WDF_INT2_COEF_35B_ADDR), 0x00000000);
   }
   else
   {
      WriteCoreReg((uint32)(V_DFI_TX_WDF_INT2_CTRL_35B_ADDR), 0x00000002);
      WriteCoreReg((uint32)(V_DFI_TX_WDF_INT2_COEF_35B_ADDR), 0x00ae4711);
      WriteCoreReg((uint32)(V_DFI_TX_WDF_INT2_CTRL_35B_ADDR), 0x00000001);
   }
   //                                                                        35B         30a         17/12/8     8
   //0x30B700  DFI_TX_NS_CTRL_35B         Tx NS control register        0x00000002  0x00000002  0x00000002  0x00000002
   //0x30B704   DFI_TX_NS_COEF_35B         Tx NS coefficient register      0x00000199   0x00000000   0x00000000   0x00000000
   //0x30B700   DFI_TX_NS_CTRL_35B         Tx NS control register         0x00000021   0x00000011   0x00000011   0x00000011

   if ( (gus_TxSRC_OutRate == VRX518_SRC_OUTRATE_144MHZ) || (gus_TxSRC_UpsamplingFactor == 0) ) //for 35B or 30a XDSLRTFW-4052 XDSLRTFW-4064
   {
      WriteCoreReg((uint32)(V_DFI_TX_NS_CTRL_35B_ADDR), 0x00000002);
      if (gs_TxPathAfeDfeCustomSettings & DFE_TX_NS_VDSL_MODE) //XDSLRTFW-3361
      {
         WriteCoreReg((uint32)(V_DFI_TX_NS_COEF_35B_ADDR), 0x00000000);
         WriteCoreReg((uint32)(V_DFI_TX_NS_CTRL_35B_ADDR), 0x00000011);
      }
      else
      {
         WriteCoreReg((uint32)(V_DFI_TX_NS_COEF_35B_ADDR), 0x00000199);
         WriteCoreReg((uint32)(V_DFI_TX_NS_CTRL_35B_ADDR), 0x00000021);
      }
   }
   else if(gus_DAC_Rate == VRX518_DAC_RATE_144MHZ)
   {
      WriteCoreReg((uint32)(V_DFI_TX_NS_CTRL_35B_ADDR), 0x0000000A);
      WriteCoreReg((uint32)(V_DFI_TX_NS_COEF_35B_ADDR), 0x000002FF);
      WriteCoreReg((uint32)(V_DFI_TX_NS_CTRL_35B_ADDR), 0x0000003D);
   }
   else
   {
      WriteCoreReg((uint32)(V_DFI_TX_NS_CTRL_35B_ADDR), 0x00000002);

      if (gs_TxPathAfeDfeCustomSettings & DFE_TX_NS_ADSL_MODE)
      {
         WriteCoreReg((uint32)(V_DFI_TX_NS_COEF_35B_ADDR), 0x000002FF);
         WriteCoreReg((uint32)(V_DFI_TX_NS_CTRL_35B_ADDR), 0x00000035);
      }
      else
      {
         WriteCoreReg((uint32)(V_DFI_TX_NS_COEF_35B_ADDR), 0x00000000);
         WriteCoreReg((uint32)(V_DFI_TX_NS_CTRL_35B_ADDR), 0x00000011);
      }
   }
   //0x30C784   V_DFI_TX_FIFO_35B         DFI TX FIFO Control/status Reg   0x00000033   0x00000033   0x00000033   0x00000033
   WriteCoreReg((uint32)(V_DFI_TX_FIFO_35B_ADDR), 0x00030033);
}

void VRX518_DfiConfig_RxPath(void)
{
   // this check is for VRx518 bring-up only
   if (gus_SkipAfeFlow & 0x0004)
   {
      return;
   }

   //Address    Register Name               Short Description                35b_Mode     30a_Mode     17a_Mode      8a_Mode
   //0x30B100   V_RX_WDF_DEC1_CTRL_35B      Rx WDF DEC1 control register   0x00000002   0x00000000   0x00000000   0x00000000
   //0x30B104   V_RX_WDF_DEC1_COEF_35B      Rx WDF DEC1 coefficient reg    0xcb78390f   0x00000000   0x00000000   0x00000000
   //0x30B100   V_RX_WDF_DEC1_CTRL_35B      Rx WDF DEC1 control register   0x00000001
   if (gus_TxSRC_OutRate == VRX518_SRC_OUTRATE_144MHZ)  //35B
   {
      WriteCoreReg((uint32)(V_RX_WDF_DEC1_CTRL_35B_ADDR), 0x00000002);
      WriteCoreReg((uint32)(V_RX_WDF_DEC1_COEF_35B_ADDR), 0xcb78390f);

      if (gus_SkipAfeFlow & 0x1000)
      {
         WriteCoreReg((uint32)(V_RX_WDF_DEC1_CTRL_35B_ADDR), 0x00000009);
      }
      else
      {
         WriteCoreReg((uint32)(V_RX_WDF_DEC1_CTRL_35B_ADDR), 0x00000001);
      }
   }
   else
   {
      WriteCoreReg((uint32)(V_RX_WDF_DEC1_CTRL_35B_ADDR), 0x00000000);
      WriteCoreReg((uint32)(V_RX_WDF_DEC1_COEF_35B_ADDR), 0x00000000);
   }
   //0x30B500   DFI_RX_WDF_DEC2_CTRL_35B   Rx WDF DEC2 control register   0x00000002   0x00000002   0x00000002   0x00000000
   //0x30B504   DFI_RX_WDF_DEC2_COEF_35B   Rx WDF DEC2 coefficient reg    0x00ae4711   0x00ae4711   0x00ae4711   0x00000000
   //0x30B500   DFI_RX_WDF_DEC2_CTRL_35B   WDF DEC2 control register      0x00000001   0x00000001   0x00000001
   //0x30B600   DFI_RX_CIC_DEC_CTRL_35B    Rx CIC Decimator control reg   0x00000002   0x00000002   0x00000002   0x0000000A
   //0x30B600   DFI_RX_CIC_DEC_CTRL_35B    Rx CIC Decimator control reg   0x00000001   0x00000001   0x00000001   0x00000009


   if (gus_ADC_Rate == VRX518_ADC_RATE_576MHZ)  //8MHz ADSLx
   {
      WriteCoreReg((uint32)(V_DFI_RX_WDF_DEC2_CTRL_35B_ADDR), 0x00000000);
      WriteCoreReg((uint32)(V_DFI_RX_WDF_DEC2_COEF_35B_ADDR), 0x00000000);

      WriteCoreReg((uint32)(V_DFI_RX_CIC_DEC_CTRL_35B_ADDR), 0x0000000A);
      WriteCoreReg((uint32)(V_DFI_RX_CIC_DEC_CTRL_35B_ADDR), 0x00000009);
   }
   else  //35 MHz 30MHz 17MHz 12 MHz
   {
      WriteCoreReg((uint32)(V_DFI_RX_WDF_DEC2_CTRL_35B_ADDR), 0x00000002);
      WriteCoreReg((uint32)(V_DFI_RX_WDF_DEC2_COEF_35B_ADDR), 0x00ae4711);
      WriteCoreReg((uint32)(V_DFI_RX_WDF_DEC2_CTRL_35B_ADDR), 0x00000001);

      WriteCoreReg((uint32)(V_DFI_RX_CIC_DEC_CTRL_35B_ADDR), 0x00000002);
      WriteCoreReg((uint32)(V_DFI_RX_CIC_DEC_CTRL_35B_ADDR), 0x00000001);
   }

   //0x30C788   V_DFI_RX_FIFO_35B         DFI RX FIFO Control/status Reg   0x00000033   0x00000033   0x00000033   0x00000033
   WriteCoreReg((uint32)(V_DFI_RX_FIFO_35B_ADDR), 0x00030033);
}


