/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2005 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: ZPH_Ini.c
*
*   This file contains initialization routines for Zephyr core
*
*-------------------------------------------------------------------------------
*/

#include "common.h"
#include "gdata.h"
#include "zep_memmap.h"
#include "zep_memmap_cnfg.h"
#include "zep_ilv_memmap.h"
#include "LL_IOf.h"
//uint32 gl_ilvSize1;
/*
*-------------------------------------------------------------------------------
*
*   Prototype: void InitZephyr(void)
*
*   This function initializes Zephyr core.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/

void InitZephyr(void)
{
   // reset all Zephyr-FCI TX per-port based registers
#define NUM_TX_PER_PORT_REGS   ((ZEP_REG_ZT_ALU_CLI_REQ_ALIAS2_ADDR - ZEP_REG_ZT_FIFO_ACCESS_ADDR + 4)/4)
   FillCoreBuf32(ZEP_REG_ZT_FIFO_ACCESS_ADDR, 0, NUM_TX_PER_PORT_REGS);

   // reset all Zephyr-FCI RX per-port based registers
#define NUM_RX_PER_PORT_REGS   ((ZEP_REG_ZR_ALU_CLI_REQ_ALIAS2_ADDR - ZEP_REG_ZR_FIFO_ACCESS_ADDR + 4)/4)
   FillCoreBuf32(ZEP_REG_ZR_FIFO_ACCESS_ADDR, 0, NUM_RX_PER_PORT_REGS);

   //The following register initialization is done before showtime
   //in ClearTxZephyrRegs() and ClearRxZephyrRegs()
   //since these memory blocks are used during the training


}

// these ILV/DTB setup functions are in INIT_2 page
// and will be called during InitModem_PreHandshake()
void InitZepIlvHwVariables(void)
{

   //Init. the base address of interleave/deinterleaver buffer
   gula_txILVBaseAddr[LP0] = ZEP_ILV_LP0_BASE;
   gula_txILVBaseAddr[LP1] = ZEP_ILV_LP1_BASE;
   gula_rxILVBaseAddr[LP0] = ZEP_DILV_LP0_BASE;
   gula_rxILVBaseAddr[LP1] = ZEP_DILV_LP1_BASE;

   if(gft_NE_IlvDilvMemType == SEPARATE_ILV)
   {
      gul_HW_ILV_MEM_SIZE[LP0] = ZEP_ILV_LP0_BLOCK_SIZE >>guc_PortMode ;   // the maximum HW interleaver memory allowed to use
      gul_HW_DILV_MEM_SIZE[LP0] = ZEP_DILV_LP0_BLOCK_SIZE>>guc_PortMode; // the maximum HW deinterleaver memory allowed to use
      gul_HW_ILV_MEM_SIZE[LP1] = ZEP_ILV_LP1_BLOCK_SIZE>>guc_PortMode;   // the maximum HW interleaver memory allowed to use
      gul_HW_DILV_MEM_SIZE[LP1] = ZEP_DILV_LP1_BLOCK_SIZE>>guc_PortMode; // the maximum HW deinterleaver memory allowed to use
   }
   else
   {
      gul_HW_ILV_MEM_SIZE[LP0] = (ZEP_ILV_LP0_BLOCK_SIZE+ZEP_DILV_LP0_BLOCK_SIZE)>>guc_PortMode;
      gul_HW_DILV_MEM_SIZE[LP0] = gul_HW_ILV_MEM_SIZE[LP0];
      gul_HW_ILV_MEM_SIZE[LP1] = (ZEP_ILV_LP1_BLOCK_SIZE+ZEP_DILV_LP1_BLOCK_SIZE)>>guc_PortMode;
      gul_HW_DILV_MEM_SIZE[LP1] = gul_HW_ILV_MEM_SIZE[LP1];
   }
}


void SetupDefaultIlvDilv(void)
{
   gft_FE_IlvDilvMemType = UNKNOWN_ILV; // assume FE ILV/DILV memory type is unknown
   gul_FE_HW_ILV_MEM_SIZE = 0; // assume FE ILV size is unknown by default
   gul_FE_HW_DILV_MEM_SIZE = 0; // assume FE DILV size is unknown by default

   gft_NE_IlvDilvMemType = SHARED_ILV;

   //Initialize variables related to the Zephyr HW interleave/deinterleave memory
   InitZepIlvHwVariables();
}

void SetupDefaultDTB(void)
{
   gs_ZEP_DTB_SIZE_TX_WDS = DEFAULT_ZEP_DTB_SIZE_TX_WDS;
   gs_ZEP_DTB_SIZE_RX_WDS = DEFAULT_ZEP_DTB_SIZE_RX_WDS;

   gs_ZEP_ILV_RAM_TXDTB_OFFSET = DEFAULT_ZEP_ILV_RAM_TXDTB_OFFSET;
   //gs_ZEP_ILV_RAM_RXDTB_OFFSET = gs_ZEP_ILV_RAM_TXDTB_OFFSET + gs_ZEP_DTB_SIZE_TX_WDS;
   gs_ZEP_ILV_RAM_RXDTB_OFFSET = DEFAULT_ZEP_ILV_RAM_RXDTB_OFFSET;

   gs_ZEP_ILV_RAM_TXDTB_LP0_SIZE = DEFAULT_ZEP_ILV_RAM_TXDTB_LP0_SIZE;
   gs_ZEP_ILV_RAM_TXDTB_LP2_SIZE = DEFAULT_ZEP_ILV_RAM_TXDTB_LP2_SIZE;
   //gs_ZEP_ILV_RAM_TXDTB_LP1_SIZE = gs_ZEP_DTB_SIZE_TX_WDS - gs_ZEP_ILV_RAM_TXDTB_LP0_SIZE - gs_ZEP_ILV_RAM_TXDTB_LP2_SIZE;
   gs_ZEP_ILV_RAM_TXDTB_LP1_SIZE = DEFAULT_ZEP_ILV_RAM_TXDTB_LP1_SIZE;

   //DTB Ping Pong will be done in Rx LP0 path only, since LP0 alone carries both Data & OH data
   gs_ZEP_ILV_RAM_RXDTB_LP0_SIZE = DEFAULT_ZEP_ILV_RAM_RXDTB_LP0_SIZE;
   gs_ZEP_ILV_RAM_RXDTB_LP0_PONG_SIZE = DEFAULT_ZEP_ILV_RAM_RXDTB_LP0_SIZE;
   gs_ZEP_ILV_RAM_RXDTB_LP2_SIZE = DEFAULT_ZEP_ILV_RAM_RXDTB_LP2_SIZE;
   gs_ZEP_ILV_RAM_RXDTB_LP1_SIZE = DEFAULT_ZEP_ILV_RAM_RXDTB_LP1_SIZE;
}
