/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 2008-2009 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: Zep_microCodeData.c
*
*   This file contains micro Code for Zephyr code engines.
*
*-------------------------------------------------------------------------------
*/
//  Zep_microCodeData.c
//
// History
//
//19/07/2013 Kannan: Changes are done to support US ReTx
//Grep for "XDSLRTFW-1048 Feature_US_VDSL2_ALL_UsReTx"
//
//25/09/2013 Kannan: Simplified the DS ReTx microcode designed for DS BC0 LP1
//           "fci_prog_rx_vdsl2_bc0_lp1_retx". This change will allow the DSL FW to modify the
//           ILV buffer write pointer.
//01/10/2013 Kannan: In order to align DTU size's to be in 32bit word boundary, byte stuffing is done
//           at the ReTx Queue with a dummy byte constant 0x55. No of bytes to be stuffed
//           is indicated from the DSL FW through ZEP_PRAM_ZR_CRC1_LP1_ADDR <15:8>. DS ReTx Micro code
//           is done at "fci_prog_rx_vdsl2_bc0_lp1_retx". These stuffed bytes should be excluded while
//           delivering data to the PPE.
//09/09/2014 Kannan: Framing Processors FP3 & FP4 are used to pull data from the TC layer.
//           They are stopped exactly at the DTU boundaries(before RS encoder)
//           during retransmission as well as DTU stoppage period while performing US SRA.
//           This is required to avoid preprocessing of SID & TS in advance.
//           FP3 & FP4 gets input from DSL FW through "ZEP_PRAM_ZT_R12_LP1_ADDR" register.
//           i.e To start partial DTU "guc_StPartialDtuTc" <23:16>,
//           Num of DTU end boundaries "guc_num_Dtu_EndBoundary" <15:8>,
//           To start new DTU "guc_StNewDtuTc" <7:0>. FP3 maintains an internal counter to keep track
//           of DTU boundaries <31:24> in ZEP_PRAM_ZT_R12_LP1_ADDR, but FP4 maintains an internal
//           counter to keep track of DTU boundaries <31:24> at "ZEP_PRAM_ZT_FRAMING_LP1_ADDR".
//           These changes are done in the micro code "fci_prog_tx_vdsl2_bc0_lp1_retx",
//           Micro code version "0x7013"
//
// 29/10/2014 Anantha Ramu: Added microcode for US & DS Intra DTU Interleaving.
//            Grep for "XDSLRTFW-1617"
//
// 26/11/2015 Anantha Ramu: Added modifications for SRA with US Intra DTU Interleaving.
//                           Grep for "XDSLRTFW-2341".
// 14/10/2016 Kannan: "fci_prog_rx_vdsl2_bc0_lp1_retx" modified to handle upto 4 DTU's for DTU's write in ReTx
//            Rx Queue buffer. Micro code get 4th DTU write address through the register ZR_VBC_SIZE_LP1.
//            ZR_VBC_SIZE_LP1 register will not be used for ReTx. This change needs to be done for DS intra dtu interleaving
//            micro code in "fci_prog_rx_vdsl2_bc0_lp1_retx_idilv".
//
// 29/10/2016 Kannan: "fci_prog_rx_vdsl2_bc0_lp1_retx" modified to handle up to 4 DTU's for DTU's Forward from IIBRAM locations
//            0x4C000(DTU1), 0x4D000(DTU2), 0x4E000(DTU3) & 0x4F000(DTU4) to TC layer using FIFO3 interface instead of ILVB interface.
//            This change is done to avoid sequential using of ILVB interface to reduce Zephyr MIPS consumption to support
//            35B mode higher data rate 350Mbps.
//
// 03/01/2017 Kannan: "fci_prog_rx_vdsl2_bc0_lp1_retx_idilv" modified to handle upto 4 DTU's for DTU's write in ReTx
//            Rx Queue buffer. Micro code get 4th DTU write address through the register ZR_VBC_SIZE_LP1.
//            ZR_VBC_SIZE_LP1 register will not be used for ReTx. This change done for DS intra dtu interleaving.
//
// 03/01/2017 Kannan: "fci_prog_rx_vdsl2_bc0_lp1_retx_idilv" modified to handle up to 4 DTU's for DTU's Forward from IIBRAM locations
//            0x4C000(DTU1), 0x4D000(DTU2), 0x4E000(DTU3) & 0x4F000(DTU4) to TC layer using FIFO3 interface instead of ILVB interface.
//            This change is done to avoid sequential using of ILVB interface to reduce Zephyr MIPS consumption to support
//            35B mode higher data rate 350Mbps.
//
// 13/09/2017 Kannan: "fci_prog_rx_vdsl2_bc0_lp1_retx" modified to use ILVB interface for SID, TS and DTU_STATUS writing
//            instead of FIFO1 interface. This is done to reduce the cycle consumption by the DSP.
//            Zephyr perspective cycle consumption is close to each other either use of FIFO1 or ILVB interface.
//            Reading SID, TS and DTU_STATUS by DSP from IIBRAM (direct reading) is much faster than
//            reading through FIFO1 interface.
//            DTU format in which ILVB interface is used to write the SID, TS and DTU Status
//            /---DTU PAYLOAD -/
//            /---DUMMY_BYTES--/ for 32bit alignment
//            /<B4><B3><B2><B1>/ <B1> (SID); <B2> (TS); <B3> (DTU_STATUS: 0 (Good), 1 (Bad), 0xFF (DTU is empty)); <B4> (Empty Byte)
//            Above mentioned change is done for iDTU as well in "fci_prog_rx_vdsl2_bc0_lp1_retx_idilv"
// ************************************************************************************************************

#include "common.h"
#include "data_alloc.h"


#ifdef MICROCODE_USE_FIFO3
#define TX_FIFO3_WRITE
#define RX_FIFO3_WRITE_UPDATED
#endif


//
// Normal mode uCode.
DATA_MAP_FCI_TX_LP0_UCODE

#ifndef TX_FIFO3_WRITE
int fci_prog_tx_vdsl2_bc0_lp0[] =
{
   0x04001, // ID.bc.lp.v
   //  No debug write to fifo3.

   0x0000003f, // UPROC_ENA
   0x0000,   5, 0x00000000, 0x20000000, 0x00000000, 0x00000002, 0x00000000,  // Code block 0 base, size, STATE0-4
   0x0005,   3, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 1 base, size, STATE0-4
   0x0008,   3, 0x00000000, 0x20000000, 0x00000000, 0x04000000, 0x00000000,  // Code block 2 base, size, STATE0-4
   0x000b,  13, 0x00000000, 0x20000000, 0x00000000, 0x00004400, 0x00000000,  // Code block 3 base, size, STATE0-4
   0x0018,  15, 0x00000000, 0x50000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 4 base, size, STATE0-4
   0x0027,   9, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 5 base, size, STATE0-4
   0x0000,   0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 6 base, size, STATE0-4
   0x0000,   0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 7 base, size, STATE0-4
   0x0000,   0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 8 base, size, STATE0-4
   0x0000,   0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 9 base, size, STATE0-4
   0x04000004, // FLAG_DATA 0
   0x00000050, // FLAG_DATA 1
   48, // Total code length
   // Code block 0 memory
   0x6d10c00e, //   0('h00000): SET_IO(`IN(SCR_D), `OUT(RS_D), `KEEP_MASK)
   0x80000811, //   1('h00001): MOV(`R(ZT_CODEWORD+0x001,0))
   0x6c01c010, //   2('h00002): SET_IO(`IN(RS_D), `OUT(FP1))
   0x80000812, //   3('h00003): MOV(`R(ZT_CODEWORD+0x002,0))
   0x40020000, //   4('h00004): JUMP(0)  // END_FOREVER
   // Code block 1 memory
   0x8d400df8, //   0('h00005): MOV(`R(ZT_PMS_SIZE+0x000,1), `OUT(ILV0))
   0x00004000, //   1('h00006): WAIT_EVENT(WAIT_STOP)
   0x40020000, //   2('h00007): JUMP(0)  // END_FOREVER
   // Code block 2 memory
   0xa9411df8, //   0('h00008): MOV(`R(ZT_PMS_SIZE+0x000,1), `IN(ILV0), `FLAG_MODE(FLAG_MODE_OR), `FLAG_MASK(4'h1), `APPLY_MODE(APPLY_MODE_LAST))
   0x00004000, //   1('h00009): WAIT_EVENT(WAIT_STOP)
   0x40020000, //   2('h0000a): JUMP(0)  // END_FOREVER
   // Code block 3 memory
   0xc850081c, //   0('h0000b): MOV(`R(ZT_OHRATE+0x000,0), `IN(FP5), `KEEP_CNT)
   0x89600c1e, //   1('h0000c): MOV(`R(ZT_OHRATE+0x002,1), `IN(TCLAYER))
   0x80000c14, //   2('h0000d): MOV(`R(ZT_VBC_SIZE+0x000,1))
   0x400c081b, //   3('h0000e): JUMP(0, `REPEAT(`R(ZT_FRAMING+0x003,0)), `KEEP_CNT)  // END_WHILE_CNT_LT(`R(ZT_FRAMING+0x003,0)), `KEEP_CNT)
   0x408a081a, //   4('h0000f): JUMP(8, `IFCNTLT(`R(ZT_FRAMING+0x002,0)))  // WHILE_CNT_LT(`R(ZT_FRAMING+0x002,0)))
   0x40c20000, //   5('h00010): JUMP(12)
   0x4088081a, //   6('h00011): JUMP(8, `REPEAT(`R(ZT_FRAMING+0x002,0)))
   0x40c20000, //   7('h00012): JUMP(12)
   0xc850081d, //   8('h00013): MOV(`R(ZT_OHRATE+0x001,0), `IN(FP5), `KEEP_CNT)
   0x89600c1e, //   9('h00014): MOV(`R(ZT_OHRATE+0x002,1), `IN(TCLAYER))
   0x80000c14, //  10('h00015): MOV(`R(ZT_VBC_SIZE+0x000,1))
   0x40620000, //  11('h00016): JUMP(6)  // END_WHILE
   0x40020000, //  12('h00017): JUMP(0)  // END_FOREVER
   // Code block 4 memory
   0x6e000000, //   0('h00018): SET_IO(`NULL_DST)
   0xc000081c, //   1('h00019): MOV(`R(ZT_OHRATE+0x000,0), `KEEP_CNT)
   0x8d622c1e, //   2('h0001a): MOV(`R(ZT_OHRATE+0x002,1), `OUT(TCLAYER), `FLAG_MODE(FLAG_MODE_AND), `FLAG_MASK(4'h2), `APPLY_MODE(APPLY_MODE_ALL))
   0x8d622c14, //   3('h0001b): MOV(`R(ZT_VBC_SIZE+0x000,1), `OUT(TCLAYER), `FLAG_MODE(FLAG_MODE_AND), `FLAG_MASK(4'h2), `APPLY_MODE(APPLY_MODE_ALL))
   0x400c081b, //   4('h0001c): JUMP(0, `REPEAT(`R(ZT_FRAMING+0x003,0)), `KEEP_CNT)  // END_WHILE_CNT_LT(`R(ZT_FRAMING+0x003,0)), `KEEP_CNT)
   0x409a081a, //   5('h0001d): JUMP(9, `IFCNTLT(`R(ZT_FRAMING+0x002,0)))  // WHILE_CNT_LT(`R(ZT_FRAMING+0x002,0)))
   0x40e20000, //   6('h0001e): JUMP(14)
   0x4098081a, //   7('h0001f): JUMP(9, `REPEAT(`R(ZT_FRAMING+0x002,0)))
   0x40e20000, //   8('h00020): JUMP(14)
   0x6e000000, //   9('h00021): SET_IO(`NULL_DST)
   0xc000081d, //  10('h00022): MOV(`R(ZT_OHRATE+0x001,0), `KEEP_CNT)
   0x8d622c1e, //  11('h00023): MOV(`R(ZT_OHRATE+0x002,1), `OUT(TCLAYER), `FLAG_MODE(FLAG_MODE_AND), `FLAG_MASK(4'h2), `APPLY_MODE(APPLY_MODE_ALL))
   0x8d622c14, //  12('h00024): MOV(`R(ZT_VBC_SIZE+0x000,1), `OUT(TCLAYER), `FLAG_MODE(FLAG_MODE_AND), `FLAG_MASK(4'h2), `APPLY_MODE(APPLY_MODE_ALL))
   0x40720000, //  13('h00025): JUMP(7)  // END_WHILE
   0x40020000, //  14('h00026): JUMP(0)  // END_FOREVER
   // Code block 5 memory
   0x00002000, //   0('h00027): WAIT_EVENT(WAIT_OUT)
   0x403e0808, //   1('h00028): JUMP(3, `IFCNTLT(`R(ZT_R8+0x000,0)), `KEEP_CNT)  // IF_CNT_LT(`R(ZT_R8+0x000,0)))
   0x40520000, //   2('h00029): JUMP(5)
   0xc8a51001, //   3('h0002a): MOV(1, `IN(CRC0_D), `FLAG_MODE(FLAG_MODE_OR), `FLAG_MASK(4'h1), `APPLY_MODE(APPLY_MODE_ALL), `KEEP_CNT, `INVERT)
   0x40620000, //   4('h0002b): JUMP(6)  // ELSE
   0xc8a11001, //   5('h0002c): MOV(1, `IN(CRC0_D), `FLAG_MODE(FLAG_MODE_OR), `FLAG_MASK(4'h1), `APPLY_MODE(APPLY_MODE_ALL), `KEEP_CNT)
   0x20001c00, //   6('h0002d): WR_REG(`DEST(ZT_R0+0x000), `WR_MODE(WR_REG_OVER), `WR_MASK(8'h01))
   0x89c00c18, //   7('h0002e): MOV(`R(ZT_FRAMING+0x000,1), `IN(FIFO0))
   0x40020000, //   8('h0002f): JUMP(0)
   // Program will require these registers:
   //   ZT_CODEWORD+0x001 [7:0] - ?? (MOV byte count)
   //   ZT_CODEWORD+0x002 [7:0] - ?? (MOV byte count)
   //   ZT_FRAMING+0x000 [15:0] - ?? (MOV byte count)
   //   ZT_FRAMING+0x002 [7:0] - ?? (JUMP repeat count)
   //   ZT_FRAMING+0x003 [7:0] - ?? (JUMP repeat count)
   //   ZT_OHRATE+0x000 [7:0] - ?? (MOV byte count)
   //   ZT_OHRATE+0x001 [7:0] - ?? (MOV byte count)
   //   ZT_OHRATE+0x002 [15:0] - ?? (MOV byte count)
   //   ZT_PMS_SIZE+0x000 [15:0] - ?? (MOV byte count)
   //   ZT_R8+0x000 [7:0] - ?? (JUMP repeat count)
   //   ZT_VBC_SIZE+0x000 [15:0] - ?? (MOV byte count)
   // Code block 5 will modify these registers:
   //   ZT_R0+0x000 [7:0] -
   0
};
#else
int fci_prog_tx_vdsl2_bc0_lp0[] =
{
   0x04002, // ID.bc.lp.v
   // +debug wr to save bytes to fifo3.

   0x0000003f, // UPROC_ENA
   0x0000,   5, 0x00000000, 0x20000000, 0x00000000, 0x00000002, 0x00000000,  // Code block 0 base, size, STATE0-4
   0x0005,   3, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 1 base, size, STATE0-4
   0x0008,   3, 0x00000000, 0x20000000, 0x00000000, 0x04000000, 0x00000000,  // Code block 2 base, size, STATE0-4
   0x000b,  14, 0x00000000, 0x20000000, 0x00000000, 0x00004400, 0x00000000,  // Code block 3 base, size, STATE0-4
   0x0019,  15, 0x00000000, 0x50000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 4 base, size, STATE0-4
   0x0028,   9, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 5 base, size, STATE0-4
   0x0000,   0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 6 base, size, STATE0-4
   0x0000,   0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 7 base, size, STATE0-4
   0x0000,   0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 8 base, size, STATE0-4
   0x0000,   0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 9 base, size, STATE0-4
   0x04000004, // FLAG_DATA 0
   0x00000050, // FLAG_DATA 1
   49, // Total code length
   // Code block 0 memory
   0x6d10c00e, //   0('h00000): SET_IO(`IN(SCR_D), `OUT(RS_D), `KEEP_MASK)
   0x80000811, //   1('h00001): MOV(`R(ZT_CODEWORD+0x001,0))
   0x6c01c010, //   2('h00002): SET_IO(`IN(RS_D), `OUT(FP1))
   0x80000812, //   3('h00003): MOV(`R(ZT_CODEWORD+0x002,0))
   0x40020000, //   4('h00004): JUMP(0)  // END_FOREVER
   // Code block 1 memory
   0x8d400df8, //   0('h00005): MOV(`R(ZT_PMS_SIZE+0x000,1), `OUT(ILV0))
   0x00004000, //   1('h00006): WAIT_EVENT(WAIT_STOP)
   0x40020000, //   2('h00007): JUMP(0)  // END_FOREVER
   // Code block 2 memory
   0xa9411df8, //   0('h00008): MOV(`R(ZT_PMS_SIZE+0x000,1), `IN(ILV0), `FLAG_MODE(FLAG_MODE_OR), `FLAG_MASK(4'h1), `APPLY_MODE(APPLY_MODE_LAST))
   0x00004000, //   1('h00009): WAIT_EVENT(WAIT_STOP)
   0x40020000, //   2('h0000a): JUMP(0)  // END_FOREVER
   // Code block 3 memory
   0x6d1f0000, //   0('h0000b): SET_IO(`OUT(FIFO3), `KEEP_MASK)
   0xc850081c, //   1('h0000c): MOV(`R(ZT_OHRATE+0x000,0), `IN(FP5), `KEEP_CNT)
   0x89600c1e, //   2('h0000d): MOV(`R(ZT_OHRATE+0x002,1), `IN(TCLAYER))
   0x80000c14, //   3('h0000e): MOV(`R(ZT_VBC_SIZE+0x000,1))
   0x401c081b, //   4('h0000f): JUMP(1, `REPEAT(`R(ZT_FRAMING+0x003,0)), `KEEP_CNT)  // END_WHILE_CNT_LT(`R(ZT_FRAMING+0x003,0)), `KEEP_CNT)
   0x409a081a, //   5('h00010): JUMP(9, `IFCNTLT(`R(ZT_FRAMING+0x002,0)))  // WHILE_CNT_LT(`R(ZT_FRAMING+0x002,0)))
   0x40d20000, //   6('h00011): JUMP(13)
   0x4098081a, //   7('h00012): JUMP(9, `REPEAT(`R(ZT_FRAMING+0x002,0)))
   0x40d20000, //   8('h00013): JUMP(13)
   0xc850081d, //   9('h00014): MOV(`R(ZT_OHRATE+0x001,0), `IN(FP5), `KEEP_CNT)
   0x89600c1e, //  10('h00015): MOV(`R(ZT_OHRATE+0x002,1), `IN(TCLAYER))
   0x80000c14, //  11('h00016): MOV(`R(ZT_VBC_SIZE+0x000,1))
   0x40720000, //  12('h00017): JUMP(7)  // END_WHILE
   0x40120000, //  13('h00018): JUMP(1)  // END_FOREVER
   // Code block 4 memory
   0x6e000000, //   0('h00019): SET_IO(`NULL_DST)
   0xc000081c, //   1('h0001a): MOV(`R(ZT_OHRATE+0x000,0), `KEEP_CNT)
   0x8d622c1e, //   2('h0001b): MOV(`R(ZT_OHRATE+0x002,1), `OUT(TCLAYER), `FLAG_MODE(FLAG_MODE_AND), `FLAG_MASK(4'h2), `APPLY_MODE(APPLY_MODE_ALL))
   0x8d622c14, //   3('h0001c): MOV(`R(ZT_VBC_SIZE+0x000,1), `OUT(TCLAYER), `FLAG_MODE(FLAG_MODE_AND), `FLAG_MASK(4'h2), `APPLY_MODE(APPLY_MODE_ALL))
   0x400c081b, //   4('h0001d): JUMP(0, `REPEAT(`R(ZT_FRAMING+0x003,0)), `KEEP_CNT)  // END_WHILE_CNT_LT(`R(ZT_FRAMING+0x003,0)), `KEEP_CNT)
   0x409a081a, //   5('h0001e): JUMP(9, `IFCNTLT(`R(ZT_FRAMING+0x002,0)))  // WHILE_CNT_LT(`R(ZT_FRAMING+0x002,0)))
   0x40e20000, //   6('h0001f): JUMP(14)
   0x4098081a, //   7('h00020): JUMP(9, `REPEAT(`R(ZT_FRAMING+0x002,0)))
   0x40e20000, //   8('h00021): JUMP(14)
   0x6e000000, //   9('h00022): SET_IO(`NULL_DST)
   0xc000081d, //  10('h00023): MOV(`R(ZT_OHRATE+0x001,0), `KEEP_CNT)
   0x8d622c1e, //  11('h00024): MOV(`R(ZT_OHRATE+0x002,1), `OUT(TCLAYER), `FLAG_MODE(FLAG_MODE_AND), `FLAG_MASK(4'h2), `APPLY_MODE(APPLY_MODE_ALL))
   0x8d622c14, //  12('h00025): MOV(`R(ZT_VBC_SIZE+0x000,1), `OUT(TCLAYER), `FLAG_MODE(FLAG_MODE_AND), `FLAG_MASK(4'h2), `APPLY_MODE(APPLY_MODE_ALL))
   0x40720000, //  13('h00026): JUMP(7)  // END_WHILE
   0x40020000, //  14('h00027): JUMP(0)  // END_FOREVER
   // Code block 5 memory
   0x00002000, //   0('h00028): WAIT_EVENT(WAIT_OUT)
   0x403e0808, //   1('h00029): JUMP(3, `IFCNTLT(`R(ZT_R8+0x000,0)), `KEEP_CNT)  // IF_CNT_LT(`R(ZT_R8+0x000,0)))
   0x40520000, //   2('h0002a): JUMP(5)
   0xc8a51001, //   3('h0002b): MOV(1, `IN(CRC0_D), `FLAG_MODE(FLAG_MODE_OR), `FLAG_MASK(4'h1), `APPLY_MODE(APPLY_MODE_ALL), `KEEP_CNT, `INVERT)
   0x40620000, //   4('h0002c): JUMP(6)  // ELSE
   0xc8a11001, //   5('h0002d): MOV(1, `IN(CRC0_D), `FLAG_MODE(FLAG_MODE_OR), `FLAG_MASK(4'h1), `APPLY_MODE(APPLY_MODE_ALL), `KEEP_CNT)
   0x20001c00, //   6('h0002e): WR_REG(`DEST(ZT_R0+0x000), `WR_MODE(WR_REG_OVER), `WR_MASK(8'h01))
   0x89c00c18, //   7('h0002f): MOV(`R(ZT_FRAMING+0x000,1), `IN(FIFO0))
   0x40020000, //   8('h00030): JUMP(0)
   // Program will require these registers:
   //   ZT_CODEWORD+0x001 [7:0] - ?? (MOV byte count)
   //   ZT_CODEWORD+0x002 [7:0] - ?? (MOV byte count)
   //   ZT_FRAMING+0x000 [15:0] - ?? (MOV byte count)
   //   ZT_FRAMING+0x002 [7:0] - ?? (JUMP repeat count)
   //   ZT_FRAMING+0x003 [7:0] - ?? (JUMP repeat count)
   //   ZT_OHRATE+0x000 [7:0] - ?? (MOV byte count)
   //   ZT_OHRATE+0x001 [7:0] - ?? (MOV byte count)
   //   ZT_OHRATE+0x002 [15:0] - ?? (MOV byte count)
   //   ZT_PMS_SIZE+0x000 [15:0] - ?? (MOV byte count)
   //   ZT_R8+0x000 [7:0] - ?? (JUMP repeat count)
   //   ZT_VBC_SIZE+0x000 [15:0] - ?? (MOV byte count)
   // Code block 5 will modify these registers:
   //   ZT_R0+0x000 [7:0] -
   0
}; //int fci_prog_tx_vdsl2_bc0_lp0[] = {
#endif
DATA_MAP_END;
//XDSLRTFW-1048 Feature_US_VDSL2_ALL_UsReTx(START)
DATA_MAP_FCI_TX_LP0_RETX_UCODE
int fci_prog_tx_vdsl2_bc0_lp0_retx[] =
{
   0x7002, // ID.bc.lp.v
   //  No debug write to fifo3.

   0x0000002f, // UPROC_ENA, FP4 is not used
   0x0000,   5, 0x00000000, 0x20000000, 0x00000000, 0x00000002, 0x00000000,  // Code block 0 base, size, STATE0-4
   0x0005,   3, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 1 base, size, STATE0-4
   0x0008,   3, 0x00000000, 0x20000000, 0x00000000, 0x04000000, 0x00000000,  // Code block 2 base, size, STATE0-4
   0x000b,   3, 0x00000000, 0x20000000, 0x00000000, 0x00004400, 0x00000000,  // Code block 3 base, size, STATE0-4
   0x000e,   0, 0x00000000, 0x50000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 4 base, size, STATE0-4
   0x000e,   9, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 5 base, size, STATE0-4
   0x0000,   0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 6 base, size, STATE0-4
   0x0000,   0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 7 base, size, STATE0-4
   0x0000,   0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 8 base, size, STATE0-4
   0x0000,   0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 9 base, size, STATE0-4
   0x04000004, // FLAG_DATA 0
   0x00000020, // FLAG_DATA 1
   23, // Total code length

   // Code block 0 memory
   0x6d10c00e, //   0('h00000): SET_IO(`IN(SCR_D), `OUT(RS_D), `KEEP_MASK)
   0x80000811, //   1('h00001): MOV(`R(ZT_CODEWORD+0x001,0))
   0x6c01c010, //   2('h00002): SET_IO(`IN(RS_D), `OUT(FP1))
   0x80000812, //   3('h00003): MOV(`R(ZT_CODEWORD+0x002,0))
   0x40020000, //   4('h00004): JUMP(0)  // END_FOREVER

   // Code block 1 memory
   0x8d400df8, //   0('h00005): MOV(`R(ZT_PMS_SIZE+0x000,1), `OUT(ILV0))
   0x00004000, //   1('h00006): WAIT_EVENT(WAIT_STOP)
   0x40020000, //   2('h00007): JUMP(0)  // END_FOREVER

   // Code block 2 memory
   0xa9411df8, //   0('h00008): MOV(`R(ZT_PMS_SIZE+0x000,1), `IN(ILV0), `FLAG_MODE(FLAG_MODE_OR), `FLAG_MASK(4'h1), `APPLY_MODE(APPLY_MODE_LAST))
   0x00004000, //   1('h00009): WAIT_EVENT(WAIT_STOP)
   0x40020000, //   2('h0000a): JUMP(0)  // END_FOREVER

   // Code block 3 memory
   0x6000c005, //   0 (       ): SET_IO(`IN(FP5), `Input_Mater)
   0x80000811,  //  1 (       ): MOV(`R(ZT_CODEWORD+0x001,0)); Kp bytes
   0x40020000, //   2('h00018) : JUMP(0)  // END_FOREVER

   // Code block 5 memory
   0x00002000, //   0('h00027): WAIT_EVENT(WAIT_OUT)
   0x403e0808, //   1('h00028): JUMP(3, `IFCNTLT(`R(ZT_R8+0x000,0)), `KEEP_CNT)  // IF_CNT_LT(`R(ZT_R8+0x000,0)))
   0x40520000, //   2('h00029): JUMP(5)
   0xc8a51001, //   3('h0002a): MOV(1, `IN(CRC0_D), `FLAG_MODE(FLAG_MODE_OR), `FLAG_MASK(4'h1), `APPLY_MODE(APPLY_MODE_ALL), `KEEP_CNT, `INVERT)
   0x40620000, //   4('h0002b): JUMP(6)  // ELSE
   0xc8a11001, //   5('h0002c): MOV(1, `IN(CRC0_D), `FLAG_MODE(FLAG_MODE_OR), `FLAG_MASK(4'h1), `APPLY_MODE(APPLY_MODE_ALL), `KEEP_CNT)
   0x20001c00, //   6('h0002d): WR_REG(`DEST(ZT_R0+0x000), `WR_MODE(WR_REG_OVER), `WR_MASK(8'h01))
   0x89c00c18, //   7('h0002e): MOV(`R(ZT_FRAMING+0x000,1), `IN(FIFO0))
   0x40020000, //   8('h0002f): JUMP(0)
   // Program will require these registers:
   //   ZT_CODEWORD+0x001 [7:0] - ?? (MOV byte count)
   //   ZT_CODEWORD+0x002 [7:0] - ?? (MOV byte count)
   //   ZT_FRAMING+0x000 [15:0] - ?? (MOV byte count)
   //   ZT_FRAMING+0x002 [7:0] - ?? (JUMP repeat count)
   //   ZT_FRAMING+0x003 [7:0] - ?? (JUMP repeat count)
   //   ZT_OHRATE+0x000 [7:0] - ?? (MOV byte count)
   //   ZT_OHRATE+0x001 [7:0] - ?? (MOV byte count)
   //   ZT_OHRATE+0x002 [15:0] - ?? (MOV byte count)
   //   ZT_PMS_SIZE+0x000 [15:0] - ?? (MOV byte count)
   //   ZT_R8+0x000 [7:0] - ?? (JUMP repeat count)
   // Code block 5 will modify these registers:
   //   ZT_R0+0x000 [7:0] -
   0
};  //fci_prog_tx_vdsl2_bc0_lp0_retx
DATA_MAP_END; //DATA_MAP_FCI_TX_LP0_RETX_UCODE


DATA_MAP_FCI_TX_LP1_RETX_UCODE
int fci_prog_tx_vdsl2_bc0_lp1_retx[] =
{
   0x7013, // ID.bc.lp.v
   /*
   */
   0x0000005f, // UPROC_ENA, FP0, FP1, FP2, FP3, FP4 & FP6
   0x0000,   5, 0x00000000, 0x20000000, 0x00000000, 0x00000002, 0x00000000,  // Code block 0 base, size, STATE0-4
   0x0005,   8, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 1 base, size, STATE0-4
   0x000d,   9, 0x00000000, 0x20000000, 0x00000000, 0x04000000, 0x00000000,  // Code block 2 base, size, STATE0-4
   0x0016,   34, 0x00000000, 0x20000000, 0x00000000, 0x00004400, 0x00000000,  // Code block 3 base, size, STATE0-4
   0x0038,   24, 0x00000000, 0x50000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 4 base, size, STATE0-4
   0x0050,   0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 5 base, size, STATE0-4
   0x0050,   8, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 6 base, size, STATE0-4
   0x0000,   0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 7 base, size, STATE0-4
   0x0000,   0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 8 base, size, STATE0-4
   0x0000,   0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 9 base, size, STATE0-4
   0x74000004, // FLAG_DATA 0
   0x00000050, // FLAG_DATA 1
   88, // Total code length

   // Code block 0 memory
   0x6d10c00e, //   0('h00000): SET_IO(`IN(SCR_D), `OUT(RS_D), `KEEP_MASK)
   0x80000811, //   1('h00001): MOV(`R(ZT_CODEWORD+0x001,0))
   0x6c01c010, //   2('h00002): SET_IO(`IN(RS_D), `OUT(FP1))
   0x80000812, //   3('h00003): MOV(`R(ZT_CODEWORD+0x002,0))
   0x40020000, //   4('h00004): JUMP(0)  // END_FOREVER
   //REGISTERS USED by FP0
   //ZT_CODEWORD+0x001 ==> Kp
   //ZT_CODEWORD+0x002 ==> Rp

   // Code block 1 memory
   0x6c188000, //   0('h00000): SET_IO(`OUT(ILVB), Out_Master, IN(FP0), IN_Slave)
   0x9d838c1c, //   1('h00005): MOV(`R(ZT_OHRATE_+0x000,2),  `OUT(ILVB)) Flag apply to first byte only; Flag Mask #8, i.e Flag x000 (WR Len 0)
   0x9d838c1e, //   2('h00005): MOV(`R(ZT_OHRATE_+0x002,2),  `OUT(ILVB)) Flag apply to first byte only; Flag Mask #8, i.e Flag x000 (WR Len 1)
   0x9d838c06, //   3('h00005): MOV(`R(ZT_R4+0x002,2),  `     OUT(ILVB)) Flag apply to first byte only; Flag Mask #8, i.e Flag x000 (WR Len 2)
   //To read data from DILV buffer interface
   0x6e00c002, //   4('h00034):SET_IO, input 2 mst, output null
   0x80000001, //   5('h00035):MOV 1 byte
   0x00004000, //   6('h00006): WAIT_EVENT(WAIT_STOP)
   0x40020000, //   7('h00007): JUMP(0)  // END_FOREVER
   //REGISTERS USED by FP1
   //ZT_OHRATE_+0x000 ==> DTU WR Length 0 @ILVB
   //ZT_OHRATE_+0x002 ==> DTU WR Length 1 @ILVB
   //ZT_R4+0x002      ==> DTU WR Length 2 @ILVB


   // Code block 2 memory
   0x6801e000, //   0('h0004e): SET_IO(`IN(NULL), `OUT(FP1) SLAVE)
   0x80000001, //   1('h00055): MOV (1 BYTE); Purpose: To ack FP1 after doing required work
   0x6e00c006, //   2('h00034): SET_IO(`IN(FP6), Master, `OUT(NULL), Master)
   0x80000001, //   3('h00035): MOV 1 byte
   0x6c1ac018, //   4('h00034): SET_IO(OUT(DTB), Master, IN(ILVB), Master,
   0x80000c34, //   5('h00008): MOV(`R(ZT_CRC1+0x000,2))
   0xa0011c36, //   6('h00008): MOV(`R(ZT_CRC1+0x002,2),`FLAG_MODE(FLAG_MODE_OR), `FLAG_MASK(1'h1), `APPLY_MODE(APPLY_MODE_LAST))
   0x00004000, //   7('h00009): WAIT_EVENT(WAIT_STOP)
   0x40020000, //   8('h0000a): JUMP(0)  // END_FOREVER
   //REGISTERS USED by FP2
   //ZT_CRC1+0x000 ==> DTU RD Length 0 @ILVB
   //ZT_CRC1+0x002 ==> DTU RD Length 1 @ILVB


// Code block 3 memory
// Read input from ZT_R12 + 0 as input to gen new DTU or not, New DTU = 1; Don't gen new DTU = 0;
//FP3_START_L0
   0x6e00E80c, //   0           SET_IO(Input Enabled, Input Master,Input Null SRC,  Input Use register (ZT_R12+0x000, 1), OUT(NULL), OUT_Master
   0x80000001,  //  1           Move 1 byte
   0x40510101, //   2           JUMP(FP3_FRAME_NEW_DTU_L5) if ((ZT_R12+0x0) == (0x1)), <set_rst>=1, <data_jump>=1, <match_data>=1 ,<line>=5
//FP3_WAIT_FOR_NEW_DTU_L3
   0x00004000, //   3           WAIT_EVENT(WAIT_STOP)
   0x40020000, //   4           JUMP(FP3_START_L0)
//FP3_FRAME_NEW_DTU_L5
   0x30000c40,  //   5('h00020): WR_REG, <reg_mode>=3, <byte_addr>=0x40    LSW //Reset Scrambler ZT_SCR_OFFSET  (0x40)
   0x30000c42,  //   6('h00021): WR_REG, <reg_mode>=3, <byte_addr>=0x42    MSW //Reset Scrambler ZT_SCR_OFFSET  (0x42)
   0x6c0eE805,  //   7           SET_IO(Input Enabled, Input Master,Input Null SRC,  Input Use register (ZT_R4+0x0001, 1), OUT(SCR_D), OUT_Master; send SID
   0x80000001,  //   8           Move 1 byte
   0x20005152,  //   9           WR_REG(ZT_R4 + 0x0001 ==> ZT_UPROC3_STATE0 + 0x0002) Copy 8bit data from ZT_R4 + 0x0001 to ZT_UPROC3_STATE0 + 0x0002
   0x40bc00ff,  //   10          JUMP(FP3_INC_SID_COUNT_L11 , REPEAT(0xFF), KEEP_CNT, END_WHILE_CNT_LT(0xFF))), Added to increment the counter
//FP3_INC_SID_COUNT_L11
   0x20152005,  //   11          WR_REG(ZT_UPROC3_STATE0 + 0x0002 ==> ZT_R4 + 0x0001) Copy 8bit data from ZT_UPROC3_STATE0 + 0x0002 to ZT_R4 + 0x0001
   0x20000d52,  //   12          WR_REG(Data_Mask0(0) ==> ZT_UPROC3_STATE0 + 0x0002) Clear repeat counter at FP3
   0x40E80001,  //   13          JUMP(FP3_CLR_KEEP_CNT_BIT_L14 , REPEAT(0x1),END_WHILE_CNT_LT(0x01))), Clear Keep count bit
//FP3_CLR_KEEP_CNT_BIT_L14
   0x6000E804,  //   14          SET_IO(Input Enabled, Input Master,Input Null SRC,  Input Use register (ZT_R4+0x0000, 1); send TS
   0x80000001,  //  15           Move 1 byte
   0x6000E033,  //  16           SET_IO(Input Enabled, Input Master,Input Null SRC,  Input CONST(0x33); V- Padding byte content
   0x80000819,  //  17           Move No of V Padded byte available at (ZT_FRAMING+0x0001, 1)
   0x60008016,  //  18           SET_IO(Input Enabled, Input slave, IN(TCLAYER))
   0x8960081a,  //  19('h0001c): MOV(`R(ZT_FRAMING+0x002,1), `IN(TCLAYER)) , Move (Kp - V - 2) bytes
//FP3_IS_ALL_CW_DONE_L_20:
   0x41680818,  //  20('h0002d): JUMP(FP3_TRANS_NEW_DTU_CW_L22, END_WHILE_CNT_LT(`R(ZT_FRAMING+0x000,0))) //Compare Q counter
   0x41820000,  //  21('h0002e): JUMP(FP3_TRANS_DONE_L24)
//FP3_TRANS_NEW_DTU_CW_L22
   0x89600811, //   22('h0001c): MOV(`R(ZT_CODEWORD+0x001,1), `IN(TCLAYER)) , Move Kp bytes
   0x41420000, //   23('h00030): JUMP(FP3_IS_ALL_CW_DONE_L_20)
//FP3_TRANS_DONE_L24:
//   0x40020000, //   24('h00018): JUMP(0)  // END_FOREVER
//   0x40520000, //   24('h00018): JUMP(FP3_FRAME_NEW_DTU_L5)  // END_FOREVER
   0x6e00E80E,  //    24           SET_IO(Input Enabled, Input Master,Input Null SRC,  Input Use register (ZT_R12+0x002, 1), OUT(NULL), OUT_Master
   0x2000F152,  //    25           WR_REG(ZT_R12 + 0x0003 ==> ZT_UPROC3_STATE0 + 0x0002) Copy 8bit data from ZT_R12 + 0x0003 to ZT_UPROC3_STATE0 + 0x0002
   0x41f8080D,  //    26           JUMP(FP3_INC_DTU_COUNT_L31 , REPEAT, END_WHILE_CNT_LT(ZT_R12+0x1))), Added to increment the counter
   0x2015200F,  //    27           WR_REG(ZT_UPROC3_STATE0 + 0x0002 ==> ZT_R12 + 0x0003) Copy 8bit data from ZT_UPROC3_STATE0 + 0x0002 to ZT_R12 + 0x0003
   0x80000001,  //    28           Move 1 byte
   0x40510101,  //    29           JUMP(FP3_FRAME_NEW_DTU_L5) if ((ZT_R12+0x2) == (0x1)), <set_rst>=1, <data_jump>=1, <match_data>=1 ,<line>=5
   0x40320000,  //    30           JUMP(FP3_WAIT_FOR_NEW_DTU_L3)
//FP3_INC_DTU_COUNT_L31
   0x2015200F,  //    31           WR_REG(ZT_UPROC3_STATE0 + 0x0002 ==> ZT_R12 + 0x0003) Copy 8bit data from ZT_UPROC3_STATE0 + 0x0002 to ZT_R12 + 0x0003
   0x20000d52,  //    32           WR_REG(Data_Mask0(0) ==> ZT_UPROC3_STATE0 + 0x0002) Clear repeat counter at FP3
//FP3_DTU_END_L33
   0x40520000, //     33('h00018): JUMP(FP3_FRAME_NEW_DTU_L5)  // END_FOREVER
   //REGISTERS USED by FP3
   //ZT_R12+0x000      ==> As Flag to Start New DTU if 1, otherwise FP3 Stop taking taking data from TC layer
   //ZT_SCR_OFFSET+0x0 ==> Scrambler Reset
   //ZT_SCR_OFFSET+0x2 ==> Scrambler Reset
   //ZT_R4+0x0001      ==> SID
   //ZT_R4+0x0000      ==> TS
   //ZT_FRAMING+0x000  ==> Q  (No of CWs in a DTU)
   //ZT_FRAMING+0x001  ==> V Bytes
   //ZT_FRAMING+0x002  ==> Kp-V-2, Bytes in 1st CW of DTU
   //ZT_CODEWORD+0x001 ==> Kp bytes
   //ZT_R12+0x001      ==> No of New DTU to be generated
   //ZT_R12+0x002      ==> Flag as 1 Indicates Partial DTU followed by New DTU, otherwise no new DTU
   //ZT_R12+0x003      ==> Local counter compare against ZT_R12+0x001

// Code block 4 memory
//FP4_START_L0
   0x6e00E80c, //   0           SET_IO(Input Enabled, Input Master,Input Null SRC,  Input Use register (ZT_R12+0x0, 1), OUT(NULL), OUT_Master
   0x80000001,  //  1           Move 1 byte
   0x40510101, //   2           JUMP(FP4_FRAME_NEW_DTU_L5) if ((ZT_R12+0x0) == (0x1)), <set_rst>=1, <data_jump>=1, <match_data>=1 ,<line>=5
//FP4_WAIT_FOR_NEW_DTU_L3
   0x00004000, //   3           WAIT_EVENT(WAIT_STOP)
   0x40020000, //   4           JUMP(FP4_START_L0)
//FP4_FRAME_NEW_DTU_L5
   0x6e000000, //  5('h00019): SET_IO(`NULL_DST)
   0x80000001, //  6           Move 1 byte // Move SID Byte
   0x80000001, //  7('h0001c): Move 1 byte //MOV(`R(ZT_R4+0x0,1)) Move TS Byte
   0x80000819, //  8           Move No of V Padded byte available at (ZT_FRAMING+0x0001, 1)
   0x8d62281a, //  9('h0001c): MOV(`R(ZT_FRAMING+0x002,1), `OUT(TCLAYER), `FLAG_MODE(FLAG_MODE_AND), `FLAG_MASK(4'h2), `APPLY_MODE(APPLY_MODE_ALL)), Move (Kp - V - 2) bytes
//FP4_IS_ALL_CW_DONE_L_10:
   0x40C80818, //  10('h0002d): JUMP(FP4_TRANS_CW_L12, END_WHILE_CNT_LT(`R(ZT_FRAMING+0x000,0)))
   0x40E20000, //  11('h0002e): JUMP(FP4_TRANS_DONE_L14)
//FP4_TRANS_CW_L12:
   0x8d622811, //  12('h0001c): MOV(`R(ZT_CODEWORD+0x001,1), `OUT(TCLAYER), `FLAG_MODE(FLAG_MODE_AND), `FLAG_MASK(4'h2), `APPLY_MODE(APPLY_MODE_ALL)), Kp bytes
   0x40A20000, //  13('h00030): JUMP(FP4_IS_ALL_CW_DONE_L_10)
//FP4_TRANS_DONE_L14:
//   0x40020000, //  14('h00018): JUMP(0)  // END_FOREVER
//   0x40520000, //  14('h00018): JUMP(FP4_FRAME_NEW_DTU_L5)  // END_FOREVER
   0x6e00E80E,  //    14           SET_IO(Input Enabled, Input Master,Input Null SRC,  Input Use register (ZT_R12+0x002, 1), OUT(NULL), OUT_Master
   0x2001B166,  //    15           WR_REG(ZT_FRAMING + 0x0003 ==> ZT_UPROC4_STATE0 + 0x0002) Copy 8bit data from ZT_FRAMING + 0x0003 to ZT_UPROC4_STATE0 + 0x0002
   0x4158080D,  //    16           JUMP(FP4_INC_DTU_COUNT_L21 , REPEAT, END_WHILE_CNT_LT(ZT_R12+0x1))), Added to increment the counter
   0x2016601B,  //    17           WR_REG(ZT_UPROC4_STATE0 + 0x0002 ==> ZT_FRAMING + 0x0003) Copy 8bit data from ZT_UPROC4STATE0 + 0x0002 to ZT_FRAMING + 0x0003
   0x80000001,  //    18           Move 1 byte
   0x40510101,  //    19           JUMP(FP4_FRAME_NEW_DTU_L5) if ((ZT_R12+0x2) == (0x1)), <set_rst>=1, <data_jump>=1, <match_data>=1 ,<line>=5
   0x40320000,  //    20           JUMP(FP4_WAIT_FOR_NEW_DTU_L3)

//FP4_INC_DTU_COUNT_L21
   0x2016601B,  //    21           WR_REG(ZT_UPROC4_STATE0 + 0x0002 ==> ZT_FRAMING + 0x0003) Copy 8bit data from ZT_UPROC4_STATE0 + 0x0002 to ZT_FRAMING + 0x0003
   0x20000d66,  //    22           WR_REG(Data_Mask0(0) ==> ZT_UPROC4_STATE0 + 0x0002) Clear repeat counter at FP4
//FP4_DTU_END_L23
   0x40520000, //     23('h00018): JUMP(FP4_FRAME_NEW_DTU_L5)  // END_FOREVER
   //REGISTERS USED by FP4
   //ZT_R12+0x000      ==> As Flag to Start New DTU if 1, otherwise FP3 Stop taking taking data from TC layer
   //ZT_FRAMING+0x000  ==> Q  (No of CWs in a DTU)
   //ZT_FRAMING+0x0001 ==> V Bytes
   //ZT_FRAMING+0x002  ==> Kp-V-2, Bytes in 1st CW of DTU
   //ZT_CODEWORD+0x001 ==> Kp bytes
   //ZT_R12+0x001      ==> No of New DTU to be generated
   //ZT_R12+0x002      ==> Flag as 1 Indicates Partial DTU followed by New DTU, otherwise no new DTU
   //ZT_FRAMING+0x003  ==> Local counter compare against ZT_R12+0x001

   // Code block 5 memory
   // Code block 6 memory
   0x6802e000, //   0('h0004e): SET_IO(`IN(NULL), `OUT(FP2) SLAVE)
   0x80000001, //   1('h00055): MOV (1 BYTE); Purpose: Wait for FP2 to start reading ILV buffer
   0x6c19e000, //   2('h00044): SET_IO, input null_src, output block_id=25 (ILVB read flags) master
   0x90038c34, //   3('h00045): MOV(R(ZT_CRC1+0x000,2) bytes, <use_reg>=1, <reg_id>=0x1B, <apply_mode>=1, <flag_mode>=3, <flag_mask>=0x8
   0x90038c36, //   4('h00045): MOV(R(ZT_CRC1+0x002,2) bytes, <use_reg>=1, <reg_id>=0x1B, <apply_mode>=1, <flag_mode>=3, <flag_mask>=0x8
   0x00004000, //   5('h00047): WAIT_EVENT(WAIT_STOP)  // wait for a stop
   0x40020000, //   6('h00048): JUMP(0)  // Restart
   //REGISTERS USED by FP5
   //ZT_CRC1+0x000 ==> DTU RD Length 0 @ILVB
   //ZT_CRC1+0x002 ==> DTU RD Length 1 @ILVB
   // Program will require these registers:
   //   ZT_CODEWORD+0x001 [7:0] - ?? (MOV byte count)
   //   ZT_CODEWORD+0x002 [7:0] - ?? (MOV byte count)
   //   ZT_FRAMING+0x000 [7:0]   -  (contains Q amount of code words, i.e No of code words/DTU)
   //   ZT_FRAMING+0x001 [15:8]  -  (contains V amount of padded bytes to be added for DTU framing)
   //   ZT_FRAMING+0x002 [23:16] -  (contains K-V-2 bytes)
   //   ZT_FRAMING+0x003 [31:24] -  (Reserved)
   //   ZT_OHRATE+0x000 [15:0] -    (MOV byte count for ReTx Queue Write Len 1)
   //   ZT_OHRATE+0x002 [31:16] -   (MOV byte count for ReTx Queue Write Len 2)
   //   ZT_R4+0x002 [31:16] -       (MOV byte count for ReTx Queue Write Len 3)
   //   ZT_R4+0x000 [7:0]           (Contains Time stamp)
   //   ZT_R4+0x001 [15:8]          (Contains SID)
   //   ZT_CRC1+0x000 [15:0] -      (MOV byte count for ReTx Queue Read Len 1)
   //   ZT_CRC1+0x000 [31:16] -     (MOV byte count for ReTx Queue Read Len 2)
   0
}; //int fci_prog_tx_vdsl2_bc0_lp1_retx[] = {
DATA_MAP_END;
//XDSLRTFW-1048 Feature_US_VDSL2_ALL_UsReTx(END)

//XDSLRTFW-1617 (Start)
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
// The following microcode is invoked when US Intra DTU interleaving is invoked (i.e when gft_Intra_DTU_Ilv_DS is TRUE)
DATA_MAP_FCI_TX_LP1_RETX_IDILV_UCODE
int fci_prog_tx_vdsl2_bc0_lp1_retx_idilv[] =
{
   0x7013, // ID.bc.lp.v
   0x000000df, // UPROC_ENA, FP0, FP1, FP2, FP3, FP4 & FP6
   0x0000,   19, 0x00000000, 0x20000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 0 base, size, STATE0-4
   0x0013,   8, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 1 base, size, STATE0-4
   0x001b,   9, 0x00000000, 0x20000000, 0x00000000, 0x04000000, 0x00000000,  // Code block 2 base, size, STATE0-4
   0x0024,   34, 0x00000000, 0x20000000, 0x00000000, 0x00004400, 0x00000000,  // Code block 3 base, size, STATE0-4
   0x0046,   24, 0x00000000, 0x50000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 4 base, size, STATE0-4
   0x005e,   0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 5 base, size, STATE0-4
   0x005e,   7, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 6 base, size, STATE0-4
   0x0065,   27, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 7 base, size, STATE0-4
   0x0000,   0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 8 base, size, STATE0-4
   0x0000,   0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 9 base, size, STATE0-4
   0x74000004, // FLAG_DATA 0
   0x00000050, // FLAG_DATA 1
   128, // Total code length




   // Code block 0 memory
   // The below part of the code moves data to RS encoder, as well as to ILV0/ILV1 from scrambler. The check bytes
   // generated by RS encoder is also moved to ILV0/ILV1.
   // Number of bytes moved to RS encoder each iteration(count provided by ZT_CODEWORD+0x001) = NFEC - R.
   // Total Number of bytes moved to ILV0/ILV1 each iteration(count provided by ZT_CODEWORD+0x001, ZT_CODEWORD+0x002 ) = NFEC -R + R.
   // Number of iterations(count provided by ZT_DEPTH ) = D
   // Total bytes moved to ILV0/ILV1 when below code is executed = NFEC*D
   0x6c10c00e, // 0: SET_IO(Output RS encoder, O/P master, Input Scrambler,I/P master)
   0x8f400811, // 1: MOV(apply mode: 00, O/P ILV0, count: R(ZT_CODEWORD+0x001,0) Keep mask(still keep  O/P RS encoder)
   0x6c14c010, // 2: SET_IO(Output ILV0, O/P master, input RS encoder,I/P master)
   0x80000812, // 3: MOV(count: R(ZT_CODEWORD+0x002,0))
   0x40080898, // 4: JUMP( jump loc:0, if cnt < ZT_DEPTH)


   //Initialise Max & Min registers such that ILV0 can not be written, but only can be read.
   0x30000cac, // 5: WR_REG(`DEST(ZT_ILV_MIN_FULLNESS0+0x000), `ACCESS_MODE(WR_REG_16), `WR_MODE(WR_REG_OVER), `WR_MASK(16'h  0000))
   0x30000cae, // 6: WR_REG(`DEST(ZT_ILV_MIN_FULLNESS0+0x002), `ACCESS_MODE(WR_REG_16), `WR_MODE(WR_REG_OVER), `WR_MASK(16'h  0000))
   0x30000ca8, // 7: WR_REG(`DEST(ZT_ILV_MAX_FULLNESS0+0x000), `ACCESS_MODE(WR_REG_16),`WR_MODE(WR_REG_OVER), `WR_MASK(16'h  0000))
   0x30000caa, // 8: WR_REG(`DEST(ZT_ILV_MAX_FULLNESS0+0x002), `ACCESS_MODE(WR_REG_16),`WR_MODE(WR_REG_OVER), `WR_MASK(16'h  0000)

   0x6c10c00e, // 9: Output RS encoder, Input Scrambler
   0x8f500811, // a: MOV(`R(ZT_CODEWORD+0x001,0)) Keep mask(still keep  O/P RS encoder), output ILV1
   0x6c15c010, // b: Output ILV1, input RS encoder
   0x80000812, // c: MOV(`R(ZT_CODEWORD+0x002,0))
   0x40980898, // d: Jump 0, if cnt < ZT_DEPTH



   //Initialise Max & Min registers such that ILV1 can not be written, but only can be read.
   0x30000cd0,  // e: WR_REG(`DEST(ZR_ILV_MIN_FULLNESS0+0x000), `ACCESS_MODE(WR_REG_16), `WR_MODE(WR_REG_OVER), `WR_MASK(16'h  0000))
   0x30000cd2,  // f: WR_REG(`DEST(ZR_ILV_MIN_FULLNESS0+0x002), `ACCESS_MODE(WR_REG_16), `WR_MODE(WR_REG_OVER), `WR_MASK(16'h  0000))
   0x30000ccc, //10: WR_REG(`DEST(ZR_ILV_MAX_FULLNESS0+0x000), `ACCESS_MODE(WR_REG_16),`WR_MODE(WR_REG_OVER), `WR_MASK(16'h  0000))
   0x30000cce, //11: WR_REG(`DEST(ZR_ILV_MAX_FULLNESS0+0x002), `ACCESS_MODE(WR_REG_16),`WR_MODE(WR_REG_OVER), `WR_MASK(16'h  0000)
   0x40020000, //12: JUMP(0)  // END_FOREVER
   //REGISTERS USED by FP0
   //ZT_CODEWORD+0x001          ==>(READ)Kp
   //ZT_CODEWORD+0x002          ==>(READ)Rp
   //ZT_ILV_MIN_FULLNESS0+0x000 ==>(WRITE)
   //ZT_ILV_MIN_FULLNESS0+0x002 ==>(WRITE)
   //ZT_ILV_MAX_FULLNESS0+0x000 ==>(WRITE)
   //ZT_ILV_MAX_FULLNESS0+0x002 ==>(WRITE)
   //ZT_DEPTH + 0               ==>(READ)


   // Code block 1 memory


   0x6c188007, //   0: SET_IO(`OUT(ILVB), Out_Master, IN(FP7), IN_Slave)
   0x9d838c1c, //   1: MOV(`R(ZT_OHRATE_+0x000,2),  `OUT(ILVB)) Flag apply to first byte only; Flag Mask #8, i.e Flag x000 (WR Len 0)
   0x9d838c1e, //   2: MOV(`R(ZT_OHRATE_+0x002,2),  `OUT(ILVB)) Flag apply to first byte only; Flag Mask #8, i.e Flag x000 (WR Len 1)
   0x9d838c06, //   3: MOV(`R(ZT_R4+0x002,2),  `     OUT(ILVB)) Flag apply to first byte only; Flag Mask #8, i.e Flag x000 (WR Len 2)
   //To read data from DILV buffer interface
   0x6e00c002, //   4: SET_IO, input 2 mst, output null
   0x80000001, //   5: MOV 1 byte
   0x00004000, //   6: WAIT_EVENT(WAIT_STOP)
   0x40020000, //   7: JUMP(0)  // END_FOREVER
   //REGISTERS USED by FP1
   //ZT_OHRATE_+0x000 ==> (READ)DTU WR Length 0 @ILVB
   //ZT_OHRATE_+0x002 ==> (READ)DTU WR Length 1 @ILVB
   //ZT_R4+0x002      ==> (READ)DTU WR Length 2 @ILVB

   // Code block 2 memory
   0x6801e000, //   0: SET_IO(`IN(NULL), `OUT(FP1) SLAVE)
   0x80000001, //   1: MOV (1 BYTE); Purpose: To ack FP1 after doing required work
   0x6e00c006, //   2: SET_IO(`IN(FP6), Master, `OUT(NULL), Master)
   0x80000001, //   3: MOV 1 byte
   0x6c1ac018, //   4: SET_IO(OUT(DTB), Master, IN(ILVB), Master,
   0x80000c34, //   5: MOV(`R(ZT_CRC1+0x000,2))
   0xa0011c36, //   6: MOV(`R(ZT_CRC1+0x002,2),`FLAG_MODE(FLAG_MODE_OR), `FLAG_MASK(1'h1), `APPLY_MODE(APPLY_MODE_LAST))
   0x00004000, //   7: WAIT_EVENT(WAIT_STOP)
   0x40020000, //   8: JUMP(0)  // END_FOREVER
   //REGISTERS USED by FP2
   //ZT_CRC1+0x000 ==> (READ)DTU RD Length 0 @ILVB
   //ZT_CRC1+0x002 ==> (READ)DTU RD Length 1 @ILVB

// Code block 3 memory
// Read input from ZT_R12 + 0 as input to gen new DTU or not, New DTU = 1; Don't gen new DTU = 0;
//XDSLRTFW-2341 (Start)
//FP3_START_L0
   0x2000F152, //  0: WR_REG(ZT_R12 + 0x0003 ==> ZT_UPROC3_STATE0 + 0x0002) Copy 8bit data from ZT_R12 + 0x0003 to ZT_UPROC3_STATE0 + 0x0002
   0x41f8080D, //  1: JUMP(FP3_INC_DTU_COUNT_L31 , REPEAT, END_WHILE_CNT_LT(ZT_R12+0x1))), Added to increment the counter
   0x2015200F, //  2: WR_REG(ZT_UPROC3_STATE0 + 0x0002 ==> ZT_R12 + 0x0003) Copy 8bit data from ZT_UPROC3_STATE0 + 0x0002 to ZT_R12 + 0x0003
//XDSLRTFW-2341 (End)
//FP3_WAIT_FOR_NEW_DTU_L3
   0x00004000, // 3:           WAIT_EVENT(WAIT_STOP)
   0x40020000, // 4:          JUMP(FP3_START_L0)
//FP3_FRAME_NEW_DTU_L5
   0x30000c40,  // 5: WR_REG, <reg_mode>=3, <byte_addr>=0x40    LSW //Reset Scrambler ZT_SCR_OFFSET  (0x40)
   0x30000c42,  // 6: WR_REG, <reg_mode>=3, <byte_addr>=0x42    MSW //Reset Scrambler ZT_SCR_OFFSET  (0x42)
   0x6c0eE805,  // 7:           SET_IO(Input Enabled, Input Master,Input Null SRC,  Input Use register (ZT_R4+0x0001, 1), OUT(SCR_D), OUT_Master; send SID
   0x80000001,  // 8:           Move 1 byte
   0x20005152,  // 9:           WR_REG(ZT_R4 + 0x0001 ==> ZT_UPROC3_STATE0 + 0x0002) Copy 8bit data from ZT_R4 + 0x0001 to ZT_UPROC3_STATE0 + 0x0002
   0x40bc00ff,  // a:         JUMP(FP3_INC_SID_COUNT_L11 , REPEAT(0xFF), KEEP_CNT, END_WHILE_CNT_LT(0xFF))), Added to increment the counter
//FP3_INC_SID_COUNT_L11
   0x20152005,  // b:          WR_REG(ZT_UPROC3_STATE0 + 0x0002 ==> ZT_R4 + 0x0001) Copy 8bit data from ZT_UPROC3_STATE0 + 0x0002 to ZT_R4 + 0x0001
   0x20000d52,  // c:          WR_REG(Data_Mask0(0) ==> ZT_UPROC3_STATE0 + 0x0002) Clear repeat counter at FP3
   0x40E80001,  // d:          JUMP(FP3_CLR_KEEP_CNT_BIT_L14 , REPEAT(0x1),END_WHILE_CNT_LT(0x01))), Clear Keep count bit
//FP3_CLR_KEEP_CNT_BIT_L14
   0x6000E804,  // e:          SET_IO(Input Enabled, Input Master,Input Null SRC,  Input Use register (ZT_R4+0x0000, 1); send TS
   0x80000001,  // f:           Move 1 byte
   0x6000E033,  // 10:           SET_IO(Input Enabled, Input Master,Input Null SRC,  Input CONST(0x33); V- Padding byte content
   0x80000819,  // 11:           Move No of V Padded byte available at (ZT_FRAMING+0x0001, 1)
   0x60008016,  // 12:           SET_IO(Input Enabled, Input slave, IN(TCLAYER))
   0x8960081a,  // 13: MOV(`R(ZT_FRAMING+0x002,1), `IN(TCLAYER)) , Move (Kp - V - 2) bytes
//FP3_IS_ALL_CW_DONE_L_20:
   0x41680818, // 14: JUMP(FP3_TRANS_NEW_DTU_CW_L22, END_WHILE_CNT_LT(`R(ZT_FRAMING+0x000,0))) //Compare Q counter
   0x41820000, // 15: JUMP(FP3_TRANS_DONE_L24)
//FP3_TRANS_NEW_DTU_CW_L22
   0x89600811, // 16: MOV(`R(ZT_CODEWORD+0x001,1), `IN(TCLAYER)) , Move Kp bytes
   0x41420000, // 17: JUMP(FP3_IS_ALL_CW_DONE_L_20)
//XDSLRTFW-2341 (Start)
//FP3_TRANS_DONE_L24:
   0x80000000,  // 18: NOP
   0x80000000,  // 19: NOP
   0x80000000,  // 1a: NOP
   0x80000000,  // 1b: NOP
   0x80000000,  // 1c: NOP
   0x80000000,  // 1d: NOP
   0x40020000,  // 1e: JUMP(FP3_START_L0)
//FP3_INC_DTU_COUNT_L31
//XDSLRTFW-2341 (End)
   0x2015200F, // 1f:  WR_REG(ZT_UPROC3_STATE0 + 0x0002 ==> ZT_R12 + 0x0003) Copy 8bit data from ZT_UPROC3_STATE0 + 0x0002 to ZT_R12 + 0x0003
   0x20000d52, // 20:  WR_REG(Data_Mask0(0) ==> ZT_UPROC3_STATE0 + 0x0002) Clear repeat counter at FP3
//FP3_DTU_END_L33
   0x40520000,  // 21: JUMP(FP3_FRAME_NEW_DTU_L5)  // END_FOREVER
   //REGISTERS USED by FP3
   //ZT_SCR_OFFSET+0x0 ==> (WRITE)Scrambler Reset
   //ZT_SCR_OFFSET+0x2 ==> (WRITE)Scrambler Reset
   //ZT_R4+0x0001      ==> (READ/MODIFY)SID
   //ZT_R4+0x0000      ==> (READ)TS
   //ZT_FRAMING+0x000  ==> (READ)Q  (No of CWs in a DTU)
   //ZT_FRAMING+0x001  ==> (READ)V Bytes
   //ZT_FRAMING+0x002  ==> (READ)Kp-V-2, Bytes in 1st CW of DTU
   //ZT_CODEWORD+0x001 ==> (READ)Kp bytes
   //ZT_R12+0x001      ==> (READ) No of New DTU to be generated
   //ZT_R12+0x003      ==> (READ/MODIFY)Local counter compare against ZT_R12+0x001

// Code block 4 memory
//FP4_START_L0
//XDSLRTFW-2341 (Start)
   0x2001B166, // 0 :WR_REG(ZT_FRAMING + 0x0003 ==> ZT_UPROC4_STATE0 + 0x0002) Copy 8bit data from ZT_FRAMING + 0x0003 to ZT_UPROC4_STATE0 + 0x0002
   0x4158080D, // 1 :JUMP(FP4_INC_DTU_COUNT_L21 , REPEAT, END_WHILE_CNT_LT(ZT_R12+0x1))), Added to increment the counter
   0x2016601B, // 2 :WR_REG(ZT_UPROC4_STATE0 + 0x0002 ==> ZT_FRAMING + 0x0003) Copy 8bit data from ZT_UPROC4STATE0 + 0x0002 to ZT_FRAMING + 0x0003
   //XDSLRTFW-2341 (End)
//FP4_WAIT_FOR_NEW_DTU_L3
   0x00004000, // 3 :WAIT_EVENT(WAIT_STOP)
   0x40020000, // 4 :JUMP(FP4_START_L0)
//FP4_FRAME_NEW_DTU_L5
   0x6e000000, // 5 :SET_IO(`NULL_DST)
   0x80000001, // 6 :Move 1 byte // Move SID Byte
   0x80000001, // 7 :Move 1 byte //MOV(`R(ZT_R4+0x0,1)) Move TS Byte
   0x80000819, // 8 :Move No of V Padded byte available at (ZT_FRAMING+0x0001, 1)
   0x8d62281a, // 9 :MOV(`R(ZT_FRAMING+0x002,1), `OUT(TCLAYER), `FLAG_MODE(FLAG_MODE_AND), `FLAG_MASK(4'h2), `APPLY_MODE(APPLY_MODE_ALL)), Move (Kp - V - 2) bytes
//FP4_IS_ALL_CW_DONE_L_10:
   0x40C80818, // 10:JUMP(FP4_TRANS_CW_L12, END_WHILE_CNT_LT(`R(ZT_FRAMING+0x000,0)))
   0x40E20000, // 11:JUMP(FP4_TRANS_DONE_L14)
//FP4_TRANS_CW_L12:
   0x8d622811, // 12:MOV(`R(ZT_CODEWORD+0x001,1), `OUT(TCLAYER), `FLAG_MODE(FLAG_MODE_AND), `FLAG_MASK(4'h2), `APPLY_MODE(APPLY_MODE_ALL)), Kp bytes
   0x40A20000, // 13:JUMP(FP4_IS_ALL_CW_DONE_L_10)
//FP4_TRANS_DONE_L14:
//XDSLRTFW-2341 (Start)
   0x80000000, // 14:NOP
   0x80000000, // 15:NOP
   0x80000000, // 16:NOP
   0x80000000, // 17:NOP
   0x80000000, // 18:NOP
   0x80000000, // 19:NOP
   0x40020000, // 20:JUMP(FP4_START_L0)
//XDSLRTFW-2341 (End)
//FP4_INC_DTU_COUNT_L21
   0x2016601B, // 21:WR_REG(ZT_UPROC4_STATE0 + 0x0002 ==> ZT_FRAMING + 0x0003) Copy 8bit data from ZT_UPROC4_STATE0 + 0x0002 to ZT_FRAMING + 0x0003
   0x20000d66, // 22:WR_REG(Data_Mask0(0) ==> ZT_UPROC4_STATE0 + 0x0002) Clear repeat counter at FP4
//FP4_DTU_END_L23
   0x40520000, // 23:JUMP(FP4_FRAME_NEW_DTU_L5)  // END_FOREVER

   // Code block 5 memory
   // FP5 is not being used

   // Code block 6 memory
   0x6802e000, //   0('h0004e): SET_IO(`IN(NULL), `OUT(FP2) SLAVE)
   0x80000001, //   1('h00055): MOV (1 BYTE); Purpose: Wait for FP2 to start reading ILV buffer
   0x6c19e000, //   2('h00044): SET_IO, input null_src, output block_id=25 (ILVB read flags) master
   0x90038c34, //   3('h00045): MOV(R(ZT_CRC1+0x000,2) bytes, <use_reg>=1, <reg_id>=0x1B, <apply_mode>=1, <flag_mode>=3, <flag_mask>=0x8
   0x90038c36, //   4('h00045): MOV(R(ZT_CRC1+0x002,2) bytes, <use_reg>=1, <reg_id>=0x1B, <apply_mode>=1, <flag_mode>=3, <flag_mask>=0x8
   0x00004000, //   5('h00047): WAIT_EVENT(WAIT_STOP)  // wait for a stop
   0x40020000, //   6('h00048): JUMP(0)  // Restart

   // Code block 7 memory
   // The below part of the code moves data from ILV0 to Fp1.


   0x6c01c014, // 0: Output Fp1, Input ILV0
   0x80000810, // 1:
   0x40080898, // 2: Jump 1, cnt < ZR_DEPTH 0,

   //*************** Initialise ILV0 counters ***************************************************************************************
   0x30000cb4, // 3: WR_REG(`DEST(ZT_ILV_CNTRS0+0x000), `ACCESS_MODE(WR_REG_16), `WR_MODE(WR_REG_OVER), `WR_MASK(16'h  0000))
   0x30000cb6, // 4: WR_REG(`DEST(ZT_ILV_CNTRS0+0x002), `ACCESS_MODE(WR_REG_16), `WR_MODE(WR_REG_OVER), `WR_MASK(16'h  0000))
   0x30000cb8, // 5: WR_REG(`DEST(ZT_ILV_PMS_CNTRS0+0x000), `ACCESS_MODE(WR_REG_16),`WR_MODE(WR_REG_OVER), `WR_MASK(16'h  0000))
   0x30000cba, // 6: WR_REG(`DEST(ZT_ILV_PMS_CNTRS0+0x002), `ACCESS_MODE(WR_REG_16),`WR_MODE(WR_REG_OVER), `WR_MASK(16'h  0000))
   0x30000cbe, // 7: WR_REG(`DEST(ZT_ILV_PMD_CNTRS0+0x002), `ACCESS_MODE(WR_REG_16),`WR_MODE(WR_REG_OVER), `WR_MASK(16'h  0000))
   0x30000cbc, // 8: WR_REG(`DEST(ZT_ILV_PMD_CNTRS0+0x000), `ACCESS_MODE(WR_REG_16),`WR_MODE(WR_REG_OVER), `WR_MASK(16'h  0000))
   //********************************************************************************************************************************

   //&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
   0x30000cae, // 9: WR_REG(`DEST(ZR_ILV_MIN_FULLNESS0+0x002), `ACCESS_MODE(WR_REG_16), `WR_MODE(WR_REG_OVER), `WR_MASK(16'h  0000))
   0x30000caa, // a: WR_REG(`DEST(ZR_ILV_MAX_FULLNESS0+0x002), `ACCESS_MODE(WR_REG_16),`WR_MODE(WR_REG_OVER), `WR_MASK(16'h  0000))
   0x300a40ac, // b: WR_REG(`DEST(ZR_ILV_MIN_FULLNESS0+0x000), `ACCESS_MODE(WR_REG_16), `WR_MODE(WR_REG_OVER), `WR_MASK(16'h  0000))
   0x300a40a8, // c: WR_REG(`DEST(ZR_ILV_MAX_FULLNESS0+0x000), `ACCESS_MODE(WR_REG_16),`WR_MODE(WR_REG_OVER), `WR_MASK(16'h  0000))
   //********************************************************************************************************************************



   // The below part of the code moves data from ILV1 to Fp1.
   0x6c01c015, // d: Output Fp1, Input ILV1
   0x80000810, // e:
   0x40d80898, // f: Jump 1, cnt < ZR_DEPTH 0,


   //*************** Initialise ILV1 counters ***************************************************************************************
   0x30000cd8, // 10: WR_REG(`DEST(ZR_ILV_CNTRS1+0x000), `ACCESS_MODE(WR_REG_16), `WR_MODE(WR_REG_OVER), `WR_MASK(16'h  0000))
   0x30000cda, // 11: WR_REG(`DEST(ZR_ILV_CNTRS1+0x002), `ACCESS_MODE(WR_REG_16), `WR_MODE(WR_REG_OVER), `WR_MASK(16'h  0000))
   0x30000cdc, // 12: WR_REG(`DEST(ZR_ILV_PMS_CNTRS1+0x000), `ACCESS_MODE(WR_REG_16),`WR_MODE(WR_REG_OVER), `WR_MASK(16'h  0000))
   0x30000cde, // 13: WR_REG(`DEST(ZR_ILV_PMS_CNTRS1+0x002), `ACCESS_MODE(WR_REG_16),`WR_MODE(WR_REG_OVER), `WR_MASK(16'h  0000))
   0x30000ce2, // 14: WR_REG(`DEST(ZR_ILV_PMD_CNTRS1+0x002), `ACCESS_MODE(WR_REG_16),`WR_MODE(WR_REG_OVER), `WR_MASK(16'h  0000))
   0x30000ce0, // 15: WR_REG(`DEST(ZR_ILV_PMD_CNTRS1+0x000), `ACCESS_MODE(WR_REG_16),`WR_MODE(WR_REG_OVER), `WR_MASK(16'h  0000))
   //********************************************************************************************************************************
   //&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
   0x30000cd2, // 16: WR_REG(`DEST(ZR_ILV_MIN_FULLNESS0+0x002), `ACCESS_MODE(WR_REG_16), `WR_MODE(WR_REG_OVER), `WR_MASK(16'h  0000))
   0x30000cce, // 17: WR_REG(`DEST(ZR_ILV_MAX_FULLNESS0+0x002), `ACCESS_MODE(WR_REG_16),`WR_MODE(WR_REG_OVER), `WR_MASK(16'h  0000))
   0x300c80d0, // 18: WR_REG(`DEST(ZR_ILV_MIN_FULLNESS0+0x000), `ACCESS_MODE(WR_REG_16), `WR_MODE(WR_REG_OVER), `WR_MASK(16'h  0000))
   0x300c80cc, // 19: WR_REG(`DEST(ZR_ILV_MAX_FULLNESS0+0x000), `ACCESS_MODE(WR_REG_16),`WR_MODE(WR_REG_OVER), `WR_MASK(16'h  0000))
   //&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
   0x40020000, // 1a: Jump 0


   // Program will require these registers:
   //   ZT_CODEWORD+0x001 [7:0] - ?? (MOV byte count)
   //   ZT_CODEWORD+0x002 [7:0] - ?? (MOV byte count)
   //   ZT_FRAMING+0x000 [7:0]   -  (contains Q amount of code words, i.e No of code words/DTU)
   //   ZT_FRAMING+0x001 [15:8]  -  (contains V amount of padded bytes to be added for DTU framing)
   //   ZT_FRAMING+0x002 [23:16] -  (contains K-V-2 bytes)
   //   ZT_FRAMING+0x003 [31:24] -  (Reserved)
   //   ZT_OHRATE+0x000 [15:0] -    (MOV byte count for ReTx Queue Write Len 1)
   //   ZT_OHRATE+0x002 [31:16] -   (MOV byte count for ReTx Queue Write Len 2)
   //   ZT_R4+0x002 [31:16] -       (MOV byte count for ReTx Queue Write Len 3)
   //   ZT_R4+0x000 [7:0]           (Contains Time stamp)
   //   ZT_R4+0x001 [15:8]          (Contains SID)
   //   ZT_CRC1+0x000 [15:0] -      (MOV byte count for ReTx Queue Read Len 1)
   //   ZT_CRC1+0x000 [31:16] -     (MOV byte count for ReTx Queue Read Len 2)
   //0
}; //int fci_prog_tx_vdsl2_bc0_lp1_retx[] = {
DATA_MAP_END;
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
//XDSLRTFW-1617 (End)



DATA_MAP_FCI_TX_PORT1_LP0_UCODE
int fci_prog_tx_vdsl2_bc1_lp0[] =
{
   0x4101, // ID.V.v
   /*
   */
   0x0000003f, // UPROC_ENA
   0x0000,   5, 0x00000000, 0x20000000, 0x00000000, 0x00000002, 0x00000000,  // Code block 0 base, size, STATE0-4
   0x0005,   3, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 1 base, size, STATE0-4
   0x0008,   3, 0x00000000, 0x20000000, 0x00000000, 0x04000000, 0x00000000,  // Code block 2 base, size, STATE0-4
   0x000b,  13, 0x00000000, 0x20000000, 0x00000000, 0x00004400, 0x00000000,  // Code block 3 base, size, STATE0-4
   0x0018,  15, 0x00000000, 0x50000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 4 base, size, STATE0-4
   0x0027,   9, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 5 base, size, STATE0-4
   0x0000,   0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 6 base, size, STATE0-4
   0x0000,   0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 7 base, size, STATE0-4
   0x0000,   0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 8 base, size, STATE0-4
   0x0000,   0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 9 base, size, STATE0-4
   0x04000004, // FLAG_DATA 0
   0x00000050, // FLAG_DATA 1
   48, // Total code length
   // Code block 0 memory
   0x6d10c00e, //   0('h00000): SET_IO(`IN(SCR_D), `OUT(RS_D), `KEEP_MASK)
   0x80000811, //   1('h00001): MOV(`R(ZT_CODEWORD+0x001,0))
   0x6c01c010, //   2('h00002): SET_IO(`IN(RS_D), `OUT(FP1))
   0x80000812, //   3('h00003): MOV(`R(ZT_CODEWORD+0x002,0))
   0x40020000, //   4('h00004): JUMP(0)  // END_FOREVER
   // Code block 1 memory
   0x8d400df8, //   0('h00005): MOV(`R(ZT_PMS_SIZE+0x000,1), `OUT(ILV0))
   0x00004000, //   1('h00006): WAIT_EVENT(WAIT_STOP)
   0x40020000, //   2('h00007): JUMP(0)  // END_FOREVER
   // Code block 2 memory
   0xa9411df8, //   0('h00008): MOV(`R(ZT_PMS_SIZE+0x000,1), `IN(ILV0), `FLAG_MODE(FLAG_MODE_OR), `FLAG_MASK(4'h1), `APPLY_MODE(APPLY_MODE_LAST))
   0x00004000, //   1('h00009): WAIT_EVENT(WAIT_STOP)
   0x40020000, //   2('h0000a): JUMP(0)  // END_FOREVER
   // Code block 3 memory
   0xc850081c, //   0('h0000b): MOV(`R(ZT_OHRATE+0x000,0), `IN(FP5), `KEEP_CNT)
   0x89600c1e, //   1('h0000c): MOV(`R(ZT_OHRATE+0x002,1), `IN(TCLAYER))
   0x80000c14, //   2('h0000d): MOV(`R(ZT_VBC_SIZE+0x000,1))
   0x400c081b, //   3('h0000e): JUMP(0, `REPEAT(`R(ZT_FRAMING+0x003,0)), `KEEP_CNT)  // END_WHILE_CNT_LT(`R(ZT_FRAMING+0x003,0)), `KEEP_CNT)
   0x408a081a, //   4('h0000f): JUMP(8, `IFCNTLT(`R(ZT_FRAMING+0x002,0)))  // WHILE_CNT_LT(`R(ZT_FRAMING+0x002,0)))
   0x40c20000, //   5('h00010): JUMP(12)
   0x4088081a, //   6('h00011): JUMP(8, `REPEAT(`R(ZT_FRAMING+0x002,0)))
   0x40c20000, //   7('h00012): JUMP(12)
   0xc850081d, //   8('h00013): MOV(`R(ZT_OHRATE+0x001,0), `IN(FP5), `KEEP_CNT)
   0x89600c1e, //   9('h00014): MOV(`R(ZT_OHRATE+0x002,1), `IN(TCLAYER))
   0x80000c14, //  10('h00015): MOV(`R(ZT_VBC_SIZE+0x000,1))
   0x40620000, //  11('h00016): JUMP(6)  // END_WHILE
   0x40020000, //  12('h00017): JUMP(0)  // END_FOREVER
   // Code block 4 memory
   0x6e000000, //   0('h00018): SET_IO(`NULL_DST)
   0xc000081c, //   1('h00019): MOV(`R(ZT_OHRATE+0x000,0), `KEEP_CNT)
   0x8d612c1e, //   2('h0001a): MOV(`R(ZT_OHRATE+0x002,1), `OUT(TCLAYER), `FLAG_MODE(FLAG_MODE_OR), `FLAG_MASK(4'h2), `APPLY_MODE(APPLY_MODE_ALL))
   0x8d612c14, //   3('h0001b): MOV(`R(ZT_VBC_SIZE+0x000,1), `OUT(TCLAYER), `FLAG_MODE(FLAG_MODE_OR), `FLAG_MASK(4'h2), `APPLY_MODE(APPLY_MODE_ALL))
   0x400c081b, //   4('h0001c): JUMP(0, `REPEAT(`R(ZT_FRAMING+0x003,0)), `KEEP_CNT)  // END_WHILE_CNT_LT(`R(ZT_FRAMING+0x003,0)), `KEEP_CNT)
   0x409a081a, //   5('h0001d): JUMP(9, `IFCNTLT(`R(ZT_FRAMING+0x002,0)))  // WHILE_CNT_LT(`R(ZT_FRAMING+0x002,0)))
   0x40e20000, //   6('h0001e): JUMP(14)
   0x4098081a, //   7('h0001f): JUMP(9, `REPEAT(`R(ZT_FRAMING+0x002,0)))
   0x40e20000, //   8('h00020): JUMP(14)
   0x6e000000, //   9('h00021): SET_IO(`NULL_DST)
   0xc000081d, //  10('h00022): MOV(`R(ZT_OHRATE+0x001,0), `KEEP_CNT)
   0x8d612c1e, //  11('h00023): MOV(`R(ZT_OHRATE+0x002,1), `OUT(TCLAYER), `FLAG_MODE(FLAG_MODE_OR), `FLAG_MASK(4'h2), `APPLY_MODE(APPLY_MODE_ALL))
   0x8d612c14, //  12('h00024): MOV(`R(ZT_VBC_SIZE+0x000,1), `OUT(TCLAYER), `FLAG_MODE(FLAG_MODE_OR), `FLAG_MASK(4'h2), `APPLY_MODE(APPLY_MODE_ALL))
   0x40720000, //  13('h00025): JUMP(7)  // END_WHILE
   0x40020000, //  14('h00026): JUMP(0)  // END_FOREVER
   // Code block 5 memory
   0x00002000, //   0('h00027): WAIT_EVENT(WAIT_OUT)
   0x403e0808, //   1('h00028): JUMP(3, `IFCNTLT(`R(ZT_R8+0x000,0)), `KEEP_CNT)  // IF_CNT_LT(`R(ZT_R8+0x000,0)))
   0x40520000, //   2('h00029): JUMP(5)
   0xc8a51001, //   3('h0002a): MOV(1, `IN(CRC0_D), `FLAG_MODE(FLAG_MODE_OR), `FLAG_MASK(4'h1), `APPLY_MODE(APPLY_MODE_ALL), `KEEP_CNT, `INVERT)
   0x40620000, //   4('h0002b): JUMP(6)  // ELSE
   0xc8a11001, //   5('h0002c): MOV(1, `IN(CRC0_D), `FLAG_MODE(FLAG_MODE_OR), `FLAG_MASK(4'h1), `APPLY_MODE(APPLY_MODE_ALL), `KEEP_CNT)
   0x20001c00, //   6('h0002d): WR_REG(`DEST(ZT_R0+0x000), `WR_MODE(WR_REG_OVER), `WR_MASK(8'h01))
   0x89c00c18, //   7('h0002e): MOV(`R(ZT_FRAMING+0x000,1), `IN(FIFO0))
   0x40020000, //   8('h0002f): JUMP(0)
   // Program will require these registers:
   //   ZT_CODEWORD+0x001 [7:0] - ?? (MOV byte count)
   //   ZT_CODEWORD+0x002 [7:0] - ?? (MOV byte count)
   //   ZT_FRAMING+0x000 [15:0] - ?? (MOV byte count)
   //   ZT_FRAMING+0x002 [7:0] - ?? (JUMP repeat count)
   //   ZT_FRAMING+0x003 [7:0] - ?? (JUMP repeat count)
   //   ZT_OHRATE+0x000 [7:0] - ?? (MOV byte count)
   //   ZT_OHRATE+0x001 [7:0] - ?? (MOV byte count)
   //   ZT_OHRATE+0x002 [15:0] - ?? (MOV byte count)
   //   ZT_PMS_SIZE+0x000 [15:0] - ?? (MOV byte count)
   //   ZT_R8+0x000 [7:0] - ?? (JUMP repeat count)
   //   ZT_VBC_SIZE+0x002 [15:0] - ?? (MOV byte count)
   // Code block 5 will modify these registers:
   //   ZT_R0+0x000 [7:0] -
   0
}; //int fci_prog_tx_vdsl2_bc1_lp0[]

DATA_MAP_END; //DATA_MAP_FCI_TX_PORT1_LP0_UCODE

DATA_MAP_FCI_RX_LP0_UCODE
#ifndef RX_FIFO3_WRITE_UPDATED
#if 1
// baseline rx uCode from R3.5 releases.
int fci_prog_rx_vdsl2_bc0_lp0[] =
{
   0x05002, // ID.bc.lp.v
   /*
   */
   0x000003ff, // UPROC_ENA
   0x0000,   3, 0x00001a00, 0x10000000, 0x001a0000, 0x00000000, 0x00000000,  // Code block 0 base, size, STATE0-4
   0x0003,   3, 0x00000000, 0x70000000, 0x00000000, 0x08000000, 0x00000000,  // Code block 1 base, size, STATE0-4
   0x0006,  18, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 2 base, size, STATE0-4
   0x0018,   5, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 3 base, size, STATE0-4
   0x001d,   2, 0x00000000, 0x20000000, 0x00000000, 0x00004000, 0x00000000,  // Code block 4 base, size, STATE0-4
   0x001f,  18, 0x00000e00, 0x10000000, 0x000e0000, 0x00000000, 0x00000000,  // Code block 5 base, size, STATE0-4
   0x0031,   4, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 6 base, size, STATE0-4
   0x0035,   4, 0x00000000, 0x50000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 7 base, size, STATE0-4
   0x0039,   4, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 8 base, size, STATE0-4
   0x003D,   5, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 9 base, size, STATE0-4
   0x76000044, // FLAG_DATA 0
   0x00000656, // FLAG_DATA 1
   66, // Total code length
   // Code block 0 memory
   // Moves bytes from the DTB to the DILV, counting PMS_SIZE before stopping
   0x8c200e3c, //   0('h00000): MOV(`R(ZR_PMS_SIZE+0x000,1), `OUT(FP2))  // Move P bytes to DILV
   0x00004000, //   1('h00001): WAIT_EVENT(WAIT_STOP)  // wait for a stop
   0x40020000, //   2('h00002): JUMP(0)  // Restart
   // Code block 1 memory
   // Pass DTB read-flags into DTB
   0xa0014e3c, //   0('h00003): MOV(`R(ZR_PMS_SIZE+0x000,1), `FLAG_MODE(FLAG_MODE_OR), `FLAG_MASK(4'h4), `APPLY_MODE(APPLY_MODE_LAST))
   0x00004000, //   1('h00004): WAIT_EVENT(WAIT_STOP)  // wait for a stop
   0x40020000, //   2('h00005): JUMP(0)  // END_FOREVER
   // Code block 2 memory
   // Move bytes into and out of the DILV, one cw at a time
   0x30000cac, //   0('h00006): WR_REG(`DEST(ZR_ILV_MIN_FULLNESS0+0x000), `ACCESS_MODE(WR_REG_16), `WR_MODE(WR_REG_OVER), `WR_MASK(16'h  0000))
   0x30000cae, //   1('h00007): WR_REG(`DEST(ZR_ILV_MIN_FULLNESS0+0x002), `ACCESS_MODE(WR_REG_16), `WR_MODE(WR_REG_OVER), `WR_MASK(16'h  0000))
   0x200ffca9, //   2('h00008): WR_REG(`DEST(ZR_ILV_MAX_FULLNESS0+0x001), `WR_MODE(WR_REG_OVER), `WR_MASK(8'hff))
   0x200ffca8, //   3('h00009): WR_REG(`DEST(ZR_ILV_MAX_FULLNESS0+0x000), `WR_MODE(WR_REG_OVER), `WR_MASK(8'hff))
   0x30003caa, //   4('h0000a): WR_REG(`DEST(ZR_ILV_MAX_FULLNESS0+0x002), `ACCESS_MODE(WR_REG_16), `WR_MODE(WR_REG_OVER), `WR_MASK(16'h  0003))
   0x409a089d, //   5('h0000b): JUMP(9, `IFCNTLT(`R(ZR_ILV_PARAMS0+0x001,0)))  // WHILE_CNT_LT(`R(ZR_ILV_PARAMS0+0x001,0)))
   0x40c20000, //   6('h0000c): JUMP(12)
   0x4098089d, //   7('h0000d): JUMP(9, `REPEAT(`R(ZR_ILV_PARAMS0+0x001,0)))
   0x40c20000, //   8('h0000e): JUMP(12)
   0x8d400c08, //   9('h0000f): MOV(`R(ZR_R8+0x000,1), `OUT(ILV0))
   0x30000cb0, //  10('h00010): WR_REG(`DEST(ZR_ILV_FULLNESS0+0x000), `ACCESS_MODE(WR_REG_16), `WR_MODE(WR_REG_OVER), `WR_MASK(16'h  0000))
   0x40720000, //  11('h00011): JUMP(7)  // END_WHILE
   0x80000810, //  12('h00012): MOV(`R(ZR_CODEWORD+0x000,0))  // move CW to ilv
   0x6c10c014, //  13('h00013): SET_IO(`IN(ILV0), `OUT(RS_D))
   0xce300001, //  14('h00014): MOV(1, `OUT(FP3), `KEEP_MASK, `KEEP_CNT)  // Move the first byte to the METRIC CB for synchro
   0x8d000810, //  15('h00015): MOV(`R(ZR_CODEWORD+0x000,0), `OUT(RS_D))  // Move the rest of the CW bytes to RSD
   0x6c148000, //  16('h00016): SET_IO(`SLVIN, `OUT(ILV0))
   0x40c20000, //  17('h00017): JUMP(12)  // END_FOREVER
   // Code block 3 memory
   // Move metrics from METRIC FIFO to the RS Decoder
   0x6e008000, //   0('h00018): SET_IO(`SLVIN, `NULL_DST)
   0x80000001, //   1('h00019): MOV(1)  // Move the first byte (which is for synchro) to NULL
   0x6c11c011, //   2('h0001a): SET_IO(`IN(RSDEC_MET), `OUT(RSDEC_MET))
   0x80000810, //   3('h0001b): MOV(`R(ZR_CODEWORD+0x000,0))  // Move N bytes from metric FIFO to RSD metric
   0x40020000, //   4('h0001c): JUMP(0)  // Restart
   // Code block 4 memory
   // Moves correct bytes from the reed solomon to the descrambler
   0x89000811, //   0('h0001d): MOV(`R(ZR_CODEWORD+0x001,0), `IN(RS_D))  // Move K bytes from RSD to the scrambler
   0x40020000, //   1('h0001e): JUMP(0)  // Restart
   // Code block 5 memory
   // Deframe the mux-frame
   0x6c0ad007, //   0('h0001f): SET_IO(`IN(FP7), `INPUT_FLAG, `OUT(CRC0_D))
   0xce600001, //   1('h00020): MOV(1, `OUT(FP6), `KEEP_MASK, `KEEP_CNT)
   0xce60081c, //   2('h00021): MOV(`R(ZR_OHRATE+0x000,0), `OUT(FP6), `KEEP_MASK, `KEEP_CNT)  // OH1RATE -> OH channel, clear CRCFL
   0x6c0ac00e, //   3('h00022): SET_IO(`IN(SCR_D), `OUT(CRC0_D))
   0x8f622c1e, //   4('h00023): MOV(`R(ZR_OHRATE+0x002,1), `OUT(TCLAYER), `KEEP_MASK, `FLAG_MODE(FLAG_MODE_AND), `FLAG_MASK(4'h2), `APPLY_MODE(APPLY_MODE_ALL))
   0x80022c14, //   5('h00024): MOV(`R(ZR_VBC_SIZE+0x000,1), `FLAG_MODE(FLAG_MODE_AND), `FLAG_MASK(4'h2), `APPLY_MODE(APPLY_MODE_ALL))
   0x400c081b, //   6('h00025): JUMP(0, `REPEAT(`R(ZR_FRAMING+0x003,0)), `KEEP_CNT)  // END_WHILE_CNT_LT(`R(ZR_FRAMING+0x003,0)), `KEEP_CNT)
   0x40ba081a, //   7('h00026): JUMP(11, `IFCNTLT(`R(ZR_FRAMING+0x002,0)))  // WHILE_CNT_LT(`R(ZR_FRAMING+0x002,0)))
   0x41120000, //   8('h00027): JUMP(17)
   0x40b8081a, //   9('h00028): JUMP(11, `REPEAT(`R(ZR_FRAMING+0x002,0)))
   0x41120000, //  10('h00029): JUMP(17)
   0x6c0ad007, //  11('h0002a): SET_IO(`IN(FP7), `INPUT_FLAG, `OUT(CRC0_D))
   0xce60081d, //  12('h0002b): MOV(`R(ZR_OHRATE+0x001,0), `OUT(FP6), `KEEP_MASK, `KEEP_CNT)  // OH2RATE -> OH channel, clear CRCFL
   0x6c0ac00e, //  13('h0002c): SET_IO(`IN(SCR_D), `OUT(CRC0_D))
   0x8f622c1e, //  14('h0002d): MOV(`R(ZR_OHRATE+0x002,1), `OUT(TCLAYER), `KEEP_MASK, `FLAG_MODE(FLAG_MODE_AND), `FLAG_MASK(4'h2), `APPLY_MODE(APPLY_MODE_ALL))
   0x80022c14, //  15('h0002e): MOV(`R(ZR_VBC_SIZE+0x000,1), `FLAG_MODE(FLAG_MODE_AND), `FLAG_MASK(4'h2), `APPLY_MODE(APPLY_MODE_ALL))
   0x40920000, //  16('h0002f): JUMP(9)  // END_WHILE
   0x40020000, //  17('h00030): JUMP(0)
   // Code block 6 memory
   // Process the OH channel
   0x6e000000, //   0('h00031): SET_IO(`NULL_DST)
   0xc0000001, //   1('h00032): MOV(1, `KEEP_CNT)
   0x8dc00c18, //   2('h00033): MOV(`R(ZR_FRAMING+0x000,1), `OUT(FIFO0))  // Everything else from FIFO0
   0x40020000, //   3('h00034): JUMP(0)
   // Code block 7 memory
   // Setup flags for the OH channel
   0xc0011001, //   0('h00035): MOV(1, `FLAG_MODE(FLAG_MODE_OR), `FLAG_MASK(4'h1), `APPLY_MODE(APPLY_MODE_ALL), `KEEP_CNT)
   0x20001c00, //   1('h00036): WR_REG(`DEST(ZR_R0+0x000), `WR_MODE(WR_REG_OVER), `WR_MASK(8'h01))  // Set ZR_R0 to 1 to indicate SEQP_DONE
   0x80000c18, //   2('h00037): MOV(`R(ZR_FRAMING+0x000,1))
   0x40020000, //   3('h00038): JUMP(0)

   // Code block 8 memory
   0x6C0CC018, //   0()    : SET_IO(`IN(ILVBIF), `OUT(CRC1))
   //0x6C0CE055, //  0()      : SET_IO(`Input Enabled, Input Master,Input Null SRC,  Input CONST(0x55), `OUT(CRC1))
   //  0x6C0CE80C, //   0()      : SET_IO(`Input Enabled, Input Master,Input Null SRC,  Input CONST(0x55), `OUT(CRC1))
   //0x80000C04, //  1()      : MOV(`R(ZR_R4+0x00,2))
   0x90011c04, //   1()    : MOV(`R(ZR_R4+0x0,2),`FLAG_MODE(FLAG_MODE_OR), `FLAG_MASK(1'h1), `APPLY_MODE(APPLY_MODE_FIRST))
   0x00004000, //   2('h00009): WAIT_EVENT(WAIT_STOP)
   0x40020000, //   3('h0000a): JUMP(0)  // END_FOREVER

   // Code block 9 memory
   0x6c19e000, //   0('h00044): SET_IO, input null_src, output block_id=25 (ILVB read flags) master
   0x90038c04, //   1('h00045): MOV(R(ZR_R4+0x000,2) bytes, <use_reg>=1, <reg_id>=0x1B, <apply_mode>=1, <flag_mode>=3, <flag_mask>=0x8
   0x00004000, //   2('h00047): WAIT_EVENT(WAIT_STOP)  // wait for a stop
   0x40020000, //   3('h00048): JUMP(0)   // Restart
   // Program will require these registers:
   //   ZR_CODEWORD+0x000 [7:0] - FEC Codeword size
   //   ZR_CODEWORD+0x001 [7:0] - Kp = N - R
   //   ZR_FRAMING+0x000 [15:0] - Set to SEQp
   //   ZR_FRAMING+0x002 [7:0] - Parameter Tp
   //   ZR_FRAMING+0x003 [7:0] - Number of mux frmaes with ceil(Gp/Tp) OH bytes
   //   ZR_ILV_PARAMS0+0x001 [7:0] - Interleaver Block Size
   //   ZR_OHRATE+0x000 [7:0] - ceil(Gp/Tp)
   //   ZR_OHRATE+0x001 [7:0] - floor(Gp/Tp)
   //   ZR_OHRATE+0x002 [15:0] - ceil(Gp/Tp)
   //   ZR_PMS_SIZE+0x000 [15:0] - Set to number of bytes to transfer this symbol
   //   ZR_R8+0x000 [15:0] - Set to D - floor(D/I) - 1
   //   ZR_VBC_SIZE+0x000 [15:0] - BC1 size = Bp1
   // Code block 2 will modify these registers:
   //   ZR_ILV_FULLNESS0+0x000 [15:0] - Reset fullness to 0 after each iblock
   //   ZR_ILV_MAX_FULLNESS0+0x000 [7:0] -
   //   ZR_ILV_MAX_FULLNESS0+0x001 [7:0] -
   //   ZR_ILV_MAX_FULLNESS0+0x002 [15:0] - Set MAX_FULLNESS to 0x3FFFF
   //   ZR_ILV_MIN_FULLNESS0+0x000 [15:0] -
   //   ZR_ILV_MIN_FULLNESS0+0x002 [15:0] - Set MIN_FULLNESS to 0
   // Code block 7 will modify these registers:
   //   ZR_R0+0x000 [7:0] - SEQP Done
   0
};

#else


// baseline rx uCode from R3.5 releases.
int fci_prog_rx_vdsl2_bc0_lp0[] =
{
   0x05001, // ID.bc.lp.v
   /*
   */
   0x000000ff, // UPROC_ENA
   0x0000,   3, 0x00001a00, 0x10000000, 0x001a0000, 0x00000000, 0x00000000,  // Code block 0 base, size, STATE0-4
   0x0003,   3, 0x00000000, 0x70000000, 0x00000000, 0x08000000, 0x00000000,  // Code block 1 base, size, STATE0-4
   0x0006,  18, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 2 base, size, STATE0-4
   0x0018,   5, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 3 base, size, STATE0-4
   0x001d,   2, 0x00000000, 0x20000000, 0x00000000, 0x00004000, 0x00000000,  // Code block 4 base, size, STATE0-4
   0x001f,  18, 0x00000e00, 0x10000000, 0x000e0000, 0x00000000, 0x00000000,  // Code block 5 base, size, STATE0-4
   0x0031,   4, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 6 base, size, STATE0-4
   0x0035,   4, 0x00000000, 0x50000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 7 base, size, STATE0-4
   0x0000,   0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 8 base, size, STATE0-4
   0x0000,   0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 9 base, size, STATE0-4
   0x06000044, // FLAG_DATA 0
   0x00000656, // FLAG_DATA 1
   57, // Total code length
   // Code block 0 memory
   // Moves bytes from the DTB to the DILV, counting PMS_SIZE before stopping
   0x8c200e3c, //   0('h00000): MOV(`R(ZR_PMS_SIZE+0x000,1), `OUT(FP2))  // Move P bytes to DILV
   0x00004000, //   1('h00001): WAIT_EVENT(WAIT_STOP)  // wait for a stop
   0x40020000, //   2('h00002): JUMP(0)  // Restart
   // Code block 1 memory
   // Pass DTB read-flags into DTB
   0xa0014e3c, //   0('h00003): MOV(`R(ZR_PMS_SIZE+0x000,1), `FLAG_MODE(FLAG_MODE_OR), `FLAG_MASK(4'h4), `APPLY_MODE(APPLY_MODE_LAST))
   0x00004000, //   1('h00004): WAIT_EVENT(WAIT_STOP)  // wait for a stop
   0x40020000, //   2('h00005): JUMP(0)  // END_FOREVER
   // Code block 2 memory
   // Move bytes into and out of the DILV, one cw at a time
   0x30000cac, //   0('h00006): WR_REG(`DEST(ZR_ILV_MIN_FULLNESS0+0x000), `ACCESS_MODE(WR_REG_16), `WR_MODE(WR_REG_OVER), `WR_MASK(16'h  0000))
   0x30000cae, //   1('h00007): WR_REG(`DEST(ZR_ILV_MIN_FULLNESS0+0x002), `ACCESS_MODE(WR_REG_16), `WR_MODE(WR_REG_OVER), `WR_MASK(16'h  0000))
   0x200ffca9, //   2('h00008): WR_REG(`DEST(ZR_ILV_MAX_FULLNESS0+0x001), `WR_MODE(WR_REG_OVER), `WR_MASK(8'hff))
   0x200ffca8, //   3('h00009): WR_REG(`DEST(ZR_ILV_MAX_FULLNESS0+0x000), `WR_MODE(WR_REG_OVER), `WR_MASK(8'hff))
   0x30003caa, //   4('h0000a): WR_REG(`DEST(ZR_ILV_MAX_FULLNESS0+0x002), `ACCESS_MODE(WR_REG_16), `WR_MODE(WR_REG_OVER), `WR_MASK(16'h  0003))
   0x409a089d, //   5('h0000b): JUMP(9, `IFCNTLT(`R(ZR_ILV_PARAMS0+0x001,0)))  // WHILE_CNT_LT(`R(ZR_ILV_PARAMS0+0x001,0)))
   0x40c20000, //   6('h0000c): JUMP(12)
   0x4098089d, //   7('h0000d): JUMP(9, `REPEAT(`R(ZR_ILV_PARAMS0+0x001,0)))
   0x40c20000, //   8('h0000e): JUMP(12)
   0x8d400c08, //   9('h0000f): MOV(`R(ZR_R8+0x000,1), `OUT(ILV0))
   0x30000cb0, //  10('h00010): WR_REG(`DEST(ZR_ILV_FULLNESS0+0x000), `ACCESS_MODE(WR_REG_16), `WR_MODE(WR_REG_OVER), `WR_MASK(16'h  0000))
   0x40720000, //  11('h00011): JUMP(7)  // END_WHILE
   0x80000810, //  12('h00012): MOV(`R(ZR_CODEWORD+0x000,0))  // move CW to ilv
   0x6c10c014, //  13('h00013): SET_IO(`IN(ILV0), `OUT(RS_D))
   0xce300001, //  14('h00014): MOV(1, `OUT(FP3), `KEEP_MASK, `KEEP_CNT)  // Move the first byte to the METRIC CB for synchro
   0x8d000810, //  15('h00015): MOV(`R(ZR_CODEWORD+0x000,0), `OUT(RS_D))  // Move the rest of the CW bytes to RSD
   0x6c148000, //  16('h00016): SET_IO(`SLVIN, `OUT(ILV0))
   0x40c20000, //  17('h00017): JUMP(12)  // END_FOREVER
   // Code block 3 memory
   // Move metrics from METRIC FIFO to the RS Decoder
   0x6e008000, //   0('h00018): SET_IO(`SLVIN, `NULL_DST)
   0x80000001, //   1('h00019): MOV(1)  // Move the first byte (which is for synchro) to NULL
   0x6c11c011, //   2('h0001a): SET_IO(`IN(RSDEC_MET), `OUT(RSDEC_MET))
   0x80000810, //   3('h0001b): MOV(`R(ZR_CODEWORD+0x000,0))  // Move N bytes from metric FIFO to RSD metric
   0x40020000, //   4('h0001c): JUMP(0)  // Restart
   // Code block 4 memory
   // Moves correct bytes from the reed solomon to the descrambler
   0x89000811, //   0('h0001d): MOV(`R(ZR_CODEWORD+0x001,0), `IN(RS_D))  // Move K bytes from RSD to the scrambler
   0x40020000, //   1('h0001e): JUMP(0)  // Restart
   // Code block 5 memory
   // Deframe the mux-frame
   0x6c0ad007, //   0('h0001f): SET_IO(`IN(FP7), `INPUT_FLAG, `OUT(CRC0_D))
   0xce600001, //   1('h00020): MOV(1, `OUT(FP6), `KEEP_MASK, `KEEP_CNT)
   0xce60081c, //   2('h00021): MOV(`R(ZR_OHRATE+0x000,0), `OUT(FP6), `KEEP_MASK, `KEEP_CNT)  // OH1RATE -> OH channel, clear CRCFL
   0x6c0ac00e, //   3('h00022): SET_IO(`IN(SCR_D), `OUT(CRC0_D))
   0x8f622c1e, //   4('h00023): MOV(`R(ZR_OHRATE+0x002,1), `OUT(TCLAYER), `KEEP_MASK, `FLAG_MODE(FLAG_MODE_AND), `FLAG_MASK(4'h2), `APPLY_MODE(APPLY_MODE_ALL))
   0x80022c14, //   5('h00024): MOV(`R(ZR_VBC_SIZE+0x000,1), `FLAG_MODE(FLAG_MODE_AND), `FLAG_MASK(4'h2), `APPLY_MODE(APPLY_MODE_ALL))
   0x400c081b, //   6('h00025): JUMP(0, `REPEAT(`R(ZR_FRAMING+0x003,0)), `KEEP_CNT)  // END_WHILE_CNT_LT(`R(ZR_FRAMING+0x003,0)), `KEEP_CNT)
   0x40ba081a, //   7('h00026): JUMP(11, `IFCNTLT(`R(ZR_FRAMING+0x002,0)))  // WHILE_CNT_LT(`R(ZR_FRAMING+0x002,0)))
   0x41120000, //   8('h00027): JUMP(17)
   0x40b8081a, //   9('h00028): JUMP(11, `REPEAT(`R(ZR_FRAMING+0x002,0)))
   0x41120000, //  10('h00029): JUMP(17)
   0x6c0ad007, //  11('h0002a): SET_IO(`IN(FP7), `INPUT_FLAG, `OUT(CRC0_D))
   0xce60081d, //  12('h0002b): MOV(`R(ZR_OHRATE+0x001,0), `OUT(FP6), `KEEP_MASK, `KEEP_CNT)  // OH2RATE -> OH channel, clear CRCFL
   0x6c0ac00e, //  13('h0002c): SET_IO(`IN(SCR_D), `OUT(CRC0_D))
   0x8f622c1e, //  14('h0002d): MOV(`R(ZR_OHRATE+0x002,1), `OUT(TCLAYER), `KEEP_MASK, `FLAG_MODE(FLAG_MODE_AND), `FLAG_MASK(4'h2), `APPLY_MODE(APPLY_MODE_ALL))
   0x80022c14, //  15('h0002e): MOV(`R(ZR_VBC_SIZE+0x000,1), `FLAG_MODE(FLAG_MODE_AND), `FLAG_MASK(4'h2), `APPLY_MODE(APPLY_MODE_ALL))
   0x40920000, //  16('h0002f): JUMP(9)  // END_WHILE
   0x40020000, //  17('h00030): JUMP(0)
   // Code block 6 memory
   // Process the OH channel
   0x6e000000, //   0('h00031): SET_IO(`NULL_DST)
   0xc0000001, //   1('h00032): MOV(1, `KEEP_CNT)
   0x8dc00c18, //   2('h00033): MOV(`R(ZR_FRAMING+0x000,1), `OUT(FIFO0))  // Everything else from FIFO0
   0x40020000, //   3('h00034): JUMP(0)
   // Code block 7 memory
   // Setup flags for the OH channel
   0xc0011001, //   0('h00035): MOV(1, `FLAG_MODE(FLAG_MODE_OR), `FLAG_MASK(4'h1), `APPLY_MODE(APPLY_MODE_ALL), `KEEP_CNT)
   0x20001c00, //   1('h00036): WR_REG(`DEST(ZR_R0+0x000), `WR_MODE(WR_REG_OVER), `WR_MASK(8'h01))  // Set ZR_R0 to 1 to indicate SEQP_DONE
   0x80000c18, //   2('h00037): MOV(`R(ZR_FRAMING+0x000,1))
   0x40020000, //   3('h00038): JUMP(0)
   // Program will require these registers:
   //   ZR_CODEWORD+0x000 [7:0] - FEC Codeword size
   //   ZR_CODEWORD+0x001 [7:0] - Kp = N - R
   //   ZR_FRAMING+0x000 [15:0] - Set to SEQp
   //   ZR_FRAMING+0x002 [7:0] - Parameter Tp
   //   ZR_FRAMING+0x003 [7:0] - Number of mux frmaes with ceil(Gp/Tp) OH bytes
   //   ZR_ILV_PARAMS0+0x001 [7:0] - Interleaver Block Size
   //   ZR_OHRATE+0x000 [7:0] - ceil(Gp/Tp)
   //   ZR_OHRATE+0x001 [7:0] - floor(Gp/Tp)
   //   ZR_OHRATE+0x002 [15:0] - ceil(Gp/Tp)
   //   ZR_PMS_SIZE+0x000 [15:0] - Set to number of bytes to transfer this symbol
   //   ZR_R8+0x000 [15:0] - Set to D - floor(D/I) - 1
   //   ZR_VBC_SIZE+0x000 [15:0] - BC1 size = Bp1
   // Code block 2 will modify these registers:
   //   ZR_ILV_FULLNESS0+0x000 [15:0] - Reset fullness to 0 after each iblock
   //   ZR_ILV_MAX_FULLNESS0+0x000 [7:0] -
   //   ZR_ILV_MAX_FULLNESS0+0x001 [7:0] -
   //   ZR_ILV_MAX_FULLNESS0+0x002 [15:0] - Set MAX_FULLNESS to 0x3FFFF
   //   ZR_ILV_MIN_FULLNESS0+0x000 [15:0] -
   //   ZR_ILV_MIN_FULLNESS0+0x002 [15:0] - Set MIN_FULLNESS to 0
   // Code block 7 will modify these registers:
   //   ZR_R0+0x000 [7:0] - SEQP Done
   0
};
#endif

#else
// MicroCode that save RxBytyes to FIfo3.
int fci_prog_rx_vdsl2_bc0_lp0[] =
{
   0x05002, // ID.bc.lp.v
   /*
   */
   0x000000ff, // UPROC_ENA
   0x0000,   3, 0x00001a00, 0x10000000, 0x001a0000, 0x00000000, 0x00000000,  // Code block 0 base, size, STATE0-4
   0x0003,   3, 0x00000000, 0x70000000, 0x00000000, 0x08000000, 0x00000000,  // Code block 1 base, size, STATE0-4
   0x0006,  18, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 2 base, size, STATE0-4
   0x0018,   5, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 3 base, size, STATE0-4
   0x001d,   2, 0x00000000, 0x20000000, 0x00000000, 0x00004000, 0x00000000,  // Code block 4 base, size, STATE0-4
   0x001f,  22, 0x00000e00, 0x10000000, 0x000e0000, 0x00000000, 0x00000000,  // Code block 5 base, size, STATE0-4
   0x0035,   4, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 6 base, size, STATE0-4
   0x0039,   4, 0x00000000, 0x50000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 7 base, size, STATE0-4
   0x0000,   0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 8 base, size, STATE0-4
   0x0000,   0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 9 base, size, STATE0-4
   0x06000044, // FLAG_DATA 0
   0x00000656, // FLAG_DATA 1
   61, // Total code length
   // Code block 0 memory
   // Moves bytes from the DTB to the DILV, counting PMS_SIZE before stopping
   0x8c200e3c, //   0('h00000): MOV(`R(ZR_PMS_SIZE+0x000,1), `OUT(FP2))  // Move P bytes to DILV
   0x00004000, //   1('h00001): WAIT_EVENT(WAIT_STOP)  // wait for a stop
   0x40020000, //   2('h00002): JUMP(0)  // Restart
   // Code block 1 memory
   // Pass DTB read-flags into DTB
   0xa0014e3c, //   0('h00003): MOV(`R(ZR_PMS_SIZE+0x000,1), `FLAG_MODE(FLAG_MODE_OR), `FLAG_MASK(4'h4), `APPLY_MODE(APPLY_MODE_LAST))
   0x00004000, //   1('h00004): WAIT_EVENT(WAIT_STOP)  // wait for a stop
   0x40020000, //   2('h00005): JUMP(0)  // END_FOREVER
   // Code block 2 memory
   // Move bytes into and out of the DILV, one cw at a time
   0x30000cac, //   0('h00006): WR_REG(`DEST(ZR_ILV_MIN_FULLNESS0+0x000), `ACCESS_MODE(WR_REG_16), `WR_MODE(WR_REG_OVER), `WR_MASK(16'h  0000))
   0x30000cae, //   1('h00007): WR_REG(`DEST(ZR_ILV_MIN_FULLNESS0+0x002), `ACCESS_MODE(WR_REG_16), `WR_MODE(WR_REG_OVER), `WR_MASK(16'h  0000))
   0x200ffca9, //   2('h00008): WR_REG(`DEST(ZR_ILV_MAX_FULLNESS0+0x001), `WR_MODE(WR_REG_OVER), `WR_MASK(8'hff))
   0x200ffca8, //   3('h00009): WR_REG(`DEST(ZR_ILV_MAX_FULLNESS0+0x000), `WR_MODE(WR_REG_OVER), `WR_MASK(8'hff))
   0x30003caa, //   4('h0000a): WR_REG(`DEST(ZR_ILV_MAX_FULLNESS0+0x002), `ACCESS_MODE(WR_REG_16), `WR_MODE(WR_REG_OVER), `WR_MASK(16'h  0003))
   0x409a089d, //   5('h0000b): JUMP(9, `IFCNTLT(`R(ZR_ILV_PARAMS0+0x001,0)))  // WHILE_CNT_LT(`R(ZR_ILV_PARAMS0+0x001,0)))
   0x40c20000, //   6('h0000c): JUMP(12)
   0x4098089d, //   7('h0000d): JUMP(9, `REPEAT(`R(ZR_ILV_PARAMS0+0x001,0)))
   0x40c20000, //   8('h0000e): JUMP(12)
   0x8d400c08, //   9('h0000f): MOV(`R(ZR_R8+0x000,1), `OUT(ILV0))
   0x30000cb0, //  10('h00010): WR_REG(`DEST(ZR_ILV_FULLNESS0+0x000), `ACCESS_MODE(WR_REG_16), `WR_MODE(WR_REG_OVER), `WR_MASK(16'h  0000))
   0x40720000, //  11('h00011): JUMP(7)  // END_WHILE
   0x80000810, //  12('h00012): MOV(`R(ZR_CODEWORD+0x000,0))  // move CW to ilv
   0x6c10c014, //  13('h00013): SET_IO(`IN(ILV0), `OUT(RS_D))
   0xce300001, //  14('h00014): MOV(1, `OUT(FP3), `KEEP_MASK, `KEEP_CNT)  // Move the first byte to the METRIC CB for synchro
   0x8d000810, //  15('h00015): MOV(`R(ZR_CODEWORD+0x000,0), `OUT(RS_D))  // Move the rest of the CW bytes to RSD
   0x6c148000, //  16('h00016): SET_IO(`SLVIN, `OUT(ILV0))
   0x40c20000, //  17('h00017): JUMP(12)  // END_FOREVER
   // Code block 3 memory
   // Move metrics from METRIC FIFO to the RS Decoder
   0x6e008000, //   0('h00018): SET_IO(`SLVIN, `NULL_DST)
   0x80000001, //   1('h00019): MOV(1)  // Move the first byte (which is for synchro) to NULL
   0x6c11c011, //   2('h0001a): SET_IO(`IN(RSDEC_MET), `OUT(RSDEC_MET))
   0x80000810, //   3('h0001b): MOV(`R(ZR_CODEWORD+0x000,0))  // Move N bytes from metric FIFO to RSD metric
   0x40020000, //   4('h0001c): JUMP(0)  // Restart
   // Code block 4 memory
   // Moves correct bytes from the reed solomon to the descrambler
   0x89000811, //   0('h0001d): MOV(`R(ZR_CODEWORD+0x001,0), `IN(RS_D))  // Move K bytes from RSD to the scrambler
   0x40020000, //   1('h0001e): JUMP(0)  // Restart
   // Code block 5 memory
   // Deframe the mux-frame
   0x6c0ad007, //   0('h0001f): SET_IO(`IN(FP7), `INPUT_FLAG, `OUT(CRC0_D))
#ifdef FIFO3_FOR_RETX
   0x6c0ad007, //   1('h00020): SET_IO(`OUT(FIFO3), `KEEP_MASK)
#else
   0x6d1f0000, //   1('h00020): SET_IO(`OUT(FIFO3), `KEEP_MASK)
#endif
   0xce600001, //   2('h00021): MOV(1, `OUT(FP6), `KEEP_MASK, `KEEP_CNT)
   0xce60081c, //   3('h00022): MOV(`R(ZR_OHRATE+0x000,0), `OUT(FP6), `KEEP_MASK, `KEEP_CNT)  // OH1RATE -> OH channel, clear CRCFL
   0x6c0ac00e, //   4('h00023): SET_IO(`IN(SCR_D), `OUT(CRC0_D))
#ifdef FIFO3_FOR_RETX
   0x6c0ac00e, //   5('h00024): SET_IO(`OUT(FIFO3), `KEEP_MASK)
#else
   0x6d1f0000, //   5('h00024): SET_IO(`OUT(FIFO3), `KEEP_MASK)
#endif
   0x8f622c1e, //   6('h00025): MOV(`R(ZR_OHRATE+0x002,1), `OUT(TCLAYER), `KEEP_MASK, `FLAG_MODE(FLAG_MODE_AND), `FLAG_MASK(4'h2), `APPLY_MODE(APPLY_MODE_ALL))
   0x80022c14, //   7('h00026): MOV(`R(ZR_VBC_SIZE+0x000,1), `FLAG_MODE(FLAG_MODE_AND), `FLAG_MASK(4'h2), `APPLY_MODE(APPLY_MODE_ALL))
   0x400c081b, //   8('h00027): JUMP(0, `REPEAT(`R(ZR_FRAMING+0x003,0)), `KEEP_CNT)  // END_WHILE_CNT_LT(`R(ZR_FRAMING+0x003,0)), `KEEP_CNT)
   0x40da081a, //   9('h00028): JUMP(13, `IFCNTLT(`R(ZR_FRAMING+0x002,0)))  // WHILE_CNT_LT(`R(ZR_FRAMING+0x002,0)))
   0x41520000, //  10('h00029): JUMP(21)
   0x40d8081a, //  11('h0002a): JUMP(13, `REPEAT(`R(ZR_FRAMING+0x002,0)))
   0x41520000, //  12('h0002b): JUMP(21)
   0x6c0ad007, //  13('h0002c): SET_IO(`IN(FP7), `INPUT_FLAG, `OUT(CRC0_D))
#ifdef FIFO3_FOR_RETX
   0x6c0ad007, //  14('h0002d): SET_IO(`OUT(FIFO3), `KEEP_MASK)
#else
   0x6d1f0000, //  14('h0002d): SET_IO(`OUT(FIFO3), `KEEP_MASK)
#endif
   0xce60081d, //  15('h0002e): MOV(`R(ZR_OHRATE+0x001,0), `OUT(FP6), `KEEP_MASK, `KEEP_CNT)  // OH2RATE -> OH channel, clear CRCFL
   0x6c0ac00e, //  16('h0002f): SET_IO(`IN(SCR_D), `OUT(CRC0_D))
#ifdef FIFO3_FOR_RETX
   0x6c0ac00e, //  17('h00030): SET_IO(`OUT(FIFO3), `KEEP_MASK)
#else
   0x6d1f0000, //  17('h00030): SET_IO(`OUT(FIFO3), `KEEP_MASK)
#endif
   0x8f622c1e, //  18('h00031): MOV(`R(ZR_OHRATE+0x002,1), `OUT(TCLAYER), `KEEP_MASK, `FLAG_MODE(FLAG_MODE_AND), `FLAG_MASK(4'h2), `APPLY_MODE(APPLY_MODE_ALL))
   0x80022c14, //  19('h00032): MOV(`R(ZR_VBC_SIZE+0x000,1), `FLAG_MODE(FLAG_MODE_AND), `FLAG_MASK(4'h2), `APPLY_MODE(APPLY_MODE_ALL))
   0x40b20000, //  20('h00033): JUMP(11)  // END_WHILE
   0x40020000, //  21('h00034): JUMP(0)
   // Code block 6 memory
   // Process the OH channel
   0x6e000000, //   0('h00035): SET_IO(`NULL_DST)
   0xc0000001, //   1('h00036): MOV(1, `KEEP_CNT)
   0x8dc00c18, //   2('h00037): MOV(`R(ZR_FRAMING+0x000,1), `OUT(FIFO0))  // Everything else from FIFO0
   0x40020000, //   3('h00038): JUMP(0)
   // Code block 7 memory
   // Setup flags for the OH channel
   0xc0011001, //   0('h00039): MOV(1, `FLAG_MODE(FLAG_MODE_OR), `FLAG_MASK(4'h1), `APPLY_MODE(APPLY_MODE_ALL), `KEEP_CNT)
   0x20001c00, //   1('h0003a): WR_REG(`DEST(ZR_R0+0x000), `WR_MODE(WR_REG_OVER), `WR_MASK(8'h01))  // Set ZR_R0 to 1 to indicate SEQP_DONE
   0x80000c18, //   2('h0003b): MOV(`R(ZR_FRAMING+0x000,1))
   0x40020000, //   3('h0003c): JUMP(0)
   // Program will require these registers:
   //   ZR_CODEWORD+0x000 [7:0] - FEC Codeword size
   //   ZR_CODEWORD+0x001 [7:0] - Kp = N - R
   //   ZR_FRAMING+0x000 [15:0] - Set to SEQp
   //   ZR_FRAMING+0x002 [7:0] - Parameter Tp
   //   ZR_FRAMING+0x003 [7:0] - Number of mux frmaes with ceil(Gp/Tp) OH bytes
   //   ZR_ILV_PARAMS0+0x001 [7:0] - Interleaver Block Size
   //   ZR_OHRATE+0x000 [7:0] - ceil(Gp/Tp)
   //   ZR_OHRATE+0x001 [7:0] - floor(Gp/Tp)
   //   ZR_OHRATE+0x002 [15:0] - ceil(Gp/Tp)
   //   ZR_PMS_SIZE+0x000 [15:0] - Set to number of bytes to transfer this symbol
   //   ZR_R8+0x000 [15:0] - Set to D - floor(D/I) - 1
   //   ZR_VBC_SIZE+0x000 [15:0] - BC1 size = Bp1
   // Code block 2 will modify these registers:
   //   ZR_ILV_FULLNESS0+0x000 [15:0] - Reset fullness to 0 after each iblock
   //   ZR_ILV_MAX_FULLNESS0+0x000 [7:0] -
   //   ZR_ILV_MAX_FULLNESS0+0x001 [7:0] -
   //   ZR_ILV_MAX_FULLNESS0+0x002 [15:0] - Set MAX_FULLNESS to 0x3FFFF
   //   ZR_ILV_MIN_FULLNESS0+0x000 [15:0] -
   //   ZR_ILV_MIN_FULLNESS0+0x002 [15:0] - Set MIN_FULLNESS to 0
   // Code block 7 will modify these registers:
   //   ZR_R0+0x000 [7:0] - SEQP Done
   0
}; //int fci_prog_rx_vdsl2_bc0_lp0[] = {
#endif
DATA_MAP_END;

DATA_MAP_FCI_RX_PORT1_LP0_UCODE
int fci_prog_rx_vdsl2_bc1_lp0[] =
{
   0x5101, // ID.V.v
   /*
   */
   0x000000ff, // UPROC_ENA
   0x0000,   3, 0x00001a00, 0x10000000, 0x001a0000, 0x00000000, 0x00000000,  // Code block 0 base, size, STATE0-4
   0x0003,   3, 0x00000000, 0x70000000, 0x00000000, 0x08000000, 0x00000000,  // Code block 1 base, size, STATE0-4
   0x0006,  18, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 2 base, size, STATE0-4
   0x0018,   5, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 3 base, size, STATE0-4
   0x001d,   2, 0x00000000, 0x20000000, 0x00000000, 0x00004000, 0x00000000,  // Code block 4 base, size, STATE0-4
   0x001f,  18, 0x00000e00, 0x10000000, 0x000e0000, 0x00000000, 0x00000000,  // Code block 5 base, size, STATE0-4
   0x0031,   4, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 6 base, size, STATE0-4
   0x0035,   4, 0x00000000, 0x50000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 7 base, size, STATE0-4
   0x0000,   0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 8 base, size, STATE0-4
   0x0000,   0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 9 base, size, STATE0-4
   0x06000044, // FLAG_DATA 0
   0x00000656, // FLAG_DATA 1
   57, // Total code length
   // Code block 0 memory
   // Moves bytes from the DTB to the DILV, counting PMS_SIZE before stopping
   0x8c200e3c, //   0('h00000): MOV(`R(ZR_PMS_SIZE+0x000,1), `OUT(FP2))  // Move P bytes to DILV
   0x00004000, //   1('h00001): WAIT_EVENT(WAIT_STOP)  // wait for a stop
   0x40020000, //   2('h00002): JUMP(0)  // Restart
   // Code block 1 memory
   // Pass DTB read-flags into DTB
   0xa0014e3c, //   0('h00003): MOV(`R(ZR_PMS_SIZE+0x000,1), `FLAG_MODE(FLAG_MODE_OR), `FLAG_MASK(4'h4), `APPLY_MODE(APPLY_MODE_LAST))
   0x00004000, //   1('h00004): WAIT_EVENT(WAIT_STOP)  // wait for a stop
   0x40020000, //   2('h00005): JUMP(0)  // END_FOREVER
   // Code block 2 memory
   // Move bytes into and out of the DILV, one cw at a time
   0x30000cac, //   0('h00006): WR_REG(`DEST(ZR_ILV_MIN_FULLNESS0+0x000), `ACCESS_MODE(WR_REG_16), `WR_MODE(WR_REG_OVER), `WR_MASK(16'h  0000))
   0x30000cae, //   1('h00007): WR_REG(`DEST(ZR_ILV_MIN_FULLNESS0+0x002), `ACCESS_MODE(WR_REG_16), `WR_MODE(WR_REG_OVER), `WR_MASK(16'h  0000))
   0x200ffca9, //   2('h00008): WR_REG(`DEST(ZR_ILV_MAX_FULLNESS0+0x001), `WR_MODE(WR_REG_OVER), `WR_MASK(8'hff))
   0x200ffca8, //   3('h00009): WR_REG(`DEST(ZR_ILV_MAX_FULLNESS0+0x000), `WR_MODE(WR_REG_OVER), `WR_MASK(8'hff))
   0x30003caa, //   4('h0000a): WR_REG(`DEST(ZR_ILV_MAX_FULLNESS0+0x002), `ACCESS_MODE(WR_REG_16), `WR_MODE(WR_REG_OVER), `WR_MASK(16'h  0003))
   0x409a089d, //   5('h0000b): JUMP(9, `IFCNTLT(`R(ZR_ILV_PARAMS0+0x001,0)))  // WHILE_CNT_LT(`R(ZR_ILV_PARAMS0+0x001,0)))
   0x40c20000, //   6('h0000c): JUMP(12)
   0x4098089d, //   7('h0000d): JUMP(9, `REPEAT(`R(ZR_ILV_PARAMS0+0x001,0)))
   0x40c20000, //   8('h0000e): JUMP(12)
   0x8d400c08, //   9('h0000f): MOV(`R(ZR_R8+0x000,1), `OUT(ILV0))
   0x30000cb0, //  10('h00010): WR_REG(`DEST(ZR_ILV_FULLNESS0+0x000), `ACCESS_MODE(WR_REG_16), `WR_MODE(WR_REG_OVER), `WR_MASK(16'h  0000))
   0x40720000, //  11('h00011): JUMP(7)  // END_WHILE
   0x80000810, //  12('h00012): MOV(`R(ZR_CODEWORD+0x000,0))  // move CW to ilv
   0x6c10c014, //  13('h00013): SET_IO(`IN(ILV0), `OUT(RS_D))
   0xce300001, //  14('h00014): MOV(1, `OUT(FP3), `KEEP_MASK, `KEEP_CNT)  // Move the first byte to the METRIC CB for synchro
   0x8d000810, //  15('h00015): MOV(`R(ZR_CODEWORD+0x000,0), `OUT(RS_D))  // Move the rest of the CW bytes to RSD
   0x6c148000, //  16('h00016): SET_IO(`SLVIN, `OUT(ILV0))
   0x40c20000, //  17('h00017): JUMP(12)  // END_FOREVER
   // Code block 3 memory
   // Move metrics from METRIC FIFO to the RS Decoder
   0x6e008000, //   0('h00018): SET_IO(`SLVIN, `NULL_DST)
   0x80000001, //   1('h00019): MOV(1)  // Move the first byte (which is for synchro) to NULL
   0x6c11c011, //   2('h0001a): SET_IO(`IN(RSDEC_MET), `OUT(RSDEC_MET))
   0x80000810, //   3('h0001b): MOV(`R(ZR_CODEWORD+0x000,0))  // Move N bytes from metric FIFO to RSD metric
   0x40020000, //   4('h0001c): JUMP(0)  // Restart
   // Code block 4 memory
   // Moves correct bytes from the reed solomon to the descrambler
   0x89000811, //   0('h0001d): MOV(`R(ZR_CODEWORD+0x001,0), `IN(RS_D))  // Move K bytes from RSD to the scrambler
   0x40020000, //   1('h0001e): JUMP(0)  // Restart
   // Code block 5 memory
   // Deframe the mux-frame
   0x6c0ad007, //   0('h0001f): SET_IO(`IN(FP7), `INPUT_FLAG, `OUT(CRC0_D))
   0xce600001, //   1('h00020): MOV(1, `OUT(FP6), `KEEP_MASK, `KEEP_CNT)
   0xce60081c, //   2('h00021): MOV(`R(ZR_OHRATE+0x000,0), `OUT(FP6), `KEEP_MASK, `KEEP_CNT)  // OH1RATE -> OH channel, clear CRCFL
   0x6c0ac00e, //   3('h00022): SET_IO(`IN(SCR_D), `OUT(CRC0_D))
   0x8f612c1e, //   4('h00023): MOV(`R(ZR_OHRATE+0x000,1), `OUT(TCLAYER), `KEEP_MASK, `FLAG_MODE(FLAG_MODE_OR), `FLAG_MASK(4'h2), `APPLY_MODE(APPLY_MODE_ALL))
   0x80012c14, //   5('h00024): MOV(`R(ZR_VBC_SIZE+0x002,1), `FLAG_MODE(FLAG_MODE_OR), `FLAG_MASK(4'h2), `APPLY_MODE(APPLY_MODE_ALL))
   0x400c081b, //   6('h00025): JUMP(0, `REPEAT(`R(ZR_FRAMING+0x003,0)), `KEEP_CNT)  // END_WHILE_CNT_LT(`R(ZR_FRAMING+0x003,0)), `KEEP_CNT)
   0x40ba081a, //   7('h00026): JUMP(11, `IFCNTLT(`R(ZR_FRAMING+0x002,0)))  // WHILE_CNT_LT(`R(ZR_FRAMING+0x002,0)))
   0x41120000, //   8('h00027): JUMP(17)
   0x40b8081a, //   9('h00028): JUMP(11, `REPEAT(`R(ZR_FRAMING+0x002,0)))
   0x41120000, //  10('h00029): JUMP(17)
   0x6c0ad007, //  11('h0002a): SET_IO(`IN(FP7), `INPUT_FLAG, `OUT(CRC0_D))
   0xce60081d, //  12('h0002b): MOV(`R(ZR_OHRATE+0x001,0), `OUT(FP6), `KEEP_MASK, `KEEP_CNT)  // OH2RATE -> OH channel, clear CRCFL
   0x6c0ac00e, //  13('h0002c): SET_IO(`IN(SCR_D), `OUT(CRC0_D))
   0x8f612c1e, //  14('h0002d): MOV(`R(ZR_OHRATE+0x002,1), `OUT(TCLAYER), `KEEP_MASK, `FLAG_MODE(FLAG_MODE_OR), `FLAG_MASK(4'h2), `APPLY_MODE(APPLY_MODE_ALL))
   0x80012c14, //  15('h0002e): MOV(`R(ZR_VBC_SIZE+0x000,1), `FLAG_MODE(FLAG_MODE_OR), `FLAG_MASK(4'h2), `APPLY_MODE(APPLY_MODE_ALL))
   0x40920000, //  16('h0002f): JUMP(9)  // END_WHILE
   0x40020000, //  17('h00030): JUMP(0)
   // Code block 6 memory
   // Process the OH channel
   0x6e000000, //   0('h00031): SET_IO(`NULL_DST)
   0xc0000001, //   1('h00032): MOV(1, `KEEP_CNT)
   0x8dc00c18, //   2('h00033): MOV(`R(ZR_FRAMING+0x000,1), `OUT(FIFO0))  // Everything else from FIFO0
   0x40020000, //   3('h00034): JUMP(0)
   // Code block 7 memory
   // Setup flags for the OH channel
   0xc0011001, //   0('h00035): MOV(1, `FLAG_MODE(FLAG_MODE_OR), `FLAG_MASK(4'h1), `APPLY_MODE(APPLY_MODE_ALL), `KEEP_CNT)
   0x20001c00, //   1('h00036): WR_REG(`DEST(ZR_R0+0x000), `WR_MODE(WR_REG_OVER), `WR_MASK(8'h01))  // Set ZR_R0 to 1 to indicate SEQP_DONE
   0x80000c18, //   2('h00037): MOV(`R(ZR_FRAMING+0x000,1))
   0x40020000, //   3('h00038): JUMP(0)
   // Program will require these registers:
   //   ZR_CODEWORD+0x000 [7:0] - FEC Codeword size
   //   ZR_CODEWORD+0x001 [7:0] - Kp = N - R
   //   ZR_FRAMING+0x000 [15:0] - Set to SEQp
   //   ZR_FRAMING+0x002 [7:0] - Parameter Tp
   //   ZR_FRAMING+0x003 [7:0] - Number of mux frmaes with ceil(Gp/Tp) OH bytes
   //   ZR_ILV_PARAMS0+0x001 [7:0] - Interleaver Block Size
   //   ZR_OHRATE+0x000 [7:0] - ceil(Gp/Tp)
   //   ZR_OHRATE+0x001 [7:0] - floor(Gp/Tp)
   //   ZR_OHRATE+0x002 [15:0] - ceil(Gp/Tp)
   //   ZR_PMS_SIZE+0x000 [15:0] - Set to number of bytes to transfer this symbol
   //   ZR_R8+0x000 [15:0] - Set to D - floor(D/I) - 1
   //   ZR_VBC_SIZE+0x002 [15:0] - BC1 size = Bp1
   // Code block 2 will modify these registers:
   //   ZR_ILV_FULLNESS0+0x000 [15:0] - Reset fullness to 0 after each iblock
   //   ZR_ILV_MAX_FULLNESS0+0x000 [7:0] -
   //   ZR_ILV_MAX_FULLNESS0+0x001 [7:0] -
   //   ZR_ILV_MAX_FULLNESS0+0x002 [15:0] - Set MAX_FULLNESS to 0x3FFFF
   //   ZR_ILV_MIN_FULLNESS0+0x000 [15:0] -
   //   ZR_ILV_MIN_FULLNESS0+0x002 [15:0] - Set MIN_FULLNESS to 0
   // Code block 7 will modify these registers:
   //   ZR_R0+0x000 [7:0] - SEQP Done
   0
};//int fci_prog_rx_vdsl2_bc1_lp0[] = {

DATA_MAP_END; //DATA_MAP_FCI_RX_PORT1_LP0_UCODE

DATA_MAP_FCI_TX_LP1_UCODE
int fci_prog_tx_vdsl2_bc0_lp1[] =
{
   0x04011, // ID.bc.lp.v
   /*
   */
   0x0000003f, // UPROC_ENA
   0x0000,   5, 0x00000000, 0x20000000, 0x00000000, 0x00000002, 0x00000000,  // Code block 0 base, size, STATE0-4
   0x0005,   3, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 1 base, size, STATE0-4
   0x0008,   3, 0x00000000, 0x20000000, 0x00000000, 0x04000000, 0x00000000,  // Code block 2 base, size, STATE0-4
   0x000b,  14, 0x00000000, 0x20000000, 0x00000000, 0x00004400, 0x00000000,  // Code block 3 base, size, STATE0-4
   0x0019,  15, 0x00000000, 0x50000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 4 base, size, STATE0-4
   0x0028,   9, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 5 base, size, STATE0-4
   0x0000,   0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 6 base, size, STATE0-4
   0x0000,   0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 7 base, size, STATE0-4
   0x0000,   0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 8 base, size, STATE0-4
   0x0000,   0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 9 base, size, STATE0-4
   0x04000004, // FLAG_DATA 0
   0x00000050, // FLAG_DATA 1
   49, // Total code length
   // Code block 0 memory
   0x6d10c00e, //   0('h00000): SET_IO(`IN(SCR_D), `OUT(RS_D), `KEEP_MASK)
   0x80000811, //   1('h00001): MOV(`R(ZT_CODEWORD+0x001,0))
   0x6c01c010, //   2('h00002): SET_IO(`IN(RS_D), `OUT(FP1))
   0x80000812, //   3('h00003): MOV(`R(ZT_CODEWORD+0x002,0))
   0x40020000, //   4('h00004): JUMP(0)  // END_FOREVER
   // Code block 1 memory
   0x8d400dfa, //   0('h00005): MOV(`R(ZT_PMS_SIZE+0x002,1), `OUT(ILV0))
   0x00004000, //   1('h00006): WAIT_EVENT(WAIT_STOP)
   0x40020000, //   2('h00007): JUMP(0)  // END_FOREVER
   // Code block 2 memory
   0xa9411dfa, //   0('h00008): MOV(`R(ZT_PMS_SIZE+0x002,1), `IN(ILV0), `FLAG_MODE(FLAG_MODE_OR), `FLAG_MASK(4'h1), `APPLY_MODE(APPLY_MODE_LAST))
   0x00004000, //   1('h00009): WAIT_EVENT(WAIT_STOP)
   0x40020000, //   2('h0000a): JUMP(0)  // END_FOREVER
   // Code block 3 memory
   0x6d1f0000, //   0('h0000b): SET_IO(`OUT(FIFO3), `KEEP_MASK)
   0xc850081c, //   1('h0000c): MOV(`R(ZT_OHRATE+0x000,0), `IN(FP5), `KEEP_CNT)
   0x89600c1e, //   2('h0000d): MOV(`R(ZT_OHRATE+0x002,1), `IN(TCLAYER))
   0x80000c14, //   3('h0000e): MOV(`R(ZT_VBC_SIZE+0x000,1))
   0x401c081b, //   4('h0000f): JUMP(1, `REPEAT(`R(ZT_FRAMING+0x003,0)), `KEEP_CNT)  // END_WHILE_CNT_LT(`R(ZT_FRAMING+0x003,0)), `KEEP_CNT)
   0x409a081a, //   5('h00010): JUMP(9, `IFCNTLT(`R(ZT_FRAMING+0x002,0)))  // WHILE_CNT_LT(`R(ZT_FRAMING+0x002,0)))
   0x40d20000, //   6('h00011): JUMP(13)
   0x4098081a, //   7('h00012): JUMP(9, `REPEAT(`R(ZT_FRAMING+0x002,0)))
   0x40d20000, //   8('h00013): JUMP(13)
   0xc850081d, //   9('h00014): MOV(`R(ZT_OHRATE+0x001,0), `IN(FP5), `KEEP_CNT)
   0x89600c1e, //  10('h00015): MOV(`R(ZT_OHRATE+0x002,1), `IN(TCLAYER))
   0x80000c14, //  11('h00016): MOV(`R(ZT_VBC_SIZE+0x000,1))
   0x40720000, //  12('h00017): JUMP(7)  // END_WHILE
   0x40120000, //  13('h00018): JUMP(1)  // END_FOREVER
   // Code block 4 memory
   0x6e000000, //   0('h00019): SET_IO(`NULL_DST)
   0xc000081c, //   1('h0001a): MOV(`R(ZT_OHRATE+0x000,0), `KEEP_CNT)
   0x8d622c1e, //   2('h0001b): MOV(`R(ZT_OHRATE+0x002,1), `OUT(TCLAYER), `FLAG_MODE(FLAG_MODE_AND), `FLAG_MASK(4'h2), `APPLY_MODE(APPLY_MODE_ALL))
   0x8d622c14, //   3('h0001c): MOV(`R(ZT_VBC_SIZE+0x000,1), `OUT(TCLAYER), `FLAG_MODE(FLAG_MODE_AND), `FLAG_MASK(4'h2), `APPLY_MODE(APPLY_MODE_ALL))
   0x400c081b, //   4('h0001d): JUMP(0, `REPEAT(`R(ZT_FRAMING+0x003,0)), `KEEP_CNT)  // END_WHILE_CNT_LT(`R(ZT_FRAMING+0x003,0)), `KEEP_CNT)
   0x409a081a, //   5('h0001e): JUMP(9, `IFCNTLT(`R(ZT_FRAMING+0x002,0)))  // WHILE_CNT_LT(`R(ZT_FRAMING+0x002,0)))
   0x40e20000, //   6('h0001f): JUMP(14)
   0x4098081a, //   7('h00020): JUMP(9, `REPEAT(`R(ZT_FRAMING+0x002,0)))
   0x40e20000, //   8('h00021): JUMP(14)
   0x6e000000, //   9('h00022): SET_IO(`NULL_DST)
   0xc000081d, //  10('h00023): MOV(`R(ZT_OHRATE+0x001,0), `KEEP_CNT)
   0x8d622c1e, //  11('h00024): MOV(`R(ZT_OHRATE+0x002,1), `OUT(TCLAYER), `FLAG_MODE(FLAG_MODE_AND), `FLAG_MASK(4'h2), `APPLY_MODE(APPLY_MODE_ALL))
   0x8d622c14, //  12('h00025): MOV(`R(ZT_VBC_SIZE+0x000,1), `OUT(TCLAYER), `FLAG_MODE(FLAG_MODE_AND), `FLAG_MASK(4'h2), `APPLY_MODE(APPLY_MODE_ALL))
   0x40720000, //  13('h00026): JUMP(7)  // END_WHILE
   0x40020000, //  14('h00027): JUMP(0)  // END_FOREVER
   // Code block 5 memory
   0x00002000, //   0('h00028): WAIT_EVENT(WAIT_OUT)
   0x403e0808, //   1('h00029): JUMP(3, `IFCNTLT(`R(ZT_R8+0x000,0)), `KEEP_CNT)  // IF_CNT_LT(`R(ZT_R8+0x000,0)))
   0x40520000, //   2('h0002a): JUMP(5)
   0xc8a51001, //   3('h0002b): MOV(1, `IN(CRC0_D), `FLAG_MODE(FLAG_MODE_OR), `FLAG_MASK(4'h1), `APPLY_MODE(APPLY_MODE_ALL), `KEEP_CNT, `INVERT)
   0x40620000, //   4('h0002c): JUMP(6)  // ELSE
   0xc8a11001, //   5('h0002d): MOV(1, `IN(CRC0_D), `FLAG_MODE(FLAG_MODE_OR), `FLAG_MASK(4'h1), `APPLY_MODE(APPLY_MODE_ALL), `KEEP_CNT)
   0x20001c00, //   6('h0002e): WR_REG(`DEST(ZT_R0+0x000), `WR_MODE(WR_REG_OVER), `WR_MASK(8'h01))
   0x89d00c18, //   7('h0002f): MOV(`R(ZT_FRAMING+0x000,1), `IN(FIFO1))
   0x40020000, //   8('h00030): JUMP(0)
   // Program will require these registers:
   //   ZT_CODEWORD+0x001 [7:0] - ?? (MOV byte count)
   //   ZT_CODEWORD+0x002 [7:0] - ?? (MOV byte count)
   //   ZT_FRAMING+0x000 [15:0] - ?? (MOV byte count)
   //   ZT_FRAMING+0x002 [7:0] - ?? (JUMP repeat count)
   //   ZT_FRAMING+0x003 [7:0] - ?? (JUMP repeat count)
   //   ZT_OHRATE+0x000 [7:0] - ?? (MOV byte count)
   //   ZT_OHRATE+0x001 [7:0] - ?? (MOV byte count)
   //   ZT_OHRATE+0x002 [15:0] - ?? (MOV byte count)
   //   ZT_PMS_SIZE+0x002 [15:0] - ?? (MOV byte count)
   //   ZT_R8+0x000 [7:0] - ?? (JUMP repeat count)
   //   ZT_VBC_SIZE+0x000 [15:0] - ?? (MOV byte count)
   // Code block 5 will modify these registers:
   //   ZT_R0+0x000 [7:0] -
   0
};
DATA_MAP_END;
DATA_MAP_FCI_TX_PORT1_LP1_UCODE
int fci_prog_tx_vdsl2_bc1_lp1[] =
{
   0x04111, // // ID.bc.lp.v
   /*
   */
   0x0000003f, // UPROC_ENA
   0x0000,   5, 0x00000000, 0x20000000, 0x00000000, 0x00000002, 0x00000000,  // Code block 0 base, size, STATE0-4
   0x0005,   3, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 1 base, size, STATE0-4
   0x0008,   3, 0x00000000, 0x20000000, 0x00000000, 0x04000000, 0x00000000,  // Code block 2 base, size, STATE0-4
   0x000b,  13, 0x00000000, 0x20000000, 0x00000000, 0x00004400, 0x00000000,  // Code block 3 base, size, STATE0-4
   0x0018,  15, 0x00000000, 0x50000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 4 base, size, STATE0-4
   0x0027,   9, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 5 base, size, STATE0-4
   0x0000,   0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 6 base, size, STATE0-4
   0x0000,   0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 7 base, size, STATE0-4
   0x0000,   0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 8 base, size, STATE0-4
   0x0000,   0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 9 base, size, STATE0-4
   0x04000004, // FLAG_DATA 0
   0x00000050, // FLAG_DATA 1
   48, // Total code length
   // Code block 0 memory
   0x6d10c00e, //   0('h00000): SET_IO(`IN(SCR_D), `OUT(RS_D), `KEEP_MASK)
   0x80000811, //   1('h00001): MOV(`R(ZT_CODEWORD+0x001,0))
   0x6c01c010, //   2('h00002): SET_IO(`IN(RS_D), `OUT(FP1))
   0x80000812, //   3('h00003): MOV(`R(ZT_CODEWORD+0x002,0))
   0x40020000, //   4('h00004): JUMP(0)  // END_FOREVER
   // Code block 1 memory
   0x8d400dfa, //   0('h00005): MOV(`R(ZT_PMS_SIZE+0x002,1), `OUT(ILV0))
   0x00004000, //   1('h00006): WAIT_EVENT(WAIT_STOP)
   0x40020000, //   2('h00007): JUMP(0)  // END_FOREVER
   // Code block 2 memory
   0xa9411dfa, //   0('h00008): MOV(`R(ZT_PMS_SIZE+0x002,1), `IN(ILV0), `FLAG_MODE(FLAG_MODE_OR), `FLAG_MASK(4'h1), `APPLY_MODE(APPLY_MODE_LAST))
   0x00004000, //   1('h00009): WAIT_EVENT(WAIT_STOP)
   0x40020000, //   2('h0000a): JUMP(0)  // END_FOREVER
   // Code block 3 memory
   0xc850081c, //   0('h0000b): MOV(`R(ZT_OHRATE+0x000,0), `IN(FP5), `KEEP_CNT)
   0x89600c1e, //   1('h0000c): MOV(`R(ZT_OHRATE+0x002,1), `IN(TCLAYER))
   0x80000c14, //   2('h0000d): MOV(`R(ZT_VBC_SIZE+0x000,1))
   0x400c081b, //   3('h0000e): JUMP(0, `REPEAT(`R(ZT_FRAMING+0x003,0)), `KEEP_CNT)  // END_WHILE_CNT_LT(`R(ZT_FRAMING+0x003,0)), `KEEP_CNT)
   0x408a081a, //   4('h0000f): JUMP(8, `IFCNTLT(`R(ZT_FRAMING+0x002,0)))  // WHILE_CNT_LT(`R(ZT_FRAMING+0x002,0)))
   0x40c20000, //   5('h00010): JUMP(12)
   0x4088081a, //   6('h00011): JUMP(8, `REPEAT(`R(ZT_FRAMING+0x002,0)))
   0x40c20000, //   7('h00012): JUMP(12)
   0xc850081d, //   8('h00013): MOV(`R(ZT_OHRATE+0x001,0), `IN(FP5), `KEEP_CNT)
   0x89600c1e, //   9('h00014): MOV(`R(ZT_OHRATE+0x002,1), `IN(TCLAYER))
   0x80000c14, //  10('h00015): MOV(`R(ZT_VBC_SIZE+0x000,1))
   0x40620000, //  11('h00016): JUMP(6)  // END_WHILE
   0x40020000, //  12('h00017): JUMP(0)  // END_FOREVER
   // Code block 4 memory
   0x6e000000, //   0('h00018): SET_IO(`NULL_DST)
   0xc000081c, //   1('h00019): MOV(`R(ZT_OHRATE+0x000,0), `KEEP_CNT)
   0x8d612c1e, //   2('h0001a): MOV(`R(ZT_OHRATE+0x002,1), `OUT(TCLAYER), `FLAG_MODE(FLAG_MODE_OR), `FLAG_MASK(4'h2), `APPLY_MODE(APPLY_MODE_ALL))
   0x8d612c14, //   3('h0001b): MOV(`R(ZT_VBC_SIZE+0x000,1), `OUT(TCLAYER), `FLAG_MODE(FLAG_MODE_OR), `FLAG_MASK(4'h2), `APPLY_MODE(APPLY_MODE_ALL))
   0x400c081b, //   4('h0001c): JUMP(0, `REPEAT(`R(ZT_FRAMING+0x003,0)), `KEEP_CNT)  // END_WHILE_CNT_LT(`R(ZT_FRAMING+0x003,0)), `KEEP_CNT)
   0x409a081a, //   5('h0001d): JUMP(9, `IFCNTLT(`R(ZT_FRAMING+0x002,0)))  // WHILE_CNT_LT(`R(ZT_FRAMING+0x002,0)))
   0x40e20000, //   6('h0001e): JUMP(14)
   0x4098081a, //   7('h0001f): JUMP(9, `REPEAT(`R(ZT_FRAMING+0x002,0)))
   0x40e20000, //   8('h00020): JUMP(14)
   0x6e000000, //   9('h00021): SET_IO(`NULL_DST)
   0xc000081d, //  10('h00022): MOV(`R(ZT_OHRATE+0x001,0), `KEEP_CNT)
   0x8d612c1e, //  11('h00023): MOV(`R(ZT_OHRATE+0x002,1), `OUT(TCLAYER), `FLAG_MODE(FLAG_MODE_OR), `FLAG_MASK(4'h2), `APPLY_MODE(APPLY_MODE_ALL))
   0x8d612c14, //  12('h00024): MOV(`R(ZT_VBC_SIZE+0x000,1), `OUT(TCLAYER), `FLAG_MODE(FLAG_MODE_OR), `FLAG_MASK(4'h2), `APPLY_MODE(APPLY_MODE_ALL))
   0x40720000, //  13('h00025): JUMP(7)  // END_WHILE
   0x40020000, //  14('h00026): JUMP(0)  // END_FOREVER
   // Code block 5 memory
   0x00002000, //   0('h00027): WAIT_EVENT(WAIT_OUT)
   0x403e0808, //   1('h00028): JUMP(3, `IFCNTLT(`R(ZT_R8+0x000,0)), `KEEP_CNT)  // IF_CNT_LT(`R(ZT_R8+0x000,0)))
   0x40520000, //   2('h00029): JUMP(5)
   0xc8a51001, //   3('h0002a): MOV(1, `IN(CRC0_D), `FLAG_MODE(FLAG_MODE_OR), `FLAG_MASK(4'h1), `APPLY_MODE(APPLY_MODE_ALL), `KEEP_CNT, `INVERT)
   0x40620000, //   4('h0002b): JUMP(6)  // ELSE
   0xc8a11001, //   5('h0002c): MOV(1, `IN(CRC0_D), `FLAG_MODE(FLAG_MODE_OR), `FLAG_MASK(4'h1), `APPLY_MODE(APPLY_MODE_ALL), `KEEP_CNT)
   0x20001c00, //   6('h0002d): WR_REG(`DEST(ZT_R0+0x000), `WR_MODE(WR_REG_OVER), `WR_MASK(8'h01))
   0x89d00c18, //   7('h0002e): MOV(`R(ZT_FRAMING+0x000,1), `IN(FIFO1))
   0x40020000, //   8('h0002f): JUMP(0)
   // Program will require these registers:
   //   ZT_CODEWORD+0x001 [7:0] - ?? (MOV byte count)
   //   ZT_CODEWORD+0x002 [7:0] - ?? (MOV byte count)
   //   ZT_FRAMING+0x000 [15:0] - ?? (MOV byte count)
   //   ZT_FRAMING+0x002 [7:0] - ?? (JUMP repeat count)
   //   ZT_FRAMING+0x003 [7:0] - ?? (JUMP repeat count)
   //   ZT_OHRATE+0x000 [7:0] - ?? (MOV byte count)
   //   ZT_OHRATE+0x001 [7:0] - ?? (MOV byte count)
   //   ZT_OHRATE+0x002 [15:0] - ?? (MOV byte count)
   //   ZT_PMS_SIZE+0x002 [15:0] - ?? (MOV byte count)
   //   ZT_R8+0x000 [7:0] - ?? (JUMP repeat count)
   //   ZT_VBC_SIZE+0x002 [15:0] - ?? (MOV byte count)
   // Code block 5 will modify these registers:
   //   ZT_R0+0x000 [7:0] -
   0
}; //int fci_prog_tx_vdsl2_bc1_lp1[] = {

DATA_MAP_END; //DATA_MAP_FCI_TX_PORT1_LP1_UCODE

DATA_MAP_FCI_RX_LP1_UCODE
int fci_prog_rx_vdsl2_bc0_lp1[] =
{
   0x05012, // // ID.bc.lp.v
   /*  +fifo3 debug wr
   */
   0x000000ff, // UPROC_ENA
   0x0000,   3, 0x00001a00, 0x10000000, 0x001a0000, 0x00000000, 0x00000000,  // Code block 0 base, size, STATE0-4
   0x0003,   3, 0x00000000, 0x70000000, 0x00000000, 0x08000000, 0x00000000,  // Code block 1 base, size, STATE0-4
   0x0006,  18, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 2 base, size, STATE0-4
   0x0018,   5, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 3 base, size, STATE0-4
   0x001d,   2, 0x00000000, 0x20000000, 0x00000000, 0x00004000, 0x00000000,  // Code block 4 base, size, STATE0-4
   0x001f,  22, 0x00000e00, 0x10000000, 0x000e0000, 0x00000000, 0x00000000,  // Code block 5 base, size, STATE0-4
   0x0035,   4, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 6 base, size, STATE0-4
   0x0039,   4, 0x00000000, 0x50000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 7 base, size, STATE0-4
   0x0000,   0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 8 base, size, STATE0-4
   0x0000,   0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 9 base, size, STATE0-4
   0x06000044, // FLAG_DATA 0
   0x00000656, // FLAG_DATA 1
   61, // Total code length
   // Code block 0 memory
   // Moves bytes from the DTB to the DILV, counting PMS_SIZE before stopping
   0x8c200e3e, //   0('h00000): MOV(`R(ZR_PMS_SIZE+0x002,1), `OUT(FP2))  // Move P bytes to DILV
   0x00004000, //   1('h00001): WAIT_EVENT(WAIT_STOP)  // wait for a stop
   0x40020000, //   2('h00002): JUMP(0)  // Restart
   // Code block 1 memory
   // Pass DTB read-flags into DTB
   0xa0014e3e, //   0('h00003): MOV(`R(ZR_PMS_SIZE+0x002,1), `FLAG_MODE(FLAG_MODE_OR), `FLAG_MASK(4'h4), `APPLY_MODE(APPLY_MODE_LAST))
   0x00004000, //   1('h00004): WAIT_EVENT(WAIT_STOP)  // wait for a stop
   0x40020000, //   2('h00005): JUMP(0)  // END_FOREVER
   // Code block 2 memory
   // Move bytes into and out of the DILV, one cw at a time
   0x30000cac, //   0('h00006): WR_REG(`DEST(ZR_ILV_MIN_FULLNESS0+0x000), `ACCESS_MODE(WR_REG_16), `WR_MODE(WR_REG_OVER), `WR_MASK(16'h  0000))
   0x30000cae, //   1('h00007): WR_REG(`DEST(ZR_ILV_MIN_FULLNESS0+0x002), `ACCESS_MODE(WR_REG_16), `WR_MODE(WR_REG_OVER), `WR_MASK(16'h  0000))
   0x200ffca9, //   2('h00008): WR_REG(`DEST(ZR_ILV_MAX_FULLNESS0+0x001), `WR_MODE(WR_REG_OVER), `WR_MASK(8'hff))
   0x200ffca8, //   3('h00009): WR_REG(`DEST(ZR_ILV_MAX_FULLNESS0+0x000), `WR_MODE(WR_REG_OVER), `WR_MASK(8'hff))
   0x30003caa, //   4('h0000a): WR_REG(`DEST(ZR_ILV_MAX_FULLNESS0+0x002), `ACCESS_MODE(WR_REG_16), `WR_MODE(WR_REG_OVER), `WR_MASK(16'h  0003))
   0x409a089d, //   5('h0000b): JUMP(9, `IFCNTLT(`R(ZR_ILV_PARAMS0+0x001,0)))  // WHILE_CNT_LT(`R(ZR_ILV_PARAMS0+0x001,0)))
   0x40c20000, //   6('h0000c): JUMP(12)
   0x4098089d, //   7('h0000d): JUMP(9, `REPEAT(`R(ZR_ILV_PARAMS0+0x001,0)))
   0x40c20000, //   8('h0000e): JUMP(12)
   0x8d400c08, //   9('h0000f): MOV(`R(ZR_R8+0x000,1), `OUT(ILV0))
   0x30000cb0, //  10('h00010): WR_REG(`DEST(ZR_ILV_FULLNESS0+0x000), `ACCESS_MODE(WR_REG_16), `WR_MODE(WR_REG_OVER), `WR_MASK(16'h  0000))
   0x40720000, //  11('h00011): JUMP(7)  // END_WHILE
   0x80000810, //  12('h00012): MOV(`R(ZR_CODEWORD+0x000,0))  // move CW to ilv
   0x6c10c014, //  13('h00013): SET_IO(`IN(ILV0), `OUT(RS_D))
   0xce300001, //  14('h00014): MOV(1, `OUT(FP3), `KEEP_MASK, `KEEP_CNT)  // Move the first byte to the METRIC CB for synchro
   0x8d000810, //  15('h00015): MOV(`R(ZR_CODEWORD+0x000,0), `OUT(RS_D))  // Move the rest of the CW bytes to RSD
   0x6c148000, //  16('h00016): SET_IO(`SLVIN, `OUT(ILV0))
   0x40c20000, //  17('h00017): JUMP(12)  // END_FOREVER
   // Code block 3 memory
   // Move metrics from METRIC FIFO to the RS Decoder
   0x6e008000, //   0('h00018): SET_IO(`SLVIN, `NULL_DST)
   0x80000001, //   1('h00019): MOV(1)  // Move the first byte (which is for synchro) to NULL
   0x6c11c011, //   2('h0001a): SET_IO(`IN(RSDEC_MET), `OUT(RSDEC_MET))
   0x80000810, //   3('h0001b): MOV(`R(ZR_CODEWORD+0x000,0))  // Move N bytes from metric FIFO to RSD metric
   0x40020000, //   4('h0001c): JUMP(0)  // Restart
   // Code block 4 memory
   // Moves correct bytes from the reed solomon to the descrambler
   0x89000811, //   0('h0001d): MOV(`R(ZR_CODEWORD+0x001,0), `IN(RS_D))  // Move K bytes from RSD to the scrambler
   0x40020000, //   1('h0001e): JUMP(0)  // Restart
   // Code block 5 memory
   // Deframe the mux-frame
   0x6c0ad007, //   0('h0001f): SET_IO(`IN(FP7), `INPUT_FLAG, `OUT(CRC0_D))
   0x6d1f0000, //   1('h00020): SET_IO(`OUT(FIFO3), `KEEP_MASK)
   0xce600001, //   2('h00021): MOV(1, `OUT(FP6), `KEEP_MASK, `KEEP_CNT)
   0xce60081c, //   3('h00022): MOV(`R(ZR_OHRATE+0x000,0), `OUT(FP6), `KEEP_MASK, `KEEP_CNT)  // OH1RATE -> OH channel, clear CRCFL
   0x6c0ac00e, //   4('h00023): SET_IO(`IN(SCR_D), `OUT(CRC0_D))
   0x6d1f0000, //   5('h00024): SET_IO(`OUT(FIFO3), `KEEP_MASK)
   0x8f622c1e, //   6('h00025): MOV(`R(ZR_OHRATE+0x002,1), `OUT(TCLAYER), `KEEP_MASK, `FLAG_MODE(FLAG_MODE_AND), `FLAG_MASK(4'h2), `APPLY_MODE(APPLY_MODE_ALL))
   0x80022c14, //   7('h00026): MOV(`R(ZR_VBC_SIZE+0x000,1), `FLAG_MODE(FLAG_MODE_AND), `FLAG_MASK(4'h2), `APPLY_MODE(APPLY_MODE_ALL))
   0x400c081b, //   8('h00027): JUMP(0, `REPEAT(`R(ZR_FRAMING+0x003,0)), `KEEP_CNT)  // END_WHILE_CNT_LT(`R(ZR_FRAMING+0x003,0)), `KEEP_CNT)
   0x40da081a, //   9('h00028): JUMP(13, `IFCNTLT(`R(ZR_FRAMING+0x002,0)))  // WHILE_CNT_LT(`R(ZR_FRAMING+0x002,0)))
   0x41520000, //  10('h00029): JUMP(21)
   0x40d8081a, //  11('h0002a): JUMP(13, `REPEAT(`R(ZR_FRAMING+0x002,0)))
   0x41520000, //  12('h0002b): JUMP(21)
   0x6c0ad007, //  13('h0002c): SET_IO(`IN(FP7), `INPUT_FLAG, `OUT(CRC0_D))
   0x6d1f0000, //  14('h0002d): SET_IO(`OUT(FIFO3), `KEEP_MASK)
   0xce60081d, //  15('h0002e): MOV(`R(ZR_OHRATE+0x001,0), `OUT(FP6), `KEEP_MASK, `KEEP_CNT)  // OH2RATE -> OH channel, clear CRCFL
   0x6c0ac00e, //  16('h0002f): SET_IO(`IN(SCR_D), `OUT(CRC0_D))
   0x6d1f0000, //  17('h00030): SET_IO(`OUT(FIFO3), `KEEP_MASK)
   0x8f622c1e, //  18('h00031): MOV(`R(ZR_OHRATE+0x002,1), `OUT(TCLAYER), `KEEP_MASK, `FLAG_MODE(FLAG_MODE_AND), `FLAG_MASK(4'h2), `APPLY_MODE(APPLY_MODE_ALL))
   0x80022c14, //  19('h00032): MOV(`R(ZR_VBC_SIZE+0x000,1), `FLAG_MODE(FLAG_MODE_AND), `FLAG_MASK(4'h2), `APPLY_MODE(APPLY_MODE_ALL))
   0x40b20000, //  20('h00033): JUMP(11)  // END_WHILE
   0x40020000, //  21('h00034): JUMP(0)
   // Code block 6 memory
   // Process the OH channel
   0x6e000000, //   0('h00035): SET_IO(`NULL_DST)
   0xc0000001, //   1('h00036): MOV(1, `KEEP_CNT)
   0x8dd00c18, //   2('h00037): MOV(`R(ZR_FRAMING+0x000,1), `OUT(FIFO1))  // Everything else from FIFO0
   0x40020000, //   3('h00038): JUMP(0)
   // Code block 7 memory
   // Setup flags for the OH channel
   0xc0011001, //   0('h00039): MOV(1, `FLAG_MODE(FLAG_MODE_OR), `FLAG_MASK(4'h1), `APPLY_MODE(APPLY_MODE_ALL), `KEEP_CNT)
   0x20001c00, //   1('h0003a): WR_REG(`DEST(ZR_R0+0x000), `WR_MODE(WR_REG_OVER), `WR_MASK(8'h01))  // Set ZR_R0 to 1 to indicate SEQP_DONE
   0x80000c18, //   2('h0003b): MOV(`R(ZR_FRAMING+0x000,1))
   0x40020000, //   3('h0003c): JUMP(0)
   // Program will require these registers:
   //   ZR_CODEWORD+0x000 [7:0] - FEC Codeword size
   //   ZR_CODEWORD+0x001 [7:0] - Kp = N - R
   //   ZR_FRAMING+0x000 [15:0] - Set to SEQp
   //   ZR_FRAMING+0x002 [7:0] - Parameter Tp
   //   ZR_FRAMING+0x003 [7:0] - Number of mux frmaes with ceil(Gp/Tp) OH bytes
   //   ZR_ILV_PARAMS0+0x001 [7:0] - Interleaver Block Size
   //   ZR_OHRATE+0x000 [7:0] - ceil(Gp/Tp)
   //   ZR_OHRATE+0x001 [7:0] - floor(Gp/Tp)
   //   ZR_OHRATE+0x002 [15:0] - ceil(Gp/Tp)
   //   ZR_PMS_SIZE+0x002 [15:0] - Set to number of bytes to transfer this symbol
   //   ZR_R8+0x000 [15:0] - Set to D - floor(D/I) - 1
   //   ZR_VBC_SIZE+0x000 [15:0] - BC1 size = Bp1
   // Code block 2 will modify these registers:
   //   ZR_ILV_FULLNESS0+0x000 [15:0] - Reset fullness to 0 after each iblock
   //   ZR_ILV_MAX_FULLNESS0+0x000 [7:0] -
   //   ZR_ILV_MAX_FULLNESS0+0x001 [7:0] -
   //   ZR_ILV_MAX_FULLNESS0+0x002 [15:0] - Set MAX_FULLNESS to 0x3FFFF
   //   ZR_ILV_MIN_FULLNESS0+0x000 [15:0] -
   //   ZR_ILV_MIN_FULLNESS0+0x002 [15:0] - Set MIN_FULLNESS to 0
   // Code block 7 will modify these registers:
   //   ZR_R0+0x000 [7:0] - SEQP Done
   0
}; //int fci_prog_rx_vdsl2_bc0_lp1[] = {
DATA_MAP_END;

DATA_MAP_FCI_RX_PORT1_LP1_UCODE
int fci_prog_rx_vdsl2_bc1_lp1[] =
{
   0x05112, // ID.bc.lp.v
   /*
   */
   0x000000ff, // UPROC_ENA
   0x0000,   3, 0x00001a00, 0x10000000, 0x001a0000, 0x00000000, 0x00000000,  // Code block 0 base, size, STATE0-4
   0x0003,   3, 0x00000000, 0x70000000, 0x00000000, 0x08000000, 0x00000000,  // Code block 1 base, size, STATE0-4
   0x0006,  18, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 2 base, size, STATE0-4
   0x0018,   5, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 3 base, size, STATE0-4
   0x001d,   2, 0x00000000, 0x20000000, 0x00000000, 0x00004000, 0x00000000,  // Code block 4 base, size, STATE0-4
   0x001f,  18, 0x00000e00, 0x10000000, 0x000e0000, 0x00000000, 0x00000000,  // Code block 5 base, size, STATE0-4
   0x0031,   4, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 6 base, size, STATE0-4
   0x0035,   4, 0x00000000, 0x50000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 7 base, size, STATE0-4
   0x0000,   0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 8 base, size, STATE0-4
   0x0000,   0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 9 base, size, STATE0-4
   0x06000044, // FLAG_DATA 0
   0x00000656, // FLAG_DATA 1
   57, // Total code length
   // Code block 0 memory
   // Moves bytes from the DTB to the DILV, counting PMS_SIZE before stopping
   0x8c200e3e, //   0('h00000): MOV(`R(ZR_PMS_SIZE+0x002,1), `OUT(FP2))  // Move P bytes to DILV
   0x00004000, //   1('h00001): WAIT_EVENT(WAIT_STOP)  // wait for a stop
   0x40020000, //   2('h00002): JUMP(0)  // Restart
   // Code block 1 memory
   // Pass DTB read-flags into DTB
   0xa0014e3e, //   0('h00003): MOV(`R(ZR_PMS_SIZE+0x002,1), `FLAG_MODE(FLAG_MODE_OR), `FLAG_MASK(4'h4), `APPLY_MODE(APPLY_MODE_LAST))
   0x00004000, //   1('h00004): WAIT_EVENT(WAIT_STOP)  // wait for a stop
   0x40020000, //   2('h00005): JUMP(0)  // END_FOREVER
   // Code block 2 memory
   // Move bytes into and out of the DILV, one cw at a time
   0x30000cac, //   0('h00006): WR_REG(`DEST(ZR_ILV_MIN_FULLNESS0+0x000), `ACCESS_MODE(WR_REG_16), `WR_MODE(WR_REG_OVER), `WR_MASK(16'h  0000))
   0x30000cae, //   1('h00007): WR_REG(`DEST(ZR_ILV_MIN_FULLNESS0+0x002), `ACCESS_MODE(WR_REG_16), `WR_MODE(WR_REG_OVER), `WR_MASK(16'h  0000))
   0x200ffca9, //   2('h00008): WR_REG(`DEST(ZR_ILV_MAX_FULLNESS0+0x001), `WR_MODE(WR_REG_OVER), `WR_MASK(8'hff))
   0x200ffca8, //   3('h00009): WR_REG(`DEST(ZR_ILV_MAX_FULLNESS0+0x000), `WR_MODE(WR_REG_OVER), `WR_MASK(8'hff))
   0x30003caa, //   4('h0000a): WR_REG(`DEST(ZR_ILV_MAX_FULLNESS0+0x002), `ACCESS_MODE(WR_REG_16), `WR_MODE(WR_REG_OVER), `WR_MASK(16'h  0003))
   0x409a089d, //   5('h0000b): JUMP(9, `IFCNTLT(`R(ZR_ILV_PARAMS0+0x001,0)))  // WHILE_CNT_LT(`R(ZR_ILV_PARAMS0+0x001,0)))
   0x40c20000, //   6('h0000c): JUMP(12)
   0x4098089d, //   7('h0000d): JUMP(9, `REPEAT(`R(ZR_ILV_PARAMS0+0x001,0)))
   0x40c20000, //   8('h0000e): JUMP(12)
   0x8d400c08, //   9('h0000f): MOV(`R(ZR_R8+0x000,1), `OUT(ILV0))
   0x30000cb0, //  10('h00010): WR_REG(`DEST(ZR_ILV_FULLNESS0+0x000), `ACCESS_MODE(WR_REG_16), `WR_MODE(WR_REG_OVER), `WR_MASK(16'h  0000))
   0x40720000, //  11('h00011): JUMP(7)  // END_WHILE
   0x80000810, //  12('h00012): MOV(`R(ZR_CODEWORD+0x000,0))  // move CW to ilv
   0x6c10c014, //  13('h00013): SET_IO(`IN(ILV0), `OUT(RS_D))
   0xce300001, //  14('h00014): MOV(1, `OUT(FP3), `KEEP_MASK, `KEEP_CNT)  // Move the first byte to the METRIC CB for synchro
   0x8d000810, //  15('h00015): MOV(`R(ZR_CODEWORD+0x000,0), `OUT(RS_D))  // Move the rest of the CW bytes to RSD
   0x6c148000, //  16('h00016): SET_IO(`SLVIN, `OUT(ILV0))
   0x40c20000, //  17('h00017): JUMP(12)  // END_FOREVER
   // Code block 3 memory
   // Move metrics from METRIC FIFO to the RS Decoder
   0x6e008000, //   0('h00018): SET_IO(`SLVIN, `NULL_DST)
   0x80000001, //   1('h00019): MOV(1)  // Move the first byte (which is for synchro) to NULL
   0x6c11c011, //   2('h0001a): SET_IO(`IN(RSDEC_MET), `OUT(RSDEC_MET))
   0x80000810, //   3('h0001b): MOV(`R(ZR_CODEWORD+0x000,0))  // Move N bytes from metric FIFO to RSD metric
   0x40020000, //   4('h0001c): JUMP(0)  // Restart
   // Code block 4 memory
   // Moves correct bytes from the reed solomon to the descrambler
   0x89000811, //   0('h0001d): MOV(`R(ZR_CODEWORD+0x001,0), `IN(RS_D))  // Move K bytes from RSD to the scrambler
   0x40020000, //   1('h0001e): JUMP(0)  // Restart
   // Code block 5 memory
   // Deframe the mux-frame
   0x6c0ad007, //   0('h0001f): SET_IO(`IN(FP7), `INPUT_FLAG, `OUT(CRC0_D))
   0xce600001, //   1('h00020): MOV(1, `OUT(FP6), `KEEP_MASK, `KEEP_CNT)
   0xce60081c, //   2('h00021): MOV(`R(ZR_OHRATE+0x000,0), `OUT(FP6), `KEEP_MASK, `KEEP_CNT)  // OH1RATE -> OH channel, clear CRCFL
   0x6c0ac00e, //   3('h00022): SET_IO(`IN(SCR_D), `OUT(CRC0_D))
   0x8f612c1e, //   4('h00023): MOV(`R(ZR_OHRATE+0x002,1), `OUT(TCLAYER), `KEEP_MASK, `FLAG_MODE(FLAG_MODE_OR), `FLAG_MASK(4'h2), `APPLY_MODE(APPLY_MODE_ALL))
   0x80012c14, //   5('h00024): MOV(`R(ZR_VBC_SIZE+0x000,1), `FLAG_MODE(FLAG_MODE_OR), `FLAG_MASK(4'h2), `APPLY_MODE(APPLY_MODE_ALL))
   0x400c081b, //   6('h00025): JUMP(0, `REPEAT(`R(ZR_FRAMING+0x003,0)), `KEEP_CNT)  // END_WHILE_CNT_LT(`R(ZR_FRAMING+0x003,0)), `KEEP_CNT)
   0x40ba081a, //   7('h00026): JUMP(11, `IFCNTLT(`R(ZR_FRAMING+0x002,0)))  // WHILE_CNT_LT(`R(ZR_FRAMING+0x002,0)))
   0x41120000, //   8('h00027): JUMP(17)
   0x40b8081a, //   9('h00028): JUMP(11, `REPEAT(`R(ZR_FRAMING+0x002,0)))
   0x41120000, //  10('h00029): JUMP(17)
   0x6c0ad007, //  11('h0002a): SET_IO(`IN(FP7), `INPUT_FLAG, `OUT(CRC0_D))
   0xce60081d, //  12('h0002b): MOV(`R(ZR_OHRATE+0x001,0), `OUT(FP6), `KEEP_MASK, `KEEP_CNT)  // OH2RATE -> OH channel, clear CRCFL
   0x6c0ac00e, //  13('h0002c): SET_IO(`IN(SCR_D), `OUT(CRC0_D))
   0x8f612c1e, //  14('h0002d): MOV(`R(ZR_OHRATE+0x002,1), `OUT(TCLAYER), `KEEP_MASK, `FLAG_MODE(FLAG_MODE_OR), `FLAG_MASK(4'h2), `APPLY_MODE(APPLY_MODE_ALL))
   0x80012c14, //  15('h0002e): MOV(`R(ZR_VBC_SIZE+0x000,1), `FLAG_MODE(FLAG_MODE_OR), `FLAG_MASK(4'h2), `APPLY_MODE(APPLY_MODE_ALL))
   0x40920000, //  16('h0002f): JUMP(9)  // END_WHILE
   0x40020000, //  17('h00030): JUMP(0)
   // Code block 6 memory
   // Process the OH channel
   0x6e000000, //   0('h00031): SET_IO(`NULL_DST)
   0xc0000001, //   1('h00032): MOV(1, `KEEP_CNT)
   0x8dd00c18, //   2('h00033): MOV(`R(ZR_FRAMING+0x000,1), `OUT(FIFO1))  // Everything else from FIFO0
   0x40020000, //   3('h00034): JUMP(0)
   // Code block 7 memory
   // Setup flags for the OH channel
   0xc0011001, //   0('h00035): MOV(1, `FLAG_MODE(FLAG_MODE_OR), `FLAG_MASK(4'h1), `APPLY_MODE(APPLY_MODE_ALL), `KEEP_CNT)
   0x20001c00, //   1('h00036): WR_REG(`DEST(ZR_R0+0x000), `WR_MODE(WR_REG_OVER), `WR_MASK(8'h01))  // Set ZR_R0 to 1 to indicate SEQP_DONE
   0x80000c18, //   2('h00037): MOV(`R(ZR_FRAMING+0x000,1))
   0x40020000, //   3('h00038): JUMP(0)
   // Program will require these registers:
   //   ZR_CODEWORD+0x000 [7:0] - FEC Codeword size
   //   ZR_CODEWORD+0x001 [7:0] - Kp = N - R
   //   ZR_FRAMING+0x000 [15:0] - Set to SEQp
   //   ZR_FRAMING+0x002 [7:0] - Parameter Tp
   //   ZR_FRAMING+0x003 [7:0] - Number of mux frmaes with ceil(Gp/Tp) OH bytes
   //   ZR_ILV_PARAMS0+0x001 [7:0] - Interleaver Block Size
   //   ZR_OHRATE+0x000 [7:0] - ceil(Gp/Tp)
   //   ZR_OHRATE+0x001 [7:0] - floor(Gp/Tp)
   //   ZR_OHRATE+0x002 [15:0] - ceil(Gp/Tp)
   //   ZR_PMS_SIZE+0x002 [15:0] - Set to number of bytes to transfer this symbol
   //   ZR_R8+0x000 [15:0] - Set to D - floor(D/I) - 1
   //   ZR_VBC_SIZE+0x002 [15:0] - BC1 size = Bp1
   // Code block 2 will modify these registers:
   //   ZR_ILV_FULLNESS0+0x000 [15:0] - Reset fullness to 0 after each iblock
   //   ZR_ILV_MAX_FULLNESS0+0x000 [7:0] -
   //   ZR_ILV_MAX_FULLNESS0+0x001 [7:0] -
   //   ZR_ILV_MAX_FULLNESS0+0x002 [15:0] - Set MAX_FULLNESS to 0x3FFFF
   //   ZR_ILV_MIN_FULLNESS0+0x000 [15:0] -
   //   ZR_ILV_MIN_FULLNESS0+0x002 [15:0] - Set MIN_FULLNESS to 0
   // Code block 7 will modify these registers:
   //   ZR_R0+0x000 [7:0] - SEQP Done
   0
}; //int fci_prog_rx_vdsl2_bc1_lp1[] = {

DATA_MAP_END; //DATA_MAP_FCI_RX_PORT1_LP1_UCODE

DATA_MAP_FCI_RX_LP1_RETX_UCODE
int fci_prog_rx_vdsl2_bc0_lp1_retx[] =
{

   0x06018, //  ID.bc.lp.v
   /*
   */
   0x0000007f, // UPROC_ENA
   0x0000,   3, 0x00001a00, 0x10000000, 0x001a0000, 0x00000000, 0x00000000,  // Code block 0 base, size, STATE0-4
   0x0003,   3, 0x00000000, 0x70000000, 0x00000000, 0x08000000, 0x00000000,  // Code block 1 base, size, STATE0-4
   0x0006,  18, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 2 base, size, STATE0-4
   0x0018,   5, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 3 base, size, STATE0-4
   0x001D,   5, 0x00000000, 0x20000000, 0x00000000, 0x00004000, 0x00000000,  // Code block 4 base, size, STATE0-4
   0x0022,  45, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 5 base, size, STATE0-4
   0x004F,  31, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 6 base, size, STATE0-4
   0x0000,   0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 7 base, size, STATE0-4
   0x0000,   0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 8 base, size, STATE0-4
   0x0000,   0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 9 base, size, STATE0-4
   0x06000000, // FLAG_DATA 0
   0x00000656, // FLAG_DATA 1
   110, // Total code length

   // Code block 0 memory
   // Moves bytes from the DTB to the DILV, counting PMS_SIZE before stopping
   0x8c200e3e, //   1('h00000): MOV(`R(ZR_PMS_SIZE+0x000,1), `OUT(FP2))  // Move P bytes to DILV
   0x00004000, //   2('h00001): WAIT_EVENT(WAIT_STOP)  // wait for a stop
   0x40020000, //   3('h00002): JUMP(0)  // Restart

   // Code block 1 memory
   // Pass DTB read-flags into DTB
   0xa0014e3e, //   0('h00003): MOV(`R(ZR_PMS_SIZE+0x000,1), `FLAG_MODE(FLAG_MODE_OR), `FLAG_MASK(4'h4), `APPLY_MODE(APPLY_MODE_LAST))
   0x00004000, //   1('h00004): WAIT_EVENT(WAIT_STOP)  // wait for a stop
   0x40020000, //   2('h00005): JUMP(0)  // END_FOREVER
   // Code block 2 memory
   // Move bytes into and out of the DILV, one cw at a time
   0x30000cac, //   0('h00005): WR_REG(`DEST(ZR_ILV_MIN_FULLNESS0+0x000), `ACCESS_MODE(WR_REG_16), `WR_MODE(WR_REG_OVER), `WR_MASK(16'h  0000))
   0x30000cae, //   1('h00006): WR_REG(`DEST(ZR_ILV_MIN_FULLNESS0+0x002), `ACCESS_MODE(WR_REG_16), `WR_MODE(WR_REG_OVER), `WR_MASK(16'h  0000))
   0x200ffca9, //   2('h00007): WR_REG(`DEST(ZR_ILV_MAX_FULLNESS0+0x001), `WR_MODE(WR_REG_OVER), `WR_MASK(8'hff))
   0x200ffca8, //   3('h00008): WR_REG(`DEST(ZR_ILV_MAX_FULLNESS0+0x000), `WR_MODE(WR_REG_OVER), `WR_MASK(8'hff))
   0x30003caa, //   4('h00009): WR_REG(`DEST(ZR_ILV_MAX_FULLNESS0+0x002), `ACCESS_MODE(WR_REG_16), `WR_MODE(WR_REG_OVER), `WR_MASK(16'h  0003))
   0x409a089d, //   5('h0000a): JUMP(9, `IFCNTLT(`R(ZR_ILV_PARAMS0+0x001,0)))  // WHILE_CNT_LT(`R(ZR_ILV_PARAMS0+0x001,0)))
   0x40c20000, //   6('h0000b): JUMP(12)
   0x4098089d, //   7('h0000c): JUMP(9, `REPEAT(`R(ZR_ILV_PARAMS0+0x001,0)))
   0x40c20000, //   8('h0000d): JUMP(12)
   0x8d400c08, //   9('h0000e): MOV(`R(ZR_R8+0x000,1), `OUT(ILV0))
   0x30000cb0, //  10('h0000f): WR_REG(`DEST(ZR_ILV_FULLNESS0+0x000), `ACCESS_MODE(WR_REG_16), `WR_MODE(WR_REG_OVER), `WR_MASK(16'h  0000))
   0x40720000, //  11('h00010): JUMP(7)  // END_WHILE
   0x80000810, //  12('h00011): MOV(`R(ZR_CODEWORD+0x000,0))  // move CW to ilv
   0x6c10c014, //  13('h00012): SET_IO(`IN(ILV0), `OUT(RS_D))
   0xce300001, //  14('h00013): MOV(1, `OUT(FP3), `KEEP_MASK, `KEEP_CNT)  // Move the first byte to the METRIC CB for synchro
   0x8d000810, //  15('h00014): MOV(`R(ZR_CODEWORD+0x000,0), `OUT(RS_D))  // Move the rest of the CW bytes to RSD
   0x6c148000, //  16('h00015): SET_IO(`SLVIN, `OUT(ILV0))
   0x40c20000, //  17('h00016): JUMP(12)  // END_FOREVER
   // Code block 3 memory
   // Move metrics from METRIC FIFO to the RS Decoder
   0x6e008000, //   0('h00017): SET_IO(`SLVIN, `NULL_DST)
   0x80000001, //   1('h00018): MOV(1)  // Move the first byte (which is for synchro) to NULL
   0x6c11c011, //   2('h00019): SET_IO(`IN(RSDEC_MET), `OUT(RSDEC_MET))
   0x80000810, //   3('h0001a): MOV(`R(ZR_CODEWORD+0x000,0))  // Move N bytes from metric FIFO to RSD metric
   0x40020000, //   4('h0001b): JUMP(0)  // Restart
   // Code block 4 memory
   // Moves correct bytes from the reed solomon to the descrambler
   0x30000c40, //   0('h0001c): WR_REG, <reg_mode>=3, <byte_addr>=0x40    LSW //Reset Scrambler ZR_SCR_OFFSET                (0x40) //ZR_SCR
   0x30000c42, //   1('h0001d): WR_REG, <reg_mode>=3, <byte_addr>=0x42    MSW //Reset Scrambler ZR_SCR_OFFSET                (0x42) //
   0x89000811, //   2('h0001e): MOV(`R(ZR_CODEWORD+0x001,0), `IN(RS_D))  // Move K bytes from RSD to the scrambler
   0x40280818, //   3('h0001f): Jump, <repeat>=1, <use_reg>=1, <reg_id>=0x18  // Repeat(Q), ZR_FRAMING stores Q
   0x40020000, //   4('h00020): JUMP(0)  // Restart

// Code block 5 memory
//START_FP5_L0:
//   0x6c1dc00e, //   0('h00021):SET IO('IN(SCR_D), OUT(FIFO1))
   0x6e00c00e, //   0('h00021):SET IO('IN(SCR_D), OUT(NULL_DEST=1))
   0x20000c04, //   1('h00022):WR_REG('R(ZR_R4+0x000), BAD_DTU = 0, Clear
//   0x80000001, //   2('h00023):MOV 1 byte (SID) to FIFO1
   0x80000001, //   2('h00023):MOV 1 byte (SID) to ZR_CRC1+2
   0x28000036, //   3('h00023):MOV Last Received 1 byte (SID) to ZR_CRC1+2

//   0x80000001, //   4('h00023):MOV 1 byte (TS) to FIFO1
   0x80000001, //   4('h00023):MOV 1 byte (TS) to ZR_CRC1+3
   0x28000037, //   5('h00023):MOV Last Received 1 byte (TS) to ZR_CRC1+3

//   0x6e000000, //   6('h00024):SET_IO('OUT(NULL_DEST= 1))
   0x80000819, //   6('h00025):MOV ('R(ZR_FRAMING+0x001,1)) V bytes to null_dest
   0x8d80081a, //   7('h00026):MOV (K-V-2) bytes to ILVIF <block_id>=24

//IS_CW_OK_L_8:
   0x40a04000, //   8('h00027):JUMP(CW_OK_L10, IF_FLAG != 0x4), i.e CW = OK;(SET_RST=0, FLAG_MASK=0x4)
   0x20001c04, //   9('h00028):WR_REG(`R(ZR_R4 +0x000),REG_MODE('11'),OVER_REG_WITH_MASK),MASK = 1; BAD_CW=1;

//CW_OK_L10:
   0x40c80818, //   10('h00029):JUMP(TRANS_CW_L12, END_WHILE_CNT_LT(`R(ZR_FRAMING+0x000,0)))
   0x40e20000, //   11('h00038):JUMP(TRANS_DONE_L14)
//TRANS_CW_L12:
   0x8d800811, //   12('h0002a):MOV('R(ZR_CODEWORD+0x001,1)) K bytes to ILVIF <block_id>=24
   0x40820000, //   13('h00038):JUMP(IS_CW_OK_L_8)

//TRANS_DONE_L14:
   0x6000E055, //   14           SET_IO(Input Enabled, Input Master,Input Null SRC,  Input CONST(0x55); DTU size to be 32bit aligned, hence stuff the constant to inc WRAD
   0x8d800835, //   15           Move No of stuffing bytes available at (ZR_CRC1+0x0001, 1) to ILVBIF

   0x6c18e836, //   16('h0002e):SET_IO('OUT(ILVBIF), INPUT('R(ZR_CRC1+0x02))) (R'(ZR_CRC1+0x02))==> SID
   0x80000001, //   17('h0002f):MOV 1 byte

   0x6c18e837, //   18('h0002e):SET_IO('OUT(ILVBIF), INPUT('R(ZR_CRC1+0x03))) (R'(ZR_CRC1+0x02))==> TS
   0x80000001, //   19('h0002f):MOV 1 byte

   0x6c18e804, //   20('h0002e):SET_IO('OUT(ILVBIF), INPUT('R(ZR_R4+0x00))) (R'(ZR_R4+0x00))==> BAD_CW
   0x80000001, //   21('h0002f):MOV 1 byte

   0x20034192, //   22           WR_REG(ZR_CRC1 + 0x0000 ==> ZR_UPROC5_STATE0 + 0x0002) Copy 8bit data from ZR_CRC1 + 0x0000 to ZR_UPROC5_STATE0 + 0x0002
   0x41bc0004, //   23          JUMP(FP5_INC_Qrx_WRITE_COUNT_L27 , REPEAT, KEEP_CNT, END_WHILE_CNT_LT(0x4)), Added to increment the counter
   0x20000d92, //   24           WR_REG(Data_Mask0(0) ==> ZR_UPROC5_STATE0 + 0x0002) Clear repeat counter at FP5

   0x30028058, //   25('h0004b): WR_REG: LSW ZR_ILV_WRAD(0x58) = LSW_RETX_QUEUE_BASE_AD(0x28); LSW 1st DTU Address (0x28)  //ZR_CR0_LP1
   0x3002a05a, //   26('h0004c): WR_REG: LSW ZR_ILV_WRAD(0x5a) = LSW_RETX_QUEUE_BASE_AD(0x2a); MSW 1st DTU Address (0x2a)

//FP5_INC_Qrx_WRITE_COUNT_L27
   0x20192034, //   27           WR_REG(ZR_UPROC5_STATE0 + 0x0002 ==> ZR_CRC1 + 0x0000) Copy 8bit data from ZR_UPROC5_STATE0 + 0x0002 to ZR_CRC1 + 0x0001
   0x20000d92, //   28           WR_REG(Data_Mask0(0) ==> ZR_UPROC5_STATE0 + 0x0002) Clear repeat counter at FP5
   0x41e80001, //   29           JUMP(FP5_CLR_KEEP_CNT_BIT_L30 , REPEAT(0x1),END_WHILE_CNT_LT(0x01))), Clear Keep count bit
//FP5_CLR_KEEP_CNT_BIT_L30
   0x6e00e834, //   30('h00034):SET_IO('OUT(NULL), INPUT('R(ZR_CRC1+0x0))) (R'(ZR_CRC1x0))==> Read Idx counter
   0x80000001, //   31('h00035):MOV 1 byte
   0x42410101, //   32('h00036):JUMP(RX_Q_READ_IDX_1_FP5_L36 if IDX ==1, SET_RST=1, DATA_JUMP=1,MATCH_DATA=1)
   0x42710102, //   33('h00036):JUMP(RX_Q_READ_IDX_2_FP5_L39 if IDX ==2, SET_RST=1, DATA_JUMP=1,MATCH_DATA=2)
   0x42a10103, //   34('h00036):JUMP(RX_Q_READ_IDX_2_FP5_L42 if IDX ==3, SET_RST=1, DATA_JUMP=1,MATCH_DATA=3)
   0x40020000, //   35('h00038):JUMP(START_FP5_L0)

//RX_Q_READ_IDX_1_FP5_L36:
   0x3001c058, //   36('h0004b): WR_REG: LSW ZR_ILV_WRAD(0x58) = LSW 2nd DTU Address (0x1c)                               //ZR_OHRATE_LP1
   0x3001e05a, //   37('h0004c): WR_REG: LSW ZR_ILV_WRAD(0x5a) = MSW 2nd DTU Address (0x1e)
   0x40020000, //   38('h00038):JUMP(START_FP5_L0)

//RX_Q_READ_IDX_2_FP5_L39
   0x30060058, //   39('h0004b): WR_REG: LSW ZR_ILV_WRAD(0x58) = LSW 3rd DTU Address (0x60)                               //ZR_ILVB_WRPTR_LP1
   0x3006205a, //   40('h0004c): WR_REG: LSW ZR_ILV_WRAD(0x5a) = MSW 3rd DTU Address (0x62)
   0x40020000, //   41('h00038):JUMP(START_FP5_L0)

//RX_Q_READ_IDX_2_FP5_L42
   0x30014058, //   42('h0004b): WR_REG: LSW ZR_ILV_WRAD(0x58) = LSW 4th DTU Address (0x14)                               //ZR_VBC_SIZE_LP1
   0x3001605a, //   43('h0004c): WR_REG: LSW ZR_ILV_WRAD(0x5a) = MSW 4th DTU Address (0x16)
   0x40020000, //   44('h00038):JUMP(START_FP5_L0)


   // Code block 6 memory
   // Delivers the DTUs to the TC layer from ReTx reordered buffer using FIFO3 interface from
   //IIBRAM Locations 0x4C000, 0x4D000, 0x4E000, 0x4F000
// Tested and working with 4 DTU/DMT symbol from line 0 to 29  - Start //////////////////
//FP6_START_L0
   0x6e00e80c, //   0('h0003e): SET_IO: input=0xC (XDTUs), output null,
   0x80000001, //   1('h0003f): MOV 1 byte
   0x41C10100, //   2('h00040): JUMP(FP6_NO_DTUS_TO_FWD_EXIT_L28, line 28),  match_data = 0, data_jump= 1

//FP6_SET_1ST_DTU_BASE_ADDR_L3
   0x3c000c8c, //   3('h00005): WR_REG(`DEST(ZR_FIFO_PTRS3+0x000), `ACCESS_MODE(WR_REG_16), `WR_MODE(WR_REG_OVER), `WR_MASK(16'h  c000)) Set 1st DTUs Lower 16bit address
//FP6_SET_FIFO3_WRPTR_RDPTR_L4
   //Reset FIFO3 WRPTR to Max Value 4095 and RDPTR to "0" as Beginning of the queue
   0x30fffc90, //   4('h00005): WR_REG(`DEST(ZR_FIFO_PTRS3+0x000), `ACCESS_MODE(WR_REG_16), `WR_MODE(WR_REG_OVER), `WR_MASK(16'h  0fff)) WRPTR to 4095
   0x30000c92, //   5('h00006): WR_REG(`DEST(ZR_FIFO_PTRS3+0x002), `ACCESS_MODE(WR_REG_16), `WR_MODE(WR_REG_OVER), `WR_MASK(16'h  0000)) RDPTR to 0

//FP6_START_FORWARD_L3
   0x6c16c01f, //   6('h0003c): SET_IO: input=31 FIFO3 master, output=22 TC-LAYER master
   0x80022c0e, //   7('h0003c): MOV: (QH - V - 2) bytes, <use_reg>=1, <reg_id>=0x0e, <flag_mode>=2, <flag_mask>=2

   0x2000d1a6, //   8           WR_REG(ZR_R12 + 0x0001 ==> ZR_UPROC6_STATE0 + 0x0002) Copy 8bit data from ZR_R12 + 0x0001 to ZR_UPROC6_STATE0 + 0x0002
   0x40dc080c, //   9           JUMP(FP6_INC_DTU_FWD_COUNT_L13 , REPEAT, KEEP_CNT, END_WHILE_CNT_LT(R(ZR_R12+0x000))), Added to increment the counter
   0x201a600d, //   10          WR_REG( ZR_UPROC6_STATE0 + 0x0002 ==> ZR_R12 + 0x0001) Copy 8bit data from ZR_UPROC6_STATE0 + 0x0002 to ZR_R12 + 0x0001
   0x200001a6, //   11          WR_REG(Data_Mask0(0) ==> ZR_UPROC6_STATE0 + 0x0002) Clear repeat counter at FP6
   0x41C20000, //   12('h00038) JUMP(FP6_NO_DTUS_TO_FWD_EXIT_L28)

//FP6_INC_DTU_FWD_COUNT_L13
   0x201a600d, //   13           WR_REG(ZR_UPROC6_STATE0 + 0x0002 ==> ZR_R12 + 0x0001) Copy 8bit data from ZR_UPROC6_STATE0 + 0x0002 to ZR_R12 + 0x0001
   0x20000da6, //   14           WR_REG(Data_Mask0(0) ==> ZR_UPROC6_STATE0 + 0x0002) Clear repeat counter at FP6
   0x41080001, //   15           JUMP(FP6_CLR_KEEP_CNT_BIT_L16 , REPEAT(0x1),END_WHILE_CNT_LT(0x01))), Clear Keep count bit

//FP6_CLR_KEEP_CNT_BIT_L16
   0x6e00e80d, //   16('h00034): SET_IO('OUT(NULL), INPUT('R(ZR_R12+0x1))) (R'(ZR_R12 + 1))==> Read DTU forward Idx counter
   0x80000001, //   17('h00035): MOV 1 byte
   0x41610101, //   18('h00036): JUMP(FP6_SET_2ND_DTU_BASE_ADDR_L22 if IDX ==1, SET_RST=1, DATA_JUMP=1,MATCH_DATA=1)
   0x41810102, //   19('h00036): JUMP(FP6_SET_3RD_DTU_BASE_ADDR_L24 if IDX ==2, SET_RST=1, DATA_JUMP=1,MATCH_DATA=2)
   0x41A10103, //   20('h00036): JUMP(FP6_SET_4TH_DTU_BASE_ADDR_L26 if IDX ==3, SET_RST=1, DATA_JUMP=1,MATCH_DATA=3)
   0x41C20000, //   21('h00038): JUMP(FP6_NO_DTUS_TO_FWD_EXIT_L28)

//FP6_SET_2ND_DTU_BASE_ADDR_L22
   0x3d000c8c, //   22('h00005): WR_REG(`DEST(ZR_FIFO_PTRS3+0x000), `ACCESS_MODE(WR_REG_16), `WR_MODE(WR_REG_OVER), `WR_MASK(16'h  c000)) Set 2nd DTUs Lower 16bit address
   0x40420000, //   23('h00038): JUMP(FP6_SET_FIFO3_WRPTR_RDPTR_L4) //Reset FIFO3 WRPTR to Max Value 4095 and RDPTR to "0" as Beginning of the queue

//FP6_SET_3RD_DTU_BASE_ADDR_L24
   0x3e000c8c, //   24('h00005): WR_REG(`DEST(ZR_FIFO_PTRS3+0x000), `ACCESS_MODE(WR_REG_16), `WR_MODE(WR_REG_OVER), `WR_MASK(16'h  c000)) Set 2nd DTUs Lower 16bit address
   0x40420000, //   25('h00038): JUMP(FP6_SET_FIFO3_WRPTR_RDPTR_L4) //Reset FIFO3 WRPTR to Max Value 4095 and RDPTR to "0" as Beginning of the queue

//FP6_SET_4TH_DTU_BASE_ADDR_L26
   0x3f000c8c, //   26('h00005): WR_REG(`DEST(ZR_FIFO_PTRS3+0x000), `ACCESS_MODE(WR_REG_16), `WR_MODE(WR_REG_OVER), `WR_MASK(16'h  c000)) Set 2nd DTUs Lower 16bit address
   0x40420000, //   27('h00038): JUMP(FP6_SET_FIFO3_WRPTR_RDPTR_L4) //Reset FIFO3 WRPTR to Max Value 4095 and RDPTR to "0" as Beginning of the queue

//FP6_NO_DTUS_TO_FWD_EXIT_L28
   0x00004000, //   28('h0003f) : WAIT for frame next frame
   0x40020000, //   29('h00040): JUMP(0)  // Restart
// Tested and working with 4 DTU/DMT symbol from line 0 to 29  - End //////////////////

   // Program will require these registers:
   //   ZR_CODEWORD+0x000 [7:0] - FEC Codeword size
   //   ZR_CODEWORD+0x001 [7:0] - Kp = N - R
   //   ZR_FRAMING+0x000 [15:0] - Set to SEQp
   //   ZR_FRAMING+0x002 [7:0] - Parameter Tp
   //   ZR_FRAMING+0x003 [7:0] - Number of mux frmaes with ceil(Gp/Tp) OH bytes
   //   ZR_ILV_PARAMS0+0x001 [7:0] - Interleaver Block Size
   //   ZR_OHRATE+0x000 [7:0] - ceil(Gp/Tp)
   //   ZR_OHRATE+0x001 [7:0] - floor(Gp/Tp)
   //   ZR_OHRATE+0x002 [15:0] - ceil(Gp/Tp)
   //   ZR_PMS_SIZE+0x000 [15:0] - Set to number of bytes to transfer this symbol
   //   ZR_R8+0x000 [15:0] - Set to D - floor(D/I) - 1
   //   ZR_VBC_SIZE+0x000 [15:0] - BC1 size = Bp1
   // Code block 2 will modify these registers:
   //   ZR_ILV_FULLNESS0+0x000 [15:0] - Reset fullness to 0 after each iblock
   //   ZR_ILV_MAX_FULLNESS0+0x000 [7:0] -
   //   ZR_ILV_MAX_FULLNESS0+0x001 [7:0] -
   //   ZR_ILV_MAX_FULLNESS0+0x002 [15:0] - Set MAX_FULLNESS to 0x3FFFF
   //   ZR_ILV_MIN_FULLNESS0+0x000 [15:0] -
   //   ZR_ILV_MIN_FULLNESS0+0x002 [15:0] - Set MIN_FULLNESS to 0
   // Code block 7 will modify these registers:
   //   ZR_R0+0x000 [7:0] - SEQP Done
   //   ZR_R4 + 0x0
   //   ZR_R12 [7:0]   = XDTUs
   //   ZR_R12 [15:8]  = No of DTUs forwarded count
   //   ZR_R12 [31:16] = (DTU_SIZE - V - 2), Payload bytes/DTU to be delivered to TC layer
   //   ZR_SCR        [31:0]  = 0 (Reset the SCR for every RS CW)
   //   ZR_CR0        [31:0]  = 1st DTU write address passed by FW
   //   ZR_OHRATE     [31:0]  = 2nd DTU write address passed by FW
   //   ZR_ILVB_WRPTR [31:0]  = 3rd DTU write address passed by FW
   //   ZR_VBC_SIZE   [31:0]  = 4th DTU write address passed by FW
   //   ZR_CRC1 [31:24] = TS   (Micro code  store temporarily
   //   ZR_CRC1 [23:16] = SID  (Micro code  store temporarily
   0
};
DATA_MAP_END;

//XDSLRTFW-1617 (Start)
DATA_MAP_FCI_RX_LP1_RETX_IDILV_UCODE
//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
// The following microcode is invoked when DS intra DTU interleaving is selected (i.e DS ReTx D > 1)
int fci_prog_rx_vdsl2_bc0_lp1_retx_idilv[] =
{
   0x06018, //  ID.bc.lp.v
   0x0000017f, // UPROC_ENA, FP7 & FP9 are not being used

   0x0000,   4, 0x00000000, 0x10000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 0 base, size, STATE0-4
   0x0004,   3, 0x00000000, 0x70000000, 0x00000000, 0x08000000, 0x00000000,  // Code block 1 base, size, STATE0-4
   0x0007,  29, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 2 base, size, STATE0-4
   0x0024,   5, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 3 base, size, STATE0-4
   0x0029,   5, 0x00000000, 0x20000000, 0x00000000, 0x00004000, 0x00000000,  // Code block 4 base, size, STATE0-4
   0x002E,  45, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 5 base, size, STATE0-4
   0x005B,  30, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 6 base, size, STATE0-4
   0x0079,   0, 0x00000000, 0x50000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 7 base, size, STATE0-4
   0x0079,  16, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 8 base, size, STATE0-4
   0x0089,   0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 9 base, size, STATE0-4

   0x76000044, // FLAG_DATA 0
   0x00000656, // FLAG_DATA 1
   137, //Total code length

   // Code block 0 memory
   0x6c08c01a, // 0: SET_IO(output FP8, input DTB)
   0x8c800e3e, // 1: MOV( output Fp8,move count Reg PMS_SIZE_LP1)
   0x00004000, // 2: WAIT_EVENT(WAIT_STOP)  // wait for a stop
   0x40020000, // 3: JUMP(0)  // Restart

   // Code block 1 memory
   // Pass DTB read-flags into DTB
   0xa0014e3e, // 0: MOV(`R(ZR_PMS_SIZE+0x000,1), `FLAG_MODE(FLAG_MODE_OR), `FLAG_MASK(4'h4), `APPLY_MODE(APPLY_MODE_LAST))
   0x00004000, // 1: WAIT_EVENT(WAIT_STOP)  // wait for a stop
   0x40020000, // 2: JUMP(0)  // END_FOREVER


   // Code block 2 memory
   //The below part of the code moves data from ILV0 to RS decoder. The 1st byte of the CW is also input to Fp3
   // to indicate inputting metric to RS decoder.
   0x6c10c014, // 0:Input ILV0, output RS decoder
   0xce300001, // 1: Move first byte of CW,  1st byte to FP3 to indicate start of CW, Keep byte count, keep mask
   0x8d000810, // 2: Move remaining bytes of CW only to RS decoder
   0x40080898, // 3: Jump LINE_0, cnt < ZR_DEPTH 0,

   //*************** Initialise ILV0 counters ***************************************************************************************
   0x30000cb4, // 4: WR_REG(`DEST(ZR_ILV_CNTRS0+0x000), `ACCESS_MODE(WR_REG_16), `WR_MODE(WR_REG_OVER), `WR_MASK(16'h  0000))
   0x30000cb6, // 5: WR_REG(`DEST(ZR_ILV_CNTRS0+0x002), `ACCESS_MODE(WR_REG_16), `WR_MODE(WR_REG_OVER), `WR_MASK(16'h  0000))
   0x30000cb8, // 6: WR_REG(`DEST(ZR_ILV_PMS_CNTRS0+0x000), `ACCESS_MODE(WR_REG_16),`WR_MODE(WR_REG_OVER), `WR_MASK(16'h  0000))
   0x30000cba, // 7: WR_REG(`DEST(ZR_ILV_PMS_CNTRS0+0x002), `ACCESS_MODE(WR_REG_16),`WR_MODE(WR_REG_OVER), `WR_MASK(16'h  0000))
   0x30000cbe, // 8: WR_REG(`DEST(ZR_ILV_PMD_CNTRS0+0x002), `ACCESS_MODE(WR_REG_16),`WR_MODE(WR_REG_OVER), `WR_MASK(16'h  0000))
   0x30000cbc, // 9: WR_REG(`DEST(ZR_ILV_PMD_CNTRS0+0x000), `ACCESS_MODE(WR_REG_16),`WR_MODE(WR_REG_OVER), `WR_MASK(16'h  0000))

   0x30000cae, // 10: WR_REG(`DEST(ZR_ILV_MIN_FULLNESS0+0x002), `ACCESS_MODE(WR_REG_16), `WR_MODE(WR_REG_OVER), `WR_MASK(16'h  0000))
   0x30000caa, // 11: WR_REG(`DEST(ZR_ILV_MAX_FULLNESS0+0x002), `ACCESS_MODE(WR_REG_16),`WR_MODE(WR_REG_OVER), `WR_MASK(16'h  0000))
   0x300a40ac, // 12: WR_REG(`DEST(ZR_ILV_MIN_FULLNESS0+0x000), `ACCESS_MODE(WR_REG_16), `WR_MODE(WR_REG_OVER), `WR_MASK(16'h  0000))
   0x300a40a8, // 13: WR_REG(`DEST(ZR_ILV_MAX_FULLNESS0+0x000), `ACCESS_MODE(WR_REG_16),`WR_MODE(WR_REG_OVER), `WR_MASK(16'h  0000))
   //********************************************************************************************************************************

   //The below part of the code moves data from ILV1 to RS decoder. The 1st byte of the CW is also input to Fp3
   // to indicate inputting metric to RS decoder.
   0x6c10c015, // 14:Input ILV1, output RS decoder
   0xce300001, // 15: Move first byte of CW, 1st byte to FP3 to indicate start of CW, Keep byte count, keep mask
   0x8d000810, // 16: Move remaining bytes of CW only to RS decoder
   0x40e80898, // 17: Jump LINE_14, cnt < ZR_DEPTH 0,

   //*************** Initialise ILV1 counters ***************************************************************************************
   0x30000cd8, // 18: WR_REG(`DEST(ZR_ILV_CNTRS1+0x000), `ACCESS_MODE(WR_REG_16), `WR_MODE(WR_REG_OVER), `WR_MASK(16'h  0000))
   0x30000cda, // 19:  WR_REG(`DEST(ZR_ILV_CNTRS1+0x002), `ACCESS_MODE(WR_REG_16), `WR_MODE(WR_REG_OVER), `WR_MASK(16'h  0000))
   0x30000cdc, // 20:  WR_REG(`DEST(ZR_ILV_PMS_CNTRS1+0x000), `ACCESS_MODE(WR_REG_16),`WR_MODE(WR_REG_OVER), `WR_MASK(16'h  0000))
   0x30000cde, // 21: WR_REG(`DEST(ZR_ILV_PMS_CNTRS1+0x002), `ACCESS_MODE(WR_REG_16),`WR_MODE(WR_REG_OVER), `WR_MASK(16'h  0000))
   0x30000ce2, // 22:  WR_REG(`DEST(ZR_ILV_PMD_CNTRS1+0x002), `ACCESS_MODE(WR_REG_16),`WR_MODE(WR_REG_OVER), `WR_MASK(16'h  0000))
   0x30000ce0, // 23: WR_REG(`DEST(ZR_ILV_PMD_CNTRS1+0x000), `ACCESS_MODE(WR_REG_16),`WR_MODE(WR_REG_OVER), `WR_MASK(16'h  0000))

   0x30000cd2, // 24: WR_REG(`DEST(ZR_ILV_MIN_FULLNESS0+0x002), `ACCESS_MODE(WR_REG_16), `WR_MODE(WR_REG_OVER), `WR_MASK(16'h  0000))
   0x30000cce, // 25: WR_REG(`DEST(ZR_ILV_MAX_FULLNESS0+0x002), `ACCESS_MODE(WR_REG_16),`WR_MODE(WR_REG_OVER), `WR_MASK(16'h  0000))
   0x300c80d0, // 26: WR_REG(`DEST(ZR_ILV_MIN_FULLNESS0+0x000), `ACCESS_MODE(WR_REG_16), `WR_MODE(WR_REG_OVER), `WR_MASK(16'h  0000))
   0x300c80cc, // 27: WR_REG(`DEST(ZR_ILV_MAX_FULLNESS0+0x000), `ACCESS_MODE(WR_REG_16),`WR_MODE(WR_REG_OVER), `WR_MASK(16'h  0000))
   //********************************************************************************************************************************
   0x40020000, // 28: JUMP(0)  // END_FOREVER



   // Code block 3 memory
   // Move metrics from METRIC FIFO to the RS Decoder
   0x6e008002, // 0: Input from FP2, output null
   0x80000001, // 1: MOV(1)  // Move the first byte (which is for synchro) to NULL
   0x6c11c011, // 2: SET_IO(`IN(RSDEC_MET), `OUT(RSDEC_MET))
   0x80000810, // 3: MOV(`R(ZR_CODEWORD+0x000,0))  // Move N bytes from metric FIFO to RSD metric
   0x40020000, // 4: JUMP(0)  // Restart

   // Code block 4 memory
   // Moves correct bytes from the reed solomon to the descrambler
   0x30000c40, // 0: WR_REG, <reg_mode>=3, <byte_addr>=0x40    LSW //Reset Scrambler ZR_SCR_OFFSET                (0x40)
   0x30000c42, // 1: WR_REG, <reg_mode>=3, <byte_addr>=0x42    MSW //Reset Scrambler ZR_SCR_OFFSET                (0x40)
   0x89000811, // 2: MOV(`R(ZR_CODEWORD+0x001,0), `IN(RS_D))  // Move K bytes from RSD to the scrambler
   0x40280818, // 3: Jump, <repeat>=1, <use_reg>=1, <reg_id>=0x18  // Repeat(Q), ZR_FRAMING stores Q
   0x40020000, // 4: JUMP(0)  // Restart

// Code block 5 memory
//START_FP5_L0:
   0x6e00c00e, //   0('h00021):SET IO('IN(SCR_D), OUT(NULL_DEST=1))
   0x20000c04, //   1('h00022):WR_REG('R(ZR_R4+0x000), BAD_DTU = 0, Clear
   0x80000001, //   2('h00023):MOV 1 byte (SID) to ZR_CRC1+2
   0x28000036, //   3('h00023):MOV Last Received 1 byte (SID) to ZR_CRC1+2
   0x80000001, //   4('h00023):MOV 1 byte (TS) to ZR_CRC1+3
   0x28000037, //   5('h00023):MOV Last Received 1 byte (TS) to ZR_CRC1+3
   0x80000819, //   6('h00025):MOV ('R(ZR_FRAMING+0x001,1)) V bytes to null_dest
   0x8d80081a, //   7('h00026):MOV (K-V-2) bytes to ILVIF <block_id>=24

//IS_CW_OK_L_8:
   0x40a04000, //   8('h00027):JUMP(CW_OK_L10, IF_FLAG != 0x4), i.e CW = OK;(SET_RST=0, FLAG_MASK=0x4)
   0x20001c04, //   9('h00028):WR_REG(`R(ZR_R4 +0x000),REG_MODE('11'),OVER_REG_WITH_MASK),MASK = 1; BAD_CW=1;

//CW_OK_L10:
   0x40c80818, //   10('h00029):JUMP(TRANS_CW_L12, END_WHILE_CNT_LT(`R(ZR_FRAMING+0x000,0)))
   0x40e20000, //   11('h00038):JUMP(TRANS_DONE_L14)
//TRANS_CW_L12:
   0x8d800811, //   12('h0002a):MOV('R(ZR_CODEWORD+0x001,1)) K bytes to ILVIF <block_id>=24
   0x40820000, //   13('h00038):JUMP(IS_CW_OK_L_8)

//TRANS_DONE_L14:
   0x6000E055, //   14           SET_IO(Input Enabled, Input Master,Input Null SRC,  Input CONST(0x55); DTU size to be 32bit aligned, hence stuff the constant to inc WRAD
   0x8d800835, //   15           Move No of stuffing bytes available at (ZR_CRC1+0x0001, 1) to ILVBIF

   0x6c18e836, //   16('h0002e):SET_IO('OUT(ILVBIF), INPUT('R(ZR_CRC1+0x02))) (R'(ZR_CRC1+0x02))==> SID
   0x80000001, //   17('h0002f):MOV 1 byte

   0x6c18e837, //   18('h0002e):SET_IO('OUT(ILVBIF), INPUT('R(ZR_CRC1+0x03))) (R'(ZR_CRC1+0x02))==> TS
   0x80000001, //   19('h0002f):MOV 1 byte

   0x6c18e804, //   20('h0002e):SET_IO('OUT(ILVBIF), INPUT('R(ZR_R4+0x00))) (R'(ZR_R4+0x00))==> BAD_CW
   0x80000001, //   21('h0002f):MOV 1 byte

   0x20034192, //   22           WR_REG(ZR_CRC1 + 0x0000 ==> ZR_UPROC5_STATE0 + 0x0002) Copy 8bit data from ZR_CRC1 + 0x0000 to ZR_UPROC5_STATE0 + 0x0002
   0x41bc0004, //   23          JUMP(FP5_INC_Qrx_WRITE_COUNT_L27 , REPEAT, KEEP_CNT, END_WHILE_CNT_LT(0x4)), Added to increment the counter
   0x20000d92, //   24           WR_REG(Data_Mask0(0) ==> ZR_UPROC5_STATE0 + 0x0002) Clear repeat counter at FP5

   0x30028058, //   25('h0004b): WR_REG: LSW ZR_ILV_WRAD(0x58) = LSW_RETX_QUEUE_BASE_AD(0x28); LSW 1st DTU Address (0x28)  //ZR_CR0_LP1
   0x3002a05a, //   26('h0004c): WR_REG: LSW ZR_ILV_WRAD(0x5a) = LSW_RETX_QUEUE_BASE_AD(0x2a); MSW 1st DTU Address (0x2a)

//FP5_INC_Qrx_WRITE_COUNT_L27
   0x20192034, //   27           WR_REG(ZR_UPROC5_STATE0 + 0x0002 ==> ZR_CRC1 + 0x0000) Copy 8bit data from ZR_UPROC5_STATE0 + 0x0002 to ZR_CRC1 + 0x0001
   0x20000d92, //   28           WR_REG(Data_Mask0(0) ==> ZR_UPROC5_STATE0 + 0x0002) Clear repeat counter at FP5
   0x41e80001, //   29           JUMP(FP5_CLR_KEEP_CNT_BIT_L30 , REPEAT(0x1),END_WHILE_CNT_LT(0x01))), Clear Keep count bit
//FP5_CLR_KEEP_CNT_BIT_L30
   0x6e00e834, //   30('h00034):SET_IO('OUT(NULL), INPUT('R(ZR_CRC1+0x0))) (R'(ZR_CRC1x0))==> Read Idx counter
   0x80000001, //   31('h00035):MOV 1 byte
   0x42410101, //   32('h00036):JUMP(RX_Q_READ_IDX_1_FP5_L36 if IDX ==1, SET_RST=1, DATA_JUMP=1,MATCH_DATA=1)
   0x42710102, //   33('h00036):JUMP(RX_Q_READ_IDX_2_FP5_L39 if IDX ==2, SET_RST=1, DATA_JUMP=1,MATCH_DATA=2)
   0x42a10103, //   34('h00036):JUMP(RX_Q_READ_IDX_2_FP5_L42 if IDX ==3, SET_RST=1, DATA_JUMP=1,MATCH_DATA=3)
   0x40020000, //   35('h00038):JUMP(START_FP5_L0)

//RX_Q_READ_IDX_1_FP5_L36:
   0x3001c058, //   36('h0004b): WR_REG: LSW ZR_ILV_WRAD(0x58) = LSW 2nd DTU Address (0x1c)                               //ZR_OHRATE_LP1
   0x3001e05a, //   37('h0004c): WR_REG: LSW ZR_ILV_WRAD(0x5a) = MSW 2nd DTU Address (0x1e)
   0x40020000, //   38('h00038):JUMP(START_FP5_L0)

//RX_Q_READ_IDX_2_FP5_L39
   0x30060058, //   39('h0004b): WR_REG: LSW ZR_ILV_WRAD(0x58) = LSW 3rd DTU Address (0x60)                               //ZR_ILVB_WRPTR_LP1
   0x3006205a, //   40('h0004c): WR_REG: LSW ZR_ILV_WRAD(0x5a) = MSW 3rd DTU Address (0x62)
   0x40020000, //   41('h00038):JUMP(START_FP5_L0)

//RX_Q_READ_IDX_2_FP5_L42
   0x30014058, //   42('h0004b): WR_REG: LSW ZR_ILV_WRAD(0x58) = LSW 4th DTU Address (0x14)                               //ZR_VBC_SIZE_LP1
   0x3001605a, //   43('h0004c): WR_REG: LSW ZR_ILV_WRAD(0x5a) = MSW 4th DTU Address (0x16)
   0x40020000, //   44('h00038):JUMP(START_FP5_L0)


   // Code block 6 memory
   // Delivers the DTUs to the TC layer from ReTx reordered buffer using FIFO3 interface from
   //IIBRAM Locations 0x4C000, 0x4D000, 0x4E000, 0x4F000
// Tested and working with 4 DTU/DMT symbol from line 0 to 29  - Start //////////////////
//FP6_START_L0
   0x6e00e80c, //   0('h0003e): SET_IO: input=0xC (XDTUs), output null,
   0x80000001, //   1('h0003f): MOV 1 byte
   0x41C10100, //   2('h00040): JUMP(FP6_NO_DTUS_TO_FWD_EXIT_L28, line 28),  match_data = 0, data_jump= 1

//FP6_SET_1ST_DTU_BASE_ADDR_L3
   0x3c000c8c, //   3('h00005): WR_REG(`DEST(ZR_FIFO_PTRS3+0x000), `ACCESS_MODE(WR_REG_16), `WR_MODE(WR_REG_OVER), `WR_MASK(16'h  c000)) Set 1st DTUs Lower 16bit address
//FP6_SET_FIFO3_WRPTR_RDPTR_L4
   //Reset FIFO3 WRPTR to Max Value 4095 and RDPTR to "0" as Beginning of the queue
   0x30fffc90, //   4('h00005): WR_REG(`DEST(ZR_FIFO_PTRS3+0x000), `ACCESS_MODE(WR_REG_16), `WR_MODE(WR_REG_OVER), `WR_MASK(16'h  0fff)) WRPTR to 4095
   0x30000c92, //   5('h00006): WR_REG(`DEST(ZR_FIFO_PTRS3+0x002), `ACCESS_MODE(WR_REG_16), `WR_MODE(WR_REG_OVER), `WR_MASK(16'h  0000)) RDPTR to 0

//FP6_START_FORWARD_L3
   0x6c16c01f, //   6('h0003c): SET_IO: input=31 FIFO3 master, output=22 TC-LAYER master
   0x80022c0e, //   7('h0003c): MOV: (QH - V - 2) bytes, <use_reg>=1, <reg_id>=0x0e, <flag_mode>=2, <flag_mask>=2

   0x2000d1a6, //   8           WR_REG(ZR_R12 + 0x0001 ==> ZR_UPROC6_STATE0 + 0x0002) Copy 8bit data from ZR_R12 + 0x0001 to ZR_UPROC6_STATE0 + 0x0002
   0x40dc080c, //   9           JUMP(FP6_INC_DTU_FWD_COUNT_L13 , REPEAT, KEEP_CNT, END_WHILE_CNT_LT(R(ZR_R12+0x000))), Added to increment the counter
   0x201a600d, //   10          WR_REG( ZR_UPROC6_STATE0 + 0x0002 ==> ZR_R12 + 0x0001) Copy 8bit data from ZR_UPROC6_STATE0 + 0x0002 to ZR_R12 + 0x0001
   0x200001a6, //   11          WR_REG(Data_Mask0(0) ==> ZR_UPROC6_STATE0 + 0x0002) Clear repeat counter at FP6
   0x41C20000, //   12('h00038) JUMP(FP6_NO_DTUS_TO_FWD_EXIT_L28)

//FP6_INC_DTU_FWD_COUNT_L13
   0x201a600d, //   13           WR_REG(ZR_UPROC6_STATE0 + 0x0002 ==> ZR_R12 + 0x0001) Copy 8bit data from ZR_UPROC6_STATE0 + 0x0002 to ZR_R12 + 0x0001
   0x20000da6, //   14           WR_REG(Data_Mask0(0) ==> ZR_UPROC6_STATE0 + 0x0002) Clear repeat counter at FP6
   0x41080001, //   15           JUMP(FP6_CLR_KEEP_CNT_BIT_L16 , REPEAT(0x1),END_WHILE_CNT_LT(0x01))), Clear Keep count bit

//FP6_CLR_KEEP_CNT_BIT_L16
   0x6e00e80d, //   16('h00034): SET_IO('OUT(NULL), INPUT('R(ZR_R12+0x1))) (R'(ZR_R12 + 1))==> Read DTU forward Idx counter
   0x80000001, //   17('h00035): MOV 1 byte
   0x41610101, //   18('h00036): JUMP(FP6_SET_2ND_DTU_BASE_ADDR_L22 if IDX ==1, SET_RST=1, DATA_JUMP=1,MATCH_DATA=1)
   0x41810102, //   19('h00036): JUMP(FP6_SET_3RD_DTU_BASE_ADDR_L24 if IDX ==2, SET_RST=1, DATA_JUMP=1,MATCH_DATA=2)
   0x41A10103, //   20('h00036): JUMP(FP6_SET_4TH_DTU_BASE_ADDR_L26 if IDX ==3, SET_RST=1, DATA_JUMP=1,MATCH_DATA=3)
   0x41C20000, //   21('h00038): JUMP(FP6_NO_DTUS_TO_FWD_EXIT_L28)

//FP6_SET_2ND_DTU_BASE_ADDR_L22
   0x3d000c8c, //   22('h00005): WR_REG(`DEST(ZR_FIFO_PTRS3+0x000), `ACCESS_MODE(WR_REG_16), `WR_MODE(WR_REG_OVER), `WR_MASK(16'h  c000)) Set 2nd DTUs Lower 16bit address
   0x40420000, //   23('h00038): JUMP(FP6_SET_FIFO3_WRPTR_RDPTR_L4) //Reset FIFO3 WRPTR to Max Value 4095 and RDPTR to "0" as Beginning of the queue

//FP6_SET_3RD_DTU_BASE_ADDR_L24
   0x3e000c8c, //   24('h00005): WR_REG(`DEST(ZR_FIFO_PTRS3+0x000), `ACCESS_MODE(WR_REG_16), `WR_MODE(WR_REG_OVER), `WR_MASK(16'h  c000)) Set 2nd DTUs Lower 16bit address
   0x40420000, //   25('h00038): JUMP(FP6_SET_FIFO3_WRPTR_RDPTR_L4) //Reset FIFO3 WRPTR to Max Value 4095 and RDPTR to "0" as Beginning of the queue

//FP6_SET_4TH_DTU_BASE_ADDR_L26
   0x3f000c8c, //   26('h00005): WR_REG(`DEST(ZR_FIFO_PTRS3+0x000), `ACCESS_MODE(WR_REG_16), `WR_MODE(WR_REG_OVER), `WR_MASK(16'h  c000)) Set 2nd DTUs Lower 16bit address
   0x40420000, //   27('h00038): JUMP(FP6_SET_FIFO3_WRPTR_RDPTR_L4) //Reset FIFO3 WRPTR to Max Value 4095 and RDPTR to "0" as Beginning of the queue

//FP6_NO_DTUS_TO_FWD_EXIT_L28
   0x00004000, //   28('h0003f) : WAIT for frame next frame
   0x40020000, //   29('h00040): JUMP(0)  // Restart


// Code block 7 memory
// FP7 is not being used


// Code block 8 memory
   0x6c148000, // 0: output ILV0, input Fp0
   0x80000810, // 1:
   0x40180898, // 2: Jump to ilne 1, if CNT < ZR_DEPTH,0
   0x30000cac, // 3: WR_REG(`DEST(ZR_ILV_MIN_FULLNESS0+0x000), `ACCESS_MODE(WR_REG_16), `WR_MODE(WR_REG_OVER), `WR_MASK(16'h  0000))
   0x30000cae, // 4: WR_REG(`DEST(ZR_ILV_MIN_FULLNESS0+0x002), `ACCESS_MODE(WR_REG_16), `WR_MODE(WR_REG_OVER), `WR_MASK(16'h  0000))
   0x30000ca8, // 5: WR_REG(`DEST(ZR_ILV_MAX_FULLNESS0+0x000), `ACCESS_MODE(WR_REG_16),`WR_MODE(WR_REG_OVER), `WR_MASK(16'h  0000))
   0x30000caa, // 6: WR_REG(`DEST(ZR_ILV_MAX_FULLNESS0+0x002), `ACCESS_MODE(WR_REG_16),`WR_MODE(WR_REG_OVER), `WR_MASK(16'h  0000))
// Writing to ILV1
   0x6c158000, // 7: output ILV1, input Fp0
   0x80000810, // 8:
   0x40880898, // 9: Jump to ilne 8, if CNT < ZR_DEPTH,0
   0x30000cd0, // 10: WR_REG(`DEST(ZR_ILV_MIN_FULLNESS0+0x000), `ACCESS_MODE(WR_REG_16), `WR_MODE(WR_REG_OVER), `WR_MASK(16'h  0000))
   0x30000cd2, // 11: WR_REG(`DEST(ZR_ILV_MIN_FULLNESS0+0x002), `ACCESS_MODE(WR_REG_16), `WR_MODE(WR_REG_OVER), `WR_MASK(16'h  0000))
   0x30000ccc, // 12: WR_REG(`DEST(ZR_ILV_MAX_FULLNESS0+0x000), `ACCESS_MODE(WR_REG_16),`WR_MODE(WR_REG_OVER), `WR_MASK(16'h  0000))
   0x30000cce, // 13: WR_REG(`DEST(ZR_ILV_MAX_FULLNESS0+0x002), `ACCESS_MODE(WR_REG_16),`WR_MODE(WR_REG_OVER), `WR_MASK(16'h  0000))
   0x40020000, // 14: JUMP(0)  // Restart
   0x80000000, // 15: Nop


// Code block 9 memory
// FP9 is not being used



   // Program will require these registers:
   //   ZR_CODEWORD+0x000 [7:0] - FEC Codeword size
   //   ZR_CODEWORD+0x001 [7:0] - Kp = N - R
   //   ZR_FRAMING+0x000 [15:0] - Set to SEQp
   //   ZR_FRAMING+0x002 [7:0] - Parameter Tp
   //   ZR_FRAMING+0x003 [7:0] - Number of mux frmaes with ceil(Gp/Tp) OH bytes
   //   ZR_ILV_PARAMS0+0x001 [7:0] - Interleaver Block Size
   //   ZR_OHRATE+0x000 [7:0] - ceil(Gp/Tp)
   //   ZR_OHRATE+0x001 [7:0] - floor(Gp/Tp)
   //   ZR_OHRATE+0x002 [15:0] - ceil(Gp/Tp)
   //   ZR_PMS_SIZE+0x000 [15:0] - Set to number of bytes to transfer this symbol
   //   ZR_R8+0x000 [15:0] - Set to D - floor(D/I) - 1
   //   ZR_VBC_SIZE+0x000 [15:0] - BC1 size = Bp1
   // Code block 2 will modify these registers:
   //   ZR_ILV_FULLNESS0+0x000 [15:0] - Reset fullness to 0 after each iblock
   //   ZR_ILV_MAX_FULLNESS0+0x000 [7:0] -
   //   ZR_ILV_MAX_FULLNESS0+0x001 [7:0] -
   //   ZR_ILV_MAX_FULLNESS0+0x002 [15:0] - Set MAX_FULLNESS to 0x3FFFF
   //   ZR_ILV_MIN_FULLNESS0+0x000 [15:0] -
   //   ZR_ILV_MIN_FULLNESS0+0x002 [15:0] - Set MIN_FULLNESS to 0
   // Code block 7 will modify these registers:
   //   ZR_R0+0x000 [7:0] - SEQP Done
   //   ZR_R4 + 0x0
   //   ZR_CRC1 [31:24] = TS   (Micro code  store temporarily
   //   ZR_CRC1 [23:16] = SID  (Micro code  store temporarily
};
//<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<

DATA_MAP_END;
//XDSLRTFW-1617 (End)



