/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2004 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;   Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;   Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;   File Name: afeif_iof.c
;
;   AFE IF core i/o functions.
;
*****************************************************************************/
#include "common.h"
#include "gdata.h"
#include "LL_IOf.h"
#include "afeif_memmap.h"
#include "cri_memmap.h"
#include "ft_memmap.h"
#include "cmv.h"


/*****************************************************************************
;   Prototype: void InitializeForLoopbackMode()
;
;   This function currently does nothing.
;
;   Input Arguments:
;
;   Output Arguments:
;
;   Return:
;
;   Global Variables:
;****************************************************************************/

#ifdef ENABLE_SHOW_LPBK
void InitializeForLoopbackMode(void)
{
   //Disable TX/RX QT stall in lpbk test
   gft_EnableQtStall = FALSE;

   //Configure RX_FFT_STALL_CTL register such that
   //FFT done is generated by the actual done
   //RX_FFT_DONE_SEL = 3 (actual done)
   WriteCoreReg(CRI_RX_FFT_STALL_CTL_ADDR, (3<<20));

   //Following change is to speed up the COCOMO test by
   //reducing the number of samples per frame
   //we can do this only if strymon is not run


   //We need to change the time slot control accordingly for
   //gs_NumSamplesPerDmtSymbol of 12.
   //Note the ratio of the high speed clock rate to the sampling rate
   //is 282.624/35.328 = 8.
   //Thus, the number of clock cycles per the time-slot is
   //gs_NumSamplesPerDmtSymbol*8/4 = gs_NumSamplesPerDmtSymbol*2 = 24
   //NUM_TS = 3
   //NUM_CLKS = gs_NumSamplesPerDmtSymbol*2 = 24
   //CLKS_LAST = 0
   //TSC_ENABLE = 0 (will enable TSC right at LinkStart)

   //For HW test, we do not want to reduce the number of clocks per slot
   SetCoreReg(CRI_TSC_CTRL_ADDR, (1 << 31));

}

#endif //#ifdef ENABLE_SHOW_LPBK

