/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 1998-2006 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *----------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Condfidential
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276-4000
 *   FAX   (781) 276-4001
 *
 *   cri_ini.c
 *
 *   init Clock, Reset, Interrupt (CRI) block core interface function
 *
 *
 *----------------------------------------------------------------------------
 */

#include "common.h"
#include "cri_cocomo_interface.h"
#include "LL_IOf.h"
#include "cri_memmap.h"
#include "gdata.h"
#include "cri_iof.h"
#include "dsp_regs_62.h"

//*************************************************
//
#ifdef INCLUDE_NON_CACHE_FUNCTIONS
//
//*************************************************


void InitCRI(void)
{

   /* ===============================================   */
   /* Enable clocks                           */
   /* ===============================================   */


   //Configure the transmit timeslot settings for current port (0 or 1),
   //as set by the DSP's port-select setting
   if(guc_ch_id == 0)
   {

#define TX_QTP_TS_PORT0_4K   (0)
#define TX_PMS_TS_PORT0_4K   (0)
#define TX_QT_TS_PORT0_4K   (1)
#define TX_IFFT_TS_PORT0_4K   (0x1F)   //inactive
#define TX_PAR_TS_PORT0_4K   (0x1F)   //inactive
#define TX_DSP_TS_PORT0_4K   (3)

      WriteCoreReg(CRI_TX_TSLOTC_A_ADDR, (TX_QTP_TS_PORT0_4K    |(TX_PMS_TS_PORT0_4K<<5)|
                                          (TX_QT_TS_PORT0_4K<<10)|(TX_IFFT_TS_PORT0_4K<<15)|
                                          (TX_PAR_TS_PORT0_4K<<20)|(TX_DSP_TS_PORT0_4K<<25)));
   }
   else if(guc_ch_id == 1)
   {

#define TX_QTP_TS_PORT1_4K   (2)
#define TX_PMS_TS_PORT1_4K   (2)
#define TX_QT_TS_PORT1_4K   (3)
#define TX_IFFT_TS_PORT1_4K   (0x1F)   //inactive
#define TX_PAR_TS_PORT1_4K   (0x1F)   //inactive
#define TX_DSP_TS_PORT1_4K   (1)

      WriteCoreReg(CRI_TX_TSLOTC_A_ADDR, (TX_QTP_TS_PORT1_4K    |(TX_PMS_TS_PORT1_4K<<5)|
                                          (TX_QT_TS_PORT1_4K<<10)|(TX_IFFT_TS_PORT1_4K<<15)|
                                          (TX_PAR_TS_PORT1_4K<<20)|(TX_DSP_TS_PORT1_4K<<25)));
   }

   //Skip CRI_TX_TSLOTC_B (it is for port 2 or 3)
   //skip CRI_TX_TSLOTx, 0, 1, 2, 3

   //Configure the receive timeslot settings for Port 0 or 1
   if(guc_ch_id == 0)
   {

#define RX_QTP_TS_PORT0_4K   (1)
#define RX_FFT_TS_PORT0_4K   (0x1F)   //inactive
#define RX_QT_TS_PORT0_4K   (2)
#define RX_PMS_TS_PORT0_4K   (0)
#define RX_DSP_TS_PORT0_4K   (3)

      WriteCoreReg(CRI_RX_TSLOTC_A_ADDR, ((RX_QTP_TS_PORT0_4K<<0)|(RX_FFT_TS_PORT0_4K<<5)|
                                          (RX_QT_TS_PORT0_4K<<10)|(RX_PMS_TS_PORT0_4K<<15)|(RX_DSP_TS_PORT0_4K<<25)));
   }
   else if(guc_ch_id == 1)
   {

#define RX_QTP_TS_PORT1_4K   (3)
#define RX_FFT_TS_PORT1_4K   (0x1F)   //inactive
#define RX_QT_TS_PORT1_4K   (0)
#define RX_PMS_TS_PORT1_4K   (2)
#define RX_DSP_TS_PORT1_4K   (1)

      WriteCoreReg(CRI_RX_TSLOTC_A_ADDR, ((RX_QTP_TS_PORT1_4K<<0)|(RX_FFT_TS_PORT1_4K<<5)|
                                          (RX_QT_TS_PORT1_4K<<10)|(RX_PMS_TS_PORT1_4K<<15)|(RX_DSP_TS_PORT1_4K<<25)));
   }

   //Skip CRI_RX_TSLOTC_B
   //skip CRI_RX_TSLOTx, x = 0, 1, 2, 3
   //skip CRI_TX_ATSLOTC_x, x = A, B
   //skip CRI_TX_ATSLOTx, x= 0, 1, 2, 3
   //skip CRI_RX_ATSLOTC_x, x = A, B
   //skip CRI_RX_ATSLOTx, x= 0, 1, 2, 3

   //skip CRI_RXGP0_CTL
   //skip CRI_RXGP1_CTL
   //skip CRI_TXGP0_CTL
   //skip CRI_TXGP1_CTL
   //skip CRI_RXGP0_VAL
   //skip CRI_RXGP1_VAL
   //skip CRI_TXGP0_MCNT
   //skip CRI_TXGP1_MCNT


   //skip CRI_MASK0_TX
   //skip CRI_MASK1_TX
   //skip CRI_MASK1_RX

   //skip CRI_STATUS0
   //skip CRI_STATUS1

   //skip CRI_AMASK0_TX
   //skip CRI_AMASK1_TX
   //skip CRI_AMASK1_RX


   //skip CRI_EVENT


   //Disable TX/RX timer
   WriteCoreReg(CRI_TX_TIMER_CTL_ADDR, 0);
   WriteCoreReg(CRI_RX_TIMER_CTL_ADDR, 0);

   //Clear TX/RX timer
   WriteCoreReg(CRI_TX_TIMER_ADDR, 0);
   WriteCoreReg(CRI_RX_TIMER_ADDR, 0);

   //Enable TX timer counter
#define TX_TIM_RLVR      (0)   //set roll over on TX buffer swap
#define TX_TIM_ENB      (1) //Enable TX timer counter
#define TX_TIM_START   (1) //Start timer at the first rollover

   WriteCoreReg(CRI_TX_TIMER_CTL_ADDR, (TX_TIM_RLVR<<21)|(TX_TIM_ENB<<20)|(TX_TIM_START<<28));

   // Enable RX timer counter and set roll over on RX buffer swap
#define RX_TIM_RLVR      (0)   //set roll over on TX buffer swap
#define RX_TIM_ENB      (1) //Enable TX timer counter
#define RX_TIM_START   (1) //Start timer at the first rollover

   WriteCoreReg(CRI_RX_TIMER_CTL_ADDR, (RX_TIM_RLVR<<21)|(RX_TIM_ENB<<20)|(RX_TIM_START<<28));

   //Configure TX PMS
   //Disable TX PMS for now, it should be configured to tx time-slot start later
   //TX_PMS_REG_START = 0
   //TX_PMS_START_SEL = 0
   //TX_PMS_GO_CNT = 0
   WriteCoreReg(CRI_TX_PMS_CTL_ADDR, 0x0);

   //Disable all the cores and they will be enabled at LinkStart by function EnableCores_ForLinkStart()
   WriteCoreReg(CRI_TX_QTP_CTL_ADDR, 0);
   WriteCoreReg(CRI_TX_QT_CTL_ADDR, 0);
   WriteCoreReg(CRI_TX_IFFT_CTL_ADDR, 0);
   WriteCoreReg(CRI_RX_FFT_CTL_ADDR, 0);
   WriteCoreReg(CRI_RX_QT_CTL_ADDR, 0);
   WriteCoreReg(CRI_RX_QTP_CTL_ADDR, 0);

   //Configure RX PMS
   //Disable RX PMS for now, it should be configured to rx time-slot start later
   //RX_PMS_REG_START = 0
   //RX_PMS_START_SEL = 0
   //RX_PMS_GO_CNT = 0
   WriteCoreReg(CRI_RX_PMS_CTL_ADDR, 0x0);

   //Configure TX_QT_STALL register (but do not enable it yet)

   //First reset this register to the power-on state
   WriteCoreReg(CRI_TX_QT_STALL_ADDR, 0xE0000);

#define TX_QT_STALL_DIS      (0)   //disable
#define TX_QT_START_DROP   (1) //write 1 to clear this bit

   WriteCoreReg(CRI_TX_QT_STALL_ADDR, ((CRI_TX_QT_STALL_CLKS_4K)|(TX_QT_STALL_DIS<<16)|(TX_QT_START_DROP<<17)));

   //Configure RX_QT_STALL register (but do not enable it yet)

   //First reset this register to the power-on state
   WriteCoreReg(CRI_RX_QT_STALL_ADDR, 0xE0000);

#define RX_QT_STALL_DIS      (0)   //disable
#define RX_QT_START_DROP   (1) //write 1 to clear this bit

   WriteCoreReg(CRI_RX_QT_STALL_ADDR, ((CRI_RX_QT_STALL_CLKS_4K)|(RX_QT_STALL_DIS<<16)|(RX_QT_START_DROP<<17)));

   //Default is to enable QT stall (in InitCRI_ForLinkStart())
   gft_EnableQtStall = TRUE;

   //Configure RX_FFT_STALL_CTL register
#if 1
   //Configure RX_FFT_STALL_CTL register such that
   //FFT done is generated by the actual done
   //RX_FFT_DONE_SEL = 3 (actual done)
   WriteCoreReg(CRI_RX_FFT_STALL_CTL_ADDR, (3<<20));
#else

#define RX_FFT_REG_DONE      (0)   //(no action)
#define RX_FFT_DONE_SEL      (2) //(timer based)

   WriteCoreReg(CRI_RX_FFT_STALL_CTL_ADDR, (CRI_FFT_STALL_CTL_FFT_DONE_CLKS|(RX_FFT_DONE_SEL<<20)|(RX_FFT_REG_DONE<<23)));
#endif

   //disable NTR regeneration logic here and it is enabled before showtime
   WriteCoreReg(CRI_NTR_CPE_CTRL_ADDR, 0);

} //void InitCRI(void)


//*************************************************
//
#endif // #ifdef INCLUDE_NON_CACHE_FUNCTIONS
//
//*************************************************


//*************************************************
//
#ifdef INCLUDE_CACHE_FUNCTIONS
//
//*************************************************

extern int32 gl_CurrentStackPointer;
extern int32 gl_MaxBgDuration;
extern uint8 guc_KernelState;                  // first interrupts or not

void HwResetInit(int32 l_Port, int32 l_StackPointer)
{

   guc_ch_id = (uint8)l_Port;
   gl_CurrentStackPointer = l_StackPointer;
   guc_PortMode = gt_PortModeControl.uc_DualPortModeCurrent;
   gt_PortModeControl.uc_MaxBgDuration = MAX_BG_DURATION;
   gt_PortModeControl.uc_BgDuration = MAX_BG_DURATION;
   guc_KernelState = 0;


   if (l_Port == 0)
   {
      guc_adma_reg_offset = 0;
      guc_xdma_reg_offset = 0;
   }
   else
   {
      guc_adma_reg_offset =  DSP_ADMA1_CTRL - DSP_ADMA0_CTRL;
      guc_xdma_reg_offset = DSP_XDMA1_CTRL - DSP_XDMA0_CTRL;
   }

   SoftResetCores();

}



//*************************************************
//
#endif // ifdef INCLUDE_CACHE_FUNCTIONS
//
//*************************************************
