/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2005 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: ddsnrfdq_iof.c
*
*   This file contains engine interface functions to be used during showtime
*   for DD SNR & FDQ.
*
*-------------------------------------------------------------------------------
*/
#include "common.h"
#include "gdata.h"
#include "LL_IOf.h"
#include "qt_memmap.h"
#include "acc40.h"


#ifdef INCLUDE_SHOWTIME_DD_SNR_FDQ_IOF
/*
*-------------------------------------------------------------------------------
*
*   Prototype: void SetUpRTVForDDSnrFdqHandler(void)
*
*   This function sets up RTV buffer for decision-directed SNR/FDQ calculation.
*   Iridia Registers Set: QT_REG_RX_MISC, QT_REG_RX_FD_RNG0 , QT_REG_RX_FD_RNG1
*
*   Input Arguments: None, Used as LoadingFunction
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*     guc_SNRFDQControl: Used to control whether HW based SNR is used.
*
*-------------------------------------------------------------------------------
*/
void SetUpRTVForDDSnrFdqHandler(void)
{
   uint32 ul_data;

   //First disable IR_REIM_ACCUM, IR_NPR_ACCUM and VECPOW_ACCUM
   ResetCoreReg(IRI_QT_REG_RX_MISC_ADDR, (uint32)(0x7<<21));

   ReadCoreReg(IRI_QT_REG_RX_FD_RNG0_ADDR, &ul_data);

   //Preserve the RTV offset
   ul_data &= RTV_OFFSET_MASK;

   ul_data |= MASK_BIT28 // disable tone rotation using PRBS
         | (0 << 31);               //disable RTV0

   /* HW Snr update */
   // enable Error Accummulation in RTV 0
   ul_data |= (ERROR_OUTPUT << 25); // write Error output to RTV buffer 0
   WriteCoreReg(IRI_QT_REG_RX_FD_RNG0_ADDR, ul_data);

   ul_data = (gs_AlgNumTonesToProcess-1);
   WriteCoreReg(IRI_QT_REG_RX_FD_RNG0_CNT_35B_ADDR, ul_data);
   //Enable IR_NPR_ACCUM
   SetCoreReg(IRI_QT_REG_RX_MISC_ADDR, (uint32)(1<<22));

   //Disable RTV1
   ResetCoreReg(IRI_QT_REG_RX_FD_RNG1_ADDR, (1<<31));

}
#endif // INCLUDE_SHOWTIME_DD_SNR_FDQ_IOF

#ifdef HW_SNR_FDQ

// Support for  HW_SNR_FDQ in the 6.2 HWengine.
// Functions to support the HW based SNR and FDQ.


#ifdef INCLUDE_SHOWTIME_DD_SNR_FDQ_IOF

/*
*-------------------------------------------------------------------------------
*
*   Prototype: void EnableFDQAdapt(void)
*
*   This functions enables the HW based FDQ adaptation.
*   Curently defaulted to signLms mode. We could promote the control to a cmv bit later.
*   Sets IRIDIA REG: QT_REG_RX_FDQADAPT
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*      gs_DDFdqAdaptSlew -- (I) the shift to control the FDQ adaptation speeed: mu = 2^gs_DDFdqAdaptSlew
*-------------------------------------------------------------------------------
*/

void EnableFDQAdapt(void)
{

   int8 uc_signLms = 1;
   uint32 ul_data;

   ul_data = ( ( gs_DDFdqAdaptSlew << 4) | (1<<3) | (uc_signLms<<1) | 1 );
   WriteCoreReg(IRI_QT_REG_RX_FDQADAPT_ADDR, ul_data);

}

void DisableFDQAdapt(void)
{
   ResetCoreReg(IRI_QT_REG_RX_FDQADAPT_ADDR, 1); //clear LSb to disable.
}



#endif   // INCLUDE_SHOWTIME_DD_SNR_FDQ_IOF


#endif // HW_SNR_FDQ

