/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _A_STR_INI_H
#define _A_STR_INI_H

// -------- Strymon constants ---------------------------
#define INTERP_PHASE_LENGTH_512_TONES  (12)  // Interp filter phase length
#define NUM_INTERP_PHASE_512_TONES     (4)      // Number of phases
#define INTERP_PHASE_LENGTH_1024_TONES (24)  // Interp filter length
#define NUM_INTERP_PHASE_1024_TONES    (2)      // Number of phases
#define INTERP_MAX_PHASE_LENGTH        (12)  // = 24 taps

#define DECIM_ORDER        (219)             // Decim filter order
#define DECIM_LENGTH    (DECIM_ORDER+1)         // Decim filter length
#define DECIM_DOWNSAMPLING_RATE  (16)           // Decim downsampling rate
#define LOG2_DECIM_DOWNSAMPLING_RATE   (4)            // Decim downsampling rate
#define DECIM_MAX_PHASE (DECIM_DOWNSAMPLING_RATE-1)   // Decim max phase value

// --------- Strymon Core I/O functions ----------------------
void A_Str_Init(void);

#endif //#ifndef _A_STR_INI_H
