/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2007 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;       Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;       Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;       File Name: IRI_IOf.h
;
;       Header file for Iridia CPE core interface layer.
;
*****************************************************************************/

#ifndef _IRI_IOF_H
#define _IRI_IOF_H

#include "vdsl_compiler.h"   // #ifdef ANXQ_35BLITE

// IRI_IOf.c
void LoadTxPRBSMsgBytes(void);
void LoadFDQ(void);
void ReadFDQ(void);
void StoreFdqMant(int16 *psa_FdqMant, int16 s_FirstTone, int16 s_NumTones);
void StoreFdqExp(uint8 *puca_FdqExp, int16 s_FirstTone, int16 s_NumTones);
void ReadFdqMant(int16 *psa_FdqMant, int16 s_FirstTone, int16 s_NumTones);
void ReadFdqExp(uint8 *puca_FdqExp, int16 s_FirstTone, int16 s_NumTones);
void Enable_HW_VectoringErbDump(void);
void Disable_HW_VectoringErbDump(void);
void SetRxToneOffset(void);
void ClearVectorPower(void);
void StopVectorPower(void);
void TriggerVectorPower(void);
void DeTriggerVectorPower(void);
void ReadVectorPower(void);
void GetRxTones(void);
void EnableRxDescrambling(void);
void DbgModifyRxDescrambling(uint16 us_BitsToSkip);
void SwitchTxPingPongTable(void);
void SwitchRxPingPongTable(void);
void CopyRxExtGainTable(void);
void CopyPilotTone(FlagT IsSyncSymbol);
void SetRxPilotToneIndex(void);
#ifdef HW_SNR_FDQ
void SetRxToneOffset_AsyncFDQ(void);
#endif

// IRI_IOf_FFT.c
void WhichIFFTBuffers(uint32 *pul_IFFTInputBuffer, uint32 *pul_IFFTOutputBuffer);
void WhichFFTBuffers(uint32 *pul_FFTInputBuffer, uint32 *pul_FFTOutputBuffer);
void LoadSingleToneToIfftBuf(void);
void LoadGhsTonesToIfftBuf(void);

void LoadT1413ToneToIfftBuf (void);

void LoadEngineFFTInput(void);
void GetEngineFFTResult(void);
void ReadFftBuffer(int16 *psa_time_domain_samples, int16 s_offset, int16 s_numSamples);
void LoadTxIFFTBuffer(int16 *psa_data, int16 s_ndata);


//#ifdef VDSL_62
void AccessIfftBuffer(int16 *psa_buf, int16 s_offset, int16 s_NumTones,
                                          FlagT gft_DigitRev, FlagT gft_ReadWrite, FlagT gft_WhichBuf);
void GetIfftBufAddr(uint32 *pul_addr, FlagT gft_WhichBuf);
void ReadIfftBufStatus(uint32 *pul_data);
void AccessFftBuffer(int16 *psa_buf, int16 s_offset, int16 s_NumTones,
                                          FlagT gft_DigitRev, FlagT gft_ReadWrite, FlagT gft_WhichBuf);
void GetFftBufAddr(uint32 *pul_addr, FlagT gft_WhichBuf);
void ReadFftBufStatus(uint32 *pul_data);
//#endif //#ifdef VDSL_62

void ModifyMedleyPrbsSkipBits(FlagT ft_tx_or_rx, uint16 us_BitsToSkip);
void ConfigRxNumTone(void);
void SwitchToTxMedleyPRBS(void);
void SwitchToRxMedleyPRBS(void);
void ConfigRTVBuf0_FFT_OUT(void);
void ConfigRTVBuf1_SFDQ_OUT(void);
void ConfigRTVBuf1_ERR_OUT(void);
void DisableDCI(void);
void IridiaControlCommon(void);
void ZeroTxOutbandTones(void);
void ResetNoisePowerBuffer(void);
void ReadAccumulatedNoise(void);
void ReadAccumulatedNoise2(void);
void CopyAccumulatedNoisefromRTV(void);
void LoadAccumulatedNoisetoRTV(void);
void DisableNPRWrite(void);

//#ifdef MTK_VECTORING_SUPPORT
void IridiaTxGainScaleDataPathControl(void);
//#endif //#ifdef MTK_VECTORING_SUPPORT



void DisablePrbsGen(void);

// LoadIridiaTransmitGains.c
void LoadIridiaTransmitGains(void);

//#ifdef VDSL_62
#define IFFT_DSP_REORD_ENA              (1)
#define IFFT_DSP_REORD_DIS              (0)
#define IFFT_BUF_READ   (0)
#define IFFT_BUF_WRITE  (1)
#define TX_QT_BUF               (0)
#define TX_FT_BUF               (1)
#define TX_FDF_BUF              (2)
#define TX_FDF_BUF_PRE  (3)

#define FFT_DSP_REORD_ENA               (1)
#define FFT_DSP_REORD_DIS               (0)
#define FFT_BUF_READ                    (0)
#define FFT_BUF_WRITE                   (1)
#define RX_QT_BUF                               (0)
#define RX_FT_BUF                               (1)
#define RX_FDF_BUF                              (2)
#define RX_FDF_BUF_PRE                  (3)
//#endif //VDSL_62

#define RTV_OFFSET_MASK          (0x00001FFF)
#define PRBS_TONE_OFFSET0_MASK   (0xFFFFE000)  //<12:0>  Physical tone offset for PRBS 0
#endif /*_IRI_IOF_H */
