/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2007 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;       Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;       Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;       File Name: V_STR_IIR_IOf.h
;
;       Header file for VDSL Strymon CO/CPE core IIR interface functions.
;
*****************************************************************************/
// ***********************************************************************************************************
// V_STR_IIR_IOf.h
//
// History
//
// 20/08/2018: Sriram Shastry : XDSLRTFW-232-Coding/decoding of US- and DS-tssi in O-PRM and R-PRM not correct
// 1. Performance optimization is done up to now only for US0 oPOTS configuration (US0-spectrum: tone 6-32)
// 2. If US oPOTS is used we force the out-of-band TSSI values for the CO TDQ training phase to: ...
//    Lower OOB tone Idx (0,4 are shaped with 6.0dB dB TxATTEN ) and  Upper OOB tone idx (36 =-0.0 dB &
//    tone idx 54 = -62.0 dB) TxATTEN is applied).
// 3. All other modes still use the old code
// 4. Added  new Tx IIR filter for  ISI optimization
// 5. Upstream performance optimization is  controlled by cmv. TEST 49 BITMASK- 9. Enabled by default
// Grep for XDSLRTFW-232
//
// ***********************************************************************************************************
#ifndef _V_STR_IIR_IOF_H
#define _V_STR_IIR_IOF_H

#include "vdsl_compiler.h"      // #ifdef ANXQ_35BLITE

void UnityTxIIR(void);
void LoadTxIIR(void);

void TxLoadIir(void *p_filter);
void RxLoadIir(void *p_filter);
void RestoreRxIIR(void);

extern uint32 gula_Strymon_TxIir_VDSL35b_unity[];
extern uint32 gula_RxIIR_ISDN_17M_Filter[];
extern uint32 gula_RxIIR_POTS_17M_Filter[];
extern uint32 gula_RxIIR_POTS_8M_Filter[];
extern uint32 gula_RxIIR_ISDN_8M_Filter[];
extern uint32 gula_Strymon_RxIir_Pots_Plus[];
extern uint32 gula_Strymon_RxIir_lp_17MHz_VDSL35[];

extern uint32 gula_TxIIR_POTS_17M_Filter[];
extern uint32 gula_TxIIR_ISDN_17M_Filter[];
extern uint32 gula_TxIIR_POTS_DOUBLE_17M_Filter[];
extern uint32 gula_TxIIR_LP_17MHz_VDSL35B[];
extern uint32 gula_TxIIR_isdn_17MHz_VDSL35B[];

extern uint32 gula_Strymon_TxIir_us0_only_A_poco_XdB_VDSL17_EchoOptimized[]; // XDSLRTFW-232(Start_End)
extern uint32 gula_Strymon_TxIir_us0_only_A_poco_XdB_VDSL17_ISIOptimized[];  // XDSLRTFW-232(Start_End)
extern uint32 gula_Strymon_TxIir_us0_only_B_poco_XdB_VDSL17[];
extern uint32 gula_Strymon_TxIir_us0_only_M_poco_XdB_VDSL17[];
extern uint32 gula_Strymon_TxIir_us0_only_EU128_poco_XdB_VDSL17[];
extern uint32 gula_Strymon_TxIir_us0_only_A_poco_XdB_VDSL35[];
extern uint32 gula_Strymon_TxIir_us0_only_B_poco_XdB_VDSL35[];
extern uint32 gula_Strymon_TxIir_us0_only_M_poco_XdB_VDSL35[];

#endif // _V_STR_IIR_IOF_H
