/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2006 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;       Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;       Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;       File Name: cri_iof.h
;
;       Header file for CRI core interface layer function.
;
*****************************************************************************/
// ***********************************************************************************************************
//  cri_iof.h
//
// History
//
// 01/02/2012 Kannan: Added function declration to clear the BC, Rx data status & Link status bits.
//                    Added another function declaration to poll S_44K owner bit.
//                    Grep for "XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown"
//
// ************************************************************************************************************

#ifndef _CRI_IOF_H
#define _CRI_IOF_H

/* Function prototypes */
void Reconfig_CRI(void);
void ModifyTxInterruptReg(int16 s_enable, uint32 ul_bitmask);
void ModifyRxInterruptReg(int16 s_enable, uint32 ul_bitmask);
void DisableAllInterrupt(void);
void EnableTSC(void);
void DisableTSC(void);
FlagT CheckQtStall(uint8 uc_TxRxIndicator);
void ClearTxStall(void);
void ClearRxStall(void);
void EnableTxPms(void);
void EnableRxPms(void);
void DisableTxPms(void);
void DisableRxPms(void);
void EnableTxQtp(void);
void EnableRxQtp(void);
void DisableTxQtp(void);
void DisableRxQtp(void);
void StartRxPmsRegStart(void);    //XDSLRTFW-2392 (Cascaded scheduling - Start - End)
void StartRxPmsRegStart(void);    //XDSLRTFW-2392 (Cascaded scheduling - Start - End)
void SetupL2StateInterruptProcessing(void);
void ReadTxTimer(uint32 *pl_timer);
void ReadRxTimer(uint32 *pl_timer);
void GetTxRxCounters(void);

void GetCriStatus0(void);
void GetRxCounter(void);

void SoftResetCores(void);
void SoftResetCores_FCI(void);
void ResetTxDSPInterrupt(void);
void ResetRxDSPInterrupt(void);
void StopTxDataPath(void);
void StopRxDataPath(void);
#ifdef PPE_ENGINE
void DFE_PPE_LinkStatus_TxRxLeaveShow(void);
void DFE_PPE_RxDataStatus_LeaveShow(void);
#endif //PPE_ENGINE

// XDSLRTFW-3565 (Start_End)
// XDSLRTFW-3711 (Start_End)
void Ppe_clockChange(uint16 us_TC_Mode, uint16 us_ProfileSelected);

//XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown (START)
void DFE_PPE_Shared_PPE_Reg_Init(void);
//XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown (END)

#ifdef DISTRIBUTE_TX_RX_PROCESS
void RegStartRxFFT(void);
void WriteCCR1RegAtBS(void);
void WriteCCR1RegAtQtDone(void);
#endif // DISTRIBUTE_TX_RX_PROCESS

#endif /*_CRI_IOF_H */
